/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.RadioBean;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.highdefense.domain.model.DefenseSwitchHistory;
import com.hs.atic.highdefense.domain.model.form.DefenseConfigForm;
import com.hs.atic.highdefense.domain.service.IDefenseConfigService;
import com.hs.atic.highdefense.domain.service.IHuaweiCloudIdentityService;
import com.hs.atic.highdefense.domain.service.impl.DefenseConfigServiceImpl;
import com.hs.atic.highdefense.domain.util.LocalDateTimeUtil;
import com.hs.atic.highdefense.util.RestInvoker;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.huawei.atic.device.license.service.ILicenseManagementService;
import com.huawei.atic.device.license.vo.LicenseInfo;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import com.restful.util.JSONUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DefenseConfigAction
extends BaseAction {
    private static final int LOG_RESULT_SUCCESS = 1;
    private static final int LOG_RESULT_FAILED = 0;
    private static final int FIVE = 5;
    private static final long serialVersionUID = -493694114818735787L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private List<DefenseConfigForm> defenseConfigFormList;
    private DefenseConfigForm defenseConfigForm;
    private List<AticDevice> deviceList;
    private Long zoneId;
    private List<Map<String, String>> regions;
    private List<Map<String, String>> lines;
    private List<RadioBean> switchToOnlineList;
    private List<RadioBean> switchToOfflineList;
    private List<RadioBean> switchToDNSRefreshList;
    private boolean exist;
    private boolean display;
    private String saveResultText;
    private Map<String, Map<Long, String>> saveResults;
    private long saveResult;
    private String ips;
    private String haveAuth;
    private String dnsRefreshGroupId;
    private int isAadUser;
    private int dnsRefreshStatus;
    private int state;
    private int dnsRefreshId;
    private int switchToOnline;
    private int switchToOffline;
    private int switchToDNSRefresh;
    private int switchBandwidth;
    @Autowired
    private IDefenseConfigService defenseConfigService;
    @Autowired
    private IAticDeviceService aticDeviceService;
    @Autowired
    @Qualifier(value="licenseManagementServiceImpl")
    private ILicenseManagementService licenseManagementService;
    @Autowired
    @Qualifier(value="zoneService")
    private IZoneService zoneService;
    @Autowired
    @Qualifier(value="huaweiCloudIdentityService")
    private IHuaweiCloudIdentityService huaweiCloudIdentityService;
    private String stateDisplay;
    private Integer defenseState;
    private String allQueryDisplay;
    private List<LangPair> defenseStateData;

    public String queryDefensePage() {
        this.logger.info((Object)"queryDefensePage start");
        this.loadSearchComb();
        this.defenseConfigFormList = new ArrayList<DefenseConfigForm>();
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        User user = (User)this.getSession().getAttribute("currentUser");
        conditionMap.put("userId", String.valueOf(user.getUserID()));
        conditionMap.put("isAdmin", user.getIsAdmin());
        if (null != this.defenseConfigForm) {
            if (null != this.defenseConfigForm.getZoneIp()) {
                conditionMap.put("zoneIp", this.defenseConfigForm.getZoneIp());
            }
            if (null != this.defenseConfigForm.getGroupName()) {
                conditionMap.put("groupName", this.defenseConfigForm.getGroupName());
            }
            if (null != this.defenseState) {
                conditionMap.put("state", String.valueOf(this.defenseState));
            }
            if (null != this.defenseConfigForm.getCompanyName()) {
                conditionMap.put("companyName", this.defenseConfigForm.getCompanyName());
            }
        }
        Paging page = this.defenseConfigService.queryByPage(conditionMap, this.start, this.pageSize);
        this.defenseConfigFormList = page.getData();
        this.total = page.getCount();
        this.logger.info((Object)("queryDefensePage success," + this.defenseConfigFormList.size()));
        this.display = this.defenseConfigService.isDefenseIndependentAccount();
        return "success";
    }

    private void loadSearchComb() {
        this.allQueryDisplay = this.getText("atic.public.query.all");
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        LangPair all = new LangPair("", this.getText("atic.bis.online.offline.Defense.state.all"));
        combData.add(all);
        LangPair statesZero = new LangPair("0", this.getText("atic.bis.online.offline.Defense.normal"));
        LangPair statesOne = new LangPair("1", this.getText("atic.bis.online.offline.Defense.black"));
        LangPair statesTwo = new LangPair("2", this.getText("atic.bis.online.offline.Defense.attack"));
        LangPair statesThree = new LangPair("3", this.getText("atic.bis.online.offline.Defense.switching"));
        LangPair statesFour = new LangPair("4", this.getText("atic.bis.online.offline.Defense.offline"));
        combData.add(statesZero);
        combData.add(statesOne);
        combData.add(statesTwo);
        combData.add(statesThree);
        combData.add(statesFour);
        this.defenseStateData = combData;
    }

    public void switchToOnline() {
        this.logger.info((Object)"switchToOnline action start");
        if (null == this.ips || "".equals(this.ips)) {
            this.logger.error((Object)("switchToOnline zone ip:" + this.ips));
            this.responseResult("failure");
            return;
        }
        boolean isSuccess = true;
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        User user = (User)this.getSession().getAttribute("currentUser");
        conditionMap.put("userId", String.valueOf(user.getUserID()));
        conditionMap.put("isAdmin", user.getIsAdmin());
        conditionMap.put("ips", this.ips);
        List<DefenseConfigForm> defenseConfigForms = this.defenseConfigService.queryDefenseConfigsByIp(conditionMap);
        HashMap<Long, Map<String, String>> checkResult = new HashMap<Long, Map<String, String>>();
        String operation = "atic.bis.online.offline.Defense.switch.online";
        String module = "lego.fault.severity.rule.diversion.cloud";
        String target = "atic.bis.online.offline.Defense.config.title";
        String detail = "";
        String[] detailPara = null;
        boolean isSwitch = false;
        DefenseSwitchHistory switchHistory = new DefenseSwitchHistory();
        for (DefenseConfigForm configForm : defenseConfigForms) {
            long deviceId = configForm.getDeviceId();
            if (null != checkResult.get(deviceId)) continue;
            if (this.defenseConfigService.isDefenseIndependentAccount()) {
                isSwitch = true;
            } else if (this.licenseManagementService.checkLicense(deviceId)) {
                if (this.defenseConfigService.concurOnlineDefenseCheck(deviceId)) {
                    if (this.licenseManagementService.licenseSwitchCountBackfill(deviceId) > 0) {
                        isSwitch = true;
                    } else {
                        isSwitch = false;
                        switchHistory.setDetail("defense.err.50006");
                    }
                } else {
                    isSwitch = false;
                    switchHistory.setDetail("defense.err.50005");
                }
            } else {
                isSwitch = false;
                switchHistory.setDetail("defense.err.50004");
            }
            if (isSwitch) {
                Map<String, String> result = this.defenseConfigService.switchToOnline(configForm);
                checkResult.put(deviceId, result);
                if (null == result) {
                    this.licenseManagementService.refreshSwitchCount(configForm.getDeviceId());
                    detailPara = new String[]{configForm.getZoneIp()};
                    detail = "atic.bis.online.offline.Defense.log.online.details.success";
                    this.batchRsult4Options(true, module, target, detail, operation, detailPara);
                    continue;
                }
                isSuccess = false;
                detail = "atic.bis.online.offline.Defense.log.online.details.fail";
                detailPara = new String[]{configForm.getZoneIp(), result.get(configForm.getZoneIp())};
                this.batchRsult4Options(false, module, target, detail, operation, detailPara);
                continue;
            }
            switchHistory.setState(1);
            switchHistory.setSwitchType(0);
            switchHistory.setSwitchDirection(1);
            switchHistory.setSwitchDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
            switchHistory.setOperator(user.getUserName().trim());
            switchHistory.setDeviceName(configForm.getDeviceName());
            switchHistory.setSwitchIp(configForm.getZoneIp());
            switchHistory.setBackIp(configForm.getBackIp());
            if (this.defenseConfigService.isDefenseIndependentAccount()) {
                switchHistory.setLicenseNumber("00");
            } else {
                switchHistory.setLicenseNumber(configForm.getLicenseNumber());
            }
            this.logger.info((Object)("switchToOnline switchHistory : " + switchHistory.toString()));
            this.defenseConfigService.saveSwitchHistory(switchHistory);
            isSuccess = false;
            detail = "atic.bis.online.offline.Defense.log.online.details.fail";
            detailPara = new String[]{configForm.getZoneIp(), switchHistory.getDetail()};
            this.batchRsult4Options(false, module, target, detail, operation, detailPara);
        }
        if (isSuccess) {
            this.responseResult("success");
        } else {
            this.responseResult("failure");
        }
    }

    public void switchToOffline() {
        this.logger.info((Object)"switchToOffline action start");
        if (null == this.ips || "".equals(this.ips)) {
            this.logger.error((Object)("switchToOffline zone ip:" + this.ips));
            this.responseResult("failure");
            return;
        }
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        User user = (User)this.getSession().getAttribute("currentUser");
        conditionMap.put("userId", String.valueOf(user.getUserID()));
        conditionMap.put("isAdmin", user.getIsAdmin());
        conditionMap.put("ips", this.ips);
        List<DefenseConfigForm> defenseConfigForms = this.defenseConfigService.queryDefenseConfigsByIp(conditionMap);
        Boolean result = this.defenseConfigService.switchToOffline(defenseConfigForms, 0);
        if (result.booleanValue()) {
            this.responseResult("success");
        } else {
            this.responseResult("failure");
        }
    }

    private void batchRsult4Options(boolean isSuccess, String module, String target, String detail, String operation, String[] detailPara) {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setOperation(operation);
        syncSysLog.setModule(module);
        syncSysLog.setOperator(currentUser.getUserName().trim());
        syncSysLog.setTerminalIp(currentUser.getIpAdr());
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        syncSysLog.setTargetLocal(Boolean.valueOf(true));
        if (isSuccess) {
            syncSysLog.setResult(1);
            syncSysLog.setLevel(SysoplogLevel.info.getValue());
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        } else {
            syncSysLog.setResult(0);
            syncSysLog.setLevel(SysoplogLevel.normal.getValue());
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        }
    }

    public String preAddDefenseConfig() {
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User user = (User)this.getSession().getAttribute("currentUser");
        this.deviceList = this.aticDeviceService.getAllDeviceWithLicense(user.getUserID());
        this.allOptions();
        this.display = this.defenseConfigService.isDefenseIndependentAccount();
        request.setAttribute("display", (Object)this.display);
        if ("admin".equals(user.getUserName())) {
            request.setAttribute("isAdmin", (Object)true);
        } else {
            request.setAttribute("isAdmin", (Object)false);
        }
        this.switchToOnline = 0;
        this.switchToOffline = 0;
        this.switchToDNSRefresh = 0;
        this.switchBandwidth = 1000;
        return "success";
    }

    private void allOptions() {
        if (null == this.regions) {
            this.regions = new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.getText("atic.bis.online.offline.Defense.config.region.northchina"));
        map.put("id", "northchina");
        this.regions.add(map);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", this.getText("atic.bis.online.offline.Defense.config.region.eastchina"));
        map1.put("id", "eastchina");
        this.regions.add(map1);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", this.getText("atic.bis.online.offline.Defense.config.region.southchina"));
        map2.put("id", "southchina");
        this.regions.add(map2);
        if (null == this.lines) {
            this.lines = new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> lineModeMap = new HashMap<String, String>();
        lineModeMap.put("name", this.getText("atic.bis.online.offline.Defense.config.line.unicom"));
        lineModeMap.put("id", "china_unicom");
        this.lines.add(lineModeMap);
        HashMap<String, String> lineModeMap1 = new HashMap<String, String>();
        lineModeMap1.put("name", this.getText("atic.bis.online.offline.Defense.config.line.mobile"));
        lineModeMap1.put("id", "china_mobile");
        this.lines.add(lineModeMap1);
        HashMap<String, String> lineModeMap2 = new HashMap<String, String>();
        lineModeMap2.put("name", this.getText("atic.bis.online.offline.Defense.config.line.telecom"));
        lineModeMap2.put("id", "china_telecom");
        this.lines.add(lineModeMap2);
        HashMap<String, String> lineModeMap3 = new HashMap<String, String>();
        lineModeMap3.put("name", this.getText("atic.bis.online.offline.Defense.config.line.BGP"));
        lineModeMap3.put("id", "BGP");
        this.lines.add(lineModeMap3);
        this.switchToOnlineList = new ArrayList<RadioBean>();
        RadioBean bean1 = new RadioBean();
        bean1.setKey(Integer.valueOf(0));
        bean1.setLabel(this.getText("atic.bis.online.offline.Defense.config.switch.mode.manual"));
        this.switchToOnlineList.add(bean1);
        RadioBean bean2 = new RadioBean();
        bean2.setKey(Integer.valueOf(1));
        bean2.setLabel(this.getText("atic.bis.online.offline.Defense.config.switch.mode.automatic"));
        this.switchToOnlineList.add(bean2);
        this.switchToOfflineList = new ArrayList<RadioBean>();
        RadioBean bean3 = new RadioBean();
        bean3.setKey(Integer.valueOf(0));
        bean3.setLabel(this.getText("atic.bis.online.offline.Defense.config.switch.mode.manual"));
        this.switchToOfflineList.add(bean3);
        if (!this.defenseConfigService.isDefenseIndependentAccount()) {
            RadioBean bean4 = new RadioBean();
            bean4.setKey(Integer.valueOf(1));
            bean4.setLabel(this.getText("atic.bis.online.offline.Defense.config.switch.mode.automatic"));
            this.switchToOfflineList.add(bean4);
        }
        this.switchToDNSRefreshList = new ArrayList<RadioBean>();
        RadioBean bean5 = new RadioBean();
        bean5.setKey(Integer.valueOf(0));
        bean5.setLabel(this.getText("atic.bis.online.offline.Defense.config.switch.mode.manual"));
        this.switchToDNSRefreshList.add(bean1);
        RadioBean bean6 = new RadioBean();
        bean6.setKey(Integer.valueOf(1));
        bean6.setLabel(this.getText("atic.bis.online.offline.Defense.config.switch.mode.automatic"));
        this.switchToDNSRefreshList.add(bean2);
    }

    public String ajaxDeviceLicense() {
        if (null == this.defenseConfigForm) {
            this.defenseConfigForm = new DefenseConfigForm();
        }
        if (0L == this.defenseConfigForm.getDeviceId()) {
            return "success";
        }
        if (this.defenseConfigService.isDefenseIndependentAccount()) {
            this.logger.info((Object)"isDefenseIndependentAccount in ajaxDeviceLicense()");
            return "success";
        }
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.defenseConfigForm.getDeviceId());
        BisUtil.checkUserSecurity(moIdList);
        LicenseInfo licenseInfo = this.licenseManagementService.getLicenseByDeviceId(this.defenseConfigForm.getDeviceId());
        if (null == licenseInfo) {
            return "success";
        }
        String expirationDateString = licenseInfo.getExpirationDate();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate expirationDate = LocalDate.parse(expirationDateString, df);
        this.defenseConfigForm.setExpirationDate(expirationDate);
        this.defenseConfigForm.setExpirationDateString(expirationDateString);
        return "success";
    }

    public String addDefenseConfig() {
        this.logger.info((Object)"addDefenseConfig");
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.defenseConfigForm.getDeviceId());
        BisUtil.checkUserSecurity(moIdList);
        String deviceName = "-";
        AticDevice device = this.aticDeviceService.getDeviceByMoid(this.defenseConfigForm.getDeviceId());
        if (null != device && !AticUtil.isNull((String)device.getName())) {
            deviceName = device.getName();
        }
        try {
            this.defenseConfigService.saveDefenseConfig(this.defenseConfigForm);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("addDefenseConfig error!" + e.getMessage()));
            String detail = "";
            if (7100L == e.getErrorCode()) {
                long errorCode = this.defenseConfigService.interceptErrorCode(e.getMessage());
                detail = this.queryDetailByErrcode("defense.err.", errorCode);
            } else {
                detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
            }
            this.saveResult = e.getErrorCode();
            this.saveResultText = this.getText(detail);
            this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.config.add.log.error", "atic.bis.online.offline.Defense.config.add", new String[]{this.defenseConfigForm.getZoneIp(), this.defenseConfigForm.getDomainName(), deviceName, detail});
            return "success";
        }
        catch (Exception e) {
            this.logger.error((Object)("addDefenseConfig falied Exception: " + e.getMessage()));
            this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.config.add.log.error", "atic.bis.online.offline.Defense.config.add", new String[]{this.defenseConfigForm.getZoneIp(), this.defenseConfigForm.getDomainName(), deviceName, "defense.err.50001"});
        }
        this.saveResultText = this.getText("atic.bis.online.offline.Defense.Constants.1000");
        this.saveResult = 1000L;
        this.getOperateLog().info("atic.bis.online.offline.Defense.config.add", "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", true, "atic.bis.online.offline.Defense.config.add.log.success", new String[]{this.defenseConfigForm.getZoneIp(), this.defenseConfigForm.getDomainName(), deviceName + ""});
        return "success";
    }

    public String preEditDefenseConfig() {
        User user = (User)this.getSession().getAttribute("currentUser");
        this.deviceList = this.aticDeviceService.getAllDeviceWithLicense(user.getUserID());
        this.allOptions();
        this.defenseConfigForm = this.defenseConfigService.queryDefenseConfig(this.defenseConfigForm);
        try {
            ArrayList<Long> zoneIds = new ArrayList<Long>();
            long zoneId = this.defenseConfigForm.getZoneId();
            zoneIds.add(zoneId);
            this.checkDevicePermissionByUserName(user.getUserName(), zoneIds);
            ArrayList<Long> deviceIds = new ArrayList<Long>();
            long deviceId = this.defenseConfigForm.getDeviceId();
            deviceIds.add(deviceId);
            BisUtil.checkUserSecurity(deviceIds);
        }
        catch (LegoCheckedException e) {
            if (630114L == e.getErrorCode()) {
                this.logger.error((Object)("Exceeding authority here, defenseConfigForm.id:[" + this.defenseConfigForm.getId() + "]."));
                throw e;
            }
            this.logger.error((Object)"Check user permission occur error.");
            throw e;
        }
        for (Map<String, String> each : this.regions) {
            if (!each.get("id").equals(this.defenseConfigForm.getDeviceArea())) continue;
            this.defenseConfigForm.setDeviceAreaName(each.get("name"));
        }
        for (Map<String, String> each : this.lines) {
            if (!each.get("id").equals(this.defenseConfigForm.getDeviceLine())) continue;
            this.defenseConfigForm.setDeviceLineName(each.get("name"));
        }
        this.display = this.defenseConfigService.isDefenseIndependentAccount();
        return "success";
    }

    private void checkDevicePermissionByUserName(String userName, List<Long> zoneIdList) {
        IZoneDeviceService zoneDeviceService = ZoneBisUtil.getIZoneDeviceService();
        HashSet<Long> associatedDeviceIds = new HashSet<Long>();
        for (Long zoneId : zoneIdList) {
            List zoneDeviceForms = zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneId);
            for (ZoneDeviceForm zoneDevice : zoneDeviceForms) {
                associatedDeviceIds.add(zoneDevice.getDeviceId());
            }
        }
        BisUtil.checkUserSecurity(new ArrayList(associatedDeviceIds));
    }

    private void checkUltraVires() {
        List<DefenseConfigForm> checkDefenseConfigFormList = this.defenseConfigService.queryDefenseConfigsByZoneIp(this.ips);
        ArrayList<Long> checkDeviceList = new ArrayList<Long>();
        for (DefenseConfigForm checkDefenseConfigForm : checkDefenseConfigFormList) {
            checkDeviceList.add(checkDefenseConfigForm.getDeviceId());
        }
        BisUtil.checkUserSecurity(checkDeviceList);
    }

    public void deleteDefenseIp() {
        String[] ipList;
        this.logger.info((Object)("delete defense data zone ip:" + this.ips));
        if (null == this.ips || "".equals(this.ips)) {
            this.logger.error((Object)("delete defense data zone ip:" + this.ips));
            this.responseResult("failure");
            return;
        }
        this.checkUltraVires();
        List<DefenseConfigForm> deleteDefenseConfigFormList = this.defenseConfigService.queryDefenseConfigsByZoneIp(this.ips);
        Map<String, Map<String, String>> allResults = this.defenseConfigService.deleteDefenseByDefenseConfig(deleteDefenseConfigFormList);
        StringBuilder ipsFail = new StringBuilder("");
        StringBuilder ipsSuccess = new StringBuilder("");
        String[] detailPara = null;
        String operation = "atic.bis.online.offline.Defense.delete";
        String module = "lego.fault.severity.rule.diversion.cloud";
        String target = "atic.bis.online.offline.Defense.config.title";
        String detail = "atic.bis.online.offline.Defense.log.delete.details.fail";
        for (String zoneIp : ipList = this.ips.split(",")) {
            if (allResults.get("successIps").containsKey(zoneIp)) {
                ipsSuccess.append(zoneIp).append(",");
                continue;
            }
            ipsFail.append(zoneIp).append(",");
        }
        Map<String, String> zoneIpDelErrorResult = allResults.get("zoneIpDelErrorResult");
        Map<String, String> groupsDelErrorResult = allResults.get("groupsDelErrorResult");
        int fail = ipList.length - allResults.get("successIps").size();
        boolean isSuccess = true;
        String detailSuccessPara = "--";
        String[] detailFailPara = null;
        if (fail == 0 && ipsSuccess.length() > 0) {
            detail = "atic.bis.online.offline.Defense.log.delete.details.success";
            detailSuccessPara = ipsSuccess.toString().substring(0, ipsSuccess.toString().length() - 1);
            detailPara = new String[]{detailSuccessPara};
            this.batchRsult4Options(isSuccess, module, target, detail, operation, detailPara);
        } else {
            isSuccess = false;
            if (ipsSuccess.length() > 0) {
                detailSuccessPara = ipsSuccess.toString().substring(0, ipsSuccess.toString().length() - 1);
                detail = "atic.bis.online.offline.Defense.log.delete.details.success";
                detailPara = new String[]{detailSuccessPara};
                this.batchRsult4Options(true, module, target, detail, operation, detailPara);
            }
            if (groupsDelErrorResult.size() > 0) {
                detail = "atic.bis.online.offline.Defense.log.delete.details.fail";
                for (Map.Entry<String, String> entry : groupsDelErrorResult.entrySet()) {
                    detailFailPara = new String[]{entry.getKey(), entry.getValue()};
                    this.batchRsult4Options(isSuccess, module, target, detail, operation, detailFailPara);
                    this.logger.info((Object)("delete fail defense group data zone ip:" + detailFailPara[0] + ";" + detailFailPara[1]));
                }
            }
            if (zoneIpDelErrorResult.size() > 0) {
                detail = "atic.bis.online.offline.Defense.log.delete.details.fail";
                for (Map.Entry<String, String> entry : zoneIpDelErrorResult.entrySet()) {
                    detailFailPara = new String[]{entry.getKey(), entry.getValue()};
                    this.batchRsult4Options(isSuccess, module, target, detail, operation, detailFailPara);
                    this.logger.info((Object)("delete fail defense data zone ip:" + detailFailPara[0] + ";" + detailFailPara[1]));
                }
            }
        }
        this.logger.info((Object)("delete success defense data zone ip:" + detailSuccessPara));
        if (isSuccess) {
            this.responseResult("success");
        } else {
            this.responseResult("failure");
        }
    }

    public String editDefenseConfig() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.defenseConfigForm.getDeviceId());
        BisUtil.checkUserSecurity(moIdList);
        String deviceName = "-";
        AticDevice device = this.aticDeviceService.getDeviceByMoid(this.defenseConfigForm.getDeviceId());
        if (null != device && !AticUtil.isNull((String)device.getName())) {
            deviceName = device.getName();
        }
        try {
            this.defenseConfigService.updateDefenseConfig(this.defenseConfigForm);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("editDefenseConfig error!" + e.getMessage()));
            String detail = "";
            if (7100L == e.getErrorCode()) {
                long errorCode = this.defenseConfigService.interceptErrorCode(e.getMessage());
                detail = this.queryDetailByErrcode("defense.err.", errorCode);
            } else {
                detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
            }
            this.saveResult = e.getErrorCode();
            this.saveResultText = this.getText(detail);
            this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.config.edit.log.error", "atic.bis.online.offline.Defense.config.edit", new String[]{this.defenseConfigForm.getZoneIp(), this.defenseConfigForm.getDomainName(), deviceName, detail});
            return "success";
        }
        catch (Exception e) {
            this.logger.error((Object)("addDefenseConfig falied Exception: " + e.getMessage()));
            this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.config.edit.log.error", "atic.bis.online.offline.Defense.config.edit", new String[]{this.defenseConfigForm.getZoneIp(), this.defenseConfigForm.getDomainName(), deviceName, "defense.err.50001"});
        }
        this.saveResultText = this.getText("atic.bis.online.offline.Defense.Constants.1000");
        this.saveResult = 1000L;
        this.getOperateLog().info("atic.bis.online.offline.Defense.config.edit", "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", true, "atic.bis.online.offline.Defense.config.edit.log.success", new String[]{this.defenseConfigForm.getZoneIp(), this.defenseConfigForm.getDomainName(), deviceName});
        return "success";
    }

    public String recoveryDefenseConfig() {
        String[] arr;
        this.saveResults = new HashMap<String, Map<Long, String>>();
        DefenseConfigForm defenseConfig = null;
        HashMap<Long, String> each = null;
        HashSet<String> failedZoneIp = new HashSet<String>();
        HashSet<String> successZoneIp = new HashSet<String>();
        if (null == this.defenseConfigForm || null == this.defenseConfigForm.getIds()) {
            return "success";
        }
        for (String id : arr = this.defenseConfigForm.getIds().split(",")) {
            try {
                each = new HashMap<Long, String>();
                defenseConfig = new DefenseConfigForm();
                defenseConfig.setId(Integer.parseInt(id));
                this.defenseConfigForm = this.defenseConfigService.queryDefenseConfig(defenseConfig);
                ArrayList<Long> zoneIds = new ArrayList<Long>();
                long zoneId = this.defenseConfigForm.getZoneId();
                zoneIds.add(zoneId);
                User user = (User)this.getSession().getAttribute("currentUser");
                this.checkDevicePermissionByUserName(user.getUserName(), zoneIds);
                ArrayList<Long> deviceIds = new ArrayList<Long>();
                long deviceId = this.defenseConfigForm.getDeviceId();
                deviceIds.add(deviceId);
                BisUtil.checkUserSecurity(deviceIds);
                this.defenseConfigService.recoveryDefenseConfig(this.defenseConfigForm);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("[ZoneIp] : " + this.defenseConfigForm.getZoneIp() + "recoveryDefenseConfig error!" + e.getMessage()));
                String detail = "";
                if (7100L == e.getErrorCode()) {
                    long errorCode = this.defenseConfigService.interceptErrorCode(e.getMessage());
                    detail = this.queryDetailByErrcode("defense.err.", errorCode);
                } else {
                    if (630114L == e.getErrorCode()) {
                        this.logger.error((Object)("Exceeding authority here, defenseConfigForm.ids:[" + this.defenseConfigForm.getIds() + "]."));
                        throw e;
                    }
                    detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
                }
                each.put(e.getErrorCode(), this.getText(detail));
                this.saveResults.put(this.defenseConfigForm.getZoneIp(), each);
                failedZoneIp.add(this.defenseConfigForm.getZoneIp() + " : " + this.getText(detail));
                continue;
            }
            successZoneIp.add(this.defenseConfigForm.getZoneIp());
            each.put(1100L, this.getText("atic.bis.online.offline.Defense.Constants.1100"));
            this.saveResults.put(this.defenseConfigForm.getZoneIp(), each);
        }
        boolean isSuccess = failedZoneIp.size() == 0;
        this.batchRsult4Options(isSuccess, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.config.recovery.log.success", "atic.bis.online.offline.Defense.config.recovery", new String[]{((Object)successZoneIp).toString(), ((Object)failedZoneIp).toString()});
        return "success";
    }

    public String ajaxDomainDevice() {
        if (null == this.defenseConfigForm) {
            return "success";
        }
        if (null == this.defenseConfigForm.getDomainName()) {
            return "success";
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        this.defenseConfigForm.setCurUserId(user.getUserID());
        Map<Long, List<AticDevice>> zone2DeviceList = this.defenseConfigService.queryDeviceByDomain(this.defenseConfigForm);
        Map.Entry<Long, List<AticDevice>> entry = zone2DeviceList.entrySet().iterator().next();
        this.deviceList = entry.getValue();
        this.zoneId = entry.getKey();
        if (null == this.deviceList) {
            this.deviceList = this.aticDeviceService.getAllDeviceWithLicense(user.getUserID());
        }
        return "success";
    }

    public String ajaxExistIp() {
        if (null == this.defenseConfigForm) {
            return "success";
        }
        if (null == this.defenseConfigForm.getZoneIp()) {
            return "success";
        }
        this.exist = this.defenseConfigService.queryIpExist(this.defenseConfigForm);
        return "success";
    }

    public String ajaxExistBackupIp() {
        if (null == this.defenseConfigForm) {
            return "success";
        }
        if (null == this.defenseConfigForm.getBackIp()) {
            return "success";
        }
        this.exist = this.defenseConfigService.queryBackupIpExist(this.defenseConfigForm);
        return "success";
    }

    public String ajaxIpCountWithDevice() {
        if (null == this.defenseConfigForm) {
            return "success";
        }
        if (0L == this.defenseConfigForm.getDeviceId()) {
            return "success";
        }
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.defenseConfigForm.getDeviceId());
        BisUtil.checkUserSecurity(moIdList);
        this.exist = this.defenseConfigService.queryIpCountWithDevice(this.defenseConfigForm);
        return "success";
    }

    public String ajaxIpCountWithDefenseIndependAccount() {
        if (null == this.defenseConfigForm) {
            return "success";
        }
        this.exist = this.defenseConfigService.queryIpCountWithDefenseIndependAccount();
        return "success";
    }

    public boolean validateDeviceId(String deviceId) {
        if (!Pattern.compile("^[0-9]\\d*$").matcher(deviceId).matches()) {
            return false;
        }
        long vDeviceId = Long.parseLong(deviceId);
        if (vDeviceId == 0L) {
            return true;
        }
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(vDeviceId);
        if (null == aticDevice || aticDevice.getMoId() <= 0L) {
            return false;
        }
        User user = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        List devicesPrivieges = this.aticDeviceService.getAntiDDoSDevice(user.getUserID());
        for (AticDevice eachDevice : devicesPrivieges) {
            if (null == eachDevice || eachDevice.getMoId() == 0L || eachDevice.getMoId() != aticDevice.getMoId()) continue;
            return true;
        }
        return false;
    }

    public boolean validateZoneId(String zoneIdx) {
        if (!Pattern.compile("^[0-9]\\d*$").matcher(zoneIdx).matches()) {
            return false;
        }
        long zoneid = Long.parseLong(zoneIdx);
        if (0L == zoneid) {
            return true;
        }
        ZoneInfoForm zoneInfoForm = this.zoneService.getById(zoneid);
        return null != zoneInfoForm && zoneInfoForm.getZoneId() > 0L;
    }

    public boolean validateDefenseConfigId(String id) {
        try {
            Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean validateState(String stateId) {
        try {
            Integer.parseInt(stateId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean validateGroupId(String groupId) {
        try {
            if (groupId.length() > 255) {
                return false;
            }
            DefenseConfigForm defenseConfig = this.defenseConfigService.getDefenseConfigStateByGroupId(groupId);
            if (defenseConfig == null) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean validateExpirationDateString(String expirationDateString) {
        if (this.defenseConfigService.isDefenseIndependentAccount()) {
            return true;
        }
        try {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate.parse(expirationDateString, df);
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateIds(String ids) {
        if (null == ids || ids.length() == 0) {
            return true;
        }
        String[] arr = ids.split(",");
        if (arr.length > 100) {
            return false;
        }
        for (String id : arr) {
            Pattern pattern = Pattern.compile("^[1-9]\\d*$");
            Matcher matcher = pattern.matcher(id + "");
            if (matcher.matches()) continue;
            return false;
        }
        return true;
    }

    public boolean validateIp(String ip) {
        if (null == ip || "".equals(ip)) {
            return true;
        }
        return IPUtil.isIpv4((String)ip.trim());
    }

    public boolean validateDomainName(String domainName) {
        if (null == domainName || "".equals(domainName)) {
            return true;
        }
        Pattern pattern4 = Pattern.compile("^(?=^.{3,255}$)[*a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$");
        Matcher matcher4 = pattern4.matcher(domainName);
        return matcher4.matches();
    }

    public boolean validatePort(String port) {
        if (null == port || "".equals(port)) {
            return true;
        }
        String[] tcps = port.split(",");
        HashSet<String> set = new HashSet<String>();
        for (String each : tcps) {
            String regex = "^([1-9][0-9]*)$";
            if (!each.matches(regex)) {
                return false;
            }
            if (Integer.parseInt(each) < 1 || Integer.parseInt(each) > 65535) {
                return false;
            }
            set.add(each);
        }
        return set.size() == tcps.length;
    }

    public boolean validateips() {
        if (null == this.ips || "".equals(this.ips)) {
            return true;
        }
        String[] ipsSts = this.ips.split(",");
        if (ipsSts.length > 100) {
            return false;
        }
        for (int i = 0; i < ipsSts.length; ++i) {
            if (IPUtil.isIpv4((String)ipsSts[i]) || IPUtil.isIpv6((String)ipsSts[i])) continue;
            return false;
        }
        return true;
    }

    public String judgeAuth() {
        this.logger.info((Object)"judgeAuth start");
        int size = this.huaweiCloudIdentityService.queryIdentity();
        if (size > 0) {
            this.haveAuth = "success";
        } else {
            this.logger.info((Object)"need identity auth");
            this.haveAuth = "none";
        }
        this.logger.info((Object)("judgeAuth over," + size));
        return "success";
    }

    private void dnsRefreshSystemOptionLog() {
        if (this.state == 6 || this.state == 8 || this.state == 10 || this.state == 12) {
            this.batchRsult4Options(true, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.dnsrefresh.task.log.success", "atic.bis.online.offline.Defense.dnsrefresh", new String[]{this.ips});
        } else if (this.state == 7 || this.state == 11) {
            this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.dnsrefresh.task.log.error", "atic.bis.online.offline.Defense.dnsrefresh", new String[]{this.ips, "atic.bis.online.offline.Defense.dns.mannul.refresh.result.failed"});
        } else if (this.state != 5 && this.state != 9) {
            this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.dnsrefresh.task.log.error", "atic.bis.online.offline.Defense.dnsrefresh", new String[]{this.ips, "atic.bis.online.offline.Defense.Constants.7100"});
        }
    }

    public String dnsRefresh() {
        this.logger.info((Object)"dnsRefresh start");
        this.checkUltraVires();
        if (!this.defenseConfigService.isDefenseIndependentAccount()) {
            this.isAadUser = 0;
            this.logger.info((Object)"getUserIdentites failed");
            return "success";
        }
        this.isAadUser = 1;
        this.dnsRefreshStatus = -1;
        this.saveResultText = "";
        this.logger.info((Object)("dns refresh id: " + this.dnsRefreshId + ",groupId:" + this.dnsRefreshGroupId + ", and state:" + this.state));
        if (this.state == 5) {
            this.logger.info((Object)"state is 5 (Advanced Anti-DDoS Normal): task is already submit, wait for query the result.");
            this.state = this.defenseConfigService.getDnsManualRefreshResultByGroupId(this.dnsRefreshId, this.dnsRefreshGroupId, this.state);
            this.dnsRefreshStatus = 2;
            this.dnsRefreshSystemOptionLog();
            return "success";
        }
        if (this.state == 9) {
            this.logger.info((Object)"state is 9 (defense offline): task is already submit, wait for query the result.");
            this.state = this.defenseConfigService.getDnsManualRefreshResultByGroupId(this.dnsRefreshId, this.dnsRefreshGroupId, this.state);
            this.dnsRefreshStatus = 2;
            this.dnsRefreshSystemOptionLog();
            return "success";
        }
        try {
            String result = RestInvoker.post("/v1/{domain_id}/dpp/groups/" + this.dnsRefreshGroupId + "/flush-name", "{}", 1);
            this.logger.info((Object)("DnsRefresh task result: " + result));
            DefenseConfigServiceImpl.MyTypeReference resultJson = new DefenseConfigServiceImpl.MyTypeReference();
            Map resultMap = (Map)JSONUtil.getInstance().fromJSON(result, resultJson);
            if (null != resultMap.get("status")) {
                int status = Integer.parseInt(String.valueOf(resultMap.get("status")));
                this.logger.info((Object)("dns mannul refresh status: " + status));
                if (status == 0) {
                    this.dnsRefreshStatus = 0;
                    if (this.state == 0 || this.state == 6 || this.state == 7 || this.state == 8) {
                        this.defenseConfigService.updateDefenseConfigStateByGroupId(this.dnsRefreshGroupId, 5);
                        this.state = 5;
                        this.state = this.defenseConfigService.getDnsManualRefreshResultByGroupId(this.dnsRefreshId, this.dnsRefreshGroupId, this.state);
                    } else if (this.state == 4 || this.state == 10 || this.state == 11 || this.state == 12) {
                        this.defenseConfigService.updateDefenseConfigStateByGroupId(this.dnsRefreshGroupId, 9);
                        this.state = 9;
                        this.state = this.defenseConfigService.getDnsManualRefreshResultByGroupId(this.dnsRefreshId, this.dnsRefreshGroupId, this.state);
                    }
                    this.dnsRefreshSystemOptionLog();
                    return "success";
                }
                if (status == 1) {
                    this.logger.error((Object)"dns refresh task failed.");
                    this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.dnsrefresh.task.log.error", "atic.bis.online.offline.Defense.dnsrefresh", new String[]{this.ips, "atic.bis.online.offline.Defense.Constants.7100"});
                    this.dnsRefreshStatus = 1;
                }
            } else {
                this.logger.error((Object)"dns mannul refresh cannot get response status!");
                this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.dnsrefresh.task.log.error", "atic.bis.online.offline.Defense.dnsrefresh", new String[]{this.ips, "atic.bis.online.offline.Defense.Constants.7100"});
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("LegoCheckedException:" + e.getMessage()));
            this.logger.error((Object)"dns refresh error!");
            String detail = "";
            if (7100L == e.getErrorCode()) {
                long errorCode = this.defenseConfigService.interceptErrorCode(e.getMessage());
                detail = this.queryDetailByErrcode("defense.err.", errorCode);
            } else {
                detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
            }
            this.saveResult = e.getErrorCode();
            this.saveResultText = this.getText(detail);
            this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.dnsrefresh.task.log.error", "atic.bis.online.offline.Defense.dnsrefresh", new String[]{this.ips, detail});
        }
        catch (Exception e) {
            this.logger.error((Object)("dnsRefresh falied Exception " + e.getMessage()));
            this.batchRsult4Options(false, "lego.fault.severity.rule.diversion.cloud", "atic.bis.online.offline.Defense.config.title", "atic.bis.online.offline.Defense.dnsrefresh.task.log.error", "atic.bis.online.offline.Defense.dnsrefresh", new String[]{this.ips, "defense.err.50001"});
        }
        this.logger.info((Object)"dnsRefresh over");
        return "success";
    }

    public String getDefenseConfig() {
        try {
            if (this.defenseConfigForm == null) {
                return "success";
            }
            DefenseConfigForm defenseConfig = this.defenseConfigService.queryDefenseConfigForm(this.defenseConfigForm);
            if (defenseConfig == null) {
                this.responseResult("fail");
                return "success";
            }
            this.logger.info((Object)("getDefenseConfig :" + defenseConfig.toString()));
            ArrayList<Long> zoneIds = new ArrayList<Long>();
            long zoneId = defenseConfig.getZoneId();
            zoneIds.add(zoneId);
            User user = (User)this.getSession().getAttribute("currentUser");
            this.checkDevicePermissionByUserName(user.getUserName(), zoneIds);
            ArrayList<Long> deviceIds = new ArrayList<Long>();
            long deviceId = defenseConfig.getDeviceId();
            if (deviceId > 0L) {
                deviceIds.add(deviceId);
                BisUtil.checkUserSecurity(deviceIds);
            }
            this.responseResult(defenseConfig);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"getDefenseConfig falied.");
            if (630114L == e.getErrorCode()) {
                this.logger.error((Object)("Exceeding authority here, domainName:[" + this.defenseConfigForm.getDomainName() + "]."));
                throw e;
            }
            this.logger.error((Object)"getDefenseConfig occur error.");
            throw e;
        }
        return "success";
    }

    private String queryDetailByErrcode(String key, long errorCode) {
        String detail = LocaleUtil.getInstance().getText(key + errorCode);
        if (null == detail || detail.equals(key + errorCode)) {
            if ("defense.err.".equals(key)) {
                return key + 50002L;
            }
            return "lego.err." + errorCode;
        }
        return key + errorCode;
    }

    public List<DefenseConfigForm> getDefenseConfigFormList() {
        return this.defenseConfigFormList;
    }

    public void setDefenseConfigFormList(List<DefenseConfigForm> defenseConfigFormList) {
        this.defenseConfigFormList = defenseConfigFormList;
    }

    public DefenseConfigForm getDefenseConfigForm() {
        return this.defenseConfigForm;
    }

    public void setDefenseConfigForm(DefenseConfigForm defenseConfigForm) {
        this.defenseConfigForm = defenseConfigForm;
    }

    public String getIps() {
        return this.ips;
    }

    public void setIps(String ips) {
        this.ips = ips;
    }

    public List<AticDevice> getDeviceList() {
        return this.deviceList;
    }

    public void setDeviceList(List<AticDevice> deviceList) {
        this.deviceList = deviceList;
    }

    public List<Map<String, String>> getRegions() {
        return this.regions;
    }

    public List<Map<String, String>> getLines() {
        return this.lines;
    }

    public List<RadioBean> getSwitchToOnlineList() {
        return this.switchToOnlineList;
    }

    public List<RadioBean> getSwitchToOfflineList() {
        return this.switchToOfflineList;
    }

    public List<RadioBean> getSwitchToDNSRefreshList() {
        return this.switchToDNSRefreshList;
    }

    public boolean isExist() {
        return this.exist;
    }

    public String getSaveResultText() {
        return this.saveResultText;
    }

    public long getSaveResult() {
        return this.saveResult;
    }

    public void setExist(boolean exist) {
        this.exist = exist;
    }

    public void setSaveResultText(String saveResultText) {
        this.saveResultText = saveResultText;
    }

    public void setSaveResult(long saveResult) {
        this.saveResult = saveResult;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Map<String, Map<Long, String>> getSaveResults() {
        return this.saveResults;
    }

    public void setSaveResults(Map<String, Map<Long, String>> saveResults) {
        this.saveResults = saveResults;
    }

    public boolean getDisplay() {
        return this.display;
    }

    public void setDisplay(boolean display) {
        this.display = display;
    }

    public String getHaveAuth() {
        return this.haveAuth;
    }

    public void setHaveAuth(String haveAuth) {
        this.haveAuth = haveAuth;
    }

    public String getDnsRefreshGroupId() {
        return this.dnsRefreshGroupId;
    }

    public void setDnsRefreshGroupId(String dnsRefreshGroupId) {
        this.dnsRefreshGroupId = dnsRefreshGroupId;
    }

    public int getIsAadUser() {
        return this.isAadUser;
    }

    public void setIsAadUser(int isAadUser) {
        this.isAadUser = isAadUser;
    }

    public int getDnsRefreshStatus() {
        return this.dnsRefreshStatus;
    }

    public void setDnsRefreshStatus(int dnsRefreshStatus) {
        this.dnsRefreshStatus = dnsRefreshStatus;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getDnsRefreshId() {
        return this.dnsRefreshId;
    }

    public void setDnsRefreshId(int dnsRefreshId) {
        this.dnsRefreshId = dnsRefreshId;
    }

    public int getSwitchToOnline() {
        return this.switchToOnline;
    }

    public void setSwitchToOnline(int switchToOnline) {
        this.switchToOnline = switchToOnline;
    }

    public int getSwitchToOffline() {
        return this.switchToOffline;
    }

    public void setSwitchToOffline(int switchToOffline) {
        this.switchToOffline = switchToOffline;
    }

    public int getSwitchToDNSRefresh() {
        return this.switchToDNSRefresh;
    }

    public void setSwitchToDNSRefresh(int switchToDNSRefresh) {
        this.switchToDNSRefresh = switchToDNSRefresh;
    }

    public String getStateDisplay() {
        if (null == this.stateDisplay) {
            return null;
        }
        return this.stateDisplay.trim();
    }

    public void setStateDisplay(String stateDisplay) {
        this.stateDisplay = stateDisplay;
    }

    public String getAllQueryDisplay() {
        if (null == this.allQueryDisplay) {
            return null;
        }
        return this.allQueryDisplay.trim();
    }

    public List<LangPair> getDefenseStateData() {
        return this.defenseStateData;
    }

    public void setDefenseStateData(List<LangPair> defenseStateData) {
        this.defenseStateData = defenseStateData;
    }

    public Integer getDefenseState() {
        return this.defenseState;
    }

    public void setDefenseState(Integer defenseState) {
        this.defenseState = defenseState;
    }

    public int getSwitchBandwidth() {
        return this.switchBandwidth;
    }

    public void setSwitchBandwidth(int switchBandwidth) {
        this.switchBandwidth = switchBandwidth;
    }
}

