/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.action;

import com.hs.atic.highdefense.domain.model.form.DefenseSwitchHistoryForm;
import com.hs.atic.highdefense.domain.service.IDefenseSwitchHistoryService;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DefenseSwitchHistoryAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IDefenseSwitchHistoryService defenseSwitchHistoryService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String zoneIp;
    private String startTime;
    private String endTime;
    private List<DefenseSwitchHistoryForm> defenseSwitchHistoryFormList;

    public String listDefenseSwitchHistory() {
        this.logger.info((Object)"listDefenseSwitchHistory start");
        this.defenseSwitchHistoryFormList = new ArrayList<DefenseSwitchHistoryForm>();
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        conditionMap.put("zoneIp", this.zoneIp);
        conditionMap.put("startTime", this.startTime);
        conditionMap.put("endTime", this.endTime);
        Paging page = this.defenseSwitchHistoryService.queryByPage(conditionMap, this.start, this.pageSize);
        this.defenseSwitchHistoryFormList = page.getData();
        this.total = page.getCount();
        return "success";
    }

    public boolean validateIp() {
        if (StringUtils.isEmpty(this.zoneIp)) {
            return true;
        }
        return IPUtil.isIpv4((String)this.zoneIp) || IPUtil.isIpv6((String)this.zoneIp);
    }

    public boolean validateTime() {
        if (StringUtils.isEmpty(this.startTime) || StringUtils.isEmpty(this.endTime)) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.startTime) && AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.endTime);
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public List<DefenseSwitchHistoryForm> getDefenseSwitchHistoryFormList() {
        return this.defenseSwitchHistoryFormList;
    }

    public void setDefenseSwitchHistoryFormList(List<DefenseSwitchHistoryForm> defenseSwitchHistoryFormList) {
        this.defenseSwitchHistoryFormList = defenseSwitchHistoryFormList;
    }
}

