/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.action;

import com.hs.atic.highdefense.domain.model.form.HuaweiCloudIdentityForm;
import com.hs.atic.highdefense.domain.service.IHuaweiCloudIdentityService;
import com.hs.atic.sdk.res.service.ICertManagementParentService;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.device.license.service.ILicenseManagementService;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class HuaweiCloudIdentityAction
extends BaseAction {
    private static final long serialVersionUID = -3879394397578003680L;
    private static final String LOGIN_URL = "https://iam.cn-north-1.myhuaweicloud.com/v3/auth/tokens";
    private static final String PROJECT_NAME = "cn-north-1";
    private static final String HIGH_DEFENSE_URL = "https://aad.myhuaweicloud.com/";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    @Autowired
    private IHuaweiCloudIdentityService huaweiCloudIdentityService;
    @Autowired
    private ILicenseManagementService licenseManagementService;
    private List<LangPair> allCertList;
    private long saveResult;
    private String saveText;
    private HuaweiCloudIdentityForm huaweiCloudIdentityForm;

    public String preAddIdentity() {
        this.logger.info((Object)"[preAddIdentity]");
        this.huaweiCloudIdentityForm = this.huaweiCloudIdentityService.queryCurrentHuaweiCloudConfig();
        if (null != this.huaweiCloudIdentityForm && null == this.huaweiCloudIdentityForm.getUrl() && null == this.huaweiCloudIdentityForm.getProjectName() && null == this.huaweiCloudIdentityForm.getHighDefenseUrl()) {
            this.huaweiCloudIdentityForm.setUrl(LOGIN_URL);
            this.huaweiCloudIdentityForm.setProjectName(PROJECT_NAME);
            this.huaweiCloudIdentityForm.setHighDefenseUrl(HIGH_DEFENSE_URL);
        }
        ICertManagementParentService ertManagementService = (ICertManagementParentService)ServiceContext.getInstance().getService("certManagementService", ICertManagementParentService.class);
        this.allCertList = ertManagementService.queryAllCertName();
        return "success";
    }

    public String saveIdentity() {
        long result;
        this.logger.info((Object)"[saveIdentity]");
        this.saveResult = result = this.huaweiCloudIdentityService.saveIdentity(this.huaweiCloudIdentityForm);
        this.saveText = this.getText("atic.bis.online.offline.Defense.Constants." + result);
        return "success";
    }

    public boolean isLicenseValid() {
        return this.licenseManagementService != null && this.licenseManagementService.getAllLicenses().size() > 0;
    }

    public boolean isHwCloudUserIdentityVerified() {
        boolean isVerified = false;
        List<HuaweiCloudIdentityForm> userIdentites = this.huaweiCloudIdentityService.getUserIdentites();
        isVerified = userIdentites.size() > 0;
        return isVerified;
    }

    public boolean validateFormUrl() {
        String url = this.huaweiCloudIdentityForm.getUrl();
        if (null != url && !url.isEmpty()) {
            if (url.length() > 255) {
                return false;
            }
            String regex = "(^((https://)|(http://))[\\w|\\-|\\/|\\:|\\.|\\?|\\%|\\&|\\=]+$)";
            if (!url.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateFormUser() {
        String user = this.huaweiCloudIdentityForm.getUserIdentity();
        if (null != user && !user.isEmpty()) {
            if (user.length() > 64) {
                return false;
            }
            String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!user.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateFormPwd() {
        String pwd = this.huaweiCloudIdentityForm.getPwdIdentity();
        if (null == pwd) {
            return true;
        }
        if (StringUtils.isBlank(pwd)) {
            return false;
        }
        String reg1 = "[a-zA-Z]+";
        String reg2 = "[0-9]+";
        String reg3 = "[=|\\-|_|!|@|#|$|%|\\*|\\(|\\^|\\)|\\|||:|;|\\,|\\.|\\\"|\\'|\\+|\\}|\\{|&]+";
        Pattern p = Pattern.compile(reg1);
        Matcher m = p.matcher(pwd);
        boolean f = m.find();
        Pattern p1 = Pattern.compile(reg2);
        Matcher m1 = p1.matcher(pwd);
        boolean f1 = m1.find();
        Pattern p2 = Pattern.compile(reg3);
        Matcher m2 = p2.matcher(pwd);
        boolean f2 = m2.find();
        if (!(f && f1 && f2)) {
            return false;
        }
        return StringUtils.isEmpty(pwd) || pwd.length() >= 6 && pwd.length() <= 64;
    }

    public boolean validateFormDomain() {
        String domainName = this.huaweiCloudIdentityForm.getDomainName();
        if (null != domainName && !domainName.isEmpty()) {
            if (domainName.length() > 255) {
                return false;
            }
            String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!domainName.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateFormProject() {
        String projectName = this.huaweiCloudIdentityForm.getProjectName();
        if (null != projectName && !projectName.isEmpty()) {
            if (projectName.length() > 255) {
                return false;
            }
            String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{|-]+$";
            if (!projectName.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateFormhighDefenseUrl(String highDefenseUrl) {
        String hostRegx = "^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$";
        if (null == highDefenseUrl || highDefenseUrl.trim().equals("")) {
            return false;
        }
        if (highDefenseUrl.indexOf("://") == -1) {
            return false;
        }
        String[] arrays = highDefenseUrl.split("://");
        if (null == arrays[0] || !arrays[0].equals("https") && !arrays[0].equals("http")) {
            return false;
        }
        if (arrays[1].indexOf(":") == -1) {
            String host = arrays[1];
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            if (host.equals("")) {
                return false;
            }
            if (!IPUtil.isIpv4((String)host) && !host.matches(hostRegx)) {
                return false;
            }
        } else {
            String[] ipPort = arrays[1].split(":");
            if (ipPort[0].equals("")) {
                return false;
            }
            if (!IPUtil.isIpv4((String)ipPort[0]) && !ipPort[0].matches(hostRegx)) {
                return false;
            }
            String port = ipPort[1];
            if (ipPort[1].endsWith("/")) {
                port = ipPort[1].substring(0, ipPort[1].length() - 1);
            }
            if (!port.matches("^([1-9][0-9]*)$")) {
                return false;
            }
            if (Integer.parseInt(port) <= 0 || Integer.parseInt(port) > 65535) {
                return false;
            }
        }
        return true;
    }

    public boolean validateCertAlias(String certAlias) {
        if (StringUtils.isEmpty(certAlias)) {
            return true;
        }
        Pattern pattern = Pattern.compile("^(?!_)(?![0-9])[a-zA-Z_0-9]+$");
        Matcher matcher = pattern.matcher(certAlias);
        if (!matcher.matches()) {
            return false;
        }
        return certAlias.length() > 0 && certAlias.length() <= 128;
    }

    public boolean validateForm() {
        return this.huaweiCloudIdentityForm != null && !StringUtils.isEmpty(this.huaweiCloudIdentityForm.getUrl()) && !StringUtils.isEmpty(this.huaweiCloudIdentityForm.getUserIdentity());
    }

    public HuaweiCloudIdentityForm getHuaweiCloudIdentityForm() {
        return this.huaweiCloudIdentityForm;
    }

    public void setHuaweiCloudIdentityForm(HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        this.huaweiCloudIdentityForm = huaweiCloudIdentityForm;
    }

    public long getSaveResult() {
        return this.saveResult;
    }

    public void setSaveResult(long saveResult) {
        this.saveResult = saveResult;
    }

    public String getSaveText() {
        return this.saveText;
    }

    public void setSaveText(String saveText) {
        this.saveText = saveText;
    }

    public List<LangPair> getAllCertList() {
        return this.allCertList;
    }
}

