/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.dao;

import com.hs.atic.highdefense.domain.model.DefenseConfig;
import com.hs.atic.highdefense.domain.model.form.DefenseConfigForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.huawei.atic.device.license.model.LicenseInfoDb;
import com.huawei.atic.device.model.AticDevice;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Repository;

@Repository(value="defenseConfigDAO")
public class DefenseConfigDAOImpl
extends CommonDaoImpl {
    private static final int DEVICE_WITH_IPS_COUNT = 5;
    private static final int DEVICE_WITH_INDEPEND_ACCOUNT_IPS_COUNT = 1000;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String companyName;
        String state;
        String groupName;
        String zoneIp;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        StringBuffer hql = new StringBuffer();
        hql.append("from DefenseConfig f where (1=1) ");
        int index = 0;
        if (conditionMap.containsKey("isAdmin") && !Boolean.valueOf(conditionMap.get("isAdmin")).booleanValue()) {
            hql.append(" and f.zoneId IN(SELECT info.zoneId FROM ZoneInfo info");
            hql.append("," + CheckChildrenMoUtil.getInstanse().getGrantHqlObj());
            hql.append(" WHERE info.moId = u.id.moId");
            hql.append(" and u.id.userId = ?0 )");
            hql.append(" and f.deviceId in (select d.moId from AticDevice d");
            hql.append("," + CheckChildrenMoUtil.getInstanse().getGrantHqlObj());
            hql.append(" WHERE d.moId = u.id.moId");
            hql.append(" and u.id.userId = ?1 )");
            queryMap.put(index++, conditionMap.get("userId"));
            queryMap.put(index++, conditionMap.get("userId"));
        }
        if (!AticUtil.isNull((String)(zoneIp = conditionMap.get("zoneIp")))) {
            hql.append(" and f.zoneIp like ?" + index);
            queryMap.put(index++, "%" + zoneIp.trim() + "%");
        }
        if (!AticUtil.isNull((String)(groupName = conditionMap.get("groupName")))) {
            hql.append(" and f.groupName like ?" + index);
            queryMap.put(index++, "%" + groupName.trim() + "%");
        }
        if (!AticUtil.isNull((String)(state = conditionMap.get("state")))) {
            hql.append(" and f.state = ?" + index);
            queryMap.put(index++, state);
        }
        if (!AticUtil.isNull((String)(companyName = conditionMap.get("companyName")))) {
            hql.append(" and f.companyName like ?" + index);
            queryMap.put(index++, "%" + companyName.trim() + "%");
        }
        hql.append(" ORDER BY state ");
        String hql4Count = "select count(*) as rowCount ";
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        List result = this.findPage(hql.toString(), start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<AticDevice> queryDeviceByDomain(DefenseConfigForm defenseConfigForm, List<AticDevice> includeDevices) {
        List aticDevices;
        String licenseHQL;
        List listLicense;
        String child = "SELECT license.defenseBindwidth FROM DefenseConfig config, LicenseInfoDb license WHERE config.deviceId = license.ddosDeviceId AND config.domainName = :domainName";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("domainName", defenseConfigForm.getDomainName());
        List listConfigBindWidths = this.findByHqlKey(child, param);
        String bindWidth = null;
        if (null != listConfigBindWidths && listConfigBindWidths.size() > 0) {
            List list = listConfigBindWidths;
            if (list.size() > 0) {
                String bindWidthEncrypt = list.get(0) + "";
                this.logger.info((Object)("[bindWidth] decryptdata : " + bindWidthEncrypt));
                bindWidth = EncryptData.getInstanse().decryptdata(bindWidthEncrypt);
            }
            if (null == bindWidth || !Pattern.compile("^[1-9]\\d*$").matcher(bindWidth).matches()) {
                this.logger.error((Object)"[bindWidth] decryptdata error!");
                return new ArrayList<AticDevice>();
            }
        }
        if (null == (listLicense = this.findByHql(licenseHQL = "FROM LicenseInfoDb license GROUP BY license.ddosDeviceId")) || listLicense.size() == 0) {
            return new ArrayList<AticDevice>();
        }
        HashSet<Long> deviceIds = new HashSet<Long>();
        for (Object obj : listLicense) {
            if (null == obj) continue;
            LicenseInfoDb licenseInfoDb = (LicenseInfoDb)obj;
            String defenseBindwidthEncrypt = licenseInfoDb.getDefenseBindwidth();
            this.logger.info((Object)("[defenseBindwidthEncrypt] decryptdata : " + defenseBindwidthEncrypt));
            String defenseBindwidth = EncryptData.getInstanse().decryptdata(defenseBindwidthEncrypt);
            if (null == defenseBindwidth || !Pattern.compile("^[1-9]\\d*$").matcher(defenseBindwidth).matches()) continue;
            if (null == bindWidth) {
                deviceIds.add(licenseInfoDb.getDdosDeviceId());
                continue;
            }
            if (!defenseBindwidth.trim().equalsIgnoreCase(bindWidth.trim())) continue;
            deviceIds.add(licenseInfoDb.getDdosDeviceId());
        }
        StringBuffer hqlSelectDevice = new StringBuffer("SELECT device FROM AticDevice device ");
        if (defenseConfigForm.getCurUserId() != 1L) {
            hqlSelectDevice.append(" LEFT JOIN UserRelMoInfo userRelMo ON device.moId = userRelMo.id.moId");
        }
        hqlSelectDevice.append(" WHERE 1=1 ");
        int indexHql = 0;
        if (defenseConfigForm.getCurUserId() != 1L) {
            hqlSelectDevice.append(" AND userRelMo.id.userId = :userId");
        }
        if (null != includeDevices && includeDevices.size() > 0) {
            hqlSelectDevice.append(" AND device.moId in (");
            hqlSelectDevice.append(":moIds" + indexHql++);
            hqlSelectDevice = new StringBuffer(hqlSelectDevice.toString().endsWith(",") ? hqlSelectDevice.toString().substring(0, hqlSelectDevice.toString().length() - 1) : hqlSelectDevice.toString());
            hqlSelectDevice.append(")");
        }
        if (deviceIds.size() > 0) {
            hqlSelectDevice.append(" AND device.moId in (");
            hqlSelectDevice.append(":moIds" + indexHql++);
            hqlSelectDevice = new StringBuffer(hqlSelectDevice.toString().endsWith(",") ? hqlSelectDevice.toString().substring(0, hqlSelectDevice.toString().length() - 1) : hqlSelectDevice.toString());
            hqlSelectDevice.append(")");
        }
        if (defenseConfigForm.getCurUserId() != 1L) {
            hqlSelectDevice.append(" GROUP BY device.moId");
        }
        LinkedHashMap<String, Serializable> param2 = new LinkedHashMap<String, Serializable>();
        int index = 0;
        if (defenseConfigForm.getCurUserId() != 1L) {
            param2.put("userId", Long.valueOf(defenseConfigForm.getCurUserId()));
        }
        if (null != includeDevices && includeDevices.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (AticDevice aticDevice : includeDevices) {
                set.add(aticDevice.getMoId());
            }
            param2.put("moIds" + index++, new ArrayList(set));
        }
        if (deviceIds.size() > 0) {
            param2.put("moIds" + index++, new ArrayList(deviceIds));
        }
        if (null == (aticDevices = this.findByHqlKey(hqlSelectDevice.toString(), param2))) {
            return new ArrayList<AticDevice>();
        }
        return aticDevices;
    }

    public List<AticDevice> filterDevicesByUserId(DefenseConfigForm defenseConfigForm, List<AticDevice> includeDevices) {
        List aticDevices;
        StringBuffer hqlSelectDevice = new StringBuffer("SELECT device FROM AticDevice device ");
        if (defenseConfigForm.getCurUserId() != 1L) {
            hqlSelectDevice.append(" LEFT JOIN UserRelMoInfo userRelMo ON device.moId = userRelMo.id.moId");
        }
        hqlSelectDevice.append(" WHERE 1=1 ");
        int indexHql = 0;
        if (defenseConfigForm.getCurUserId() != 1L) {
            hqlSelectDevice.append(" AND userRelMo.id.userId = :userId");
        }
        if (null != includeDevices && includeDevices.size() > 0) {
            hqlSelectDevice.append(" AND device.moId in (");
            hqlSelectDevice.append(":moIds" + ++indexHql);
            hqlSelectDevice = new StringBuffer(hqlSelectDevice.toString().endsWith(",") ? hqlSelectDevice.toString().substring(0, hqlSelectDevice.toString().length() - 1) : hqlSelectDevice.toString());
            hqlSelectDevice.append(")");
        }
        if (defenseConfigForm.getCurUserId() != 1L) {
            hqlSelectDevice.append(" GROUP BY device.moId");
        }
        LinkedHashMap<String, Serializable> param2 = new LinkedHashMap<String, Serializable>();
        int index = 0;
        if (defenseConfigForm.getCurUserId() != 1L) {
            param2.put("userId", Long.valueOf(defenseConfigForm.getCurUserId()));
        }
        if (null != includeDevices && includeDevices.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (AticDevice aticDevice : includeDevices) {
                set.add(aticDevice.getMoId());
            }
            param2.put("moIds" + ++index, new ArrayList(set));
        }
        if (null == (aticDevices = this.findByHqlKey(hqlSelectDevice.toString(), param2))) {
            return new ArrayList<AticDevice>();
        }
        return aticDevices;
    }

    public boolean queryIpExist(DefenseConfigForm defenseConfigForm) {
        List result;
        String hql = "from DefenseConfig where 1=1 and (zoneIp = :zoneIp1 or backIp = :zoneIp2)";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("zoneIp1", defenseConfigForm.getZoneIp());
        param.put("zoneIp2", defenseConfigForm.getZoneIp());
        if (defenseConfigForm.isEdit()) {
            hql = hql + " and id != :id";
            param.put("id", defenseConfigForm.getId() + "");
        }
        return (result = this.findByHqlKey(hql, param)) != null && !result.isEmpty();
    }

    public boolean queryBackupIpExist(DefenseConfigForm defenseConfigForm) {
        List result;
        String hql = "from DefenseConfig where 1=1 and (zoneIp = :zoneIp1 or backIp = :zoneIp2)";
        if (defenseConfigForm.isEdit()) {
            hql = hql + " and id != :id";
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("zoneIp1", defenseConfigForm.getBackIp());
        param.put("zoneIp2", defenseConfigForm.getBackIp());
        if (defenseConfigForm.isEdit()) {
            param.put("id", defenseConfigForm.getId() + "");
        }
        return (result = this.findByHqlKey(hql, param)) != null && !result.isEmpty();
    }

    public boolean queryIpCountWithDevice(DefenseConfigForm defenseConfigForm) {
        String hql = "from DefenseConfig where deviceId = :deviceId";
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("deviceId", defenseConfigForm.getDeviceId());
        List result = this.findByHqlKey(hql, param);
        if (result == null || result.isEmpty()) {
            return false;
        }
        return result.size() >= 5;
    }

    public boolean queryIpCountWithDefenseIndependAccount() {
        String hql = "select count(* ) as rowCount from DefenseConfig";
        long count = this.getTotalCount(hql);
        return count >= 1000L;
    }

    public List<DefenseConfig> queryAllOnOrOffLine(boolean isOnLine) {
        StringBuffer hql = new StringBuffer();
        hql.append("from DefenseConfig where state ");
        if (isOnLine) {
            hql.append(" <> 4 ");
        } else {
            hql.append(" = 4 ");
        }
        List list = this.findByHql(hql.toString());
        if (null != list) {
            return list;
        }
        return null;
    }

    public List<DefenseConfig> queryDefenseConfigsByIp(Map<String, String> conditionMap) {
        StringBuffer hql = new StringBuffer();
        hql.append("from DefenseConfig f where 1=1 ");
        int index = 0;
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (conditionMap.containsKey("isAdmin") && !Boolean.valueOf(conditionMap.get("isAdmin")).booleanValue()) {
            hql.append(" and f.zoneId IN(SELECT info.zoneId FROM ZoneInfo info");
            hql.append("," + CheckChildrenMoUtil.getInstanse().getGrantHqlObj());
            hql.append(" WHERE info.moId = u.id.moId");
            hql.append(" and u.id.userId = ?" + index + " )");
            param.put(index++, conditionMap.get("userId"));
        }
        hql.append("and f.zoneIp in ( ");
        if (conditionMap.containsKey("ips")) {
            String[] ips = conditionMap.get("ips").split(",");
            for (int i = 0; i < ips.length; ++i) {
                if (0 == i) {
                    hql.append("?" + index);
                    param.put(index++, ips[i]);
                    continue;
                }
                hql.append(",? " + index);
                param.put(index++, ips[i]);
            }
        }
        hql.append(')');
        List list = this.findByHql(hql.toString(), param);
        if (null != list) {
            return list;
        }
        return null;
    }

    public List<DefenseConfig> queryDefenseConfigsByZoneIp(String ips) {
        StringBuffer hql = new StringBuffer();
        hql.append("from DefenseConfig f where 1=1 ");
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (ips == null) {
            return null;
        }
        hql.append("and f.zoneIp in ( ");
        int index = 0;
        String[] ipList = ips.split(",");
        for (int i = 0; i < ipList.length; ++i) {
            if (0 == i) {
                hql.append("?" + index);
                param.put(index++, ipList[i]);
                continue;
            }
            hql.append(",?" + index);
            param.put(index++, ipList[i]);
        }
        hql.append(')');
        List list = this.findByHql(hql.toString(), param);
        if (null != list) {
            return list;
        }
        return null;
    }

    public List<DefenseConfig> getOnlineDefenseByDeviceId(long deviceId) {
        String hql = "from DefenseConfig where state <> 4 and deviceId = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(deviceId));
        List list = this.findByHql(hql, param);
        if (null != list) {
            return list;
        }
        return null;
    }

    public DefenseConfig queryDefenseConfig(DefenseConfigForm defenseConfigForm) {
        StringBuffer hql = new StringBuffer();
        hql.append("select new DefenseConfig(config.id, config.licenseNumber, config.domainName, config.zoneId, config.zoneIp, config.ipId, config.deviceId, device.name as deviceName, config.deviceArea, config.deviceLine, config.backIp, config.groupId, config.groupName, config.switchToOnline, config.switchToOffline,config.switchToDNSRefresh, config.switchBandwidth, config.tcpPort, config.udpPort, config.cname, config.state, config.companyName, config.expirationDate, config.updatedDateTime) from DefenseConfig config LEFT JOIN AticDevice device on config.deviceId = device.moId where config.id = :id");
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", defenseConfigForm.getId());
        List list = this.findByHqlKey(hql.toString(), params);
        if (null != list && list.size() > 0) {
            return (DefenseConfig)list.get(0);
        }
        return null;
    }

    public DefenseConfig queryDefenseConfigForm(DefenseConfigForm defenseConfigForm) {
        StringBuffer hql = new StringBuffer();
        hql.append("select new DefenseConfig(config.id, config.licenseNumber, config.domainName, config.zoneId, config.zoneIp, config.ipId, config.deviceId, device.name as deviceName, config.deviceArea, config.deviceLine, config.backIp, config.groupId, config.groupName, config.switchToOnline, config.switchToOffline,config.switchToDNSRefresh, config.switchBandwidth, config.tcpPort, config.udpPort, config.cname, config.state, config.companyName, config.expirationDate, config.updatedDateTime) from DefenseConfig config LEFT JOIN AticDevice device on config.deviceId = device.moId where config.domainName = :domainName");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("domainName", defenseConfigForm.getDomainName());
        List list = this.findByHqlKey(hql.toString(), params);
        if (null != list && list.size() > 0) {
            return (DefenseConfig)list.get(0);
        }
        return null;
    }

    public List<DefenseConfig> getDefenseConfigsByLicenseNumber(String licenseNumber) {
        StringBuffer hql = new StringBuffer();
        hql.append("from DefenseConfig where licenseNumber = ?0");
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, licenseNumber);
        return this.findByHql(hql.toString(), param);
    }

    public List<DefenseConfig> getDefenseConfigsByDomainName(String domainName) {
        StringBuffer hql = new StringBuffer();
        hql.append("from DefenseConfig where domainName = ?0");
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, domainName);
        return this.findByHql(hql.toString(), param);
    }

    public Integer updateDefenseGroup(Set<String> set, String expirationDate) {
        String hql = "update DefenseConfig o1 set o1.expirationDate=:expirationDate where o1.domainName in (:domainNames)";
        Object[] domainNames = new Object[set.size()];
        int i = 0;
        for (String string : set) {
            domainNames[i++] = string;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate expirationD = LocalDate.parse(expirationDate, df);
        String name1 = "expirationDate";
        String name = "domainNames";
        UpdateByHql callBack = new UpdateByHql(hql, name1, name, domainNames, expirationD);
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)callBack);
    }

    public Integer updateDefenseGroupDeviceId(long ddosDeviceId, String licenseNumber) {
        String hql = "update DefenseConfig o1 set o1.deviceId =:deviceId where o1.licenseNumber =:licenseNumber";
        String deviceIdStr = "deviceId";
        String licenseNumberStr = "licenseNumber";
        UpdateByHql callBack = new UpdateByHql(hql, deviceIdStr, licenseNumberStr, new Object[]{licenseNumber}, ddosDeviceId);
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)callBack);
    }

    public List<DefenseConfig> queryDefenseConfigsByGroupId(String groupId) {
        String hql = "from DefenseConfig where groupId = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, groupId);
        List list = this.findByHql(hql, param);
        if (null != list) {
            return list;
        }
        return null;
    }

    public void updateDefenseState(long id, int state, LocalDateTime updatedDateTime) {
        String hql = "update DefenseConfig set state =?0 ,updatedDateTime =?1 where id =?2";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{state, updatedDateTime, id});
    }

    public void updateDefenseByDomainName(DefenseConfig defenseConfig) {
        StringBuffer hql = new StringBuffer();
        hql.append("update DefenseConfig config set config.tcpPort = ?0 ,config.udpPort= ?1 ,config.switchToOnline = ?2 , ").append(" config.switchToOffline = ?3 , config.switchToDNSRefresh = ?4 where config.domainName = ?5 ");
        String tcpPort = defenseConfig.getTcpPort();
        String udpPort = defenseConfig.getUdpPort();
        int switchToOnline = defenseConfig.getSwitchToOnline();
        int switchToOffline = defenseConfig.getSwitchToOffline();
        int switchToDNSRefresh = defenseConfig.getSwitchToDNSRefresh();
        String domainName = defenseConfig.getDomainName();
        this.getHibernateTemplate().bulkUpdate(hql.toString(), new Object[]{tcpPort, udpPort, switchToOnline, switchToOffline, switchToDNSRefresh, domainName});
    }

    private static final class UpdateByHql
    implements HibernateCallback {
        private String hql;
        private String name;
        private String name1;
        private Object value;
        private Object[] values;

        public UpdateByHql(String hql, String name1, String name, Object[] values, Object value) {
            this.hql = hql;
            this.name = name;
            this.values = values;
            this.name1 = name1;
            this.value = value;
        }

        public Integer doInHibernate(Session session) {
            Query query = session.createQuery(this.hql);
            query.setParameter(this.name1, this.value);
            if (this.values != null && this.values.length > 0) {
                query.setParameterList(this.name, this.values);
            }
            return query.executeUpdate();
        }
    }
}

