/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.dao;

import com.hs.atic.highdefense.domain.model.HuaweiCloudIdentity;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="huaweiCloudIdentityDAO")
public class HuaweiCloudIdentityDAOImpl
extends CommonDaoImpl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public HuaweiCloudIdentity queryIdentity(int bandWith) {
        this.logger.info((Object)"[HuaweiCloudIdentityDAOImpl][queryIdentity]");
        String hql = "from HuaweiCloudIdentity where huaweiCloudBandWidth = ?0";
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        params.put(0, bandWith + "");
        List listHuaweiCloudIdentity = this.findByHql(hql, params);
        if (null == listHuaweiCloudIdentity || listHuaweiCloudIdentity.size() == 0) {
            return new HuaweiCloudIdentity();
        }
        return (HuaweiCloudIdentity)listHuaweiCloudIdentity.get(0);
    }

    public int queryIdentity() {
        this.logger.info((Object)"[HuaweiCloudIdentityDAOImpl][queryIdentity]");
        String hql = "from HuaweiCloudIdentity";
        List listHuaweiCloudIdentity = this.findByHql(hql);
        if (null == listHuaweiCloudIdentity || listHuaweiCloudIdentity.size() == 0) {
            return 0;
        }
        return listHuaweiCloudIdentity.size();
    }

    public void saveIdentity(HuaweiCloudIdentity huaweiCloudIdentity) {
        this.logger.info((Object)"[HuaweiCloudIdentityDAOImpl][saveIdentity]");
        try {
            super.getHibernateTemplate().flush();
            super.getHibernateTemplate().clear();
            super.getHibernateTemplate().saveOrUpdate((Object)huaweiCloudIdentity);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("huaweiCloudentity save failed." + e.getMessage()));
        }
    }

    @Transactional
    public void saveIdentitys(List<HuaweiCloudIdentity> huaweiCloudIdentityList) {
        this.logger.info((Object)"[HuaweiCloudIdentityDAOImpl][saveIdentitys]");
        for (HuaweiCloudIdentity identity : huaweiCloudIdentityList) {
            this.saveIdentity(identity);
        }
    }

    public List<HuaweiCloudIdentity> getAadUserIdentities(boolean isAadAccount) {
        this.logger.info((Object)"[HuaweiCloudIdentityDAOImpl][getAadUserIdentities]");
        String hql = "from HuaweiCloudIdentity where isAadAccount = ?0";
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        Integer aadAccount = isAadAccount ? 1 : 0;
        params.put(0, String.valueOf(aadAccount));
        List listHuaweiCloudIdentity = this.findByHql(hql, params);
        ArrayList<HuaweiCloudIdentity> identites = new ArrayList<HuaweiCloudIdentity>();
        for (int i = 0; i < listHuaweiCloudIdentity.size(); ++i) {
            identites.add((HuaweiCloudIdentity)listHuaweiCloudIdentity.get(i));
        }
        return identites;
    }

    public List<HuaweiCloudIdentity> getUserIdentities() {
        this.logger.info((Object)"[HuaweiCloudIdentityDAOImpl][getUserIdentities]");
        String hql = "from HuaweiCloudIdentity";
        List listHuaweiCloudIdentity = this.findByHql(hql);
        ArrayList<HuaweiCloudIdentity> identites = new ArrayList<HuaweiCloudIdentity>();
        for (int i = 0; i < listHuaweiCloudIdentity.size(); ++i) {
            identites.add((HuaweiCloudIdentity)listHuaweiCloudIdentity.get(i));
        }
        return identites;
    }

    public void cleanNonAadAccountUserIdentities() {
        this.logger.info((Object)"[HuaweiCloudIdentityDAOImpl][cleanUserIdentities]");
        String hql = "delete from HuaweiCloudIdentity where isAadAccount = ?0";
        Integer isAadAccount = 0;
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{isAadAccount});
    }
}

