/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.service.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hs.atic.highdefense.domain.dao.DefenseConfigDAOImpl;
import com.hs.atic.highdefense.domain.dao.DefenseSwitchHistoryDAOImpl;
import com.hs.atic.highdefense.domain.model.DefenseConfig;
import com.hs.atic.highdefense.domain.model.DefenseSwitchHistory;
import com.hs.atic.highdefense.domain.model.HighDefenseGroup;
import com.hs.atic.highdefense.domain.model.HighDefenseGroupInfo;
import com.hs.atic.highdefense.domain.model.HighDefenseGroups;
import com.hs.atic.highdefense.domain.model.HighDefenseIp;
import com.hs.atic.highdefense.domain.model.HighDefenseIpNode;
import com.hs.atic.highdefense.domain.model.HighDefenseTransferRule;
import com.hs.atic.highdefense.domain.model.form.DefenseConfigForm;
import com.hs.atic.highdefense.domain.model.form.HuaweiCloudIdentityForm;
import com.hs.atic.highdefense.domain.service.IDefenseConfigCommandService;
import com.hs.atic.highdefense.domain.service.IDefenseConfigService;
import com.hs.atic.highdefense.domain.service.IHuaweiCloudIdentityService;
import com.hs.atic.highdefense.domain.util.LocalDateTimeUtil;
import com.hs.atic.highdefense.util.RestInvoker;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.license.dao.LicenseDao;
import com.huawei.atic.device.license.model.LicenseInfoModel;
import com.huawei.atic.device.license.service.ILicenseManagementService;
import com.huawei.atic.device.license.vo.LicenseInfo;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import com.restful.util.JSONUtil;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defenseConfigService")
public class DefenseConfigServiceImpl
implements IDefenseConfigService {
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOURTH = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final int SEVEN = 7;
    private static final int EIGHT = 8;
    private static final int THIRTY_TOW = 32;
    private static final int LOG_RESULT_SUCCESS = 1;
    private static final int LOG_RESULT_FAILED = 0;
    private static final long ONE_THOUSAND_NUM = 1000L;
    private static final String STATUS_FLUSHING = "flushing";
    private static final String STATUS_FLUSHED = "flushed";
    private static final String STATUS_FAILED = "failed";
    private static final String STATUS_RECORD_REMOVED = "recordRomoved";
    private static final Long DEVICE_THRESHOLD_DEPLOY_FAILURE = 7300L;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    @Autowired
    private DefenseConfigDAOImpl defenseConfigDAO;
    @Autowired
    private AticDeviceDao aticDeviceDao;
    @Autowired
    private DefenseSwitchHistoryDAOImpl defenseSwitchHistoryDAO;
    @Autowired
    @Qualifier(value="licenseManagementServiceImpl")
    private ILicenseManagementService licenseManagementService;
    @Autowired
    @Qualifier(value="huaweiCloudIdentityService")
    private IHuaweiCloudIdentityService huaweiCloudIdentityService;
    @Autowired
    private LicenseDao licenseDao;
    @Autowired
    @Qualifier(value="zoneService")
    private IZoneService zoneService;
    @Autowired
    @Qualifier(value="zonePolicyApplyService")
    private IZonePolicyApplyService zonePolicyApplyService;
    @Autowired
    @Qualifier(value="aticDeviceService")
    private IAticDeviceService aticDeviceService;
    @Autowired
    @Qualifier(value="defenseConfigCommandService")
    private IDefenseConfigCommandService defenseConfigCommandService;

    @Override
    @Transactional
    public void saveDefenseConfig(DefenseConfigForm defenseConfigForm) {
        HighDefenseGroupInfo highDefenseGroupInfoExist;
        LicenseInfo licenseInfo;
        DefenseConfig defenseConfig;
        block45: {
            HighDefenseGroup highDefenseGroup;
            String responseJson;
            HuaweiCloudIdentityForm huaweiCloudIdentityForm;
            block44: {
                this.logger.info((Object)"saveDefenseConfig");
                if (defenseConfigForm.getDeviceId() > 0L) {
                    this.defenseConfigCommandService.execCmd(defenseConfigForm);
                }
                List<DefenseConfig> list = this.defenseConfigDAO.getDefenseConfigsByDomainName(defenseConfigForm.getDomainName());
                DefenseConfig defenseConfigExist = null;
                if (null != list && list.size() > 0 && null != list.get(0)) {
                    defenseConfigExist = list.get(0);
                    this.logger.info((Object)("[DefenseConfig atic database exist] : " + defenseConfigExist.getGroupId() + ", " + defenseConfigExist.getDomainName()));
                }
                defenseConfig = new DefenseConfig();
                licenseInfo = null;
                huaweiCloudIdentityForm = null;
                if (!this.isDefenseIndependentAccount()) {
                    licenseInfo = this.licenseManagementService.getLicenseByDeviceId(defenseConfigForm.getDeviceId());
                    if (null == licenseInfo) {
                        this.logger.error((Object)"saveDefenseConfig licenseInfo is null!");
                        this.failToundo(defenseConfigForm);
                        throw new LegoCheckedException(6001L);
                    }
                    huaweiCloudIdentityForm = this.huaweiCloudIdentityService.queryIdentity(licenseInfo.getDefenseBindwidth());
                    if (null == huaweiCloudIdentityForm || null == huaweiCloudIdentityForm.getHighDefenseUser()) {
                        this.failToundo(defenseConfigForm);
                        throw new LegoCheckedException(6001L);
                    }
                } else {
                    List<HuaweiCloudIdentityForm> huaweiCloudIdentityFormList = this.huaweiCloudIdentityService.getAadUserIdentites();
                    if (null != huaweiCloudIdentityFormList && huaweiCloudIdentityFormList.size() != 0) {
                        huaweiCloudIdentityForm = huaweiCloudIdentityFormList.get(0);
                    }
                    if (null == huaweiCloudIdentityForm || null == huaweiCloudIdentityForm.getHighDefenseUser()) {
                        this.failToundo(defenseConfigForm);
                        throw new LegoCheckedException(6001L);
                    }
                }
                responseJson = "";
                highDefenseGroup = new HighDefenseGroup();
                highDefenseGroupInfoExist = null;
                try {
                    String responseGroupJson = null;
                    responseGroupJson = !this.isDefenseIndependentAccount() ? RestInvoker.get("/v1/{domain_id}/dpp/groups", licenseInfo.getDefenseBindwidth(), null, 1) : RestInvoker.get("/v1/{domain_id}/dpp/groups", null, 1);
                    HighDefenseGroups highDefenseGroups = null;
                    if (null != responseGroupJson) {
                        this.logger.info((Object)("[responseGroupJson] : " + responseGroupJson));
                        highDefenseGroups = (HighDefenseGroups)JSONUtil.getInstance().fromJSON(responseGroupJson, HighDefenseGroups.class);
                    }
                    if (null == highDefenseGroups || null == highDefenseGroups.getGroups()) break block44;
                    List<HighDefenseGroupInfo> groups = highDefenseGroups.getGroups();
                    for (HighDefenseGroupInfo groupInfo : groups) {
                        if (null == groupInfo || null == groupInfo.getGroupName() || !groupInfo.getGroupName().equalsIgnoreCase(defenseConfigForm.getDomainName())) continue;
                        highDefenseGroupInfoExist = groupInfo;
                        this.logger.info((Object)("[highDefenseGroupExist exist] : " + highDefenseGroupInfoExist.getGroupId() + ", " + highDefenseGroupInfoExist.getGroupName()));
                        break;
                    }
                }
                catch (IOException e) {
                    this.logger.error((Object)"saveDefenseConfig failed IOException");
                    return;
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)e.getMessage());
                    throw e;
                }
            }
            try {
                highDefenseGroup.setDomainName(defenseConfigForm.getDomainName());
                highDefenseGroup.setUname(huaweiCloudIdentityForm.getHighDefenseUser());
                highDefenseGroup.setGroupName(defenseConfigForm.getDomainName());
                highDefenseGroup.setSwitchType(defenseConfigForm.getSwitchToOnline());
                if (!this.isDefenseIndependentAccount()) {
                    highDefenseGroup.setExpirationDate(defenseConfigForm.getExpirationDateString());
                    highDefenseGroup.setDnsFastRefreshSwitch(0);
                } else {
                    highDefenseGroup.setExpirationDate("2100-01-01");
                    highDefenseGroup.setDnsFastRefreshSwitch(defenseConfigForm.getSwitchToDNSRefresh());
                }
                this.logger.info((Object)("saveDefenseConfig : " + JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{""})));
                if (null == highDefenseGroupInfoExist) {
                    responseJson = !this.isDefenseIndependentAccount() ? RestInvoker.post("/v1/{domain_id}/dpp/groups", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{""}), 2) : RestInvoker.post("/v1/{domain_id}/dpp/groups", JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{""}), 2);
                    this.logger.info((Object)("group add response info : " + responseJson));
                    MyTypeReference typeReference = new MyTypeReference();
                    if (null != responseJson && !"".equals(responseJson)) {
                        Map addGroupResponse = (Map)JSONUtil.getInstance().fromJSON(responseJson, typeReference);
                        defenseConfigForm.setGroupId((String)addGroupResponse.get("groupId"));
                        defenseConfigForm.setCname((String)addGroupResponse.get("cname"));
                        defenseConfig.setGroupId((String)addGroupResponse.get("groupId"));
                        defenseConfig.setCname((String)addGroupResponse.get("cname"));
                    }
                } else {
                    defenseConfigForm.setGroupId(highDefenseGroupInfoExist.getGroupId());
                    defenseConfigForm.setCname(highDefenseGroupInfoExist.getCname());
                    defenseConfig.setGroupId(highDefenseGroupInfoExist.getGroupId());
                    defenseConfig.setCname(highDefenseGroupInfoExist.getCname());
                }
            }
            catch (LegoCheckedException e) {
                this.failToundo(defenseConfigForm);
                throw e;
            }
            catch (IOException e) {
                this.logger.error((Object)"[saveDefenseConfigPage error cause of add [[group]] params to JSON IOException]");
                return;
            }
            try {
                HighDefenseIp highDefenseIp = new HighDefenseIp();
                highDefenseIp.setGroupId(defenseConfig.getGroupId());
                HighDefenseIpNode highDefenseIpNode = new HighDefenseIpNode();
                highDefenseIpNode.setIp(defenseConfigForm.getZoneIp());
                highDefenseIpNode.setBackupIp(defenseConfigForm.getBackIp());
                highDefenseIpNode.setArea(defenseConfigForm.getDeviceArea());
                highDefenseIpNode.setLine(defenseConfigForm.getDeviceLine());
                highDefenseIpNode.setType(4);
                highDefenseIpNode.setUsingStatus(0);
                highDefenseIpNode.setCorrelationId("0");
                highDefenseIpNode.setProjectName(huaweiCloudIdentityForm.getProject());
                ArrayList<HighDefenseIpNode> ipNodeList = new ArrayList<HighDefenseIpNode>();
                ipNodeList.add(highDefenseIpNode);
                highDefenseIp.setIpNodes(ipNodeList);
                this.logger.info((Object)("saveDefenseConfig : " + JSONUtil.getInstance().toJSON((Object)highDefenseIp)));
                responseJson = !this.isDefenseIndependentAccount() ? RestInvoker.post("/v1/{domain_id}/dpp/group/" + defenseConfigForm.getGroupId() + "/ipnodes", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseIp), 2) : RestInvoker.post("/v1/{domain_id}/dpp/group/" + defenseConfigForm.getGroupId() + "/ipnodes", JSONUtil.getInstance().toJSON((Object)highDefenseIp), 2);
                this.logger.info((Object)("ipnode add response info : " + responseJson));
                MyTypeReference typeReference = new MyTypeReference();
                if (null == responseJson || "".equals(responseJson)) break block45;
                Map addIpNodesResponse = (Map)JSONUtil.getInstance().fromJSON(responseJson, typeReference);
                if (null != addIpNodesResponse && addIpNodesResponse.size() > 0) {
                    List ipIdList = (List)addIpNodesResponse.get("ipIdList");
                    if (null != ipIdList && ipIdList.size() > 0) {
                        String ipId = (String)ipIdList.get(0);
                        defenseConfigForm.setIpId(ipId);
                        break block45;
                    }
                    this.logger.error((Object)"[saveDefenseConfigPage error cause of ipIdList is null");
                    throw new LegoCheckedException(7100L);
                }
                this.logger.info((Object)"[saveDefenseConfigPage error cause of ipList is null]");
                throw new LegoCheckedException(7100L);
            }
            catch (IOException e) {
                this.logger.error((Object)"[saveDefenseConfigPage error cause of add [[ipnode]] params to JSON IOException]");
                return;
            }
            catch (LegoCheckedException e) {
                this.failToundo(defenseConfigForm);
                if (null == highDefenseGroupInfoExist) {
                    if (!this.isDefenseIndependentAccount()) {
                        this.deleteGroup(defenseConfigForm.getGroupId(), licenseInfo.getDefenseBindwidth());
                    } else {
                        this.deleteGroup(defenseConfigForm.getGroupId());
                    }
                }
                throw e;
            }
            catch (Exception e) {
                this.logger.error((Object)("[saveDefenseConfigPage error cause of add [[ipnode]] params to JSON IOException]. " + e.getMessage()));
                return;
            }
        }
        try {
            HighDefenseTransferRule highDefenseTransferRule = new HighDefenseTransferRule();
            highDefenseTransferRule.setGroupId(defenseConfig.getGroupId());
            highDefenseTransferRule.setForwardMode(0);
            highDefenseTransferRule.setTcpPort(defenseConfigForm.getTcpPort());
            highDefenseTransferRule.setUdpPort(defenseConfigForm.getUdpPort());
            this.logger.info((Object)("saveDefenseConfig : " + JSONUtil.getInstance().toJSON((Object)highDefenseTransferRule)));
            if (!this.isDefenseIndependentAccount()) {
                RestInvoker.post("/v1/{domain_id}/dpp/group/" + defenseConfigForm.getGroupId() + "/transferrules", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseTransferRule), 2);
            } else {
                RestInvoker.post("/v1/{domain_id}/dpp/group/" + defenseConfigForm.getGroupId() + "/transferrules", JSONUtil.getInstance().toJSON((Object)highDefenseTransferRule), 2);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"[saveDefenseConfigPage error cause of add [[transferrule]] params to JSON IOException]");
            return;
        }
        catch (LegoCheckedException e) {
            this.failToundo(defenseConfigForm);
            if (!this.isDefenseIndependentAccount()) {
                this.deleteIp(defenseConfigForm.getGroupId(), defenseConfigForm.getIpId(), licenseInfo.getDefenseBindwidth());
                if (null == highDefenseGroupInfoExist) {
                    this.deleteGroup(defenseConfigForm.getGroupId(), licenseInfo.getDefenseBindwidth());
                }
            } else {
                this.deleteIp(defenseConfigForm.getGroupId(), defenseConfigForm.getIpId());
                if (null == highDefenseGroupInfoExist) {
                    this.deleteGroup(defenseConfigForm.getGroupId());
                }
            }
            throw e;
        }
        BeanUtils.copyProperties((Object)defenseConfigForm, (Object)defenseConfig);
        defenseConfig.setGroupName(defenseConfigForm.getDomainName());
        if (!this.isDefenseIndependentAccount()) {
            String expirationDateString = defenseConfigForm.getExpirationDateString();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate expirationDate = LocalDate.parse(expirationDateString, dateTimeFormatter);
            defenseConfig.setExpirationDate(expirationDate);
        }
        defenseConfig.setState(4);
        if (!this.isDefenseIndependentAccount()) {
            defenseConfig.setLicenseNumber(licenseInfo.getLicenseNumber());
            defenseConfig.setDeviceLine(defenseConfigForm.getDeviceLine());
        } else {
            defenseConfig.setLicenseNumber("00");
            defenseConfig.setDeviceLine(defenseConfigForm.getDeviceLine());
        }
        defenseConfig.setUpdatedDateTime(LocalDateTime.now());
        defenseConfig.setSwitchToDNSRefresh(defenseConfigForm.getSwitchToDNSRefresh());
        this.defenseConfigDAO.save(defenseConfig);
    }

    @Override
    public boolean isDefenseIndependentAccount() {
        return this.huaweiCloudIdentityService.isAadAccount();
    }

    private void deleteGroup(String groupId, int bandwidth) {
        try {
            RestInvoker.post("/v1/{domain_id}/dpp/groups/delete", bandwidth, "{\"groupIds\": [\"" + groupId + "\"]}", 1);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void deleteGroup(String groupId) {
        try {
            RestInvoker.post("/v1/{domain_id}/dpp/groups/delete", "{\"groupIds\": [\"" + groupId + "\"]}", 1);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void deleteIp(String groupId, String ipId, int bandwidth) {
        try {
            RestInvoker.post("/v1/{domain_id}/dpp/group/" + groupId + "/ipnodes/delete", bandwidth, "{\"ipNodes\": [{\"type\": 4,\"ipId\": \"" + ipId + "\"}]}", 1);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void deleteIp(String groupId, String ipId) {
        try {
            RestInvoker.post("/v1/{domain_id}/dpp/group/" + groupId + "/ipnodes/delete", "{\"ipNodes\": [{\"type\": 4,\"ipId\": \"" + ipId + "\"}]}", 1);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void failToundo(DefenseConfigForm defenseConfigForm) {
        try {
            if (defenseConfigForm.getDeviceId() > 0L) {
                this.defenseConfigCommandService.execUndoCmd(defenseConfigForm);
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    @Override
    public void updateDefenseConfig(DefenseConfigForm defenseConfigForm) {
        DefenseConfigForm defense = this.queryDefenseConfig(defenseConfigForm);
        DefenseConfig defenseConfig = new DefenseConfig();
        LicenseInfo licenseInfo = null;
        HuaweiCloudIdentityForm huaweiCloudIdentityForm = null;
        if (!this.isDefenseIndependentAccount()) {
            licenseInfo = this.licenseManagementService.getLicenseByDeviceId(defenseConfigForm.getDeviceId());
            if (null == licenseInfo) {
                this.logger.error((Object)"updateDefenseConfig licenseInfo is null!");
                throw new LegoCheckedException(6001L);
            }
            huaweiCloudIdentityForm = this.huaweiCloudIdentityService.queryIdentity(licenseInfo.getDefenseBindwidth());
            if (null == huaweiCloudIdentityForm || null == huaweiCloudIdentityForm.getHighDefenseUser()) {
                throw new LegoCheckedException(6001L);
            }
        } else {
            List<HuaweiCloudIdentityForm> huaweiCloudIdentityFormList = this.huaweiCloudIdentityService.getAadUserIdentites();
            if (null != huaweiCloudIdentityFormList && huaweiCloudIdentityFormList.size() != 0) {
                huaweiCloudIdentityForm = huaweiCloudIdentityFormList.get(0);
            }
            if (null == huaweiCloudIdentityForm || null == huaweiCloudIdentityForm.getHighDefenseUser()) {
                throw new LegoCheckedException(6001L);
            }
        }
        try {
            HighDefenseGroup highDefenseGroup = new HighDefenseGroup();
            highDefenseGroup.setGroupId(defense.getGroupId());
            highDefenseGroup.setDomainName(defenseConfigForm.getDomainName());
            highDefenseGroup.setGroupName(defenseConfigForm.getDomainName());
            highDefenseGroup.setSwitchType(defenseConfigForm.getSwitchToOnline());
            if (!this.isDefenseIndependentAccount()) {
                highDefenseGroup.setExpirationDate(defenseConfigForm.getExpirationDateString());
            } else {
                highDefenseGroup.setExpirationDate("2100-01-01");
            }
            highDefenseGroup.setDnsFastRefreshSwitch(defenseConfigForm.getSwitchToDNSRefresh());
            this.logger.info((Object)("updateDefenseConfig  toJSON : " + JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{"bizType"})));
            if (!this.isDefenseIndependentAccount()) {
                RestInvoker.put("/v1/{domain_id}/dpp/groups", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{"bizType"}), 2);
            } else {
                RestInvoker.put("/v1/{domain_id}/dpp/groups", JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{"bizType"}), 2);
            }
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (IOException e) {
            this.logger.error((Object)"[updateDefenseConfig error cause of add [[group]] params to JSON IOException]");
            return;
        }
        try {
            int type = 4;
            HashMap<String, Object> highDefenseIpNode = new HashMap<String, Object>();
            highDefenseIpNode.put("groupId", defense.getGroupId());
            highDefenseIpNode.put("type", type);
            highDefenseIpNode.put("ipId", defense.getIpId());
            highDefenseIpNode.put("line", defenseConfigForm.getDeviceLine());
            highDefenseIpNode.put("area", defenseConfigForm.getDeviceArea());
            highDefenseIpNode.put("backupIp", defenseConfigForm.getBackIp());
            this.logger.info((Object)("updateDefenseConfig : " + JSONUtil.getInstance().toJSON(highDefenseIpNode)));
            if (!this.isDefenseIndependentAccount()) {
                RestInvoker.put("/v1/{domain_id}/dpp/group/" + defense.getGroupId() + "/ipnodes", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON(highDefenseIpNode), 2);
            } else {
                RestInvoker.put("/v1/{domain_id}/dpp/group/" + defense.getGroupId() + "/ipnodes", JSONUtil.getInstance().toJSON(highDefenseIpNode), 2);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"[updateDefenseConfig error cause of add [[ipnode]] params to JSON IOException]");
            return;
        }
        catch (LegoCheckedException e) {
            if (!this.isDefenseIndependentAccount()) {
                this.failToRestoreConfig(defense, licenseInfo, huaweiCloudIdentityForm);
            } else {
                this.failToRestoreConfig(defense, huaweiCloudIdentityForm);
            }
            throw e;
        }
        try {
            HighDefenseTransferRule highDefenseTransferRule = new HighDefenseTransferRule();
            highDefenseTransferRule.setGroupId(defense.getGroupId());
            highDefenseTransferRule.setForwardMode(0);
            highDefenseTransferRule.setTcpPort(defenseConfigForm.getTcpPort());
            highDefenseTransferRule.setUdpPort(defenseConfigForm.getUdpPort());
            this.logger.info((Object)("updateDefenseConfig : " + JSONUtil.getInstance().toJSON((Object)highDefenseTransferRule)));
            if (!this.isDefenseIndependentAccount()) {
                RestInvoker.post("/v1/{domain_id}/dpp/group/" + defense.getGroupId() + "/transferrules", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseTransferRule), 2);
            } else {
                RestInvoker.post("/v1/{domain_id}/dpp/group/" + defense.getGroupId() + "/transferrules", JSONUtil.getInstance().toJSON((Object)highDefenseTransferRule), 2);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"[saveDefenseConfigPage error cause of add [[transferrule]] params to JSON IOException]");
            return;
        }
        catch (LegoCheckedException e) {
            if (!this.isDefenseIndependentAccount()) {
                this.failToRestoreConfig(defense, licenseInfo, huaweiCloudIdentityForm);
                this.failToRestoreIp(defense, licenseInfo);
            } else {
                this.failToRestoreConfig(defense, huaweiCloudIdentityForm);
                this.failToRestoreIp(defense);
            }
            throw e;
        }
        defense.setTcpPort(defenseConfigForm.getTcpPort());
        defense.setUdpPort(defenseConfigForm.getUdpPort());
        defense.setBackIp(defenseConfigForm.getBackIp());
        defense.setDeviceArea(defenseConfigForm.getDeviceArea());
        defense.setSwitchToOnline(defenseConfigForm.getSwitchToOnline());
        defense.setDeviceLine(defenseConfigForm.getDeviceLine());
        defense.setSwitchToOffline(defenseConfigForm.getSwitchToOffline());
        defense.setSwitchToDNSRefresh(defenseConfigForm.getSwitchToDNSRefresh());
        defense.setCompanyName(defenseConfigForm.getCompanyName());
        BeanUtils.copyProperties((Object)defense, (Object)defenseConfig);
        if (!this.isDefenseIndependentAccount()) {
            String expirationDateString = defenseConfigForm.getExpirationDateString();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate expirationDate = LocalDate.parse(expirationDateString, dateTimeFormatter);
            defenseConfig.setExpirationDate(expirationDate);
        }
        defenseConfig.setUpdatedDateTime(LocalDateTime.now());
        this.defenseConfigDAO.update(defenseConfig);
        try {
            if (defenseConfigForm.getDeviceId() > 0L && defense.getSwitchBandwidth() != defenseConfigForm.getSwitchBandwidth()) {
                this.defenseConfigCommandService.execCmd(defenseConfigForm);
            }
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(DEVICE_THRESHOLD_DEPLOY_FAILURE.longValue(), (Throwable)e);
        }
        defenseConfig.setSwitchBandwidth(defenseConfigForm.getSwitchBandwidth());
        this.defenseConfigDAO.update(defenseConfig);
        this.defenseConfigDAO.updateDefenseByDomainName(defenseConfig);
    }

    private void failToRestoreIp(DefenseConfigForm defense, LicenseInfo licenseInfo) {
        int type = 4;
        HashMap<String, Object> highDefenseIpNode = new HashMap<String, Object>();
        highDefenseIpNode.put("groupId", defense.getGroupId());
        highDefenseIpNode.put("type", type);
        highDefenseIpNode.put("ipId", defense.getIpId());
        highDefenseIpNode.put("line", defense.getDeviceLine());
        highDefenseIpNode.put("area", defense.getDeviceArea());
        highDefenseIpNode.put("backupIp", defense.getBackIp());
        try {
            RestInvoker.put("/v1/{domain_id}/dpp/group/" + defense.getGroupId() + "/ipnodes", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON(highDefenseIpNode), 2);
        }
        catch (IOException e) {
            this.logger.error((Object)"failToRestoreIp IOException");
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void failToRestoreIp(DefenseConfigForm defense) {
        int type = 4;
        HashMap<String, Object> highDefenseIpNode = new HashMap<String, Object>();
        highDefenseIpNode.put("groupId", defense.getGroupId());
        highDefenseIpNode.put("type", type);
        highDefenseIpNode.put("ipId", defense.getIpId());
        highDefenseIpNode.put("line", defense.getDeviceLine());
        highDefenseIpNode.put("area", defense.getDeviceArea());
        highDefenseIpNode.put("backupIp", defense.getBackIp());
        try {
            RestInvoker.put("/v1/{domain_id}/dpp/group/" + defense.getGroupId() + "/ipnodes", JSONUtil.getInstance().toJSON(highDefenseIpNode), 2);
        }
        catch (IOException e) {
            this.logger.error((Object)"failToRestoreIp IOException");
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void failToRestoreConfig(DefenseConfigForm defense, LicenseInfo licenseInfo, HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        HighDefenseGroup highDefenseGroup = new HighDefenseGroup();
        highDefenseGroup.setGroupId(defense.getGroupId());
        highDefenseGroup.setDomainName(defense.getDomainName());
        highDefenseGroup.setGroupName(defense.getDomainName());
        highDefenseGroup.setSwitchType(defense.getSwitchToOnline());
        highDefenseGroup.setExpirationDate(defense.getExpirationDateString());
        try {
            RestInvoker.put("/v1/{domain_id}/dpp/groups", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{"bizType"}), 2);
        }
        catch (IOException e) {
            this.logger.error((Object)"failToRestoreConfig IOException");
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void failToRestoreConfig(DefenseConfigForm defense, HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        HighDefenseGroup highDefenseGroup = new HighDefenseGroup();
        highDefenseGroup.setGroupId(defense.getGroupId());
        highDefenseGroup.setDomainName(defense.getDomainName());
        highDefenseGroup.setGroupName(defense.getDomainName());
        highDefenseGroup.setSwitchType(defense.getSwitchToOnline());
        highDefenseGroup.setExpirationDate("2100-01-01");
        try {
            RestInvoker.put("/v1/{domain_id}/dpp/groups", JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{"bizType"}), 2);
        }
        catch (IOException e) {
            this.logger.error((Object)"failToRestoreConfig IOException");
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    @Override
    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        this.logger.info((Object)"DefenseConfigServiceImpl queryByPage ");
        Paging page = this.defenseConfigDAO.queryByPage(conditionMap, start, pageSize);
        List infoList = page.getData();
        ArrayList<DefenseConfigForm> formList = new ArrayList<DefenseConfigForm>();
        if (null != infoList) {
            for (DefenseConfig defenseConfig : infoList) {
                DefenseConfigForm dConfigForm = new DefenseConfigForm();
                AticUtil.copyProperties((Object)defenseConfig, (Object)dConfigForm);
                AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(defenseConfig.getDeviceId());
                if (null != aticDevice) {
                    dConfigForm.setDeviceName(aticDevice.getName());
                } else {
                    dConfigForm.setDeviceName("-");
                }
                formList.add(dConfigForm);
            }
        }
        page.setData(formList);
        return page;
    }

    @Override
    public DefenseConfigForm queryDefenseConfig(DefenseConfigForm defenseConfigForm) {
        DefenseConfig defenseConfig = this.defenseConfigDAO.queryDefenseConfig(defenseConfigForm);
        if (null == defenseConfig) {
            return new DefenseConfigForm();
        }
        DefenseConfigForm defenseConfigFormReturn = new DefenseConfigForm();
        BeanUtils.copyProperties((Object)defenseConfig, (Object)defenseConfigFormReturn);
        if (!this.isDefenseIndependentAccount()) {
            LocalDate expirationDate = defenseConfig.getExpirationDate();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String expirationDateString = df.format(expirationDate);
            defenseConfigFormReturn.setExpirationDateString(expirationDateString);
        }
        return defenseConfigFormReturn;
    }

    @Override
    public Map<Long, List<AticDevice>> queryDeviceByDomain(DefenseConfigForm defenseConfigForm) {
        String endIp;
        HashMap<Long, List<AticDevice>> result = new HashMap<Long, List<AticDevice>>();
        if (StringUtils.isEmpty(defenseConfigForm.getZoneIp()) && StringUtils.isEmpty(defenseConfigForm.getDomainName())) {
            result.put(0L, null);
            return result;
        }
        if (StringUtils.isEmpty(defenseConfigForm.getZoneIp())) {
            result.put(0L, this.defenseConfigDAO.queryDeviceByDomain(defenseConfigForm, null));
            return result;
        }
        String startIp = ZoneReferUtil.getMaskStartIp(defenseConfigForm.getZoneIp(), 32);
        List<ZoneIpForm> zoneIpFormList = this.zoneService.getRepeatIpWithOtherZone(0L, startIp, endIp = ZoneReferUtil.getMaskEndIp(defenseConfigForm.getZoneIp(), 32), true);
        if (null == zoneIpFormList || zoneIpFormList.isEmpty()) {
            result.put(0L, new ArrayList());
            return result;
        }
        ZoneIpForm zoneIpForm = zoneIpFormList.get(0);
        ZonePolicyApplyForm zonePolicyApplyForm = this.zonePolicyApplyService.queryByZoneId(zoneIpForm.getZoneId());
        if (null == zonePolicyApplyForm || null == zonePolicyApplyForm.getDeployState() || !zonePolicyApplyForm.getDeployState().equals("SUCCESS")) {
            result.put(0L, new ArrayList());
            return result;
        }
        List list = this.aticDeviceService.getDeviceByZoneId(zonePolicyApplyForm.getZoneId().longValue(), defenseConfigForm.getCurUserId());
        if (list.size() == 0) {
            result.put(zonePolicyApplyForm.getZoneId(), list);
            return result;
        }
        List<AticDevice> byDomainlist = null;
        byDomainlist = !this.isDefenseIndependentAccount() ? this.defenseConfigDAO.queryDeviceByDomain(defenseConfigForm, list) : this.defenseConfigDAO.filterDevicesByUserId(defenseConfigForm, list);
        result.put(zonePolicyApplyForm.getZoneId(), byDomainlist);
        return result;
    }

    @Override
    public boolean queryIpExist(DefenseConfigForm defenseConfigForm) {
        return this.defenseConfigDAO.queryIpExist(defenseConfigForm);
    }

    @Override
    public boolean queryBackupIpExist(DefenseConfigForm defenseConfigForm) {
        return this.defenseConfigDAO.queryBackupIpExist(defenseConfigForm);
    }

    @Override
    public boolean queryIpCountWithDevice(DefenseConfigForm defenseConfigForm) {
        return this.defenseConfigDAO.queryIpCountWithDevice(defenseConfigForm);
    }

    @Override
    public boolean queryIpCountWithDefenseIndependAccount() {
        return this.defenseConfigDAO.queryIpCountWithDefenseIndependAccount();
    }

    @Override
    public void updateDefenseState(DefenseConfigForm dConfigForm) {
        this.logger.info((Object)("updateDefenseState is " + dConfigForm.toString()));
        this.defenseConfigDAO.updateDefenseState(dConfigForm.getId(), dConfigForm.getState(), dConfigForm.getUpdatedDateTime());
    }

    @Override
    public boolean concurOnlineDefenseCheck(long deviceId) {
        List<DefenseConfig> configs = this.defenseConfigDAO.getOnlineDefenseByDeviceId(deviceId);
        return null == configs || configs.size() <= 0;
    }

    @Override
    public boolean concurOnlineDefenseCheckByDevIp(String deviceIp) {
        boolean checkConCur = false;
        if (StringUtils.isEmpty(deviceIp)) {
            this.logger.error((Object)"deviceIp is null");
            return false;
        }
        AticDevice device = this.aticDeviceDao.getDeviceByIp(deviceIp);
        if (device != null) {
            checkConCur = this.concurOnlineDefenseCheck(device.getMoId());
        } else {
            checkConCur = false;
            this.logger.error((Object)"device is null");
        }
        return checkConCur;
    }

    @Override
    public List<DefenseConfigForm> queryAllOnOrOffLine(boolean isOnLine) {
        ArrayList<DefenseConfigForm> defenseConfigForms = new ArrayList<DefenseConfigForm>();
        List<DefenseConfig> defenseConfigs = this.defenseConfigDAO.queryAllOnOrOffLine(isOnLine);
        if (null != defenseConfigs && defenseConfigs.size() > 0) {
            this.queryBindWidth(defenseConfigForms, defenseConfigs);
        }
        return defenseConfigForms;
    }

    @Override
    public List<DefenseConfigForm> queryDefenseConfigsByIp(Map<String, String> conditionMap) {
        ArrayList<DefenseConfigForm> defenseConfigForms = new ArrayList<DefenseConfigForm>();
        List<DefenseConfig> defenseConfigs = this.defenseConfigDAO.queryDefenseConfigsByIp(conditionMap);
        if (null != defenseConfigs && defenseConfigs.size() > 0) {
            this.queryBindWidth(defenseConfigForms, defenseConfigs);
        }
        return defenseConfigForms;
    }

    @Override
    public List<DefenseConfigForm> queryDefenseConfigsByZoneIp(String ips) {
        ArrayList<DefenseConfigForm> defenseConfigForms = new ArrayList<DefenseConfigForm>();
        List<DefenseConfig> defenseConfigs = this.defenseConfigDAO.queryDefenseConfigsByZoneIp(ips);
        if (null != defenseConfigs && defenseConfigs.size() > 0) {
            this.queryBindWidth(defenseConfigForms, defenseConfigs);
        }
        return defenseConfigForms;
    }

    private void queryBindWidth(List<DefenseConfigForm> defenseConfigForms, List<DefenseConfig> defenseConfigs) {
        for (DefenseConfig defenseConfig : defenseConfigs) {
            LicenseInfoModel lInfoModel;
            DefenseConfigForm dConfigForm = new DefenseConfigForm();
            AticUtil.copyProperties((Object)defenseConfig, (Object)dConfigForm);
            AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(defenseConfig.getDeviceId());
            if (null != aticDevice) {
                dConfigForm.setDeviceIp(aticDevice.getIpAddress());
                dConfigForm.setDeviceName(aticDevice.getName());
            }
            if (!this.isDefenseIndependentAccount() && null != (lInfoModel = this.licenseDao.getLicenseByDeviceId(defenseConfig.getDeviceId()))) {
                dConfigForm.setDefenseBindwidth(lInfoModel.getDefenseBindwidth());
            }
            defenseConfigForms.add(dConfigForm);
        }
    }

    @Override
    public List<DefenseConfigForm> getOnlineDenfenseState() {
        this.logger.info((Object)"getOnlineDenfenseState start.");
        ArrayList<DefenseConfigForm> needSwitchDefenses = new ArrayList<DefenseConfigForm>();
        List<DefenseConfigForm> needCheckDefenseFroms = this.queryAllOnOrOffLine(true);
        for (DefenseConfigForm form : needCheckDefenseFroms) {
            int dbStatus = form.getState();
            try {
                if (3 == form.getState() || 5 == form.getState() || 9 == form.getState()) continue;
                String url = "/v1/{domain_id}/dpp/ipnodes/" + form.getIpId() + "/aad-ip-status";
                HashMap<String, Object> params = new HashMap<String, Object>();
                this.logger.info((Object)"init url success");
                String result = "";
                result = !this.isDefenseIndependentAccount() ? RestInvoker.get(url, form.getDefenseBindwidth(), params, 3) : RestInvoker.get(url, params, 3);
                this.logger.info((Object)(form.getZoneIp() + ",getOnlineDenfenseState result is  " + result));
                MyTypeReference resultJson = new MyTypeReference();
                Map map = (Map)JSONUtil.getInstance().fromJSON(result, resultJson);
                if (null == map.get("status")) continue;
                int status = Integer.parseInt(String.valueOf(map.get("status")));
                long attackFlowKbps = Long.parseLong(String.valueOf(map.get("attackFlowKbps")));
                this.logger.info((Object)("getOnlineDenfenseState result status, " + status + " ;attackFlowKbps, " + attackFlowKbps + "database status" + form.getState()));
                if (0 == status) {
                    if (dbStatus != 0 && dbStatus != 2) {
                        form.setUpdatedDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
                    } else {
                        needSwitchDefenses.add(form);
                    }
                } else if (2 == status && attackFlowKbps <= form.getSwitchBandwidth() * 1000L) {
                    if (dbStatus != 0 && dbStatus != 2) {
                        form.setUpdatedDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
                    } else {
                        needSwitchDefenses.add(form);
                    }
                } else {
                    form.setUpdatedDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
                }
                form.setState(status);
                this.logger.info((Object)("update database defense form info, " + form.toString()));
                this.updateDefenseState(form);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("Defense restfull.getOnlineDenfenseState failed ," + e.getMessage()));
            }
            catch (Exception e) {
                this.logger.error((Object)("Defense restfull.json Conversion failed ," + e.getMessage()));
            }
        }
        this.logger.info((Object)"getOnlineDenfenseState end.");
        return needSwitchDefenses;
    }

    public String getCurrUserName() {
        ActionContext ctx = ActionContext.getContext();
        if (null == ctx) {
            return "";
        }
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        this.logger.info((Object)"get current log User success ");
        return currentUser.getUserName();
    }

    public String getCurrUserIp() {
        ActionContext ctx = ActionContext.getContext();
        if (null == ctx) {
            return "";
        }
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        this.logger.info((Object)"get current log User success ");
        return currentUser.getIpAdr();
    }

    @Override
    public Boolean switchToOffline(List<DefenseConfigForm> defenseConfigForms, int type) {
        this.logger.info((Object)"switchToOffline start ...");
        boolean switchResult = true;
        this.switchAutomaticAndBack(defenseConfigForms);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("switchToOffline InterruptedException :" + e.getMessage()));
        }
        String module = "lego.fault.severity.rule.diversion.cloud";
        String target = "atic.bis.online.offline.Defense.config.title";
        String operation = "atic.bis.online.offline.Defense.switch.offline";
        String detail = "atic.bis.online.offline.Defense.log.offline.details.success";
        for (DefenseConfigForm configForm : defenseConfigForms) {
            String[] detailPara;
            String successIps = "--";
            DefenseSwitchHistory switchHistory = new DefenseSwitchHistory();
            boolean switchSuccess = false;
            for (int i = 0; i < 3 && !switchSuccess; ++i) {
                switchSuccess = this.cutBackHighDefense(configForm, switchHistory);
                try {
                    if (switchSuccess) continue;
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("cutBackHighDefense InterruptedException :" + e.getMessage()));
                }
            }
            String operator = "system";
            String terminalIp = "127.0.0.1";
            if (0 == type) {
                operator = this.getCurrUserName();
                terminalIp = this.getCurrUserIp();
            }
            if (switchSuccess) {
                switchHistory.setState(0);
                configForm.setState(4);
                configForm.setUpdatedDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
                this.logger.info((Object)("switchToOffline.Defense status.update success," + configForm.toString()));
                this.updateDefenseState(configForm);
                if (!AticUtil.isNull((String)configForm.getZoneIp())) {
                    successIps = configForm.getZoneIp();
                }
                detailPara = new String[]{successIps};
                this.batchRsult(true, module, target, detail, operation, detailPara, operator, terminalIp);
            } else {
                switchResult = false;
                switchHistory.setState(1);
                detailPara = new String[]{configForm.getZoneIp(), switchHistory.getDetail()};
                detail = "atic.bis.online.offline.Defense.log.offline.details.fail";
                this.batchRsult(false, module, target, detail, operation, detailPara, operator, terminalIp);
            }
            switchHistory.setSwitchIp(configForm.getZoneIp());
            switchHistory.setBackIp(configForm.getBackIp());
            if (this.isDefenseIndependentAccount()) {
                switchHistory.setLicenseNumber("00");
            } else {
                switchHistory.setLicenseNumber(configForm.getLicenseNumber());
            }
            switchHistory.setSwitchType(type);
            switchHistory.setSwitchDirection(2);
            switchHistory.setSwitchDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
            switchHistory.setOperator(operator);
            switchHistory.setDeviceName(configForm.getDeviceName());
            this.logger.info((Object)("switchToOffline switchHistory : " + switchHistory.toString()));
            this.defenseSwitchHistoryDAO.save(switchHistory);
        }
        this.logger.info((Object)"switchToOffline end...");
        return switchResult;
    }

    private boolean cutBackHighDefense(DefenseConfigForm configForm, DefenseSwitchHistory switchHistory) {
        this.logger.info((Object)("cutBackHighDefense start," + configForm.toString()));
        String detail = "";
        boolean switchSuccess = false;
        try {
            String result = "";
            result = !this.isDefenseIndependentAccount() ? RestInvoker.post("/v1/{domain_id}/dpp/ipnodes/" + configForm.getIpId() + "/aad-defense-stop", configForm.getDefenseBindwidth(), "{}", 3) : RestInvoker.post("/v1/{domain_id}/dpp/ipnodes/" + configForm.getIpId() + "/aad-defense-stop", "{}", 3);
            this.logger.info((Object)("cutBackHighDefense cutBack, result is  " + result));
            switchSuccess = true;
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("defense restfull.cutBackHighDefense failed, " + e.getMessage()));
            if (7100L == e.getErrorCode()) {
                long errorCode = this.interceptErrorCode(e.getMessage());
                if (5182L == errorCode || 5183L == errorCode) {
                    switchSuccess = true;
                } else {
                    detail = this.queryDetailByErrcode("defense.err.", errorCode);
                }
            } else {
                detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("defense restfull.cutBackHighDefense json Conversion failed, " + e.getMessage()));
            detail = "defense.err.50001";
        }
        this.logger.info((Object)("cutBackHighDefense end," + detail));
        switchHistory.setDetail(detail);
        return switchSuccess;
    }

    @Override
    public void switchAutomaticAndBack(List<DefenseConfigForm> defenseConfigForms) {
        this.logger.info((Object)"switchAutomaticAndBack start");
        HashMap needCheckMap = new HashMap();
        for (DefenseConfigForm defenseConfigForm : defenseConfigForms) {
            if (null != needCheckMap.get(defenseConfigForm.getDefenseBindwidth())) {
                ((List)needCheckMap.get(defenseConfigForm.getDefenseBindwidth())).add(defenseConfigForm);
                continue;
            }
            ArrayList<DefenseConfigForm> temp = new ArrayList<DefenseConfigForm>();
            temp.add(defenseConfigForm);
            needCheckMap.put(defenseConfigForm.getDefenseBindwidth(), temp);
        }
        for (Map.Entry entry : needCheckMap.entrySet()) {
            try {
                ArrayList<String> zoneIps = new ArrayList<String>();
                for (DefenseConfigForm form : (List)entry.getValue()) {
                    zoneIps.add(form.getZoneIp());
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("ipType", "1");
                params.put("ip", zoneIps);
                params.put("type", "unblock");
                String bodyJson = JSONUtil.getInstance().toJSON(params);
                if (!this.isDefenseIndependentAccount()) {
                    RestInvoker.post("/v1/{domain_id}/dpp/ipnodes/aad-defense", (Integer)entry.getKey(), bodyJson, 3);
                    continue;
                }
                RestInvoker.post("/v1/{domain_id}/dpp/ipnodes/aad-defense", bodyJson, 3);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("restfull.switchAutomaticAndBack failed ," + e.getMessage()));
            }
            catch (Exception e) {
                this.logger.error((Object)("restfull.switchAutomaticAndBack json Conversion failed ," + e.getMessage()));
            }
        }
    }

    @Override
    public void recoveryDefenseConfig(DefenseConfigForm defenseConfigForm) {
        HighDefenseGroupInfo highDefenseGroupInfoExist;
        HuaweiCloudIdentityForm huaweiCloudIdentityForm;
        String responseJson;
        LicenseInfo licenseInfo;
        DefenseConfig defenseConfig;
        DefenseConfigForm defense;
        block25: {
            defense = this.queryDefenseConfig(defenseConfigForm);
            this.defenseConfigCommandService.execCmd(defense);
            defenseConfig = new DefenseConfig();
            licenseInfo = this.licenseManagementService.getLicenseByDeviceId(defense.getDeviceId());
            if (null == licenseInfo) {
                this.logger.error((Object)"recoveryDefenseConfig licenseInfo is null!");
                this.failToundo(defense);
                throw new LegoCheckedException(6001L);
            }
            responseJson = "";
            huaweiCloudIdentityForm = this.huaweiCloudIdentityService.queryIdentity(licenseInfo.getDefenseBindwidth());
            if (null == huaweiCloudIdentityForm || null == huaweiCloudIdentityForm.getHighDefenseUser()) {
                this.failToundo(defense);
                throw new LegoCheckedException(6001L);
            }
            highDefenseGroupInfoExist = null;
            try {
                String responseGroupJson = RestInvoker.get("/v1/{domain_id}/dpp/groups", licenseInfo.getDefenseBindwidth(), null, 1);
                HighDefenseGroups highDefenseGroups = null;
                if (null != responseGroupJson) {
                    this.logger.info((Object)("[responseGroupJson] : " + responseGroupJson));
                    highDefenseGroups = (HighDefenseGroups)JSONUtil.getInstance().fromJSON(responseGroupJson, HighDefenseGroups.class);
                }
                if (null == highDefenseGroups || null == highDefenseGroups.getGroups()) break block25;
                List<HighDefenseGroupInfo> groups = highDefenseGroups.getGroups();
                for (HighDefenseGroupInfo groupInfo : groups) {
                    if (null == groupInfo || null == groupInfo.getGroupName() || !groupInfo.getGroupName().equalsIgnoreCase(defenseConfigForm.getDomainName())) continue;
                    highDefenseGroupInfoExist = groupInfo;
                    this.logger.info((Object)("[highDefenseGroupExist exist] : " + highDefenseGroupInfoExist.getGroupId() + ", " + highDefenseGroupInfoExist.getGroupName()));
                    break;
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"recoveryDefenseConfig IOException");
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        try {
            HighDefenseGroup highDefenseGroup = new HighDefenseGroup();
            highDefenseGroup.setGroupId(defense.getGroupId());
            highDefenseGroup.setDomainName(defense.getDomainName());
            highDefenseGroup.setUname(huaweiCloudIdentityForm.getHighDefenseUser());
            highDefenseGroup.setGroupName(defense.getDomainName());
            highDefenseGroup.setSwitchType(defense.getSwitchToOnline());
            highDefenseGroup.setExpirationDate(defense.getExpirationDateString());
            highDefenseGroup.setCname(defense.getCname());
            this.logger.info((Object)("recoveryDefenseConfig : " + JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{""})));
            if (null == highDefenseGroupInfoExist) {
                responseJson = RestInvoker.post("/v1/{domain_id}/dpp/groups", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseGroup, new String[]{""}), 2);
                this.logger.info((Object)("group add response info : " + responseJson));
                MyTypeReference typeReference = new MyTypeReference();
                Map addGroupResponse = (Map)JSONUtil.getInstance().fromJSON(responseJson, typeReference);
                defense.setGroupId((String)addGroupResponse.get("groupId"));
                defense.setCname((String)addGroupResponse.get("cname"));
                defenseConfigForm.setGroupId((String)addGroupResponse.get("groupId"));
                defenseConfigForm.setCname((String)addGroupResponse.get("cname"));
                defenseConfig.setGroupId((String)addGroupResponse.get("groupId"));
                defenseConfig.setCname((String)addGroupResponse.get("cname"));
            } else {
                defense.setGroupId(highDefenseGroupInfoExist.getGroupId());
                defense.setCname(highDefenseGroupInfoExist.getCname());
                defenseConfigForm.setGroupId(highDefenseGroupInfoExist.getGroupId());
                defenseConfigForm.setCname(highDefenseGroupInfoExist.getCname());
                defenseConfig.setGroupId(highDefenseGroupInfoExist.getGroupId());
                defenseConfig.setCname(highDefenseGroupInfoExist.getCname());
            }
        }
        catch (LegoCheckedException e) {
            this.failToundo(defense);
            throw e;
        }
        catch (IOException e) {
            this.logger.error((Object)"[recoveryDefenseConfig error cause of add [[group]] params to JSON IOException]");
            return;
        }
        try {
            List ipIdList;
            HighDefenseIp highDefenseIp = new HighDefenseIp();
            highDefenseIp.setGroupId(defense.getGroupId());
            HighDefenseIpNode highDefenseIpNode = new HighDefenseIpNode();
            highDefenseIpNode.setIp(defense.getZoneIp());
            highDefenseIpNode.setBackupIp(defense.getBackIp());
            highDefenseIpNode.setArea(defense.getDeviceArea());
            highDefenseIpNode.setLine(defense.getDeviceLine());
            highDefenseIpNode.setType(4);
            highDefenseIpNode.setUsingStatus(0);
            highDefenseIpNode.setCorrelationId("0");
            highDefenseIpNode.setProjectName(huaweiCloudIdentityForm.getProject());
            ArrayList<HighDefenseIpNode> ipNodeList = new ArrayList<HighDefenseIpNode>();
            ipNodeList.add(highDefenseIpNode);
            highDefenseIp.setIpNodes(ipNodeList);
            this.logger.info((Object)("recoveryDefenseConfig : " + JSONUtil.getInstance().toJSON((Object)highDefenseIp)));
            responseJson = RestInvoker.post("/v1/{domain_id}/dpp/group/" + defense.getGroupId() + "/ipnodes", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseIp), 2);
            this.logger.info((Object)("ipnode recovery response info : " + responseJson));
            MyTypeReference typeReference = new MyTypeReference();
            Map addIpNodesResponse = (Map)JSONUtil.getInstance().fromJSON(responseJson, typeReference);
            if (null != addIpNodesResponse && addIpNodesResponse.containsKey("ipIdList")) {
                ipIdList = (List)addIpNodesResponse.get("ipIdList");
                if (null == ipIdList || ipIdList.size() <= 0) {
                    this.logger.error((Object)"[recoveryDefenseConfig error cause of ipIdList is null");
                    throw new LegoCheckedException(7100L);
                }
            } else {
                this.logger.error((Object)"[recoveryDefenseConfig error cause of addIpNodesResponse is null");
                throw new LegoCheckedException(7100L);
            }
            String ipId = (String)ipIdList.get(0);
            defenseConfigForm.setIpId(ipId);
            defenseConfig.setIpId(ipId);
        }
        catch (IOException e) {
            this.logger.error((Object)"[recoveryDefenseConfig error cause of add [[ipnode]] params to JSON IOException]");
            return;
        }
        catch (LegoCheckedException e) {
            this.failToundo(defense);
            if (null == highDefenseGroupInfoExist) {
                this.deleteGroup(defense.getGroupId(), licenseInfo.getDefenseBindwidth());
            }
            throw e;
        }
        try {
            HighDefenseTransferRule highDefenseTransferRule = new HighDefenseTransferRule();
            highDefenseTransferRule.setGroupId(defense.getGroupId());
            highDefenseTransferRule.setForwardMode(0);
            highDefenseTransferRule.setTcpPort(defense.getTcpPort());
            highDefenseTransferRule.setUdpPort(defense.getUdpPort());
            this.logger.info((Object)("recoveryDefenseConfig : " + JSONUtil.getInstance().toJSON((Object)highDefenseTransferRule)));
            RestInvoker.post("/v1/{domain_id}/dpp/group/" + defense.getGroupId() + "/transferrules", licenseInfo.getDefenseBindwidth(), JSONUtil.getInstance().toJSON((Object)highDefenseTransferRule), 2);
        }
        catch (IOException e) {
            this.logger.error((Object)"[recoveryDefenseConfig error cause of add [[transferrule]] params to JSON IOException]");
            return;
        }
        catch (LegoCheckedException e) {
            this.failToundo(defense);
            this.deleteIp(defense.getGroupId(), defense.getIpId(), licenseInfo.getDefenseBindwidth());
            if (null == highDefenseGroupInfoExist) {
                this.deleteGroup(defense.getGroupId(), licenseInfo.getDefenseBindwidth());
            }
            throw e;
        }
        BeanUtils.copyProperties((Object)defense, (Object)defenseConfig);
        String expirationDateString = licenseInfo.getExpirationDate();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate expirationDate = LocalDate.parse(expirationDateString, dateTimeFormatter);
        defenseConfig.setExpirationDate(expirationDate);
        defenseConfig.setUpdatedDateTime(LocalDateTime.now());
        defenseConfig.setIpId(defenseConfigForm.getIpId());
        this.defenseConfigDAO.update(defenseConfig);
    }

    @Override
    public Map<String, String> switchToOnline(DefenseConfigForm configForm) {
        this.logger.info((Object)("switchToOnline start," + configForm.toString()));
        boolean checkResult = false;
        DefenseSwitchHistory switchHistory = new DefenseSwitchHistory();
        HashMap<String, String> errorInfo = null;
        String detail = "";
        try {
            String bodyJson = "{\"groupId\": \"" + configForm.getGroupId() + "\"}";
            String result = "";
            result = this.isDefenseIndependentAccount() ? RestInvoker.post("/v1/{domain_id}/dpp/ipnodes/" + configForm.getIpId() + "/aad-defense-start", bodyJson, 3) : RestInvoker.post("/v1/{domain_id}/dpp/ipnodes/" + configForm.getIpId() + "/aad-defense-start", configForm.getDefenseBindwidth(), bodyJson, 3);
            this.logger.info((Object)("switchToOnline result is " + result));
            checkResult = true;
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("defense restfull.switchToOnline failed, " + e.getMessage()));
            if (7100L == e.getErrorCode()) {
                long errorCode = this.interceptErrorCode(e.getMessage());
                if (5172L == errorCode) {
                    checkResult = true;
                } else {
                    detail = this.queryDetailByErrcode("defense.err.", errorCode);
                }
            } else {
                detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("defense restfull.switchToOnline failed, " + e.getMessage()));
            detail = "defense.err.50001";
        }
        if (checkResult) {
            switchHistory.setState(0);
            configForm.setState(0);
            configForm.setUpdatedDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
            this.logger.debug((Object)("switchToOnline.Defense status.update success," + configForm.toString()));
            this.updateDefenseState(configForm);
        } else {
            switchHistory.setState(1);
            errorInfo = new HashMap<String, String>();
            errorInfo.put(configForm.getZoneIp(), detail);
        }
        switchHistory.setDetail(detail);
        switchHistory.setSwitchIp(configForm.getZoneIp());
        switchHistory.setBackIp(configForm.getBackIp());
        if (this.isDefenseIndependentAccount()) {
            switchHistory.setLicenseNumber("00");
        } else {
            switchHistory.setLicenseNumber(configForm.getLicenseNumber());
        }
        switchHistory.setSwitchType(0);
        switchHistory.setSwitchDirection(1);
        switchHistory.setSwitchDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
        switchHistory.setOperator(this.getCurrUserName());
        switchHistory.setDeviceName(configForm.getDeviceName());
        this.logger.info((Object)("switchToOnline switchHistory : " + switchHistory.toString()));
        this.defenseSwitchHistoryDAO.save(switchHistory);
        this.logger.info((Object)("switchToOnline end,result is " + checkResult));
        return errorInfo;
    }

    @Override
    public void switchAutomaticAndBlock(DefenseConfigForm configForm) {
        this.logger.info((Object)("switchAutomaticAndBlock start type is block defenseConfig Size " + configForm.toString()));
        DefenseSwitchHistory switchHistory = new DefenseSwitchHistory();
        String detail = "";
        try {
            ArrayList<String> zoneIps = new ArrayList<String>();
            zoneIps.add(configForm.getZoneIp());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ipType", "1");
            params.put("ip", zoneIps);
            params.put("type", "block");
            String bodyJson = JSONUtil.getInstance().toJSON(params);
            if (this.isDefenseIndependentAccount()) {
                RestInvoker.post("/v1/{domain_id}/dpp/ipnodes/aad-defense", bodyJson, 3);
            } else {
                RestInvoker.post("/v1/{domain_id}/dpp/ipnodes/aad-defense", configForm.getDefenseBindwidth(), bodyJson, 3);
            }
            switchHistory.setState(3);
            configForm.setState(3);
            configForm.setUpdatedDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
            this.updateDefenseState(configForm);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("defense restfull.switchAutomaticAndBlock failed, " + e.getMessage()));
            if (7100L == e.getErrorCode()) {
                long errorCode = this.interceptErrorCode(e.getMessage());
                detail = this.queryDetailByErrcode("defense.err.", errorCode);
            } else {
                detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
            }
            switchHistory.setState(1);
        }
        catch (Exception e) {
            this.logger.error((Object)("defense restfull.switchAutomaticAndBlock failed, " + e.getMessage()));
            switchHistory.setState(1);
            detail = "defense.err.50001";
        }
        switchHistory.setSwitchIp(configForm.getZoneIp());
        switchHistory.setBackIp(configForm.getBackIp());
        if (this.isDefenseIndependentAccount()) {
            switchHistory.setLicenseNumber("00");
        } else {
            switchHistory.setLicenseNumber(configForm.getLicenseNumber());
        }
        switchHistory.setDetail(detail);
        switchHistory.setSwitchType(1);
        switchHistory.setSwitchDirection(1);
        switchHistory.setSwitchDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
        switchHistory.setOperator("system");
        switchHistory.setDeviceName(configForm.getDeviceName());
        this.logger.info((Object)("switchToOnline switchAutomaticAndBlock : " + switchHistory.toString()));
        this.defenseSwitchHistoryDAO.save(switchHistory);
        this.logger.info((Object)"switchAutomaticAndBlock end...");
    }

    @Override
    public boolean checkAdvancedIpSwitchState(DefenseConfigForm configForm, DefenseSwitchHistory switchHistory) {
        this.logger.info((Object)("checkAdvancedIpSwitchState start type is block defenseConfig Size " + configForm.toString()));
        boolean retState = false;
        String detail = "";
        try {
            String result = "";
            result = this.isDefenseIndependentAccount() ? RestInvoker.get("/v1/{domain_id}/dpp/ipnodes/status?ip=" + configForm.getZoneIp(), null, 3) : RestInvoker.get("/v1/{domain_id}/dpp/ipnodes/status?ip=" + configForm.getZoneIp(), configForm.getDefenseBindwidth(), null, 3);
            this.logger.info((Object)("get dpp ipnodes status info : " + result));
            MyTypeReference typeReference = new MyTypeReference();
            Map dppIpnodesResponse = (Map)JSONUtil.getInstance().fromJSON(result, typeReference);
            if (null != dppIpnodesResponse.get("ipStatus")) {
                int ipStatus = Integer.parseInt(String.valueOf(dppIpnodesResponse.get("ipStatus")));
                if (0 == ipStatus) {
                    retState = true;
                } else {
                    detail = "defense.err.50003";
                }
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("defense restfull.checkAdvancedIpSwitchState failed, " + e.getMessage()));
            if (7100L == e.getErrorCode()) {
                long errorCode = this.interceptErrorCode(e.getMessage());
                detail = this.queryDetailByErrcode("defense.err.", errorCode);
            } else {
                detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("defense restfull.checkAdvancedIpSwitchState failed, " + e.getMessage()));
            detail = "defense.err.50001";
        }
        switchHistory.setDetail(detail);
        this.logger.info((Object)"checkAdvancedIpSwitchState end...");
        return retState;
    }

    public void deleteDefenseIp(DefenseConfig defenseConfig, int defenseBindwidth) {
        this.deleteHighDefenseIp(defenseConfig, defenseBindwidth);
        this.undoSwitchBandwidth(defenseConfig.getDeviceId(), defenseConfig.getSwitchBandwidth(), defenseConfig.getZoneIp());
        this.defenseConfigDAO.delete(defenseConfig);
    }

    private String deleteHighDefenseIp(DefenseConfig defenseConfig, int defenseBindwidth) {
        this.logger.info((Object)"deleteHighDefenseIp start ...");
        String url = "/v1/{domain_id}/dpp/group/" + defenseConfig.getGroupId() + "/ipnodes/delete";
        String bodyJson = "{\r\n\"ipNodes\":[{\r\n\"type\":4,\"ipId\":\"" + defenseConfig.getIpId() + "\"\r\n}]\r\n}";
        String result = RestInvoker.post(url, defenseBindwidth, bodyJson, 3);
        this.logger.info((Object)("deleteHighDefenseIp end,result:" + result));
        return result;
    }

    private String deleteHighDefenseIp(DefenseConfig defenseConfig) {
        this.logger.info((Object)"deleteHighDefenseIp start ...");
        String url = "/v1/{domain_id}/dpp/group/" + defenseConfig.getGroupId() + "/ipnodes/delete";
        String bodyJson = "{\r\n\"ipNodes\":[{\r\n\"type\":4,\"ipId\":\"" + defenseConfig.getIpId() + "\"\r\n}]\r\n}";
        String result = RestInvoker.post(url, bodyJson, 3);
        this.logger.info((Object)("deleteHighDefenseIp end,result:" + result));
        return result;
    }

    private String deleteHighDefenseGroup(List<String> groupIds, int defenseBindwidth) {
        this.logger.info((Object)"deleteHighDefenseGroupId start ...");
        String url = "/v1/{domain_id}/dpp/groups/delete";
        String groupIdsStr = groupIds.toString();
        String listStr = groupIdsStr.substring(1, groupIdsStr.length() - 1).replace(", ", "\",\"");
        String bodyJson = "{\"groupIds\": [\"" + listStr + "\"]}";
        String result = RestInvoker.post(url, defenseBindwidth, bodyJson, 3);
        this.logger.info((Object)("deleteHighDefenseGroup end ...result = " + result));
        return result;
    }

    private String deleteHighDefenseGroup(List<String> groupIds) {
        this.logger.info((Object)"deleteHighDefenseGroupId start ...");
        String url = "/v1/{domain_id}/dpp/groups/delete";
        String groupIdsStr = groupIds.toString();
        String listStr = groupIdsStr.substring(1, groupIdsStr.length() - 1).replace(", ", "\",\"");
        String bodyJson = "{\"groupIds\": [\"" + listStr + "\"]}";
        String result = RestInvoker.post(url, bodyJson, 3);
        this.logger.info((Object)("deleteHighDefenseGroup end ...result = " + result));
        return result;
    }

    private String modifyDefenseGroupExpirationDate(DefenseConfig dg, int defenseBindwidth, String expirationDate) {
        this.logger.info((Object)"modifyDefenseGroupExpirationDate start ...");
        String url = "/v1/{domain_id}/dpp/groups";
        String bodyJson = "{\"groupId\": \"" + dg.getGroupId() + "\",\r\n    \"groupName\": \"" + dg.getDomainName() + "\",\r\n    \"groupDesc\": \"\",\r\n    \"type\": 1,\r\n    \"dispatchType\": 0,\r\n    \"switchType\": " + dg.getSwitchToOnline() + ",\r\n    \"notifyURL\": \"\",\r\n    \"shareKey\": \"\",\r\n    \"escapeTimes\": 1,\r\n    \"selectMode\": 1,\r\n    \"dnsFastRefreshSwitch\": 0,\r\n    \"domainName\": \"" + dg.getDomainName() + "\"\r\n    \"expirationDate\": \"" + expirationDate + "\"}";
        String result = "";
        result = !this.isDefenseIndependentAccount() ? RestInvoker.put(url, defenseBindwidth, bodyJson, 3) : RestInvoker.put(url, bodyJson, 3);
        this.logger.info((Object)"modifyDefenseGroupExpirationDate end ...");
        return result;
    }

    @Override
    public String deleteDefenseConfig(String licenseNumber, int defenseBindwidth) {
        this.logger.info((Object)"deleteDefenseConfig begin");
        List<DefenseConfig> list = this.defenseConfigDAO.getDefenseConfigsByLicenseNumber(licenseNumber);
        if (null == list || list.isEmpty()) {
            this.logger.info((Object)"deleteDefenseConfig:list is null");
            return "ok";
        }
        HashMap<String, DefenseConfigForm> map = new HashMap<String, DefenseConfigForm>(5);
        DefenseConfigForm dConfigForm = null;
        for (DefenseConfig defenseConfig : list) {
            dConfigForm = new DefenseConfigForm();
            AticUtil.copyProperties((Object)defenseConfig, (Object)dConfigForm);
            map.put(defenseConfig.getDomainName(), dConfigForm);
            this.deleteDefenseIp(defenseConfig, defenseBindwidth);
        }
        Set set = map.entrySet();
        ArrayList<String> groupIds = new ArrayList<String>(5);
        for (Map.Entry entry : set) {
            if (null != this.defenseConfigDAO.getDefenseConfigsByDomainName((String)entry.getKey())) continue;
            groupIds.add(((DefenseConfigForm)entry.getValue()).getGroupId());
        }
        if (!groupIds.isEmpty()) {
            this.deleteHighDefenseGroup(groupIds, defenseBindwidth);
        }
        this.logger.info((Object)"deleteDefenseConfig end");
        return "ok";
    }

    @Override
    public String updateDefenseConfig(String licenseNumber, int defenseBindwidth, long ddosDeviceId, String expirationDate) {
        this.logger.info((Object)"updateDefenseConfig begin");
        List<DefenseConfig> list = this.defenseConfigDAO.getDefenseConfigsByLicenseNumber(licenseNumber);
        if (null == list || list.isEmpty()) {
            this.logger.error((Object)"updateDefenseConfig: list is null ");
            return "ok";
        }
        HashMap<String, DefenseConfig> map = new HashMap<String, DefenseConfig>(5);
        HashMap<Long, Long> mapDeviceId = new HashMap<Long, Long>(5);
        for (DefenseConfig defenseConfig : list) {
            map.put(defenseConfig.getDomainName(), defenseConfig);
            if (defenseConfig.getDeviceId() == ddosDeviceId) continue;
            mapDeviceId.put(ddosDeviceId, ddosDeviceId);
        }
        Set<String> set = map.keySet();
        if (set.isEmpty()) {
            this.logger.error((Object)"updateDefenseConfig:domainNames is null ");
            return "ok";
        }
        for (DefenseConfig dg : map.values()) {
            this.modifyDefenseGroupExpirationDate(dg, defenseBindwidth, expirationDate);
        }
        this.defenseConfigDAO.updateDefenseGroup(set, expirationDate);
        if (!mapDeviceId.isEmpty()) {
            this.defenseConfigDAO.updateDefenseGroupDeviceId(ddosDeviceId, licenseNumber);
        }
        this.logger.info((Object)"updateDefenseConfig end");
        return "ok";
    }

    public String undoSwitchBandwidth(long deviceId, long switchBandwidth, String ip) {
        String result = "error";
        try {
            for (int i = 0; i < 3 && !"ok".equals(result = this.undoBandwidth(deviceId, switchBandwidth, ip)); ++i) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("undoSwitchBandwidth InterruptedException :" + e.getMessage()));
        }
        return result;
    }

    private String undoBandwidth(long deviceId, long switchBandwidth, String ip) {
        if (deviceId > 0L) {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("system");
            cmds.add("undo anti-ddos offline-to-online ip-address " + ip + " alert-rate " + switchBandwidth);
            List<String> result = CmdUtil.execCmds(deviceId, cmds);
            if (result.toString().toLowerCase(Locale.ENGLISH).contains("error")) {
                return "error";
            }
        }
        return "ok";
    }

    @Override
    public Map<String, Map<String, String>> deleteDefenseByDefenseConfig(List<DefenseConfigForm> defenseConfigFormList) {
        ArrayList<String> deleteList = new ArrayList<String>();
        HashMap<String, Map<String, String>> allResult = new HashMap<String, Map<String, String>>();
        if (defenseConfigFormList == null || defenseConfigFormList.size() == 0) {
            return allResult;
        }
        ArrayList<String> ipList = new ArrayList<String>();
        HashSet<String> groupIdList = new HashSet<String>();
        HashMap<String, List<DefenseConfigForm>> defenseConfigFormMap = new HashMap<String, List<DefenseConfigForm>>();
        this.getDefenseConfigByGroupId(defenseConfigFormList, ipList, groupIdList, defenseConfigFormMap);
        if (groupIdList.size() == 0) {
            return allResult;
        }
        ArrayList<DefenseConfigForm> deleteDefenseConfigByIp = new ArrayList<DefenseConfigForm>();
        HashMap<String, Integer> defenseConfigMap = new HashMap<String, Integer>();
        HashMap<String, List<DefenseConfig>> defenseConfigListMap = new HashMap<String, List<DefenseConfig>>();
        int defenseBindwidth = this.getDbDefenseConfigByGroupId(ipList, groupIdList, defenseConfigFormMap, deleteDefenseConfigByIp, defenseConfigMap, defenseConfigListMap);
        Map<String, String> groupsDelErrorResult = this.deleteGroupId(deleteList, defenseConfigMap, defenseConfigListMap);
        Map<String, String> zoneIpDelErrorResult = null;
        zoneIpDelErrorResult = !this.isDefenseIndependentAccount() ? this.deleteGroupZoneIp(deleteList, deleteDefenseConfigByIp, defenseBindwidth) : this.deleteGroupZoneIp(deleteList, deleteDefenseConfigByIp);
        HashMap<String, String> successIps = new HashMap<String, String>();
        for (String str : deleteList) {
            successIps.put(str, str);
        }
        allResult.put("groupsDelErrorResult", groupsDelErrorResult);
        allResult.put("zoneIpDelErrorResult", zoneIpDelErrorResult);
        allResult.put("successIps", successIps);
        return allResult;
    }

    private Map<String, String> deleteGroupZoneIp(List<String> deleteList, List<DefenseConfigForm> deleteDefenseConfigByIp, int defenseBindwidth) {
        HashMap<String, String> zoneIpDelErrorResult = new HashMap<String, String>();
        DefenseConfig defenseConfig = null;
        for (DefenseConfigForm deleteDefenseConfig : deleteDefenseConfigByIp) {
            this.logger.info((Object)("delete defense single zone ip data:" + deleteDefenseConfig.toString()));
            defenseConfig = new DefenseConfig();
            AticUtil.copyProperties((Object)deleteDefenseConfig, (Object)defenseConfig);
            try {
                List<DefenseConfig> defenseConfigList;
                String resultDefenseIp = this.deleteHighDefenseIp(defenseConfig, defenseBindwidth);
                this.logger.info((Object)("delete defense single zone ip data visit resultDefenseIp:" + resultDefenseIp));
                String unDoResultDefenseIp = this.undoSwitchBandwidth(defenseConfig.getDeviceId(), defenseConfig.getSwitchBandwidth(), defenseConfig.getZoneIp());
                if (!"ok".equals(unDoResultDefenseIp) || (defenseConfigList = this.defenseConfigDAO.queryDefenseConfigsByZoneIp(defenseConfig.getZoneIp())) == null || defenseConfigList.size() <= 0) continue;
                this.defenseConfigDAO.delete(defenseConfigList.get(0));
                deleteList.add(defenseConfig.getZoneIp());
                this.logger.info((Object)("delete sucess defense single zone ip data:" + deleteDefenseConfig.getZoneIp()));
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("delete defense zone ip data failed, " + e.getMessage()));
                String detail = "";
                if (7100L == e.getErrorCode()) {
                    long errorCode = this.interceptErrorCode(e.getMessage());
                    detail = this.queryDetailByErrcode("defense.err.", errorCode);
                } else {
                    detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
                }
                zoneIpDelErrorResult.put(defenseConfig.getZoneIp(), detail);
            }
            catch (Exception e) {
                this.logger.error((Object)("delete defense zone ip data ,failed, " + e.getMessage()));
                zoneIpDelErrorResult.put(defenseConfig.getZoneIp(), "defense.err.50001");
            }
        }
        return zoneIpDelErrorResult;
    }

    private Map<String, String> deleteGroupZoneIp(List<String> deleteList, List<DefenseConfigForm> deleteDefenseConfigByIp) {
        HashMap<String, String> zoneIpDelErrorResult = new HashMap<String, String>();
        DefenseConfig defenseConfig = null;
        for (DefenseConfigForm deleteDefenseConfig : deleteDefenseConfigByIp) {
            this.logger.info((Object)("delete defense single zone ip data:" + deleteDefenseConfig.toString()));
            defenseConfig = new DefenseConfig();
            AticUtil.copyProperties((Object)deleteDefenseConfig, (Object)defenseConfig);
            try {
                List<DefenseConfig> defenseConfigList;
                String resultDefenseIp = this.deleteHighDefenseIp(defenseConfig);
                this.logger.info((Object)("delete defense single zone ip data visit resultDefenseIp:" + resultDefenseIp));
                String unDoResultDefenseIp = this.undoSwitchBandwidth(defenseConfig.getDeviceId(), defenseConfig.getSwitchBandwidth(), defenseConfig.getZoneIp());
                if (!"ok".equals(unDoResultDefenseIp) || (defenseConfigList = this.defenseConfigDAO.queryDefenseConfigsByZoneIp(defenseConfig.getZoneIp())) == null || defenseConfigList.size() <= 0) continue;
                this.defenseConfigDAO.delete(defenseConfigList.get(0));
                deleteList.add(defenseConfig.getZoneIp());
                this.logger.info((Object)("delete sucess defense single zone ip data:" + deleteDefenseConfig.getZoneIp()));
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("delete defense zone ip data failed, " + e.getMessage()));
                String detail = "";
                if (7100L == e.getErrorCode()) {
                    long errorCode = this.interceptErrorCode(e.getMessage());
                    detail = this.queryDetailByErrcode("defense.err.", errorCode);
                } else {
                    detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
                }
                zoneIpDelErrorResult.put(defenseConfig.getZoneIp(), detail);
            }
            catch (Exception e) {
                this.logger.error((Object)("delete defense zone ip data ,failed, " + e.getMessage()));
                zoneIpDelErrorResult.put(defenseConfig.getZoneIp(), "defense.err.50001");
            }
        }
        return zoneIpDelErrorResult;
    }

    private Map<String, String> deleteGroupId(List<String> deleteList, Map<String, Integer> defenseConfigMap, Map<String, List<DefenseConfig>> defenseConfigListMap) {
        HashMap<String, String> allGrougDelResult = new HashMap<String, String>();
        for (Map.Entry<String, Integer> entry : defenseConfigMap.entrySet()) {
            this.logger.info((Object)("delete groupId data:" + entry.getKey()));
            ArrayList<String> groupIds = new ArrayList<String>();
            groupIds.add(entry.getKey());
            ArrayList<String> deleteGrroupIpFailList = new ArrayList<String>();
            List<DefenseConfig> defenseConfigList = defenseConfigListMap.get(entry.getKey());
            for (DefenseConfig config : defenseConfigList) {
                deleteGrroupIpFailList.add(config.getZoneIp());
            }
            List<DefenseConfig> temp = defenseConfigListMap.get(entry.getKey());
            String groupName = null == temp || temp.size() == 0 ? "--" : temp.get(0).getGroupName();
            StringBuilder deleteGrroupIpFail = new StringBuilder().append(groupName).append(" ").append(((Object)deleteGrroupIpFailList).toString());
            try {
                String result = "";
                result = !this.isDefenseIndependentAccount() ? this.deleteHighDefenseGroup(groupIds, entry.getValue()) : this.deleteHighDefenseGroup(groupIds);
                this.logger.info((Object)("delete groupId data visit SCC result:" + result));
                List<DefenseConfig> defenseTempList = defenseConfigListMap.get(entry.getKey());
                for (DefenseConfig config : defenseTempList) {
                    String unDoResult = this.undoSwitchBandwidth(config.getDeviceId(), config.getSwitchBandwidth(), config.getZoneIp());
                    if (!"ok".equals(unDoResult)) continue;
                    this.defenseConfigDAO.delete(config);
                    deleteList.add(config.getZoneIp());
                    this.logger.info((Object)("success delete groupId data:" + config.getGroupId()));
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("delete defense group id data, lego failed, " + e.getMessage()));
                String detail = "";
                if (7100L == e.getErrorCode()) {
                    long errorCode = this.interceptErrorCode(e.getMessage());
                    detail = this.queryDetailByErrcode("defense.err.", errorCode);
                } else {
                    detail = this.queryDetailByErrcode("atic.bis.online.offline.Defense.Constants.", e.getErrorCode());
                }
                allGrougDelResult.put(deleteGrroupIpFail.toString(), detail);
            }
            catch (Exception e) {
                this.logger.error((Object)("delete defense group id data ,failed, " + e.getMessage()));
                allGrougDelResult.put(deleteGrroupIpFail.toString(), "defense.err.50001");
            }
        }
        return allGrougDelResult;
    }

    private int getDbDefenseConfigByGroupId(List<String> ipList, Set<String> groupIdList, Map<String, List<DefenseConfigForm>> defenseConfigFormMap, List<DefenseConfigForm> deleteDefenseConfigByIp, Map<String, Integer> defenseConfigMap, Map<String, List<DefenseConfig>> defenseConfigListMap) {
        LicenseInfo licenseInfo = null;
        int defenseBindwidth = 0;
        for (String groupId : groupIdList) {
            ArrayList<String> dbZoneIpList = new ArrayList<String>();
            List<DefenseConfig> defenseConfigList = this.defenseConfigDAO.queryDefenseConfigsByGroupId(groupId);
            if (null == defenseConfigList) {
                this.logger.error((Object)("getDbDefenseConfigByGroupId defenseConfigList is null! groupId is : " + groupId));
                continue;
            }
            for (DefenseConfig defenseList : defenseConfigList) {
                this.logger.info((Object)("database defense data:DeviceId=" + defenseList.getDeviceId() + "GroupId=" + defenseList.getGroupId() + "GroupName=" + defenseList.getGroupName() + "GroupName=" + defenseList.getZoneId() + "GroupName=" + defenseList.getZoneIp()));
                dbZoneIpList.add(defenseList.getZoneIp());
                if (this.isDefenseIndependentAccount() || licenseInfo != null && licenseInfo.getDefenseBindwidth() >= 0) continue;
                licenseInfo = this.licenseManagementService.getLicenseByDeviceId(defenseList.getDeviceId());
                if (null == licenseInfo) {
                    this.logger.error((Object)"getDbDefenseConfigByGroupId licenseInfo is null!");
                    continue;
                }
                defenseBindwidth = licenseInfo.getDefenseBindwidth();
                this.logger.info((Object)("database defense defenseBindwidth:" + defenseBindwidth));
            }
            if (ipList.containsAll(dbZoneIpList)) {
                if (!this.isDefenseIndependentAccount()) {
                    defenseConfigMap.put(groupId, defenseBindwidth);
                } else {
                    defenseConfigMap.put(groupId, 0);
                }
                defenseConfigListMap.put(groupId, defenseConfigList);
                continue;
            }
            List<DefenseConfigForm> defenseFormList = defenseConfigFormMap.get(groupId);
            for (DefenseConfigForm form : defenseFormList) {
                if (!this.isDefenseIndependentAccount()) {
                    form.setDefenseBindwidth(defenseBindwidth);
                }
                deleteDefenseConfigByIp.add(form);
            }
        }
        return defenseBindwidth;
    }

    private void getDefenseConfigByGroupId(List<DefenseConfigForm> defenseConfigFormList, List<String> ipList, Set<String> groupIdList, Map<String, List<DefenseConfigForm>> defenseConfigFormMap) {
        for (DefenseConfigForm defenseConfigForm : defenseConfigFormList) {
            this.logger.info((Object)("choose defense data:" + defenseConfigForm.toString()));
            ipList.add(defenseConfigForm.getZoneIp());
            groupIdList.add(defenseConfigForm.getGroupId());
            List<DefenseConfigForm> defenseList = defenseConfigFormMap.get(defenseConfigForm.getGroupId());
            if (defenseList == null) {
                defenseList = new ArrayList<DefenseConfigForm>();
                defenseList.add(defenseConfigForm);
            } else {
                defenseList.add(defenseConfigForm);
            }
            defenseConfigFormMap.put(defenseConfigForm.getGroupId(), defenseList);
        }
    }

    @Override
    public void updateDefenseConfigStateByGroupId(String groupId, int state) {
        List<DefenseConfig> defenseConfig = this.defenseConfigDAO.queryDefenseConfigsByGroupId(groupId);
        if (defenseConfig == null || defenseConfig.isEmpty() || defenseConfig.get(0) == null) {
            return;
        }
        this.defenseConfigDAO.updateDefenseState(defenseConfig.get(0).getId(), state, LocalDateTime.now());
    }

    private String getDnsManualRefreshStateByGroupId(String groupId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String result = RestInvoker.get("/v1/{domain_id}/dpp/groups/" + groupId + "/flush-name", params, 2);
            this.logger.info((Object)("getDnsManualRefreshStateByGroupId task result: " + result));
            if (result == null || result.isEmpty()) {
                return "-1";
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            mapper.disableDefaultTyping();
            Map jsonObject = (Map)mapper.readValue(result, Map.class);
            jsonObject = (Map)jsonObject.get("result");
            String status = jsonObject.get("status").toString();
            this.logger.info((Object)("dns mannul refresh status : " + status));
            return status;
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("LegoCheckedException:" + e.getMessage()));
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception:" + e.getMessage()));
        }
        this.logger.info((Object)"get dns mannul refresh status fail.");
        return "-1";
    }

    @Override
    public void getDnsManualRefreshResult() {
        this.logger.info((Object)"getDnsManualRefreshResult start.");
        List<DefenseConfig> defenseConfigs = this.defenseConfigDAO.queryAllOnOrOffLine(true);
        int getFlushResultTimes = 0;
        for (DefenseConfig defenseConfig : defenseConfigs) {
            String status;
            int refreshedState;
            this.logger.info((Object)("getDnsManualRefreshResult defenseConfig zoneIp = " + defenseConfig.getZoneIp() + " state = " + defenseConfig.getState()));
            if (defenseConfig.getState() == 5) {
                ++getFlushResultTimes;
                refreshedState = -1;
                status = this.getDnsManualRefreshStateByGroupId(defenseConfig.getGroupId());
                if (status.equalsIgnoreCase(STATUS_FLUSHING)) {
                    refreshedState = 5;
                } else if (status.equalsIgnoreCase(STATUS_FLUSHED)) {
                    refreshedState = 6;
                } else if (status.equalsIgnoreCase(STATUS_FAILED)) {
                    refreshedState = 7;
                } else if (status.equalsIgnoreCase(STATUS_RECORD_REMOVED)) {
                    refreshedState = 8;
                } else {
                    this.logger.error((Object)"Advanced Anti-DDoS Normal get dns mannul refresh: status is not correct!");
                }
                this.logger.info((Object)("Advanced Anti-DDoS Normal refreshedState:" + refreshedState));
                if (refreshedState != 6 && refreshedState != 7 && refreshedState != 8) continue;
                this.defenseConfigDAO.updateDefenseState(defenseConfig.getId(), refreshedState, LocalDateTime.now());
                this.logger.info((Object)"Advanced Anti-DDoS Normal dns refresh result write to mysql over.");
                continue;
            }
            if (defenseConfig.getState() != 9) continue;
            ++getFlushResultTimes;
            refreshedState = -1;
            status = this.getDnsManualRefreshStateByGroupId(defenseConfig.getGroupId());
            if (status.equalsIgnoreCase(STATUS_FLUSHING)) {
                refreshedState = 9;
            } else if (status.equalsIgnoreCase(STATUS_FLUSHED)) {
                refreshedState = 10;
            } else if (status.equalsIgnoreCase(STATUS_FAILED)) {
                refreshedState = 11;
            } else if (status.equalsIgnoreCase(STATUS_RECORD_REMOVED)) {
                refreshedState = 12;
            } else {
                this.logger.error((Object)"defense offline get dns mannul refresh: status is not correct!");
            }
            this.logger.info((Object)("defense offline refreshedState:" + refreshedState));
            if (refreshedState != 10 && refreshedState != 11 && refreshedState != 12) continue;
            this.defenseConfigDAO.updateDefenseState(defenseConfig.getId(), refreshedState, LocalDateTime.now());
            this.logger.info((Object)"defense offline dns refresh result write to mysql over.");
        }
        if (getFlushResultTimes <= 0) {
            this.logger.info((Object)"no data need to get dns mannul refresh result");
            return;
        }
    }

    @Override
    public int getDnsManualRefreshResultByGroupId(long id, String groupId, int state) {
        this.logger.info((Object)"getDnsManualRefreshResultByGroupId start.");
        String refreshedState = this.getDnsManualRefreshStateByGroupId(groupId);
        int dateBaseState = -1;
        if (state == 5) {
            if (refreshedState.equalsIgnoreCase(STATUS_FLUSHING)) {
                dateBaseState = 5;
            } else if (refreshedState.equalsIgnoreCase(STATUS_FLUSHED)) {
                dateBaseState = 6;
            } else if (refreshedState.equalsIgnoreCase(STATUS_FAILED)) {
                dateBaseState = 7;
            } else if (refreshedState.equalsIgnoreCase(STATUS_RECORD_REMOVED)) {
                dateBaseState = 8;
            } else {
                this.logger.error((Object)"state is 5 (Advanced Anti-DDoS Normal): get dns mannul refresh: status is not correct!");
            }
            if (dateBaseState == 6 || dateBaseState == 7 || dateBaseState == 8) {
                this.defenseConfigDAO.updateDefenseState(id, dateBaseState, LocalDateTime.now());
                this.logger.info((Object)"state is 5 (Advanced Anti-DDoS Normal) : dns refresh result write to mysql over.");
            }
        } else if (state == 9) {
            if (refreshedState.equalsIgnoreCase(STATUS_FLUSHING)) {
                dateBaseState = 9;
            } else if (refreshedState.equalsIgnoreCase(STATUS_FLUSHED)) {
                dateBaseState = 10;
            } else if (refreshedState.equalsIgnoreCase(STATUS_FAILED)) {
                dateBaseState = 11;
            } else if (refreshedState.equalsIgnoreCase(STATUS_RECORD_REMOVED)) {
                dateBaseState = 12;
            } else {
                this.logger.error((Object)"state 9 (defense offline): get dns mannul refresh: status is not correct!");
            }
            if (dateBaseState == 10 || dateBaseState == 11 || dateBaseState == 12) {
                this.defenseConfigDAO.updateDefenseState(id, dateBaseState, LocalDateTime.now());
                this.logger.info((Object)"state 9 (defense offline): dns refresh result write to mysql over.");
            }
        }
        this.logger.info((Object)("refreshedState:" + refreshedState + ", dateBaseState = " + dateBaseState));
        return dateBaseState;
    }

    @Override
    public long interceptErrorCode(String message) {
        if (StringUtils.isNotEmpty(message) && message.indexOf("{") != -1 && message.indexOf("}") != -1) {
            message = message.substring(message.indexOf("{"), message.indexOf("}") + 1);
            MyTypeReference resultJson = new MyTypeReference();
            try {
                Map map = (Map)JSONUtil.getInstance().fromJSON(message, resultJson);
                if (null != map.get("error_code")) {
                    String errorCodeStr = String.valueOf(map.get("error_code"));
                    long errorCode = Long.parseLong(errorCodeStr.substring(errorCodeStr.indexOf(".") + 1));
                    this.logger.info((Object)("intercept ErrorCode is," + errorCode));
                    return errorCode;
                }
            }
            catch (IOException e) {
                this.logger.info((Object)("interceptErrorCode json error," + e.getMessage()));
            }
        }
        return 50002L;
    }

    private String queryDetailByErrcode(String key, long errorCode) {
        String detail = LocaleUtil.getInstance().getText(key + errorCode);
        if (AticUtil.isNull((String)detail) || detail.equals(key + errorCode)) {
            if ("defense.err.".equals(key)) {
                return key + 50002L;
            }
            return "lego.err." + errorCode;
        }
        return key + errorCode;
    }

    @Override
    public DefenseConfigForm getDefenseConfigStateByGroupId(String groupId) {
        List<DefenseConfig> defenseConfigList = this.defenseConfigDAO.queryDefenseConfigsByGroupId(groupId);
        if (defenseConfigList == null || defenseConfigList.isEmpty()) {
            return null;
        }
        DefenseConfigForm defenseConfigForm = new DefenseConfigForm();
        AticUtil.copyProperties((Object)defenseConfigList.get(0), (Object)defenseConfigForm);
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(defenseConfigList.get(0).getDeviceId());
        if (null != aticDevice) {
            defenseConfigForm.setDeviceName(aticDevice.getName());
        }
        return defenseConfigForm;
    }

    @Override
    public DefenseConfigForm queryDefenseConfigForm(DefenseConfigForm defenseConfigForm) {
        DefenseConfig defenseConfig = this.defenseConfigDAO.queryDefenseConfigForm(defenseConfigForm);
        if (null == defenseConfig) {
            return null;
        }
        DefenseConfigForm defenseConfigFormReturn = new DefenseConfigForm();
        BeanUtils.copyProperties((Object)defenseConfig, (Object)defenseConfigFormReturn);
        if (!this.isDefenseIndependentAccount()) {
            LocalDate expirationDate = defenseConfig.getExpirationDate();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String expirationDateString = df.format(expirationDate);
            defenseConfigFormReturn.setExpirationDateString(expirationDateString);
        }
        return defenseConfigFormReturn;
    }

    @Override
    public void saveSwitchHistory(DefenseSwitchHistory switchHistory) {
        this.defenseSwitchHistoryDAO.save(switchHistory);
    }

    private void batchRsult(boolean isSuccess, String module, String target, String detail, String operation, String[] detailPara, String operator, String terminalIp) {
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setOperation(operation);
        syncSysLog.setModule(module);
        syncSysLog.setOperator(operator);
        syncSysLog.setTerminalIp(terminalIp);
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        syncSysLog.setTargetLocal(Boolean.valueOf(true));
        if (isSuccess) {
            syncSysLog.setResult(1);
            syncSysLog.setLevel(SysoplogLevel.info.getValue());
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        } else {
            syncSysLog.setResult(0);
            syncSysLog.setLevel(SysoplogLevel.normal.getValue());
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        }
    }

    public static class MyTypeReference<T>
    extends TypeReference<T> {
    }
}

