/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.service.impl;

import com.hs.atic.highdefense.domain.dao.DefenseSwitchHistoryDAOImpl;
import com.hs.atic.highdefense.domain.model.DefenseSwitchHistory;
import com.hs.atic.highdefense.domain.model.form.DefenseSwitchHistoryForm;
import com.hs.atic.highdefense.domain.service.IDefenseSwitchHistoryService;
import com.hs.atic.highdefense.domain.util.LocalDateTimeUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.sdk.comm.Paging;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="defenseSwitchHistoryService")
public class DefenseSwitchHistoryServiceimpl
implements IDefenseSwitchHistoryService {
    @Autowired
    private DefenseSwitchHistoryDAOImpl defenseSwitchHistoryDAO;

    @Override
    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        Paging page = this.defenseSwitchHistoryDAO.queryByPage(conditionMap, start, pageSize);
        List infoList = page.getData();
        ArrayList<DefenseSwitchHistoryForm> formList = new ArrayList<DefenseSwitchHistoryForm>();
        if (null != infoList) {
            for (DefenseSwitchHistory switchHistory : infoList) {
                DefenseSwitchHistoryForm historyForm = new DefenseSwitchHistoryForm();
                AticUtil.copyProperties((Object)switchHistory, (Object)historyForm);
                historyForm.setSwitchDateTime(LocalDateTimeUtil.getDateTimeAsString(switchHistory.getSwitchDateTime(), "yyyy-MM-dd HH:mm:ss"));
                if (AticUtil.isNull((String)historyForm.getDeviceName())) {
                    historyForm.setDeviceName("-");
                }
                historyForm.setDetail(LocaleUtil.getInstance().getText(switchHistory.getDetail()));
                formList.add(historyForm);
            }
        }
        page.setData(formList);
        return page;
    }
}

