/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.hs.atic.highdefense.domain.dao.HuaweiCloudIdentityDAOImpl;
import com.hs.atic.highdefense.domain.model.HuaweiCloudIdentity;
import com.hs.atic.highdefense.domain.model.form.HuaweiCloudIdentityForm;
import com.hs.atic.highdefense.domain.service.IHuaweiCloudIdentityService;
import com.hs.atic.highdefense.util.HuaweiCloudIdentityToken;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.system.SysConfigManager;
import com.hs.atic.util.ProxyInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.restful.util.JSONUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="huaweiCloudIdentityService")
public class HuaweiCloudIdentityServiceImpl
implements IHuaweiCloudIdentityService {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static AtomicInteger isAadAccount = new AtomicInteger(-1);
    @Autowired
    private HuaweiCloudIdentityDAOImpl huaweiCloudIdentityDAO;
    @Autowired
    private SysConfigManager sysConfigManager;

    @Override
    public HuaweiCloudIdentityForm queryIdentity(int bandWith) {
        HuaweiCloudIdentity huaweiCloudIdentity = this.huaweiCloudIdentityDAO.queryIdentity(bandWith);
        if (null == huaweiCloudIdentity) {
            return null;
        }
        HuaweiCloudIdentityForm huaweiCloudIdentityForm = new HuaweiCloudIdentityForm();
        BeanUtils.copyProperties((Object)huaweiCloudIdentity, (Object)huaweiCloudIdentityForm);
        huaweiCloudIdentityForm.setHighDefenseUser(EncryptData.getInstanse().decryptdata(huaweiCloudIdentity.getHighDefenseUser()));
        huaweiCloudIdentityForm.setHighDefensePwd(EncryptData.getInstanse().decryptdata(huaweiCloudIdentity.getHighDefensePwd()));
        huaweiCloudIdentityForm.setDomain(EncryptData.getInstanse().decryptdata(huaweiCloudIdentity.getDomain()));
        huaweiCloudIdentityForm.setProject(EncryptData.getInstanse().decryptdata(huaweiCloudIdentity.getProject()));
        return huaweiCloudIdentityForm;
    }

    @Override
    public int queryIdentity() {
        return this.huaweiCloudIdentityDAO.queryIdentity();
    }

    @Override
    public long saveIdentity(HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        List<HuaweiCloudIdentityForm> userPwdIdentitys = null;
        this.proxyInfo(huaweiCloudIdentityForm);
        try {
            if (null == huaweiCloudIdentityForm.getPwdIdentity()) {
                String json = this.sysConfigManager.getSystemValue("huaweiCloudConfig");
                if (null == json) {
                    return 5100L;
                }
                CurTypeReference type = new CurTypeReference();
                Map param01 = (Map)JSONUtil.getInstance().fromJSON(json, type);
                huaweiCloudIdentityForm.setPwdIdentity(EncryptData.getInstanse().decryptdata((String)param01.get("pwdIdentity")));
            }
            userPwdIdentitys = HuaweiCloudIdentityToken.getInstance().getUserPwdIdentity(huaweiCloudIdentityForm);
        }
        catch (LegoCheckedException e) {
            return e.getErrorCode();
        }
        catch (IOException e) {
            return 5100L;
        }
        if (userPwdIdentitys.size() == 0) {
            return 5100L;
        }
        ArrayList<HuaweiCloudIdentity> listHuaweiIdentitys = new ArrayList<HuaweiCloudIdentity>();
        for (HuaweiCloudIdentityForm form : userPwdIdentitys) {
            if (null == form || null == form.getHighDefenseUser() || null == form.getHighDefensePwd()) {
                return 5100L;
            }
            HuaweiCloudIdentity huaweiCloudIdentity = new HuaweiCloudIdentity();
            huaweiCloudIdentity.setHighDefenseUser(EncryptData.getInstanse().encryptData(form.getHighDefenseUser()));
            huaweiCloudIdentity.setHighDefensePwd(EncryptData.getInstanse().encryptData(form.getHighDefensePwd()));
            huaweiCloudIdentity.setDomain(EncryptData.getInstanse().encryptData(form.getDomain()));
            huaweiCloudIdentity.setProject(EncryptData.getInstanse().encryptData(form.getProject()));
            huaweiCloudIdentity.setHuaweiCloudBandWidth(form.getHuaweiCloudBandWidth());
            huaweiCloudIdentity.setUrl(huaweiCloudIdentityForm.getUrl());
            huaweiCloudIdentity.setIsAadAccount(huaweiCloudIdentityForm.getIsAadAccount());
            listHuaweiIdentitys.add(huaweiCloudIdentity);
        }
        try {
            boolean aadAccount = this.isHuaweiCloudIdentityAad(listHuaweiIdentitys);
            this.setAadAccount(aadAccount);
            this.cleanNonAadIfAadAccountCreate(listHuaweiIdentitys);
            this.sysConfigManager.replaceSystemValue(huaweiCloudIdentityForm.getHighDefenseUrl(), "highDefenseRestServer");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("domainName", EncryptData.getInstanse().encryptData(huaweiCloudIdentityForm.getDomainName()));
            param.put("projectName", EncryptData.getInstanse().encryptData(huaweiCloudIdentityForm.getProjectName()));
            param.put("userIdentity", EncryptData.getInstanse().encryptData(huaweiCloudIdentityForm.getUserIdentity()));
            param.put("pwdIdentity", EncryptData.getInstanse().encryptData(huaweiCloudIdentityForm.getPwdIdentity()));
            param.put("url", huaweiCloudIdentityForm.getUrl());
            param.put("defenceAuthCertAlias", huaweiCloudIdentityForm.getDefenceAuthCertAlias());
            param.put("defenceAuthAdvancedCertAlias", huaweiCloudIdentityForm.getDefenceAuthAdvancedCertAlias());
            this.sysConfigManager.replaceSystemValue(JSONUtil.getInstance().toJSON(param), "huaweiCloudConfig");
        }
        catch (RuntimeException e) {
            return 5300L;
        }
        catch (Exception e) {
            return 5300L;
        }
        return 5000L;
    }

    private void cleanNonAadIfAadAccountCreate(List<HuaweiCloudIdentity> listHuaweiIdentitys) {
        HuaweiCloudIdentity cloudIdentity = listHuaweiIdentitys.get(0);
        if (this.isAadAccount()) {
            this.huaweiCloudIdentityDAO.saveOrUpdate(cloudIdentity);
            this.huaweiCloudIdentityDAO.cleanNonAadAccountUserIdentities();
        } else {
            this.huaweiCloudIdentityDAO.saveIdentitys(listHuaweiIdentitys);
        }
    }

    private boolean isHuaweiCloudIdentityAad(List<HuaweiCloudIdentity> listHuaweiIdentitys) {
        boolean adAccount = false;
        HuaweiCloudIdentity cloudIdentity = listHuaweiIdentitys.get(0);
        if (null != cloudIdentity && null != cloudIdentity.getIsAadAccount() && cloudIdentity.getIsAadAccount() == 1) {
            adAccount = true;
        }
        return adAccount;
    }

    private void proxyInfo(HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        try {
            String json = this.sysConfigManager.getSystemValue("huaweiCloudIdentity");
            if (null == json) {
                ProxyInfo proxyInfo = new ProxyInfo();
                proxyInfo.getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthCertAlias());
                proxyInfo.getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getUrl());
                huaweiCloudIdentityForm.setProxyInfo(proxyInfo);
                return;
            }
            ProxyInfo proxyInfo = (ProxyInfo)JSONUtil.getInstance().fromJSON(json, ProxyInfo.class);
            String userDomain = StringUtils.isEmpty(proxyInfo.getUserDomain()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getUserDomain());
            String pwd = StringUtils.isEmpty(proxyInfo.getPwd()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getPwd());
            proxyInfo.setUserDomain(userDomain);
            proxyInfo.setPwd(pwd);
            proxyInfo.getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthCertAlias());
            proxyInfo.getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getUrl());
            huaweiCloudIdentityForm.setProxyInfo(proxyInfo);
        }
        catch (IOException e) {
            logger.error((Object)"[proxyInfo] setProxyInfo failed IOException");
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthCertAlias());
            proxyInfo.getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getUrl());
            huaweiCloudIdentityForm.setProxyInfo(proxyInfo);
        }
    }

    @Override
    public List<HuaweiCloudIdentityForm> getAadUserIdentites() {
        ArrayList<HuaweiCloudIdentityForm> userIdenties = new ArrayList<HuaweiCloudIdentityForm>();
        boolean addAccount = true;
        List<HuaweiCloudIdentity> cloudIdentities = this.huaweiCloudIdentityDAO.getAadUserIdentities(addAccount);
        for (HuaweiCloudIdentity cloudIdentity : cloudIdentities) {
            HuaweiCloudIdentityForm identityForm = new HuaweiCloudIdentityForm();
            identityForm.setHighDefenseUser(EncryptData.getInstanse().decryptdata(cloudIdentity.getHighDefenseUser()));
            identityForm.setHighDefensePwd(EncryptData.getInstanse().decryptdata(cloudIdentity.getHighDefensePwd()));
            identityForm.setDomain(EncryptData.getInstanse().decryptdata(cloudIdentity.getDomain()));
            identityForm.setProject(EncryptData.getInstanse().decryptdata(cloudIdentity.getProject()));
            identityForm.setHuaweiCloudBandWidth(cloudIdentity.getHuaweiCloudBandWidth());
            identityForm.setUrl(cloudIdentity.getUrl());
            identityForm.setIsAadAccount(cloudIdentity.getIsAadAccount());
            userIdenties.add(identityForm);
        }
        return userIdenties;
    }

    @Override
    public boolean isAadAccount() {
        boolean aadAccount = false;
        if (isAadAccount.get() == -1) {
            Integer iAadAccount = this.getAadUserIdentites().size() > 0 ? 1 : 0;
            isAadAccount.set(iAadAccount);
        }
        aadAccount = isAadAccount.get() == 1;
        return aadAccount;
    }

    private void setAadAccount(boolean aadAccount) {
        Integer iAadAccount = aadAccount ? 1 : 0;
        isAadAccount.set(iAadAccount);
    }

    @Override
    public List<HuaweiCloudIdentityForm> getUserIdentites() {
        ArrayList<HuaweiCloudIdentityForm> userIdenties = new ArrayList<HuaweiCloudIdentityForm>();
        List<HuaweiCloudIdentity> cloudIdentities = this.huaweiCloudIdentityDAO.getUserIdentities();
        for (HuaweiCloudIdentity cloudIdentity : cloudIdentities) {
            HuaweiCloudIdentityForm identityForm = new HuaweiCloudIdentityForm();
            BeanUtils.copyProperties((Object)identityForm, (Object)cloudIdentity);
            userIdenties.add(identityForm);
        }
        return userIdenties;
    }

    @Override
    public void cleanUserIdentities() {
    }

    @Override
    public HuaweiCloudIdentityForm queryCurrentHuaweiCloudConfig() {
        HuaweiCloudIdentityForm form = new HuaweiCloudIdentityForm();
        String json = this.sysConfigManager.getSystemValue("huaweiCloudConfig");
        if (null == json) {
            return form;
        }
        String highDefenseRestServer = this.sysConfigManager.getSystemValue("highDefenseRestServer");
        if (null == highDefenseRestServer) {
            logger.error((Object)"queryCurrentHuaweiCloudConfig highDefenseRestServer is null");
            return form;
        }
        try {
            CurTypeReference type = new CurTypeReference();
            Map param = (Map)JSONUtil.getInstance().fromJSON(json, type);
            form.setPwdIdentity(EncryptData.getInstanse().decryptdata((String)param.get("pwdIdentity")));
            form.setUrl((String)param.get("url"));
            form.setUserIdentity(EncryptData.getInstanse().decryptdata((String)param.get("userIdentity")));
            form.setDomainName(EncryptData.getInstanse().decryptdata((String)param.get("domainName")));
            form.setProjectName(EncryptData.getInstanse().decryptdata((String)param.get("projectName")));
            form.setHighDefenseUrl(highDefenseRestServer);
            form.setDefenceAuthCertAlias((String)param.get("defenceAuthCertAlias"));
            form.setDefenceAuthAdvancedCertAlias((String)param.get("defenceAuthAdvancedCertAlias"));
            return form;
        }
        catch (IOException e) {
            logger.error((Object)("queryCurrentHuaweiCloudConfig error : " + json));
            return form;
        }
    }

    private static class CurTypeReference<T>
    extends TypeReference<Map<String, String>> {
    }
}

