/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.domain.util;

import com.hs.atic.highdefense.domain.model.form.DefenseConfigForm;
import com.hs.atic.highdefense.domain.service.IDefenseConfigService;
import com.hs.atic.highdefense.domain.util.LocalDateTimeUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.device.model.AticDevice;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;

public class DefenseTaskThread
extends Thread {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    @Autowired
    private IDefenseConfigService defenseConfigService;
    private long statusCheckTime = 300000L;
    private long cutBackAutoTime = 86400000L;
    private long cutBackManualTime = 259200000L;

    public DefenseTaskThread() {
        Properties conf = this.openPropertyFile();
        if (null != conf.getProperty("defense.status.checkTime")) {
            this.logger.info((Object)("DefenseTaskThread statusCheckTime is " + conf.getProperty("defense.status.checkTime")));
            this.statusCheckTime = Long.parseLong(conf.getProperty("defense.status.checkTime"));
        }
        if (null != conf.getProperty("defense.cutback.autoTime")) {
            this.cutBackAutoTime = Long.parseLong(conf.getProperty("defense.cutback.autoTime"));
        }
        if (null != conf.getProperty("defense.cutback.manualTime")) {
            this.cutBackManualTime = Long.parseLong(conf.getProperty("defense.cutback.manualTime"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties openPropertyFile() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = DefenseTaskThread.class.getResourceAsStream("/datetable.properties");
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"query defense.openPropertyFile failed FileNotFoundException!");
        }
        catch (IOException e) {
            this.logger.error((Object)"query defense.openPropertyFile failed IOException!");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"query defense.openPropertyFile failed! ");
                }
            }
        }
        return properties;
    }

    @Override
    public void run() {
        while (true) {
            try {
                List<DefenseConfigForm> needSwitchDefenses = this.defenseConfigService.getOnlineDenfenseState();
                if (!this.defenseConfigService.isDefenseIndependentAccount()) {
                    List<DefenseConfigForm> needBackCutList = null;
                    if (!needSwitchDefenses.isEmpty()) {
                        needBackCutList = this.queryBackCutDefense(needSwitchDefenses);
                    }
                    if (needBackCutList != null && !needBackCutList.isEmpty()) {
                        this.defenseConfigService.switchToOffline(needBackCutList, 1);
                    }
                } else {
                    this.defenseConfigService.getDnsManualRefreshResult();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("defense Task thread.data error." + e.getMessage()));
            }
            try {
                Thread.sleep(this.statusCheckTime);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("defense Task thread.sleep error." + e.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<DefenseConfigForm> queryBackCutDefense(List<DefenseConfigForm> needSwitchDefenses) {
        ArrayList<DefenseConfigForm> needSwitchDefenseList = new ArrayList<DefenseConfigForm>();
        for (DefenseConfigForm form : needSwitchDefenses) {
            this.logger.info((Object)("DefenseTaskThread.initDate id is : " + form.getId()));
            if (form.getSwitchToOffline() == 1) {
                if (System.currentTimeMillis() - LocalDateTimeUtil.getTimestampOfDateTime(form.getUpdatedDateTime()) < this.cutBackAutoTime) continue;
                needSwitchDefenseList.add(form);
                continue;
            }
            if (System.currentTimeMillis() - LocalDateTimeUtil.getTimestampOfDateTime(form.getUpdatedDateTime()) < this.cutBackManualTime || this.queryOfflinStatus(form)) continue;
            needSwitchDefenseList.add(form);
        }
        return needSwitchDefenseList;
    }

    private boolean queryOfflinStatus(DefenseConfigForm dConfigForm) {
        CollectorInfo collectorInfo;
        this.logger.info((Object)("DefenseTaskThread queryOfflinStatus,offlineSatus id is " + dConfigForm.getId()));
        boolean offlineSatus = false;
        Long collectorId = ZoneReferUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(dConfigForm.getDeviceId()));
        AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(dConfigForm.getDeviceId());
        if (null != collectorId && null != aticDevice && null != (collectorInfo = ZoneReferUtil.getICollectorService().getCollectorInfo(collectorId.longValue())) && 2 != collectorInfo.getStatus()) {
            offlineSatus = ZoneReferUtil.getAttackDataService().getAttackStatus(collectorInfo.getIpAddress(), dConfigForm.getZoneId(), dConfigForm.getZoneIp(), aticDevice.getIpAddress());
            this.logger.info((Object)("DefenseTaskThread queryOfflinStatus,offlineSatus is " + offlineSatus));
        }
        return offlineSatus;
    }
}

