/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.util;

import com.hs.atic.highdefense.domain.model.form.HuaweiCloudIdentityForm;
import com.hs.atic.highdefense.domain.service.IHuaweiCloudIdentityService;
import com.hs.atic.highdefense.domain.service.impl.HuaweiCloudIdentityServiceImpl;
import com.hs.atic.highdefense.util.DomainTokenModel;
import com.hs.atic.highdefense.util.HuaweiCloudResponse;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.system.service.SysConfigManagerImpl;
import com.hs.atic.util.HttpClientUtil;
import com.hs.atic.util.ProxyInfo;
import com.hs.atic.util.ResponseHandlerModel;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.restful.util.JSONUtil;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;

public class HighDefenseToken {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final long DELAY_TIME_MILLIS = 300000L;
    private volatile ConcurrentHashMap<Integer, DomainTokenModel> tokens = new ConcurrentHashMap();
    private volatile long tokenReceiveTime;
    private volatile boolean invalid = false;

    private HighDefenseToken() {
    }

    public static HighDefenseToken getInstance() {
        return HighDefenseTokenHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainTokenModel getToken(int bandWith) {
        if (this.isNull(bandWith)) {
            HighDefenseToken highDefenseToken = this;
            synchronized (highDefenseToken) {
                if (this.isNull(bandWith)) {
                    DomainTokenModel domainWtihToken = HighDefenseToken.getXAuthToken(bandWith);
                    this.tokenReceiveTime = System.currentTimeMillis();
                    return domainWtihToken;
                }
            }
        }
        return this.tokens.get(bandWith);
    }

    public DomainTokenModel getTokenDefense() {
        DomainTokenModel domainWtihToken = HighDefenseToken.getXAuthTokenDefense();
        this.tokenReceiveTime = System.currentTimeMillis();
        return domainWtihToken;
    }

    private boolean isNull(int bandWith) {
        return null == this.tokens || this.invalid || System.currentTimeMillis() - this.tokenReceiveTime >= 300000L || this.innerNullCheck(bandWith);
    }

    private boolean innerNullCheck(int bandWith) {
        return null == this.tokens.get(bandWith) || null == this.tokens.get(bandWith).getToken() || null == this.tokens.get(bandWith).getDomainId() || null == this.tokens.get(bandWith).getProjectId();
    }

    public synchronized void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    private static DomainTokenModel getXAuthToken(int bandWith) {
        IHuaweiCloudIdentityService huaweiCloudIdentityService = (IHuaweiCloudIdentityService)ServiceContext.getInstance().getService("huaweiCloudIdentityService", HuaweiCloudIdentityServiceImpl.class);
        if (null == huaweiCloudIdentityService) {
            throw new LegoCheckedException(6001L);
        }
        HuaweiCloudIdentityForm huaweiCloudIdentityForm = huaweiCloudIdentityService.queryIdentity(bandWith);
        if (null == huaweiCloudIdentityForm) {
            throw new LegoCheckedException(6001L);
        }
        ResponseHandlerModel responseHandlerModel = null;
        try {
            HighDefenseToken.proxyInfo(huaweiCloudIdentityForm);
            HuaweiCloudIdentityForm config = huaweiCloudIdentityService.queryCurrentHuaweiCloudConfig();
            huaweiCloudIdentityForm.getProxyInfo().getCertCheckInfo().setAlias(config.getDefenceAuthCertAlias());
            huaweiCloudIdentityForm.getProxyInfo().getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getUrl());
            responseHandlerModel = HttpClientUtil.postByProxy(huaweiCloudIdentityForm.getUrl(), "", HighDefenseToken.assemblyBodyJson(huaweiCloudIdentityForm), null, huaweiCloudIdentityForm.getProxyInfo());
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(5100L);
        }
        if (null == responseHandlerModel.getAllHeaders() || responseHandlerModel.getAllHeaders().size() == 0) {
            throw new LegoCheckedException(5200L);
        }
        List<Header> allHeaders = responseHandlerModel.getAllHeaders();
        String token = "";
        for (Header header : allHeaders) {
            if (header == null || null == header.getName() || !header.getName().equals("X-Subject-Token")) continue;
            token = header.getValue();
            break;
        }
        DomainTokenModel domainTokenModel = new DomainTokenModel();
        domainTokenModel.setToken(token);
        try {
            HuaweiCloudResponse huaweiCloudResponse = (HuaweiCloudResponse)JSONUtil.getInstance().fromJSON(responseHandlerModel.getEntityJson(), HuaweiCloudResponse.class);
            String domainId = huaweiCloudResponse.getToken().getUser().getDomain().getId();
            String projectId = huaweiCloudResponse.getToken().getProject().getId();
            domainTokenModel.setDomainId(domainId);
            domainTokenModel.setProjectId(projectId);
        }
        catch (IOException | NullPointerException e) {
            throw new LegoCheckedException(5200L);
        }
        return domainTokenModel;
    }

    private static DomainTokenModel getXAuthTokenDefense() {
        IHuaweiCloudIdentityService huaweiCloudIdentityService = (IHuaweiCloudIdentityService)ServiceContext.getInstance().getService("huaweiCloudIdentityService", HuaweiCloudIdentityServiceImpl.class);
        if (null == huaweiCloudIdentityService) {
            throw new LegoCheckedException(6001L);
        }
        List<HuaweiCloudIdentityForm> huaweiCloudIdentityFormList = huaweiCloudIdentityService.getAadUserIdentites();
        HuaweiCloudIdentityForm huaweiCloudIdentityForm = null;
        if (null != huaweiCloudIdentityFormList && huaweiCloudIdentityFormList.size() != 0) {
            huaweiCloudIdentityForm = huaweiCloudIdentityFormList.get(0);
        }
        if (null == huaweiCloudIdentityForm) {
            throw new LegoCheckedException(6001L);
        }
        ResponseHandlerModel responseHandlerModel = null;
        try {
            HighDefenseToken.proxyInfo(huaweiCloudIdentityForm);
            HuaweiCloudIdentityForm config = huaweiCloudIdentityService.queryCurrentHuaweiCloudConfig();
            huaweiCloudIdentityForm.getProxyInfo().getCertCheckInfo().setAlias(config.getDefenceAuthCertAlias());
            huaweiCloudIdentityForm.getProxyInfo().getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getUrl());
            responseHandlerModel = HttpClientUtil.postByProxy(huaweiCloudIdentityForm.getUrl(), "", HighDefenseToken.assemblyBodyJson(huaweiCloudIdentityForm), null, huaweiCloudIdentityForm.getProxyInfo());
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(5100L);
        }
        if (null == responseHandlerModel.getAllHeaders() || responseHandlerModel.getAllHeaders().size() == 0) {
            throw new LegoCheckedException(5200L);
        }
        List<Header> allHeaders = responseHandlerModel.getAllHeaders();
        String token = "";
        for (Header header : allHeaders) {
            if (header == null || null == header.getName() || !header.getName().equals("X-Subject-Token")) continue;
            token = header.getValue();
            break;
        }
        DomainTokenModel domainTokenModel = new DomainTokenModel();
        domainTokenModel.setToken(token);
        try {
            HuaweiCloudResponse huaweiCloudResponse = (HuaweiCloudResponse)JSONUtil.getInstance().fromJSON(responseHandlerModel.getEntityJson(), HuaweiCloudResponse.class);
            String domainId = huaweiCloudResponse.getToken().getUser().getDomain().getId();
            String projectId = huaweiCloudResponse.getToken().getProject().getId();
            domainTokenModel.setDomainId(domainId);
            domainTokenModel.setProjectId(projectId);
        }
        catch (IOException | NullPointerException e) {
            throw new LegoCheckedException(5200L);
        }
        return domainTokenModel;
    }

    public static String assemblyBodyJson(HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        String userIdentity = huaweiCloudIdentityForm.getHighDefenseUser();
        String pwdIdentity = huaweiCloudIdentityForm.getHighDefensePwd();
        String domainName = huaweiCloudIdentityForm.getDomain();
        String projectName = huaweiCloudIdentityForm.getProject();
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("\"auth\":{\"identity\":{\"methods\":[\"password\"],\"password\":{\"user\":{");
        sb.append("\"name\":");
        sb.append("\"");
        sb.append(userIdentity);
        sb.append("\"");
        sb.append(",");
        sb.append("\"password\":");
        sb.append("\"");
        sb.append(pwdIdentity);
        sb.append("\"");
        if (null != domainName && !"".equals(domainName)) {
            sb.append(",");
            sb.append("\"domain\":{\"name\":");
            sb.append("\"");
            sb.append(domainName);
            sb.append("\"");
            sb.append("}");
        }
        sb.append("}}}");
        if (null != projectName && !"".equals(projectName)) {
            sb.append(",");
            sb.append("\"scope\":{");
            sb.append("\"project\":{\"name\":\"");
            sb.append(projectName);
            sb.append("\"");
            if (null != domainName && !"".equals(domainName)) {
                sb.append(",");
                sb.append("\"domain\":{\"name\":");
                sb.append("\"");
                sb.append(domainName);
                sb.append("\"");
                sb.append("}");
            }
            sb.append("}}}}");
        }
        if (null == domainName || "".equals(domainName)) {
            sb.append("}}}");
        }
        if (null == projectName || "".equals(projectName)) {
            sb.append("}}");
        }
        return sb.toString();
    }

    private static void proxyInfo(HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        try {
            String json = ((SysConfigManagerImpl)ServiceContext.getInstance().getService("sysConfigMgr", SysConfigManagerImpl.class)).getSystemValue("huaweiCloudIdentity");
            if (null == json) {
                ProxyInfo proxyInfo = new ProxyInfo();
                proxyInfo.getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthCertAlias());
                proxyInfo.getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getUrl());
                huaweiCloudIdentityForm.setProxyInfo(proxyInfo);
                return;
            }
            ProxyInfo proxyInfo = (ProxyInfo)JSONUtil.getInstance().fromJSON(json, ProxyInfo.class);
            String userDomain = StringUtils.isEmpty(proxyInfo.getUserDomain()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getUserDomain());
            String pwd = StringUtils.isEmpty(proxyInfo.getPwd()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getPwd());
            proxyInfo.setUserDomain(userDomain);
            proxyInfo.setPwd(pwd);
            huaweiCloudIdentityForm.setProxyInfo(proxyInfo);
        }
        catch (IOException e) {
            logger.error((Object)"proxyInfo json error");
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthCertAlias());
            proxyInfo.getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getUrl());
            huaweiCloudIdentityForm.setProxyInfo(proxyInfo);
        }
    }

    private static class HighDefenseTokenHolder {
        private static HighDefenseToken instance = new HighDefenseToken();

        private HighDefenseTokenHolder() {
        }
    }
}

