/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.util;

import com.hs.atic.highdefense.domain.model.HighDefenseInstanceInfoList;
import com.hs.atic.highdefense.domain.model.HighDefenseUsers;
import com.hs.atic.highdefense.domain.model.form.HuaweiCloudIdentityForm;
import com.hs.atic.highdefense.util.DomainTokenModel;
import com.hs.atic.highdefense.util.HuaweiCloudResponse;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.system.service.SysConfigManagerImpl;
import com.hs.atic.util.HttpClientUtil;
import com.hs.atic.util.ProxyInfo;
import com.hs.atic.util.ResponseHandlerModel;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.restful.util.JSONUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.http.Header;
import org.wcc.crypt.Crypter;
import org.wcc.crypt.CrypterFactory;

public class HuaweiCloudIdentityToken {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private HuaweiCloudIdentityToken() {
    }

    public static HuaweiCloudIdentityToken getInstance() {
        return HuaweiCloudIdentityTokenHolder.instance;
    }

    public synchronized List<HuaweiCloudIdentityForm> getUserPwdIdentity(HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        ArrayList<HuaweiCloudIdentityForm> identities;
        block12: {
            identities = new ArrayList<HuaweiCloudIdentityForm>();
            String url = huaweiCloudIdentityForm.getUrl();
            huaweiCloudIdentityForm.getProxyInfo().getCertCheckInfo().setUrl(url);
            huaweiCloudIdentityForm.getProxyInfo().getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthCertAlias());
            ResponseHandlerModel responseHandlerModel = null;
            try {
                responseHandlerModel = HttpClientUtil.postByProxy(url, "", HuaweiCloudIdentityToken.assemblyBodyJson(huaweiCloudIdentityForm), null, huaweiCloudIdentityForm.getProxyInfo());
            }
            catch (LegoCheckedException e) {
                throw new LegoCheckedException(5100L);
            }
            if (null == responseHandlerModel.getAllHeaders() || responseHandlerModel.getAllHeaders().size() == 0) {
                throw new LegoCheckedException(5200L);
            }
            String token = "";
            String domainId = "";
            DomainTokenModel tokenModel = this.parseResponseHandlerModel(responseHandlerModel);
            token = tokenModel.getToken();
            domainId = tokenModel.getDomainId();
            try {
                if (this.hasAadInstances(huaweiCloudIdentityForm, domainId, token)) {
                    huaweiCloudIdentityForm.setHuaweiCloudBandWidth(9000000);
                    huaweiCloudIdentityForm.setIsAadAccount(1);
                    huaweiCloudIdentityForm.setHighDefenseUser(huaweiCloudIdentityForm.getUserIdentity());
                    huaweiCloudIdentityForm.setHighDefensePwd(huaweiCloudIdentityForm.getPwdIdentity());
                    huaweiCloudIdentityForm.setDomain(huaweiCloudIdentityForm.getDomainName());
                    huaweiCloudIdentityForm.setProject(huaweiCloudIdentityForm.getProjectName());
                    identities.add(huaweiCloudIdentityForm);
                    break block12;
                }
                String highDefenseUrl = huaweiCloudIdentityForm.getHighDefenseUrl();
                ProxyInfo proxyInfo = null == this.proxyInfo() ? new ProxyInfo() : this.proxyInfo();
                proxyInfo.getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthAdvancedCertAlias());
                proxyInfo.getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getHighDefenseUrl());
                String highDefenseUserInfoCrypt = null;
                try {
                    highDefenseUserInfoCrypt = HttpClientUtil.get(highDefenseUrl + "/v1/dpp/user-info", token, null, null, proxyInfo);
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("/v1/dpp/user/info/list get crpty data error!!!" + e.getMessage()));
                    throw new LegoCheckedException(7100L);
                }
                String decodedData = "";
                if (null == highDefenseUserInfoCrypt) {
                    this.logger.error((Object)"/v1/dpp/user/info/list get crpty data error!");
                    throw new LegoCheckedException(7100L);
                }
                try {
                    this.logger.info((Object)("highDefenseUserInfoCrypt : " + highDefenseUserInfoCrypt));
                    Crypter crypter = CrypterFactory.getCrypter((String)"AES_CBC");
                    ResourceBundle resource = ResourceBundle.getBundle("config");
                    this.logger.info((Object)"getUserPwdIdentity read config.properties success!");
                    decodedData = crypter.decrypt(highDefenseUserInfoCrypt, resource.getString("highdenfencypubkey"));
                    this.logger.info((Object)"getUserPwdIdentity decrypt success!");
                    HighDefenseUsers highDefenseUsers = (HighDefenseUsers)JSONUtil.getInstance().fromJSON(decodedData, HighDefenseUsers.class);
                    identities.addAll(highDefenseUsers.getUsers());
                }
                catch (IOException e) {
                    this.logger.error((Object)"/v1/dpp/user/info/list get crpty data error!");
                    throw new LegoCheckedException(7100L);
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)("/v1/dpp/user/info/list get crpty data error!" + e.getMessage()));
                    throw new LegoCheckedException(7100L);
                }
            }
            catch (LegoCheckedException e) {
                throw new LegoCheckedException(7100L);
            }
        }
        return identities;
    }

    private DomainTokenModel parseResponseHandlerModel(ResponseHandlerModel responseHandlerModel) {
        List<Header> allHeaders = responseHandlerModel.getAllHeaders();
        String token = "";
        for (Header header : allHeaders) {
            if (header == null || null == header.getName() || !header.getName().equals("X-Subject-Token")) continue;
            token = header.getValue();
            break;
        }
        DomainTokenModel domainTokenModel = new DomainTokenModel();
        domainTokenModel.setToken(token);
        try {
            HuaweiCloudResponse huaweiCloudResponse = (HuaweiCloudResponse)JSONUtil.getInstance().fromJSON(responseHandlerModel.getEntityJson(), HuaweiCloudResponse.class);
            String domainId = huaweiCloudResponse.getToken().getUser().getDomain().getId();
            String projectId = huaweiCloudResponse.getToken().getProject().getId();
            domainTokenModel.setDomainId(domainId);
            domainTokenModel.setProjectId(projectId);
        }
        catch (IOException | NullPointerException e) {
            throw new LegoCheckedException(5200L);
        }
        return domainTokenModel;
    }

    private boolean hasAadInstances(HuaweiCloudIdentityForm huaweiCloudIdentityForm, String domainId, String token) {
        boolean hasAadInstances = false;
        try {
            ProxyInfo proxyInfo = this.loadProxyInfo(huaweiCloudIdentityForm);
            HighDefenseInstanceInfoList instanceList = HttpClientUtil.get(huaweiCloudIdentityForm.getHighDefenseUrl() + "/v1/" + domainId + "/aad-instances", token, null, null, HighDefenseInstanceInfoList.class, proxyInfo);
            if (instanceList != null) {
                hasAadInstances = instanceList.getInstanceInfoList().size() > 0;
            }
        }
        catch (LegoCheckedException e) {
            String errStr = e.getMessage();
            this.logger.error((Object)("hasAadInstances LegoCheckedException " + errStr));
            if (errStr != null && errStr.contains("12000004")) {
                return false;
            }
            throw e;
        }
        return hasAadInstances;
    }

    private static String assemblyBodyJson(HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        String userIdentity = huaweiCloudIdentityForm.getUserIdentity();
        String pwdIdentity = huaweiCloudIdentityForm.getPwdIdentity();
        String domainName = huaweiCloudIdentityForm.getDomainName();
        String projectName = huaweiCloudIdentityForm.getProjectName();
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("\"auth\":{\"identity\":{\"methods\":[\"password\"],\"password\":{\"user\":{");
        sb.append("\"name\":");
        sb.append("\"");
        sb.append(userIdentity);
        sb.append("\"");
        sb.append(",");
        sb.append("\"password\":");
        sb.append("\"");
        sb.append(pwdIdentity);
        sb.append("\"");
        if (null != domainName && !"".equals(domainName)) {
            sb.append(",");
            sb.append("\"domain\":{\"name\":");
            sb.append("\"");
            sb.append(domainName);
            sb.append("\"");
            sb.append("}");
        }
        sb.append("}}}");
        if (null != projectName && !"".equals(projectName)) {
            sb.append(",");
            sb.append("\"scope\":{");
            sb.append("\"project\":{\"name\":\"");
            sb.append(projectName);
            sb.append("\"");
            if (null != domainName && !"".equals(domainName)) {
                sb.append(",");
                sb.append("\"domain\":{\"name\":");
                sb.append("\"");
                sb.append(domainName);
                sb.append("\"");
                sb.append("}");
            }
            sb.append("}}}}");
        }
        if (null == domainName || "".equals(domainName)) {
            sb.append("}}}");
        }
        if (null == projectName || "".equals(projectName)) {
            sb.append("}}");
        }
        return sb.toString();
    }

    private ProxyInfo proxyInfo() {
        try {
            String json = ((SysConfigManagerImpl)ServiceContext.getInstance().getService("sysConfigMgr", SysConfigManagerImpl.class)).getSystemValue("huaweiCloudIdentity");
            if (null == json) {
                return null;
            }
            ProxyInfo proxyInfo = (ProxyInfo)JSONUtil.getInstance().fromJSON(json, ProxyInfo.class);
            String userDomain = StringUtils.isEmpty(proxyInfo.getUserDomain()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getUserDomain());
            String pwd = StringUtils.isEmpty(proxyInfo.getPwd()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getPwd());
            proxyInfo.setUserDomain(userDomain);
            proxyInfo.setPwd(pwd);
            return proxyInfo;
        }
        catch (IOException e) {
            this.logger.error((Object)"proxyInfo json error");
            return null;
        }
    }

    private ProxyInfo loadProxyInfo(HuaweiCloudIdentityForm huaweiCloudIdentityForm) {
        ProxyInfo proxyInfo = null == this.proxyInfo() ? new ProxyInfo() : this.proxyInfo();
        proxyInfo.getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthAdvancedCertAlias());
        proxyInfo.getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getHighDefenseUrl());
        return proxyInfo;
    }

    private static class HuaweiCloudIdentityTokenHolder {
        private static HuaweiCloudIdentityToken instance = new HuaweiCloudIdentityToken();

        private HuaweiCloudIdentityTokenHolder() {
        }
    }
}

