/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.highdefense.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.hs.atic.highdefense.domain.model.form.HuaweiCloudIdentityForm;
import com.hs.atic.highdefense.domain.service.IHuaweiCloudIdentityService;
import com.hs.atic.highdefense.util.DomainTokenModel;
import com.hs.atic.highdefense.util.HighDefenseToken;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.system.SysConfigManager;
import com.hs.atic.system.service.SysConfigManagerImpl;
import com.hs.atic.util.HttpClientUtil;
import com.hs.atic.util.ProxyInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.restful.util.JSONUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RestInvoker {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final int MAX_REPEAT_COUNT = 10;

    public static String post(String url, int bandwidth, String bodyJson, int times) {
        if (times > 10) {
            times = 10;
        }
        DomainTokenModel domainWithToken = null;
        domainWithToken = HighDefenseToken.getInstance().getToken(bandwidth);
        url = RestInvoker.urlPlaceHolder(url, bandwidth, domainWithToken.getDomainId(), domainWithToken.getProjectId());
        ProxyInfo proxyInfo = RestInvoker.loadProxyInfo();
        String json = null;
        try {
            json = HttpClientUtil.post(RestInvoker.getSchemeServer() + url, domainWithToken.getToken(), bodyJson, null, proxyInfo);
            return json;
        }
        catch (LegoCheckedException e) {
            if (times >= 0) {
                RestInvoker.sleep();
                HighDefenseToken.getInstance().setInvalid(true);
                return RestInvoker.post(url, bandwidth, bodyJson, --times);
            }
            logger.error((Object)("[RestInvoker post String] " + e.getMessage()));
            throw e;
        }
    }

    public static String post(String url, String bodyJson, int times) {
        if (times > 10) {
            times = 10;
        }
        DomainTokenModel domainWithToken = null;
        domainWithToken = HighDefenseToken.getInstance().getTokenDefense();
        url = RestInvoker.urlPlaceHolderDefense(url, domainWithToken.getDomainId(), domainWithToken.getProjectId());
        ProxyInfo proxyInfo = RestInvoker.loadProxyInfo();
        String json = null;
        try {
            json = HttpClientUtil.post(RestInvoker.getSchemeServer() + url, domainWithToken.getToken(), bodyJson, null, proxyInfo);
            return json;
        }
        catch (LegoCheckedException e) {
            if (times >= 0) {
                RestInvoker.sleep();
                HighDefenseToken.getInstance().setInvalid(true);
                return RestInvoker.post(url, bodyJson, --times);
            }
            logger.error((Object)("[RestInvoker post String] " + e.getMessage()));
            throw e;
        }
    }

    private static void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException e) {
            logger.error((Object)("sleep():" + e.getMessage()));
        }
    }

    public static String get(String url, int bandwidth, Map<String, Object> params, int times) {
        if (times > 10) {
            times = 10;
        }
        DomainTokenModel domainTokenModel = null;
        domainTokenModel = HighDefenseToken.getInstance().getToken(bandwidth);
        ProxyInfo proxyInfo = RestInvoker.loadProxyInfo();
        url = RestInvoker.urlPlaceHolder(url, bandwidth, domainTokenModel.getDomainId(), domainTokenModel.getProjectId());
        try {
            return HttpClientUtil.get(RestInvoker.getSchemeServer() + url, domainTokenModel.getToken(), params, null, proxyInfo);
        }
        catch (LegoCheckedException e) {
            if (times >= 0) {
                RestInvoker.sleep();
                HighDefenseToken.getInstance().setInvalid(true);
                return RestInvoker.get(url, bandwidth, params, --times);
            }
            logger.error((Object)("[RestInvoker get String] " + e.getMessage()));
            throw e;
        }
    }

    public static String get(String url, Map<String, Object> params, int times) {
        if (times > 10) {
            times = 10;
        }
        DomainTokenModel domainTokenModel = null;
        domainTokenModel = HighDefenseToken.getInstance().getTokenDefense();
        ProxyInfo proxyInfo = RestInvoker.loadProxyInfo();
        url = RestInvoker.urlPlaceHolderDefense(url, domainTokenModel.getDomainId(), domainTokenModel.getProjectId());
        try {
            return HttpClientUtil.get(RestInvoker.getSchemeServer() + url, domainTokenModel.getToken(), params, null, proxyInfo);
        }
        catch (LegoCheckedException e) {
            if (times >= 0) {
                RestInvoker.sleep();
                HighDefenseToken.getInstance().setInvalid(true);
                return RestInvoker.get(url, params, --times);
            }
            logger.error((Object)("[RestInvoker get String] " + e.getMessage()));
            throw e;
        }
    }

    private static ProxyInfo loadProxyInfo() {
        ProxyInfo proxyInfo = null == RestInvoker.proxyInfo() ? new ProxyInfo() : RestInvoker.proxyInfo();
        IHuaweiCloudIdentityService huaweiCloudIdentityService = (IHuaweiCloudIdentityService)ServiceContext.getInstance().getService("huaweiCloudIdentityService", IHuaweiCloudIdentityService.class);
        HuaweiCloudIdentityForm huaweiCloudIdentityForm = huaweiCloudIdentityService.queryCurrentHuaweiCloudConfig();
        proxyInfo.getCertCheckInfo().setAlias(huaweiCloudIdentityForm.getDefenceAuthAdvancedCertAlias());
        proxyInfo.getCertCheckInfo().setUrl(huaweiCloudIdentityForm.getHighDefenseUrl());
        return proxyInfo;
    }

    private static String urlPlaceHolder(String url, int bandwidth, String domainId, String projectId) {
        if (null != domainId && null != projectId) {
            url = RestInvoker.urlReplaceParams(url, domainId, projectId);
        }
        return url;
    }

    private static String urlPlaceHolderDefense(String url, String domainId, String projectId) {
        if (null != domainId && null != projectId) {
            url = RestInvoker.urlReplaceParams(url, domainId, projectId);
        }
        return url;
    }

    public static String getSchemeServer() {
        SysConfigManager sysConfigManager = (SysConfigManager)ServiceContext.getInstance().getService("sysConfigMgr", SysConfigManagerImpl.class);
        if (null == sysConfigManager) {
            String message = "[Hihg Defense][getSchemeServer] error!";
            throw new LegoCheckedException(7200L, message);
        }
        String highDefenseRestServer = sysConfigManager.getSystemValue("highDefenseRestServer");
        if (null == highDefenseRestServer) {
            String message = "[Hihg Defense][getSchemeServer] error!";
            throw new LegoCheckedException(7200L, message);
        }
        return highDefenseRestServer;
    }

    private static String urlReplaceParams(String url, String domainId, String project) {
        Pattern pattern = Pattern.compile("\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String keyPlaceHoder = matcher.group();
            String key = keyPlaceHoder.substring(1, keyPlaceHoder.length() - 1);
            try {
                if (key.equals("domain_id")) {
                    url = url.replace(keyPlaceHoder, domainId);
                }
                if (!key.equals("project_id")) continue;
                url = url.replace(keyPlaceHoder, project);
            }
            catch (Exception e) {
                throw new LegoCheckedException("String formatter failed", (Throwable)e);
            }
        }
        return url;
    }

    public static <T> T getTypeReference(String url, int bandwidth, Map<String, Object> params, int times, TypeReference<T> typeReference) {
        if (times > 10) {
            times = 10;
        }
        DomainTokenModel domainTokenModel = null;
        domainTokenModel = HighDefenseToken.getInstance().getToken(bandwidth);
        url = RestInvoker.urlPlaceHolder(url, bandwidth, domainTokenModel.getDomainId(), domainTokenModel.getProjectId());
        ProxyInfo proxyInfo = RestInvoker.loadProxyInfo();
        T json = null;
        try {
            json = HttpClientUtil.getTypeReference(RestInvoker.getSchemeServer() + url, domainTokenModel.getToken(), params, null, typeReference, proxyInfo);
            if (times >= 0) {
                RestInvoker.sleep();
                HighDefenseToken.getInstance().setInvalid(true);
                json = RestInvoker.getTypeReference(url, bandwidth, params, --times, typeReference);
            }
            return json;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("[RestInvoker get TypeReference] " + e.getMessage()));
            return json;
        }
    }

    public static <T> T post(String url, int bandwidth, Object body, int times, Class<T> clazz) {
        if (times > 10) {
            times = 10;
        }
        DomainTokenModel domainTokenModel = null;
        domainTokenModel = HighDefenseToken.getInstance().getToken(bandwidth);
        url = RestInvoker.urlPlaceHolder(url, bandwidth, domainTokenModel.getDomainId(), domainTokenModel.getProjectId());
        ProxyInfo proxyInfo = RestInvoker.loadProxyInfo();
        T json = null;
        try {
            json = HttpClientUtil.post(RestInvoker.getSchemeServer() + url, domainTokenModel.getToken(), body, null, clazz, proxyInfo);
            if (times >= 0) {
                RestInvoker.sleep();
                HighDefenseToken.getInstance().setInvalid(true);
                json = RestInvoker.post(url, bandwidth, body, --times, clazz);
            }
            return json;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("[RestInvoker post Class] " + e.getMessage()));
            return json;
        }
    }

    public static String put(String url, int bandwidth, String bodyJson, int times) {
        if (times > 10) {
            times = 10;
        }
        DomainTokenModel domainWithToken = null;
        domainWithToken = HighDefenseToken.getInstance().getToken(bandwidth);
        url = RestInvoker.urlPlaceHolder(url, bandwidth, domainWithToken.getDomainId(), domainWithToken.getProjectId());
        ProxyInfo proxyInfo = RestInvoker.loadProxyInfo();
        String json = null;
        try {
            json = HttpClientUtil.put(RestInvoker.getSchemeServer() + url, domainWithToken.getToken(), bodyJson, null, proxyInfo);
            return json;
        }
        catch (LegoCheckedException e) {
            if (times >= 0) {
                RestInvoker.sleep();
                HighDefenseToken.getInstance().setInvalid(true);
                return RestInvoker.put(url, bandwidth, bodyJson, --times);
            }
            logger.error((Object)("[RestInvoker put String] " + e.getMessage()));
            throw e;
        }
    }

    public static String put(String url, String bodyJson, int times) {
        if (times > 10) {
            times = 10;
        }
        DomainTokenModel domainWithToken = null;
        domainWithToken = HighDefenseToken.getInstance().getTokenDefense();
        url = RestInvoker.urlPlaceHolderDefense(url, domainWithToken.getDomainId(), domainWithToken.getProjectId());
        ProxyInfo proxyInfo = RestInvoker.loadProxyInfo();
        String json = null;
        try {
            json = HttpClientUtil.put(RestInvoker.getSchemeServer() + url, domainWithToken.getToken(), bodyJson, null, proxyInfo);
            return json;
        }
        catch (LegoCheckedException e) {
            if (times >= 0) {
                RestInvoker.sleep();
                HighDefenseToken.getInstance().setInvalid(true);
                return RestInvoker.put(url, bodyJson, --times);
            }
            logger.error((Object)("[RestInvoker put String] " + e.getMessage()));
            throw e;
        }
    }

    private static ProxyInfo proxyInfo() {
        try {
            String json = ((SysConfigManagerImpl)ServiceContext.getInstance().getService("sysConfigMgr", SysConfigManagerImpl.class)).getSystemValue("huaweiCloudIdentity");
            if (null == json) {
                return null;
            }
            ProxyInfo proxyInfo = (ProxyInfo)JSONUtil.getInstance().fromJSON(json, ProxyInfo.class);
            String userDomain = StringUtils.isEmpty(proxyInfo.getUserDomain()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getUserDomain());
            String pwd = StringUtils.isEmpty(proxyInfo.getPwd()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getPwd());
            proxyInfo.setUserDomain(userDomain);
            proxyInfo.setPwd(pwd);
            return proxyInfo;
        }
        catch (IOException e) {
            logger.error((Object)"proxyInfo json error");
            return null;
        }
    }
}

