/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.intelligentdefense.dao;

import com.hs.atic.intelligentdefense.entity.StreamMonitorRuleZoneMapping;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StreamMonitorRuleZoneMappingDao
extends CommonDaoImpl {
    public void save(List<StreamMonitorRuleZoneMapping> ruleZones) {
        for (StreamMonitorRuleZoneMapping ruleZone : ruleZones) {
            this.saveOrUpdate(ruleZone);
        }
    }

    public void remove(int id) {
        String hql = "delete from StreamMonitorRuleZoneMapping where id = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void removeByRuleZoneId(int ruleId, List<Long> zoneIds) {
        if (ruleId == 0 || zoneIds == null || zoneIds.isEmpty()) {
            return;
        }
        String hql = "delete from StreamMonitorRuleZoneMapping where ruleId = ?0 and zoneId in ( ";
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        params.put(0, ruleId);
        StringBuffer hqlBuffer = new StringBuffer();
        hqlBuffer.append(hql);
        this.getHqlParams(hqlBuffer, zoneIds, params);
        hqlBuffer.append(")");
        hql = hqlBuffer.toString();
        this.deleteBatch(hql, params);
    }

    public void removeByZoneId(List<Long> zoneIds) {
        if (zoneIds == null || zoneIds.isEmpty()) {
            return;
        }
        String hql = "delete from StreamMonitorRuleZoneMapping where zoneId in ( ";
        StringBuffer hqlBuffer = new StringBuffer();
        hqlBuffer.append(hql);
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        this.getHqlParams(hqlBuffer, zoneIds, params);
        hqlBuffer.append(")");
        hql = hqlBuffer.toString();
        this.deleteBatch(hql, params);
    }

    public List<Integer> getRuleIdByZoneId(List<Long> zoneIds) {
        ArrayList<Integer> ruleIds = new ArrayList<Integer>();
        if (zoneIds == null || zoneIds.isEmpty()) {
            return ruleIds;
        }
        String hql = "select ruleId from StreamMonitorRuleZoneMapping where zoneId in (?0) ";
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        Optional<String> zoneIdString = zoneIds.stream().map(i -> String.valueOf(i)).reduce((x, y) -> x + "," + y);
        params.put(0, zoneIdString.get());
        List tempRuleIds = this.findByHql(hql, params);
        for (int i2 = 0; i2 < tempRuleIds.size(); ++i2) {
            ruleIds.add((Integer)tempRuleIds.get(i2));
        }
        return ruleIds;
    }

    public List<StreamMonitorRuleZoneMapping> getByRuleId(List<Integer> ruleIds) {
        ArrayList<StreamMonitorRuleZoneMapping> mappings = new ArrayList<StreamMonitorRuleZoneMapping>();
        if (ruleIds == null || ruleIds.isEmpty()) {
            return mappings;
        }
        String hql = "from StreamMonitorRuleZoneMapping where ruleId in (?0) ";
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        Optional<String> ruleIdString = ruleIds.stream().map(i -> String.valueOf(i)).reduce((x, y) -> x + "," + y);
        params.put(0, ruleIdString.get());
        List tempMappings = this.findByHql(hql, params);
        for (int i2 = 0; i2 < tempMappings.size(); ++i2) {
            mappings.add((StreamMonitorRuleZoneMapping)tempMappings.get(i2));
        }
        return mappings;
    }

    public List<StreamMonitorRuleZoneMapping> getByZoneId(List<Long> zoneIds) {
        ArrayList<StreamMonitorRuleZoneMapping> mappings = new ArrayList<StreamMonitorRuleZoneMapping>();
        if (zoneIds == null || zoneIds.isEmpty()) {
            return mappings;
        }
        String hql = "from StreamMonitorRuleZoneMapping where zoneId in (?0) ";
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        Optional<String> zoneIdString = zoneIds.stream().map(i -> String.valueOf(i)).reduce((x, y) -> x + "," + y);
        params.put(0, zoneIdString.get());
        List tempMappings = this.findByHql(hql, params);
        for (int i2 = 0; i2 < tempMappings.size(); ++i2) {
            mappings.add((StreamMonitorRuleZoneMapping)tempMappings.get(i2));
        }
        return mappings;
    }

    private void getHqlParams(StringBuffer hql, List<Long> zoneIds, Map<Integer, Object> params) {
        for (int i = 0; i < zoneIds.size(); ++i) {
            if (0 == i) {
                hql.append("?" + params.size());
            } else {
                hql.append(",?" + params.size());
            }
            params.put(params.size(), zoneIds.get(i));
        }
    }
}

