/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.restful.client;

import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.atic.util.AticConstants;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.restful.util.HttpsConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public abstract class BaseRestClient {
    public static final String FILE_PATH = System.getProperty("user.dir") + "/../../vsm_conf/antiddos/attackIpConfig.xml";
    public static final String DEFAULT_LOGIN_URL = "https://host:port/v3/auth/tokens";
    public static final int GET_TOKEN_SUCCESS = 201;
    public static final int RETRY_TIMES = 3;
    public static final String TOKEN_HEADER = "X-Subject-Token";
    public static final String SUCCESS = "success";
    public static final String TOKEN_ILLEGAL = "tokenIllegal";
    public static final String TRUE_STRING = "2";
    public static final String FALSE_STRING = "1";
    protected static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REST);
    static String isOpen;
    static Properties prop;
    protected volatile Executor executor;
    protected IAlarmService alarmService;

    public BaseRestClient() {
        this.readConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig() {
        File configFile = new File(FILE_PATH);
        LOGGER.info((Object)("cloud config fileName : " + configFile.getName()));
        Class<BaseRestClient> clazz = BaseRestClient.class;
        synchronized (BaseRestClient.class) {
            if (null != prop) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            prop = new Properties();
            LOGGER.info((Object)"first read config file.");
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(configFile);
                prop.loadFromXML(fileInputStream);
            }
            catch (InvalidPropertiesFormatException e) {
                LOGGER.error((Object)("read config error." + e.getMessage()));
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"read config loadFromXML FileNotFoundException error.");
            }
            catch (IOException e) {
                LOGGER.error((Object)"read config loadFromXML IOException error.");
            }
            finally {
                if (null != fileInputStream) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"close stream error.");
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void createExecutor() {
        if (null != this.executor) return;
        Class<BaseRestClient> clazz = BaseRestClient.class;
        synchronized (BaseRestClient.class) {
            if (null != this.executor) return;
            LOGGER.info((Object)"first send blackhole ip, init executor,createConnect.");
            this.executor = Executors.newFixedThreadPool(5);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected boolean isOpen() {
        if ("false".equals(isOpen)) {
            LOGGER.info((Object)"send blackhole ip is not opened.");
            return false;
        }
        return true;
    }

    protected final AticAlarmObject generateAlarm(String alarmId, List<String> blackholeIps) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        String[] alarm = new String[]{blackholeIps.get(0)};
        alarmObject.setAlarmParam(alarm);
        alarmObject.setAlarmId(alarmId);
        alarmObject.setIsAlarm(Boolean.valueOf(true));
        alarmObject.setAlertTime(System.currentTimeMillis());
        alarmObject.setMoName("System");
        alarmObject.setMoIp("127.0.0.1");
        alarmObject.setMoId(Long.valueOf(1L));
        return alarmObject;
    }

    protected static final void createConnect() {
    }

    private CloseableHttpClient getHttpClient(String alias, String url) {
        RequestConfig defaultRequestConfig = null;
        Registry socketFactoryRegistry = null;
        PoolingHttpClientConnectionManager connectionManager = null;
        SSLConnectionSocketFactory socketFactory = null;
        socketFactory = BaseRestClient.enableSSL(alias, url);
        defaultRequestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
        connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableHttpResponse sendRequest(HttpPost post, String json, String url, Map<String, String> headers, String alias) throws UnsupportedEncodingException {
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = this.getHttpClient(alias, url);
        StringEntity entity = new StringEntity(json);
        entity.setContentEncoding("utf-8");
        entity.setContentType("application/json;charset=utf8");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            post.setHeader(entry.getKey(), entry.getValue());
        }
        post.setEntity((HttpEntity)entity);
        try {
            LOGGER.info((Object)("thread : " + Thread.currentThread().getName() + " ,httpClient execute start "));
            response = httpClient.execute((HttpUriRequest)post);
            LOGGER.info((Object)("thread : " + Thread.currentThread().getName() + " ,httpClient execute end "));
        }
        catch (ClientProtocolException e) {
            LOGGER.error((Object)("execute error. " + e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error((Object)"execute error. ");
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"response close in error");
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"httpClient close in error");
                }
            }
        }
        return response;
    }

    private static SSLConnectionSocketFactory enableSSL(String alias, String url) {
        try {
            HttpsConnection.HttpsConnectionX509TrustManager tm = new HttpsConnection.HttpsConnectionX509TrustManager(alias);
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(null, new TrustManager[]{tm}, new SecureRandom());
            return new SSLConnectionSocketFactory(context, new String[]{"TLSv1.2"}, AticConstants.getHttpSslSupportCiphersuites(), (HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(url));
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)("SSL is error," + e.getMessage()));
        }
        catch (KeyManagementException e) {
            LOGGER.error((Object)("SSL is error," + e.getMessage()));
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("LegoCheckedException is error," + e.getMessage()));
        }
        return null;
    }

    protected String dealResponse(CloseableHttpResponse response) {
        String result = "";
        if (null != response) {
            int httpCode = response.getStatusLine().getStatusCode();
            if (httpCode == 200) {
                result = SUCCESS;
            } else if (httpCode == 401) {
                result = TOKEN_ILLEGAL;
            } else {
                LOGGER.warn((Object)("thread : " + Thread.currentThread().getName() + " ,send faild. httpCode : " + httpCode));
            }
        }
        return result;
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }
}

