/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ConditionEvaluationResult;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.StreamMonitorAlarmHandlerService;
import com.hs.atic.rmi.StreamMonitorAlarmInfo;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class StreamMonitorAlarmHandlerServiceImpl
extends UnicastRemoteObject
implements StreamMonitorAlarmHandlerService {
    private static final long serialVersionUID = 3566870553198627944L;
    private static final Integer MISSING_ALARM = 0;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private transient IAlarmService alarmService = null;
    private transient IZoneService zoneService = null;

    protected StreamMonitorAlarmHandlerServiceImpl() throws RemoteException {
        super(16666);
    }

    public StreamMonitorAlarmHandlerServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
    }

    @Override
    public void streamMonitorAlarm(List<StreamMonitorAlarmInfo> streamMonitorAlarmInfos) throws RemoteException {
        if (null != streamMonitorAlarmInfos) {
            this.zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
            for (StreamMonitorAlarmInfo streamMonitorAlarmInfo : streamMonitorAlarmInfos) {
                logger.info((Object)("streamMonitorAlarmInfo:" + streamMonitorAlarmInfo.toString()));
                if (null == streamMonitorAlarmInfo.getAlarmType()) {
                    logger.warn((Object)"stream monitor alarm type is null");
                    continue;
                }
                if (null == this.zoneService) {
                    logger.warn((Object)"zoneService is null");
                    continue;
                }
                ZoneInfoForm zoneinfo = this.zoneService.getZoneNOIpById(streamMonitorAlarmInfo.getZoneId());
                AticAlarmObject alarmObject = new AticAlarmObject();
                String[] alarmParam = new String[4 + streamMonitorAlarmInfo.getConEvaluationResult().size()];
                if (null != zoneinfo) {
                    alarmParam[0] = streamMonitorAlarmInfo.getDefendIp();
                    alarmParam[1] = zoneinfo.getZoneName();
                    alarmParam[2] = streamMonitorAlarmInfo.getDeviceIp();
                    alarmParam[3] = streamMonitorAlarmInfo.getRuleName();
                    List<ConditionEvaluationResult> results = streamMonitorAlarmInfo.getConEvaluationResult();
                    if (null != results) {
                        for (int i = 0; i < results.size(); ++i) {
                            ConditionEvaluationResult result = results.get(i);
                            alarmParam[4 + i] = null == result.getMeasure() || result.getMeasure().isEmpty() ? "--" : result.getMeasure();
                        }
                    }
                    if (MISSING_ALARM.equals(streamMonitorAlarmInfo.getAlarmType())) {
                        alarmObject.setAlarmId("0x0000000803240840");
                    } else {
                        alarmObject.setAlarmId("0x0000000803240839");
                    }
                    alarmObject.setIsAlarm(Boolean.valueOf(true));
                    alarmObject.setMoId(streamMonitorAlarmInfo.getZoneId());
                    alarmObject.setMoName(zoneinfo.getZoneName());
                    alarmObject.setMoIp(streamMonitorAlarmInfo.getDefendIp());
                    alarmObject.setAlertTime(System.currentTimeMillis());
                    alarmObject.setAlarmParam(alarmParam);
                }
                try {
                    this.alarmService = (IAlarmService)ServiceContext.getInstance().getService("alarmService", IAlarmService.class);
                    this.alarmService.callAlarmQueue(alarmObject);
                }
                catch (Exception e) {
                    logger.error((Object)("stream monitor alarm error, ruleName=" + streamMonitorAlarmInfo.getRuleName() + " , alarm type = " + streamMonitorAlarmInfo.getAlarmType() + ". " + e.getMessage()));
                }
            }
        } else {
            logger.warn((Object)"stream monitor alarm is null");
        }
    }
}

