/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.bis.service.IZoneCollectorRmiProxyService;
import com.hs.atic.bis.service.ZoneStateBuffer;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.ZoneConfService;
import com.hs.atic.rmi.ZoneState;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyCustomService;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class ZoneConfServiceRmiImpl
extends UnicastRemoteObject
implements ZoneConfService {
    private static final long serialVersionUID = -2866639626475369029L;
    private transient IZonePolicyCustomService zonePolicyCustomService;
    private transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public ZoneConfServiceRmiImpl() throws RemoteException {
    }

    public ZoneConfServiceRmiImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
    }

    public IZonePolicyCustomService getZonePolicyCustomService() {
        return this.zonePolicyCustomService;
    }

    public void setZonePolicyCustomService(IZonePolicyCustomService zonePolicyCustomService) {
        this.zonePolicyCustomService = zonePolicyCustomService;
    }

    @Override
    public void notifyZoneStateChanged(ZoneState state, String collectorIp) throws RemoteException {
        if (null == state || null == collectorIp) {
            this.logger.error((Object)"notifyZoneStateChanged state is null");
            return;
        }
        String deviceIp = state.getDeviceIp();
        int status = state.getState();
        if (!IPUtil.isIpv4((String)deviceIp)) {
            this.logger.error((Object)"notifyZoneStateChanged deviceIp is error");
            return;
        }
        if (!String.valueOf(status).matches("^(1|2|3)$")) {
            this.logger.error((Object)"notifyZoneStateChanged status is error");
            return;
        }
        if (!IPUtil.isIpv4((String)collectorIp)) {
            this.logger.error((Object)"notifyZoneStateChanged collectorIp is error");
            return;
        }
        try {
            int totalState = ZoneStateBuffer.getInstance().getZoneState(state, collectorIp);
            this.logger.info((Object)("change zone state: zoneId:" + state.getZoneId() + ";collectorIp:" + collectorIp + ";changestate:" + totalState));
            if (null == this.zonePolicyCustomService) {
                IZoneCollectorRmiProxyService proxyService = ZoneReferUtil.getZoneCollectorRmiProxyService();
                this.zonePolicyCustomService = proxyService.getZonePolicyCustomService();
            }
            this.zonePolicyCustomService.updateZonePolicyApplyOfAbnormalState(state.getZoneId(), totalState);
        }
        catch (Exception e) {
            this.logger.error((Object)("notifyZoneStateChanged error. " + e.getMessage()));
        }
    }

    @Override
    public void notifyZoneStateInList(List<ZoneState> list, String collectorIp) throws RemoteException {
        if (null != list && !list.isEmpty()) {
            if (!IPUtil.isIpv4((String)collectorIp)) {
                this.logger.error((Object)"notifyZoneStateChanged collectorIp is error");
                return;
            }
            if (list.size() > 10000) {
                this.logger.error((Object)"notifyZoneStateChanged list size too long");
                return;
            }
            for (ZoneState state : list) {
                this.notifyZoneStateChanged(state, collectorIp);
            }
        }
    }
}

