/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.backup.form;

import com.hs.atic.sdk.backup.form.StepResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BackupProgress
implements Serializable {
    private static final long serialVersionUID = -2679300748991643290L;
    private boolean running = false;
    private int percent = 0;
    private List<String> steps = new ArrayList<String>();
    private String currentOper;
    private Map<String, StepResult> stepResults = Collections.synchronizedMap(new HashMap());
    private String progressDesc = "";

    public BackupProgress(String[] stepArray) {
        this.reset(stepArray);
    }

    public BackupProgress() {
        this.reset(null);
    }

    public String getProgressDesc() {
        return this.progressDesc;
    }

    public String getCurrentOper() {
        return this.currentOper;
    }

    public void setCurrentOper(String currentOper) {
        this.currentOper = currentOper;
    }

    public void reset(String[] stepArray) {
        this.running = false;
        this.percent = 0;
        this.steps = new ArrayList<String>();
        this.stepResults = new TreeMap<String, StepResult>();
        this.progressDesc = "";
        if (stepArray != null && stepArray.length > 0) {
            for (int i = 0; i < stepArray.length; ++i) {
                this.steps.add(stepArray[i]);
                this.stepResults.put(stepArray[i], new StepResult(stepArray[i], "RESULT_WAIT_TO_DO", ""));
            }
        }
    }

    public void setProgressDesc(String progressDesc) {
        this.progressDesc = progressDesc;
    }

    public StepResult getResult(String stepName) {
        return this.stepResults.get(stepName);
    }

    public StepResult setStepResult(StepResult state) {
        StepResult value = this.stepResults.get(state.getStepName());
        if (null == value) {
            value = this.stepResults.put(state.getStepName(), state);
        } else {
            value.setResult(state.getResult());
            value.setStepDetail(state.getStepDetail());
        }
        int total = this.stepResults.size();
        int completed = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepResult result = this.getResult(this.steps.get(i));
            if ("RESULT_SUCCEED".equals(result.getResult()) || "RESULT_FAILED".equals(result.getResult()) || "RESULT_COPLETE_WITH_ERROR".equals(result.getResult())) {
                ++completed;
            }
            if (!"RESULT_SUCCEED_RESTORE_ROLLBACK".equals(result.getResult()) && !"RESULT_FAILED_RESTORE_ROLLBACK".equals(result.getResult()) && !"RESULT_COPLETE_WITH_ERROR_RESTORE_ROLLBACK".equals(result.getResult())) continue;
            ++completed;
        }
        this.percent = completed * 100 / total;
        return value;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public void setSteps(List<String> steps) {
        this.steps = steps;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        if (running) {
            this.percent = 0;
        } else {
            for (int i = 0; i < this.steps.size(); ++i) {
                StepResult result = this.getResult(this.steps.get(i));
                if (!"RESULT_DOING".equals(result.getResult()) && !"RESULT_WAIT_TO_DO".equals(result.getResult())) continue;
                this.setStepResult(new StepResult(this.steps.get(i), "RESULT_CANCEL_WITH_EXCEPTION", ""));
            }
            this.percent = 100;
        }
        this.running = running;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }
}

