/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.backup.util;

import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.form.BackupConfig;
import com.hs.atic.sdk.backup.form.BackupDB;
import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.atic.sdk.system.form.BasicInfoForm;
import com.hs.atic.sdk.util.BasicInfoUtil;
import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class BackupConfigUtil {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static BasicInfoForm form = new BasicInfoForm();
    private static BackupConfig dbBackupConfig = new BackupConfig();
    private static final String DB_TYPE_MYSQL = "MySQL";

    private BackupConfigUtil() {
    }

    public static void setLogger(Log logger) {
        log = logger;
    }

    private static String getConfigItemFromElement(Element element, String nodeName, String defaultValue) {
        Element confElement = element.element(nodeName);
        if (confElement != null) {
            return confElement.getTextTrim();
        }
        return defaultValue;
    }

    private static void setConfigBackupDBs(List<Element> dbs, List<BackupDB> backupDBs) {
        for (int i = 0; i < dbs.size(); ++i) {
            Element dbElement = dbs.get(i);
            Integer id = Integer.valueOf(dbElement.attributeValue("id"));
            String dbname = dbElement.attributeValue("name");
            String dbtype = dbElement.attributeValue("type");
            ArrayList<String> tables = new ArrayList<String>();
            BackupDB backupDB = new BackupDB(id, dbname, dbtype, tables);
            backupDBs.add(backupDB);
            Element tablesElement = dbElement.element("tables");
            if (tablesElement == null || BackupConfigUtil.isCollectionEmpty(tablesElement.elements())) continue;
            List dbtables = tablesElement.elements();
            HashSet<String> tableSet = new HashSet<String>();
            for (int j = 0; j < dbtables.size(); ++j) {
                String fullTalbeName = ((Element)dbtables.get(j)).getTextTrim();
                tableSet.add(fullTalbeName.toLowerCase(Locale.ENGLISH));
            }
            backupDB.getTables().addAll(tableSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupConfig loadBackupConfig() {
        BackupConfig backupConfig = new BackupConfig();
        backupConfig.setInstallPath(form.getInstallPath());
        backupConfig.setHost(form.getHost());
        backupConfig.setPassword(form.getPassword());
        backupConfig.setUserName(form.getUser());
        backupConfig.setDbPort(form.getPort());
        backupConfig.setFileVersion(form.getVersion());
        InputStream is = null;
        try {
            File fileinstall = new File(backupConfig.getInstallPath());
            is = BackupConfigUtil.class.getResourceAsStream("/com/hs/atic/sdk/backup/config/BackupConfig.xml");
            SAXReader saxReader = new SAXReader();
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            Document document = saxReader.read(is);
            Element rootElem = document.getRootElement();
            Element backupInfoElem = rootElem.element("BackupBaseInfo");
            String buckupDir = BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "BackupDir", "VSMDBbackup");
            backupConfig.setBackupDir(fileinstall.getParent() + File.separator + buckupDir);
            String buckupBatDir = BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "BackupBatDir", "\\Runtime\\bin");
            backupConfig.setBackupBatDir(fileinstall.getCanonicalPath() + buckupBatDir);
            backupConfig.setBackupInfoDBName(BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "BackupInfoDB", null));
            backupConfig.setBackupInfoTableName(BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "BackupInfoTable", null));
            backupConfig.setFpid(BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "fpid", null));
            backupConfig.setSlaveMoTable(BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "SlaveMoTable", null));
            backupConfig.setMoCheckMode(BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "MOCheckMode", null));
            backupConfig.setCharSet(BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "Charset", "UTF-8"));
            backupConfig.setUiMsgLocale(BackupConfigUtil.getConfigItemFromElement(backupInfoElem, "UIMsgLocale", "zh_CN"));
            Element backupDBListElement = rootElem.element("BackupDBList");
            ArrayList<BackupDB> backupDBs = new ArrayList<BackupDB>();
            backupConfig.setDatabases(backupDBs);
            if (null != backupDBListElement && !BackupConfigUtil.isCollectionEmpty(backupDBListElement.elements())) {
                BackupConfigUtil.setConfigBackupDBs(backupDBListElement.elements(), backupDBs);
            }
        }
        catch (IOException e) {
            log.error((Object)"loadBackupConfig setConfigBackupDBs ioException");
        }
        catch (SAXException e) {
            log.error((Object)"Failed to load backup configuration because of SAXEception.");
        }
        catch (DocumentException e) {
            log.error((Object)e.getMessage());
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"loadBackupConfig ioException");
            }
        }
        return backupConfig;
    }

    public static boolean isCollectionEmpty(Collection coll) {
        return null == coll || coll.isEmpty();
    }

    public static boolean isEmptyString(String value) {
        return null == value || value.trim().length() == 0;
    }

    public static String formatTime(long time) {
        SimpleDateFormat siFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return siFormat.format(time);
    }

    private static void checkDBConfig(BackupConfig currentBackupConfig) throws ConfigBackupException {
        if (null == currentBackupConfig.getHost() || null == currentBackupConfig.getPassword() || null == currentBackupConfig.getUserName() || null == currentBackupConfig.getDbPort()) {
            throw new ConfigBackupException(571637);
        }
        if (!DB_TYPE_MYSQL.equals(form.getDbType())) {
            throw new ConfigBackupException(571638);
        }
        currentBackupConfig.setDbDriverClass("com.mysql.jdbc.Driver");
    }

    private static void checkBackupConfig(BackupConfig currentBackupConfig) throws ConfigBackupException {
        boolean flag9;
        boolean flag1 = null == currentBackupConfig.getBackupDir();
        boolean flag2 = null == currentBackupConfig.getBackupBatDir();
        boolean flag3 = null == currentBackupConfig.getBackupInfoTableName();
        boolean flag4 = null == currentBackupConfig.getBackupInfoDBName();
        boolean flag5 = BackupConfigUtil.isCollectionEmpty(currentBackupConfig.getDatabases());
        boolean flag6 = null == currentBackupConfig.getCharSet();
        boolean flag7 = null == currentBackupConfig.getUiMsgLocale();
        boolean flag8 = flag1 || flag2 || flag3;
        boolean bl = flag9 = flag4 || flag5 || flag6 || flag7;
        if (flag8 || flag9) {
            throw new ConfigBackupException(571639);
        }
        if (null == currentBackupConfig.getFpid() || null == currentBackupConfig.getMoCheckMode() || null == currentBackupConfig.getSlaveMoTable()) {
            throw new ConfigBackupException(571640);
        }
    }

    public static BackupConfig getCurrentBackupConfig() throws ConfigBackupException {
        BackupConfig currentBackupConfig = new BackupConfig(dbBackupConfig);
        BackupConfigUtil.checkDBConfig(currentBackupConfig);
        BackupConfigUtil.checkBackupConfig(currentBackupConfig);
        return currentBackupConfig;
    }

    public static String currentATICVersion() throws ConfigBackupException {
        if (null == dbBackupConfig.getFpid()) {
            throw new ConfigBackupException(571641);
        }
        return form.getVersion() + '_' + dbBackupConfig.getFpid();
    }

    public static BackupConfig getRestoreBackupConfig(ConfigBackupDBBean configBackupDBBean) throws ConfigBackupException {
        BackupConfig backupConfig = BackupConfigUtil.getCurrentBackupConfig();
        backupConfig.setBackupTime(configBackupDBBean.getBackupTime());
        backupConfig.setBackupFile(configBackupDBBean.getBackupBase());
        backupConfig.setFileFingerprint(configBackupDBBean.getFileHashCode());
        backupConfig.setFileVersion(configBackupDBBean.getVersion());
        backupConfig.setFileSource(configBackupDBBean.getFileSource());
        return backupConfig;
    }

    static {
        try {
            form = BasicInfoUtil.getBasicInfo();
            dbBackupConfig = BackupConfigUtil.loadBackupConfig();
        }
        catch (Exception e) {
            log.error((Object)("BackupConfigUtil init error." + e.getMessage()));
        }
    }
}

