/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.zone.util;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ProgressState
implements Serializable {
    private static final long serialVersionUID = 9134993258519014226L;
    private static ReentrantLock lock = new ReentrantLock();
    private Boolean isStop = false;
    private long progressId;
    private int totalStep;
    private int currentStep = 0;
    private String currentTask;
    private List<String> historyRecord;
    private List<String> cacheRecord;

    public ProgressState() {
    }

    public ProgressState(int totalStep, long progressId) {
        this.totalStep = totalStep;
        this.progressId = progressId;
        this.currentStep = 0;
    }

    public void next() {
        lock.lock();
        try {
            ++this.currentStep;
        }
        finally {
            lock.unlock();
        }
    }

    public void next(int steps) {
        lock.lock();
        try {
            this.currentStep += steps;
        }
        finally {
            lock.unlock();
        }
    }

    public int getProgress() {
        lock.lock();
        try {
            int progress;
            int n = progress = this.currentStep * 100 / this.totalStep;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public Boolean getIsStop() {
        return this.isStop;
    }

    public void setIsStop(Boolean isStop) {
        this.isStop = isStop;
    }

    public long getProgressId() {
        return this.progressId;
    }

    public void setProgressId(long progressId) {
        this.progressId = progressId;
    }

    public int getTotalStep() {
        return this.totalStep;
    }

    public void setTotalStep(int totalStep) {
        this.totalStep = totalStep;
    }

    public int getCurrentStep() {
        lock.lock();
        try {
            int n = this.currentStep;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public void setCurrentStep(int currentStep) {
        lock.lock();
        try {
            this.currentStep = currentStep;
        }
        finally {
            lock.unlock();
        }
    }

    public String getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(String currentTask) {
        this.currentTask = currentTask;
    }

    public List<String> getHistoryRecord() {
        return this.historyRecord;
    }

    public void setHistoryRecord(List<String> historyRecord) {
        this.historyRecord = historyRecord;
    }

    public List<String> getCacheRecord() {
        return this.cacheRecord;
    }

    public void setCacheRecord(List<String> cacheRecord) {
        this.cacheRecord = cacheRecord;
    }
}

