/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.CertCheckInfo;
import com.hs.atic.util.ProxyInfo;
import com.hs.atic.util.ResponseHandlerModel;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.restful.util.HttpsConnection;
import com.restful.util.JSONUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final Pattern PATTERN = Pattern.compile("<(.*?)>");
    private static final String PATTERN_RESPONSE_HTML_REG = "([\\s\\S]*)(<html>)([\\s\\S]*)(</html>)([\\s\\S]*)";
    private static final Pattern PATTERN_RESPONSE_HTML = Pattern.compile("([\\s\\S]*)(<html>)([\\s\\S]*)(</html>)([\\s\\S]*)");
    private static final int HTTP_STATUS_OK = 200;
    private static final int HTTP_STATUS_OK_RANGE = 300;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private static CloseableHttpClient getHttpClient(ProxyInfo proxyInfo, CertCheckInfo certCheckInfo) {
        HttpHost proxy = null;
        DefaultProxyRoutePlanner defaultProxyRoutePlanner = null;
        BasicCredentialsProvider credsProvider = null;
        try {
            if (null != proxyInfo && !StringUtils.isEmpty(proxyInfo.getProxy()) && proxyInfo.getPort() > 0) {
                proxy = new HttpHost(proxyInfo.getProxy(), proxyInfo.getPort(), "http");
            }
            if (null != proxy && null != proxyInfo && !StringUtils.isEmpty(proxyInfo.getUserDomain()) && !StringUtils.isEmpty(proxyInfo.getPwd())) {
                credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(proxyInfo.getUserDomain(), proxyInfo.getPwd()));
            }
            if (null != proxy && null == credsProvider) {
                defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(proxy);
            }
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{new HttpsConnection.HttpsConnectionX509TrustManager(certCheckInfo.getAlias())}, new SecureRandom());
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, AticConstants.getHttpSslSupportCiphersuites(), (HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(certCheckInfo.getUrl()));
            Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslConnectionSocketFactory).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setDefaultCookieStore((CookieStore)new BasicCookieStore()).setConnectionManager((HttpClientConnectionManager)cm);
            if (null != defaultProxyRoutePlanner) {
                httpClientBuilder.setRoutePlanner((HttpRoutePlanner)defaultProxyRoutePlanner);
            }
            if (null != credsProvider) {
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            if (null != proxy) {
                httpClientBuilder = httpClientBuilder.setProxy(proxy);
            }
            CloseableHttpClient httpclient = httpClientBuilder.build();
            return httpclient;
        }
        catch (KeyManagementException e) {
            logger.error((Object)("HttpClientUtil KeyManagementException: " + e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("HttpClientUtil NoSuchAlgorithmException: " + e.getMessage()));
        }
        return HttpClients.createDefault();
    }

    private static void globalThrow(SSLException e) {
        if (e.getMessage().contains("9600100")) {
            throw new LegoCheckedException(9600100L);
        }
        if (e.getMessage().contains("9600200")) {
            throw new LegoCheckedException(9600200L);
        }
        if (e.getMessage().contains("9600300")) {
            throw new LegoCheckedException(9600300L);
        }
        if (e.getMessage().contains("9600400")) {
            throw new LegoCheckedException(9600400L);
        }
    }

    public static ResponseHandlerModel postResponse(String uri, String xAuthToken, String bodyJson, Map<String, String> headers, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        try {
            ResponseHandlerModel responseHandlerModel;
            String fullUrl = HttpClientUtil.buildUrlWithParams(uri, null);
            HttpPost httpPost = new HttpPost(fullUrl);
            StringEntity bodyParams = new StringEntity(bodyJson, "UTF-8");
            httpPost.setEntity((HttpEntity)bodyParams);
            HttpClientUtil.initHeader(headers, (HttpRequestBase)httpPost);
            ResponseHandlerModel responseHandlerModel2 = responseHandlerModel = (ResponseHandlerModel)client.execute((HttpUriRequest)httpPost, HttpClientUtil.getResponseHandlerWithHeader());
            return responseHandlerModel2;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil ResponseHandlerModel postResponse SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[Post-ResponseHandlerModel]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = PATTERN.matcher(errorMessage).group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    public static String get(String uri, String xAuthToken, Map<String, Object> params, Map<String, String> headers, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        return HttpClientUtil.get(client, uri, params, headers);
    }

    public static String post(String uri, String xAuthToken, String bodyJson, Map<String, String> headers, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        return HttpClientUtil.post(client, uri, headers, bodyJson);
    }

    public static <T> T get(String uri, String xAuthToken, Map<String, Object> params, Map<String, String> headers, Class<T> responseType, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        return HttpClientUtil.get(client, uri, params, headers, responseType);
    }

    public static <T> T post(String uri, String xAuthToken, Object body, Map<String, String> headers, Class<T> responseType, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        return HttpClientUtil.post(client, uri, headers, body, responseType);
    }

    public static <T> T getTypeReference(String uri, String xAuthToken, Map<String, Object> params, Map<String, String> headers, TypeReference<T> typeReference, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        return HttpClientUtil.getTypeReference(client, uri, params, headers, typeReference);
    }

    public static <T> T postTypeReference(String uri, String xAuthToken, Object body, Map<String, String> headers, TypeReference<T> typeReference, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        return HttpClientUtil.postTypeReference(client, uri, headers, body, typeReference);
    }

    private static String get(CloseableHttpClient client, String uri, Map<String, Object> params, Map<String, String> headers) {
        try {
            String httpResponseString = HttpClientUtil.execute(client, uri, params, headers);
            logger.info((Object)("URL: " + uri + " String get " + httpResponseString));
            String string = httpResponseString;
            return string;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil String get SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[Get-String]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    private static String post(CloseableHttpClient client, String uri, Map<String, String> headers, String bodyJSON) {
        try {
            String fullUrl = HttpClientUtil.buildUrlWithParams(uri, null);
            HttpPost httpPost = new HttpPost(fullUrl);
            StringEntity bodyParams = new StringEntity(bodyJSON, "UTF-8");
            httpPost.setEntity((HttpEntity)bodyParams);
            HttpClientUtil.initHeader(headers, (HttpRequestBase)httpPost);
            String httpResponseString = (String)client.execute((HttpUriRequest)httpPost, HttpClientUtil.getDefaultResponseHandler());
            logger.info((Object)("String post " + httpResponseString));
            String string = httpResponseString;
            return string;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil String post SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[Post-String]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    private static <T> T get(CloseableHttpClient client, String uri, Map<String, Object> params, Map<String, String> headers, Class<T> responseType) {
        try {
            String httpResponseString = HttpClientUtil.execute(client, uri, params, headers);
            logger.info((Object)("<T> T get : " + httpResponseString));
            Object object = JSONUtil.getInstance().fromJSON(httpResponseString, responseType);
            return (T)object;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil <T> T get SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[Get]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    private static String execute(CloseableHttpClient client, String uri, Map<String, Object> params, Map<String, String> headers) throws IOException {
        String fullUrl = HttpClientUtil.buildUrlWithParams(uri, params);
        HttpGet httpGet = new HttpGet(fullUrl);
        HttpClientUtil.initHeader(headers, (HttpRequestBase)httpGet);
        return (String)client.execute((HttpUriRequest)httpGet, HttpClientUtil.getDefaultResponseHandler());
    }

    private static <T> T post(CloseableHttpClient client, String uri, Map<String, String> headers, Object body, Class<T> responseType) {
        try {
            String httpResponseString = HttpClientUtil.execute(client, uri, headers, body);
            logger.info((Object)("<T> T post : " + httpResponseString));
            Object object = JSONUtil.getInstance().fromJSON(httpResponseString, responseType);
            return (T)object;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil <T> T post SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[Post]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    private static <T> T getTypeReference(CloseableHttpClient client, String uri, Map<String, Object> params, Map<String, String> headers, TypeReference<T> typeReference) {
        try {
            String httpResponseString = HttpClientUtil.execute(client, uri, params, headers);
            logger.info((Object)("<T> T getTypeReference : " + httpResponseString));
            Object object = JSONUtil.getInstance().fromJSON(httpResponseString, typeReference);
            return (T)object;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil getTypeReference SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[getTypeReference]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    private static <T> T postTypeReference(CloseableHttpClient client, String uri, Map<String, String> headers, Object body, TypeReference<T> typeReference) {
        try {
            String httpResponseString = HttpClientUtil.execute(client, uri, headers, body);
            logger.info((Object)("<T> T postTypeReference : " + httpResponseString));
            Object object = JSONUtil.getInstance().fromJSON(httpResponseString, typeReference);
            return (T)object;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil postTypeReference SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[postTypeReference]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    private static String execute(CloseableHttpClient client, String uri, Map<String, String> headers, Object body) throws IOException {
        String fullUrl = HttpClientUtil.buildUrlWithParams(uri, null);
        HttpPost httpPost = new HttpPost(fullUrl);
        StringEntity bodyParams = new StringEntity(body instanceof String ? body.toString() : JSONUtil.getInstance().toJSON(body), "UTF-8");
        httpPost.setEntity((HttpEntity)bodyParams);
        HttpClientUtil.initHeader(headers, (HttpRequestBase)httpPost);
        return (String)client.execute((HttpUriRequest)httpPost, HttpClientUtil.getDefaultResponseHandler());
    }

    private static String buildUrlWithParams(String uri, Map<String, Object> params) throws UnsupportedEncodingException {
        StringBuilder urlBuilder = new StringBuilder(uri);
        if (null != params && !params.isEmpty()) {
            if (!uri.contains("?")) {
                urlBuilder.append("?");
            }
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String valueStr;
                String key = entry.getKey();
                Object value = entry.getValue();
                String string = valueStr = null == value ? "" : value.toString();
                if (!urlBuilder.toString().endsWith("?")) {
                    urlBuilder.append("&");
                }
                urlBuilder.append(key).append("=").append(URLEncoder.encode(valueStr, "utf-8"));
            }
        }
        String fullUrl = urlBuilder.toString();
        return fullUrl;
    }

    private static ResponseHandler<String> getDefaultResponseHandler() {
        ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                String entityString;
                int status;
                int n = status = null == response || null == response.getStatusLine() ? 0 : response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                String string = entityString = null != response && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity()) : null;
                if (null != entityString && entityString.matches(HttpClientUtil.PATTERN_RESPONSE_HTML_REG)) {
                    logger.info((Object)("entityString with html : " + entityString));
                    entityString = entityString.substring(0, entityString.indexOf("<html>"));
                }
                if (null != entityString && entityString.indexOf("<html>") != -1) {
                    entityString = entityString.substring(0, entityString.indexOf("<html>"));
                }
                boolean is = null != entityString && entityString.length() > 0;
                String message = "[HttpClientUtil getDefaultResponseHandler request error] Unexpected response status : " + status + (is ? "<response error code : " + entityString + ">" : "");
                throw new ClientProtocolException(message);
            }
        };
        return responseHandler;
    }

    public static ResponseHandlerModel getByProxy(String uri, String xAuthToken, Map<String, Object> params, Map<String, String> headers, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        try {
            ResponseHandlerModel httpResponse;
            String fullUrl = HttpClientUtil.buildUrlWithParams(uri, params);
            HttpGet httpGet = new HttpGet(fullUrl);
            HttpClientUtil.initHeader(headers, (HttpRequestBase)httpGet);
            ResponseHandlerModel responseHandlerModel = httpResponse = (ResponseHandlerModel)client.execute((HttpUriRequest)httpGet, HttpClientUtil.getResponseHandlerWithHeader());
            return responseHandlerModel;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil getByProxy SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[Get-getByProxy]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    public static ResponseHandlerModel postByProxy(String uri, String xAuthToken, String bodyJson, Map<String, String> headers, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        try {
            ResponseHandlerModel httpResponse;
            String fullUrl = HttpClientUtil.buildUrlWithParams(uri, null);
            HttpPost httpPost = new HttpPost(fullUrl);
            StringEntity bodyParams = new StringEntity(bodyJson, "UTF-8");
            httpPost.setEntity((HttpEntity)bodyParams);
            HttpClientUtil.initHeader(headers, (HttpRequestBase)httpPost);
            ResponseHandlerModel responseHandlerModel = httpResponse = (ResponseHandlerModel)client.execute((HttpUriRequest)httpPost, HttpClientUtil.getResponseHandlerWithHeader());
            return responseHandlerModel;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil postByProxy SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[Post-postByProxy]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    private static ResponseHandler<ResponseHandlerModel> getResponseHandlerWithHeader() {
        ResponseHandler<ResponseHandlerModel> responseHandler = new ResponseHandler<ResponseHandlerModel>(){

            public ResponseHandlerModel handleResponse(HttpResponse response) throws IOException {
                String entityString;
                int status;
                int n = status = null == response || null == response.getStatusLine() ? 0 : response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    Header[] allHeaders = response.getAllHeaders();
                    HttpEntity entity = response.getEntity();
                    String entityString2 = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    ResponseHandlerModel result = new ResponseHandlerModel();
                    result.setAllHeaders(Arrays.asList(allHeaders));
                    result.setEntityJson(entityString2);
                    return result;
                }
                String string = entityString = null != response && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity()) : null;
                if (null != entityString && entityString.matches(HttpClientUtil.PATTERN_RESPONSE_HTML_REG)) {
                    logger.info((Object)("entityString with html : " + entityString));
                    entityString = entityString.substring(0, entityString.indexOf("<html>"));
                }
                if (null != entityString && entityString.indexOf("<html>") != -1) {
                    entityString = entityString.substring(0, entityString.indexOf("<html>"));
                }
                boolean is = null != entityString && entityString.length() > 0;
                String message = "[HttpClientUtil getResponseHandlerWithHeader request error] Unexpected response status : " + status + (is ? "<response error code : " + entityString + ">" : "");
                throw new ClientProtocolException(message);
            }
        };
        return responseHandler;
    }

    public static String put(String uri, String xAuthToken, String bodyJson, Map<String, String> headers, ProxyInfo proxyInfo) {
        CloseableHttpClient client = HttpClientUtil.getHttpClient(proxyInfo, proxyInfo.getCertCheckInfo());
        headers = HttpClientUtil.initHeaderAuth(xAuthToken, headers);
        try {
            String fullUrl = HttpClientUtil.buildUrlWithParams(uri, null);
            HttpPut httpPost = new HttpPut(fullUrl);
            StringEntity bodyParams = new StringEntity(bodyJson, "UTF-8");
            httpPost.setEntity((HttpEntity)bodyParams);
            HttpClientUtil.initHeader(headers, (HttpRequestBase)httpPost);
            String httpResponseString = (String)client.execute((HttpUriRequest)httpPost, HttpClientUtil.getDefaultResponseHandler());
            logger.info((Object)("String put " + httpResponseString));
            String string = httpResponseString;
            return string;
        }
        catch (SSLException e) {
            logger.error((Object)("HttpClientUtil put SSLException e" + e.getMessage()));
            HttpClientUtil.globalThrow(e);
            throw new LegoCheckedException(9600200L);
        }
        catch (IOException e) {
            String message = String.format("HttpClientUtil-[Put-String]Request url: %s failed. %s", uri, e.getMessage());
            logger.error((Object)message);
            String errorMessage = message;
            Matcher matcher = PATTERN.matcher(errorMessage);
            if (matcher.find()) {
                errorMessage = matcher.group();
            }
            throw new LegoCheckedException(7100L, errorMessage);
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    private static Map<String, String> initHeaderAuth(String xAuthToken, Map<String, String> headers) {
        if (null == headers) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/json;charset=utf-8");
        headers.put("Accept", "application/json;charset=utf-8");
        if (null != xAuthToken && !"".equals(xAuthToken)) {
            headers.put("X-Auth-Token", xAuthToken);
        }
        return headers;
    }

    private static void initHeader(Map<String, String> headers, HttpRequestBase httpRequestBase) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequestBase.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

