/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.bis.dao.LibraryFileDao;
import com.hs.atic.bis.dao.LocationCustomDao;
import com.hs.atic.bis.model.LibraryFile;
import com.hs.atic.bis.model.LocationCustom;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.util.IpLocationUtil;
import com.hs.atic.util.LibFilePathUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.service.IAlarmInitService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;

public class InitLocationCustomPkid
implements InitializingBean {
    public static final String LOCATION_SDB_FILE_NAME = "location_sdb_default.zip";
    private IAlarmInitService alarmService;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LocationCustomDao locationCustomDao;
    private ILibraryFileService libraryFileService;
    private LibraryFileDao libraryFileDao;

    public void afterPropertiesSet() {
        this.setPkidFromNum();
        this.loadIpLocationToMemery();
    }

    private void loadIpLocationToMemery() {
        this.processIpLocationLibFile();
        this.processIpLocationCustom();
    }

    private void processIpLocationLibFile() {
        String libFilePath = LibFilePathUtil.getLibFilePath();
        LibraryFile libFile = null;
        int exceptionTimes = 0;
        while (true) {
            try {
                libFile = this.libraryFileDao.getDeployedIpLocationFile();
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("notifyDao libraryFileDao with error" + e.getMessage()));
                if (++exceptionTimes >= 10) {
                    this.alarmService.callinitAlarm("atic.bis.libraryFile.libType.location", "t_atic_library_file");
                    break;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    this.logger.error((Object)("sleep error." + ex.getMessage()));
                }
                continue;
            }
            break;
        }
        libFilePath = null == libFile ? libFilePath + LOCATION_SDB_FILE_NAME : libFilePath + libFile.getLibName();
        IpLocationUtil.loadIpLocFileDataToMemery(libFilePath);
    }

    private void processIpLocationCustom() {
        List<Object> locCusList = new ArrayList();
        int exceptionTimes = 0;
        while (true) {
            try {
                locCusList = this.locationCustomDao.getAll();
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("notifyDao locationCustomDao with error" + e.getMessage()));
                if (++exceptionTimes >= 10) {
                    this.alarmService.callinitAlarm("atic.destip.domain.list", "t_atic_location_custom");
                    break;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.error((Object)("sleep error." + interruptedException.getMessage()));
                }
                continue;
            }
            break;
        }
        for (LocationCustom locationCustom : locCusList) {
            IpLocationUtil.loadIpLocCusDataToMemery(locationCustom);
        }
    }

    private void setPkidFromNum() {
        String setTablePkidStartNumHQL = "ALTER TABLE t_atic_location_custom AUTO_INCREMENT=3000";
        try {
            this.locationCustomDao.updateBySql("ALTER TABLE t_atic_location_custom AUTO_INCREMENT=3000");
            this.logger.info((Object)"AUTO_INCREMENT is 3000");
        }
        catch (Exception e) {
            this.logger.error((Object)"setPkidFromNum Error ");
        }
    }

    public LocationCustomDao getLocationCustomDao() {
        return this.locationCustomDao;
    }

    public void setLocationCustomDao(LocationCustomDao locationCustomDao) {
        this.locationCustomDao = locationCustomDao;
    }

    public ILibraryFileService getLibraryFileService() {
        return this.libraryFileService;
    }

    public void setLibraryFileService(ILibraryFileService libraryFileService) {
        this.libraryFileService = libraryFileService;
    }

    public LibraryFileDao getLibraryFileDao() {
        return this.libraryFileDao;
    }

    public void setLibraryFileDao(LibraryFileDao libraryFileDao) {
        this.libraryFileDao = libraryFileDao;
    }

    public void setAlarmService(IAlarmInitService alarmService) {
        this.alarmService = alarmService;
    }
}

