/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.util.AticUtil;
import com.hs.atic.util.SystemToolFactory;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public abstract class ZipUtil {
    public static final int BLKSIZ = 8192;
    public static final int TOOBIG = 0x6400000;
    public static final int TOOMANY = 1024;
    private static final String ZIP_FILE_SEPARATOR = "/";
    private static final Character ZIP_FILE_SEPARATOR_CHAR = Character.valueOf('/');
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String inputFilePath, String zipFilePath, String baseName) {
        logger.info((Object)"zip-->begin");
        ZipOutputStream zOut = null;
        try {
            logger.info((Object)"inputFilePath1:");
            logger.info((Object)("baseName:" + ZipUtil.getcleanedMessage(baseName)));
            logger.info((Object)"zipFilePath:");
            zOut = new ZipOutputStream(new FileOutputStream(zipFilePath));
            ZipUtil.zip(zOut, new File(inputFilePath), baseName);
        }
        catch (IOException e) {
            logger.error((Object)"zip IOException");
        }
        catch (RuntimeException e) {
            logger.error((Object)"zip RuntimeException");
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close ZipOutputStream error");
            }
        }
        logger.info((Object)"zip-->end");
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipWithFilter(String inputFilePath, String zipFilePath, String baseName, List<String> filterList) {
        ZipOutputStream zOut = null;
        try {
            logger.info((Object)"inputFilePath1:");
            logger.info((Object)("baseName:" + ZipUtil.getcleanedMessage(baseName)));
            logger.info((Object)"zipFilePath:");
            zOut = new ZipOutputStream(new FileOutputStream(zipFilePath));
            logger.info((Object)"zip-->begin");
            ZipUtil.zipWithFilter(zOut, new File(inputFilePath), baseName, filterList);
            logger.info((Object)"zip-->end");
        }
        catch (IOException e) {
            logger.error((Object)"zipWithFilter IOException");
        }
        catch (RuntimeException e) {
            logger.error((Object)"zipWithFilter RuntimeException");
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close ZipOutputStream error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipWithFilter(ZipOutputStream zOut, File file, String base, List<String> filterList) {
        FileInputStream in = null;
        try {
            logger.info((Object)("zip(ZipOutputStream zOut, File file, String base)-> fileName=" + ZipUtil.getcleanedMessage(file.getName())));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                String entryName = base + ZIP_FILE_SEPARATOR;
                logger.info((Object)"zip(ZipOutputStream zOut, File file, String base)-> entryName");
                zOut.putNextEntry(new ZipEntry(entryName));
                String string = base = base.length() == 0 ? "" : base + ZIP_FILE_SEPARATOR;
                if (null != listFiles) {
                    for (int i = 0; i < listFiles.length; ++i) {
                        ZipUtil.zipWithFilter(zOut, listFiles[i], base + listFiles[i].getName(), filterList);
                    }
                }
            } else {
                int len;
                if (!ZipUtil.isFileNameValid(file, filterList)) {
                    return;
                }
                if (base.equals("")) {
                    base = file.getName();
                }
                logger.info((Object)"zip(ZipOutputStream zOut, File file, String base)-> entryName:");
                zOut.putNextEntry(new ZipEntry(base));
                logger.info((Object)"zip(ZipOutputStream zOut, File file, String base) ->");
                in = new FileInputStream(file);
                while ((len = in.read()) != -1) {
                    zOut.write(len);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"zipWithFilter IOException");
        }
        catch (RuntimeException e) {
            logger.error((Object)"zipWithFilter RuntimeException");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close FileInputStream error");
            }
        }
    }

    private static boolean isFileNameValid(File file, List<String> filterList) {
        if (filterList != null && !filterList.isEmpty()) {
            for (String item : filterList) {
                if (!file.getName().endsWith(item)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(List<String> directoryList, String zipFileName) {
        ZipOutputStream zOut = null;
        try {
            if (directoryList != null && !directoryList.isEmpty()) {
                zOut = new ZipOutputStream(new FileOutputStream(new String(zipFileName.getBytes("gb2312"), "utf-8")));
                for (String item : directoryList) {
                    logger.info((Object)"zip-->begin");
                    ZipUtil.zip(zOut, new File(item), ZipUtil.getDirectoryName(item));
                    logger.info((Object)"zip-->end");
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"zip IOException");
        }
        catch (RuntimeException e) {
            logger.error((Object)"zip RuntimeException");
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close ZipOutputStream error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipWithFilter(List<String> directoryList, String zipFileName, List<String> filterList) {
        ZipOutputStream zOut = null;
        try {
            if (directoryList != null && !directoryList.isEmpty()) {
                zOut = new ZipOutputStream(new FileOutputStream(new String(zipFileName.getBytes("gb2312"), "utf-8")));
                for (String item : directoryList) {
                    logger.info((Object)"zip-->begin");
                    ZipUtil.zipWithFilter(zOut, new File(item), ZipUtil.getDirectoryName(item), filterList);
                    logger.info((Object)"zip-->end");
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"zipWithFilter IOException");
        }
        catch (RuntimeException e) {
            logger.error((Object)"zipWithFilter RuntimeException");
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close ZipOutputStream error");
            }
        }
    }

    private static String getDirectoryName(String directoryPath) {
        if (directoryPath != null) {
            String[] dirs = directoryPath.replace('\\', ZIP_FILE_SEPARATOR_CHAR.charValue()).split(ZIP_FILE_SEPARATOR);
            return dirs[dirs.length - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zOut, File file, String base) {
        FileInputStream in = null;
        try {
            logger.info((Object)("zip(ZipOutputStream zOut, File file, String base)-> fileName=" + file.getName()));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                String entryName = base + ZIP_FILE_SEPARATOR;
                logger.info((Object)"zip(ZipOutputStream zOut, File file, String base)-> entryName");
                zOut.putNextEntry(new ZipEntry(entryName));
                String string = base = base.length() == 0 ? "" : base + ZIP_FILE_SEPARATOR;
                if (null != listFiles) {
                    for (int i = 0; i < listFiles.length; ++i) {
                        ZipUtil.zip(zOut, listFiles[i], base + listFiles[i].getName());
                    }
                }
            } else {
                int len;
                if (base.equals("")) {
                    base = file.getName();
                }
                logger.info((Object)"zip(ZipOutputStream zOut, File file, String base)-> entryName:");
                zOut.putNextEntry(new ZipEntry(base));
                logger.info((Object)"zip(ZipOutputStream zOut, File file, String base) -> ");
                in = new FileInputStream(file);
                while ((len = in.read()) != -1) {
                    zOut.write(len);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"zip IOException");
        }
        catch (RuntimeException e) {
            logger.error((Object)"zip RuntimeException");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close FileInputStream error");
            }
        }
    }

    private static void createDirectory(String directory, String subDirectory) {
        File fl = new File(directory);
        if (subDirectory.equals("") && !fl.exists()) {
            if (fl.mkdir()) {
                logger.info((Object)" file create.");
            } else {
                logger.error((Object)"dir create fail:");
            }
        } else if (!subDirectory.equals("")) {
            String[] dir = subDirectory.replace('\\', ZIP_FILE_SEPARATOR_CHAR.charValue()).split(ZIP_FILE_SEPARATOR);
            StringBuffer bufDic = new StringBuffer(directory);
            for (int i = 0; i < dir.length; ++i) {
                String newDirPath = bufDic.toString() + ZIP_FILE_SEPARATOR + dir[i];
                ZipUtil.createDirectory(newDirPath, "");
                bufDic.append(ZIP_FILE_SEPARATOR).append(dir[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(String zipFileName, String outputDirectory) {
        ZipFile zipFile = null;
        int entries = 0;
        int total = 0;
        long min = SystemToolFactory.getMinsize();
        try {
            zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            ZipEntry zipEntry = null;
            ZipUtil.createDirectory(outputDirectory, "");
            while (e.hasMoreElements()) {
                zipEntry = e.nextElement();
                logger.info((Object)("ziping: " + ZipUtil.getcleanedMessage(zipEntry.getName())));
                String name = ZipUtil.sanitzeFileName(zipEntry.getName(), ".");
                if (AticUtil.isNull((String)name)) {
                    return;
                }
                if (zipEntry.isDirectory()) {
                    name = name.substring(0, name.length() - 1);
                    String newDirPath = outputDirectory + ZIP_FILE_SEPARATOR + name;
                    ZipUtil.createDirectory(newDirPath, "");
                    continue;
                }
                total = ZipUtil.createFileByZip(zipEntry, zipFile, outputDirectory, total);
                if (++entries > 1024) {
                    logger.error((Object)"Too many files to unzip.fileNum:1024");
                    return;
                }
                if (total > 0x6400000) {
                    logger.error((Object)"File being unzipped is too big.BigSize=104857600");
                    return;
                }
                if (Long.parseLong(String.valueOf(total), 16) <= min) continue;
                logger.error((Object)("File being unzipped is too big.availSize=" + min));
                return;
            }
        }
        catch (IOException ex) {
            logger.error((Object)"unZip IOException");
        }
        catch (RuntimeException ex) {
            logger.error((Object)"unZip RuntimeException");
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close ZipFile error");
            }
        }
    }

    private static String sanitzeFileName(String entryName, String intendedDir) throws IOException {
        File iD;
        String canonicalID;
        File f = new File(intendedDir, entryName);
        String canonicalPath = f.getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return canonicalPath;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int createFileByZip(ZipEntry zipEntry, ZipFile zipFile, String outputDirectory, int totalSize) {
        FileOutputStream out;
        InputStream in;
        block8: {
            in = null;
            out = null;
            String fileName = zipEntry.getName();
            if (fileName.indexOf(ZIP_FILE_SEPARATOR) != -1) {
                ZipUtil.createDirectory(outputDirectory, fileName.substring(0, fileName.lastIndexOf(ZIP_FILE_SEPARATOR)));
            }
            File f = new File(outputDirectory + ZIP_FILE_SEPARATOR + zipEntry.getName());
            try {
                int c;
                if (!f.createNewFile()) break block8;
                in = zipFile.getInputStream(zipEntry);
                out = new FileOutputStream(f);
                byte[] by = new byte[8192];
                while (totalSize + 8192 <= 0x6400000 && (c = in.read(by)) != -1) {
                    out.write(by, 0, c);
                    totalSize += c;
                }
                out.flush();
            }
            catch (IOException e) {
                logger.error((Object)"createFileByZip IOException");
                ZipUtil.closeInputStream(in);
                ZipUtil.closeOutputStream(out);
            }
            catch (RuntimeException e2) {
                logger.error((Object)"createFileByZip RuntimeException");
                {
                    catch (Throwable throwable) {
                        ZipUtil.closeInputStream(in);
                        ZipUtil.closeOutputStream(out);
                        throw throwable;
                    }
                }
                ZipUtil.closeInputStream(in);
                ZipUtil.closeOutputStream(out);
            }
        }
        ZipUtil.closeInputStream(in);
        ZipUtil.closeOutputStream(out);
        return totalSize;
    }

    private static void closeOutputStream(OutputStream output) {
        if (null != output) {
            try {
                output.flush();
                output.close();
            }
            catch (IOException e) {
                logger.error((Object)"outstream.close() error");
            }
            finally {
                output = null;
            }
        }
    }

    private static void closeInputStream(InputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.error((Object)"instream.close() error");
            }
            finally {
                input = null;
            }
        }
    }
}

