/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.zone.dao.BaseDao;
import com.hs.atic.zone.model.ZoneIpInfo;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import java.util.List;

public class SigZoneIpDao
extends BaseDao<ZoneIpInfo, Long> {
    public SigZoneIpDao() {
        super(ZoneIpInfo.class);
    }

    public List<ZoneIpInfo> getZoneIpListByZoneIdAndStartIpAndEndIp(long zoneId, String startIp, String endIp) {
        String hql = "from ZoneIpInfo zi where zi.zoneId = ?0 and zi.startIp >= ?1 and zi.endIp <= ?2 and LENGTH(zi.startIp) = ?3 AND LENGTH(zi.endIp) = ?4";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId, IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), (long)IPUtil4Atic.convert2CompleteIp((String)startIp).length(), (long)IPUtil4Atic.convert2CompleteIp((String)endIp).length()});
    }

    public void deleteByZoneIdAndStartIpAndEndIp(long zoneId, String startIp, String endIp) {
        String hql = "delete from ZoneIpInfo zi where zi.zoneId = ?0 and zi.startIp >= ?1 and zi.endIp <= ?2 and LENGTH(zi.startIp) = ?3 AND LENGTH(zi.endIp) = ?4";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId, IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), (long)IPUtil4Atic.convert2CompleteIp((String)startIp).length(), (long)IPUtil4Atic.convert2CompleteIp((String)endIp).length()});
    }

    public boolean isOverlapped(String startIp, String endIp) {
        String hql = "from ZoneIpInfo zi where (( zi.startIp <= ?0 and zi.endIp >= ?1 ) or ( zi.startIp <= ?2 and zi.endIp >= ?3 ) or ( zi.startIp >= ?4 and zi.endIp <= ?5 )) and LENGTH(zi.startIp) = ?6 AND LENGTH(zi.endIp) = ?7";
        List list = this.getHibernateTemplate().find(hql, new Object[]{IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), IPUtil4Atic.convert2CompleteIp((String)endIp), IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), (long)IPUtil4Atic.convert2CompleteIp((String)startIp).length(), (long)IPUtil4Atic.convert2CompleteIp((String)endIp).length()});
        return list != null && !list.isEmpty();
    }

    public boolean isOverlappedExceptZoneId(long zoneId, String startIp, String endIp) {
        String hql = "from ZoneIpInfo zi where (( zi.startIp <= ?0 and zi.endIp >= ?1 ) or ( zi.startIp <= ?2 and zi.endIp >= ?3 ) or ( zi.startIp >= ?4 and zi.endIp <= ?5 )) and zi.zoneId <> ?6 and LENGTH(zi.startIp) = ?7 AND LENGTH(zi.endIp) = ?8";
        List zoneIpList = super.getHibernateTemplate().find(hql, new Object[]{IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), IPUtil4Atic.convert2CompleteIp((String)endIp), IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), zoneId, (long)IPUtil4Atic.convert2CompleteIp((String)startIp).length(), (long)IPUtil4Atic.convert2CompleteIp((String)endIp).length()});
        return zoneIpList != null && !zoneIpList.isEmpty();
    }

    public void deleteById(Long zoneIpId) {
        String hql = "delete from ZoneIpInfo zi where zi.id = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneIpId});
    }

    public void saveZoneIp(ZoneIpInfo zoneIp) {
        this.getHibernateTemplate().save((Object)zoneIp);
    }

    public void deleteByZoneId(long zoneId) {
        String hql = "delete from ZoneIpInfo zi where zi.zoneId = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public List<ZoneIpInfo> getByZoneId(long zoneId) {
        String hql = "from ZoneIpInfo zi where zi.zoneId = ?0";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }
}

