/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.zone.model.ZoneIpStatusInfo;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ZoneIpStatusDao
extends CommonDaoImpl {
    public List<ZoneIpStatusInfo> findByIpIdAndState(Long ipId) {
        if (ipId == null) {
            return new ArrayList<ZoneIpStatusInfo>();
        }
        String hql = "from ZoneIpStatusInfo where ipId = ?0 and deployState = true";
        List result = this.findByHql(hql, new Object[]{ipId});
        if (result == null) {
            return new ArrayList<ZoneIpStatusInfo>();
        }
        return result;
    }

    public List<ZoneIpStatusInfo> findByIpIdAndDeviceId(Long ipId, Long deviceId) {
        if (null == ipId || null == deviceId) {
            return new ArrayList<ZoneIpStatusInfo>();
        }
        String hql = "from ZoneIpStatusInfo where ipId = ?0 and deviceId = ?1";
        List result = this.findByHql(hql, new Object[]{ipId, deviceId});
        if (result == null) {
            return new ArrayList<ZoneIpStatusInfo>();
        }
        return result;
    }

    public List<ZoneIpStatusInfo> findByDeviceId(Long deviceId) {
        if (null == deviceId) {
            return new ArrayList<ZoneIpStatusInfo>();
        }
        String hql = "from ZoneIpStatusInfo where deviceId = ?0";
        List result = this.findByHql(hql, new Object[]{deviceId});
        if (result == null) {
            return new ArrayList<ZoneIpStatusInfo>();
        }
        return result;
    }

    public void deleteIpByDeviceId(Long deviceId) {
        String hql = "delete from ZoneIpStatusInfo where deviceId = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
    }

    public void deleteIpByPkIds(List<Long> pkidList) {
        String hql = "delete from ZoneIpStatusInfo where ipId in (:ids)";
        InnerClassDelete innerClass = new InnerClassDelete(hql, pkidList);
        super.getHibernateTemplate().execute((HibernateCallback)innerClass);
    }

    public void deleteIpByPkIdsAndDeviceId(List<Long> pkidList, Long deviceId) {
        String hql = "delete from ZoneIpStatusInfo where deviceId = :deviceId and ipId in (:ids)";
        InnerClassDelete1 innerClass = new InnerClassDelete1(hql, pkidList, deviceId);
        super.getHibernateTemplate().execute((HibernateCallback)innerClass);
    }

    private static class InnerClassDelete1
    implements HibernateCallback {
        private String hql;
        private List<Long> ids;
        private Long deviceId;

        public InnerClassDelete1(String hql, List<Long> ids, Long deviceId) {
            this.hql = hql;
            this.ids = ids;
            this.deviceId = deviceId;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            q.setParameter("deviceId", (Object)this.deviceId);
            q.setParameterList("ids", this.ids);
            return q.executeUpdate();
        }
    }

    private static class InnerClassDelete
    implements HibernateCallback {
        private String hql;
        private List<Long> ids;

        public InnerClassDelete(String hql, List<Long> ids) {
            this.hql = hql;
            this.ids = ids;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            q.setParameterList("ids", this.ids);
            return q.executeUpdate();
        }
    }
}

