/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.zone.model.ZonePortMapInfo;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import java.util.List;

public class ZoneListPortMapDao
extends CommonDaoImpl {
    public void deleteByZoneId(Long zoneId) {
        String hql = "delete from ZonePortMapInfo where zoneId = ?0 and (deleteFlag IS NULL OR deleteFlag = 0)";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void deleteAllByZoneId(Long zoneId) {
        String hql = "delete from ZonePortMapInfo where zoneId = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public List<ZonePortMapInfo> getByZoneId(Long zoneId) {
        String hql = "from ZonePortMapInfo where zoneId = ?0";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZonePortMapInfo> getPortMapUndeployDataByZoneId(Long zoneId) {
        String hql = "from ZonePortMapInfo where zoneId = ?0 and deployState = false and deleteFlag = 0";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZonePortMapInfo> getPortMapUndoDataByZoneId(Long zoneId) {
        String hql = "from ZonePortMapInfo where zoneId = ?0 and deleteFlag = 1";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<Long> getPkIdsByZoneId(Long zoneId) {
        String hql = "select id from ZonePortMapInfo where zoneId = ?0";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public void updateDeployStateByZoneId(Long zoneId) {
        String hql = "update ZonePortMapInfo  set deployState = false  where zoneId = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void updateDeployStateById(Long pkid, boolean deployState) {
        String hql = "update ZonePortMapInfo  set deployState = ?0  where id = ?1";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deployState, pkid});
    }

    public List<ZonePortMapInfo> getByZoneIdAndFlag(Long zoneId) {
        String hql = "from ZonePortMapInfo where zoneId = ?0 and deployState = true and deleteFlag = 1";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public void deleteById(Long pkid) {
        String hql = "delete from ZonePortMapInfo where id = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{pkid});
    }

    public void deleteIpByPortMapIds(List<Long> protMapIdList) {
        String hql = "delete from ZonePortMapInfo where id in (:ids)";
        this.currentSession().createQuery(hql).setParameterList("ids", protMapIdList).executeUpdate();
    }
}

