/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.service.impl;

import com.hs.atic.intelligentdefense.impl.StreamMonitorRuleManager;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.service.FaultSeverityRuleService;
import com.hs.atic.sdk.bis.service.IBaseLineService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.form.ZonePortMapForm;
import com.hs.atic.sdk.zone.form.ZoneUndoIpForm;
import com.hs.atic.sdk.zone.service.ICurrentZoneIdService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.sdk.zone.util.ProgressManage;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.dao.ZoneDao;
import com.hs.atic.zone.dao.ZoneIpDao;
import com.hs.atic.zone.dao.ZoneIpStatusDao;
import com.hs.atic.zone.dao.ZoneListIpDao;
import com.hs.atic.zone.dao.ZoneListPortMapDao;
import com.hs.atic.zone.dao.ZoneListPortMapStateDao;
import com.hs.atic.zone.model.ZoneInfo;
import com.hs.atic.zone.model.ZoneIpInfo;
import com.hs.atic.zone.model.ZoneIpStatusInfo;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.atic.zone.model.ZonePortMapInfo;
import com.hs.atic.zone.util.ZoneConstants;
import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.LegoDataProtectorWrapper;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoExceptionTranslator;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.nem.fault.resource.ResUpdateSubscriber;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneIpLocationDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceStatusDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceStatusInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyEditService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IServiceLearningParamService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceForm;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.policy.third.service.IDivertForPolicy;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import com.huawei.atic.policy.third.service.ISynchronizDivertService;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IUndoZoneParentService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;

public class ZoneServiceImpl
implements IZoneService,
IUndoZoneParentService {
    private static final int SLLEEP_TIME = 1000;
    private static final int LOOP_COUNT = 10;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneDao zoneDao;
    private ZoneIpDao zoneIpDao;
    private ZoneListIpDao zoneListIpDao;
    private ZoneListPortMapDao zoneListPortMapDao;
    private ZoneListPortMapStateDao zoneListPortMapStateDao;
    private ICurrentZoneIdService currentZoneIdService;
    private IZoneServiceService zoneServiceService;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneServiceStatusDao zoneServiceStatusDao;
    private FilterDeviceDao filterDeviceDao;
    private FilterDeviceZoneStatusDao filterDeviceZoneStatusDao;
    private IFilterDeviceZoneInfoService filterZoneService;
    private ZoneIpStatusDao zoneIpStatusDao;
    private IUserMgr userMgr;
    private IDivertForPolicy divertTacticsService;
    private IPacketTaskService packetTaskService;
    private IResourceService resourceService;
    private IServiceLearningParamService serviceLearningParamService;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IBaseLineService baseLineService;
    private ISynchronizDivertService synchronizDivertService;
    private IZoneDeviceDeployStatusService zoneDeviceDeployStatusService;
    private IDiscoveryService discoveryService = null;
    private IAticDeviceService aticDeviceService;
    private IZoneDeviceService zoneDeviceService;
    private ZoneIpLocationDao zoneIpLocationDao;
    private IFilterDeviceZoneInfoService filterDeviceZoneInfoService;
    private INfaPolicyEditService nfaPolicyEditService;
    private FaultSeverityRuleService faultSeverityRuleService;

    @Override
    public Long saveZone(ZoneInfoForm zoneInfoForm, Long currentUserId, boolean isAdd) {
        this.initSaveOrEditServices();
        if (isAdd) {
            return this.createZone(zoneInfoForm, currentUserId);
        }
        return this.updateZone(zoneInfoForm);
    }

    private void initSaveOrEditServices() {
        this.synchronizDivertService = this.getSynchronizDivertService();
        this.zonePolicyApplyService = this.getZonePolicyApplyService();
    }

    private Long createZone(ZoneInfoForm zoneInfoForm, Long currentUserId) {
        this.currentZoneIdService.initZoneId(zoneInfoForm);
        ZoneInfo zoneInfo = new ZoneInfo();
        ZoneUtil.copyProperties(zoneInfoForm, zoneInfo);
        this.initZoneMoInfo(zoneInfo);
        this.resourceService.addMoAndSubMoWithoutDelete((ManagedObject)zoneInfo);
        this.grandZoneToUser(zoneInfo.getMoId(), currentUserId);
        this.saveZoneIps(zoneInfoForm.getZoneIpFormList(), zoneInfo.getZoneId());
        this.saveZoneListIps(zoneInfoForm.getZoneListIpFormList(), zoneInfo.getZoneId());
        this.saveZonePortMaps(zoneInfoForm.getZonePortMapFormList(), zoneInfo.getZoneId());
        this.zonePolicyApplyService.createDDOSPolicy(zoneInfo.getZoneId(), currentUserId);
        this.synchronizDivertService.synchronizDivert(zoneInfo.getZoneId(), 1);
        return zoneInfo.getZoneId();
    }

    private Long updateZone(ZoneInfoForm zoneInfoForm) {
        ZoneInfo zoneInfo = this.zoneDao.getZoneById(zoneInfoForm.getZoneId());
        if (zoneInfo != null) {
            boolean changeDesc = false;
            if (!zoneInfo.getZoneDesc().equals(zoneInfoForm.getZoneDesc())) {
                changeDesc = true;
            }
            zoneInfoForm.setZoneName(zoneInfo.getZoneName());
            zoneInfoForm.setZoneType(zoneInfo.getZoneType());
            ZoneUtil.copyProperties(zoneInfoForm, zoneInfo);
            this.initZoneMoInfo(zoneInfo);
            this.zoneDao.saveOrUpdate(zoneInfo);
            this.deleteZoneIps(zoneInfo.getZoneId());
            this.saveZoneIps(zoneInfoForm.getZoneIpFormList(), zoneInfo.getZoneId());
            this.deleteZoneListIps(zoneInfoForm);
            this.saveZoneListIps(zoneInfoForm.getZoneListIpFormList(), zoneInfo.getZoneId());
            this.deleteZonePortMaps(zoneInfoForm.getDeletePortMapFromDBList());
            this.saveZonePortMaps(zoneInfoForm.getZonePortMapFormList(), zoneInfo.getZoneId());
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(zoneInfoForm.getMoId().longValue());
            if (null != aticDevice) {
                this.updateZoneDeployState(zoneInfo.getZoneId());
            }
            this.synchronizDivertService.synchronizDivert(zoneInfo.getZoneId(), 2);
            if (changeDesc) {
                ResUpdateSubscriber ras = new ResUpdateSubscriber();
                ras.updateAlarmNority((TopoObject)zoneInfo);
            }
            return zoneInfo.getZoneId();
        }
        throw new LegoCheckedException("The zoneID id error");
    }

    private void deleteZoneListIps(ZoneInfoForm zoneInfoForm) {
        List<Long> ipIdList = zoneInfoForm.getDeleteIpList();
        if (null != ipIdList && !ipIdList.isEmpty()) {
            this.zoneListIpDao.deleteIpByPkIds(ipIdList);
            this.zoneIpStatusDao.deleteIpByPkIds(ipIdList);
        }
    }

    @Override
    public void deleteZoneIps(Long zoneId) {
        this.zoneIpDao.deleteIpByZoneId(zoneId);
    }

    private void deleteZonePortMaps(List<Long> deletePortMapFromDBList) {
        if (null != deletePortMapFromDBList && !deletePortMapFromDBList.isEmpty()) {
            for (Long pkId : deletePortMapFromDBList) {
                this.zoneListPortMapDao.deleteById(pkId);
            }
        }
    }

    @Override
    public void saveZoneListIps(List<ZoneListIpForm> zoneListIpFromList, Long zoneId) {
        if (zoneListIpFromList != null && !zoneListIpFromList.isEmpty()) {
            for (ZoneListIpForm zoneListIpFrom : zoneListIpFromList) {
                ZoneListIpInfo zoneListIpInfo = new ZoneListIpInfo();
                zoneListIpFrom.setZoneId(zoneId);
                ZoneUtil.copyProperties(zoneListIpFrom, zoneListIpInfo);
                this.zoneListIpDao.saveOrUpdate(zoneListIpInfo);
            }
        }
    }

    @Override
    public void saveZoneIps(List<ZoneIpForm> zoneIpFormList, Long zoneId) {
        if (null != zoneIpFormList && !zoneIpFormList.isEmpty()) {
            for (ZoneIpForm zoneIpForm : zoneIpFormList) {
                ZoneIpInfo zoneIpInfo = new ZoneIpInfo();
                zoneIpForm.setZoneId(zoneId);
                zoneIpForm.setStartIp(IPUtil4Atic.convert2CompleteIp((String)zoneIpForm.getStartIp()));
                zoneIpForm.setEndIp(IPUtil4Atic.convert2CompleteIp((String)zoneIpForm.getEndIp()));
                ZoneUtil.copyProperties(zoneIpForm, zoneIpInfo);
                this.zoneIpDao.saveOrUpdate(zoneIpInfo);
            }
        }
    }

    private void saveZonePortMaps(List<ZonePortMapForm> zonePortMapForms, Long zoneId) {
        if (null != zonePortMapForms && !zonePortMapForms.isEmpty()) {
            for (ZonePortMapForm zonePortMapForm : zonePortMapForms) {
                ZonePortMapInfo zonePortMapInfo = (ZonePortMapInfo)ZoneUtil.copyProperties(zonePortMapForm, new ZonePortMapInfo());
                zonePortMapInfo.setZoneId(zoneId);
                this.zoneListPortMapDao.saveOrUpdate(zonePortMapInfo);
            }
        }
    }

    private void updateZoneDeployState(Long zoneId) {
        Long deployedCrc = this.zonePolicyApplyService.queryZoneIpCrcDeployed(zoneId);
        Long toDeployCrc = this.zonePolicyApplyService.calcZoneIpCrcToDeploy(zoneId);
        if (!toDeployCrc.equals(deployedCrc)) {
            this.zonePolicyApplyService.updateDDosPolicyDeployedState(zoneId);
        }
    }

    private void grandZoneToUser(Long zoneMoId, Long currentUserId) {
        if (currentUserId > 0L) {
            HashSet<Long> userIds = new HashSet<Long>();
            userIds.add(zoneMoId);
            this.userMgr.grandObjectToUser(currentUserId.longValue(), userIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult batchAddZone(List<ZoneInfoForm> zoneInfoFormList, Long currentUserId, Long progressId) {
        this.logger.info((Object)"Batchimport start");
        BatchOperationResult result = new BatchOperationResult();
        int totalStep = zoneInfoFormList.size();
        ProgressState progressState = ProgressManage.getInstance().createProgress(totalStep, progressId);
        int fail = 0;
        int success = 0;
        int failReason = 0;
        ArrayList<BatchOperation> batchOperationList = new ArrayList<BatchOperation>();
        for (ZoneInfoForm zoneInfoForm : zoneInfoFormList) {
            if (progressState.getIsStop().booleanValue()) {
                this.logger.info((Object)"stop batch import zones");
                break;
            }
            ZoneServiceImpl zoneServiceImpl = this;
            synchronized (zoneServiceImpl) {
                BatchOperation bo = new BatchOperation();
                int currentStep = progressState.getCurrentStep();
                if (totalStep > currentStep + 1) {
                    progressState.next();
                }
                String zoneName = zoneInfoForm.getZoneName();
                String zoneDesc = zoneInfoForm.getZoneDesc();
                bo.setTargetName(zoneName);
                if (this.getZoneNum() >= 10000) {
                    this.logger.warn((Object)"exceed max zone num : 10000");
                    fail = zoneInfoFormList.size() - success;
                    failReason = 570603;
                    bo.setErrorCode(570603L);
                    batchOperationList.add(bo);
                    break;
                }
                failReason = this.checkZoneNameDesc(zoneName, zoneDesc);
                if (failReason > 0) {
                    this.logger.warn((Object)("import zone : " + zoneName + " name or desc has existed."));
                    ++fail;
                    bo.setErrorCode((long)failReason);
                    batchOperationList.add(bo);
                    continue;
                }
                List<ZoneIpForm> ipList = zoneInfoForm.getZoneIpFormList();
                if (null != ipList) {
                    for (ZoneIpForm zoneIpForm : ipList) {
                        if (!this.isExistIP(zoneIpForm)) continue;
                        this.logger.warn((Object)("import ip : " + zoneIpForm.getZoneIp() + " has existed."));
                        ++fail;
                        bo.setErrorCode(570608L);
                        batchOperationList.add(bo);
                        failReason = 570608;
                        break;
                    }
                }
                if (failReason > 0) {
                    continue;
                }
                try {
                    this.saveZone(zoneInfoForm, currentUserId, true);
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570611L);
                    batchOperationList.add(bo);
                    this.logger.error((Object)("save zone fail zone name is " + zoneInfoForm.getZoneName() + ". " + e.getMessage()));
                    continue;
                }
                this.opLogForZoneIp(ipList, zoneInfoForm, bo);
                batchOperationList.add(bo);
                ++success;
            }
        }
        this.logger.info((Object)"Batchimport stop");
        result.setResult(batchOperationList);
        result.setFailCount(fail);
        result.setTotalCount(batchOperationList.size());
        result.setSucceedCount(batchOperationList.size() - fail);
        this.logger.info((Object)("import zone info result: total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public ProgressState getProgressState(Long id) {
        return ProgressManage.getInstance().getProgressState(id);
    }

    @Override
    public void removeProgressState(Long progressId) {
        ProgressManage.getInstance().removeProgressState(progressId);
    }

    private void opLogForZoneIp(List<ZoneIpForm> ipList, ZoneInfoForm zoneInfoForm, BatchOperation bo) {
        String zoneType;
        String string = zoneType = ZoneConstants.ZONE_TYPE_CUSTOME.equals(zoneInfoForm.getZoneType()) ? "atic.user.type.custome" : "atic.user.type.default";
        if (null != ipList && !ipList.isEmpty()) {
            String ipAddress = "";
            StringBuffer buf = new StringBuffer();
            for (ZoneIpForm ipFormTemp : ipList) {
                buf.append(ipFormTemp.getZoneIp() + ",");
            }
            ipAddress = buf.toString();
            ipAddress = ipAddress.substring(0, ipAddress.length() - 1);
            String[] detailParam = new String[]{zoneType, zoneInfoForm.getZoneName(), zoneInfoForm.getZoneDesc(), ipAddress};
            bo.setOptDetail("atic.user.operaLog.importUseSummary");
            bo.setDetailParam(detailParam);
        } else {
            String[] detailParam = new String[]{zoneType, zoneInfoForm.getZoneName(), zoneInfoForm.getZoneDesc()};
            bo.setOptDetail("atic.user.operaLog.importUseSummary.noIpAddress");
            bo.setDetailParam(detailParam);
        }
    }

    private void initZoneMoInfo(ZoneInfo zoneInfo) {
        if (ZoneUtil.isNull(zoneInfo.getUuid())) {
            zoneInfo.setUuid(UUID.randomUUID().toString());
        }
        zoneInfo.setName(zoneInfo.getZoneDesc());
        zoneInfo.setMainType("atic.portal.mainType.zone");
        zoneInfo.setSubType("atic.portal.subType.dsosZone");
        zoneInfo.setIsTopMo(true);
        zoneInfo.setSupportPing(false);
        String encryptedTelephone = LegoDataProtectorWrapper.sdpEncryptLocal((String)zoneInfo.getTelephone());
        String encryptedMobile = LegoDataProtectorWrapper.sdpEncryptLocal((String)zoneInfo.getMobile());
        String encryptedEmail = LegoDataProtectorWrapper.sdpEncryptLocal((String)zoneInfo.getEmail());
        String encryptedPost = LegoDataProtectorWrapper.sdpEncryptLocal((String)zoneInfo.getPost());
        String encryptedAddress = LegoDataProtectorWrapper.sdpEncryptLocal((String)zoneInfo.getAddress());
        zoneInfo.setTelephone(encryptedTelephone);
        zoneInfo.setMobile(encryptedMobile);
        zoneInfo.setEmail(encryptedEmail);
        zoneInfo.setPost(encryptedPost);
        zoneInfo.setAddress(encryptedAddress);
    }

    @Override
    public List<ZoneInfoForm> getZoneListByZoneIdS(String zoneIds) {
        ArrayList<ZoneInfoForm> zoneInfoList = new ArrayList<ZoneInfoForm>();
        if (null == zoneIds || zoneIds.equals("")) {
            return null;
        }
        String[] zIds = zoneIds.split(",");
        for (int i = 0; i < zIds.length; ++i) {
            try {
                Long id = Long.valueOf(zIds[i]);
                ZoneInfoForm zoneInfoForm = this.getById(id);
                if (null == zoneInfoForm) continue;
                zoneInfoList.add(zoneInfoForm);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Numberformat exception id = " + zIds[i] + ". " + e.getMessage()));
            }
        }
        return zoneInfoList;
    }

    @Override
    public BatchOperationResult batchDelZone(List<BatchOperation> boList) {
        this.logger.info((Object)"BatchDel start");
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == boList) {
            this.logger.info((Object)"parameter boList is null so don't execute delete zone");
            return result;
        }
        this.packetTaskService = ZoneReferUtil.getPacketTaskService();
        this.divertTacticsService = this.getDivertForPolicyService();
        ArrayList<BatchOperation> legoList = new ArrayList<BatchOperation>();
        BatchOperation legoBo = new BatchOperation();
        ArrayList<Long> unConnDevices = new ArrayList<Long>();
        ArrayList<Long> zoneIds = new ArrayList<Long>();
        for (BatchOperation bo : boList) {
            try {
                ZoneInfoForm infoForm;
                block34: {
                    infoForm = this.getZoneNOIpById(bo.getTargetId());
                    if (null == infoForm) {
                        bo.setErrorCode(570609L);
                        ++fail;
                        this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : not exist."));
                        continue;
                    }
                    try {
                        BatchOperationResult batchDelPacketResult = this.packetTaskService.stopAndDelAllPacketTaskByZoneId(bo.getTargetId());
                        if (batchDelPacketResult != null && batchDelPacketResult.getFailCount() > 0) {
                            bo.setErrorCode(570627L);
                            ++fail;
                            this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : stop packetTasks."));
                        }
                        break block34;
                    }
                    catch (Exception e) {
                        bo.setErrorCode(570627L);
                        ++fail;
                        this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : stop packetTasks." + e.getMessage()));
                    }
                    continue;
                }
                try {
                    this.divertTacticsService.stopAndDelDivertTacticsByZoneId(bo.getTargetId());
                }
                catch (Exception e) {
                    bo.setErrorCode(570628L);
                    ++fail;
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : stop diverts." + e.getMessage()));
                    continue;
                }
                try {
                    this.baseLineService.deleteBaseLineTask(bo.getTargetId());
                }
                catch (Exception e) {
                    bo.setErrorCode(570629L);
                    ++fail;
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : has stop baseLine failed." + e.getMessage()));
                    continue;
                }
                try {
                    this.serviceLearningParamService.deleteServiceLearningTask(bo.getTargetId());
                }
                catch (Exception e) {
                    bo.setErrorCode(570630L);
                    ++fail;
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : stop serviceLearn." + e.getMessage()));
                    continue;
                }
                try {
                    this.zonePolicyApplyService.deleteDDOSPolicy(bo.getTargetId(), Long.valueOf(bo.getDetailParam()[0]), unConnDevices);
                    boolean isTelnetError = false;
                    List<ZoneDeviceDeployStatusForm> zoneDeviceDeployStatusForms = this.getZoneDeviceDeployStatusService().queryByZoneId(bo.getTargetId());
                    if (null != zoneDeviceDeployStatusForms && !zoneDeviceDeployStatusForms.isEmpty()) {
                        String detailParam = "";
                        StringBuffer buf = new StringBuffer();
                        for (ZoneDeviceDeployStatusForm zoneDeviceDeployForm : zoneDeviceDeployStatusForms) {
                            if (!zoneDeviceDeployForm.getDeployState().booleanValue()) {
                                isTelnetError = true;
                            }
                            if (!AticUtil.isNull((String)zoneDeviceDeployForm.getErrorMsgKey()) && zoneDeviceDeployForm.getErrorMsgKey().contains("lego.err")) {
                                isTelnetError = true;
                            }
                            Long deviceId = zoneDeviceDeployForm.getDeviceId();
                            AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                            String devName = device.getName();
                            if (StringUtils.equals((CharSequence)"", (CharSequence)detailParam)) {
                                buf.append(devName);
                                continue;
                            }
                            buf.append(";" + devName);
                        }
                        detailParam = buf.toString();
                        bo.setErrorCode(570626L);
                        bo.setDetailParam(new String[]{infoForm.getZoneDesc(), detailParam});
                        ++fail;
                        this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : undeployfailed."));
                    }
                    if (isTelnetError) continue;
                    this.zonePolicyApplyService.deleteByZoneId(bo.getTargetId());
                    this.nfaPolicyEditService.deleteByZoneId(bo.getTargetId());
                }
                catch (Exception e) {
                    bo.setErrorCode(570626L);
                    ++fail;
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : undeployexception." + e.getMessage()));
                    continue;
                }
                try {
                    this.zoneIpLocationDao.deleteByZoneId(bo.getTargetId());
                    this.logger.info((Object)("remove zoneInfo : " + bo.getErrorCode() + "'s zoneIpLocation successfully."));
                }
                catch (Exception e) {
                    bo.setErrorCode(570626L);
                    ++fail;
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : delete zoneIpLocation." + e.getMessage()));
                    continue;
                }
                try {
                    this.zoneListIpDao.deleteIpByZoneId(bo.getTargetId());
                    this.zoneIpDao.deleteIpByZoneId(bo.getTargetId());
                }
                catch (Exception e) {
                    bo.setErrorCode(570626L);
                    ++fail;
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : delete ips." + e.getMessage()));
                    continue;
                }
                try {
                    this.zoneListPortMapDao.deleteAllByZoneId(bo.getTargetId());
                }
                catch (Exception e) {
                    bo.setErrorCode(570626L);
                    ++fail;
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : delete port maps." + e.getMessage()));
                    continue;
                }
                try {
                    this.filterDeviceZoneInfoService.delFilterRelationByZoneId(bo.getTargetId());
                }
                catch (Exception e) {
                    bo.setErrorCode(570626L);
                    ++fail;
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : delete filterDeviceZoneInfo." + e.getMessage()));
                    continue;
                }
                try {
                    StreamMonitorRuleManager streamMonitorRuleManager = (StreamMonitorRuleManager)ServiceContext.getInstance().getService("streamMonitorRuleManager", StreamMonitorRuleManager.class);
                    streamMonitorRuleManager.disassociateRuleZone(Collections.singletonList(bo.getTargetId()));
                }
                catch (Exception e) {
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : delete streamMonitorRuleZoneMapping." + e.getMessage()));
                }
                zoneIds.add(bo.getTargetId());
                try {
                    this.faultSeverityRuleService.deleteRule(zoneIds);
                }
                catch (RemoteException e) {
                    this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed : delete faultSeverityRule." + e.getMessage()));
                }
                zoneIds.remove(bo.getTargetId());
                this.logger.info((Object)("remove zoneIp : " + bo.getErrorCode() + "'s ips successfully."));
                legoBo.setTargetId(infoForm.getMoId().longValue());
                legoList.add(legoBo);
                this.logger.info((Object)("remove zoneIp " + bo.getErrorCode() + " successfully."));
            }
            catch (RuntimeException e) {
                ++fail;
                bo.setErrorCode(570611L);
                this.logger.error((Object)("delete zone : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed." + e.getMessage()));
                continue;
            }
            BatchOperationResult legoResult = this.discoveryService.deleteDeviceNew(legoList, Long.valueOf(1L));
            this.logger.info((Object)("legoResult is : total " + legoResult.getTotalCount() + ", success = " + legoResult.getSucceedCount() + ", fail = " + legoResult.getFailCount()));
            BatchOperation tmpbo = (BatchOperation)legoResult.getResult().get(0);
            if (tmpbo.getErrorCode() != 0L) {
                bo.setErrorCode(tmpbo.getErrorCode());
                ++fail;
                this.logger.error((Object)("deleteDeviceNew failed : " + ZoneServiceImpl.getcleanedMessage(bo.getTargetName()) + " errorCode:" + tmpbo.getErrorCode()));
                continue;
            }
            bo.setOptDetail("atic.user.operaLog.delSummary");
            if (bo.getDetailParam().length == 2) continue;
            bo.setDetailParam(new String[]{bo.getTargetName()});
        }
        this.logger.info((Object)"BatchDel stop");
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("batch delete zone info result: total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private IZoneDeviceDeployStatusService getZoneDeviceDeployStatusService() {
        for (int i = 0; null == this.zoneDeviceDeployStatusService && i < 10; ++i) {
            try {
                this.zoneDeviceDeployStatusService = ZoneReferUtil.getZoneDeviceDeployStatusService();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("getZonePolicyApplyService failed. " + e.getMessage()));
            }
        }
        return this.zoneDeviceDeployStatusService;
    }

    @Override
    public void delByZoneId(Long zoneId) {
        if (null == zoneId) {
            return;
        }
        try {
            this.zoneIpDao.deleteIpByZoneId(zoneId);
            this.zoneListIpDao.deleteIpByZoneId(zoneId);
            ArrayList<BatchOperation> legoList = new ArrayList<BatchOperation>();
            ZoneInfo zoneInfo = this.zoneDao.getByZoneId(zoneId);
            if (null == zoneInfo) {
                this.logger.error((Object)"zoneInfo is null");
                return;
            }
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(zoneInfo.getMoId().longValue());
            bo.setTargetName(zoneInfo.getZoneDesc());
            legoList.add(bo);
            BatchOperationResult legoResult = this.discoveryService.deleteDeviceNew(legoList, Long.valueOf(1L));
            this.logger.info((Object)("legoResult is :total " + legoResult.getTotalCount() + ", success = " + legoResult.getSucceedCount() + ", fail = " + legoResult.getFailCount()));
            this.packetTaskService = ZoneReferUtil.getPacketTaskService();
            this.packetTaskService.stopAndDelAllPacketTaskByZoneId(zoneId);
            this.baseLineService.deleteBaseLineTask(zoneId);
            this.serviceLearningParamService.deleteServiceLearningTask(zoneId);
            this.zoneIpLocationDao.deleteByZoneId(zoneId);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("delete zoneInfo by id error, id is " + zoneId + ". " + e.getMessage()));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        try {
            this.divertTacticsService = this.getDivertForPolicyService();
            this.divertTacticsService.resetZoneNameForDivert(zoneId);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("resetZoneNameForDivert zoneId error, zoneId is " + zoneId + ". " + e.getMessage()));
        }
    }

    @Override
    public void delDefaultZone(Long deviceId) {
        this.delByZoneId(this.zoneDeviceService.getDefaultZoneIdByDevId(deviceId));
    }

    @Override
    public void delDefaultZone(List<AticDeviceForm> deviceList) {
        for (AticDeviceForm device : deviceList) {
            Long zoneId = this.zoneDeviceService.getDefaultZoneIdByDevId(Long.valueOf(device.getMoId()));
            this.delByZoneId(zoneId);
        }
    }

    @Override
    public List<ZoneIpForm> findIpByZoneId(Long zoneId) {
        ArrayList<ZoneIpForm> formList = new ArrayList<ZoneIpForm>();
        if (null == zoneId) {
            this.logger.info((Object)"parameter zoneId is null");
            return formList;
        }
        List<ZoneIpInfo> list = this.zoneIpDao.findIpByZoneId(zoneId);
        for (ZoneIpInfo ip : list) {
            ZoneIpForm form = new ZoneIpForm();
            ZoneUtil.copyProperties(ip, form);
            formList.add(form);
        }
        this.logger.info((Object)"find ip list by zone id successfully .");
        return formList;
    }

    @Override
    public List<ZonePortMapForm> findPortMapByZoneId(Long zoneId) {
        ArrayList<ZonePortMapForm> formList = new ArrayList<ZonePortMapForm>();
        if (null == zoneId) {
            this.logger.info((Object)"parameter zoneId is null");
            return formList;
        }
        List<ZonePortMapInfo> list = this.zoneListPortMapDao.getByZoneId(zoneId);
        for (ZonePortMapInfo portMap : list) {
            ZonePortMapForm form = new ZonePortMapForm();
            ZoneUtil.copyProperties(portMap, form);
            formList.add(form);
        }
        this.logger.info((Object)"find port map list by zone id successfully .");
        return formList;
    }

    @Override
    public List<ZoneIpForm> findIpNotThisZoneId(Long zoneId) {
        ArrayList<ZoneIpForm> formList = new ArrayList<ZoneIpForm>();
        if (null == zoneId) {
            this.logger.info((Object)"parameter zoneId is null");
            return formList;
        }
        List<ZoneIpInfo> ipList = this.zoneIpDao.findIpNotThisZoneId(zoneId);
        for (ZoneIpInfo temp : ipList) {
            ZoneIpForm form = new ZoneIpForm();
            ZoneUtil.copyProperties(temp, form);
            formList.add(form);
        }
        this.logger.info((Object)"find ips not belong this zoneId successfully.");
        return formList;
    }

    @Override
    public ZoneInfoForm getById(Long id) {
        if (null == id) {
            this.logger.error((Object)"get Zone info with ip by id. Id is null");
            return null;
        }
        ZoneInfo zoneInfo = this.zoneDao.getByZoneId(id);
        if (null == zoneInfo) {
            this.logger.warn((Object)("get Zone info with ip  by id, result is null. Id is : " + id));
            return null;
        }
        ZoneInfoForm zoneInfoForm = (ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm());
        List<ZoneListIpInfo> zoneListIpInfoList = this.zoneListIpDao.getByZoneId(id);
        ArrayList<ZoneListIpForm> zoneListIpFromList = new ArrayList<ZoneListIpForm>();
        for (ZoneListIpInfo zoneListIpInfo : zoneListIpInfoList) {
            ZoneListIpForm zoneListIpFrom = new ZoneListIpForm();
            ZoneUtil.copyProperties(zoneListIpInfo, zoneListIpFrom);
            zoneListIpFromList.add(zoneListIpFrom);
        }
        zoneInfoForm.setZoneListIpFormList(zoneListIpFromList);
        List<ZoneIpInfo> ipList = this.zoneIpDao.findIpByZoneId(id);
        ArrayList<ZoneIpForm> ipFormList = new ArrayList<ZoneIpForm>();
        for (ZoneIpInfo temp : ipList) {
            ZoneIpForm form = new ZoneIpForm();
            ZoneUtil.copyProperties(temp, form);
            ipFormList.add(form);
        }
        zoneInfoForm.setZoneIpFormList(ipFormList);
        List<ZonePortMapInfo> zonePortMapInfoList = this.zoneListPortMapDao.getByZoneId(id);
        ArrayList<ZonePortMapForm> zonePortMapFormList = new ArrayList<ZonePortMapForm>();
        for (ZonePortMapInfo zonePortMapInfo : zonePortMapInfoList) {
            ZonePortMapForm zonePortMapForm = new ZonePortMapForm();
            ZoneUtil.copyProperties(zonePortMapInfo, zonePortMapForm);
            zonePortMapFormList.add(zonePortMapForm);
        }
        zoneInfoForm.setZonePortMapFormList(zonePortMapFormList);
        return zoneInfoForm;
    }

    @Override
    public ZoneInfoForm getInitConfigById(Long zoneId, List<String> features, List<String> zoneIp) {
        if (null == zoneId) {
            this.logger.error((Object)"get Zone info with ip by id. Id is null");
            return null;
        }
        ZoneInfo zoneInfo = this.zoneDao.getByZoneId(zoneId);
        if (null == zoneInfo) {
            this.logger.warn((Object)("get Zone info with ip  by id, result is null. Id zoneId : " + zoneId));
            return null;
        }
        ZoneInfoForm zoneInfoForm = (ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm());
        if (null == features) {
            if (this.isUndoAll(zoneId)) {
                zoneInfoForm.setUndoAll(true);
                zoneInfoForm.setZoneIpFormList(this.deployAllIp(zoneId));
                zoneInfoForm.setZoneDoPortMapFormLis(this.deployAllPortMap(zoneId));
                List<ZonePortMapForm> portMapUndoFormList = this.deploydPortMapList(zoneId);
                zoneInfoForm.setZoneUndoPortMapFormList(portMapUndoFormList);
                List<ZoneUndoIpForm> ipUndoFormList = this.undeploydIpList(zoneId, zoneIp);
                zoneInfoForm.setZoneUndoIpFromList(ipUndoFormList);
            } else {
                zoneInfoForm.setUndoAll(false);
                List<ZoneIpForm> ipFormList = this.deployIpList(zoneId, zoneIp);
                List<ZoneUndoIpForm> ipUndoFormList = this.undeploydIpList(zoneId, zoneIp);
                List<ZonePortMapForm> portMapFormList = this.deployPortMapList(zoneId);
                List<ZonePortMapForm> portMapUndoFormList = this.deploydPortMapList(zoneId);
                zoneInfoForm.setZoneIpFormList(ipFormList);
                zoneInfoForm.setZoneUndoIpFromList(ipUndoFormList);
                zoneInfoForm.setZoneDoPortMapFormLis(portMapFormList);
                zoneInfoForm.setZoneUndoPortMapFormList(portMapUndoFormList);
                this.logger.info((Object)("zoneInfoForm ipFormList is : " + ipFormList.toString()));
                this.logger.info((Object)("zoneInfoForm ipUndoFormList is : " + ipUndoFormList.toString()));
            }
        } else if (features.contains(Constant.Feature.ZoneIpInfo.toString())) {
            zoneInfoForm.setUndoAll(false);
            List<ZoneIpForm> ipFormList = this.deployIpList(zoneId, zoneIp);
            List<ZoneUndoIpForm> ipUndoFormList = this.undeploydIpList(zoneId, zoneIp);
            List<ZonePortMapForm> portMapFormList = this.deployPortMapList(zoneId);
            List<ZonePortMapForm> portMapUndoFormList = this.deploydPortMapList(zoneId);
            zoneInfoForm.setZoneIpFormList(ipFormList);
            zoneInfoForm.setZoneUndoIpFromList(ipUndoFormList);
            zoneInfoForm.setZoneDoPortMapFormLis(portMapFormList);
            zoneInfoForm.setZoneUndoPortMapFormList(portMapUndoFormList);
        }
        this.logger.info((Object)("get Zone info by id successfuly. Id zoneId : " + zoneId));
        return zoneInfoForm;
    }

    private List<ZoneIpForm> deployAllIp(Long zoneId) {
        ArrayList<ZoneIpForm> ipFormList = new ArrayList<ZoneIpForm>();
        List<ZoneIpInfo> zoneIpInfos = this.zoneIpDao.findIpByZoneId(zoneId);
        List<ZoneListIpInfo> zoneListIpInfos = this.zoneListIpDao.getByZoneIdAndIpType(zoneId);
        for (ZoneIpInfo zoneIpInfo : zoneIpInfos) {
            ZoneIpForm zoneIpForm = (ZoneIpForm)ZoneUtil.copyProperties(zoneIpInfo, new ZoneIpForm());
            ArrayList<Long> pkIdList = new ArrayList<Long>();
            String[] zoneIps = IPUtil.getSubnetRange((String)zoneIpInfo.getZoneIp(), (int)zoneIpInfo.getMask());
            for (ZoneListIpInfo zoneListIpInfo : zoneListIpInfos) {
                String[] ipStrings = new String[]{zoneListIpInfo.getStartIp(), zoneListIpInfo.getEndIp()};
                if (!IPUtil4Atic.isCrossIpRange((String[])ipStrings, (String[])zoneIps)) continue;
                pkIdList.add(zoneListIpInfo.getId());
            }
            zoneIpForm.setPkIdList(pkIdList);
            ipFormList.add(zoneIpForm);
        }
        return ipFormList;
    }

    private List<ZonePortMapForm> deployAllPortMap(Long zoneId) {
        ArrayList<ZonePortMapForm> portMapFormList = new ArrayList<ZonePortMapForm>();
        List<ZonePortMapInfo> zonePortMapFormInfos = this.zoneListPortMapDao.getByZoneId(zoneId);
        if (null != zonePortMapFormInfos) {
            for (ZonePortMapInfo zonePortMapInfo : zonePortMapFormInfos) {
                ZonePortMapForm zonePortMapForm = (ZonePortMapForm)ZoneUtil.copyProperties(zonePortMapInfo, new ZonePortMapForm());
                if (zonePortMapForm.getDeleteFlag() == 1) continue;
                portMapFormList.add(zonePortMapForm);
            }
        }
        return portMapFormList;
    }

    private List<ZoneIpForm> deployIpList(Long zoneId, List<String> zoneIp) {
        ArrayList<ZoneIpForm> ipFormList = new ArrayList<ZoneIpForm>();
        List<Object> deployZoneIpList = new ArrayList();
        if (null != zoneIp) {
            for (String string : zoneIp) {
                String[] ipMask;
                ZoneListIpInfo zoneListIpInfo;
                if (!string.contains("/") || null == (zoneListIpInfo = this.zoneListIpDao.getByIpAndDeleteFlag((ipMask = string.split("/"))[0]))) continue;
                deployZoneIpList.add(zoneListIpInfo);
            }
        } else {
            deployZoneIpList = this.isZoneIdConflict(zoneId, 1) ? this.zoneListIpDao.getByZoneIdAndIpType(zoneId) : this.zoneListIpDao.getIpInitDataByZoneId(zoneId);
        }
        for (ZoneListIpInfo zoneListIpInfo : deployZoneIpList) {
            String[] networkSegment;
            ZoneIpForm zoneIpForm;
            ArrayList<Long> pkIdList = new ArrayList<Long>();
            pkIdList.add(zoneListIpInfo.getId());
            int maskType = zoneListIpInfo.getMaskType();
            if (maskType == 0) {
                zoneIpForm = new ZoneIpForm();
                String[] srcIpRange = IPUtil.getSubnetRange((String)zoneListIpInfo.getZoneIp(), (int)zoneListIpInfo.getIntMask());
                zoneIpForm.setZoneIp(srcIpRange[0]);
                zoneIpForm.setMask(zoneListIpInfo.getIntMask());
                zoneIpForm.setPkIdList(pkIdList);
                ipFormList.add(zoneIpForm);
                continue;
            }
            if (maskType != 1) continue;
            for (String ipAdress : networkSegment = IPUtil.getNetworkSegment((String)zoneListIpInfo.getStartIp(), (String)zoneListIpInfo.getEndIp())) {
                zoneIpForm = new ZoneIpForm();
                String[] ipStrings = ipAdress.split("/");
                zoneIpForm.setZoneIp(ipStrings[0]);
                zoneIpForm.setMask(Integer.valueOf(ipStrings[1]));
                zoneIpForm.setPkIdList(pkIdList);
                ipFormList.add(zoneIpForm);
            }
        }
        return ipFormList;
    }

    private boolean isZoneIdConflict(Long zoneId, int type) {
        boolean isConflictFlag = false;
        String policyErrorMsg = "lego.err.630014";
        String filterErrorMsg = "lego.err.630095";
        List<ZoneDeviceDeployStatusForm> zoneDeviceDeployStatusFormList = this.getZoneDeviceDeployStatusService().queryAllByZoneId(zoneId);
        if (null == zoneDeviceDeployStatusFormList || zoneDeviceDeployStatusFormList.isEmpty()) {
            return isConflictFlag;
        }
        for (ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm : zoneDeviceDeployStatusFormList) {
            if (zoneDeviceDeployStatusForm.getDeployType() != type || zoneDeviceDeployStatusForm.getDeployState().booleanValue()) continue;
            if (1 == type && policyErrorMsg.equals(zoneDeviceDeployStatusForm.getErrorMsgKey())) {
                isConflictFlag = true;
                break;
            }
            if (2 != type || !filterErrorMsg.equals(zoneDeviceDeployStatusForm.getErrorMsgKey())) continue;
            isConflictFlag = true;
            break;
        }
        return isConflictFlag;
    }

    private List<ZonePortMapForm> deployPortMapList(Long zoneId) {
        ArrayList<ZonePortMapForm> portMapFormList = new ArrayList<ZonePortMapForm>();
        List<ZonePortMapInfo> deployZonePortMapList = null;
        deployZonePortMapList = this.isZoneIdConflict(zoneId, 1) ? this.zoneListPortMapDao.getByZoneId(zoneId) : this.zoneListPortMapDao.getPortMapUndeployDataByZoneId(zoneId);
        for (ZonePortMapInfo zoneListPortMapInfo : deployZonePortMapList) {
            ZonePortMapForm zonePortMapForm = new ZonePortMapForm();
            zonePortMapForm.setId(zoneListPortMapInfo.getId());
            zonePortMapForm.setIpAddress(zoneListPortMapInfo.getIpAddress());
            zonePortMapForm.setIpPort(zoneListPortMapInfo.getIpPort());
            zonePortMapForm.setProtocol(zoneListPortMapInfo.getProtocol());
            portMapFormList.add(zonePortMapForm);
        }
        return portMapFormList;
    }

    private List<ZoneUndoIpForm> undeploydIpList(Long zoneId, List<String> zoneIp) {
        ArrayList<ZoneUndoIpForm> ipFormList = new ArrayList<ZoneUndoIpForm>();
        if (null != zoneIp) {
            for (String ip : zoneIp) {
                String[] ipMask = null;
                if (ip.contains("/")) {
                    ipMask = ip.split("/");
                } else {
                    String mask = "";
                    if (IPUtil.isIpv4((String)ip)) {
                        mask = "32";
                    } else {
                        if (!IPUtil.isIpv6((String)ip)) continue;
                        mask = "128";
                    }
                    ipMask = new String[]{ip, mask};
                }
                String[] subnetRange = IPUtil.getSubnetRange((String)ipMask[0], (int)Integer.parseInt(ipMask[1]));
                List<ZoneListIpInfo> deployZoneIpList = this.zoneListIpDao.getIpUndoDataByZoneId(zoneId);
                for (ZoneListIpInfo zoneListIpInfo : deployZoneIpList) {
                    if (!subnetRange[0].equals(zoneListIpInfo.getStartIp()) || !subnetRange[1].equals(zoneListIpInfo.getEndIp())) continue;
                    ArrayList<Long> pkIdList = new ArrayList<Long>();
                    pkIdList.add(zoneListIpInfo.getId());
                    ZoneUndoIpForm zoneIpForm = new ZoneUndoIpForm();
                    zoneIpForm.setZoneIp(ipMask[0]);
                    zoneIpForm.setMask(Integer.valueOf(ipMask[1]));
                    zoneIpForm.setPkIdList(pkIdList);
                    ipFormList.add(zoneIpForm);
                }
            }
            return ipFormList;
        }
        List<ZoneListIpInfo> deployZoneIpList = this.zoneListIpDao.getIpUndoDataByZoneId(zoneId);
        for (ZoneListIpInfo zoneListIpInfo : deployZoneIpList) {
            String[] networkSegment;
            ZoneUndoIpForm zoneIpForm;
            ArrayList<Long> pkIdList = new ArrayList<Long>();
            pkIdList.add(zoneListIpInfo.getId());
            int maskType = zoneListIpInfo.getMaskType();
            if (maskType == 0) {
                zoneIpForm = new ZoneUndoIpForm();
                String[] srcIpRange = IPUtil.getSubnetRange((String)zoneListIpInfo.getZoneIp(), (int)zoneListIpInfo.getIntMask());
                zoneIpForm.setZoneIp(srcIpRange[0]);
                zoneIpForm.setMask(zoneListIpInfo.getIntMask());
                zoneIpForm.setPkIdList(pkIdList);
                ipFormList.add(zoneIpForm);
                continue;
            }
            if (maskType != 1) continue;
            for (String ipAdress : networkSegment = IPUtil.getNetworkSegment((String)zoneListIpInfo.getStartIp(), (String)zoneListIpInfo.getEndIp())) {
                zoneIpForm = new ZoneUndoIpForm();
                String[] ipStrings = ipAdress.split("/");
                zoneIpForm.setZoneIp(ipStrings[0]);
                zoneIpForm.setMask(Integer.valueOf(ipStrings[1]));
                zoneIpForm.setPkIdList(pkIdList);
                ipFormList.add(zoneIpForm);
            }
        }
        return ipFormList;
    }

    private List<ZonePortMapForm> deploydPortMapList(Long zoneId) {
        ArrayList<ZonePortMapForm> portMapFormList = new ArrayList<ZonePortMapForm>();
        List<ZonePortMapInfo> deployZonePortMapList = this.zoneListPortMapDao.getPortMapUndoDataByZoneId(zoneId);
        for (ZonePortMapInfo zoneListPortMapInfo : deployZonePortMapList) {
            ZonePortMapForm zonePortMapForm = new ZonePortMapForm();
            zonePortMapForm.setId(zoneListPortMapInfo.getId());
            zonePortMapForm.setIpAddress(zoneListPortMapInfo.getIpAddress());
            zonePortMapForm.setIpPort(zoneListPortMapInfo.getIpPort());
            zonePortMapForm.setProtocol(zoneListPortMapInfo.getProtocol());
            portMapFormList.add(zonePortMapForm);
        }
        return portMapFormList;
    }

    @Override
    public ZoneInfoForm getZoneNOIpById(Long id) {
        if (null == id) {
            this.logger.error((Object)"getZoneNOIpById. Id is null");
            return null;
        }
        ZoneInfo zoneInfo = this.zoneDao.getByZoneId(id);
        if (null == zoneInfo) {
            this.logger.warn((Object)("getZoneNOIpById, result is null. Id is" + id));
            return null;
        }
        ZoneInfoForm zoneInfoForm = (ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm());
        this.logger.info((Object)("get Zone info by id successfuly. Id is : " + id));
        return zoneInfoForm;
    }

    @Override
    public int getZoneNum() {
        int num = this.zoneDao.getTotalZoneNumber();
        this.logger.info((Object)("get zone number in db. zone number = " + num));
        return num;
    }

    @Override
    public boolean isZoneDesExists(String zoneDesc, Long zoneId) {
        return this.zoneDao.isZoneDesExists(zoneDesc, zoneId);
    }

    @Override
    public boolean isZoneNameExists(String zoneName, Long zoneId) {
        return this.zoneDao.isZoneNameExists(zoneName, zoneId);
    }

    public int checkZoneNameDesc(String zoneName, String zoneDesc) {
        return this.zoneDao.checkZoneNameDesc(zoneName, zoneDesc);
    }

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = null;
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        String queryIpAddress = queryMap.get("queryIpAddress");
        String queryMaskAddress = queryMap.get("queryMaskAddress");
        if (!ZoneUtil.isNullExcludeNullStr(queryIpAddress)) {
            ZoneIpForm queryZoneIpForm = new ZoneIpForm();
            queryZoneIpForm.setZoneIp(queryIpAddress);
            this.logger.info((Object)("search zone by ip :" + ZoneServiceImpl.getcleanedMessage(queryIpAddress)));
            if (!ZoneUtil.isNullExcludeNullStr(queryMaskAddress)) {
                queryZoneIpForm.setMask(Integer.parseInt(queryMaskAddress));
            } else if (IPUtil.isIpv4((String)queryIpAddress)) {
                queryZoneIpForm.setMask(32);
            } else {
                queryZoneIpForm.setMask(128);
            }
            this.logger.info((Object)("search zone by ip . mask is" + queryZoneIpForm.getMask()));
            String[] ips = IPUtil.getSubnetRange((String)queryZoneIpForm.getZoneIp(), (int)queryZoneIpForm.getMask());
            String startIp = ips[0];
            String endIp = ips[1];
            queryMap.put("startIp", startIp);
            queryMap.put("endIp", endIp);
        }
        page = this.zoneDao.queryByPage(queryMap, start, pageSize);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    @Override
    public List<ZoneInfoForm> getAll() {
        List<ZoneInfo> zoneList = this.zoneDao.getAll();
        ArrayList<ZoneInfoForm> zoneFormList = new ArrayList<ZoneInfoForm>();
        for (ZoneInfo zoneInfo : zoneList) {
            zoneFormList.add((ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm()));
        }
        this.logger.info((Object)("get all zone info successfully. size is : " + zoneFormList.size()));
        return zoneFormList;
    }

    @Override
    public List<ZoneInfoForm> getAll(Long currentUserId, Boolean currentUserIsAdmin) {
        List<ZoneInfo> zoneList = this.zoneDao.getAll(currentUserId, currentUserIsAdmin);
        ArrayList<ZoneInfoForm> zoneFormList = new ArrayList<ZoneInfoForm>();
        for (ZoneInfo zoneInfo : zoneList) {
            zoneFormList.add((ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm()));
        }
        this.logger.info((Object)("get all zone info successfully. size is : " + zoneFormList.size()));
        return zoneFormList;
    }

    @Override
    public List<Long> getAllZoneIds() {
        return this.zoneDao.getAllZoneIds();
    }

    @Override
    public boolean isDefaultZone(long zoneId) {
        ZoneInfoForm zoneInfo = this.getZoneNOIpById(zoneId);
        if (null != zoneInfo) {
            return zoneInfo.getZoneType() == 1;
        }
        return false;
    }

    @Override
    public ZoneInfoForm getDefaultZoneInfoByDeviceId(long deviceId) {
        ZoneInfo zoneInfo = this.zoneDao.getDefaultZoneInfoByDeviceId(deviceId);
        return (ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm());
    }

    @Override
    public List<ZoneInfoForm> getDeployZoneInfoByDeviceId(Long userId, Boolean userIsAdmin, Long deviceId) {
        List<ZoneInfo> zoneList = this.zoneDao.getDeployZoneInfoByDeviceId(userId, userIsAdmin, deviceId);
        ArrayList<ZoneInfoForm> zoneFormList = new ArrayList<ZoneInfoForm>();
        for (ZoneInfo zoneInfo : zoneList) {
            zoneFormList.add((ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm()));
        }
        return zoneFormList;
    }

    @Override
    public List<ZoneInfoForm> getDeployZoneInfoByDeviceType(Long userId, Boolean userIsAdmin, int deviceType) {
        List<ZoneInfo> zoneList = this.zoneDao.getDeployZoneInfoByDeviceType(userId, userIsAdmin, deviceType);
        ArrayList<ZoneInfoForm> zoneFormList = new ArrayList<ZoneInfoForm>();
        for (ZoneInfo zoneInfo : zoneList) {
            zoneFormList.add((ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm()));
        }
        return zoneFormList;
    }

    @Override
    public Paging getPageDeployZoneInfo(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneDao.getPageDeployZoneInfo(queryMap, start, pageSize, true);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    @Override
    public Paging getPageDeployDDoSZoneInfo(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneDao.getPageDeployDDoSZoneInfo(queryMap, start, pageSize);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    @Override
    public Paging getPageDeployZoneInfoNoNfa(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneDao.getPageDeployZoneInfo(queryMap, start, pageSize, false);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    @Override
    public Paging getConnectZoneInfo(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneDao.getPageZoneInfoWithDevice(queryMap, start, pageSize);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    @Override
    public Boolean isExistConn(Long zoneId, Long deviceId) {
        return this.zoneDao.isExistConn(zoneId, deviceId);
    }

    public ZoneDao getZoneDao() {
        return this.zoneDao;
    }

    public ZoneIpDao getZoneIpDao() {
        return this.zoneIpDao;
    }

    public void setZoneDao(ZoneDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public void setZoneIpDao(ZoneIpDao zoneIpDao) {
        this.zoneIpDao = zoneIpDao;
    }

    @Override
    public List<ZoneInfoForm> getAllDefaultZones() {
        List<ZoneInfo> zoneList = this.zoneDao.getAllDefaultZones();
        this.logger.info((Object)("getDefaultZone:size" + zoneList.size()));
        ArrayList<ZoneInfoForm> zoneFormList = new ArrayList<ZoneInfoForm>();
        for (ZoneInfo zoneInfo : zoneList) {
            this.logger.info((Object)("getDefaultZone:zoneId" + zoneInfo.getZoneId() + ",zoneType:" + zoneInfo.getZoneType() + ",zoneName:" + zoneInfo.getZoneName()));
            zoneFormList.add((ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm()));
        }
        this.logger.info((Object)"query allDefaultZones list successfully");
        return zoneFormList;
    }

    @Override
    public List<ZoneIpForm> findExistIp(ZoneIpForm zoneIpForm) {
        ArrayList<ZoneIpForm> zoneIpFormList = new ArrayList<ZoneIpForm>();
        if (null == zoneIpForm) {
            this.logger.info((Object)"parameter  zoneIpForm is null");
            return null;
        }
        if (null == zoneIpForm.getZoneIp() && null == zoneIpForm.getMask()) {
            this.logger.info((Object)"parameter  zoneIpForm.getZoneIp() or  zoneIpForm.getMask() is null");
            return null;
        }
        String startIp = IPUtil.getSubnetRange((String)zoneIpForm.getZoneIp(), (int)zoneIpForm.getMask())[0];
        String endIp = IPUtil.getSubnetRange((String)zoneIpForm.getZoneIp(), (int)zoneIpForm.getMask())[1];
        List<ZoneIpInfo> zoneIpInfoList = this.zoneIpDao.findExistZoneIpInfobyIp(startIp, endIp);
        for (ZoneIpInfo zoneIpInfo : zoneIpInfoList) {
            ZoneIpForm zif = new ZoneIpForm();
            ZoneUtil.copyProperties(zoneIpInfo, zif);
            zoneIpFormList.add(zif);
        }
        return zoneIpFormList;
    }

    public boolean isExistIP(ZoneIpForm zoneIpForm) {
        if (null == zoneIpForm.getZoneIp() && null == zoneIpForm.getMask()) {
            this.logger.info((Object)"parameter  zoneIpForm.getZoneIp() or  zoneIpForm.getMask() is null");
            return true;
        }
        String[] ips = IPUtil.getSubnetRange((String)zoneIpForm.getZoneIp(), (int)zoneIpForm.getMask());
        String startIp = ips[0];
        String endIp = ips[1];
        return this.zoneIpDao.isExistsIp(startIp, endIp);
    }

    @Override
    public Long getZoneIdByIpAndMask(String ip, int mask) {
        String[] ips = IPUtil.getSubnetRange((String)ip, (int)mask);
        String startIp = ips[0];
        String endIp = ips[1];
        return this.zoneDao.getZoneIdByIpAndMask(startIp, endIp);
    }

    @Override
    public Paging getReportZoneInfoByDeviceId(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneDao.getPageDeployZoneInfo(queryMap, start, pageSize, true);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    @Override
    public Paging getReportZoneInfoByDeviceIdAndInfo(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneDao.getPageDeployZoneInfo(queryMap, start, pageSize, true);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    @Override
    public Paging getReportZoneInfoByDeviceType(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneDao.getPageDeployZoneInfo(queryMap, start, pageSize, true);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    @Override
    public Paging getReportZoneInfoByDeviceTypeAndInfo(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<ZoneInfoForm> zoneInfoFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneDao.getPageDeployZoneInfo(queryMap, start, pageSize, true);
        for (ZoneInfo zi : page.getData()) {
            ZoneInfoForm zif = new ZoneInfoForm();
            ZoneUtil.copyProperties(zi, zif);
            zoneInfoFormList.add(zif);
        }
        page.setData(zoneInfoFormList);
        this.logger.info((Object)("query zoneInfo list successfully. Size is : " + zoneInfoFormList.size()));
        return page;
    }

    private ISynchronizDivertService getSynchronizDivertService() {
        this.synchronizDivertService = ZoneReferUtil.getSynchronizDivertService();
        return this.synchronizDivertService;
    }

    private IDivertForPolicy getDivertForPolicyService() {
        this.divertTacticsService = ZoneReferUtil.getDivertForPolicyService();
        return this.divertTacticsService;
    }

    @Override
    public Long getLastInsertZoneId() {
        return this.zoneDao.getLastInsertZoneId();
    }

    public IServiceLearningParamService getServiceLearningParamService() {
        return this.serviceLearningParamService;
    }

    public void setServiceLearningParamService(IServiceLearningParamService serviceLearningParamService) {
        this.serviceLearningParamService = serviceLearningParamService;
    }

    public ICurrentZoneIdService getCurrentZoneIdService() {
        return this.currentZoneIdService;
    }

    public void setCurrentZoneIdService(ICurrentZoneIdService currentZoneIdService) {
        this.currentZoneIdService = currentZoneIdService;
    }

    @Override
    public Boolean isExist(String startIp, String endIp) {
        return this.zoneIpDao.isExistsIp(startIp, endIp);
    }

    @Override
    public String validToDeleteIpAddr(String[] ipArr, Long zoneId) {
        if (null == zoneId || null == ipArr) {
            return "";
        }
        this.divertTacticsService = this.getDivertForPolicyService();
        List<DivertTacticsForm> divertTacticsForms = this.divertTacticsService.getDivertTacticsByZoneId(zoneId);
        if (null != divertTacticsForms && !divertTacticsForms.isEmpty()) {
            for (DivertTacticsForm form : divertTacticsForms) {
                for (String ipStr : ipArr) {
                    String endIp;
                    String startIp = ipStr.split(",")[0];
                    if (!IPUtil4Atic.isCrossIpRange((String[])new String[]{startIp, endIp = ipStr.split(",")[1]}, (String[])new String[]{form.getStartIp(), form.getEndIp()})) continue;
                    this.logger.error((Object)("ip valid false divert ip is " + form.getDivertIp() + " and ip mask is " + form.getMask()));
                    return ipStr;
                }
            }
        }
        return "";
    }

    @Override
    public List<ZoneIpForm> getRepeatIpWithOtherZone(long zoneId, String startIp, String endIp, boolean isAdd) {
        ArrayList<ZoneIpForm> zoneIpFormList = new ArrayList<ZoneIpForm>();
        List<ZoneIpInfo> zoneIpInfoList = null;
        zoneIpInfoList = isAdd ? this.zoneIpDao.findExistZoneIpInfobyIp(startIp, endIp) : this.zoneIpDao.findIpbyStartIpAndEndIpExceptZoneId(zoneId, startIp, endIp);
        if (!zoneIpInfoList.isEmpty()) {
            for (ZoneIpInfo zoneIpInfo : zoneIpInfoList) {
                ZoneIpForm zif = new ZoneIpForm();
                ZoneUtil.copyProperties(zoneIpInfo, zif);
                zoneIpFormList.add(zif);
            }
        }
        return zoneIpFormList;
    }

    @Override
    public List<ZoneListIpForm> getListIpByZoneId(Long zoneId) {
        List<ZoneListIpInfo> zoneListIpInfolList = this.zoneListIpDao.getByZoneId(zoneId);
        ArrayList<ZoneListIpForm> zoneListIpFromlList = new ArrayList<ZoneListIpForm>();
        this.generatePo2Vo(zoneListIpInfolList, zoneListIpFromlList);
        return zoneListIpFromlList;
    }

    @Override
    public List<ZoneListIpForm> findExistSigIp(String zoneIp, boolean isIpv4) {
        List<ZoneListIpInfo> zoneListIpInfolList = this.zoneListIpDao.findExistSigIp(zoneIp, isIpv4);
        ArrayList<ZoneListIpForm> zoneListIpFromlList = new ArrayList<ZoneListIpForm>();
        this.generatePo2Vo(zoneListIpInfolList, zoneListIpFromlList);
        return zoneListIpFromlList;
    }

    @Override
    public List<ZoneListIpForm> findExistByIpMask(String zoneIp, boolean isIpv4, int mask) {
        List<ZoneListIpInfo> zoneListIpInfolList = this.zoneListIpDao.findExistByIpMask(zoneIp, isIpv4, mask);
        ArrayList<ZoneListIpForm> zoneListIpFromlList = new ArrayList<ZoneListIpForm>();
        this.generatePo2Vo(zoneListIpInfolList, zoneListIpFromlList);
        return zoneListIpFromlList;
    }

    private void generatePo2Vo(List<ZoneListIpInfo> zoneListIpInfolList, List<ZoneListIpForm> zoneListIpFromlList) {
        if (zoneListIpInfolList != null && !zoneListIpInfolList.isEmpty()) {
            for (ZoneListIpInfo zoneListIpInfo : zoneListIpInfolList) {
                ZoneListIpForm zoneListIpFrom = new ZoneListIpForm();
                ZoneUtil.copyProperties(zoneListIpInfo, zoneListIpFrom);
                zoneListIpFromlList.add(zoneListIpFrom);
            }
        }
    }

    @Override
    public List<ZoneListIpForm> findExistByIpMaskWithoutSourceZoneId(String zoneIp, boolean isIpv4, int mask, String sourceZoneId) {
        List<ZoneListIpInfo> zoneListIpInfolList = this.zoneListIpDao.findExistByIpMaskWithoutSourceZoneId(zoneIp, isIpv4, mask, sourceZoneId);
        ArrayList<ZoneListIpForm> zoneListIpFromlList = new ArrayList<ZoneListIpForm>();
        this.generatePo2Vo(zoneListIpInfolList, zoneListIpFromlList);
        return zoneListIpFromlList;
    }

    private boolean isUndoAll(Long zoneId) {
        List<ZoneListIpInfo> zoneListIpInfolList = this.zoneListIpDao.getExcludeByZoneId(zoneId);
        if (null != zoneListIpInfolList && !zoneListIpInfolList.isEmpty()) {
            return true;
        }
        zoneListIpInfolList = this.zoneListIpDao.getByZoneIdAndFlag(zoneId);
        return null == zoneListIpInfolList || zoneListIpInfolList.isEmpty();
    }

    @Override
    public void delZoneListIpByIp(String zoneIp) {
        this.zoneListIpDao.delZoneListIpByIp(zoneIp);
    }

    @Override
    public void delZoneIpByIp(String ip) {
        this.zoneIpDao.deleteIpByIp(ip);
    }

    @Override
    public long getZoneIdByIp(String zoneIp) {
        return this.zoneIpDao.getZoneIdByIp(zoneIp);
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public ZoneIpLocationDao getZoneIpLocationDao() {
        return this.zoneIpLocationDao;
    }

    public void setZoneIpLocationDao(ZoneIpLocationDao zoneIpLocationDao) {
        this.zoneIpLocationDao = zoneIpLocationDao;
    }

    @Override
    public String delZoneByName(String zoneName) {
        List optResults;
        Iterator iterator;
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        Long zoneId = this.zoneDao.getMoIdByZoneNameForRestIf(zoneName);
        if (0L == zoneId) {
            return "The Zone does not exist.";
        }
        bo.setTargetId(zoneId.longValue());
        bo.setTargetName(zoneName);
        bo.setDetailParam(new String[]{"1"});
        boList.add(bo);
        BatchOperationResult result = this.batchDelZone(boList);
        if (result.getFailCount() > 0 && (iterator = (optResults = result.getResult()).iterator()).hasNext()) {
            BatchOperation optResult = (BatchOperation)iterator.next();
            if (570609L == optResult.getErrorCode()) {
                return "The Zone does not exist.";
            }
            if (570627L == optResult.getErrorCode()) {
                return "Failed to delete the packet-capturing task.";
            }
            if (570628L == optResult.getErrorCode()) {
                return "Failed to delete the diversion task.";
            }
            if (570629L == optResult.getErrorCode()) {
                return "Failed to delete the baseline-learning task.";
            }
            if (570630L == optResult.getErrorCode()) {
                return "Failed to delete the service-learning task.";
            }
            if (570626L == optResult.getErrorCode()) {
                return "Failed to undeploy Zone from device. Please check and clear the antiddos device data manually.";
            }
            return "An unknown ATIC internal error occurred.";
        }
        return "success";
    }

    @Override
    public List<ZoneInfoForm> getZoneByNameOrDesc(String zoneName, String zoneDesc) {
        List<ZoneInfo> zoneList = this.zoneDao.getZoneByNameOrDesc(zoneName, zoneDesc);
        ArrayList<ZoneInfoForm> zoneFormList = new ArrayList<ZoneInfoForm>();
        for (ZoneInfo zoneInfo : zoneList) {
            zoneFormList.add((ZoneInfoForm)ZoneUtil.copyProperties(zoneInfo, new ZoneInfoForm()));
        }
        return zoneFormList;
    }

    @Override
    public ZoneInfoForm getZoneByName(String zoneName) {
        ZoneInfo zoneInfo = this.zoneDao.getZoneByName(zoneName);
        if (null != zoneInfo) {
            ZoneInfoForm zoneInfoForm = new ZoneInfoForm();
            ZoneUtil.copyProperties(zoneInfo, zoneInfoForm);
            return zoneInfoForm;
        }
        return null;
    }

    @Override
    public ZoneInfoForm getCustomZoneByName(String zoneName) {
        ZoneInfo zoneInfo = this.zoneDao.getCustomZoneByName(zoneName);
        if (null != zoneInfo) {
            ZoneInfoForm zoneInfoForm = new ZoneInfoForm();
            ZoneUtil.copyProperties(zoneInfo, zoneInfoForm);
            return zoneInfoForm;
        }
        return null;
    }

    @Override
    public ZoneInfoForm getZoneByDefPol(String mbps, String pps, String newConn, String currConn, String httpQps) {
        ZoneInfo zoneInfo = this.zoneDao.getZoneByDefPolForRestIf(mbps, pps, newConn, currConn, httpQps);
        if (null != zoneInfo) {
            ZoneInfoForm zoneInfoForm = new ZoneInfoForm();
            ZoneUtil.copyProperties(zoneInfo, zoneInfoForm);
            return zoneInfoForm;
        }
        return null;
    }

    @Override
    public long getDeployDefaultZoneByDeviceId(Long deviceId) {
        return this.zoneDao.getDeployDefaultZoneInfoByDeviceId(deviceId);
    }

    @Override
    public void updateZoneIpFlag(String zoneIp) {
        this.zoneListIpDao.updateFlagByRestful(zoneIp);
    }

    @Override
    public void updateZoneIpFlag(String zoneIp, int flag) {
        this.zoneListIpDao.updateFlagByRestful(zoneIp, flag);
    }

    @Override
    public void updateFlagByRestful(Long zoneId) {
        this.zoneListIpDao.updateFlagByRestful(zoneId);
    }

    @Override
    public boolean isExistPartDeploy(Long ipId) {
        return !this.zoneIpStatusDao.findByIpIdAndState(ipId).isEmpty();
    }

    @Override
    public void deleteListIpAndIpState(List<ZoneListIpForm> zoneListIpForms) {
        if (!zoneListIpForms.isEmpty()) {
            ArrayList<Long> ipIdList = new ArrayList<Long>();
            for (ZoneListIpForm zoneListIpForm : zoneListIpForms) {
                ipIdList.add(zoneListIpForm.getId());
            }
            this.zoneIpStatusDao.deleteIpByPkIds(ipIdList);
            this.zoneListIpDao.deleteIpByPkIds(ipIdList);
        }
    }

    @Override
    public void deletePortMapAndMapState(List<ZonePortMapForm> zonePortMapForms) {
        if (!zonePortMapForms.isEmpty()) {
            ArrayList<Long> idList = new ArrayList<Long>();
            for (ZonePortMapForm zonePortMapForm : zonePortMapForms) {
                idList.add(zonePortMapForm.getId());
            }
            this.zoneListPortMapStateDao.deleteIpByPortMapIds(idList);
            this.zoneListPortMapDao.deleteIpByPortMapIds(idList);
        }
    }

    @Override
    public void delZoneListIpByIpAndZoneId(String zoneIp, long zoneId) {
        this.zoneListIpDao.delZoneListIpByIpAndZoneId(zoneIp, zoneId);
    }

    @Override
    public void delZoneIpByIpAndZoneId(String ip, long zoneId) {
        this.zoneIpDao.delZoneIpByIpAndZoneId(ip, zoneId);
    }

    @Override
    public void deleteZoneIpAndZoneIpList(ZoneIpForm zoneIpForm, long zoneId, String zoneIp) {
        this.zoneIpDao.deleteZoneIpForm(zoneIpForm);
        this.zoneListIpDao.updateFlagByRestful(zoneIp);
    }

    @Override
    public void deleteSourceZoneIpAndZoneIpListAndAddDestZoneIp(ZoneIpForm sourceZoneIpForm, long sourceZoneId, String zoneIp, ZoneIpForm destZoneIpForm, ZoneListIpForm destZoneListIpForm, long destZoneId) {
        if (null != sourceZoneIpForm) {
            this.zoneIpDao.deleteIpByIp(sourceZoneIpForm.getZoneId(), sourceZoneIpForm.getZoneIp(), sourceZoneIpForm.getMask());
            this.zoneListIpDao.delZoneListIpByIp(IPUtil4Atic.compressIP((String)sourceZoneIpForm.getStartIp()), IPUtil4Atic.compressIP((String)sourceZoneIpForm.getEndIp()), sourceZoneIpForm.getZoneId());
        }
        ZoneListIpInfo destZoneListIpInfo = new ZoneListIpInfo();
        if (null != destZoneListIpForm) {
            destZoneListIpForm.setId(null);
            destZoneListIpForm.setZoneId(destZoneId);
            ZoneUtil.copyProperties(destZoneListIpForm, destZoneListIpInfo);
            this.zoneListIpDao.saveOrUpdate(destZoneListIpInfo);
            destZoneListIpForm.setId(destZoneListIpInfo.getId());
        }
        if (null != destZoneIpForm) {
            destZoneIpForm.setId(null);
            ZoneIpInfo destZoneIpInfo = new ZoneIpInfo();
            destZoneIpForm.setZoneId(destZoneId);
            destZoneIpForm.setStartIp(IPUtil4Atic.convert2CompleteIp((String)destZoneIpForm.getStartIp()));
            destZoneIpForm.setEndIp(IPUtil4Atic.convert2CompleteIp((String)destZoneIpForm.getEndIp()));
            ZoneUtil.copyProperties(destZoneIpForm, destZoneIpInfo);
            this.zoneIpDao.saveOrUpdate(destZoneIpInfo);
            destZoneIpForm.setId(destZoneIpInfo.getId());
        }
    }

    @Override
    public void saveOrUpdateSourceZoneIpAndZoneIpListAndAddDestZoneIp(ZoneIpForm sourceZoneIpForm, long sourceZoneId, String zoneIp, ZoneIpForm destZoneIpForm, ZoneListIpForm destZoneListIpForm, long destZoneId) {
        this.zoneIpDao.deleteZoneIpForm(destZoneIpForm);
        this.zoneListIpDao.deleteZoneListIp(destZoneListIpForm.getId());
        ZoneListIpInfo destZoneListIpInfo = new ZoneListIpInfo();
        destZoneListIpForm.setId(null);
        destZoneListIpForm.setZoneId(sourceZoneId);
        ZoneUtil.copyProperties(destZoneListIpForm, destZoneListIpInfo);
        this.zoneListIpDao.saveOrUpdate(destZoneListIpInfo);
        destZoneIpForm.setId(null);
        ZoneIpInfo destZoneIpInfo = new ZoneIpInfo();
        destZoneIpForm.setZoneId(sourceZoneId);
        destZoneIpForm.setStartIp(IPUtil4Atic.convert2CompleteIp((String)destZoneIpForm.getStartIp()));
        destZoneIpForm.setEndIp(IPUtil4Atic.convert2CompleteIp((String)destZoneIpForm.getEndIp()));
        ZoneUtil.copyProperties(destZoneIpForm, destZoneIpInfo);
        this.zoneIpDao.saveOrUpdate(destZoneIpInfo);
    }

    @Override
    public void updateSourceZoneIpAndZoneIpListAndAddDestZoneIp(ZoneIpForm sourceZoneIpForm, long sourceZoneId, String zoneIp, ZoneIpForm destZoneIpForm, ZoneListIpForm destZoneListIpForm, long destZoneId) {
        this.zoneIpDao.deleteZoneIpForm(destZoneIpForm);
        this.zoneListIpDao.deleteZoneListIp(destZoneListIpForm.getId());
        this.zoneListIpDao.updateFlagByRestful(zoneIp, 0, sourceZoneId);
        destZoneIpForm.setId(null);
        ZoneIpInfo destZoneIpInfo = new ZoneIpInfo();
        destZoneIpForm.setZoneId(sourceZoneId);
        destZoneIpForm.setStartIp(IPUtil4Atic.convert2CompleteIp((String)destZoneIpForm.getStartIp()));
        destZoneIpForm.setEndIp(IPUtil4Atic.convert2CompleteIp((String)destZoneIpForm.getEndIp()));
        ZoneUtil.copyProperties(destZoneIpForm, destZoneIpInfo);
        this.zoneIpDao.saveOrUpdate(destZoneIpInfo);
    }

    @Override
    public void saveOrUpdateZoneIpAndZoneIpList(ZoneIpForm zoneIpForm, long zoneId, String zoneIp) {
        zoneIpForm.setId(null);
        ZoneIpInfo zoneIpInfo = new ZoneIpInfo();
        zoneIpForm.setZoneId(zoneId);
        zoneIpForm.setStartIp(IPUtil4Atic.convert2CompleteIp((String)zoneIpForm.getStartIp()));
        zoneIpForm.setEndIp(IPUtil4Atic.convert2CompleteIp((String)zoneIpForm.getEndIp()));
        ZoneUtil.copyProperties(zoneIpForm, zoneIpInfo);
        this.zoneIpDao.saveOrUpdate(zoneIpInfo);
        this.zoneListIpDao.updateFlagByRestful(zoneIp, 0);
    }

    /*
     * WARNING - void declaration
     */
    public void modifyZoneMsgForEditCluster(Long clusterId, List<Long> addDevIds, List<AticDevice> deleteDevs, List<AticDevice> oldDevs) {
        ArrayList<AticDevice> deleteDevsCopy = new ArrayList<AticDevice>();
        deleteDevsCopy.addAll(deleteDevs);
        ArrayList<Long> addDevIdsCopy = new ArrayList<Long>();
        addDevIdsCopy.addAll(addDevIds);
        for (AticDevice aticDevice : deleteDevs) {
            if (8 == aticDevice.getDeviceType()) continue;
            deleteDevsCopy.remove(aticDevice);
        }
        AticDeviceDao aticDeviceDao = (AticDeviceDao)ServiceContext.getInstance().getService("aticDeviceDao", AticDeviceDao.class);
        for (Long device1820Id : addDevIds) {
            AticDevice device1820 = aticDeviceDao.getDeviceByMoid(device1820Id.longValue());
            if (8 == device1820.getDeviceType()) continue;
            addDevIdsCopy.remove(device1820.getMoId());
        }
        ArrayList arrayList = new ArrayList();
        List<Object> oldZoneServiceStatusInfos = new ArrayList();
        List<Object> oldFilterDeviceZoneStatusInfos = new ArrayList();
        if (!oldDevs.isEmpty() || !deleteDevsCopy.isEmpty()) {
            List<ZoneIpStatusInfo> list = this.zoneIpStatusDao.findByDeviceId(!oldDevs.isEmpty() ? oldDevs.get(0).getMoId() : ((AticDevice)deleteDevsCopy.get(0)).getMoId());
            oldZoneServiceStatusInfos = this.zoneServiceStatusDao.queryByDeviceId(!oldDevs.isEmpty() ? oldDevs.get(0).getMoId() : ((AticDevice)deleteDevsCopy.get(0)).getMoId());
            oldFilterDeviceZoneStatusInfos = this.filterDeviceZoneStatusDao.findByDeviceId(!oldDevs.isEmpty() ? oldDevs.get(0).getMoId() : ((AticDevice)deleteDevsCopy.get(0)).getMoId());
        }
        if (!deleteDevsCopy.isEmpty()) {
            for (AticDevice deleteDev : deleteDevsCopy) {
                this.zoneIpStatusDao.deleteIpByDeviceId(deleteDev.getMoId());
                this.logger.info((Object)("delete zone_ip_status by deviceID = " + deleteDev.getMoId()));
                this.zoneServiceStatusDao.deleteByDeviceId(deleteDev.getMoId());
                this.logger.info((Object)("delete zone_service_status by deviceID = " + deleteDev.getMoId()));
                this.filterDeviceZoneStatusDao.deleteByDeviceId(deleteDev.getMoId());
                this.logger.info((Object)("delete filter_device_zone_status by deviceID = " + deleteDev.getMoId()));
                this.zoneDeviceDeployStatusService.deleteByDeviceId(deleteDev.getMoId());
                this.logger.info((Object)("delete t_vsm_zone_device_status by deviceID = " + deleteDev.getMoId()));
            }
        }
        for (Long addDevId : addDevIdsCopy) {
            void var8_12;
            for (ZoneIpStatusInfo zoneIpStatusInfo : var8_12) {
                ZoneIpStatusInfo zoneIpStatus = new ZoneIpStatusInfo();
                zoneIpStatus.setDeployState(false);
                zoneIpStatus.setDeviceId(addDevId);
                zoneIpStatus.setIpId(zoneIpStatusInfo.getIpId());
                this.zoneIpStatusDao.saveOrUpdate(zoneIpStatus);
                this.zoneListIpDao.updateDeployStateById(zoneIpStatusInfo.getIpId(), false);
            }
            for (ZoneServiceStatusInfo zoneServiceStatusInfo : oldZoneServiceStatusInfos) {
                ZoneServiceStatusInfo zoneServiceStatus = new ZoneServiceStatusInfo();
                zoneServiceStatus.setDeployCrc(zoneServiceStatusInfo.getDeployCrc());
                zoneServiceStatus.setDeployState(false);
                zoneServiceStatus.setDeployTime(zoneServiceStatusInfo.getDeployTime());
                zoneServiceStatus.setDeviceId(addDevId);
                zoneServiceStatus.setProtocol(zoneServiceStatusInfo.getProtocol());
                zoneServiceStatus.setServiceId(zoneServiceStatusInfo.getServiceId());
                zoneServiceStatus.setServiceName(zoneServiceStatusInfo.getServiceName());
                zoneServiceStatus.setServiceType(zoneServiceStatusInfo.getServiceType());
                zoneServiceStatus.setZoneId(zoneServiceStatusInfo.getZoneId());
                this.zoneServiceStatusDao.save(zoneServiceStatus);
            }
            for (FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo : oldFilterDeviceZoneStatusInfos) {
                FilterDeviceZoneStatusInfo filterDeviceZoneStatus = new FilterDeviceZoneStatusInfo();
                filterDeviceZoneStatus.setDeployState(false);
                filterDeviceZoneStatus.setDeviceId(addDevId);
                filterDeviceZoneStatus.setFilterId(filterDeviceZoneStatusInfo.getFilterId());
                filterDeviceZoneStatus.setDirection(filterDeviceZoneStatusInfo.getDirection());
                filterDeviceZoneStatus.setFilterDefineState(false);
                filterDeviceZoneStatus.setZoneId(filterDeviceZoneStatusInfo.getZoneId());
                filterDeviceZoneStatus.setFilterPreference(filterDeviceZoneStatusInfo.getFilterPreference());
                this.filterDeviceZoneStatusDao.save(filterDeviceZoneStatus);
            }
        }
        this.changeZoneDeployStatus(clusterId, addDevIdsCopy, deleteDevsCopy, oldDevs);
    }

    private void changeZoneDeployStatus(Long clusterId, List<Long> addDevIds, List<AticDevice> deleteDevs, List<AticDevice> oldDevs) {
        List<ZonePolicyApplyInfo> zonePolicyApplyInfos = this.zonePolicyApplyService.getZoneInfoByDeviceId(clusterId);
        for (ZonePolicyApplyInfo zonePolicyApplyInfo : zonePolicyApplyInfos) {
            ZonePolicyApplyForm zonePolicyApplyForm = new ZonePolicyApplyForm();
            VsmUtil.getInstance().copyProperties(zonePolicyApplyInfo, zonePolicyApplyForm);
            if (zonePolicyApplyForm.getDeployState().equals("UNDEPLOY")) continue;
            if (null != addDevIds && !addDevIds.isEmpty()) {
                if (zonePolicyApplyForm.getDeployState().equals("SUCCESS") || zonePolicyApplyForm.getDeployState().equals("PART_SUCCESS")) {
                    zonePolicyApplyForm.setDeployState("INCREAMENT_UNDEPLOY");
                }
                if (zonePolicyApplyForm.getFilterState().equals("SUCCESS") || zonePolicyApplyForm.getFilterState().equals("PART_SUCCESS")) {
                    zonePolicyApplyForm.setFilterState("INCREAMENT_UNDEPLOY");
                }
            }
            if (null != deleteDevs && !deleteDevs.isEmpty()) {
                if (zonePolicyApplyForm.getDeployState().equals("SUCCESS") && zonePolicyApplyForm.getFilterState().equals("SUCCESS") || zonePolicyApplyForm.getDeployState().equals("INCREAMENT_UNDEPLOY") || zonePolicyApplyForm.getFilterState().equals("INCREAMENT_UNDEPLOY")) continue;
                zonePolicyApplyForm.setFilterState("SUCCESS");
                List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfos = this.filterDeviceZoneStatusDao.getByZoneId(zonePolicyApplyForm.getZoneId());
                for (FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo : filterDeviceZoneStatusInfos) {
                    FilterDeviceZoneStatusForm filterDeviceZoneStatusForm = new FilterDeviceZoneStatusForm();
                    VsmUtil.getInstance().copyProperties(filterDeviceZoneStatusInfo, filterDeviceZoneStatusForm);
                    if (filterDeviceZoneStatusForm.getDeployState().booleanValue()) continue;
                    zonePolicyApplyForm.setFilterState("PART_SUCCESS");
                    break;
                }
                boolean zoneStatusChange = false;
                ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao = (ZoneDeviceDeployStatusDao)((Object)ServiceContext.getInstance().getService("zoneDeviceDeployStatusDao", ZoneDeviceDeployStatusDao.class));
                zonePolicyApplyForm.setDeployState("SUCCESS");
                List<ZoneDeviceDeployStatusInfo> zoneDeviceDeployStatusInfos = zoneDeviceDeployStatusDao.queryByZoneId(zonePolicyApplyForm.getZoneId());
                for (ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo : zoneDeviceDeployStatusInfos) {
                    ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm = new ZoneDeviceDeployStatusForm();
                    VsmUtil.getInstance().copyProperties(zoneDeviceDeployStatusInfo, zoneDeviceDeployStatusForm);
                    if (zoneDeviceDeployStatusForm.getDeployState().booleanValue()) continue;
                    zonePolicyApplyForm.setDeployState("PART_SUCCESS");
                    zoneStatusChange = true;
                    break;
                }
                if (zoneStatusChange) continue;
                List<ZoneIpInfo> zoneIpInfos = this.zoneIpDao.findIpByZoneId(zonePolicyApplyForm.getZoneId());
                zonePolicyApplyForm.setDeployState("SUCCESS");
                block3: for (ZoneIpInfo zoneIpInfo : zoneIpInfos) {
                    ZoneIpForm zoneIpForm = new ZoneIpForm();
                    VsmUtil.getInstance().copyProperties(zoneIpInfo, zoneIpForm);
                    List<ZoneIpStatusInfo> zoneIpStatusInfos = this.zoneIpStatusDao.findByIpIdAndState(zoneIpForm.getId());
                    for (ZoneIpStatusInfo zoneIpStatusInfo : zoneIpStatusInfos) {
                        ZoneIpStatusInfo zoneIpStatus = new ZoneIpStatusInfo();
                        VsmUtil.getInstance().copyProperties(zoneIpStatusInfo, zoneIpStatus);
                        if (zoneIpStatus.isDeployState()) continue;
                        zonePolicyApplyForm.setDeployState("PART_SUCCESS");
                        continue block3;
                    }
                }
            }
            this.zonePolicyApplyService.update(zonePolicyApplyForm);
        }
    }

    public void removeSingleDevToCulster(Long clusterId, List<Long> addDevIdList) {
        if (null != addDevIdList && !addDevIdList.isEmpty()) {
            ArrayList changeZoneIds = new ArrayList();
            for (Long devId : addDevIdList) {
                List zoneIdList = this.zoneDeviceService.getZonesByDevId(devId);
                if (null == zoneIdList || zoneIdList.isEmpty()) continue;
                changeZoneIds.addAll(zoneIdList);
                this.zoneDeviceService.deleteByDeviceId(devId);
                this.zoneDeviceDeployStatusService.deleteByDeviceId(devId);
                this.zoneFeatureStatusDao.deleteByDeviceId(devId);
                this.zoneServiceStatusDao.deleteByDeviceId(devId);
                this.zoneServiceService.deleteByDeviceId(devId);
                this.zoneIpStatusDao.deleteIpByDeviceId(devId);
                this.filterZoneService.delFilterRelationByDeviceId(devId);
                this.filterDeviceZoneStatusDao.deleteByDeviceId(devId);
                this.filterDeviceDao.deleteByDeviceId(devId);
            }
            HashSet hashSet = new HashSet(changeZoneIds);
            changeZoneIds.clear();
            changeZoneIds.addAll(hashSet);
            for (Long changeZoneId : changeZoneIds) {
                List containDevIds = this.zoneDeviceService.getDeviceIdsByZoneId(changeZoneId);
                if (null != containDevIds && !containDevIds.isEmpty()) continue;
                this.zonePolicyApplyService.updateDeployStateByZoneId(changeZoneId, "UNDEPLOY");
            }
        }
    }

    public INfaPolicyEditService getNfaPolicyEditService() {
        return this.nfaPolicyEditService;
    }

    public void setNfaPolicyEditService(INfaPolicyEditService nfaPolicyEditService) {
        this.nfaPolicyEditService = nfaPolicyEditService;
    }

    public ZoneListPortMapDao getZoneListPortMapDao() {
        return this.zoneListPortMapDao;
    }

    public void setZoneListPortMapDao(ZoneListPortMapDao zoneListPortMapDao) {
        this.zoneListPortMapDao = zoneListPortMapDao;
    }

    public IFilterDeviceZoneInfoService getFilterDeviceZoneInfoService() {
        return this.filterDeviceZoneInfoService;
    }

    public void setFilterDeviceZoneInfoService(IFilterDeviceZoneInfoService filterDeviceZoneInfoService) {
        this.filterDeviceZoneInfoService = filterDeviceZoneInfoService;
    }

    public IDiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public void setDiscoveryService(IDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public FaultSeverityRuleService getFaultSeverityRuleService() {
        return this.faultSeverityRuleService;
    }

    public void setFaultSeverityRuleService(FaultSeverityRuleService faultSeverityRuleService) {
        this.faultSeverityRuleService = faultSeverityRuleService;
    }

    public ZoneListIpDao getZoneListIpDao() {
        return this.zoneListIpDao;
    }

    public void setZoneListIpDao(ZoneListIpDao zoneListIpDao) {
        this.zoneListIpDao = zoneListIpDao;
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    public IBaseLineService getBaseLineService() {
        return this.baseLineService;
    }

    public void setBaseLineService(IBaseLineService baseLineService) {
        this.baseLineService = baseLineService;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public ZoneIpStatusDao getZoneIpStatusDao() {
        return this.zoneIpStatusDao;
    }

    public void setZoneIpStatusDao(ZoneIpStatusDao zoneIpStatusDao) {
        this.zoneIpStatusDao = zoneIpStatusDao;
    }

    public ZoneListPortMapStateDao getZoneListPortMapStateDao() {
        return this.zoneListPortMapStateDao;
    }

    public void setZoneListPortMapStateDao(ZoneListPortMapStateDao zoneListPortMapStateDao) {
        this.zoneListPortMapStateDao = zoneListPortMapStateDao;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneServiceStatusDao getZoneServiceStatusDao() {
        return this.zoneServiceStatusDao;
    }

    public void setZoneServiceStatusDao(ZoneServiceStatusDao zoneServiceStatusDao) {
        this.zoneServiceStatusDao = zoneServiceStatusDao;
    }

    public FilterDeviceDao getFilterDeviceDao() {
        return this.filterDeviceDao;
    }

    public void setFilterDeviceDao(FilterDeviceDao filterDeviceDao) {
        this.filterDeviceDao = filterDeviceDao;
    }

    public FilterDeviceZoneStatusDao getFilterDeviceZoneStatusDao() {
        return this.filterDeviceZoneStatusDao;
    }

    public void setFilterDeviceZoneStatusDao(FilterDeviceZoneStatusDao filterDeviceZoneStatusDao) {
        this.filterDeviceZoneStatusDao = filterDeviceZoneStatusDao;
    }

    public IFilterDeviceZoneInfoService getFilterZoneService() {
        return this.filterZoneService;
    }

    public void setFilterZoneService(IFilterDeviceZoneInfoService filterZoneService) {
        this.filterZoneService = filterZoneService;
    }

    public void setZoneDeviceDeployStatusService(IZoneDeviceDeployStatusService zoneDeviceDeployStatusService) {
        this.zoneDeviceDeployStatusService = zoneDeviceDeployStatusService;
    }
}

