/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.util;

import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.form.LocationIpForm;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.sdk.bis.service.ILocationIpService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.ImportZoneConstant;
import com.hs.atic.zone.util.ImportZoneData;
import com.hs.atic.zone.util.ImportZoneUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.FilterUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpKeyDetectUriForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TopNStudyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;

public final class CheckImportXml {
    static final Map<String, List<String>> MAP1 = new HashMap<String, List<String>>();
    private static final Long NUM_570648 = 570648L;
    private static final String SEPARATOR = "/";
    private static final List<String> FILTER_TYPELIST = new ArrayList<String>();
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static CheckImportXml instance = null;
    private static final Map<String, List<String>> MP2 = new HashMap<String, List<String>>();
    private static ReentrantLock lock = new ReentrantLock();

    private CheckImportXml() {
    }

    public static CheckImportXml getInstance() {
        lock.lock();
        try {
            CheckImportXml checkImportXml = instance == null ? (CheckImportXml)CheckImportXml.class.newInstance() : instance;
            return checkImportXml;
        }
        catch (InstantiationException e) {
            CheckImportXml checkImportXml = null;
            return checkImportXml;
        }
        catch (IllegalAccessException e) {
            CheckImportXml checkImportXml = null;
            return checkImportXml;
        }
        finally {
            lock.unlock();
        }
    }

    public static boolean checkFilterAlter(FilterForm filterForm, ImportZoneData importZoneData, List<BatchOperation> frontOperationList) {
        logger.info((Object)("import filterbaseinfo  failed, the error filterAlert is : " + filterForm.getFilterAlert()));
        if (ImportZoneConstant.POLICY_FILTER_ACTION_NUM5.equals(filterForm.getFilterAction()) && !CheckImportXml.isRange120000(String.valueOf(filterForm.getFilterAlert()))) {
            ImportZoneUtil.recordErrorMessg(importZoneData.getZoneString() + importZoneData.getFilterString() + filterForm.getFilterName() + SEPARATOR + filterForm.getFilterAlert(), 572046L, frontOperationList);
            return false;
        }
        if (ImportZoneConstant.POLICY_FILTER_ACTION_NUM7.equals(filterForm.getFilterAction()) && !CheckImportXml.isRange120000(String.valueOf(filterForm.getFilterAlert()))) {
            ImportZoneUtil.recordErrorMessg(importZoneData.getZoneString() + importZoneData.getFilterString() + filterForm.getFilterName() + SEPARATOR + filterForm.getFilterAlert(), 572047L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean isTooMuchForFilter(List<HttpFilterForm> list, String filterKey) {
        int count = 0;
        for (HttpFilterForm tmp : list) {
            if (!tmp.getFilterKey().equals(filterKey)) continue;
            ++count;
        }
        return count <= FilterUtil.getNumber(filterKey);
    }

    public static boolean isNumber(String str) {
        String regex = "^[0-9]*$";
        return !AticUtil.isNull((String)str) && str.matches(regex);
    }

    private static boolean isRangeOnly1(String str) {
        String regex = "^[1]$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    public static boolean isRange1(String str) {
        String regex = "^[0-1]$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    public static boolean isRangeZero5(String str) {
        String regex = "^[0-5]$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    public static boolean isRange10(String str) {
        String regex = "^[1-9]|10$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    public static boolean isRangeZero15(String str) {
        String regex = "^([0-9]|1[0-5])$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    private static boolean isRange0Or2(String str) {
        String regex = "^[0|2]$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    private static boolean isRange1Or2(String str) {
        String regex = "^[1-2]$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    public static boolean isRange1Or2Or3(String str) {
        String regex = "^[1|2|3]$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    public static boolean isRange20(String str) {
        String regex = "^([1-9]|1[0-9]|20)$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    public static boolean isRangeZero20(String str) {
        String regex = "^([0-9]|1[0-9]|20)$";
        return CheckImportXml.isNumber(str) && str.matches(regex);
    }

    public static boolean isRange60(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) >= ImportZoneConstant.POLICY_ITEM_NUM1 && Integer.parseInt(number) <= ImportZoneConstant.POLICY_ITEM_NUM60;
    }

    public static boolean isRange120(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) >= ImportZoneConstant.POLICY_ITEM_NUM1 && Integer.parseInt(number) <= ImportZoneConstant.POLICY_ITEM_NUM120;
    }

    public static boolean isRange10240(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) >= ImportZoneConstant.POLICY_ITEM_NUM1 && Integer.parseInt(number) <= ImportZoneConstant.POLICY_ITEM_NUM10240 && CheckImportXml.isNumber(number);
    }

    public static boolean isRange120000(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) >= ImportZoneConstant.POLICY_ITEM_NUM1 && Integer.parseInt(number) <= ImportZoneConstant.POLICY_ITEM_NUM120000;
    }

    public static boolean isRange2000000(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) >= ImportZoneConstant.POLICY_ITEM_NUM1 && Integer.parseInt(number) <= ImportZoneConstant.POLICY_ITEM_NUM2000000;
    }

    public static boolean isRange10000000(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) >= ImportZoneConstant.POLICY_ITEM_NUM1 && Integer.parseInt(number) <= ImportZoneConstant.POLICY_ITEM_NUM10000000;
    }

    public static boolean isRange80000000(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) >= ImportZoneConstant.POLICY_ITEM_NUM1 && Integer.parseInt(number) <= ImportZoneConstant.POLICY_ITEM_NUM80000000;
    }

    private static boolean isRange400000(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) >= ImportZoneConstant.POLICY_ITEM_NUM1 && Integer.parseInt(number) <= ImportZoneConstant.POLICY_ITEM_NUM400000;
    }

    private static boolean isInRange(Integer sample) {
        if (null == sample) {
            return false;
        }
        HashMap<Integer, Integer> samples = new HashMap<Integer, Integer>();
        samples.put(0, 1);
        samples.put(1, 1);
        samples.put(2, 1);
        samples.put(3, 1);
        samples.put(4, 1);
        samples.put(5, 1);
        samples.put(6, 1);
        samples.put(7, 1);
        samples.put(8, 1);
        samples.put(9, 1);
        samples.put(10, 1);
        samples.put(11, 1);
        samples.put(12, 1);
        samples.put(13, 1);
        samples.put(14, 1);
        samples.put(15, 1);
        return null != samples.get(sample) && (Integer)samples.get(sample) == 1;
    }

    private static boolean compareRange(int num1, int num2) {
        return num1 < num2;
    }

    public static boolean checkDefenseMode(ZonePolicyApplyForm zoPolicyApplyForm, List<BatchOperation> frontOperationList, String zoneString) {
        String zoneNameString = zoPolicyApplyForm.getZoneInfoForm().getZoneDesc();
        if (null != zoPolicyApplyForm.getDivertMode()) {
            if (!CheckImportXml.isRange1(String.valueOf(zoPolicyApplyForm.getDivertMode()))) {
                logger.info((Object)("import ZonePolicyApplyForm  failed, the error traffic-diversion-mode is : " + zoPolicyApplyForm.getDivertMode()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 733011L, frontOperationList);
                return false;
            }
        } else {
            zoPolicyApplyForm.setDivertMode(0);
        }
        if (null != zoPolicyApplyForm.getDefendMode()) {
            if (!CheckImportXml.isRange1(String.valueOf(zoPolicyApplyForm.getDefendMode()))) {
                logger.info((Object)("import ZonePolicyApplyForm  failed, the error defense-mode is : " + zoPolicyApplyForm.getDefendMode()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 733012L, frontOperationList);
                return false;
            }
        } else {
            zoPolicyApplyForm.setDefendMode(0);
        }
        if (CheckImportXml.isRangeOnly1(String.valueOf(zoPolicyApplyForm.getDivertMode())) && CheckImportXml.isRangeOnly1(String.valueOf(zoPolicyApplyForm.getDefendMode()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error defense-mode traffic-diversion-mode is : " + zoPolicyApplyForm.getDefendMode() + "," + zoPolicyApplyForm.getDivertMode()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732072L, frontOperationList);
            return false;
        }
        if (null != zoPolicyApplyForm.getBlackholeMode()) {
            if (!CheckImportXml.isRange1Or2(String.valueOf(zoPolicyApplyForm.getBlackholeMode()))) {
                logger.info((Object)("import ZonePolicyApplyForm  failed, the error blackhole mode is : " + zoPolicyApplyForm.getBlackholeMode()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 733021L, frontOperationList);
                return false;
            }
        } else {
            zoPolicyApplyForm.setBlackholeMode(1);
        }
        if (null != zoPolicyApplyForm.getBlackholeNotifyEnable()) {
            if (!CheckImportXml.isRange1Or2(String.valueOf(zoPolicyApplyForm.getBlackholeNotifyEnable()))) {
                logger.info((Object)("import ZonePolicyApplyForm  failed, the error blackhole-notify-enable is : " + zoPolicyApplyForm.getBlackholeNotifyEnable()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 733022L, frontOperationList);
                return false;
            }
        } else {
            zoPolicyApplyForm.setBlackholeMode(2);
        }
        if (null != zoPolicyApplyForm.getDynamicBlackMode()) {
            if (!CheckImportXml.isRange0Or2(String.valueOf(zoPolicyApplyForm.getDynamicBlackMode()))) {
                logger.info((Object)("import ZonePolicyApplyForm  failed, the error dynamic-blacklist-mode is : " + zoPolicyApplyForm.getDynamicBlackMode()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 733013L, frontOperationList);
                return false;
            }
        } else {
            zoPolicyApplyForm.setDynamicBlackMode(0);
        }
        if (null != zoPolicyApplyForm.getZoneLimitEnable() && zoPolicyApplyForm.getZoneLimitEnable().booleanValue() && !CheckImportXml.isRange2000000(String.valueOf(zoPolicyApplyForm.getZoneLimitRate()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error cleaning-bandwidth-threshold is : " + zoPolicyApplyForm.getZoneLimitRate()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732074L, frontOperationList);
            return false;
        }
        if (null != zoPolicyApplyForm.getIpLimitEnable() && zoPolicyApplyForm.getIpLimitEnable().booleanValue() && !CheckImportXml.isRange2000000(String.valueOf(zoPolicyApplyForm.getIpLimit()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error traffic-limiting-for-single-ip-address-threshold is : " + zoPolicyApplyForm.getIpLimit()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732075L, frontOperationList);
            return false;
        }
        if (ImportZoneUtil.isTrue(zoPolicyApplyForm.getIpReputationEnable()) && !CheckImportXml.isRangeZero5(String.valueOf(zoPolicyApplyForm.getIpReputationServiceType()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error ipreputation_service_type is : " + zoPolicyApplyForm.getIpReputationServiceType()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 733042L, frontOperationList);
            return false;
        }
        if (ImportZoneUtil.isTrue(zoPolicyApplyForm.getNewDestSessionLimitEnable()) && !CheckImportXml.isRange400000(String.valueOf(zoPolicyApplyForm.getDestSessionLimit()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error new_dest_session_limit_threshold is : " + zoPolicyApplyForm.getDestSessionLimit()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732086L, frontOperationList);
            return false;
        }
        if (!CheckImportXml.isRange80000000(String.valueOf(zoPolicyApplyForm.getFilterDropThreshold()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error filter_drop_thershold is : " + zoPolicyApplyForm.getFilterDropThreshold()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732077L, frontOperationList);
            return false;
        }
        if (!CheckImportXml.isRange80000000(String.valueOf(zoPolicyApplyForm.getOutBoundFilterDropThreshold()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error outbound_filter_drop_thershold is : " + zoPolicyApplyForm.getOutBoundFilterDropThreshold()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732078L, frontOperationList);
            return false;
        }
        if (null != zoPolicyApplyForm.getOutBoundFilterAction() && !CheckImportXml.isRange1Or2Or3(String.valueOf(zoPolicyApplyForm.getOutBoundFilterAction()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error outbound_flowspec_action is : " + zoPolicyApplyForm.getOutBoundFilterAction()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732079L, frontOperationList);
            return false;
        }
        if (null != zoPolicyApplyForm.getOutBoundFilterAction() && 3 == zoPolicyApplyForm.getOutBoundFilterAction() && !IPUtil.isIpv4((String)zoPolicyApplyForm.getOutBoundNextHop()) && !IPUtil.isIpv6((String)zoPolicyApplyForm.getOutBoundNextHop())) {
            logger.info((Object)"import ZonePolicyApplyForm  failed, the outbound_flowspec_redirect error. ");
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732092L, frontOperationList);
            return false;
        }
        if (null != zoPolicyApplyForm.getOutBoundFilterAction() && 2 == zoPolicyApplyForm.getOutBoundFilterAction() && !CheckImportXml.isRange80000000(String.valueOf(zoPolicyApplyForm.getOutBoundFilterLimit()))) {
            logger.info((Object)("import ZonePolicyApplyForm  failed, the error outbound_flowspec_limit_thershold is : " + zoPolicyApplyForm.getOutBoundFilterLimit()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneNameString, 732091L, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean isProtocolDefault(String protocol) {
        return "DEFAULT".equals(protocol);
    }

    private static boolean validateTcpMaxSpeed(TcpDefendPolicyForm tcpDefendPolicyForm, String protocol, ZoneServiceForm serviceForm) {
        return !(!"DEFAULT".equals(protocol) ? ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("maxSpeed"), String.valueOf(tcpDefendPolicyForm.getMaxSpeed()), serviceForm) : ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpLimitEnable()) && ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpLimitSubEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("maxSpeed"), String.valueOf(tcpDefendPolicyForm.getMaxSpeed()), serviceForm));
    }

    private static boolean checkPolicyItemTCP(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        String protocol = serviceForm.getProtocol();
        boolean protocolDefaultFlag = CheckImportXml.isProtocolDefault(protocol);
        if (protocolDefaultFlag) {
            TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
            if (null != tcpDefendPolicyForm) {
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpBlock()) && !"HTTP".equals(protocol) && !"HTTPS".equals(protocol)) {
                    return true;
                }
                if (!CheckImportXml.validateTcpMaxSpeed(tcpDefendPolicyForm, protocol, serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error tcp-traffic-limiting-threshold is : " + tcpDefendPolicyForm.getMaxSpeed()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731060L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpFragLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("fragMaxSpeed"), String.valueOf(tcpDefendPolicyForm.getFragMaxSpeed()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error tcp-fragment-traffic-limiting-threshold is : " + tcpDefendPolicyForm.getFragMaxSpeed()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731061L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpNewDestSessionLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("tcpNewDestSessionLimit"), String.valueOf(tcpDefendPolicyForm.getTcpNewDestSessionLimit()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error tcp-new-dest-session-limiting-threshold is : " + tcpDefendPolicyForm.getTcpNewDestSessionLimit()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732087L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpAbnormalEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("tcpAbnormalAlertRate"), String.valueOf(tcpDefendPolicyForm.getTcpAbnormalAlertRate()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error tcp-abnormal-defense-threshold is : " + tcpDefendPolicyForm.getTcpAbnormalAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + tcpDefendPolicyForm.getTcpAbnormalAlertRate(), 731062L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynfloodEnable())) {
                    if (null != tcpDefendPolicyForm.getSynfloodMode() && tcpDefendPolicyForm.getSynfloodMode() != 0 && tcpDefendPolicyForm.getSynfloodMode() != 1) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-flood-mode is : " + tcpDefendPolicyForm.getSynfloodMode()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 572048L, frontOperationList);
                        return false;
                    }
                    if (1 == tcpDefendPolicyForm.getDirection() && null != tcpDefendPolicyForm.getSynfloodAlertRate() && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synfloodAlertRate"), String.valueOf(tcpDefendPolicyForm.getSynfloodAlertRate()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-flood-attack-defense-threshold is : " + tcpDefendPolicyForm.getSynfloodAlertRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + tcpDefendPolicyForm.getSynfloodAlertRate(), 731063L, frontOperationList);
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynFirstPacketCheckEnable())) {
                        if (!CheckImportXml.isRangeZero20(String.valueOf(tcpDefendPolicyForm.getFirstPacketCheckLowerLimit()))) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-flood-attack-defense-first-packet-check-interval lowerLimit is : " + tcpDefendPolicyForm.getFirstPacketCheckLowerLimit()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732051L, frontOperationList);
                            return false;
                        }
                        if (!CheckImportXml.isRange20(String.valueOf(tcpDefendPolicyForm.getFirstPacketCheckUpperLimit()))) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-flood-attack-defense-first-packet-check-interval upperLimit is : " + tcpDefendPolicyForm.getFirstPacketCheckUpperLimit()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732051L, frontOperationList);
                            return false;
                        }
                        if (!CheckImportXml.compareRange(tcpDefendPolicyForm.getFirstPacketCheckLowerLimit(), tcpDefendPolicyForm.getFirstPacketCheckUpperLimit())) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-flood-attack-defense-first-packet-check-interval lowerLimit is : " + tcpDefendPolicyForm.getFirstPacketCheckLowerLimit() + ", upperLimit is :" + tcpDefendPolicyForm.getFirstPacketCheckUpperLimit()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732051L, frontOperationList);
                            return false;
                        }
                    }
                    if (2 == tcpDefendPolicyForm.getDirection()) {
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synfloodAlertRate"), String.valueOf(tcpDefendPolicyForm.getSynfloodAlertRate()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-flood-attack-defense-threshold is : " + tcpDefendPolicyForm.getTcpAbnormalAlertRate()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + tcpDefendPolicyForm.getTcpAbnormalAlertRate(), 731063L, frontOperationList);
                            return false;
                        }
                        if (!CheckImportXml.isRangeZero20(String.valueOf(tcpDefendPolicyForm.getFirstPacketCheckLowerLimit()))) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error outbound syn-interval lowerLimit is : " + tcpDefendPolicyForm.getFirstPacketCheckLowerLimit()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732093L, frontOperationList);
                            return false;
                        }
                        if (!CheckImportXml.isRange20(String.valueOf(tcpDefendPolicyForm.getFirstPacketCheckUpperLimit()))) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error outbound syn-interval upperLimit is : " + tcpDefendPolicyForm.getFirstPacketCheckUpperLimit()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732093L, frontOperationList);
                            return false;
                        }
                        if (!CheckImportXml.compareRange(tcpDefendPolicyForm.getFirstPacketCheckLowerLimit(), tcpDefendPolicyForm.getFirstPacketCheckUpperLimit())) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error outbound syn-interval lowerLimit is : " + tcpDefendPolicyForm.getFirstPacketCheckLowerLimit() + ", upperLimit is :" + tcpDefendPolicyForm.getFirstPacketCheckUpperLimit()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732094L, frontOperationList);
                            return false;
                        }
                    }
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getAckFloodEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("ackFloodAlertRate"), String.valueOf(tcpDefendPolicyForm.getAckFloodAlertRate()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error ack-flood-attack-defense-threshold is : " + tcpDefendPolicyForm.getAckFloodAlertRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731064L, frontOperationList);
                        return false;
                    }
                    tcpDefendPolicyForm.setAckSessionCheckEnable(true);
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpFragEnable())) {
                    String checkKey = ImportZoneConstant.TCP_POLICY_MAP.get("tcpFragAlertRate");
                    if (2 == tcpDefendPolicyForm.getDirection()) {
                        checkKey = ImportZoneConstant.TCP_POLICY_MAP.get("tcpFragAlertRateOutbound");
                    }
                    if (!ImportZoneUtil.validatePolicyItem(checkKey, String.valueOf(tcpDefendPolicyForm.getTcpFragAlertRate()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error tcp-fragment-attack-defense-threshold is : " + tcpDefendPolicyForm.getTcpFragAlertRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + tcpDefendPolicyForm.getTcpFragAlertRate(), 731065L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getFinRstFloodEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("finRstFloodAlertRate"), String.valueOf(tcpDefendPolicyForm.getFinRstFloodAlertRate()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error fin-flood-attack-defense-threshold is : " + tcpDefendPolicyForm.getFinRstFloodAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + tcpDefendPolicyForm.getFinRstFloodAlertRate(), 731066L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpEnable())) {
                    if (!CheckImportXml.isRangeZero20(String.valueOf(tcpDefendPolicyForm.getTcpLowerLimit()))) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error tcp-first-packet-check-interval lowerLimit is : " + tcpDefendPolicyForm.getTcpLowerLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732095L, frontOperationList);
                        return false;
                    }
                    if (!CheckImportXml.isRange20(String.valueOf(tcpDefendPolicyForm.getTcpUpperLimit()))) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error  tcp-first-packet-check-interval upperLimit is : " + tcpDefendPolicyForm.getTcpUpperLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732095L, frontOperationList);
                        return false;
                    }
                    if (!CheckImportXml.compareRange(tcpDefendPolicyForm.getTcpLowerLimit(), tcpDefendPolicyForm.getTcpUpperLimit())) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error tcp-first-packet-check-interval lowerLimit is : " + tcpDefendPolicyForm.getTcpLowerLimit() + ", upperLimit is :" + tcpDefendPolicyForm.getTcpUpperLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732096L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpratioEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("tcpratioActionLimit"), String.valueOf(tcpDefendPolicyForm.getTcpratioLimitRate()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-tcp-ratio-anomaly-limiting-threshold is : " + tcpDefendPolicyForm.getTcpratioLimitRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731067L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynratioEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synratioLimitRate"), String.valueOf(tcpDefendPolicyForm.getSynratioLimitRate()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-tcp-ratio-anomaly-limiting-threshold is : " + tcpDefendPolicyForm.getSynratioLimitRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731067L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synratioLimitPackets"), String.valueOf(tcpDefendPolicyForm.getSynratioLimitPackets()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-ratio-Limit-packets is : " + tcpDefendPolicyForm.getSynratioLimitPackets()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733026L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synratioLimitDurationRange"), String.valueOf(tcpDefendPolicyForm.getSynratioDuration()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-tcp-ratio-anomaly-limiting-threshold is : " + tcpDefendPolicyForm.getSynratioDuration()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731067L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synMaxPacketsRange"), String.valueOf(tcpDefendPolicyForm.getSynMaxPackets()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-tcp-ratio-anomaly-limiting-threshold is : " + tcpDefendPolicyForm.getSynMaxPackets()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731067L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synMaxPacketsDurationRange"), String.valueOf(tcpDefendPolicyForm.getSynMaxPacketsDuration()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-tcp-ratio-anomaly-limiting-threshold is : " + tcpDefendPolicyForm.getSynMaxPacketsDuration()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731067L, frontOperationList);
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynBlackListEnable())) {
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synExceptionTimes"), String.valueOf(tcpDefendPolicyForm.getSynExceptionTimes()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-exception-times is : " + tcpDefendPolicyForm.getSynExceptionTimes()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733027L, frontOperationList);
                            return false;
                        }
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synTotalCheckTimes"), String.valueOf(tcpDefendPolicyForm.getSynTotalCheckTimes()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-total-check-times is : " + tcpDefendPolicyForm.getSynTotalCheckTimes()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733028L, frontOperationList);
                            return false;
                        }
                    }
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynAckFloodEnable()) && ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynAckIllegalSessionEnable())) {
                    if (!ImportZoneUtil.synAckFloodIllegalSessionCheck(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                        return false;
                    }
                    if (!ImportZoneUtil.synAckFloodIllegalConnNum(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                        return false;
                    }
                }
                if (!ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpConnEnable())) {
                    return true;
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpNewSrctipEnable())) {
                    if (!ImportZoneUtil.validateDestinationConNumAndRate(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("tcpNewSrctipRate"), String.valueOf(tcpDefendPolicyForm.getTcpNewSrctipRate()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error new-connection-rate-check-by-source-ip-address-threshold is : " + tcpDefendPolicyForm.getTcpNewSrctipRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731068L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("tcpNewSrctipInterval"), String.valueOf(tcpDefendPolicyForm.getTcpNewSrctipInterval()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error new-connection-rate-check-by-source-ip-address-check-cycle is : " + tcpDefendPolicyForm.getTcpNewSrctipInterval()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731069L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpSrctipEnable())) {
                    if (!ImportZoneUtil.validateDestinationConNumAndRate(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("tcpSrctipNum"), String.valueOf(tcpDefendPolicyForm.getTcpSrctipNum()), serviceForm)) {
                        logger.info((Object)("Source IP address connection number threshold error.The error tcpSrctipNum is  " + tcpDefendPolicyForm.getTcpSrctipNum()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 572049L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getIllegalSessionEnable())) {
                    if (!ImportZoneUtil.validateDestinationConNumAndRate(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getIllegalMinConnNumEnable())) {
                        if (!ImportZoneUtil.validateAbnormalConAndCyle(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                            return false;
                        }
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("illegalConnNum"), String.valueOf(tcpDefendPolicyForm.getIllegalConnNum()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error null-connection-check-minimum-packets-per-connection is : " + tcpDefendPolicyForm.getIllegalConnNum()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731072L, frontOperationList);
                            return false;
                        }
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("illegalConnNumInterval"), String.valueOf(tcpDefendPolicyForm.getIllegalConnNumInterval()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error null-connection-check-check-cycle is : " + tcpDefendPolicyForm.getIllegalConnNumInterval()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731073L, frontOperationList);
                            return false;
                        }
                    }
                    if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSackCheckEnable())) {
                        if (!ImportZoneUtil.validateAbnormalConAndCyle(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                            return false;
                        }
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("sackCheckMaxNumber"), String.valueOf(tcpDefendPolicyForm.getSackCheckMaxNumber()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error retransmission-session-check-retransmission-packet-number-threshold : " + tcpDefendPolicyForm.getSackCheckMaxNumber()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731076L, frontOperationList);
                            return false;
                        }
                    }
                    if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getWindowSizeCheckEnable())) {
                        if (!ImportZoneUtil.validateAbnormalConAndCyle(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                            return false;
                        }
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("windowSize"), String.valueOf(tcpDefendPolicyForm.getWindowSize()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error sockstress-tcp-window-size-threshold is : " + tcpDefendPolicyForm.getWindowSize()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731077L, frontOperationList);
                            return false;
                        }
                    }
                    if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSessionCheckEnable())) {
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("sessionConnRate"), String.valueOf(tcpDefendPolicyForm.getSessionConnRate()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error session-conn-rate is : " + tcpDefendPolicyForm.getSessionConnRate()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733020L, frontOperationList);
                            return false;
                        }
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("sessionCheckDuration"), String.valueOf(tcpDefendPolicyForm.getSessionCheckDuration()), serviceForm)) {
                            logger.info((Object)("import tcpDefendPolicyForm  failed, the error session-check-duration is : " + tcpDefendPolicyForm.getSessionCheckDuration()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733021L, frontOperationList);
                            return false;
                        }
                        if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getAckCheckEnable())) {
                            if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("ackMinPacketsNum"), String.valueOf(tcpDefendPolicyForm.getAckMinPacketsNum()), serviceForm)) {
                                logger.info((Object)("import tcpDefendPolicyForm  failed, the error ack-min-packets-num is : " + tcpDefendPolicyForm.getAckMinPacketsNum()));
                                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733023L, frontOperationList);
                                return false;
                            }
                            if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("bigPacketLength"), String.valueOf(tcpDefendPolicyForm.getBigPacketLength()), serviceForm)) {
                                logger.info((Object)("import tcpDefendPolicyForm  failed, the error big-packet-length is : " + tcpDefendPolicyForm.getBigPacketLength()));
                                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733023L, frontOperationList);
                                return false;
                            }
                            if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("bigPacketRatio"), String.valueOf(tcpDefendPolicyForm.getBigPacketRatio()), serviceForm)) {
                                logger.info((Object)("import tcpDefendPolicyForm  failed, the error big-packet-ratio is : " + tcpDefendPolicyForm.getBigPacketRatio()));
                                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733024L, frontOperationList);
                                return false;
                            }
                            if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynCheckEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synPacketsNum"), String.valueOf(tcpDefendPolicyForm.getSynPacketsNum()), serviceForm)) {
                                logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-packets-num is : " + tcpDefendPolicyForm.getSynPacketsNum()));
                                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733025L, frontOperationList);
                                return false;
                            }
                        }
                    }
                }
            }
        } else if ("TCP".equals(protocol) && null != serviceForm.getPortType()) {
            TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
            if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSourceLimitEnable())) {
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSourceLimitBandwidthEnable())) {
                    if (!ImportZoneUtil.validateSourceLimitTimesAndInterval(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("sourceLimitBandwidthRate"), String.valueOf(tcpDefendPolicyForm.getSourceLimitBandwidthRate()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-band-width-limiting-threshold is : " + tcpDefendPolicyForm.getSourceLimitBandwidthRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733032L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSourceLimitPacketsEnable())) {
                    if (!ImportZoneUtil.validateSourceLimitTimesAndInterval(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("sourceLimitPacketsRate"), String.valueOf(tcpDefendPolicyForm.getSourceLimitPacketsRate()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, The error source-ip-limiting-packet-threshold is : " + tcpDefendPolicyForm.getSourceLimitPacketsRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733033L, frontOperationList);
                        return false;
                    }
                }
            }
            if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynratioEnable())) {
                if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("synratioLimit"), String.valueOf(tcpDefendPolicyForm.getSynratioLimitRate()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-tcp-ratio-anomaly-limiting-threshold is : " + tcpDefendPolicyForm.getSynratioLimitRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733038L, frontOperationList);
                    return false;
                }
                if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("synratioLimitPackets"), String.valueOf(tcpDefendPolicyForm.getSynratioLimitPackets()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-ratio-Limit-packets is : " + tcpDefendPolicyForm.getSynratioLimitPackets()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733026L, frontOperationList);
                    return false;
                }
                if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("synratioLimitDurationRange"), String.valueOf(tcpDefendPolicyForm.getSynratioDuration()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-syn-ratio-anomaly-limiting-cycle is : " + tcpDefendPolicyForm.getSynratioDuration()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733039L, frontOperationList);
                    return false;
                }
                if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("synMaxPackets"), String.valueOf(tcpDefendPolicyForm.getSynMaxPackets()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-syn-ratio-anomaly-limiting-packets-threshold is : " + tcpDefendPolicyForm.getSynMaxPackets()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733040L, frontOperationList);
                    return false;
                }
                if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("synMaxPacketsDuration"), String.valueOf(tcpDefendPolicyForm.getSynMaxPacketsDuration()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-syn-ratio-anomaly-limiting-packets-cycle is : " + tcpDefendPolicyForm.getSynMaxPacketsDuration()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733041L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getSynBlackListEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("synExceptionTimes"), String.valueOf(tcpDefendPolicyForm.getSynExceptionTimes()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-exception-times is : " + tcpDefendPolicyForm.getSynExceptionTimes()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733027L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("synTotalCheckTimes"), String.valueOf(tcpDefendPolicyForm.getSynTotalCheckTimes()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error syn-total-check-times is : " + tcpDefendPolicyForm.getSynTotalCheckTimes()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733028L, frontOperationList);
                        return false;
                    }
                }
            }
            if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpConnEnable())) {
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpNewSrctipEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("tcpNewSrctipRate"), String.valueOf(tcpDefendPolicyForm.getTcpNewSrctipRate()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error new-connection-rate-check-by-source-ip-address-threshold is : " + tcpDefendPolicyForm.getTcpNewSrctipRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731068L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("tcpNewSrctipInterval"), String.valueOf(tcpDefendPolicyForm.getTcpNewSrctipInterval()), serviceForm)) {
                        logger.info((Object)("import tcpDefendPolicyForm  failed, the error new-connection-rate-check-by-source-ip-address-check-cycle is : " + tcpDefendPolicyForm.getTcpNewSrctipInterval()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731069L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(tcpDefendPolicyForm.getTcpSrctipEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("tcpSrctipNum"), String.valueOf(tcpDefendPolicyForm.getTcpSrctipNum()), serviceForm)) {
                    logger.info((Object)("import tcpDefendPolicyForm  failed, the error connection-number-check-for-source-ip-address-threshold is : " + tcpDefendPolicyForm.getTcpSrctipNum()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 572049L, frontOperationList);
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkPolicyItemUDP(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        UdpDefendPolicyForm udpDefendPolicyForm;
        String protocol = serviceForm.getProtocol();
        boolean tag = CheckImportXml.isProtocolDefault(protocol);
        if (!(!tag && !"UDP".equals(protocol) || null == (udpDefendPolicyForm = serviceForm.getUdpDefendPolicyForm()) || null != udpDefendPolicyForm.getUdpBlock() && udpDefendPolicyForm.getUdpBlock().booleanValue())) {
            if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpLimitEnable())) {
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpMaxSpeedEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.UDP_POLICY_MAP.get("udpMaxSpeed"), String.valueOf(udpDefendPolicyForm.getUdpMaxSpeed()), serviceForm)) {
                    logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-traffic-limiting-threshold is : " + udpDefendPolicyForm.getUdpMaxSpeed()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731078L, frontOperationList);
                    return false;
                }
                if ("UDP".equals(protocol) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.UDP_POLICY_MAP.get("udpMaxSpeed"), String.valueOf(udpDefendPolicyForm.getUdpMaxSpeed()), serviceForm)) {
                    logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-traffic-limiting-threshold is : " + udpDefendPolicyForm.getUdpMaxSpeed()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731078L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpFragMaxSpeedEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.UDP_POLICY_MAP.get("udpFragMaxSpeed"), String.valueOf(udpDefendPolicyForm.getUdpFragMaxSpeed()), serviceForm)) {
                    logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-traffic-limiting-threshold is : " + udpDefendPolicyForm.getUdpFragMaxSpeed()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731079L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpNewDestSessionLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.UDP_POLICY_MAP.get("udpNewDestSessionLimit"), String.valueOf(udpDefendPolicyForm.getUdpNewDestSessionLimit()), serviceForm)) {
                    logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-new-dest-session-limiting-threshold is : " + udpDefendPolicyForm.getUdpNewDestSessionLimit()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732088L, frontOperationList);
                    return false;
                }
            }
            if (2 == udpDefendPolicyForm.getDirection()) {
                String checkKey;
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpMaxSpeedEnable()) && !ImportZoneUtil.validatePolicyItem(checkKey = ImportZoneConstant.UDP_POLICY_MAP.get("udpMaxSpeedOutbound"), String.valueOf(udpDefendPolicyForm.getUdpMaxSpeed()), serviceForm)) {
                    logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-traffic-limiting-threshold is : " + udpDefendPolicyForm.getUdpMaxSpeed()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731078L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpFragMaxSpeedEnable()) && !ImportZoneUtil.validatePolicyItem(checkKey = ImportZoneConstant.UDP_POLICY_MAP.get("udpFragMaxSpeedOutbound"), String.valueOf(udpDefendPolicyForm.getUdpFragMaxSpeed()), serviceForm)) {
                    logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-traffic-limiting-threshold is : " + udpDefendPolicyForm.getUdpFragMaxSpeed()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731079L, frontOperationList);
                    return false;
                }
            }
            if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpDefendEnable())) {
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpAbnormalEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.UDP_POLICY_MAP.get("udpAbnormalAlertRate"), String.valueOf(udpDefendPolicyForm.getUdpAbnormalAlertRate()), serviceForm)) {
                    logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-abnormal-defense-threshold is : " + udpDefendPolicyForm.getUdpAbnormalAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + udpDefendPolicyForm.getUdpAbnormalAlertRate(), 733023L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getAlertSpeedEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.UDP_POLICY_MAP.get("alertSpeed"), String.valueOf(udpDefendPolicyForm.getAlertSpeed()), serviceForm)) {
                        logger.info((Object)("UDP fingerprint defense bandwidth threshold beyond the range. (1-10240) The error bandwidth is  " + udpDefendPolicyForm.getAlertSpeed()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + udpDefendPolicyForm.getAlertSpeed(), 572050L, frontOperationList);
                        return false;
                    }
                    udpDefendPolicyForm.setUdpContentCheckEnable(true);
                    udpDefendPolicyForm.setUdpFingerLearnEnable(true);
                }
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getFragAlertSpeedEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.UDP_POLICY_MAP.get("fragAlertSpeed"), String.valueOf(udpDefendPolicyForm.getFragAlertSpeed()), serviceForm)) {
                        logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-fragment-attack-defense-threshold is : " + udpDefendPolicyForm.getFragAlertSpeed()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731081L, frontOperationList);
                        return false;
                    }
                    udpDefendPolicyForm.setUdpFragContentCheckEnable(true);
                    udpDefendPolicyForm.setUdpFragFingerLearnEnable(true);
                }
                if (ImportZoneUtil.isTrue(udpDefendPolicyForm.getUdpFirstPacketCheckEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.UDP_POLICY_MAP.get("udpUpperLimit"), String.valueOf(udpDefendPolicyForm.getUdpUpperLimit()), serviceForm)) {
                    logger.info((Object)("import udpDefendPolicyForm  failed, the error udp-first-packet-check-upper-limit is : " + udpDefendPolicyForm.getUdpUpperLimit()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732054L, frontOperationList);
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkPolicyItemICMP(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        IcmpDefendPolicyForm icmpDefendPolicyForm;
        String protocol = serviceForm.getProtocol();
        boolean tag = CheckImportXml.isProtocolDefault(protocol);
        if ((tag || "ICMP".equals(protocol)) && null != (icmpDefendPolicyForm = serviceForm.getIcmpDefendPolicyForm())) {
            String checkKey;
            if (ImportZoneUtil.isTrue(icmpDefendPolicyForm.getIcmpBlockEnable())) {
                return true;
            }
            if (ImportZoneUtil.isTrue(icmpDefendPolicyForm.getIcmpMaxSpeedEnable())) {
                if (ImportZoneUtil.isTrue(icmpDefendPolicyForm.getIcmpLimitSubEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.ICMP_POLICY_MAP.get("icmpMaxSpeed"), String.valueOf(icmpDefendPolicyForm.getIcmpMaxSpeed()), serviceForm)) {
                    logger.info((Object)("import icmpDefendPolicyForm  failed, the error traffic-limiting-threshold is : " + icmpDefendPolicyForm.getIcmpMaxSpeedEnable()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731085L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(icmpDefendPolicyForm.getIcmpNewDestSessionLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.ICMP_POLICY_MAP.get("icmpNewDestSessionLimit"), String.valueOf(icmpDefendPolicyForm.getIcmpNewDestSessionLimit()), serviceForm)) {
                    logger.info((Object)("import icmpDefendPolicyForm  failed, the error icmp-new-dest-session-limiting-threshold is : " + icmpDefendPolicyForm.getIcmpNewDestSessionLimit()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732089L, frontOperationList);
                    return false;
                }
            }
            if (2 == icmpDefendPolicyForm.getDirection() && ImportZoneUtil.isTrue(icmpDefendPolicyForm.getIcmpLimitSubEnable()) && !ImportZoneUtil.validatePolicyItem(checkKey = ImportZoneConstant.ICMP_POLICY_MAP.get("icmpMaxSpeedOutbound"), String.valueOf(icmpDefendPolicyForm.getIcmpMaxSpeed()), serviceForm)) {
                logger.info((Object)("import icmpDefendPolicyForm  failed, the error traffic-limiting-threshold is : " + icmpDefendPolicyForm.getIcmpMaxSpeedEnable()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731085L, frontOperationList);
                return false;
            }
        }
        return true;
    }

    private static boolean checkPolicyItemOther(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        OtherDefendPolicyForm otherDefendPolicyForm;
        String protocol = serviceForm.getProtocol();
        boolean tag = CheckImportXml.isProtocolDefault(protocol);
        if ((tag || "Other".equals(protocol)) && null != (otherDefendPolicyForm = serviceForm.getOtherDefendPolicyForm()) && !ImportZoneUtil.isTrue(otherDefendPolicyForm.getOtherBlock())) {
            if (ImportZoneUtil.isTrue(otherDefendPolicyForm.getOtherDefendEnable())) {
                if (ImportZoneUtil.isTrue(otherDefendPolicyForm.getOtherLimitSubEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.OTHER_POLICY_MAP.get("otherAlertRate"), String.valueOf(otherDefendPolicyForm.getOtherAlertRate()), serviceForm)) {
                    logger.info((Object)("import otherDefendPolicyForm  failed, the error traffic-limiting-threshold is : " + otherDefendPolicyForm.getOtherAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731087L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(otherDefendPolicyForm.getOtherNewDestSessionLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.OTHER_POLICY_MAP.get("otherNewDestSessionLimit"), String.valueOf(otherDefendPolicyForm.getOtherNewDestSessionLimit()), serviceForm)) {
                    logger.info((Object)("import otherDefendPolicyForm  failed, the error other-new-dest-session-limiting-threshold is : " + otherDefendPolicyForm.getOtherNewDestSessionLimit()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732090L, frontOperationList);
                    return false;
                }
            }
            if (ImportZoneUtil.isTrue(otherDefendPolicyForm.getOtherDefenseEnable())) {
                if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.OTHER_POLICY_MAP.get("fingerAlert"), String.valueOf(otherDefendPolicyForm.getFingerAlert()), serviceForm)) {
                    logger.info((Object)("import otherDefendPolicyForm  failed, the error defense-threshold is : " + otherDefendPolicyForm.getOtherAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731088L, frontOperationList);
                    return false;
                }
                otherDefendPolicyForm.setFingerLearnEnable(true);
                otherDefendPolicyForm.setOtherLearnMode(0);
            }
        }
        return true;
    }

    private static boolean checkPolicyItemSIP(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        SipDefendPolicyForm sipDefendPolicyForm;
        String protocol = serviceForm.getProtocol();
        boolean tag = CheckImportXml.isProtocolDefault(protocol);
        if ((tag || "SIP".equals(protocol)) && null != (sipDefendPolicyForm = serviceForm.getSipDefendPolicyForm()) && !ImportZoneUtil.isTrue(sipDefendPolicyForm.getSipBlock())) {
            if (ImportZoneUtil.isTrue(sipDefendPolicyForm.getLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.SIP_POLICY_MAP.get("limitRate"), String.valueOf(sipDefendPolicyForm.getLimitRate()), serviceForm)) {
                logger.info((Object)("import otherDefendPolicyForm  failed, the error defense-threshold is : " + sipDefendPolicyForm.getLimitRate()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733018L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(sipDefendPolicyForm.getSipDefendEnable())) {
                if (ImportZoneUtil.isTrue(sipDefendPolicyForm.getSipSrcDetectEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.SIP_POLICY_MAP.get("sipAlertRate"), String.valueOf(sipDefendPolicyForm.getSipAlertRate()), serviceForm)) {
                    logger.info((Object)("import sipDefendPolicyForm  failed, the error detection-threshold is : " + sipDefendPolicyForm.getSipAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731090L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(sipDefendPolicyForm.getSipSrcOtherLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.SIP_POLICY_MAP.get("sipSrcOtherAlertRate"), String.valueOf(sipDefendPolicyForm.getSipSrcOtherAlertRate()), serviceForm)) {
                    logger.info((Object)("import sipDefendPolicyForm  failed, the error rate-limiting-of-source-ip-address-threshold is : " + sipDefendPolicyForm.getSipSrcOtherAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731091L, frontOperationList);
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkPolicyItemDNSAndUDPDNS(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        DnsDefendPolicyForm dnsDefendPolicyForm;
        String protocol = serviceForm.getProtocol();
        boolean tag = CheckImportXml.isProtocolDefault(protocol);
        if ((tag || "DNS".equals(protocol)) && null != (dnsDefendPolicyForm = serviceForm.getDnsDefendPolicyForm()) && !ImportZoneUtil.isTrue(dnsDefendPolicyForm.getDnsBlock())) {
            if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getLimitEnable())) {
                if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getSrcipReqLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("srcipReqAlertRate"), String.valueOf(dnsDefendPolicyForm.getSrcipReqAlertRate()), serviceForm)) {
                    logger.info((Object)("import dnsDefendPolicyForm  failed, the error rate-limiting-on-request-packets-of-source-ip-address-threshold is : " + dnsDefendPolicyForm.getSrcipReqAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731093L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getSrcipRespLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("srcipRespAlertRate"), String.valueOf(dnsDefendPolicyForm.getSrcipRespAlertRate()), serviceForm)) {
                    logger.info((Object)("import dnsDefendPolicyForm  failed, the error rate-limiting-on-request-packets-of-source-ip-address-threshold is : " + dnsDefendPolicyForm.getSrcipRespAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731094L, frontOperationList);
                    return false;
                }
            }
            if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getDnsDefendEnable())) {
                boolean tag2;
                boolean tag1 = null != dnsDefendPolicyForm.getDnsAuthServerEnable() && dnsDefendPolicyForm.getDnsAuthServerEnable() != false;
                boolean bl = tag2 = null != dnsDefendPolicyForm.getDnsCacheServerEnable() && dnsDefendPolicyForm.getDnsCacheServerEnable() != false;
                if (tag1 && tag2) {
                    logger.info((Object)("import dnsDefendPolicyForm  failed, the error rate-dns-request-flood-attack-defense-threshold is : " + dnsDefendPolicyForm.getAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731102L, frontOperationList);
                    return false;
                }
                if (tag1) {
                    if (null != dnsDefendPolicyForm.getDefendMode() && dnsDefendPolicyForm.getDefendMode() != 2 && dnsDefendPolicyForm.getDefendMode() != 3) {
                        logger.info((Object)("DNS Request Flood DNS, a unique configuration item, is beyond the scope. (2:CNAME, 3: passive) The error defendMode is  " + dnsDefendPolicyForm.getDefendMode()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 572053L, frontOperationList);
                        return false;
                    }
                    if (!(null == dnsDefendPolicyForm.getDefendMode() || dnsDefendPolicyForm.getDefendMode() != 2 && dnsDefendPolicyForm.getDefendMode() != 3 || ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("alertRate"), String.valueOf(dnsDefendPolicyForm.getAlertRate()), serviceForm))) {
                        logger.info((Object)("import dnsDefendPolicyForm  failed, the error rate-dns-request-flood-attack-defense-threshold is : " + dnsDefendPolicyForm.getAlertRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731095L, frontOperationList);
                        return false;
                    }
                }
                if (tag2 && ImportZoneUtil.isTrue(dnsDefendPolicyForm.getDnsFloodEnable())) {
                    if (null != dnsDefendPolicyForm.getDefendMode() && dnsDefendPolicyForm.getDefendMode() != 0 && dnsDefendPolicyForm.getDefendMode() != 3) {
                        logger.info((Object)("DNS cache server specific configuration item Request Flood DNS defense mode beyond the range. (0:TCP certification, 3: passive) The error defendMode is  " + dnsDefendPolicyForm.getDefendMode()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 572052L, frontOperationList);
                        return false;
                    }
                    if (!(null == dnsDefendPolicyForm.getDefendMode() || dnsDefendPolicyForm.getDefendMode() != 0 && dnsDefendPolicyForm.getDefendMode() != 3 || ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("alertRate"), String.valueOf(dnsDefendPolicyForm.getAlertRate()), serviceForm))) {
                        logger.info((Object)("import dnsDefendPolicyForm  failed, the error rate-dns-request-flood-attack-defense-threshold is : " + dnsDefendPolicyForm.getAlertRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731095L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getReplyFloodEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("replyFloodAlertRate"), String.valueOf(dnsDefendPolicyForm.getReplyFloodAlertRate()), serviceForm)) {
                    logger.info((Object)("import dnsDefendPolicyForm  failed, the error authorization-server-dns-request-flood-attack-defense-threshold is : " + dnsDefendPolicyForm.getReplyFloodAlertRate()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731096L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getNoSuchNameCheckEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("noSuchNameCheckAlertRatio"), String.valueOf(dnsDefendPolicyForm.getNoSuchNameCheckAlertRatio()), serviceForm)) {
                    logger.info((Object)("import dnsDefendPolicyForm  failed, the error proportion-taken-by-the-requests-for-nxdomain is : " + dnsDefendPolicyForm.getNoSuchNameCheckAlertRatio()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731097L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getFormatCheckEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("formatCheckRatio"), String.valueOf(dnsDefendPolicyForm.getFormatCheckRatio()), serviceForm)) {
                    logger.info((Object)("import dnsDefendPolicyForm  failed, the error packet-malformed-threshold is : " + dnsDefendPolicyForm.getFormatCheckRatio()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731098L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getDnsRequestMessageLenLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("dnsRequestMessageLen"), String.valueOf(dnsDefendPolicyForm.getDnsRequestMessageLen()), serviceForm)) {
                    logger.info((Object)("import dnsDefendPolicyForm  failed, the error dns-request-packet-length-limiting-threshold is : " + dnsDefendPolicyForm.getDnsRequestMessageLen()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731099L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getDnsReponseMessageLenLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.DNS_POLICY_MAP.get("dnsResponseMessageLen"), String.valueOf(dnsDefendPolicyForm.getDnsResponseMessageLen()), serviceForm)) {
                    logger.info((Object)("import dnsDefendPolicyForm  failed, the error dns-reply-packet-length-limiting-threshold is : " + dnsDefendPolicyForm.getDnsResponseMessageLen()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 731100L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(dnsDefendPolicyForm.getDnsEnable())) {
                    if (!CheckImportXml.isRangeZero20(String.valueOf(dnsDefendPolicyForm.getDnsLowerLimit()))) {
                        logger.info((Object)("import dnsDefendPolicyForm  failed, the error dns-first-packet-check-interval lowerLimit is : " + dnsDefendPolicyForm.getDnsLowerLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732099L, frontOperationList);
                        return false;
                    }
                    if (!CheckImportXml.isRange20(String.valueOf(dnsDefendPolicyForm.getDnsUpperLimit()))) {
                        logger.info((Object)("import dnsDefendPolicyForm  failed, the error dns-first-packet-check-interval upperLimit is : " + dnsDefendPolicyForm.getDnsUpperLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732099L, frontOperationList);
                        return false;
                    }
                    if (!CheckImportXml.compareRange(dnsDefendPolicyForm.getDnsLowerLimit(), dnsDefendPolicyForm.getDnsUpperLimit())) {
                        logger.info((Object)("import dnsDefendPolicyForm  failed, the error dns-first-packet-check-interval lowerLimit is : " + dnsDefendPolicyForm.getDnsLowerLimit() + ", upperLimit is :" + dnsDefendPolicyForm.getDnsUpperLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732100L, frontOperationList);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean checkPolicyItemTopNStudy(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        TopNStudyForm topNStudyForm;
        String protocol = serviceForm.getProtocol();
        boolean tag = CheckImportXml.isProtocolDefault(protocol);
        if ((tag || "Top N Study".equals(serviceForm.getProtocol())) && null != (topNStudyForm = serviceForm.getTopNStudyForm())) {
            if (ImportZoneUtil.isTrue(topNStudyForm.getHttpHostEnable()) && !CheckImportXml.isInRange(topNStudyForm.getHttpHostSimple())) {
                logger.info((Object)("import TopNStudyForm  failed, the error http-host-sampling-ratio is : " + topNStudyForm.getHttpHostSimple()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732000L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(topNStudyForm.getHttpUriEnable()) && !CheckImportXml.isInRange(topNStudyForm.getHttpUriSimple())) {
                logger.info((Object)("import TopNStudyForm  failed, the error http-uri-sampling-ratio is : " + topNStudyForm.getHttpUriSimple()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732001L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(topNStudyForm.getHttpSrcIpEnable()) && !CheckImportXml.isInRange(topNStudyForm.getHttpSrcIpSimple())) {
                logger.info((Object)("import TopNStudyForm  failed, the error top-n-http-source-ip-addresses-sampling-ratio is : " + topNStudyForm.getHttpSrcIpSimple()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732002L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(topNStudyForm.getDnsQueryDomainEnable())) {
                if (!CheckImportXml.isInRange(topNStudyForm.getDnsQueryDomainSimple())) {
                    logger.info((Object)("import TopNStudyForm  failed, the error top-n-requested-domain-names-sampling-ratio is : " + topNStudyForm.getDnsQueryDomainSimple()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732003L, frontOperationList);
                    return false;
                }
                if (ImportZoneUtil.isTrue(topNStudyForm.getTopnCacheEnable())) {
                    if (null == topNStudyForm.getTopnCacheNum()) {
                        logger.info((Object)("import TopNStudyForm  failed, the error top-n-requested-domain-names-sampling-ratio is : " + topNStudyForm.getTopnCacheNum()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732004L, frontOperationList);
                        return false;
                    }
                    int num = topNStudyForm.getTopnCacheNum();
                    if (num < 1 || num > 32) {
                        logger.info((Object)("import TopNStudyForm  failed, the error top-n-requested-domain-names-sampling-ratio is : " + topNStudyForm.getTopnCacheNum()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732004L, frontOperationList);
                        return false;
                    }
                }
            }
            if (ImportZoneUtil.isTrue(topNStudyForm.getDnsQuerySrcIpEnable()) && !CheckImportXml.isInRange(topNStudyForm.getDnsQuerySrcIpSimple())) {
                logger.info((Object)("import TopNStudyForm  failed, the error top-n-dns-request-source-ip-addresses-sampling-ratio is : " + topNStudyForm.getDnsQuerySrcIpSimple()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732005L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(topNStudyForm.getDnsReqSrcIpEnable()) && !CheckImportXml.isInRange(topNStudyForm.getDnsReqSrcIpSimple())) {
                logger.info((Object)("import TopNStudyForm  failed, the error top-n-dns-request-source-ip-addresses-sampling-ratio is : " + topNStudyForm.getDnsReqSrcIpSimple()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732006L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(topNStudyForm.getHttpsEnable()) && !CheckImportXml.isInRange(topNStudyForm.getHttpsSimple())) {
                logger.info((Object)("import TopNStudyForm  failed, the error top-n-https-source-ip-addresses-sampling-ratio is : " + topNStudyForm.getHttpsSimple()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732007L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(topNStudyForm.getTcpNewConnEnable()) && !CheckImportXml.isInRange(topNStudyForm.getTcpNewConnSimple())) {
                logger.info((Object)("import TopNStudyForm  failed, the error top-n-tcp-source-ip-addresses-sampling-ratio is : " + topNStudyForm.getTcpNewConnSimple()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732008L, frontOperationList);
                return false;
            }
        }
        return true;
    }

    private static boolean checkPolicyItemHTTPS(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        HttpsDefendPolicyForm httpsDefendPoliyForm;
        String protocol = serviceForm.getProtocol();
        boolean tag = CheckImportXml.isProtocolDefault(protocol);
        if ((tag || "HTTPS".equals(protocol)) && null != (httpsDefendPoliyForm = serviceForm.getHttpsDefendPolicyForm()) && !ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsBlock())) {
            if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getLimitEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("limitRate"), String.valueOf(httpsDefendPoliyForm.getLimitRate()), serviceForm)) {
                logger.info((Object)("import otherDefendPolicyForm  failed, the error defense-threshold is : " + httpsDefendPoliyForm.getLimitRate()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733019L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsDefendEnable())) {
                HashMap<String, String> zoneInfoMap = new HashMap<String, String>();
                zoneInfoMap.put("zoneName", zoneName);
                zoneInfoMap.put("policyString", policyString);
                zoneInfoMap.put("zoneString", zoneString);
                if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsSrcEnable())) {
                    if (!CheckImportXml.checkHttpsSrc(serviceForm, frontOperationList, zoneInfoMap, httpsDefendPoliyForm)) {
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsHighFreqDetectEnable()) && !CheckImportXml.checkHttpsHighFreq(serviceForm, frontOperationList, zoneInfoMap, httpsDefendPoliyForm)) {
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsFixResEnable()) && !CheckImportXml.checkHttpsFixRes(serviceForm, frontOperationList, zoneInfoMap, httpsDefendPoliyForm)) {
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsLargeResDetectEnable()) && !CheckImportXml.checkHttpsLargeRes(serviceForm, frontOperationList, zoneInfoMap, httpsDefendPoliyForm)) {
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsSslEnable()) && !CheckImportXml.checkHttpsSsl(serviceForm, frontOperationList, zoneInfoMap, httpsDefendPoliyForm)) {
                    return false;
                }
            }
        }
        return !"HTTPS".equals(protocol) || CheckImportXml.checkPolicyItemTCP(serviceForm, frontOperationList, zoneName, policyString, zoneString);
    }

    private static boolean checkHttpsSrc(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, Map<String, String> zoneInfoMap, HttpsDefendPolicyForm httpsDefendPoliyForm) {
        String zoneString = zoneInfoMap.get("zoneString");
        String zoneName = zoneInfoMap.get("zoneName");
        String policyString = zoneInfoMap.get("policyString");
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsAlertRate"), String.valueOf(httpsDefendPoliyForm.getHttpsAlertRate()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error statistics-based-on-destination-ip-address-packet-threshold is" + httpsDefendPoliyForm.getHttpsAlertRate()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732010L, frontOperationList);
            return false;
        }
        if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsSrcStaticEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsSrcStaticRate"), String.valueOf(httpsDefendPoliyForm.getHttpsSrcStaticRate()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error statistics-based-on-source-ip-address-threshold is" + httpsDefendPoliyForm.getHttpsSrcStaticRate()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732015L, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkHttpsLargeRes(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, Map<String, String> zoneInfoMap, HttpsDefendPolicyForm httpsDefendPoliyForm) {
        String zoneString = zoneInfoMap.get("zoneString");
        String zoneName = zoneInfoMap.get("zoneName");
        String policyString = zoneInfoMap.get("policyString");
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsLargeResSize"), String.valueOf(httpsDefendPoliyForm.getHttpsLargeResSize()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-large-res-size is" + httpsDefendPoliyForm.getHttpsLargeResSize()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732106L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsLargeResDetectRatio"), String.valueOf(httpsDefendPoliyForm.getHttpsLargeResDetectRatio()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-large-res-detect-ratio is" + httpsDefendPoliyForm.getHttpsLargeResDetectRatio()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732107L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsLargeResDetectThreshold"), String.valueOf(httpsDefendPoliyForm.getHttpsLargeResDetectThreshold()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-large-res-detect-threshold is" + httpsDefendPoliyForm.getHttpsLargeResDetectThreshold()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732108L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsLargeResDetectInterval"), String.valueOf(httpsDefendPoliyForm.getHttpsLargeResDetectInterval()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-large-res-detect-interval is" + httpsDefendPoliyForm.getHttpsLargeResDetectInterval()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732109L, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkHttpsFixRes(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, Map<String, String> zoneInfoMap, HttpsDefendPolicyForm httpsDefendPoliyForm) {
        String zoneString = zoneInfoMap.get("zoneString");
        String zoneName = zoneInfoMap.get("zoneName");
        String policyString = zoneInfoMap.get("policyString");
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsFixResRatioNumber"), String.valueOf(httpsDefendPoliyForm.getHttpsFixResRatioNumber()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-fix-res-ratio-number is" + httpsDefendPoliyForm.getHttpsFixResRatioNumber()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732103L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsFixResThreshold"), String.valueOf(httpsDefendPoliyForm.getHttpsFixResThreshold()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-fix-res-threshold is" + httpsDefendPoliyForm.getHttpsFixResThreshold()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732104L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsFixResInterval"), String.valueOf(httpsDefendPoliyForm.getHttpsFixResInterval()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-fix-res-interval is" + httpsDefendPoliyForm.getHttpsFixResInterval()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732105L, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkHttpsHighFreq(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, Map<String, String> zoneInfoMap, HttpsDefendPolicyForm httpsDefendPoliyForm) {
        String zoneString = zoneInfoMap.get("zoneString");
        String zoneName = zoneInfoMap.get("zoneName");
        String policyString = zoneInfoMap.get("policyString");
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsHighFreqDetectThreshold"), String.valueOf(httpsDefendPoliyForm.getHttpsHighFreqDetectThreshold()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-high-freq-detect-threshold is" + httpsDefendPoliyForm.getHttpsHighFreqDetectThreshold()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732101L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsHighFreqDetectInterval"), String.valueOf(httpsDefendPoliyForm.getHttpsHighFreqDetectInterval()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-high-freq-detect-interval is" + httpsDefendPoliyForm.getHttpsHighFreqDetectInterval()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732102L, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkHttpsSsl(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, Map<String, String> zoneInfoMap, HttpsDefendPolicyForm httpsDefendPoliyForm) {
        String zoneString = zoneInfoMap.get("zoneString");
        String zoneName = zoneInfoMap.get("zoneName");
        String policyString = zoneInfoMap.get("policyString");
        if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsDestIpConnNumEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsDestIpConnNum"), String.valueOf(httpsDefendPoliyForm.getHttpsDestIpConnNum()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error https-dest-ip-conn-num is" + httpsDefendPoliyForm.getHttpsDestIpConnNum()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732110L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsIllegalNum"), String.valueOf(httpsDefendPoliyForm.getHttpsIllegalnum()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error ssl-defense-maximum-number-of-abnormal-sessions is" + httpsDefendPoliyForm.getHttpsIllegalnum()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732013L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsIllegalInterval"), String.valueOf(httpsDefendPoliyForm.getHttpsIllegalinterval()), serviceForm)) {
            logger.info((Object)("import HttpsDefendPolicyForm failed, the error ssl-defense-abnormal-session-check-interva is" + httpsDefendPoliyForm.getHttpsIllegalinterval()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732014L, frontOperationList);
            return false;
        }
        if (ImportZoneUtil.isTrue(httpsDefendPoliyForm.getHttpsNegoCheckEnable())) {
            if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsNegoNum"), String.valueOf(httpsDefendPoliyForm.getHttpsNegonum()), serviceForm)) {
                logger.info((Object)("import HttpsDefendPolicyForm failed, the error ssl-defense-maximum-renegotiation-times is" + httpsDefendPoliyForm.getHttpsNegonum()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732011L, frontOperationList);
                return false;
            }
            if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTPS_POLICY_MAP.get("httpsNegoInterval"), String.valueOf(httpsDefendPoliyForm.getHttpsNegointerval()), serviceForm)) {
                logger.info((Object)("import HttpsDefendPolicyForm failed, the error ssl-defense-renegotiation-interval is" + httpsDefendPoliyForm.getHttpsNegointerval()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732012L, frontOperationList);
                return false;
            }
        }
        return true;
    }

    private static boolean checkPolicyItemHTTP(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        HttpDefendPolicyForm httpDefendPoliyForm;
        String protocol = serviceForm.getProtocol();
        boolean tag = CheckImportXml.isProtocolDefault(protocol);
        if ((tag || "HTTP".equals(protocol)) && null != (httpDefendPoliyForm = serviceForm.getHttpDefendPolicyForm()) && !ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpBlock())) {
            if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getLimitEnable()) && !CheckImportXml.isRange10240(String.valueOf(httpDefendPoliyForm.getLimitRate()))) {
                logger.info((Object)("import otherDefendPolicyForm  failed, the error defense-threshold is : " + httpDefendPoliyForm.getLimitRate()));
                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733017L, frontOperationList);
                return false;
            }
            if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpDefendEnable())) {
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpSourceAuthEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpDestQpsAlertRate"), String.valueOf(httpDefendPoliyForm.getHttpDestQpsAlertRate()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error statistics-based-on-destination-ip-address-request-threshold is" + httpDefendPoliyForm.getHttpDestQpsAlertRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732021L, frontOperationList);
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpSrcStaticEnable())) {
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpSrcStaticRate"), String.valueOf(httpDefendPoliyForm.getHttpSrcStaticRate()), serviceForm)) {
                            logger.info((Object)("import HttpDefendPolicyForm failed, the error statistics-based-on-source-ip-address-threshold is" + httpDefendPoliyForm.getHttpSrcStaticRate()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732022L, frontOperationList);
                            return false;
                        }
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpSrcQpsRate"), String.valueOf(httpDefendPoliyForm.getHttpSrcQpsRate()), serviceForm)) {
                            logger.info((Object)("import HttpDefendPolicyForm failed, the error statistics-based-on-source-ip-address-request-threshold is" + httpDefendPoliyForm.getHttpSrcQpsRate()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732023L, frontOperationList);
                            return false;
                        }
                    }
                    if (!CheckImportXml.isNumber(String.valueOf(httpDefendPoliyForm.getDefendMode()))) {
                        logger.info((Object)("HTTP source authentication defense mode beyond the scope. (1: verification code, 2:302 redirection) The error defendmode is " + httpDefendPoliyForm.getDefendMode()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + httpDefendPoliyForm.getDefendMode(), 572054L, frontOperationList);
                        return false;
                    }
                    if (httpDefendPoliyForm.getDefendMode() != 1 && httpDefendPoliyForm.getDefendMode() != 2 && httpDefendPoliyForm.getDefendMode() != 3 && httpDefendPoliyForm.getDefendMode() != 4) {
                        logger.info((Object)("HTTP source authentication defense mode beyond the scope. (1: verification code, 2:302 redirection) The error defendmode is " + httpDefendPoliyForm.getDefendMode()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName() + SEPARATOR + httpDefendPoliyForm.getDefendMode(), 572054L, frontOperationList);
                        return false;
                    }
                    if (CheckImportXml.isNumber(String.valueOf(httpDefendPoliyForm.getDefendMode())) && httpDefendPoliyForm.getDefendMode() == 2 && ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpWebDetectEnable()) && httpDefendPoliyForm.getWebTitle() == null) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-source-authentication-defense-verification-code-caption-settings is" + httpDefendPoliyForm.getWebTitle()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732024L, frontOperationList);
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpProxyEnable()) && ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpProxyHeaderEnable())) {
                        String reg = "^[a-zA-Z0-9\\-_]{1,64}+$";
                        if (!httpDefendPoliyForm.getHttpProxyHeader().matches(reg)) {
                            logger.info((Object)("import HttpDefendPolicyForm failed, the error http-source-authentication-defense-proxy-header is" + httpDefendPoliyForm.getHttpProxyHeader()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734003L, frontOperationList);
                            return false;
                        }
                    }
                    if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getDetectUriEnable())) {
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("maxTimes"), String.valueOf(httpDefendPoliyForm.getMaxTimes()), serviceForm)) {
                            logger.info((Object)("import HttpDefendPolicyForm failed, the error http-source-authentication-defense-termination-maxnum-attempt is" + httpDefendPoliyForm.getMaxTimes()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734001L, frontOperationList);
                            return false;
                        }
                        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("timeout"), String.valueOf(httpDefendPoliyForm.getTimeout()), serviceForm)) {
                            logger.info((Object)("import HttpDefendPolicyForm failed, the error http-source-authentication-defense-termination-attempt-time is" + httpDefendPoliyForm.getTimeout()));
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734002L, frontOperationList);
                            return false;
                        }
                    }
                    if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpAfterAuthSynEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("afterAuthSynRate"), String.valueOf(httpDefendPoliyForm.getAfterAuthSynRate()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-source-authentication-defense-syn-rate-limiting-threshold is" + httpDefendPoliyForm.getAfterAuthSynRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732025L, frontOperationList);
                        return false;
                    }
                    if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpAfterAuthAckEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("afterAuthAckRate"), String.valueOf(httpDefendPoliyForm.getAfterAuthAckRate()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-source-authentication-defense-ack-rate-limiting-enable is" + httpDefendPoliyForm.getAfterAuthAckRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732026L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpFirstPacketEnable())) {
                    if (!CheckImportXml.isRangeZero20(String.valueOf(httpDefendPoliyForm.getHttpLowerLimit()))) {
                        logger.info((Object)("import httpDefendPoliyForm  failed, the error http-interval lowerLimit is : " + httpDefendPoliyForm.getHttpLowerLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733021L, frontOperationList);
                        return false;
                    }
                    if (!CheckImportXml.isRange20(String.valueOf(httpDefendPoliyForm.getHttpUpperLimit()))) {
                        logger.info((Object)("import httpDefendPoliyForm  failed, the error http-interval upperLimit is : " + httpDefendPoliyForm.getHttpUpperLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733021L, frontOperationList);
                        return false;
                    }
                    if (!CheckImportXml.compareRange(httpDefendPoliyForm.getHttpLowerLimit(), httpDefendPoliyForm.getHttpUpperLimit())) {
                        logger.info((Object)("import firstPacketCheckForm  failed, the error syn-interval is : " + httpDefendPoliyForm.getHttpLowerLimit()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 733022L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getFingerLearnEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpDestQpsAlertRate"), String.valueOf(httpDefendPoliyForm.getHttpDestQpsAlertRate()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error statistics-based-on-destination-ip-address-request-threshold is" + httpDefendPoliyForm.getHttpDestQpsAlertRate()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732021L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("learnPeriod"), String.valueOf(httpDefendPoliyForm.getLearnPeriod()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-fingerprint-learning-cycle is" + httpDefendPoliyForm.getLearnPeriod()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732027L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("matchTimes"), String.valueOf(httpDefendPoliyForm.getMatchTimes()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-fingerprint-learning-matching-counts is" + httpDefendPoliyForm.getMatchTimes()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732028L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpSlowAttackEnable())) {
                    if (!ImportZoneUtil.isTrue(httpDefendPoliyForm.getDestIpConnNumEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpSlowConnNum"), String.valueOf(httpDefendPoliyForm.getHttpSlowConnNum()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-slow-attack-defense-concurrent-connection-number is" + httpDefendPoliyForm.getHttpSlowConnNum()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732029L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpSlowContentLength"), String.valueOf(httpDefendPoliyForm.getHttpSlowContentLength()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-slow-attack-defense-total-packet-length is" + httpDefendPoliyForm.getHttpSlowContentLength()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732030L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpSlowCheckPacketNum"), String.valueOf(httpDefendPoliyForm.getHttpSlowCheckPacketNum()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-slow-attack-defense-check-packet-number is" + httpDefendPoliyForm.getHttpSlowCheckPacketNum()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732031L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpSlowPayloadLength"), String.valueOf(httpDefendPoliyForm.getHttpSlowPayloadLength()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-slow-attack-defense-payload-length is" + httpDefendPoliyForm.getHttpSlowPayloadLength()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732032L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpUriEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpDetectNumber"), String.valueOf(httpDefendPoliyForm.getHttpDetectNumber()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error destination-ip-based-uri-behavior-monitoring-detection-threshold is" + httpDefendPoliyForm.getHttpDetectNumber()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732033L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("illegalRatioNumber"), String.valueOf(httpDefendPoliyForm.getIllegalRatioNumber()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error source-ip-based-uri-behavior-monitoring-defense-threshold is" + httpDefendPoliyForm.getIllegalRatioNumber()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732034L, frontOperationList);
                        return false;
                    }
                    if (null != httpDefendPoliyForm.getKeyDetectUriForms() && !httpDefendPoliyForm.getKeyDetectUriForms().isEmpty()) {
                        List<HttpKeyDetectUriForm> httpKeyDetectUriFormList = httpDefendPoliyForm.getKeyDetectUriForms();
                        ArrayList<HttpKeyDetectUriForm> tList = new ArrayList<HttpKeyDetectUriForm>();
                        for (HttpKeyDetectUriForm httpuri : httpKeyDetectUriFormList) {
                            if (null == httpuri.getHttpDefendId() && AticUtil.isNull((String)httpuri.getHttpUri())) {
                                tList.add(httpuri);
                                continue;
                            }
                            if (FilterUtil.isChineseChar(httpuri.getHttpUri())) {
                                logger.info((Object)"import HttpDefendPolicyForm failed");
                                ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732035L, frontOperationList);
                                tList.add(httpuri);
                                continue;
                            }
                            Integer matchMode = httpuri.getMatchMode();
                            if (1 == matchMode || 0 == matchMode) continue;
                            logger.info((Object)"import HttpDefendPolicyForm failed");
                            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 732043L, frontOperationList);
                            tList.add(httpuri);
                        }
                        httpKeyDetectUriFormList.removeAll(tList);
                        httpDefendPoliyForm.setKeyDetectUriForms(httpKeyDetectUriFormList);
                        serviceForm.setHttpDefendPolicyForm(httpDefendPoliyForm);
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHighFreqDetectEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("highFreqDetectThreshold"), String.valueOf(httpDefendPoliyForm.getHighFreqDetectThreshold()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-high-freq-detect-threshold is" + httpDefendPoliyForm.getHighFreqDetectThreshold()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734004L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("highFreqDetectInterval"), String.valueOf(httpDefendPoliyForm.getHighFreqDetectInterval()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-high-freq-detect-interval is" + httpDefendPoliyForm.getHighFreqDetectInterval()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734005L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpFixUriEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpFixUriRatioNumber"), String.valueOf(httpDefendPoliyForm.getHttpFixUriRatioNumber()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-fix-uri-ratio-number is" + httpDefendPoliyForm.getHttpFixUriRatioNumber()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734006L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpFixUriThreshold"), String.valueOf(httpDefendPoliyForm.getHttpFixUriThreshold()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-fix-uri-threshold is" + httpDefendPoliyForm.getHttpFixUriThreshold()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734007L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpFixUriInterval"), String.valueOf(httpDefendPoliyForm.getHttpFixUriInterval()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-fix-uri-interval is" + httpDefendPoliyForm.getHttpFixUriInterval()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734008L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getLargeResDetectEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("largeResSize"), String.valueOf(httpDefendPoliyForm.getLargeResSize()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-large-res-size is" + httpDefendPoliyForm.getLargeResSize()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734009L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("largeResDetectRatio"), String.valueOf(httpDefendPoliyForm.getLargeResDetectRatio()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-large-res-detect-ratio is" + httpDefendPoliyForm.getLargeResDetectRatio()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734010L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("largeResDetectThreshold"), String.valueOf(httpDefendPoliyForm.getLargeResDetectThreshold()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-large-res-detect-threshold is" + httpDefendPoliyForm.getLargeResDetectThreshold()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734011L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("largeResDetectInterval"), String.valueOf(httpDefendPoliyForm.getLargeResDetectInterval()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error  http-large-res-detect-interval is" + httpDefendPoliyForm.getLargeResDetectInterval()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734012L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getHttpIllegalSessionCheckEnable())) {
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpIllegalSessionNum"), String.valueOf(httpDefendPoliyForm.getHttpIllegalSessionNum()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-illegal-session-num is" + httpDefendPoliyForm.getHttpIllegalSessionNum()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734013L, frontOperationList);
                        return false;
                    }
                    if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("httpIllegalSessionInterval"), String.valueOf(httpDefendPoliyForm.getHttpIllegalSessionInterval()), serviceForm)) {
                        logger.info((Object)("import HttpDefendPolicyForm failed, the error http-illegal-session-interval is" + httpDefendPoliyForm.getHttpIllegalSessionInterval()));
                        ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734014L, frontOperationList);
                        return false;
                    }
                }
                if (ImportZoneUtil.isTrue(httpDefendPoliyForm.getDestIpConnNumEnable()) && !ImportZoneUtil.validatePolicyItem(ImportZoneConstant.HTTP_POLICY_MAP.get("destIpConnNum"), String.valueOf(httpDefendPoliyForm.getDestIpConnNum()), serviceForm)) {
                    logger.info((Object)("import HttpDefendPolicyForm failed, the error dest-ip-conn-num is" + httpDefendPoliyForm.getDestIpConnNum()));
                    ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + policyString + serviceForm.getServiceName(), 734015L, frontOperationList);
                    return false;
                }
            }
        }
        return !"HTTP".equals(protocol) || CheckImportXml.checkPolicyItemTCP(serviceForm, frontOperationList, zoneName, policyString, zoneString);
    }

    public static boolean checkPolicyItem(ZoneServiceForm serviceForm, List<ZoneServiceForm> list, List<BatchOperation> frontOperationList, String[] params) {
        String zoneName = params[0];
        String policyString = params[1];
        String zoneString = params[2];
        if (!CheckImportXml.checkPolicyItemTCP(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
            return false;
        }
        if (!CheckImportXml.checkPolicyItemUDP(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
            return false;
        }
        if (!CheckImportXml.checkPolicyItemICMP(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
            return false;
        }
        if (!CheckImportXml.checkPolicyItemOther(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
            return false;
        }
        if (!CheckImportXml.checkPolicyItemSIP(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
            return false;
        }
        if (!CheckImportXml.checkPolicyItemDNSAndUDPDNS(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
            return false;
        }
        if (!CheckImportXml.checkPolicyItemTopNStudy(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
            return false;
        }
        if (!CheckImportXml.checkPolicyItemHTTPS(serviceForm, frontOperationList, zoneName, policyString, zoneString)) {
            return false;
        }
        return CheckImportXml.checkPolicyItemHTTP(serviceForm, frontOperationList, zoneName, policyString, zoneString);
    }

    public static boolean checkZoneBasicInfo(ZoneInfoForm zoneInfoForm, List<BatchOperation> frontOperationList, String zoneString) {
        String zoneName = zoneInfoForm.getZoneName().trim();
        String zoneDesc = zoneInfoForm.getZoneDesc().trim();
        String zoneContact = zoneInfoForm.getContact();
        if (AticUtil.isNull((String)zoneName)) {
            logger.info((Object)"import ZoneInfoForm failed, the zoneName is empty");
            return false;
        }
        if (AticUtil.isNull((String)zoneDesc)) {
            logger.info((Object)"import ZoneInfoForm failed, the zoneDesc is empty");
            ImportZoneUtil.recordErrorMessg(zoneString + zoneDesc, 570505L, frontOperationList);
            return false;
        }
        if (zoneName.length() > 32) {
            logger.info((Object)("import ZoneInfoForm failed, the error zoneName's length is " + zoneName.length()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneDesc + SEPARATOR + zoneName, 570656L, frontOperationList);
            return false;
        }
        if (zoneDesc.length() > 64) {
            logger.info((Object)("import ZoneInfoForm failed, the error zoneDesc's length is " + zoneDesc.length()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneDesc, 570656L, frontOperationList);
            return false;
        }
        String zoneNameRegex = "^(?!default$)(?!(?i)null$)(?!admin$)[a-zA-Z]{1}\\w*$";
        String zoneDescRegex = "^(?!(?i)null$)[\\w|\u4e00-\u9fa5|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\{]*$";
        if (!zoneDesc.matches(zoneDescRegex) || !zoneName.matches(zoneNameRegex)) {
            logger.info((Object)"import ZoneInfoForm failed, input wrong: The Zone name or account input invalid.");
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SEPARATOR + zoneDesc, 570657L, frontOperationList);
            return false;
        }
        if (!AticUtil.isNullForVpn((String)zoneContact) && zoneContact.length() > 30) {
            logger.info((Object)"import ZoneInfoForm failed, the error zoneContact's length is out of range");
            ImportZoneUtil.recordErrorMessg(zoneString + zoneDesc + "/ " + zoneContact, 732057L, frontOperationList);
            return false;
        }
        return ZoneUtil.validateZoneInfo(logger, zoneInfoForm, frontOperationList, zoneString);
    }

    public static boolean isWhiteAndBlackList(String ipAddr, String deviceId, List<BatchOperation> frontOperationList, String targetName, String whiteLiOrBlackList) {
        if (!FilterUtil.isIpv4(ipAddr) && !FilterUtil.isIpv6(ipAddr)) {
            logger.info((Object)("import WhiteAndBlackList failed, formart wrong :" + AticUtil.getcleanedMessage((String)ipAddr)));
            ImportZoneUtil.recordErrorMessg(targetName + ipAddr, 572010L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean checkIpConflict(LocationCustomForm locationForm, List<BatchOperation> frontOperationList, String iplocationString) {
        List<LocationIpForm> locationIpFormList = locationForm.getLocationIpList();
        for (LocationIpForm form : locationIpFormList) {
            int index = locationIpFormList.indexOf(form);
            String[] srcIpRange = new String[]{form.getStartIp(), form.getEndIp()};
            for (int j = index + 1; j < locationIpFormList.size(); ++j) {
                String startIp = locationIpFormList.get(j).getStartIp();
                String endIp = locationIpFormList.get(j).getEndIp();
                String[] ipRange = new String[]{startIp, endIp};
                boolean isCross = IPUtil4Atic.isCrossIpRange((String[])ipRange, (String[])srcIpRange);
                if (!isCross) continue;
                logger.error((Object)("import iplocation  failed, the error ipAddress is : ," + startIp + "---" + endIp));
                ImportZoneUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + SEPARATOR + form.getIpString(), 571985L, frontOperationList);
                return false;
            }
            ILocationIpService locationIpService = ZoneReferUtil.getLocationIpService();
            ILocationCustomService locationCustomService = ZoneReferUtil.getLocationCustomService();
            List<LocationIpForm> formList = locationIpService.getAllLocationIp();
            Long pkidLong = locationCustomService.findByName(locationForm.getLocationName()).getPkId();
            List<Object> locationIpSelfList = new ArrayList();
            if (null != pkidLong) {
                locationIpSelfList = locationIpService.getLocationIpByLocId(pkidLong);
            }
            if (null == formList) continue;
            formList.removeAll(locationIpSelfList);
            for (LocationIpForm locationIpForm : formList) {
                String startIp = locationIpForm.getStartIp();
                String endIp = locationIpForm.getEndIp();
                String[] ipRange = new String[]{startIp, endIp};
                boolean isCross = IPUtil4Atic.isCrossIpRange((String[])ipRange, (String[])srcIpRange);
                if (!isCross) continue;
                logger.error((Object)("import iplocation  failed, the error ipAddress is : ," + startIp + "---" + endIp));
                ImportZoneUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + SEPARATOR + form.getIpString(), 571985L, frontOperationList);
                return false;
            }
        }
        return true;
    }

    private static boolean checkFilterKeyProtocal(FilterForm form, HttpFilterForm httpFilterForm, String filterType, String filterString, List<BatchOperation> frontOperationList) {
        String filterKey;
        List<String> list = MAP1.get(filterType);
        boolean isContainsKey = list.contains(filterKey = httpFilterForm.getFilterKey());
        if (!isContainsKey) {
            logger.info((Object)("import filterkey  failed, the error filterType is : " + AticUtil.getcleanedMessage((String)filterType)));
            long errorCode = 670709L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey, errorCode, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkFilterContend(FilterForm form, List<BatchOperation> frontOperationList, String[] params) {
        boolean isFilterContent;
        String filterType = params[0];
        String filterString = params[1];
        String filterContent = params[2];
        String filterKey = params[3];
        List<String> list2 = MP2.get(filterKey);
        if (list2 != null && !(isFilterContent = list2.contains(filterContent))) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 670710L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + " : " + filterContent, errorCode, frontOperationList);
            return false;
        }
        return true;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private static boolean checkKeyWordNum(FilterForm form, List<BatchOperation> frontOperationList, String[] params) {
        boolean isContentRange;
        boolean isContentRange2;
        boolean isContentRange1;
        String filterType = params[0];
        String filterString = params[1];
        String filterContent = params[2];
        String filterKey = params[3];
        if ("ttl".equals(filterKey) && !(isContentRange1 = FilterUtil.isCheckData1(filterContent))) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 670711L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + " : " + filterContent, errorCode, frontOperationList);
            return false;
        }
        if (("dscp".equals(filterKey) || "protocol".equals(filterKey) || "type".equals(filterKey)) && !(isContentRange2 = FilterUtil.isCheckData2(filterContent))) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 670712L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + " : " + filterContent, errorCode, frontOperationList);
            return false;
        }
        if ("tcp-flag".equals(filterKey) && !(isContentRange = FilterUtil.isCheckData3(filterContent))) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 670718L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + " : " + filterContent, errorCode, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkFilterSourceOrDestinationIp(FilterForm form, HttpFilterForm httpFilterForm, List<BatchOperation> frontOperationList, List<HttpFilterForm> httpFilterFormList, String filterString) {
        String filterType = form.getFilterType();
        String filterKey = httpFilterForm.getFilterKey();
        String filterContent = httpFilterForm.getFilterContent();
        if (!"source-ip".equals(filterKey) && !"destination-ip".equals(filterKey)) {
            return true;
        }
        String[] currContent = filterContent.split(SEPARATOR);
        String validateIp = currContent[0];
        if (!AticUtil.isNull((String)ImportZoneUtil.checkFilterContentIp(filterContent))) {
            if ("ipAddrError".equals(ImportZoneUtil.checkFilterContentIp(filterContent))) {
                logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
                ImportZoneUtil.recordErrorMessg(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + " : " + filterContent, 572056L, frontOperationList);
                return false;
            }
            if ("maskError".equals(ImportZoneUtil.checkFilterContentIp(filterContent))) {
                logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
                ImportZoneUtil.recordErrorMessg(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + " : " + filterContent, 572057L, frontOperationList);
                return false;
            }
        }
        if (!ImportZoneUtil.checkFilterIpConflict(httpFilterForm, httpFilterFormList, validateIp)) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = NUM_570648;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + " : " + filterContent, errorCode, frontOperationList);
            return false;
        }
        return true;
    }

    private static Map<String, Integer> getMaxAndMinFilterIdIs0(List<HttpFilterForm> httpFilterFormList, HttpFilterForm httpFilterForm) {
        HashMap<String, Integer> maxMinMap = new HashMap<String, Integer>();
        int min = 0;
        int max = 0;
        int tag = 1;
        for (HttpFilterForm form : httpFilterFormList) {
            if (form.getFilterContent().equals(httpFilterForm.getFilterContent()) && tag == 1) {
                ++tag;
                continue;
            }
            if (!"packet-length".equals(form.getFilterKey())) continue;
            String[] contentBefor = form.getFilterContent().split("~");
            if (contentBefor.length == 1) {
                max = min = Integer.parseInt(contentBefor[0]);
                continue;
            }
            if (contentBefor.length != 2) continue;
            min = Integer.parseInt(contentBefor[0]);
            max = Integer.parseInt(contentBefor[1]);
        }
        maxMinMap.put("max", max);
        maxMinMap.put("min", min);
        return maxMinMap;
    }

    private static Map<String, Integer> getMaxAndMinFilterIdIsNot0(List<HttpFilterForm> httpFilterFormList, Integer filterId) {
        HashMap<String, Integer> maxMinMap = new HashMap<String, Integer>();
        int min = 0;
        int max = 0;
        List<HttpFilterForm> dbList = ZoneReferUtil.getHttpFilterService().queryFilterContent("packet-length", String.valueOf(filterId));
        if ((null == httpFilterFormList || httpFilterFormList.isEmpty()) && null != dbList && !dbList.isEmpty()) {
            for (HttpFilterForm form1 : dbList) {
                String[] contentExist = form1.getFilterContent().split("~");
                if (contentExist.length == 1) {
                    max = min = Integer.parseInt(contentExist[0]);
                    continue;
                }
                if (contentExist.length != 2) continue;
                min = Integer.parseInt(contentExist[0]);
                max = Integer.parseInt(contentExist[1]);
            }
        }
        maxMinMap.put("max", max);
        maxMinMap.put("min", min);
        return maxMinMap;
    }

    private static Map<String, Integer> getMaxAndMin(List<HttpFilterForm> httpFilterFormList, FilterForm form, HttpFilterForm httpFilterForm) {
        Map<String, Integer> maxMinMap = null;
        Integer filterId = form.getFilterId();
        maxMinMap = filterId != null ? CheckImportXml.getMaxAndMinFilterIdIsNot0(httpFilterFormList, filterId) : CheckImportXml.getMaxAndMinFilterIdIs0(httpFilterFormList, httpFilterForm);
        return maxMinMap;
    }

    private static boolean checkFilterContentPacketLen(FilterForm form, HttpFilterForm httpFilterForm, List<BatchOperation> frontOperationList, List<HttpFilterForm> httpFilterFormList, String filterString) {
        int max;
        String filterType = form.getFilterType();
        String filterKey = httpFilterForm.getFilterKey();
        String filterContent = httpFilterForm.getFilterContent();
        String[] packetLength = filterContent.split("~");
        if (!"packet-length".equals(filterKey)) {
            return true;
        }
        Long errorCode = ImportZoneUtil.checkPacketLen(packetLength);
        if (null != errorCode) {
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + " : " + filterContent, errorCode, frontOperationList);
            return false;
        }
        Map<String, Integer> maxMinMap = CheckImportXml.getMaxAndMin(httpFilterFormList, form, httpFilterForm);
        int min = null != maxMinMap.get("min") ? maxMinMap.get("min") : 0;
        int n = max = null != maxMinMap.get("max") ? maxMinMap.get("max") : 0;
        if (FilterUtil.isRangeExist(filterContent, min, max)) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, 670722L, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkPortLength(FilterForm form, HttpFilterForm httpFilterForm, List<BatchOperation> frontOperationList, String filterString) {
        String filterType = form.getFilterType();
        String filterKey = httpFilterForm.getFilterKey();
        String filterContent = httpFilterForm.getFilterContent();
        String[] portLength = filterContent.split("~");
        if (!ImportZoneUtil.checkPortFormat(portLength)) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 670716L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCode, frontOperationList);
            return false;
        }
        if (portLength.length == 2) {
            if (Integer.parseInt(portLength[0]) > Integer.parseInt(portLength[1])) {
                logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
                long errorCode = 670720L;
                CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCode, frontOperationList);
                return false;
            }
        } else if (portLength.length != 1) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 572058L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCode, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkSourceOrDestinationSort(FilterForm form, HttpFilterForm httpFilterForm, List<BatchOperation> frontOperationList, List<HttpFilterForm> httpFilterFormList, String filterString) {
        String filterType = form.getFilterType();
        String filterKey = httpFilterForm.getFilterKey();
        String filterContent = httpFilterForm.getFilterContent();
        if (!("source-port".equals(filterKey) || "destination-port".equals(filterKey) || "identification".equals(filterKey))) {
            return true;
        }
        if (!CheckImportXml.checkPortLength(form, httpFilterForm, frontOperationList, filterString)) {
            return false;
        }
        if (!CheckImportXml.checkPortConlict(form, httpFilterForm, httpFilterFormList, filterContent)) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 670721L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCode, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkPortConlict(FilterForm form, HttpFilterForm httpFilterForm, List<HttpFilterForm> httpFilterFormList, String filterContent) {
        int startPort = 0;
        int endPort = 0;
        String[] portLength = filterContent.split("~");
        String filterKey = httpFilterForm.getFilterKey();
        String content = "";
        if (portLength.length == 1) {
            endPort = startPort = Integer.parseInt(portLength[0]);
        } else if (portLength.length == 2) {
            startPort = Integer.parseInt(portLength[0]);
            endPort = Integer.parseInt(portLength[1]);
        }
        Integer filterId = form.getFilterId();
        if (filterId != null && !CheckImportXml.checkPortRangeExistFilterIdNot0(httpFilterFormList, startPort, endPort, filterId, filterKey)) {
            return false;
        }
        int tag = 1;
        for (HttpFilterForm form1 : httpFilterFormList) {
            if (form1.getFilterContent().equals(httpFilterForm.getFilterContent()) && tag == 1) {
                ++tag;
                continue;
            }
            if (!filterKey.equals(form1.getFilterKey()) || !FilterUtil.isRangeExist(content = form1.getFilterContent(), startPort, endPort)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPortRangeExistFilterIdNot0(List<HttpFilterForm> httpFilterFormList, int startPort, int endPort, Integer filterId, String filterKey) {
        String content = "";
        List<HttpFilterForm> dbformList = ZoneReferUtil.getHttpFilterService().queryFilterContent("packet-length", String.valueOf(filterId));
        if (httpFilterFormList.isEmpty() && !dbformList.isEmpty()) {
            for (HttpFilterForm form1 : dbformList) {
                if (!filterKey.equals(form1.getFilterKey()) || !FilterUtil.isRangeExist(content = form1.getFilterContent(), startPort, endPort)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkFingerPrint(FilterForm form, HttpFilterForm httpFilterForm, List<BatchOperation> frontOperationList, String filterString) {
        String filterType = form.getFilterType();
        String filterKey = httpFilterForm.getFilterKey();
        String filterContent = httpFilterForm.getFilterContent();
        if (!"fingerprint".equals(filterKey)) {
            return true;
        }
        String[] fingers = filterContent.split("        ");
        for (int i = 0; i < fingers.length; ++i) {
            String onePart = fingers[i];
            String[] fingerContentOne = onePart.split(" ");
            if (fingerContentOne.length >= 4 || fingerContentOne.length <= 1) {
                logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
                long errorCode = 670717L;
                CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCode, frontOperationList);
                return false;
            }
            Long errorCodeLenIs2 = ImportZoneUtil.validateContentLengthIs2(fingerContentOne);
            if (null != errorCodeLenIs2) {
                logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
                CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCodeLenIs2, frontOperationList);
                return false;
            }
            Long errorCodeLenIs3 = ImportZoneUtil.validateContentLengthIs3(fingerContentOne);
            if (null == errorCodeLenIs3) continue;
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCodeLenIs3, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean filterValidate(FilterForm form, HttpFilterForm httpFilterForm, List<BatchOperation> frontOperationList, List<HttpFilterForm> httpFilterFormList, String filterString) {
        String filterType = form.getFilterType();
        String filterKey = httpFilterForm.getFilterKey();
        String filterContent = httpFilterForm.getFilterContent();
        if (!CheckImportXml.checkFilterKeyProtocal(form, httpFilterForm, filterType, filterString, frontOperationList)) {
            return false;
        }
        String[] params = new String[]{filterType, filterString, filterContent, filterKey};
        if (!CheckImportXml.checkFilterContend(form, frontOperationList, params)) {
            return false;
        }
        String[] parameters = new String[]{filterType, filterString, filterContent, filterKey};
        if (!CheckImportXml.checkKeyWordNum(form, frontOperationList, parameters)) {
            return false;
        }
        if (!CheckImportXml.checkFilterSourceOrDestinationIp(form, httpFilterForm, frontOperationList, httpFilterFormList, filterString)) {
            return false;
        }
        if (!CheckImportXml.checkFilterContentPacketLen(form, httpFilterForm, frontOperationList, httpFilterFormList, filterString)) {
            return false;
        }
        if (!CheckImportXml.checkSourceOrDestinationSort(form, httpFilterForm, frontOperationList, httpFilterFormList, filterString)) {
            return false;
        }
        if (!ImportZoneUtil.checkHostAndSoOn(filterKey, filterContent)) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 670717L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCode, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.checkCallAndDomain(filterKey, filterContent)) {
            logger.info((Object)("import filterContent  failed, the error filterContent is : " + CheckImportXml.getcleanedMessage(filterContent)));
            long errorCode = 670717L;
            CheckImportXml.createImportFailedBO(filterString + form.getFilterName() + SEPARATOR + filterType + SEPARATOR + filterKey + ":" + filterContent, errorCode, frontOperationList);
            return false;
        }
        return CheckImportXml.checkFingerPrint(form, httpFilterForm, frontOperationList, filterString);
    }

    private static void createImportFailedBO(String targetName, long errorCode, List<BatchOperation> frontOperationList) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setTargetName(targetName);
        batchOperation.setErrorCode(errorCode);
        frontOperationList.add(batchOperation);
    }

    private static boolean validateServicePortList(ZoneServiceForm serviceForm, ZonePolicyApplyForm appForm, List<BatchOperation> frontOperationList, String zoneString, String policyString) {
        if (StringUtils.isEmpty((CharSequence)serviceForm.getPortList())) {
            return true;
        }
        String[] ports = serviceForm.getPortList().split(";");
        if (ports.length > Constant.PORT_SERVICE_ZONE_MAXIMUM_PORT_NUM) {
            ImportZoneUtil.recordErrorMessg(zoneString + appForm.getZoneInfoForm().getZoneName() + "/ " + policyString + serviceForm.getServiceName() + SEPARATOR + serviceForm.getPortList(), 733035L, frontOperationList);
            return false;
        }
        for (String port : ports) {
            String[] portStartAndEnd = port.split("~");
            if (2 != portStartAndEnd.length || !AticUtil.isNum((String)portStartAndEnd[0]).booleanValue() || !AticUtil.isNum((String)portStartAndEnd[1]).booleanValue()) {
                ImportZoneUtil.recordErrorMessg(zoneString + appForm.getZoneInfoForm().getZoneName() + "/ " + policyString + serviceForm.getServiceName() + SEPARATOR + port, 733014L, frontOperationList);
                return false;
            }
            String portStart = portStartAndEnd[0];
            String portEnd = portStartAndEnd[1];
            if (Integer.parseInt(portStart) >= 1 && Integer.parseInt(portStart) <= 65535 && Integer.parseInt(portEnd) >= 1 && Integer.parseInt(portEnd) <= 65535 && Integer.parseInt(portStart) <= Integer.parseInt(portEnd)) continue;
            String[] params = new String[]{appForm.getZoneInfoForm().getZoneDesc(), zoneString, port, "", policyString};
            CheckImportXml.writeBatchOperation(frontOperationList, serviceForm, true, params);
            return false;
        }
        int size = ports.length;
        for (int i = 0; i < size; ++i) {
            String port = ports[i];
            String[] portStartAndEnd = port.split("~");
            String portStart = portStartAndEnd[0];
            String portEnd = portStartAndEnd[1];
            for (int j = i + 1; j < size; ++j) {
                String port1 = ports[j];
                String[] portStartAndEnd1 = port1.split("~");
                String portStart1 = portStartAndEnd1[0];
                String portEnd1 = portStartAndEnd1[1];
                if (Integer.parseInt(portEnd) < Integer.parseInt(portStart1) || Integer.parseInt(portStart) > Integer.parseInt(portEnd1)) continue;
                ImportZoneUtil.recordErrorMessg(zoneString + appForm.getZoneInfoForm().getZoneName() + "/ " + policyString + serviceForm.getServiceName() + SEPARATOR + port, 733036L, frontOperationList);
                return false;
            }
        }
        try {
            ZoneReferUtil.getZoneServiceService().checkServiceValid4Import(serviceForm);
        }
        catch (LegoCheckedException e) {
            ImportZoneUtil.recordErrorMessg(zoneString + appForm.getZoneInfoForm().getZoneName() + "/ " + policyString + serviceForm.getServiceName() + SEPARATOR + serviceForm.getPortList(), e.getErrorCode(), frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean checkServiceProtocalAndPort(ZoneServiceForm serviceForm, ZonePolicyApplyForm appForm, List<BatchOperation> frontOperationList, String zoneString, String policyString) {
        if (null == serviceForm) {
            return true;
        }
        return CheckImportXml.validateServicePortList(serviceForm, appForm, frontOperationList, zoneString, policyString);
    }

    public static boolean checkPort(ZoneServiceForm serviceForm) {
        String portList = serviceForm.getPortList();
        if (StringUtils.isEmpty((CharSequence)portList)) {
            return true;
        }
        String[] ports = portList.split(";");
        String[] portRange = null;
        String portStart = null;
        String portEnd = null;
        for (String port : ports) {
            if (null == port) {
                return false;
            }
            if (port.indexOf("~") < 1) {
                return false;
            }
            portRange = port.split("~");
            portStart = portRange[0];
            portEnd = portRange[1];
            if (!AticUtil.isNum((String)portStart).booleanValue() || !AticUtil.isNum((String)portEnd).booleanValue()) {
                return false;
            }
            if (Long.parseLong(portStart) >= 1L && Long.parseLong(portStart) <= 65535L && Long.parseLong(portEnd) >= 1L && Long.parseLong(portEnd) <= 65535L) continue;
            return false;
        }
        return true;
    }

    private static void writeBatchOperation(List<BatchOperation> frontOperationList, ZoneServiceForm serviceForm, boolean isPortError, String[] params) {
        String zoneName = params[0];
        String zoneString = params[1];
        String port = params[2];
        String ipAddr = params[3];
        String policyString = params[4];
        BatchOperation batchOperation = new BatchOperation();
        if (isPortError) {
            batchOperation.setTargetName(zoneString + zoneName + "/ " + policyString + serviceForm.getServiceName() + SEPARATOR + port);
            batchOperation.setErrorCode(572023L);
        } else {
            batchOperation.setTargetName(zoneString + zoneName + "/ " + policyString + serviceForm.getServiceName() + SEPARATOR + ipAddr);
            batchOperation.setErrorCode(572022L);
        }
        frontOperationList.add(batchOperation);
    }

    public static List<String> getFilterTypelist() {
        return Collections.unmodifiableList(FILTER_TYPELIST);
    }

    public static boolean checkProxyIpNum(int size, List<BatchOperation> frontOperationList, String proxyIpString) {
        if (size >= 256) {
            logger.info((Object)("import proxyIp failed, size wrong :" + size));
            ImportZoneUtil.recordErrorMessg(proxyIpString, 570815L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean isGreaterThan0(String number) {
        if (!CheckImportXml.isNumber(number)) {
            return false;
        }
        return Integer.parseInt(number) > ImportZoneConstant.POLICY_ITEM_NUM_ZERO;
    }

    static {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("source-ip");
        list1.add("destination-ip");
        list1.add("packet-length");
        list1.add("ttl");
        list1.add("identification");
        list1.add("fingerprint");
        list1.add("protocol");
        list1.add("dscp");
        list1.add("fragment");
        MAP1.put("IP", list1);
        FILTER_TYPELIST.add("IP");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("source-ip");
        list2.add("destination-ip");
        list2.add("packet-length");
        list2.add("ttl");
        list1.add("identification");
        list2.add("fingerprint");
        list2.add("dscp");
        list2.add("fragment");
        list2.add("tcp-flag");
        list2.add("destination-port");
        list2.add("source-port");
        MAP1.put("TCP", list2);
        FILTER_TYPELIST.add("TCP");
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add("source-ip");
        list3.add("destination-ip");
        list3.add("packet-length");
        list3.add("ttl");
        list1.add("identification");
        list3.add("fingerprint");
        list3.add("dscp");
        list3.add("fragment");
        list3.add("destination-port");
        list3.add("source-port");
        MAP1.put("UDP", list3);
        FILTER_TYPELIST.add("UDP");
        ArrayList<String> list4 = new ArrayList<String>();
        list4.add("source-ip");
        list4.add("destination-ip");
        list4.add("packet-length");
        list4.add("ttl");
        list1.add("identification");
        list4.add("fingerprint");
        list4.add("dscp");
        list4.add("fragment");
        MAP1.put("ICMP", list4);
        FILTER_TYPELIST.add("ICMP");
        ArrayList<String> list5 = new ArrayList<String>();
        list5.add("source-ip");
        list5.add("destination-ip");
        list5.add("packet-length");
        list5.add("ttl");
        list1.add("identification");
        list5.add("fingerprint");
        list5.add("dscp");
        list5.add("fragment");
        list5.add("tcp-flag");
        list5.add("source-port");
        list5.add("opcode");
        list5.add("cookie");
        list5.add("host");
        list5.add("referer");
        list5.add("uri");
        list5.add("user-agent");
        MAP1.put("HTTP", list5);
        FILTER_TYPELIST.add("HTTP");
        ArrayList<String> list6 = new ArrayList<String>();
        list6.add("source-ip");
        list6.add("destination-ip");
        list6.add("packet-length");
        list6.add("ttl");
        list1.add("identification");
        list6.add("fingerprint");
        list6.add("dscp");
        list6.add("fragment");
        list6.add("source-port");
        list6.add("domain");
        list6.add("qr");
        list6.add("type");
        MAP1.put("DNS", list6);
        FILTER_TYPELIST.add("DNS");
        ArrayList<String> list7 = new ArrayList<String>();
        list7.add("source-ip");
        list7.add("destination-ip");
        list7.add("packet-length");
        list7.add("ttl");
        list1.add("identification");
        list7.add("fingerprint");
        list7.add("dscp");
        list7.add("fragment");
        list7.add("source-port");
        list7.add("caller");
        list7.add("callee");
        MAP1.put("SIP", list7);
        FILTER_TYPELIST.add("SIP");
        list1 = new ArrayList();
        list1.add("non");
        list1.add("first");
        list1.add("middle");
        list1.add("last");
        list1.add("donot");
        MP2.put("fragment", list1);
        list2 = new ArrayList();
        list2.add("get");
        list2.add("post");
        list2.add("put");
        list2.add("head");
        list2.add("delete");
        list2.add("options");
        list2.add("trace");
        list2.add("connect");
        MP2.put("opcode", list2);
        list3 = new ArrayList();
        list3.add("query");
        list3.add("replay");
        MP2.put("qr", list3);
    }
}

