/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.util;

import com.hs.atic.bis.model.LocationCustom;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.form.LocationIpForm;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.sdk.bis.service.ILocationIpService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.util.ProgressManage;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.CheckImportXml;
import com.hs.atic.zone.util.ImportZoneConstant;
import com.hs.atic.zone.util.ImportZoneData;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.DevCapUtil;
import com.hs.vsm.secservice.ddos.policy.util.FilterUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyIOForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpFilterService;
import com.huawei.atic.secne.adapter.capability.model.ParaBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public final class ImportZoneUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static ImportZoneUtil instance = null;
    private static ReentrantLock lock = new ReentrantLock();
    private static final String SPRIT = "/";

    private ImportZoneUtil() {
    }

    public static ImportZoneUtil getinstance() {
        lock.lock();
        try {
            ImportZoneUtil importZoneUtil = instance == null ? (ImportZoneUtil)ImportZoneUtil.class.newInstance() : instance;
            return importZoneUtil;
        }
        catch (InstantiationException e) {
            ImportZoneUtil importZoneUtil = null;
            return importZoneUtil;
        }
        catch (IllegalAccessException e) {
            ImportZoneUtil importZoneUtil = null;
            return importZoneUtil;
        }
        finally {
            lock.unlock();
        }
    }

    public static List<LocationCustomForm> getSameNameIpLocation(List<LocationCustomForm> xmlLocationCusFormList, String tartget, List<BatchOperation> frontOperationList) {
        ArrayList<LocationCustomForm> sameNameLocationList = new ArrayList<LocationCustomForm>();
        if (null != xmlLocationCusFormList && !xmlLocationCusFormList.isEmpty()) {
            HashSet<String> locationNameSet = new HashSet<String>();
            for (LocationCustomForm cusForm : xmlLocationCusFormList) {
                if (locationNameSet.contains(cusForm.getLocationName().toLowerCase(Locale.getDefault()))) {
                    sameNameLocationList.add(cusForm);
                    ImportZoneUtil.recordErrorMessg(tartget + cusForm.getLocationName(), 572067L, frontOperationList);
                    continue;
                }
                locationNameSet.add(cusForm.getLocationName().toLowerCase(Locale.getDefault()));
            }
        }
        return sameNameLocationList;
    }

    public static List<FilterForm> getSameNameFilter(List<FilterForm> xmlFilterFormList, String tartget, List<BatchOperation> frontOperationList) {
        ArrayList<FilterForm> sameNameFilterFormList = new ArrayList<FilterForm>();
        if (null != xmlFilterFormList && !xmlFilterFormList.isEmpty()) {
            HashSet<String> filterNameSet = new HashSet<String>();
            for (FilterForm filterForm : xmlFilterFormList) {
                if (null == filterForm.getFilterName() || filterForm.getFilterName().isEmpty()) {
                    sameNameFilterFormList.add(filterForm);
                    continue;
                }
                if (filterNameSet.contains(filterForm.getFilterName().toLowerCase(Locale.getDefault()))) {
                    sameNameFilterFormList.add(filterForm);
                    ImportZoneUtil.recordErrorMessg(tartget + filterForm.getFilterName(), 572066L, frontOperationList);
                    continue;
                }
                filterNameSet.add(filterForm.getFilterName().toLowerCase(Locale.getDefault()));
            }
        }
        return sameNameFilterFormList;
    }

    public static Map<String, ZoneDeviceForm> getZoneDeviceMap(List<ZoneDeviceForm> zoneDeviceList) {
        HashMap<String, ZoneDeviceForm> zoneDevMap = new HashMap<String, ZoneDeviceForm>();
        if (null != zoneDeviceList && !zoneDeviceList.isEmpty()) {
            for (ZoneDeviceForm zdForm : zoneDeviceList) {
                zoneDevMap.put(zdForm.getDeviceIp(), zdForm);
            }
        }
        return zoneDevMap;
    }

    public static boolean checkZoneInfoBasicInformation(ZoneInfoForm zoneInfoForm, ZonePolicyApplyForm zonePolicyApplyForm, List<BatchOperation> frontOperationList, ImportZoneData importZoneData) {
        boolean zoneInfoBasicFlag = CheckImportXml.checkZoneBasicInfo(zoneInfoForm, frontOperationList, importZoneData.getZoneString());
        boolean faultSeverityRuleFlag = ZoneUtil.checkFaultSeverityRuleParameter4Import(zoneInfoForm, zonePolicyApplyForm.getFaultSeverityRuleForm(), frontOperationList, importZoneData.getZoneString());
        boolean outboundfaultSeverityRuleFlag = ZoneUtil.checkFaultSeverityRuleParameter4Import(zoneInfoForm, zonePolicyApplyForm.getOutboundFaultSeverityRuleForm(), frontOperationList, importZoneData.getZoneString());
        Object[] params = new Object[]{zoneInfoForm.getZoneId(), zoneInfoForm.getZoneListIpFormList(), zoneInfoForm, frontOperationList, logger, importZoneData.getZoneString()};
        boolean ipAddrFlag = ZoneUtil.validateIpAddress(params);
        return zoneInfoBasicFlag && faultSeverityRuleFlag && outboundfaultSeverityRuleFlag && ipAddrFlag;
    }

    public static Map<String, IpLocation> ipLocationMap(boolean needLocation) {
        ILibraryFileService service = ZoneReferUtil.getLibraryFileService();
        Map<Long, IpLocation> map = service.getIpLocationMap();
        ILocationCustomService locationCustomService = ZoneReferUtil.getLocationCustomService();
        List<LocationCustom> list = locationCustomService.queryByDeployStatus("undeployed");
        if (null != list && !list.isEmpty()) {
            for (LocationCustom locationCustom : list) {
                IpLocation iplocation = new IpLocation();
                iplocation.setLocationId(locationCustom.getPkId());
                iplocation.setLocationNameZh(SPRIT + locationCustom.getLocationName());
                iplocation.setLocationNameEn(SPRIT + locationCustom.getLocationName());
                map.put(locationCustom.getPkId(), iplocation);
            }
        }
        ArrayList<IpLocation> ipLocationAlList = new ArrayList<IpLocation>(map.values());
        HashMap<String, IpLocation> locationMap = new HashMap<String, IpLocation>();
        if (needLocation) {
            for (IpLocation ipLocation : ipLocationAlList) {
                locationMap.put(ipLocation.getLocationNameEn(), ipLocation);
            }
        }
        return locationMap;
    }

    public static void removeAllSameNameService(List<ZoneServiceForm> serviceFormList, String zoneNameTarget, List<BatchOperation> frontOperationList) {
        if (null == serviceFormList || serviceFormList.isEmpty()) {
            return;
        }
        Map<String, List<ZoneServiceForm>> zoneDevIdServiceMap = ImportZoneUtil.getZoneDeviceServiceMap(serviceFormList);
        if (!zoneDevIdServiceMap.isEmpty()) {
            ArrayList<ZoneServiceForm> tempServiceFormList = new ArrayList<ZoneServiceForm>();
            List<ZoneServiceForm> serviceFormByDeviceList = null;
            String deviceIpString = "";
            for (Map.Entry<String, List<ZoneServiceForm>> entry : zoneDevIdServiceMap.entrySet()) {
                serviceFormByDeviceList = entry.getValue();
                deviceIpString = entry.getKey();
                if (null == serviceFormByDeviceList || serviceFormByDeviceList.isEmpty()) continue;
                for (int i = 0; i < serviceFormByDeviceList.size(); ++i) {
                    for (int j = serviceFormByDeviceList.size() - 1; j > i; --j) {
                        if (j > serviceFormByDeviceList.size() - 1 || !serviceFormByDeviceList.get(i).getServiceName().equals(serviceFormByDeviceList.get(j).getServiceName())) continue;
                        ImportZoneUtil.recordErrorMessg(zoneNameTarget + SPRIT + deviceIpString + SPRIT + serviceFormByDeviceList.get(j).getServiceName(), 572062L, frontOperationList);
                        tempServiceFormList.add(serviceFormByDeviceList.get(j));
                        serviceFormByDeviceList.remove(serviceFormByDeviceList.get(j));
                    }
                }
            }
            serviceFormList.removeAll(tempServiceFormList);
        }
    }

    private static Map<String, List<ZoneServiceForm>> getZoneDeviceServiceMap(List<ZoneServiceForm> serviceFormList) {
        HashMap<String, List<ZoneServiceForm>> zoneDevIdServiceMap = new HashMap<String, List<ZoneServiceForm>>();
        ArrayList<ZoneServiceForm> zServiceList = null;
        for (ZoneServiceForm serviceForm : serviceFormList) {
            zServiceList = (ArrayList<ZoneServiceForm>)zoneDevIdServiceMap.get(serviceForm.getDeviceIp());
            if (null == zServiceList) {
                zServiceList = new ArrayList<ZoneServiceForm>();
            }
            zServiceList.add(serviceForm);
            zoneDevIdServiceMap.put(serviceForm.getDeviceIp(), zServiceList);
        }
        return zoneDevIdServiceMap;
    }

    public static boolean synAckFloodIllegalSessionCheck(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synAckIllegalConnCount"), String.valueOf(tcpDefendPolicyForm.getSynAckIllegalConnCount()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error synack-flood-abnormal-session-check-threshold is : " + tcpDefendPolicyForm.getSynAckIllegalConnCount()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName(), 731103L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synAckIllegalConnCountInterval"), String.valueOf(tcpDefendPolicyForm.getSynAckIllegalConnCountInterval()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error synack-flood-abnormal-session-check-interval is : " + tcpDefendPolicyForm.getSynAckIllegalConnCountInterval()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName(), 731104L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean synAckFloodIllegalConnNum(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synAckIllegalConnNum"), String.valueOf(tcpDefendPolicyForm.getSynAckIllegalConnNum()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error synack-flood-minimum-packets-per-connection-num is : " + tcpDefendPolicyForm.getSynAckIllegalConnNum()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName(), 731105L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("synAckIllegalConnNumInterval"), String.valueOf(tcpDefendPolicyForm.getSynAckIllegalConnNumInterval()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error synack-flood--minimum-packets-per-connection-interval is : " + tcpDefendPolicyForm.getSynAckIllegalConnNumInterval()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName(), 731106L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean validateAbnormalConAndCyle(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("illegalConnCount"), String.valueOf(tcpDefendPolicyForm.getIllegalConnCount()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error abnormal-session-check-threshold is : " + tcpDefendPolicyForm.getIllegalConnCount()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName(), 731074L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("illegalConnCountInterval"), String.valueOf(tcpDefendPolicyForm.getIllegalConnCountInterval()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error abnormal-session-check-check-cycle is : " + tcpDefendPolicyForm.getIllegalConnCountInterval()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName(), 731075L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean validateDestinationConNumAndRate(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("tcpDesttipNum"), String.valueOf(tcpDefendPolicyForm.getTcpDesttipNum()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error concurrent-connection-check-by-destination-ip-address-threshold is : " + tcpDefendPolicyForm.getTcpDesttipNum()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName(), 731070L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.TCP_POLICY_MAP.get("tcpNewDestipRate"), String.valueOf(tcpDefendPolicyForm.getTcpNewDestipRate()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error new-connection-rate-check-by-destination-ip-address-threshold is : " + tcpDefendPolicyForm.getTcpNewDestipRate()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName() + SPRIT + tcpDefendPolicyForm.getTcpNewDestipRate(), 731071L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean validateSourceLimitTimesAndInterval(ZoneServiceForm serviceForm, List<BatchOperation> frontOperationList, String zoneName, String policyString, String zoneString) {
        TcpDefendPolicyForm tcpDefendPolicyForm = serviceForm.getTcpDefendPolicyForm();
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("sourceLimitIllegalTimes"), String.valueOf(tcpDefendPolicyForm.getSourceLimitIllegalTimes()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-limiting-anomaly-times is : " + tcpDefendPolicyForm.getSourceLimitIllegalTimes()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName(), 733029L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("sourceLimitTotalTimes"), String.valueOf(tcpDefendPolicyForm.getSourceLimitTotalTimes()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-limiting-total-check-times is : " + tcpDefendPolicyForm.getSourceLimitTotalTimes()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName() + SPRIT + tcpDefendPolicyForm.getSourceLimitTotalTimes(), 733030L, frontOperationList);
            return false;
        }
        if (!ImportZoneUtil.validatePolicyItem(ImportZoneConstant.PORTSERVICE_POLICY_MAP.get("sourceLimitInterval"), String.valueOf(tcpDefendPolicyForm.getSourceLimitInterval()), serviceForm)) {
            logger.info((Object)("import tcpDefendPolicyForm  failed, the error source-ip-limiting-cycle is : " + tcpDefendPolicyForm.getSourceLimitInterval()));
            ImportZoneUtil.recordErrorMessg(zoneString + zoneName + SPRIT + policyString + serviceForm.getServiceName() + SPRIT + tcpDefendPolicyForm.getSourceLimitInterval(), 733031L, frontOperationList);
            return false;
        }
        return true;
    }

    private static ParaBean hasParasDiff(String id, ZoneServiceForm zoneService) {
        if (null == zoneService || null == zoneService.getDeviceId()) {
            return new ParaBean();
        }
        Long moId = zoneService.getDeviceId();
        DevCapUtil devCapUtil = DevCapUtil.getInstance();
        devCapUtil.initContext(zoneService.getDeviceId(), zoneService.getProtocol());
        ParaBean paraBean = devCapUtil.hasParasDiff(id, moId, zoneService.getProtocol());
        if (null == paraBean) {
            paraBean = new ParaBean();
        }
        return paraBean;
    }

    private static boolean validateParaBean(ParaBean paraBean, String nowValue) {
        Long nowValueNum = null;
        if (null == paraBean || !ImportZoneUtil.isNumber(nowValue)) {
            return false;
        }
        nowValueNum = Long.parseLong(nowValue);
        return nowValueNum <= (long)paraBean.getMaxVal() && nowValueNum >= (long)paraBean.getMinVal();
    }

    public static boolean validatePolicyItem(String key, String nowValue, ZoneServiceForm serviceForm) {
        ParaBean paraBean = ImportZoneUtil.hasParasDiff(key, serviceForm);
        boolean result = true;
        result = ImportZoneUtil.validateParaBean(paraBean, nowValue);
        return result;
    }

    public static boolean isNumber(String str) {
        String regex = "^[0-9]*$";
        return !AticUtil.isNull((String)str) && str.matches(regex);
    }

    public static boolean isTrue(Boolean booleanStr) {
        return null != booleanStr && booleanStr != false;
    }

    public static boolean isCheckPolicyItemTcp(boolean protocolDefaultFlag, String protocol) {
        return protocolDefaultFlag || "TCP".equals(protocol) || "HTTP".equals(protocol) || "HTTPS".equals(protocol);
    }

    public static List<String> ipLocationNameList(List<ZoneIpLocationForm> zoneIpLocationFormList) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (null != zoneIpLocationFormList && !zoneIpLocationFormList.isEmpty()) {
            for (ZoneIpLocationForm ipForm : zoneIpLocationFormList) {
                nameList.add(ipForm.getLocationNameEn().toLowerCase(Locale.getDefault()));
            }
        }
        return nameList;
    }

    public static Long validateContentLengthIs3(String[] fingerContentOne) {
        if (fingerContentOne.length != 3) {
            return null;
        }
        String offset = fingerContentOne[0];
        String contentLength = fingerContentOne[1];
        String depth = fingerContentOne[2];
        String tag = FilterUtil.validateContent(contentLength);
        if ("670717".equals(tag)) {
            return 670717L;
        }
        if ("670725".equals(tag)) {
            return 670725L;
        }
        if ("670724".equals(tag)) {
            return 670724L;
        }
        if (!(FilterUtil.isPacketLengthRange(offset) && FilterUtil.isPacketLengthRange(depth) || FilterUtil.isFingerprintPacketLengthRange(offset) && FilterUtil.isPacketLengthRange(depth))) {
            return 670717L;
        }
        return null;
    }

    public static Long validateContentLengthIs2(String[] fingerContentOne) {
        if (fingerContentOne.length != 2) {
            return null;
        }
        String offset = fingerContentOne[0];
        String contentLength = fingerContentOne[1];
        String tag = FilterUtil.validateContent(contentLength);
        if ("670717".equals(tag)) {
            return 670717L;
        }
        if ("670725".equals(tag)) {
            return 670725L;
        }
        if ("670724".equals(tag)) {
            return 670724L;
        }
        if (!FilterUtil.isPacketLengthRange(offset)) {
            return 670717L;
        }
        return null;
    }

    public static boolean checkCallAndDomain(String filterKey, String filterContent) {
        if ("caller".equals(filterKey) || "callee".equals(filterKey) || "domain".equals(filterKey)) {
            String[] httpContent = filterContent.split("    ");
            if (httpContent.length != 2) {
                return false;
            }
            if (!("include".equals(httpContent[0]) || "equal".equals(httpContent[0]) && FilterUtil.isAnyCharacter(httpContent[1]))) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkHostAndSoOn(String filterKey, String filterContent) {
        if ("cookie".equals(filterKey) || "host".equals(filterKey) || "referer".equals(filterKey) || "uri".equals(filterKey) || "user-agent".equals(filterKey)) {
            String[] httpContent = filterContent.split("    ");
            if (httpContent.length != 2) {
                return false;
            }
            if (!"include".equals(httpContent[0]) || !FilterUtil.isAnyCharacter(httpContent[1])) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkPortFormat(String[] portLength) {
        if (portLength.length == 1 && !FilterUtil.isPortRange(portLength[0])) {
            return false;
        }
        return portLength.length != 2 || FilterUtil.isPortRange(portLength[0]) && FilterUtil.isPortRange(portLength[1]);
    }

    public static Long checkPacketLen(String[] packetLength) {
        int length = packetLength.length;
        if (length == 2) {
            if (!FilterUtil.isPacketLengthRange(packetLength[0]) || !FilterUtil.isPacketLengthRange(packetLength[1])) {
                return 670715L;
            }
            if (Integer.parseInt(packetLength[0]) > Integer.parseInt(packetLength[1])) {
                return 670719L;
            }
        } else {
            return 670717L;
        }
        return null;
    }

    private static String[] getIpRange(String content) {
        String[] ipRange = new String[]{};
        if (AticUtil.isNull((String)content)) {
            return ipRange;
        }
        String[] contentExist = content.split(SPRIT);
        if (contentExist.length == 2) {
            ipRange = IPUtil.getSubnetRange((String)contentExist[0], (int)Integer.parseInt(contentExist[1]));
        } else if (contentExist.length == 1) {
            ipRange = contentExist;
        }
        return ipRange;
    }

    public static boolean checkFilterIpConflict(HttpFilterForm httpFilterForm, List<HttpFilterForm> httpFilterFormList, String validateIp) {
        String content = "";
        int tag = 1;
        for (HttpFilterForm filterForm : httpFilterFormList) {
            String[] ipRange;
            if (filterForm.getFilterContent().equals(httpFilterForm.getFilterContent()) && tag == 1) {
                ++tag;
                continue;
            }
            if ("source-ip".equals(filterForm.getFilterKey()) || "destination-ip".equals(filterForm.getFilterKey())) {
                content = filterForm.getFilterContent();
            }
            if ((ipRange = ImportZoneUtil.getIpRange(content)).length == 0) continue;
            if (ipRange.length == 2 && IPUtil.isInIpRange((String[])ipRange, (String)validateIp)) {
                return false;
            }
            if (ipRange.length != 1 || !validateIp.equals(ipRange[0])) continue;
            return false;
        }
        return true;
    }

    public static String checkFilterContentIp(String filterContent) {
        String[] currContent = filterContent.split(SPRIT);
        if (currContent.length != 2) {
            return "ipAddrError";
        }
        Map<String, Boolean> ipResultMap = ImportZoneUtil.getIpResultMap();
        if (!ImportZoneUtil.validateIpMask(currContent, ipResultMap, true)) {
            if (ipResultMap.get("isZero").booleanValue() || ipResultMap.get("ipAddrError").booleanValue()) {
                return "ipAddrError";
            }
            if (ipResultMap.get("maskError").booleanValue()) {
                return "maskError";
            }
        }
        return null;
    }

    public static boolean checkFilterAction(FilterForm filterForm) {
        if (filterForm.getFilterAction() < 1 || filterForm.getFilterAction() > 7) {
            return false;
        }
        return filterForm.getFilterAction() != 6 || "http".equals(filterForm.getFilterType());
    }

    private static boolean validateIpRange(String[] ipAddress, Map<String, Boolean> ipResultMap) {
        if (ipAddress.length != 2) {
            ipResultMap.put("rangeError", true);
            return false;
        }
        if (AticUtil.isNull((String)ipAddress[0]) || AticUtil.isNull((String)ipAddress[1])) {
            ipResultMap.put("rangeError", true);
            return false;
        }
        if ("0.0.0.0".equals(ipAddress[0]) || "0.0.0.0".equals(ipAddress[1])) {
            ipResultMap.put("isZero", true);
            return false;
        }
        if (!IPUtil4Atic.checkStartEndIpArray((String[])ipAddress)) {
            ipResultMap.put("rangeError", true);
            return false;
        }
        return true;
    }

    public static boolean validateIpMask(String[] ipAddress, Map<String, Boolean> ipResultMap, boolean isNotValidateBlackAndWhiteIp) {
        if (null == ipAddress || !ImportZoneUtil.preIpAddrError(ipAddress)) {
            ipResultMap.put("ipAddrError", true);
            logger.info((Object)("ipAddress is error.The ipAddress : " + (null == ipAddress ? "" : ipAddress)));
            return false;
        }
        if (isNotValidateBlackAndWhiteIp && "0.0.0.0".equals(ipAddress[0])) {
            ipResultMap.put("isZero", true);
            logger.info((Object)"The ipAddr is 0.0.0");
            return false;
        }
        if (!ImportZoneUtil.checkMask(ipAddress[0], ipAddress[1])) {
            ipResultMap.put("maskError", true);
            logger.info((Object)("The mask is error.The mask is " + AticUtil.getcleanedMessage((String)ipAddress[1]) + ". The ip is " + AticUtil.getcleanedMessage((String)ipAddress[0])));
            return false;
        }
        return true;
    }

    private static boolean preIpAddrError(String[] ipAddress) {
        if (ipAddress.length != 2) {
            return false;
        }
        if (AticUtil.isNull((String)ipAddress[0]) || AticUtil.isNull((String)ipAddress[1])) {
            return false;
        }
        return ImportZoneUtil.checkIpAddr(ipAddress[0]);
    }

    private static boolean checkIpAddr(String ipAddr) {
        return IPUtil.isIpv4((String)ipAddr) || IPUtil.isIpv6((String)ipAddr);
    }

    private static boolean checkMask(String ipAddr, String mask) {
        if (IPUtil.isIpv4((String)ipAddr) && !ImportZoneUtil.isIpv4Mask(mask)) {
            return false;
        }
        return !IPUtil.isIpv6((String)ipAddr) || ImportZoneUtil.isIpv6Mask(mask);
    }

    public static boolean validateIpAddr(String ipAddrs, Map<String, Boolean> ipResultMap, boolean isNotValidateBlackAndWhiteIp) {
        if (AticUtil.isNull((String)ipAddrs)) {
            ipResultMap.put("ipAddrError", true);
            return false;
        }
        String ipSplitRange = "-";
        String ipSplitMask = SPRIT;
        if (ipAddrs.contains(ipSplitRange)) {
            String[] ipAddress = ipAddrs.split(ipSplitRange);
            return ImportZoneUtil.validateIpRange(ipAddress, ipResultMap);
        }
        if (ipAddrs.contains(ipSplitMask)) {
            String[] ipAddress = ipAddrs.split(ipSplitMask);
            return ImportZoneUtil.validateIpMask(ipAddress, ipResultMap, isNotValidateBlackAndWhiteIp);
        }
        ipResultMap.put("ipAddrError", true);
        return false;
    }

    private static boolean isIpv4Mask(String mask) {
        String regex = "^1[0-9]|2[0-9]|3[0-2]|[1-9]$";
        return !AticUtil.isNull((String)mask) && mask.matches(regex);
    }

    private static boolean isIpv6Mask(String mask) {
        String regex = "^1[0-2][0-8]|[1-9][0-9]|[1-9]$";
        return !AticUtil.isNull((String)mask) && mask.matches(regex);
    }

    public static boolean checkIsTaskCancled(ImportZoneData importZoneData) {
        boolean isTaskCancled = false;
        ProgressState pState = ProgressManage.getInstance().getProgressState(importZoneData.getProgressBarId());
        if (null != pState && pState.getIsStop().booleanValue()) {
            isTaskCancled = true;
            Locker.getInstance().setImportFlag(false);
        }
        logger.info((Object)("Progress bar state is " + isTaskCancled + ". The time is" + new Date(System.currentTimeMillis()) + ", The  importZoneData.getProgressBarId() is " + importZoneData.getProgressBarId()));
        return isTaskCancled;
    }

    public static void updateFilterForm(FilterForm dbForm, FilterForm filterForm) {
        IHttpFilterService httpFilterService = ZoneReferUtil.getHttpFilterService();
        IFilterService filterService = ZoneReferUtil.getFilterService();
        dbForm.setFilterAction(filterForm.getFilterAction());
        dbForm.setFilterAlert(filterForm.getFilterAlert());
        dbForm.setHttpFilterFormList(filterForm.getHttpFilterFormList());
        filterForm.setFilterId(dbForm.getFilterId());
        httpFilterService.queryAndDeleteByFilterId(dbForm.getPkid());
        filterService.update(dbForm);
    }

    public static Map<String, FilterForm> getFilterFormMap() {
        HashMap<String, FilterForm> filterFormMap = new HashMap<String, FilterForm>();
        IFilterService filterService = ZoneReferUtil.getFilterService();
        List<FilterForm> filterFormDbList = filterService.findAll();
        if (null != filterFormDbList && !filterFormDbList.isEmpty()) {
            for (FilterForm filterForm : filterFormDbList) {
                filterFormMap.put(filterForm.getFilterName(), filterForm);
            }
        }
        return filterFormMap;
    }

    public static LocationCustomForm prepareLocationCusForm(LocationCustomForm locationForm, List<LocationIpForm> ipList, ImportZoneData importZoneData, List<BatchOperation> frontOperationList) {
        ILocationCustomService locationCustomService = ZoneReferUtil.getLocationCustomService();
        boolean isExist = locationCustomService.isExists(locationForm.getLocationName());
        if (isExist) {
            LocationCustomForm cusForm = locationCustomService.findByName(locationForm.getLocationName());
            cusForm.setLocationIpList(ipList);
            cusForm.setDescription(locationForm.getDescription());
            if (!"undeployed".equals(cusForm.getDeployStatus())) {
                cusForm.setDeployStatus("part_suc");
            }
            return cusForm;
        }
        locationForm.setDeployStatus("undeployed");
        return locationForm;
    }

    public static void prepareLocationIpList(List<LocationIpForm> ipLoactionList, ImportZoneData importZoneData, List<BatchOperation> frontOperationList) {
        if (null != ipLoactionList && !ipLoactionList.isEmpty()) {
            int maskInteger = 0;
            String startIp = "";
            String endIp = "";
            for (LocationIpForm ipForm : ipLoactionList) {
                if (!ImportZoneUtil.checkLocationIp(ipForm, importZoneData, frontOperationList)) continue;
                String ipString = ipForm.getIpString();
                if (ipString.contains("-")) {
                    startIp = IPUtil4Atic.convert2CompleteIp((String)ipString.split("-")[0]);
                    endIp = IPUtil4Atic.convert2CompleteIp((String)ipString.split("-")[1]);
                }
                if (ipString.contains(SPRIT)) {
                    String ipSplitMask = SPRIT;
                    String ipAddress = ipString.split(ipSplitMask)[0];
                    String maskInput = ipString.split(ipSplitMask)[1];
                    if (AticUtil.isNum((String)maskInput).booleanValue()) {
                        maskInteger = Integer.parseInt(maskInput);
                    }
                    String maskStr = AticUtil.getMask((Integer)maskInteger);
                    startIp = IPUtil4Atic.convert2CompleteIp((String)AticUtil.getMaskStartIp((String)ipAddress, (String)maskStr));
                    endIp = IPUtil4Atic.convert2CompleteIp((String)AticUtil.getMaskEndIp((String)ipAddress, (String)maskStr));
                }
                ipForm.setStartIp(startIp);
                ipForm.setEndIp(endIp);
            }
        }
    }

    private static boolean checkLocationIp(LocationIpForm ipForm, ImportZoneData importZoneData, List<BatchOperation> frontOperationList) {
        String ipString = ipForm.getIpString();
        if (!ipString.contains("-") && !ipString.contains(SPRIT)) {
            logger.info((Object)("saveLoctionIpForm error,ipString=" + AticUtil.getcleanedMessage((String)ipString) + ". Wrong IP address."));
            ImportZoneUtil.recordErrorMessg(importZoneData.getIplocationString() + ipString, 572010L, frontOperationList);
            return false;
        }
        if (ipString.contains(SPRIT)) {
            String ipSplitMask = SPRIT;
            String ipAddress = ipString.split(ipSplitMask)[0];
            String maskInput = ipString.split(ipSplitMask)[1];
            int maskInteger = 0;
            if (AticUtil.isNum((String)maskInput).booleanValue()) {
                maskInteger = Integer.parseInt(maskInput);
            }
            if (IPUtil.isIpv4((String)ipAddress)) {
                if (maskInteger > 32 || maskInteger < 1) {
                    logger.info((Object)("saveLoctionIpForm error,ipString=" + AticUtil.getcleanedMessage((String)ipString) + ". Mask over range,mask=" + maskInteger));
                    ImportZoneUtil.recordErrorMessg(importZoneData.getIplocationString() + ipString, 572009L, frontOperationList);
                    return false;
                }
            } else {
                logger.info((Object)("saveLoctionIpForm error,ipString=" + AticUtil.getcleanedMessage((String)ipString) + ". Wrong IP address."));
                ImportZoneUtil.recordErrorMessg(importZoneData.getIplocationString() + ipString, 572010L, frontOperationList);
                return false;
            }
        }
        return true;
    }

    public static boolean checkLocationIpList(LocationCustomForm locationForm, ImportZoneData importZoneData, List<BatchOperation> frontOperationList) {
        if (null != locationForm.getLocationIpList() && !locationForm.getLocationIpList().isEmpty()) {
            if (locationForm.getLocationIpList().size() > 50) {
                logger.info((Object)(" Custom IP location information can not be more than 50\uff0cipLocation.size= " + locationForm.getLocationIpList().size()));
                ImportZoneUtil.recordErrorMessg(locationForm.getLocationName(), 572007L, frontOperationList);
                return false;
            }
        } else {
            logger.info((Object)("saveLoctionCustom error,locationCustom'name=" + locationForm.getLocationName() + ". Custom IP location can not be empty."));
            ImportZoneUtil.recordErrorMessg(locationForm.getLocationName(), 572011L, frontOperationList);
            return false;
        }
        return true;
    }

    private static boolean checkLocationIpValid(LocationCustomForm locationForm, List<BatchOperation> frontOperationList, String iplocationString) {
        List<LocationIpForm> ipList = locationForm.getLocationIpList();
        Map<String, Boolean> ipResultMap = ImportZoneUtil.getIpResultMap();
        for (LocationIpForm ipLocation : ipList) {
            if (ImportZoneUtil.validateIpAddr(ipLocation.getIpString().trim(), ipResultMap, true)) continue;
            if (ipResultMap.get("isZero").booleanValue()) {
                logger.error((Object)("import iplocation  failed.The IP is zero.IP =" + ipLocation.getIpString().trim()));
                ImportZoneUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + SPRIT + ipLocation.getIpString(), 571986L, frontOperationList);
                return false;
            }
            if (ipResultMap.get("rangeError").booleanValue()) {
                logger.error((Object)("The ip range error.The ipRange=" + ipLocation.getIpString().trim()));
                ImportZoneUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + SPRIT + ipLocation.getIpString(), 572021L, frontOperationList);
                return false;
            }
            if (ipResultMap.get("ipAddrError").booleanValue()) {
                logger.error((Object)("import iplocation  failed, ip format wrong.IP= " + ipLocation.getIpString().trim()));
                ImportZoneUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + SPRIT + ipLocation.getIpString(), 571986L, frontOperationList);
                return false;
            }
            if (!ipResultMap.get("maskError").booleanValue()) continue;
            logger.error((Object)("IP mask error.The ip=" + ipLocation.getIpString().trim()));
            ImportZoneUtil.recordErrorMessg(iplocationString + locationForm.getLocationName() + SPRIT + ipLocation.getIpString(), 571987L, frontOperationList);
            return false;
        }
        return true;
    }

    public static boolean checkIpLocationNameAndIpAddr(LocationCustomForm locationForm, ImportZoneData importZoneData, List<BatchOperation> frontOperationList) {
        if (!ImportZoneUtil.checkIpLocationName(locationForm)) {
            logger.info((Object)"import iplocation  failed, the error  is : name is null");
            ImportZoneUtil.recordErrorMessg(importZoneData.getIplocationString() + locationForm.getLocationName(), 572037L, frontOperationList);
            return false;
        }
        return ImportZoneUtil.checkLocationIpValid(locationForm, frontOperationList, importZoneData.getIplocationString());
    }

    private static boolean checkIpLocationName(LocationCustomForm locationForm) {
        return locationForm.getLocationName().matches("^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$");
    }

    public static boolean checkIpLocationNum(ZonePolicyIOForm zonePolicyForm, ImportZoneData importZoneData) {
        ILocationCustomService locationCustomService = ZoneReferUtil.getLocationCustomService();
        ILocationIpService locationIpService = ZoneReferUtil.getLocationIpService();
        int allIpNum = locationIpService.getAllLocationIp().size();
        int tempNum = 0;
        int xmlIpListSize = 0;
        for (LocationCustomForm customForm : zonePolicyForm.getLocationFormList()) {
            if (locationCustomService.isExists(customForm.getLocationName())) {
                List<LocationIpForm> locationIpFormList = locationIpService.getLocationIpByLocId(locationCustomService.findByName(customForm.getLocationName()).getPkId());
                tempNum += locationIpFormList.size();
            }
            xmlIpListSize += customForm.getLocationIpList().size();
        }
        logger.info((Object)("Custom IP location of the total number of IP can not exceed 500.size=" + (allIpNum - tempNum + xmlIpListSize)));
        return allIpNum - tempNum + xmlIpListSize <= 500;
    }

    public static void recordErrorMessg(String targetName, long errorCode, List<BatchOperation> frontOperationList) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setTargetName(targetName);
        batchOperation.setErrorCode(errorCode);
        frontOperationList.add(batchOperation);
    }

    public static Map<String, Boolean> getIpResultMap() {
        HashMap<String, Boolean> ipResultMap = new HashMap<String, Boolean>();
        ipResultMap.put("ipAddrError", false);
        ipResultMap.put("rangeError", false);
        ipResultMap.put("maskError", false);
        ipResultMap.put("isZero", false);
        return ipResultMap;
    }

    public static int calTotalSetp(ZonePolicyIOForm zonePolicyForm) {
        int totalStep = 0;
        if (zonePolicyForm.isNeedPolicy() && null != zonePolicyForm.getZoneFormList() && !zonePolicyForm.getZoneFormList().isEmpty()) {
            totalStep += zonePolicyForm.getZoneFormList().size() + 1;
        }
        if (zonePolicyForm.isNeedLocation() && null != zonePolicyForm.getLocationFormList() && !zonePolicyForm.getLocationFormList().isEmpty()) {
            totalStep += zonePolicyForm.getLocationFormList().size();
        }
        if (zonePolicyForm.isNeedFilter() && null != zonePolicyForm.getFilterFormList() && !zonePolicyForm.getFilterFormList().isEmpty()) {
            totalStep += zonePolicyForm.getFilterFormList().size();
        }
        logger.info((Object)("importZone totalStep:=" + totalStep));
        return totalStep;
    }
}

