/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.util;

import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.form.ZonePortMapForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.XmlUtil;
import com.hs.atic.zone.util.CheckImportXml;
import com.hs.atic.zone.util.PolicyDefaultValueUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpKeyDetectUriForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TopNStudyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyIOForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.xml.sax.SAXException;

public final class ZoneImportParserUtil {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String POLICY_PROTOCOL_TCP = "TCP";
    private static final String POLICY_PROTOCOL_UDP = "UDP";
    private static final String POLICY_PROTOCOL_ICMP = "ICMP";
    private static final String POLICY_PROTOCOL_OTHER = "Other";
    private static final String POLICY_PROTOCOL_DNS = "DNS";
    private static final String POLICY_PROTOCOL_SIP = "SIP";
    private static final String POLICY_PROTOCOL_HTTP = "HTTP";
    private static final String POLICY_PROTOCOL_HTTPS = "HTTPS";
    private static final String POLICY_PROTOCOL_TOP_N_STUDY = "Top N Study";
    private static final String POLICY_PROTOCOL_DEFAULT = "DEFAULT";
    private static final String TRUE = "1";
    private static final String TRUE_BOOLEAN = "true";
    private static ZoneImportParserUtil zoneImportParser = null;

    private ZoneImportParserUtil() {
    }

    public static ZoneImportParserUtil getInstance() {
        if (null == zoneImportParser) {
            try {
                zoneImportParser = (ZoneImportParserUtil)ZoneImportParserUtil.class.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return zoneImportParser;
    }

    public static ZonePolicyIOForm parseZoneImport(String filePath) {
        File file = null;
        FileInputStream fileInputStream = null;
        ZonePolicyIOForm form = new ZonePolicyIOForm();
        try {
            file = new File(filePath);
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            LOG.error((Object)"file is null");
            throw new LegoCheckedException(571980L, (Throwable)e);
        }
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = XmlUtil.configureSecureInfoForDocumentBuilder((DocumentBuilderFactory)dbf);
            Document document = new DOMReader().read(db.parse(fileInputStream));
            if (null == document) {
                LOG.error((Object)"document is null");
                throw new LegoCheckedException(571982L);
            }
            Element root = document.getRootElement();
            String dimension = root.elementText("dimension");
            String time = root.elementText("time");
            String systemVersion = root.elementText("system-version");
            if (StringUtils.isEmpty((CharSequence)dimension) || StringUtils.isEmpty((CharSequence)time) || StringUtils.isEmpty((CharSequence)systemVersion)) {
                LOG.error((Object)"dimension or time or systemVersion is null");
                throw new LegoCheckedException(571981L);
            }
            if (!AticUtil.getAticVersion().equals(systemVersion) && !"ATIC".equals(systemVersion)) {
                LOG.error((Object)"System Version is incorrect.");
                throw new LegoCheckedException(571981L);
            }
            if (!AticUtil.isValidDate((String)time)) {
                LOG.error((Object)"time format error");
                throw new LegoCheckedException(571981L);
            }
            form.setDimension(dimension);
            form.setTime(time);
            form.setSystemVersion(systemVersion);
            if ("zone".equals(dimension)) {
                String needIp = root.elementText("need-ip");
                String needLocation = root.elementText("need-location");
                String needMode = root.elementText("need-mode");
                String needFilter = root.elementText("need-filter");
                String needPolicy = root.elementText("need-policy");
                String needBlackPolicy = root.elementText("need-black-policy");
                String needWhitePolicy = root.elementText("need-white-policy");
                if (!TRUE_BOOLEAN.equals(needIp)) {
                    form.setNeedIp(false);
                }
                if (!TRUE_BOOLEAN.equals(needLocation)) {
                    form.setNeedLocation(false);
                }
                if (!TRUE_BOOLEAN.equals(needMode)) {
                    form.setNeedMode(false);
                }
                if (!TRUE_BOOLEAN.equals(needFilter)) {
                    form.setNeedFilter(false);
                }
                if (!TRUE_BOOLEAN.equals(needPolicy)) {
                    form.setNeedPolicy(false);
                }
                if (!TRUE_BOOLEAN.equals(needBlackPolicy)) {
                    form.setNeedBlackPolicy(false);
                }
                if (!TRUE_BOOLEAN.equals(needWhitePolicy)) {
                    form.setNeedWhitePolicy(false);
                }
            } else {
                String needLocation = root.elementText("need-location");
                String needFilter = root.elementText("need-filter");
                String needPolicy = root.elementText("need-policy");
                if (!TRUE_BOOLEAN.equals(needLocation)) {
                    form.setNeedLocation(false);
                }
                if (!TRUE_BOOLEAN.equals(needFilter)) {
                    form.setNeedFilter(false);
                }
                if (!TRUE_BOOLEAN.equals(needPolicy)) {
                    form.setNeedPolicy(false);
                }
            }
            ArrayList<ZonePolicyApplyForm> zoneFormList = new ArrayList<ZonePolicyApplyForm>();
            ZoneImportParserUtil.parseZoneInfo(root, zoneFormList);
            form.setZoneFormList(zoneFormList);
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)("File format is incorrect:" + le.getMessage()));
            if (571988L == le.getErrorCode()) {
                throw new LegoCheckedException(571988L, (Throwable)le);
            }
            throw new LegoCheckedException(571981L, (Throwable)le);
        }
        catch (SAXException e1) {
            LOG.error((Object)"File format is incorrect SAXException");
            throw new LegoCheckedException(571981L, (Throwable)e1);
        }
        catch (IOException e2) {
            LOG.error((Object)"File format is incorrect IOException");
            throw new LegoCheckedException(571981L, (Throwable)e2);
        }
        catch (ParserConfigurationException e3) {
            LOG.error((Object)"File format is incorrect ParserConfigurationException");
            throw new LegoCheckedException(571981L, (Throwable)e3);
        }
        catch (NumberFormatException e4) {
            LOG.error((Object)"File contains incorrent number.");
            throw new LegoCheckedException(632010L);
        }
        catch (ArrayIndexOutOfBoundsException e5) {
            LOG.error((Object)"File contains incorrent range.");
            throw new LegoCheckedException(632011L);
        }
        catch (IllegalArgumentException e6) {
            LOG.error((Object)"File contains incorrent parameter.");
            throw new LegoCheckedException(632012L);
        }
        catch (RuntimeException e7) {
            LOG.error((Object)"File format is incorrect RuntimeException");
            throw new LegoCheckedException(571981L, (Throwable)e7);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    fileInputStream = null;
                }
            }
        }
        return form;
    }

    private static boolean isEmptyString(String s) {
        return AticUtil.isNull((String)s);
    }

    private static DnsDefendPolicyForm dnsParse(Element elementPolicy, String policyProtocol) {
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String sourceRateLimitingEnable = elementPolicy.elementText("source-rate-limiting-enable");
        String requestSourceIpAddressEnable = elementPolicy.elementText("rate-limiting-on-request-packets-of-source-ip-address-enable");
        String requestSourceIpAddressThreshold = elementPolicy.elementText("rate-limiting-on-request-packets-of-source-ip-address-threshold");
        String replytSourceIpAddressEnable = elementPolicy.elementText("rate-limiting-on-reply-packets-of-source-ip-address-enable");
        String replySourceIpAddressThreshold = elementPolicy.elementText("rate-limiting-on-reply-packets-of-source-ip-address-threshold");
        String cacheServerEnable = elementPolicy.elementText("unique-configuration-item-of-the-cache-server-enable");
        String cacheServerRFADefenseEnable = elementPolicy.elementText("cache-server-dns-request-flood-attack-defense-enable");
        String cacheServerRFADefenseMode = elementPolicy.elementText("cache-server-dns-request-flood-attack-defense-mode");
        String cacheServerRFADefenseThreshold = elementPolicy.elementText("cache-server-dns-request-flood-attack-defense-threshold");
        String authorizationServerEnable = elementPolicy.elementText("unique-configuration-item-of-the-authorization-server-enable");
        String authDefenseEnable = elementPolicy.elementText("authorization-server-dns-request-flood-attack-defense-enable");
        String authDefenseMode = elementPolicy.elementText("authorization-server-dns-request-flood-attack-defense-mode");
        String authDefenseThreshold = elementPolicy.elementText("authorization-server-dns-request-flood-attack-defense-threshold");
        String replyRFADefenseEnable = elementPolicy.elementText("dns-reply-flood-attack-defense-enable");
        String replyRFADefenseThreshold = elementPolicy.elementText("dns-reply-flood-attack-defense-threshold");
        String nxdomainEnable = elementPolicy.elementText("detection-of-the-requests-for-nxdomain-enable");
        String nxdomain = elementPolicy.elementText("proportion-taken-by-the-requests-for-nxdomain");
        String malformedEnable = elementPolicy.elementText("packet-malformed-enable");
        String malformedThreshold = elementPolicy.elementText("packet-malformed-threshold");
        String limitingEnable = elementPolicy.elementText("dns-request-packet-length-limiting-enable");
        String limitingThreshold = elementPolicy.elementText("dns-request-packet-length-limiting-threshold");
        String replyLimitingEnable = elementPolicy.elementText("dns-reply-packet-length-limiting-enable");
        String replyLimitingThreshold = elementPolicy.elementText("dns-reply-packet-length-limiting-threshold");
        String dnsFirestPacketCheck = elementPolicy.elementText("dns-first-packet-check-enable");
        String dnsFirestPacketCheckInterval = elementPolicy.elementText("dns-first-packet-check-interval");
        DnsDefendPolicyForm dnsDefendPolicyForm = new DnsDefendPolicyForm();
        dnsDefendPolicyForm.setDirection(1);
        String blockEnable = elementPolicy.elementText("block-enable");
        if (TRUE.equals(blockEnable)) {
            dnsDefendPolicyForm.setDnsBlock(true);
            dnsDefendPolicyForm.setLimitEnable(false);
            dnsDefendPolicyForm.setDnsDefendEnable(false);
        } else {
            dnsDefendPolicyForm.setDnsBlock(false);
        }
        if (TRUE.equals(sourceRateLimitingEnable)) {
            dnsDefendPolicyForm.setLimitEnable(true);
            dnsDefendPolicyForm.setDnsLimitRate(200);
            if (TRUE.equals(requestSourceIpAddressEnable)) {
                dnsDefendPolicyForm.setSrcipReqLimitEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(requestSourceIpAddressThreshold)) {
                    dnsDefendPolicyForm.setSrcipReqAlertRate(Integer.valueOf(requestSourceIpAddressThreshold));
                }
            } else {
                dnsDefendPolicyForm.setSrcipReqLimitEnable(false);
            }
            if (TRUE.equals(replytSourceIpAddressEnable)) {
                dnsDefendPolicyForm.setSrcipRespLimitEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(replySourceIpAddressThreshold)) {
                    dnsDefendPolicyForm.setSrcipRespAlertRate(Integer.valueOf(replySourceIpAddressThreshold));
                }
            } else {
                dnsDefendPolicyForm.setSrcipRespLimitEnable(false);
            }
        } else {
            dnsDefendPolicyForm.setLimitEnable(false);
        }
        if (TRUE.equals(defenseEnable)) {
            dnsDefendPolicyForm.setDnsDefendEnable(true);
            if (TRUE.equals(cacheServerEnable)) {
                dnsDefendPolicyForm.setDnsCacheServerEnable(true);
                if (TRUE.equals(cacheServerRFADefenseEnable)) {
                    dnsDefendPolicyForm.setDnsFloodEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(cacheServerRFADefenseMode)) {
                        dnsDefendPolicyForm.setDefendMode(Integer.valueOf(cacheServerRFADefenseMode));
                    }
                    if (!ZoneImportParserUtil.isEmptyString(cacheServerRFADefenseThreshold)) {
                        dnsDefendPolicyForm.setAlertRate(Integer.valueOf(cacheServerRFADefenseThreshold));
                    }
                } else {
                    dnsDefendPolicyForm.setDnsFloodEnable(false);
                }
            }
            if (TRUE.equals(authorizationServerEnable)) {
                dnsDefendPolicyForm.setDnsAuthServerEnable(true);
                if (TRUE.equals(authDefenseEnable)) {
                    dnsDefendPolicyForm.setDnsFloodEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(authDefenseMode)) {
                        dnsDefendPolicyForm.setDefendMode(Integer.valueOf(authDefenseMode));
                    }
                    if (!ZoneImportParserUtil.isEmptyString(authDefenseThreshold)) {
                        dnsDefendPolicyForm.setAlertRate(Integer.valueOf(authDefenseThreshold));
                    }
                } else {
                    dnsDefendPolicyForm.setDnsFloodEnable(false);
                }
            }
            if (TRUE.equals(replyRFADefenseEnable)) {
                dnsDefendPolicyForm.setReplyFloodEnable(true);
                dnsDefendPolicyForm.setReplyFloodSrcDectectEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(replyRFADefenseThreshold)) {
                    dnsDefendPolicyForm.setReplyFloodAlertRate(Integer.valueOf(replyRFADefenseThreshold));
                }
            } else {
                dnsDefendPolicyForm.setReplyFloodEnable(false);
                dnsDefendPolicyForm.setReplyFloodSrcDectectEnable(false);
            }
            if (TRUE.equals(nxdomainEnable)) {
                dnsDefendPolicyForm.setNoSuchNameCheckEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(nxdomain)) {
                    dnsDefendPolicyForm.setNoSuchNameCheckAlertRatio(Integer.valueOf(nxdomain));
                }
            } else {
                dnsDefendPolicyForm.setNoSuchNameCheckEnable(false);
            }
            if (TRUE.equals(malformedEnable)) {
                dnsDefendPolicyForm.setFormatCheckEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(malformedThreshold)) {
                    dnsDefendPolicyForm.setFormatCheckRatio(Integer.valueOf(malformedThreshold));
                }
            } else {
                dnsDefendPolicyForm.setFormatCheckEnable(false);
            }
            if (TRUE.equals(limitingEnable)) {
                dnsDefendPolicyForm.setDnsRequestMessageLenLimitEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(limitingThreshold)) {
                    dnsDefendPolicyForm.setDnsRequestMessageLen(Integer.valueOf(limitingThreshold));
                }
            } else {
                dnsDefendPolicyForm.setDnsRequestMessageLenLimitEnable(false);
            }
            if (TRUE.equals(replyLimitingEnable)) {
                dnsDefendPolicyForm.setDnsReponseMessageLenLimitEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(replyLimitingThreshold)) {
                    dnsDefendPolicyForm.setDnsResponseMessageLen(Integer.valueOf(replyLimitingThreshold));
                }
            } else {
                dnsDefendPolicyForm.setDnsReponseMessageLenLimitEnable(false);
            }
            if (TRUE.equals(dnsFirestPacketCheck)) {
                dnsDefendPolicyForm.setDnsEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(dnsFirestPacketCheckInterval)) {
                    String[] synInterVals = dnsFirestPacketCheckInterval.split("-");
                    dnsDefendPolicyForm.setDnsLowerLimit(Integer.valueOf(synInterVals[0]));
                    dnsDefendPolicyForm.setDnsUpperLimit(Integer.valueOf(synInterVals[1]));
                }
            } else {
                dnsDefendPolicyForm.setDnsEnable(false);
            }
        } else {
            dnsDefendPolicyForm.setDnsDefendEnable(false);
        }
        return dnsDefendPolicyForm;
    }

    private static TcpDefendPolicyForm tcpParse(Element elementPolicy) {
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        tcpDefendPolicyForm.setDirection(1);
        String blockEnable = elementPolicy.elementText("block-enable");
        String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
        String tcpTrafficLimitingEnable = elementPolicy.elementText("tcp-traffic-limiting-enable");
        String tcpTrafficLimitingThreshold = elementPolicy.elementText("tcp-traffic-limiting-threshold");
        String tcpFragmentTrafficLimitingEnable = elementPolicy.elementText("tcp-fragment-traffic-limiting-enable");
        String trafficLimitingThreshold = elementPolicy.elementText("tcp-fragment-traffic-limiting-threshold");
        String tcpNewDestSessionLimitingEnable = elementPolicy.elementText("tcp-new-dest-session-limiting-enable");
        String tcpNewDestSessionLimitingThreshold = elementPolicy.elementText("tcp-new-dest-session-limiting-threshold");
        String defenseEnable = elementPolicy.elementText("defense-enable");
        String tcpDefenseEnable = elementPolicy.elementText("tcp-abnormal-defense-enable");
        String tcpDefenseThreshold = elementPolicy.elementText("tcp-abnormal-defense-threshold");
        String tcpBasicDefenseEnable = elementPolicy.elementText("tcp-basic-defense-enable");
        String synFloodAttackDefenseEnable = elementPolicy.elementText("syn-flood-attack-defense-enable");
        String synFloodAttackDefenseFirstPacketCheckEnable = elementPolicy.elementText("syn-flood-attack-defense-first-packet-check-enable");
        String synFloodAttackDefenseFirstPacketCheckInterval = elementPolicy.elementText("syn-flood-attack-defense-first-packet-check-interval");
        String synFloodAttackDefenseThreshold = elementPolicy.elementText("syn-flood-attack-defense-threshold");
        String synflooddefendmodeEnable = elementPolicy.elementText("syn-flood-attack-defense-auth-enable");
        String synfloodMode = elementPolicy.elementText("syn-flood-attack-defense-auth-mode");
        String synRationLimiteEnable = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-enable");
        String synRationLimiteThreshold = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-threshold");
        String synRationLimitecycle = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-cycle");
        String synRationLimitePacketsThreshold = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-packets-threshold");
        String synRationLimitePacketscycle = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-packets-cycle");
        String synAckFloodEnable = elementPolicy.elementText("synack-flood-attack-defense-enable");
        String synAckFloodAlertRate = elementPolicy.elementText("synack-flood-attack-defense-threshold");
        String synAckSourceEnable = elementPolicy.elementText("synack-flood-attack-defense-source-enable");
        String synAckFirstPacketCheckEnable = elementPolicy.elementText("synack-flood-attack-defense-first-packet-check-enable");
        String synAckLimit = elementPolicy.elementText("synack-flood-attack-defense-first-packet-check-interval");
        String synAckIllegalSessionEnable = elementPolicy.elementText("synack-flood-abnormal-session-check-enable");
        String synAckIllegalConnCount = elementPolicy.elementText("synack-flood-abnormal-session-check-threshold");
        String synAckIllegalConnCountInterval = elementPolicy.elementText("synack-flood-abnormal-session-check-interval");
        String synAckIllegalConnNum = elementPolicy.elementText("synack-flood-minimum-packets-per-connection-num");
        String synAckIllegalConnNumInterval = elementPolicy.elementText("synack-flood--minimum-packets-per-connection-interval");
        String ackDefenseEnable = elementPolicy.elementText("ack-flood-attack-defense-enable");
        String ackDefenseMode = elementPolicy.elementText("ack-flood-attack-defense-mode");
        String ackDefenseThreshold = elementPolicy.elementText("ack-flood-attack-defense-threshold");
        String tcpFragmentAttackDefenseEnable = elementPolicy.elementText("tcp-fragment-attack-defense-enable");
        String tcpFragmentAattackDefenseTthreshold = elementPolicy.elementText("tcp-fragment-attack-defense-threshold");
        String finDefenseEnable = elementPolicy.elementText("fin-flood-attack-defense-enable");
        String finDefenseThreshold = elementPolicy.elementText("fin-flood-attack-defense-threshold");
        String tcpFirestPacketCheck = elementPolicy.elementText("tcp-first-packet-check-enable");
        String tcpFirestPacketCheckInterval = elementPolicy.elementText("tcp-first-packet-check-interval");
        String sourceIpLimitingEnable = elementPolicy.elementText("source-ip-tcp-ratio-anomaly-limiting-enable");
        String sourceIpLimitingThreshold = elementPolicy.elementText("source-ip-tcp-ratio-anomaly-limiting-threshold");
        String tcpConnectionDefenseEnable = elementPolicy.elementText("tcp-connection-flood-attack-defense-enable");
        String destinationIpAddressThreshold = elementPolicy.elementText("concurrent-connection-check-by-destination-ip-address-threshold");
        String newDestinationIpAddressThreshold = elementPolicy.elementText("new-connection-rate-check-by-destination-ip-address-threshold");
        String newSourceIpAddressEnable = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-enable");
        String newSourceIpAddressThreshold = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-threshold");
        String newSourceIpAddressCheckCycle = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-check-cycle");
        String sourceIpAddressEnable = elementPolicy.elementText("connection-number-check-for-source-ip-address-enable");
        String sourceIpAddressThreshold = elementPolicy.elementText("connection-number-check-for-source-ip-address-threshold");
        String abnormalSessionCheckEnable = elementPolicy.elementText("abnormal-session-check-enable");
        String abnormalSessionCheckThreshold = elementPolicy.elementText("abnormal-session-check-threshold");
        String abnormalSessionCheckCheckCycle = elementPolicy.elementText("abnormal-session-check-check-cycle");
        String connectionCheckEnable = elementPolicy.elementText("null-connection-check-enable");
        String connectionCheckMinimumPacketsPerConnection = elementPolicy.elementText("null-connection-check-minimum-packets-per-connection");
        String connectionCheckCheckCycle = elementPolicy.elementText("null-connection-check-check-cycle");
        String retransmissionSessionCheckEnable = elementPolicy.elementText("retransmission-session-check-enable");
        String packetNumberThreshold = elementPolicy.elementText("retransmission-session-check-retransmission-packet-number-threshold");
        String sockstressEnable = elementPolicy.elementText("sockstress-enable");
        String windowSizeThreshold = elementPolicy.elementText("sockstress-tcp-window-size-threshold");
        String sessionCheckEnable = elementPolicy.elementText("session-check-enable");
        String sessionConnRate = elementPolicy.elementText("session-conn-rate");
        String sessionCheckDuration = elementPolicy.elementText("session-check-duration");
        String ackCheckEnable = elementPolicy.elementText("ack-check-enable");
        String ackMinPacketsNum = elementPolicy.elementText("ack-min-packets-num");
        String bigPacketLength = elementPolicy.elementText("big-packet-length");
        String bigPacketRatio = elementPolicy.elementText("big-packet-ratio");
        String synCheckEnable = elementPolicy.elementText("syn-check-enable");
        String synPacketsNum = elementPolicy.elementText("syn-packets-num");
        String synratioLimitPackets = elementPolicy.elementText("syn-ratio-Limit-packets");
        String synBlackListEnable = elementPolicy.elementText("syn-blackList-enable");
        String synExceptionTimes = elementPolicy.elementText("syn-exception-times");
        String synTotalCheckTimes = elementPolicy.elementText("syn-total-check-times");
        if (TRUE.equals(blockEnable)) {
            tcpDefendPolicyForm.setTcpBlock(true);
            tcpDefendPolicyForm.setTcpLimitEnable(false);
            tcpDefendPolicyForm.setTcpDefendEnable(false);
        } else {
            boolean mark;
            tcpDefendPolicyForm.setTcpBlock(false);
            if (TRUE.equals(trafficLimitingEnable)) {
                tcpDefendPolicyForm.setTcpLimitEnable(true);
            } else {
                tcpDefendPolicyForm.setTcpLimitEnable(false);
            }
            if (TRUE.equals(tcpTrafficLimitingEnable)) {
                tcpDefendPolicyForm.setTcpLimitSubEnable(true);
            } else {
                tcpDefendPolicyForm.setTcpLimitSubEnable(false);
            }
            if (!ZoneImportParserUtil.isEmptyString(tcpTrafficLimitingThreshold)) {
                tcpDefendPolicyForm.setMaxSpeed(Integer.valueOf(tcpTrafficLimitingThreshold));
            }
            if (TRUE.equals(tcpFragmentTrafficLimitingEnable)) {
                tcpDefendPolicyForm.setTcpFragLimitEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                    tcpDefendPolicyForm.setFragMaxSpeed(Integer.valueOf(trafficLimitingThreshold));
                }
            } else {
                tcpDefendPolicyForm.setTcpFragLimitEnable(false);
            }
            if (TRUE.equals(tcpNewDestSessionLimitingEnable)) {
                tcpDefendPolicyForm.setTcpNewDestSessionLimitEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(tcpNewDestSessionLimitingThreshold)) {
                    tcpDefendPolicyForm.setTcpNewDestSessionLimit(Long.valueOf(tcpNewDestSessionLimitingThreshold));
                }
            } else {
                tcpDefendPolicyForm.setTcpNewDestSessionLimitEnable(false);
            }
            if (TRUE.equals(defenseEnable)) {
                tcpDefendPolicyForm.setTcpDefendEnable(true);
            } else {
                tcpDefendPolicyForm.setTcpDefendEnable(false);
            }
            if (TRUE.equals(tcpDefenseEnable)) {
                tcpDefendPolicyForm.setTcpAbnormalEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(tcpDefenseThreshold)) {
                    tcpDefendPolicyForm.setTcpAbnormalAlertRate(Integer.valueOf(tcpDefenseThreshold));
                }
            } else {
                tcpDefendPolicyForm.setTcpAbnormalEnable(false);
            }
            boolean tcpBasic = false;
            if (TRUE.equals(tcpBasicDefenseEnable)) {
                tcpBasic = true;
                tcpDefendPolicyForm.setTcpBasicEnable(true);
            } else {
                tcpBasic = false;
                tcpDefendPolicyForm.setTcpBasicEnable(false);
            }
            if (tcpBasic && TRUE.equals(synFloodAttackDefenseEnable)) {
                tcpDefendPolicyForm.setSynfloodEnable(true);
                mark = false;
                if (TRUE.equals(synFloodAttackDefenseFirstPacketCheckEnable)) {
                    tcpDefendPolicyForm.setSynFirstPacketCheckEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(synFloodAttackDefenseFirstPacketCheckInterval)) {
                        String[] synFloodAttackDefenseInterval = synFloodAttackDefenseFirstPacketCheckInterval.split("-");
                        tcpDefendPolicyForm.setFirstPacketCheckLowerLimit(Integer.valueOf(synFloodAttackDefenseInterval[0]));
                        tcpDefendPolicyForm.setFirstPacketCheckUpperLimit(Integer.valueOf(synFloodAttackDefenseInterval[1]));
                    } else {
                        tcpDefendPolicyForm.setFirstPacketCheckLowerLimit(2);
                        tcpDefendPolicyForm.setFirstPacketCheckUpperLimit(6);
                    }
                } else {
                    tcpDefendPolicyForm.setSynFirstPacketCheckEnable(false);
                    mark = true;
                }
                tcpDefendPolicyForm.setSynfloodAlertRate(Integer.valueOf(synFloodAttackDefenseThreshold));
                if ("0".equals(synfloodMode) || TRUE.equals(synfloodMode)) {
                    tcpDefendPolicyForm.setSynFloodDefendModeEnable(true);
                    tcpDefendPolicyForm.setSynfloodMode(Integer.valueOf(synfloodMode));
                } else if (TRUE.equals(synflooddefendmodeEnable)) {
                    tcpDefendPolicyForm.setSynFloodDefendModeEnable(true);
                    tcpDefendPolicyForm.setSynfloodMode(1);
                }
                if (mark && (null == tcpDefendPolicyForm.getSynFloodDefendModeEnable() || !tcpDefendPolicyForm.getSynFloodDefendModeEnable().booleanValue())) {
                    tcpDefendPolicyForm.setSynFloodDefendModeEnable(true);
                    tcpDefendPolicyForm.setSynfloodMode(1);
                }
            } else {
                tcpDefendPolicyForm.setSynfloodEnable(false);
            }
            if (tcpBasic && TRUE.equals(synRationLimiteEnable)) {
                tcpDefendPolicyForm.setSynratioEnable(true);
                if (ZoneImportParserUtil.isEmptyString(synratioLimitPackets)) {
                    tcpDefendPolicyForm.setSynratioLimitPackets(PolicyDefaultValueUtil.paraDefault("synratioLimitPackets"));
                } else {
                    tcpDefendPolicyForm.setSynratioLimitPackets(Integer.valueOf(synratioLimitPackets));
                }
                if (!ZoneImportParserUtil.isEmptyString(synRationLimiteThreshold)) {
                    tcpDefendPolicyForm.setSynratioLimitRate(Integer.valueOf(synRationLimiteThreshold));
                }
                if (!ZoneImportParserUtil.isEmptyString(synRationLimitecycle)) {
                    tcpDefendPolicyForm.setSynratioDuration(Integer.valueOf(synRationLimitecycle));
                }
                if (!ZoneImportParserUtil.isEmptyString(synRationLimitePacketsThreshold)) {
                    tcpDefendPolicyForm.setSynMaxPackets(Integer.valueOf(synRationLimitePacketsThreshold));
                }
                if (!ZoneImportParserUtil.isEmptyString(synRationLimitePacketscycle)) {
                    tcpDefendPolicyForm.setSynMaxPacketsDuration(Integer.valueOf(synRationLimitePacketscycle));
                }
            } else {
                tcpDefendPolicyForm.setSynratioEnable(false);
            }
            if (tcpBasic && TRUE.equals(synAckFloodEnable)) {
                tcpDefendPolicyForm.setSynAckFloodEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(synAckFloodAlertRate) && Pattern.matches("^[1-9]\\d{0,7}$", synAckFloodAlertRate)) {
                    tcpDefendPolicyForm.setSynAckFloodAlertRate(Integer.valueOf(synAckFloodAlertRate));
                }
                mark = false;
                if (TRUE.equals(synAckSourceEnable)) {
                    tcpDefendPolicyForm.setSynAckSourceEnable(true);
                } else {
                    tcpDefendPolicyForm.setSynAckSourceEnable(false);
                    mark = true;
                }
                if (TRUE.equals(synAckFirstPacketCheckEnable)) {
                    String[] synAckLimits;
                    tcpDefendPolicyForm.setSynAckFirstPacketCheckEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(synAckLimit) && Pattern.matches("^\\d{1,2}\\-[1-9][0-9]?$", synAckLimit) && !"00".equals((synAckLimits = synAckLimit.split("-"))[0]) && CheckImportXml.isRangeZero20(synAckLimits[0]) && CheckImportXml.isRange20(synAckLimits[1]) && Integer.parseInt(synAckLimits[0]) < Integer.parseInt(synAckLimits[1])) {
                        tcpDefendPolicyForm.setSynAckLowerLimit(Integer.valueOf(synAckLimits[0]));
                        tcpDefendPolicyForm.setSynAckUpperLimit(Integer.valueOf(synAckLimits[1]));
                    }
                } else {
                    tcpDefendPolicyForm.setSynAckFirstPacketCheckEnable(false);
                    mark = true;
                }
                if (mark) {
                    tcpDefendPolicyForm.setSynAckSourceEnable(true);
                }
                ZoneImportParserUtil.tcpDefendPolicySynFloodIllegalSession(tcpDefendPolicyForm, synAckIllegalSessionEnable, synAckIllegalConnCount, synAckIllegalConnCountInterval, synAckIllegalConnNum, synAckIllegalConnNumInterval);
            }
            if (tcpBasic && TRUE.equals(ackDefenseEnable)) {
                tcpDefendPolicyForm.setAckFloodEnable(true);
                String string = ackDefenseMode = ZoneImportParserUtil.isEmptyString(ackDefenseMode) ? Constant.ACK_FLOODMODE_BASIC.toString() : ackDefenseMode;
                if (!ZoneImportParserUtil.isEmptyString(ackDefenseThreshold)) {
                    tcpDefendPolicyForm.setAckFloodMode(Integer.valueOf(ackDefenseMode));
                    tcpDefendPolicyForm.setAckFloodAlertRate(Integer.valueOf(ackDefenseThreshold));
                }
            } else {
                tcpDefendPolicyForm.setAckFloodEnable(false);
            }
            if (tcpBasic && TRUE.equals(tcpFragmentAttackDefenseEnable)) {
                tcpDefendPolicyForm.setTcpFragEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(tcpFragmentAattackDefenseTthreshold)) {
                    tcpDefendPolicyForm.setTcpFragAlertRate(Integer.valueOf(tcpFragmentAattackDefenseTthreshold));
                }
            } else {
                tcpDefendPolicyForm.setTcpFragEnable(false);
            }
            if (tcpBasic && TRUE.equals(finDefenseEnable)) {
                tcpDefendPolicyForm.setFinRstFloodEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(finDefenseThreshold)) {
                    tcpDefendPolicyForm.setFinRstFloodAlertRate(Integer.valueOf(finDefenseThreshold));
                }
            } else {
                tcpDefendPolicyForm.setFinRstFloodEnable(false);
            }
            if (tcpBasic && TRUE.equals(tcpFirestPacketCheck)) {
                tcpDefendPolicyForm.setTcpEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(tcpFirestPacketCheckInterval)) {
                    String[] synInterVals = tcpFirestPacketCheckInterval.split("-");
                    tcpDefendPolicyForm.setTcpLowerLimit(Integer.valueOf(synInterVals[0]));
                    tcpDefendPolicyForm.setTcpUpperLimit(Integer.valueOf(synInterVals[1]));
                }
            } else {
                tcpDefendPolicyForm.setTcpEnable(false);
            }
            if (tcpBasic && TRUE.equals(sourceIpLimitingEnable)) {
                tcpDefendPolicyForm.setTcpratioEnable(true);
                tcpDefendPolicyForm.setTcpratioLimitMode(1);
                tcpDefendPolicyForm.setTcpratioProtion(20);
                if (!ZoneImportParserUtil.isEmptyString(sourceIpLimitingThreshold)) {
                    tcpDefendPolicyForm.setTcpratioLimitRate(Integer.valueOf(sourceIpLimitingThreshold));
                }
            } else {
                tcpDefendPolicyForm.setTcpratioEnable(false);
            }
            if (TRUE.equals(tcpConnectionDefenseEnable)) {
                tcpDefendPolicyForm.setTcpConnEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(destinationIpAddressThreshold)) {
                    tcpDefendPolicyForm.setTcpDesttipNum(Integer.valueOf(destinationIpAddressThreshold));
                }
                if (!ZoneImportParserUtil.isEmptyString(newDestinationIpAddressThreshold)) {
                    tcpDefendPolicyForm.setTcpNewDestipRate(Integer.valueOf(newDestinationIpAddressThreshold));
                }
            } else {
                tcpDefendPolicyForm.setTcpConnEnable(false);
            }
            if (TRUE.equals(newSourceIpAddressEnable)) {
                tcpDefendPolicyForm.setTcpNewSrctipEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(newSourceIpAddressThreshold)) {
                    tcpDefendPolicyForm.setTcpNewSrctipRate(Integer.valueOf(newSourceIpAddressThreshold));
                }
                if (!ZoneImportParserUtil.isEmptyString(newSourceIpAddressCheckCycle)) {
                    tcpDefendPolicyForm.setTcpNewSrctipInterval(Integer.valueOf(newSourceIpAddressCheckCycle));
                }
            } else {
                tcpDefendPolicyForm.setTcpNewSrctipEnable(false);
            }
            if (TRUE.equals(sourceIpAddressEnable)) {
                tcpDefendPolicyForm.setTcpSrctipEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(sourceIpAddressThreshold)) {
                    tcpDefendPolicyForm.setTcpSrctipNum(Integer.valueOf(sourceIpAddressThreshold));
                }
            } else {
                tcpDefendPolicyForm.setTcpSrctipEnable(false);
            }
            if (TRUE.equals(abnormalSessionCheckEnable)) {
                tcpDefendPolicyForm.setIllegalSessionEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(abnormalSessionCheckThreshold)) {
                    tcpDefendPolicyForm.setIllegalConnCount(Integer.valueOf(abnormalSessionCheckThreshold));
                }
                if (!ZoneImportParserUtil.isEmptyString(abnormalSessionCheckCheckCycle)) {
                    tcpDefendPolicyForm.setIllegalConnCountInterval(Integer.valueOf(abnormalSessionCheckCheckCycle));
                }
            } else {
                tcpDefendPolicyForm.setIllegalSessionEnable(false);
            }
            if (TRUE.equals(connectionCheckEnable)) {
                tcpDefendPolicyForm.setIllegalMinConnNumEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(connectionCheckMinimumPacketsPerConnection)) {
                    tcpDefendPolicyForm.setIllegalConnNum(Integer.valueOf(connectionCheckMinimumPacketsPerConnection));
                }
                if (!ZoneImportParserUtil.isEmptyString(connectionCheckCheckCycle)) {
                    tcpDefendPolicyForm.setIllegalConnNumInterval(Integer.valueOf(connectionCheckCheckCycle));
                }
            } else {
                tcpDefendPolicyForm.setIllegalMinConnNumEnable(false);
            }
            if (TRUE.equals(retransmissionSessionCheckEnable)) {
                tcpDefendPolicyForm.setSackCheckEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(packetNumberThreshold)) {
                    tcpDefendPolicyForm.setSackCheckMaxNumber(Integer.valueOf(packetNumberThreshold));
                }
            } else {
                tcpDefendPolicyForm.setSackCheckEnable(false);
            }
            if (TRUE.equals(sockstressEnable)) {
                tcpDefendPolicyForm.setWindowSizeCheckEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(windowSizeThreshold)) {
                    tcpDefendPolicyForm.setWindowSize(Integer.valueOf(windowSizeThreshold));
                }
            } else {
                tcpDefendPolicyForm.setWindowSizeCheckEnable(false);
            }
            if (TRUE.equals(sessionCheckEnable)) {
                tcpDefendPolicyForm.setSessionCheckEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(sessionConnRate)) {
                    tcpDefendPolicyForm.setSessionConnRate(Integer.valueOf(sessionConnRate));
                }
                if (!ZoneImportParserUtil.isEmptyString(sessionCheckDuration)) {
                    tcpDefendPolicyForm.setSessionCheckDuration(Integer.valueOf(sessionCheckDuration));
                }
            } else {
                tcpDefendPolicyForm.setSessionCheckEnable(false);
            }
            if (TRUE.equals(ackCheckEnable)) {
                tcpDefendPolicyForm.setAckCheckEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(sessionConnRate)) {
                    tcpDefendPolicyForm.setAckMinPacketsNum(Integer.valueOf(ackMinPacketsNum));
                }
                if (!ZoneImportParserUtil.isEmptyString(bigPacketLength)) {
                    tcpDefendPolicyForm.setBigPacketLength(Integer.valueOf(bigPacketLength));
                }
                if (!ZoneImportParserUtil.isEmptyString(bigPacketRatio)) {
                    tcpDefendPolicyForm.setBigPacketRatio(Integer.valueOf(bigPacketRatio));
                }
            } else {
                tcpDefendPolicyForm.setAckCheckEnable(false);
            }
            if (TRUE.equals(synCheckEnable)) {
                tcpDefendPolicyForm.setSynCheckEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(synPacketsNum)) {
                    tcpDefendPolicyForm.setSynPacketsNum(Integer.valueOf(synPacketsNum));
                }
            } else {
                tcpDefendPolicyForm.setSynCheckEnable(false);
            }
            if (TRUE.equals(synBlackListEnable)) {
                tcpDefendPolicyForm.setSynBlackListEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(synExceptionTimes)) {
                    tcpDefendPolicyForm.setSynExceptionTimes(Integer.valueOf(synExceptionTimes));
                }
                if (!ZoneImportParserUtil.isEmptyString(synTotalCheckTimes)) {
                    tcpDefendPolicyForm.setSynTotalCheckTimes(Integer.valueOf(synTotalCheckTimes));
                }
            } else {
                tcpDefendPolicyForm.setSynBlackListEnable(false);
            }
        }
        return tcpDefendPolicyForm;
    }

    private static void tcpDefendPolicySynFloodIllegalSession(TcpDefendPolicyForm tcpDefendPolicyForm, String synAckIllegalSessionEnable, String synAckIllegalConnCount, String synAckIllegalConnCountInterval, String synAckIllegalConnNum, String synAckIllegalConnNumInterval) {
        if (TRUE.equals(synAckIllegalSessionEnable)) {
            tcpDefendPolicyForm.setSynAckIllegalSessionEnable(true);
        }
        if (!ZoneImportParserUtil.isEmptyString(synAckIllegalConnCount)) {
            tcpDefendPolicyForm.setSynAckIllegalConnCount(Integer.valueOf(synAckIllegalConnCount));
        }
        if (!ZoneImportParserUtil.isEmptyString(synAckIllegalConnCountInterval)) {
            tcpDefendPolicyForm.setSynAckIllegalConnCountInterval(Integer.valueOf(synAckIllegalConnCountInterval));
        }
        if (!ZoneImportParserUtil.isEmptyString(synAckIllegalConnNum)) {
            tcpDefendPolicyForm.setSynAckIllegalConnNum(Integer.valueOf(synAckIllegalConnNum));
        }
        if (!ZoneImportParserUtil.isEmptyString(synAckIllegalConnNumInterval)) {
            tcpDefendPolicyForm.setSynAckIllegalConnNumInterval(Integer.valueOf(synAckIllegalConnNumInterval));
        } else {
            tcpDefendPolicyForm.setSynAckIllegalSessionEnable(false);
        }
    }

    private static List<ZonePolicyApplyForm> parseZoneInfo(Element root, List<ZonePolicyApplyForm> zoneFormList) {
        if (null == root) {
            return zoneFormList;
        }
        List elementsList = root.element("zone-list").elements("zone");
        if (null != elementsList && !elementsList.isEmpty()) {
            for (Element element : elementsList) {
                List elementZonWhiteList;
                Element elementWhitePolicyList;
                Object elementZoneBlack2;
                List elementZoneBlackList;
                Element elementBlackPolicyList;
                List elementfLocationList;
                List inboundElementfilterList;
                List elementZonePortMapList;
                String ipAddress;
                String regName;
                ZonePolicyApplyForm zonePolicyApplyForm = new ZonePolicyApplyForm();
                Element elementZoneInfo = element.element("zone-info");
                String zoneInfoAccount = elementZoneInfo.elementText("account");
                String zoneInfoType = elementZoneInfo.elementText("type");
                String zoneInfoName = elementZoneInfo.elementText("name");
                String zoneInfoContact = elementZoneInfo.elementText("contact");
                String zoneInfoPhone = elementZoneInfo.elementText("phone");
                String zoneInfoMobilePhone = elementZoneInfo.elementText("mobile-phone");
                String zoneInfoIndustry = elementZoneInfo.elementText("industry");
                String zoneInfoPostCode = elementZoneInfo.elementText("post-code");
                String zoneInfoEmail = elementZoneInfo.elementText("email");
                String zoneInfoAddress = elementZoneInfo.elementText("address");
                String zoneInfoDescription = elementZoneInfo.elementText("description");
                ZoneInfoForm zoneInfoForm = new ZoneInfoForm();
                zoneInfoForm.setZoneName(zoneInfoAccount);
                if (!ZoneImportParserUtil.isEmptyString(zoneInfoType)) {
                    zoneInfoForm.setZoneType(Integer.valueOf(zoneInfoType));
                }
                if (!zoneInfoName.matches(regName = "^(?!null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$")) {
                    LOG.error((Object)"zoneInfoName type error");
                    throw new LegoCheckedException(571981L);
                }
                zoneInfoForm.setZoneDesc(zoneInfoName);
                zoneInfoForm.setContact(zoneInfoContact);
                zoneInfoForm.setTelephone(zoneInfoPhone);
                zoneInfoForm.setMobile(zoneInfoMobilePhone);
                if (!ZoneImportParserUtil.isEmptyString(zoneInfoIndustry)) {
                    zoneInfoForm.setIndustry(zoneInfoIndustry);
                }
                zoneInfoForm.setPost(zoneInfoPostCode);
                zoneInfoForm.setEmail(zoneInfoEmail);
                zoneInfoForm.setAddress(zoneInfoAddress);
                zoneInfoForm.setRemark(zoneInfoDescription);
                zonePolicyApplyForm.setZoneInfoForm(zoneInfoForm);
                ZoneImportParserUtil.parserFaultSeverityRule(zonePolicyApplyForm, element, true);
                List elementZoneIpList = element.element("zone-ip-list").elements("zone-ip");
                ArrayList<ZoneListIpForm> zoneListIpFormList = new ArrayList<ZoneListIpForm>();
                if (null != elementZoneIpList && !elementZoneIpList.isEmpty()) {
                    for (Element elementIp : elementZoneIpList) {
                        Iterator ipType = elementIp.elementText("ip-type");
                        String maskType = elementIp.elementText("mask-type");
                        ipAddress = elementIp.elementText("ip-address");
                        String subnetMask = elementIp.elementText("subnet-mask");
                        String startIp = elementIp.elementText("start-ip");
                        String endIp = elementIp.elementText("end-ip");
                        ZoneListIpForm zoneListIpForm = new ZoneListIpForm();
                        zoneListIpForm.setDeleteFlag(0);
                        if (!ZoneImportParserUtil.isEmptyString(ipType)) {
                            zoneListIpForm.setIpType(Integer.parseInt(ipType));
                        }
                        if (!ZoneImportParserUtil.isEmptyString(maskType)) {
                            zoneListIpForm.setMaskType(Integer.parseInt(maskType));
                        }
                        if (!ZoneImportParserUtil.isEmptyString(subnetMask)) {
                            zoneListIpForm.setIntMask(Integer.parseInt(subnetMask));
                        }
                        if (ZoneImportParserUtil.isEmptyString(ipType) || ZoneImportParserUtil.isEmptyString(maskType)) continue;
                        zoneListIpForm.setZoneIp(ipAddress);
                        zoneListIpForm.setStartIp(startIp);
                        zoneListIpForm.setEndIp(endIp);
                        zoneListIpFormList.add(zoneListIpForm);
                    }
                }
                zoneInfoForm.setZoneListIpFormList(zoneListIpFormList);
                zonePolicyApplyForm.setZoneInfoForm(zoneInfoForm);
                if (null != element.element("zone-port-map-list") && null != (elementZonePortMapList = element.element("zone-port-map-list").elements("zone-port-map")) && !elementZonePortMapList.isEmpty()) {
                    ArrayList<ZonePortMapForm> zoneListPortMapFormList = new ArrayList<ZonePortMapForm>();
                    for (Element elementPortMap : elementZonePortMapList) {
                        ipAddress = elementPortMap.elementText("ip-address");
                        String ipPort = elementPortMap.elementText("ip-port");
                        String protocol = elementPortMap.elementText("protocol");
                        ZonePortMapForm zonePortMapForm = new ZonePortMapForm();
                        if (ZoneImportParserUtil.isEmptyString(ipAddress) || ZoneImportParserUtil.isEmptyString(ipPort) || ZoneImportParserUtil.isEmptyString(protocol) || !POLICY_PROTOCOL_HTTP.equals(protocol) || !IPUtil.isIpv4((String)ipAddress) && !IPUtil.isIpv6((String)ipAddress)) continue;
                        zonePortMapForm.setIpAddress(ipAddress);
                        zonePortMapForm.setIpPort(Integer.parseInt(ipPort));
                        zonePortMapForm.setProtocol(protocol);
                        zonePortMapForm.setDeleteFlag(0);
                        zoneListPortMapFormList.add(zonePortMapForm);
                    }
                    zoneInfoForm.setZonePortMapFormList(zoneListPortMapFormList);
                    zonePolicyApplyForm.setZoneInfoForm(zoneInfoForm);
                }
                List elementZoneDeviceList = element.element("zone-device-list").elements("zone-device");
                ArrayList<ZoneDeviceForm> zoneDeviceForms = new ArrayList<ZoneDeviceForm>();
                if (null != elementZoneDeviceList && !elementZoneDeviceList.isEmpty()) {
                    for (Element elementDevice : elementZoneDeviceList) {
                        ZoneDeviceForm zoneDeviceForm = new ZoneDeviceForm();
                        String deviceIp = elementDevice.elementText("device-ip");
                        String vpnName = elementDevice.elementText("vpn-name");
                        zoneDeviceForm.setDeviceIp(deviceIp);
                        zoneDeviceForm.setVpnName(vpnName);
                        zoneDeviceForms.add(zoneDeviceForm);
                    }
                }
                zonePolicyApplyForm.setZoneDeviceForms(zoneDeviceForms);
                Element elementModeInfo = element.element("defense-mode-info");
                String trafficDiversionMode = elementModeInfo.elementText("traffic-diversion-mode");
                String defenseMode = elementModeInfo.elementText("defense-mode");
                String dynamicBlacklistMode = elementModeInfo.elementText("dynamic-blacklist-mode");
                String blackholeMode = elementModeInfo.elementText("blackhole-mode");
                String blackholeNotify = elementModeInfo.elementText("blackhole-notify-enable");
                String cleaningBandwidthEnable = elementModeInfo.elementText("cleaning-bandwidth-enable");
                String cleaningBandwidthThreshold = elementModeInfo.elementText("cleaning-bandwidth-threshold");
                String singleIpAddressEnable = elementModeInfo.elementText("traffic-limiting-for-single-ip-address-enable");
                String singleIpAddressThreshold = elementModeInfo.elementText("traffic-limiting-for-single-ip-address-threshold");
                String antiDomainAudit = elementModeInfo.elementText("anti-domain-audit");
                String ipReputationEnable = elementModeInfo.elementText("ipreputation_enable");
                String ipReputationServiceType = elementModeInfo.elementText("ipreputation_service_type");
                String newDestSessionLimitEnable = elementModeInfo.elementText("new_dest_session_limit_enable");
                String newDestSessionLimitThreshold = elementModeInfo.elementText("new_dest_session_limit_threshold");
                String blackholeEnable = elementModeInfo.elementText("blackhole_enable");
                String blackholeThreshold = elementModeInfo.elementText("blackhole_threshold");
                String blackholeType = elementModeInfo.elementText("blackhole_type");
                String filterDropThreshold = elementModeInfo.elementText("filter_drop_thershold");
                if (!ZoneImportParserUtil.isEmptyString(trafficDiversionMode)) {
                    zonePolicyApplyForm.setDivertMode(Integer.valueOf(trafficDiversionMode));
                }
                if (!ZoneImportParserUtil.isEmptyString(defenseMode)) {
                    zonePolicyApplyForm.setDefendMode(Integer.valueOf(defenseMode));
                }
                if (!ZoneImportParserUtil.isEmptyString(dynamicBlacklistMode)) {
                    zonePolicyApplyForm.setDynamicBlackMode(Integer.valueOf(dynamicBlacklistMode));
                }
                if (!ZoneImportParserUtil.isEmptyString(blackholeMode)) {
                    zonePolicyApplyForm.setBlackholeMode(Integer.valueOf(blackholeMode));
                }
                if (!ZoneImportParserUtil.isEmptyString(blackholeNotify)) {
                    zonePolicyApplyForm.setBlackholeNotifyEnable(Integer.valueOf(blackholeNotify));
                }
                if (TRUE.equals(cleaningBandwidthEnable)) {
                    zonePolicyApplyForm.setZoneLimitEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(cleaningBandwidthThreshold)) {
                        zonePolicyApplyForm.setZoneLimitRate(Integer.valueOf(cleaningBandwidthThreshold));
                    }
                } else {
                    zonePolicyApplyForm.setZoneLimitEnable(false);
                }
                if (TRUE.equals(singleIpAddressEnable)) {
                    zonePolicyApplyForm.setIpLimitEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(singleIpAddressThreshold)) {
                        zonePolicyApplyForm.setIpLimit(Integer.valueOf(singleIpAddressThreshold));
                    }
                } else {
                    zonePolicyApplyForm.setIpLimitEnable(false);
                }
                zonePolicyApplyForm.setDosEnable(false);
                if (TRUE.equals(antiDomainAudit)) {
                    zonePolicyApplyForm.setAuditEnable(true);
                } else {
                    zonePolicyApplyForm.setAuditEnable(false);
                }
                if (TRUE.equals(ipReputationEnable)) {
                    zonePolicyApplyForm.setIpReputationEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(ipReputationServiceType)) {
                        zonePolicyApplyForm.setIpReputationServiceType(Integer.parseInt(ipReputationServiceType));
                    }
                } else {
                    zonePolicyApplyForm.setIpReputationEnable(false);
                }
                if (TRUE.equals(newDestSessionLimitEnable)) {
                    zonePolicyApplyForm.setNewDestSessionLimitEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(newDestSessionLimitThreshold)) {
                        zonePolicyApplyForm.setDestSessionLimit(Long.valueOf(newDestSessionLimitThreshold));
                    }
                } else {
                    zonePolicyApplyForm.setNewDestSessionLimitEnable(false);
                }
                if (TRUE.equals(blackholeEnable)) {
                    zonePolicyApplyForm.setBlackholeEnable(true);
                    if (!ZoneImportParserUtil.isEmptyString(blackholeThreshold) && CheckImportXml.isRange10000000(blackholeThreshold)) {
                        zonePolicyApplyForm.setBlackholeThreshold(Long.valueOf(blackholeThreshold));
                    }
                    if (!ZoneImportParserUtil.isEmptyString(blackholeType)) {
                        if (Integer.parseInt(blackholeType) != ZoneConstants.BLACKHOLE_TYPE_ROUTE && Integer.parseInt(blackholeType) != ZoneConstants.BLACKHOLE_TYPE_INTERFACEBOARD && Integer.parseInt(blackholeType) != ZoneConstants.BLACKHOLE_TYPE_API) {
                            LOG.error((Object)"blackhole type error : BLACKHOLE_TYPE_ROUTE = 0; BLACKHOLE_TYPE_INTERFACEBOARD = 1; BLACKHOLE_TYPE_API = 2");
                            throw new LegoCheckedException(571981L);
                        }
                        zonePolicyApplyForm.setBlackholeType(Integer.valueOf(blackholeType));
                    } else {
                        zonePolicyApplyForm.setBlackholeType(ZoneConstants.BLACKHOLE_TYPE_ROUTE);
                    }
                } else {
                    zonePolicyApplyForm.setBlackholeEnable(false);
                }
                if (!ZoneImportParserUtil.isEmptyString(filterDropThreshold)) {
                    zonePolicyApplyForm.setFilterDropThreshold(Long.valueOf(filterDropThreshold));
                }
                if (null != (inboundElementfilterList = element.element("filter-list").elements("filter-name")) && !inboundElementfilterList.isEmpty()) {
                    ArrayList<Long> filterIdList = new ArrayList<Long>();
                    ArrayList<String> filterNameList = new ArrayList<String>();
                    for (Element elementFilter : inboundElementfilterList) {
                        String filterName = elementFilter.getText();
                        filterNameList.add(filterName);
                    }
                    zonePolicyApplyForm.setFilterIdList(filterIdList);
                    zonePolicyApplyForm.setFilterNameList(filterNameList);
                }
                if (null != (elementfLocationList = element.element("location-policy-list").elements("location-policy")) && !elementfLocationList.isEmpty()) {
                    ArrayList<ZoneIpLocationForm> zoneIpLocationList = new ArrayList<ZoneIpLocationForm>();
                    for (Element elementlocation : elementfLocationList) {
                        Object locationNameEn = elementlocation.elementText("location-name");
                        String locationAction = elementlocation.elementText("location-action");
                        String locationLimit = elementlocation.elementText("location-limit");
                        ZoneIpLocationForm zoneIpLocationForm = new ZoneIpLocationForm();
                        if (!ZoneImportParserUtil.isEmptyString((String)locationNameEn)) {
                            if (!"OtherLocation".equalsIgnoreCase((String)locationNameEn) && !((String)locationNameEn).startsWith("/")) {
                                locationNameEn = "/" + (String)locationNameEn;
                            }
                            zoneIpLocationForm.setLocationNameEn((String)locationNameEn);
                        }
                        if (!ZoneImportParserUtil.isEmptyString(locationAction)) {
                            zoneIpLocationForm.setLocationAction(Integer.valueOf(locationAction));
                        }
                        if (!ZoneImportParserUtil.isEmptyString(locationLimit)) {
                            zoneIpLocationForm.setLocationLimit(Integer.valueOf(locationLimit));
                        }
                        zoneIpLocationList.add(zoneIpLocationForm);
                    }
                    zonePolicyApplyForm.setZoneIpLocationList(zoneIpLocationList);
                }
                if (null != (elementBlackPolicyList = element.element("black-policy-list")) && null != (elementZoneBlackList = element.element("black-policy-list").elements("black-list")) && !elementZoneBlackList.isEmpty()) {
                    ArrayList<ZoneBlackWhiteForm> zoneBlackWhiteFormList = new ArrayList<ZoneBlackWhiteForm>();
                    for (Object elementZoneBlack2 : elementZoneBlackList) {
                        String blackListIp = elementZoneBlack2.elementText("black-list-ip");
                        String blackListMask = elementZoneBlack2.elementText("black-list-mask");
                        ZoneBlackWhiteForm zoneBlackWhiteForm = null;
                        if (ZoneImportParserUtil.isEmptyString(blackListIp) || ZoneImportParserUtil.isEmptyString(blackListMask)) continue;
                        zoneBlackWhiteForm = new ZoneBlackWhiteForm();
                        zoneBlackWhiteForm.setIpAddress(blackListIp);
                        zoneBlackWhiteForm.setMask(Integer.valueOf(blackListMask));
                        zoneBlackWhiteForm.setBlackWhiteType(1);
                        zoneBlackWhiteForm.setDeleteFlag(0);
                        zoneBlackWhiteFormList.add(zoneBlackWhiteForm);
                    }
                    zonePolicyApplyForm.setZoneBlackWhiteFormList(zoneBlackWhiteFormList);
                }
                if (null != (elementWhitePolicyList = element.element("white-policy-list")) && null != (elementZonWhiteList = element.element("white-policy-list").elements("white-list")) && !elementZonWhiteList.isEmpty()) {
                    ArrayList<ZoneWhiteForm> zoneWhiteFormList = new ArrayList<ZoneWhiteForm>();
                    elementZoneBlack2 = elementZonWhiteList.iterator();
                    while (elementZoneBlack2.hasNext()) {
                        Element elementZoneWhite = (Element)elementZoneBlack2.next();
                        String whiteListIp = elementZoneWhite.elementText("white-list-ip");
                        String whiteListMask = elementZoneWhite.elementText("white-list-mask");
                        ZoneWhiteForm zoneWhiteForm = null;
                        if (ZoneImportParserUtil.isEmptyString(whiteListIp) || ZoneImportParserUtil.isEmptyString(whiteListMask)) continue;
                        zoneWhiteForm = new ZoneWhiteForm();
                        zoneWhiteForm.setIpAddress(whiteListIp);
                        zoneWhiteForm.setMask(Integer.valueOf(whiteListMask));
                        zoneWhiteForm.setBlackWhiteType(2);
                        zoneWhiteForm.setDeleteFlag(0);
                        zoneWhiteFormList.add(zoneWhiteForm);
                    }
                    zonePolicyApplyForm.setZoneWhiteFormList(zoneWhiteFormList);
                }
                ArrayList<ZoneServiceForm> inboundZoneServices = new ArrayList<ZoneServiceForm>();
                List elementDefensePolicyList = element.element("defense-policy-list").elements("defense-policy");
                if (null != elementDefensePolicyList && !elementDefensePolicyList.isEmpty()) {
                    elementZoneBlack2 = elementDefensePolicyList.iterator();
                    while (elementZoneBlack2.hasNext()) {
                        Element elementlocation = (Element)elementZoneBlack2.next();
                        ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
                        zoneServiceForm.setDirection(1);
                        Element elementBasicInfo = elementlocation.element("basic-info");
                        String name = elementBasicInfo.elementText("name");
                        String deviceIp = elementBasicInfo.elementText("device-ip");
                        String protocol = elementBasicInfo.elementText("protocol");
                        String protocolId = elementBasicInfo.elementText("protocol-id");
                        String ipAddressList = elementBasicInfo.elementText("ip-address-list");
                        String portType = elementBasicInfo.elementText("port-type").trim();
                        String destinationPortList = elementBasicInfo.elementText("destination-port-list");
                        String description = elementBasicInfo.elementText("description");
                        if (AticUtil.validateSpecialStr((String)name)) {
                            zoneServiceForm.setServiceName(name);
                        }
                        zoneServiceForm.setDeviceIp(deviceIp);
                        if (POLICY_PROTOCOL_OTHER.equals(protocol) && !ZoneImportParserUtil.isEmptyString(protocolId)) {
                            zoneServiceForm.setProtocolNum(Integer.valueOf(protocolId));
                        }
                        zoneServiceForm.setProtocol(protocol);
                        zoneServiceForm.setIpList(ipAddressList);
                        if (!ZoneImportParserUtil.isEmptyString(portType) && (portType.equals("0") || portType.equals(TRUE) || portType.equals("2"))) {
                            zoneServiceForm.setPortType(Integer.valueOf(portType));
                        }
                        zoneServiceForm.setPortList(destinationPortList);
                        zoneServiceForm.setDescription(description);
                        List elementPolicyList = elementlocation.element("policy-list").elements("policy");
                        if (null != elementPolicyList && !elementPolicyList.isEmpty()) {
                            for (Element elementPolicy : elementPolicyList) {
                                String sourceIpAddressThreshold;
                                String defenseEnable;
                                String trafficLimitingThreshold;
                                String trafficLimitingEnable;
                                String blockEnable;
                                String trafficLimitingEnable2;
                                String blockEnable2;
                                if (POLICY_PROTOCOL_TCP.equals(protocol)) {
                                    zoneServiceForm.setTcpDefendPolicyForm(ZoneImportParserUtil.portBizParse(elementPolicy));
                                    continue;
                                }
                                if (!POLICY_PROTOCOL_DEFAULT.equals(protocol)) continue;
                                String policyProtocol = elementPolicy.elementText("protocol");
                                if (POLICY_PROTOCOL_TCP.equals(policyProtocol)) {
                                    zoneServiceForm.setTcpDefendPolicyForm(ZoneImportParserUtil.tcpParse(elementPolicy));
                                    continue;
                                }
                                if (POLICY_PROTOCOL_UDP.equals(policyProtocol)) {
                                    UdpDefendPolicyForm udpDefendPolicyForm = new UdpDefendPolicyForm();
                                    udpDefendPolicyForm.setDirection(1);
                                    blockEnable2 = elementPolicy.elementText("block-enable");
                                    trafficLimitingEnable2 = elementPolicy.elementText("traffic-limiting-enable");
                                    String udpTtrafficLimitingEnable = elementPolicy.elementText("udp-traffic-limiting-enable");
                                    String udpTrafficLimitingThreshold = elementPolicy.elementText("udp-traffic-limiting-threshold");
                                    String udpFragmentRateLimitingEnable = elementPolicy.elementText("udp-fragment-rate-limiting-enable");
                                    String udpFragmentRateLimitingThreshold = elementPolicy.elementText("udp-fragment-rate-limiting-threshold");
                                    String udpNewDestSessionLimitingEnable = elementPolicy.elementText("udp-new-dest-session-limiting-enable");
                                    String udpNewDestSessionLimitingThreshold = elementPolicy.elementText("udp-new-dest-session-limiting-threshold");
                                    String defenseEnable2 = elementPolicy.elementText("defense-enable");
                                    String udpAbnormalDefenseEnable = elementPolicy.elementText("udp-abnormal-defense-enable");
                                    String udpAbnormalDefenseThreshold = elementPolicy.elementText("udp-abnormal-defense-threshold");
                                    String udpFloodFingerprintDefenseEnable = elementPolicy.elementText("udp-flood-fingerprint-defense-enable");
                                    String udpFloodFingerprintDefenseThreshold = elementPolicy.elementText("udp-flood-fingerprint-defense-threshold");
                                    String udpFragmentAttackDefenseEnable = elementPolicy.elementText("udp-fragment-attack-defense-enable");
                                    String udpFragmentAttackDefenseThreshold = elementPolicy.elementText("udp-fragment-attack-defense-threshold");
                                    String udpFirstPacketCheckEnable = elementPolicy.elementText("udp-first-packet-check-enable");
                                    String udpUpperLimit = elementPolicy.elementText("udp-first-packet-check-upper-limit");
                                    if (TRUE.equals(blockEnable2)) {
                                        udpDefendPolicyForm.setUdpBlock(true);
                                    }
                                    if (TRUE.equals(trafficLimitingEnable2)) {
                                        udpDefendPolicyForm.setUdpLimitEnable(true);
                                        if (TRUE.equals(udpTtrafficLimitingEnable)) {
                                            udpDefendPolicyForm.setUdpMaxSpeedEnable(true);
                                        } else {
                                            udpDefendPolicyForm.setUdpMaxSpeedEnable(false);
                                        }
                                        if (!ZoneImportParserUtil.isEmptyString(udpTrafficLimitingThreshold)) {
                                            udpDefendPolicyForm.setUdpMaxSpeed(Integer.valueOf(udpTrafficLimitingThreshold));
                                        }
                                        if (TRUE.equals(udpFragmentRateLimitingEnable)) {
                                            udpDefendPolicyForm.setUdpFragMaxSpeedEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(udpFragmentRateLimitingThreshold)) {
                                                udpDefendPolicyForm.setUdpFragMaxSpeed(Integer.valueOf(udpFragmentRateLimitingThreshold));
                                            }
                                        } else {
                                            udpDefendPolicyForm.setUdpFragMaxSpeedEnable(false);
                                        }
                                        if (TRUE.equals(udpNewDestSessionLimitingEnable)) {
                                            udpDefendPolicyForm.setUdpNewDestSessionLimitEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(udpNewDestSessionLimitingThreshold)) {
                                                udpDefendPolicyForm.setUdpNewDestSessionLimit(Long.valueOf(udpNewDestSessionLimitingThreshold));
                                            }
                                        } else {
                                            udpDefendPolicyForm.setUdpNewDestSessionLimitEnable(false);
                                        }
                                    } else {
                                        udpDefendPolicyForm.setUdpLimitEnable(false);
                                    }
                                    if (TRUE.equals(defenseEnable2)) {
                                        udpDefendPolicyForm.setUdpDefendEnable(true);
                                        if (TRUE.equals(udpAbnormalDefenseEnable)) {
                                            udpDefendPolicyForm.setUdpAbnormalEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(udpAbnormalDefenseThreshold)) {
                                                udpDefendPolicyForm.setUdpAbnormalAlertRate(Integer.valueOf(udpAbnormalDefenseThreshold));
                                            }
                                        } else {
                                            udpDefendPolicyForm.setUdpAbnormalEnable(false);
                                        }
                                        if (TRUE.equals(udpFloodFingerprintDefenseEnable)) {
                                            udpDefendPolicyForm.setAlertSpeedEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(udpFloodFingerprintDefenseThreshold)) {
                                                udpDefendPolicyForm.setAlertSpeed(Integer.valueOf(udpFloodFingerprintDefenseThreshold));
                                            }
                                        } else {
                                            udpDefendPolicyForm.setAlertSpeedEnable(false);
                                        }
                                        if (TRUE.equals(udpFragmentAttackDefenseEnable)) {
                                            udpDefendPolicyForm.setFragAlertSpeedEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(udpFragmentAttackDefenseThreshold)) {
                                                udpDefendPolicyForm.setFragAlertSpeed(Integer.valueOf(udpFragmentAttackDefenseThreshold));
                                            }
                                        } else {
                                            udpDefendPolicyForm.setFragAlertSpeedEnable(false);
                                        }
                                        if (TRUE.equals(udpFirstPacketCheckEnable)) {
                                            udpDefendPolicyForm.setUdpFirstPacketCheckEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(udpUpperLimit)) {
                                                udpDefendPolicyForm.setUdpUpperLimit(Integer.valueOf(udpUpperLimit));
                                            }
                                        } else {
                                            udpDefendPolicyForm.setUdpFirstPacketCheckEnable(false);
                                        }
                                    } else {
                                        udpDefendPolicyForm.setUdpDefendEnable(false);
                                    }
                                    zoneServiceForm.setUdpDefendPolicyForm(udpDefendPolicyForm);
                                    continue;
                                }
                                if (POLICY_PROTOCOL_ICMP.equals(policyProtocol)) {
                                    IcmpDefendPolicyForm icmpDefendPolicyForm = new IcmpDefendPolicyForm();
                                    icmpDefendPolicyForm.setDirection(1);
                                    blockEnable2 = elementPolicy.elementText("block-enable");
                                    trafficLimitingEnable2 = elementPolicy.elementText("traffic-limiting-enable");
                                    String trafficLimitingSubEnable = elementPolicy.elementText("traffic-limiting-sub-enable");
                                    String trafficLimitingThreshold2 = elementPolicy.elementText("traffic-limiting-threshold");
                                    String icmpNewDestSessionLimitingEnable = elementPolicy.elementText("icmp-new-dest-session-limiting-enable");
                                    String icmpNewDestSessionLimitingThreshold = elementPolicy.elementText("icmp-new-dest-session-limiting-threshold");
                                    if (TRUE.equals(blockEnable2)) {
                                        icmpDefendPolicyForm.setIcmpBlockEnable(true);
                                        icmpDefendPolicyForm.setIcmpMaxSpeedEnable(false);
                                    } else {
                                        icmpDefendPolicyForm.setIcmpBlockEnable(false);
                                        if (TRUE.equals(trafficLimitingEnable2)) {
                                            icmpDefendPolicyForm.setIcmpMaxSpeedEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(trafficLimitingThreshold2)) {
                                                icmpDefendPolicyForm.setIcmpMaxSpeed(Integer.valueOf(trafficLimitingThreshold2));
                                            }
                                            if (TRUE.equals(trafficLimitingSubEnable)) {
                                                icmpDefendPolicyForm.setIcmpLimitSubEnable(true);
                                            } else {
                                                icmpDefendPolicyForm.setIcmpLimitSubEnable(false);
                                            }
                                            if (TRUE.equals(icmpNewDestSessionLimitingEnable)) {
                                                icmpDefendPolicyForm.setIcmpNewDestSessionLimitEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(icmpNewDestSessionLimitingThreshold)) {
                                                    icmpDefendPolicyForm.setIcmpNewDestSessionLimit(Long.valueOf(icmpNewDestSessionLimitingThreshold));
                                                }
                                            } else {
                                                icmpDefendPolicyForm.setIcmpNewDestSessionLimitEnable(false);
                                            }
                                        } else {
                                            icmpDefendPolicyForm.setIcmpMaxSpeedEnable(false);
                                        }
                                    }
                                    zoneServiceForm.setIcmpDefendPolicyForm(icmpDefendPolicyForm);
                                    continue;
                                }
                                if (POLICY_PROTOCOL_OTHER.equals(policyProtocol)) {
                                    blockEnable = elementPolicy.elementText("block-enable");
                                    trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
                                    String trafficLimitingSubEnable = elementPolicy.elementText("traffic-limiting-sub-enable");
                                    String trafficLimitingThreshold3 = elementPolicy.elementText("traffic-limiting-threshold");
                                    String otherNewDestSessionLimitingEnable = elementPolicy.elementText("other-new-dest-session-limiting-enable");
                                    String otherNewDestSessionLimitingThreshold = elementPolicy.elementText("other-new-dest-session-limiting-threshold");
                                    String defenseEnable3 = elementPolicy.elementText("defense-enable");
                                    String defenseThreshold = elementPolicy.elementText("defense-threshold");
                                    OtherDefendPolicyForm otherDefendPolicyForm = new OtherDefendPolicyForm();
                                    otherDefendPolicyForm.setDirection(1);
                                    if (TRUE.equals(blockEnable)) {
                                        otherDefendPolicyForm.setOtherBlock(true);
                                        otherDefendPolicyForm.setOtherDefendEnable(false);
                                        otherDefendPolicyForm.setOtherDefenseEnable(false);
                                    } else {
                                        otherDefendPolicyForm.setOtherBlock(false);
                                        if (TRUE.equals(trafficLimitingEnable)) {
                                            otherDefendPolicyForm.setOtherDefendEnable(true);
                                            if (TRUE.equals(trafficLimitingSubEnable)) {
                                                otherDefendPolicyForm.setOtherLimitSubEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(trafficLimitingThreshold3)) {
                                                    otherDefendPolicyForm.setOtherAlertRate(Integer.valueOf(trafficLimitingThreshold3));
                                                }
                                            } else {
                                                otherDefendPolicyForm.setOtherLimitSubEnable(false);
                                            }
                                            if (TRUE.equals(otherNewDestSessionLimitingEnable)) {
                                                otherDefendPolicyForm.setOtherNewDestSessionLimitEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(otherNewDestSessionLimitingThreshold)) {
                                                    otherDefendPolicyForm.setOtherNewDestSessionLimit(Long.valueOf(otherNewDestSessionLimitingThreshold));
                                                }
                                            } else {
                                                otherDefendPolicyForm.setOtherNewDestSessionLimitEnable(false);
                                            }
                                        } else {
                                            otherDefendPolicyForm.setOtherDefendEnable(false);
                                        }
                                        if (TRUE.equals(defenseEnable3)) {
                                            otherDefendPolicyForm.setOtherDefenseEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(defenseThreshold)) {
                                                otherDefendPolicyForm.setFingerAlert(Integer.valueOf(defenseThreshold));
                                            }
                                        } else {
                                            otherDefendPolicyForm.setOtherDefenseEnable(false);
                                        }
                                    }
                                    zoneServiceForm.setOtherDefendPolicyForm(otherDefendPolicyForm);
                                    continue;
                                }
                                if (POLICY_PROTOCOL_DNS.equals(policyProtocol)) {
                                    zoneServiceForm.setDnsDefendPolicyForm(ZoneImportParserUtil.dnsParse(elementPolicy, policyProtocol));
                                    continue;
                                }
                                if (POLICY_PROTOCOL_SIP.equals(policyProtocol)) {
                                    blockEnable = elementPolicy.elementText("block-enable");
                                    trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
                                    trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
                                    defenseEnable = elementPolicy.elementText("defense-enable");
                                    String sourceDetectionEnable = elementPolicy.elementText("source-detection-enable");
                                    String sourceDetectionThreshold = elementPolicy.elementText("source-detection-threshold");
                                    String sourceIpAddressEnable = elementPolicy.elementText("rate-limiting-of-source-ip-address-enable");
                                    sourceIpAddressThreshold = elementPolicy.elementText("rate-limiting-of-source-ip-address-threshold");
                                    SipDefendPolicyForm sipDefendPolicyForm = new SipDefendPolicyForm();
                                    sipDefendPolicyForm.setSipBlock(false);
                                    if (TRUE.equals(trafficLimitingEnable)) {
                                        sipDefendPolicyForm.setLimitEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                                            sipDefendPolicyForm.setLimitRate(Integer.valueOf(trafficLimitingThreshold));
                                        }
                                    } else {
                                        sipDefendPolicyForm.setLimitEnable(false);
                                    }
                                    if (TRUE.equals(defenseEnable)) {
                                        sipDefendPolicyForm.setSipDefendEnable(true);
                                        if (TRUE.equals(sourceDetectionEnable)) {
                                            sipDefendPolicyForm.setSipSrcDetectEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(sourceDetectionThreshold)) {
                                                sipDefendPolicyForm.setSipAlertRate(Integer.parseInt(sourceDetectionThreshold));
                                            }
                                        } else {
                                            sipDefendPolicyForm.setSipSrcDetectEnable(false);
                                        }
                                        if (TRUE.equals(sourceIpAddressEnable)) {
                                            sipDefendPolicyForm.setSipSrcOtherLimitEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(sourceIpAddressThreshold)) {
                                                sipDefendPolicyForm.setSipSrcOtherAlertRate(Integer.parseInt(sourceIpAddressThreshold));
                                                sipDefendPolicyForm.setSipSrcOtherLimitMode(1);
                                            }
                                        } else {
                                            sipDefendPolicyForm.setSipSrcOtherLimitEnable(false);
                                        }
                                    } else {
                                        sipDefendPolicyForm.setSipDefendEnable(false);
                                    }
                                    zoneServiceForm.setSipDefendPolicyForm(sipDefendPolicyForm);
                                    continue;
                                }
                                if (POLICY_PROTOCOL_HTTP.equals(policyProtocol)) {
                                    blockEnable = elementPolicy.elementText("block-enable");
                                    trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
                                    trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
                                    defenseEnable = elementPolicy.elementText("defense-enable");
                                    String requestThreshold = elementPolicy.elementText("statistics-based-on-destination-ip-address-request-threshold");
                                    String sourceIpAddressEnable = elementPolicy.elementText("statistics-based-on-source-ip-address-enable");
                                    String sourceIpAddressThreshold2 = elementPolicy.elementText("statistics-based-on-source-ip-address-threshold");
                                    String sourceIpAddressRequestThreshold = elementPolicy.elementText("statistics-based-on-source-ip-address-request-threshold");
                                    String sourceDefenseEnable = elementPolicy.elementText("http-source-authentication-defense-enable");
                                    String sourceDefenseMode = elementPolicy.elementText("http-source-authentication-defense-mode");
                                    String srcDefenseEnable = elementPolicy.elementText("http-source-authentication-defense-verification-code-caption-enable");
                                    String sourceDefenseSettings = elementPolicy.elementText("http-source-authentication-defense-verification-code-caption-settings");
                                    String sourceDefenseDetectionEnable = elementPolicy.elementText("http-source-authentication-defense-proxy-detection-enable");
                                    String sourceDefenseHeaderEnable = elementPolicy.elementText("http-source-authentication-defense-proxy-header-enable");
                                    String sourceDefenseHeader = elementPolicy.elementText("http-source-authentication-defense-proxy-header");
                                    String sourceDefenseTerminationEnable = elementPolicy.elementText("http-source-authentication-defense-termination-enable");
                                    String sourceDefenseTerminationMaxNumAttempt = elementPolicy.elementText("http-source-authentication-defense-termination-maxnum-attempt");
                                    String sourceDefenseTerminationAttemptTime = elementPolicy.elementText("http-source-authentication-defense-termination-attempt-time");
                                    String sourceDefenseSynEnable = elementPolicy.elementText("http-source-authentication-defense-syn-rate-limiting-enable");
                                    String sourceDefenseSynThreshold = elementPolicy.elementText("http-source-authentication-defense-syn-rate-limiting-threshold");
                                    String sourceDefenseAckEnable = elementPolicy.elementText("http-source-authentication-defense-ack-rate-limiting-enable");
                                    String sourceDefenseAckThreshold = elementPolicy.elementText("http-source-authentication-defense-ack-rate-limiting-threshold");
                                    String firstPacketCheckEnable = elementPolicy.elementText("http-first-packet-check-enable");
                                    String fiestPacketCheckInterval = elementPolicy.elementText("http-first-packet-check-interval");
                                    String learningEnable = elementPolicy.elementText("http-fingerprint-learning-enable");
                                    String learningCycle = elementPolicy.elementText("http-fingerprint-learning-cycle");
                                    String learningMatchingCounts = elementPolicy.elementText("http-fingerprint-learning-matching-counts");
                                    String slowAttackDefenseEnable = elementPolicy.elementText("http-slow-attack-defense-enable");
                                    String concurrentConnectionNumber = elementPolicy.elementText("http-slow-attack-defense-concurrent-connection-number");
                                    String totalPacketLength = elementPolicy.elementText("http-slow-attack-defense-total-packet-length");
                                    String checkPacketNumber = elementPolicy.elementText("http-slow-attack-defense-check-packet-number");
                                    String payloadLength = elementPolicy.elementText("http-slow-attack-defense-payload-length");
                                    String monitoringDetectionThreshold = elementPolicy.elementText("destination-ip-based-uri-behavior-monitoring-detection-threshold");
                                    String monitoringEnable = elementPolicy.elementText("source-ip-based-uri-behavior-monitoring-enable");
                                    String monitoringDefenseThreshold = elementPolicy.elementText("source-ip-based-uri-behavior-monitoring-defense-threshold");
                                    List elementUriList = elementPolicy.element("closely-monitored-uri-list").elements("closely-monitored-uri");
                                    ArrayList<HttpKeyDetectUriForm> httpKeyDetectUriFormList = new ArrayList<HttpKeyDetectUriForm>();
                                    for (Element uriElement : elementUriList) {
                                        String monitoredUri = uriElement.elementText("monitored-uri");
                                        String uriMatchMode = uriElement.elementText("uri-match-mode");
                                        if (ZoneImportParserUtil.isEmptyString(monitoredUri)) continue;
                                        HttpKeyDetectUriForm detectUriForm = new HttpKeyDetectUriForm();
                                        detectUriForm.setHttpUri(monitoredUri);
                                        if (ZoneImportParserUtil.isEmptyString(uriMatchMode)) {
                                            detectUriForm.setMatchMode(1);
                                        } else {
                                            detectUriForm.setMatchMode(Integer.parseInt(uriMatchMode));
                                        }
                                        httpKeyDetectUriFormList.add(detectUriForm);
                                    }
                                    HttpDefendPolicyForm httpDefendPolicyForm = new HttpDefendPolicyForm();
                                    httpDefendPolicyForm.setHttpBlock(false);
                                    if (TRUE.equals(trafficLimitingEnable)) {
                                        httpDefendPolicyForm.setLimitEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                                            httpDefendPolicyForm.setLimitRate(Integer.valueOf(trafficLimitingThreshold));
                                        }
                                    } else {
                                        httpDefendPolicyForm.setLimitEnable(false);
                                    }
                                    if (TRUE.equals(defenseEnable)) {
                                        String httpIllegalSessionCheckEnable;
                                        httpDefendPolicyForm.setHttpDefendEnable(true);
                                        if (TRUE.equals(sourceDefenseEnable)) {
                                            httpDefendPolicyForm.setHttpSourceAuthEnable(true);
                                            if (TRUE.equals(sourceIpAddressEnable)) {
                                                httpDefendPolicyForm.setHttpSrcStaticEnable(true);
                                                httpDefendPolicyForm.setHttpSrcMode(1);
                                                if (!ZoneImportParserUtil.isEmptyString(sourceIpAddressThreshold2)) {
                                                    httpDefendPolicyForm.setHttpSrcStaticRate(Integer.parseInt(sourceIpAddressThreshold2));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(sourceIpAddressRequestThreshold)) {
                                                    httpDefendPolicyForm.setHttpSrcQpsRate(Integer.parseInt(sourceIpAddressRequestThreshold));
                                                }
                                            } else {
                                                httpDefendPolicyForm.setHttpSrcStaticEnable(false);
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(sourceDefenseMode)) {
                                                httpDefendPolicyForm.setDefendMode(Integer.parseInt(sourceDefenseMode));
                                                if (Integer.parseInt(sourceDefenseMode) == 1 && TRUE.equals(srcDefenseEnable)) {
                                                    httpDefendPolicyForm.setHttpWebDetectEnable(true);
                                                    if (!ZoneImportParserUtil.isEmptyString(sourceDefenseSettings)) {
                                                        httpDefendPolicyForm.setWebTitle(sourceDefenseSettings);
                                                    }
                                                } else {
                                                    httpDefendPolicyForm.setHttpWebDetectEnable(false);
                                                }
                                            } else {
                                                httpDefendPolicyForm.setHttpWebDetectEnable(false);
                                            }
                                            if (TRUE.equals(sourceDefenseDetectionEnable)) {
                                                httpDefendPolicyForm.setHttpProxyEnable(true);
                                                if (TRUE.equals(sourceDefenseHeaderEnable)) {
                                                    httpDefendPolicyForm.setHttpProxyHeaderEnable(true);
                                                    httpDefendPolicyForm.setHttpProxyHeader(sourceDefenseHeader);
                                                } else {
                                                    httpDefendPolicyForm.setHttpProxyHeaderEnable(false);
                                                    httpDefendPolicyForm.setHttpProxyHeader(sourceDefenseHeader);
                                                }
                                            } else {
                                                httpDefendPolicyForm.setHttpProxyEnable(false);
                                                httpDefendPolicyForm.setHttpProxyHeaderEnable(false);
                                                httpDefendPolicyForm.setHttpProxyHeader(sourceDefenseHeader);
                                            }
                                            if (TRUE.equals(sourceDefenseTerminationEnable)) {
                                                httpDefendPolicyForm.setDetectUriEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(sourceDefenseTerminationMaxNumAttempt)) {
                                                    httpDefendPolicyForm.setMaxTimes(Integer.parseInt(sourceDefenseTerminationMaxNumAttempt));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(sourceDefenseTerminationAttemptTime)) {
                                                    httpDefendPolicyForm.setTimeout(Integer.parseInt(sourceDefenseTerminationAttemptTime));
                                                }
                                            } else {
                                                httpDefendPolicyForm.setDetectUriEnable(false);
                                            }
                                            if (TRUE.equals(sourceDefenseSynEnable)) {
                                                httpDefendPolicyForm.setHttpAfterAuthSynEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(sourceDefenseSynThreshold)) {
                                                    httpDefendPolicyForm.setAfterAuthSynRate(Integer.parseInt(sourceDefenseSynThreshold));
                                                    httpDefendPolicyForm.setAfterAuthSynAction(0);
                                                }
                                            } else {
                                                httpDefendPolicyForm.setHttpAfterAuthSynEnable(false);
                                            }
                                            if (TRUE.equals(sourceDefenseAckEnable)) {
                                                httpDefendPolicyForm.setHttpAfterAuthAckEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(sourceDefenseAckThreshold)) {
                                                    httpDefendPolicyForm.setAfterAuthAckRate(Integer.parseInt(sourceDefenseAckThreshold));
                                                    httpDefendPolicyForm.setAfterAuthAckAction(0);
                                                }
                                            } else {
                                                httpDefendPolicyForm.setHttpAfterAuthAckEnable(false);
                                            }
                                        } else {
                                            httpDefendPolicyForm.setHttpSourceAuthEnable(false);
                                        }
                                        if (TRUE.equals(firstPacketCheckEnable)) {
                                            httpDefendPolicyForm.setHttpFirstPacketEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(fiestPacketCheckInterval)) {
                                                String[] httpInterVals = fiestPacketCheckInterval.split("-");
                                                httpDefendPolicyForm.setHttpLowerLimit(Integer.parseInt(httpInterVals[0]));
                                                httpDefendPolicyForm.setHttpUpperLimit(Integer.parseInt(httpInterVals[1]));
                                            }
                                        }
                                        if (TRUE.equals(learningEnable)) {
                                            httpDefendPolicyForm.setFingerLearnEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(learningCycle)) {
                                                httpDefendPolicyForm.setLearnPeriod(Integer.parseInt(learningCycle));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(learningMatchingCounts)) {
                                                httpDefendPolicyForm.setMatchTimes(Integer.parseInt(learningMatchingCounts));
                                            }
                                        } else {
                                            httpDefendPolicyForm.setFingerLearnEnable(false);
                                        }
                                        if ((TRUE.equals(learningEnable) || TRUE.equals(sourceDefenseEnable)) && !ZoneImportParserUtil.isEmptyString(requestThreshold)) {
                                            httpDefendPolicyForm.setHttpDestQpsAlertRate(Integer.parseInt(requestThreshold));
                                        }
                                        if (TRUE.equals(slowAttackDefenseEnable)) {
                                            httpDefendPolicyForm.setHttpSlowAttackEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(concurrentConnectionNumber)) {
                                                httpDefendPolicyForm.setHttpSlowConnNum(Integer.parseInt(concurrentConnectionNumber));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(totalPacketLength)) {
                                                httpDefendPolicyForm.setHttpSlowContentLength(Integer.parseInt(totalPacketLength));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(checkPacketNumber)) {
                                                httpDefendPolicyForm.setHttpSlowCheckPacketNum(Integer.parseInt(checkPacketNumber));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(payloadLength)) {
                                                httpDefendPolicyForm.setHttpSlowPayloadLength(Integer.parseInt(payloadLength));
                                            }
                                        } else {
                                            httpDefendPolicyForm.setHttpSlowAttackEnable(false);
                                        }
                                        if (TRUE.equals(monitoringEnable)) {
                                            httpDefendPolicyForm.setHttpUriEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(monitoringDetectionThreshold)) {
                                                httpDefendPolicyForm.setHttpDetectNumber(Integer.parseInt(monitoringDetectionThreshold));
                                                httpDefendPolicyForm.setHttpDetectInterval(30);
                                                httpDefendPolicyForm.setDetectMinNum(10);
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(monitoringDefenseThreshold)) {
                                                httpDefendPolicyForm.setIllegalRatioNumber(Integer.parseInt(monitoringDefenseThreshold));
                                                httpDefendPolicyForm.setIllegalRatioInterval(30);
                                                httpDefendPolicyForm.setIllegalMinNum(10);
                                            }
                                            if (!httpKeyDetectUriFormList.isEmpty()) {
                                                httpDefendPolicyForm.setKeyDetectUriForms(httpKeyDetectUriFormList);
                                            }
                                        } else {
                                            httpDefendPolicyForm.setHttpUriEnable(false);
                                        }
                                        String highFreqDetectEnable = elementPolicy.elementText("http-high-freq-detect-enable");
                                        String highFreqDetectThreshold = elementPolicy.elementText("http-high-freq-detect-threshold");
                                        String highFreqDetectInterval = elementPolicy.elementText("http-high-freq-detect-interval");
                                        if (TRUE.equals(highFreqDetectEnable)) {
                                            httpDefendPolicyForm.setHighFreqDetectEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(highFreqDetectThreshold)) {
                                                httpDefendPolicyForm.setHighFreqDetectThreshold(Integer.parseInt(highFreqDetectThreshold));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(highFreqDetectInterval)) {
                                                httpDefendPolicyForm.setHighFreqDetectInterval(Integer.parseInt(highFreqDetectInterval));
                                            }
                                        } else {
                                            httpDefendPolicyForm.setHighFreqDetectEnable(false);
                                        }
                                        String httpFixUriEnable = elementPolicy.elementText("http-fix-uri-enable");
                                        String httpFixUriRatioNumber = elementPolicy.elementText("http-fix-uri-ratio-number");
                                        String httpFixUriThreshold = elementPolicy.elementText("http-fix-uri-threshold");
                                        String httpFixUriInterval = elementPolicy.elementText("http-fix-uri-interval");
                                        if (TRUE.equals(httpFixUriEnable)) {
                                            httpDefendPolicyForm.setHttpFixUriEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(httpFixUriRatioNumber)) {
                                                httpDefendPolicyForm.setHttpFixUriRatioNumber(Integer.parseInt(httpFixUriRatioNumber));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(httpFixUriThreshold)) {
                                                httpDefendPolicyForm.setHttpFixUriThreshold(Integer.parseInt(httpFixUriThreshold));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(httpFixUriInterval)) {
                                                httpDefendPolicyForm.setHttpFixUriInterval(Integer.parseInt(httpFixUriInterval));
                                            }
                                            if (!httpKeyDetectUriFormList.isEmpty()) {
                                                httpDefendPolicyForm.setKeyDetectUriForms(httpKeyDetectUriFormList);
                                            }
                                        } else {
                                            httpDefendPolicyForm.setHttpFixUriEnable(false);
                                        }
                                        String largeResDetectEnable = elementPolicy.elementText("http-large-res-detect-enable");
                                        String largeResSize = elementPolicy.elementText("http-large-res-size");
                                        String largeResDetectRatio = elementPolicy.elementText("http-large-res-detect-ratio");
                                        String largeResDetectThreshold = elementPolicy.elementText("http-large-res-detect-threshold");
                                        String largeResDetectInterval = elementPolicy.elementText("http-large-res-detect-interval");
                                        if (TRUE.equals(largeResDetectEnable)) {
                                            httpDefendPolicyForm.setLargeResDetectEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(largeResSize)) {
                                                httpDefendPolicyForm.setLargeResSize(Integer.parseInt(largeResSize));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(largeResDetectRatio)) {
                                                httpDefendPolicyForm.setLargeResDetectRatio(Integer.parseInt(largeResDetectRatio));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(largeResDetectThreshold)) {
                                                httpDefendPolicyForm.setLargeResDetectThreshold(Integer.parseInt(largeResDetectThreshold));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(largeResDetectInterval)) {
                                                httpDefendPolicyForm.setLargeResDetectInterval(Integer.parseInt(largeResDetectInterval));
                                            }
                                        } else {
                                            httpDefendPolicyForm.setLargeResDetectEnable(false);
                                        }
                                        if (TRUE.equals(httpIllegalSessionCheckEnable = elementPolicy.elementText("http-illegal-session-check-enable"))) {
                                            String httpIllegalSessionInterval;
                                            String httpIllegalSessionNum;
                                            String multiGetCheck;
                                            String rangeHeaderCheck;
                                            String nullMethodCheck = elementPolicy.elementText("http-null-method-check");
                                            httpDefendPolicyForm.setHttpIllegalSessionCheckEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(nullMethodCheck)) {
                                                httpDefendPolicyForm.setNullMethodCheck(TRUE.equals(nullMethodCheck));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(rangeHeaderCheck = elementPolicy.elementText("http-range-header-check"))) {
                                                httpDefendPolicyForm.setRangeHeaderCheck(TRUE.equals(rangeHeaderCheck));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(multiGetCheck = elementPolicy.elementText("http-multi-get-check"))) {
                                                httpDefendPolicyForm.setMultiGetCheck(TRUE.equals(multiGetCheck));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(httpIllegalSessionNum = elementPolicy.elementText("http-illegal-session-num"))) {
                                                httpDefendPolicyForm.setHttpIllegalSessionNum(Integer.parseInt(httpIllegalSessionNum));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(httpIllegalSessionInterval = elementPolicy.elementText("http-illegal-session-interval"))) {
                                                httpDefendPolicyForm.setHttpIllegalSessionInterval(Integer.parseInt(httpIllegalSessionInterval));
                                            }
                                        } else {
                                            httpDefendPolicyForm.setHttpIllegalSessionCheckEnable(false);
                                        }
                                        String destIpConnNumEnable = elementPolicy.elementText("dest-ip-conn-num-enable");
                                        String destIpConnNum = elementPolicy.elementText("dest-ip-conn-num");
                                        if (TRUE.equals(destIpConnNumEnable)) {
                                            httpDefendPolicyForm.setDestIpConnNumEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(destIpConnNum)) {
                                                httpDefendPolicyForm.setDestIpConnNum(Integer.parseInt(destIpConnNum));
                                            }
                                        } else {
                                            httpDefendPolicyForm.setDestIpConnNumEnable(false);
                                        }
                                    } else {
                                        httpDefendPolicyForm.setHttpDefendEnable(false);
                                    }
                                    zoneServiceForm.setHttpDefendPolicyForm(httpDefendPolicyForm);
                                    continue;
                                }
                                if (POLICY_PROTOCOL_HTTPS.equals(policyProtocol)) {
                                    blockEnable = elementPolicy.elementText("block-enable");
                                    trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
                                    trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
                                    defenseEnable = elementPolicy.elementText("defense-enable");
                                    String sourceDefenseEnable = elementPolicy.elementText("https-source-authentication-defense-enable");
                                    String packetThreshold = elementPolicy.elementText("statistics-based-on-destination-ip-address-packet-threshold");
                                    String srcIpAddEnable = elementPolicy.elementText("statistics-based-on-source-ip-address-enable");
                                    sourceIpAddressThreshold = elementPolicy.elementText("statistics-based-on-source-ip-address-threshold");
                                    String sslDefenseEnable = elementPolicy.elementText("ssl-defense-enable");
                                    String maximumRenegotiationTimes = elementPolicy.elementText("ssl-defense-maximum-renegotiation-times");
                                    String renegotiationInterval = elementPolicy.elementText("ssl-defense-renegotiation-interval");
                                    String abnormalSessions = elementPolicy.elementText("ssl-defense-maximum-number-of-abnormal-sessions");
                                    String checkInterva = elementPolicy.elementText("ssl-defense-abnormal-session-check-interva");
                                    String httpsNegoCheckEnable = elementPolicy.elementText("ssl-defense-renegotiation-times-check-enable");
                                    String httpsSessionCheckEnable = elementPolicy.elementText("ssl-defense-session-check-enable");
                                    HttpsDefendPolicyForm httpsDefendPolicyForm = new HttpsDefendPolicyForm();
                                    httpsDefendPolicyForm.setHttpsBlock(false);
                                    if (TRUE.equals(trafficLimitingEnable)) {
                                        httpsDefendPolicyForm.setLimitEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                                            httpsDefendPolicyForm.setLimitRate(Integer.valueOf(trafficLimitingThreshold));
                                        }
                                    } else {
                                        httpsDefendPolicyForm.setLimitEnable(false);
                                    }
                                    if (TRUE.equals(defenseEnable)) {
                                        httpsDefendPolicyForm.setHttpsDefendEnable(true);
                                        if (TRUE.equals(sourceDefenseEnable)) {
                                            httpsDefendPolicyForm.setHttpsSrcEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(packetThreshold)) {
                                                httpsDefendPolicyForm.setHttpsAlertRate(Integer.parseInt(packetThreshold));
                                            }
                                            if (TRUE.equals(srcIpAddEnable)) {
                                                httpsDefendPolicyForm.setHttpsSrcStaticEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(sourceIpAddressThreshold)) {
                                                    httpsDefendPolicyForm.setHttpsSrcStaticRate(Integer.parseInt(sourceIpAddressThreshold));
                                                }
                                                httpsDefendPolicyForm.setHttpsSrcMode(1);
                                            } else {
                                                httpsDefendPolicyForm.setHttpsSrcStaticEnable(false);
                                            }
                                            String httpsSrcAdvanceEnable = elementPolicy.elementText("https-src-advance-enable");
                                            httpsDefendPolicyForm.setHttpsSrcAdvanceEnable(TRUE.equals(httpsSrcAdvanceEnable));
                                            String httpsHighFreqDetectEnable = elementPolicy.elementText("https-high-freq-detect-enable");
                                            String httpsHighFreqDetectThreshold = elementPolicy.elementText("https-high-freq-detect-threshold");
                                            String httpsHighFreqDetectInterval = elementPolicy.elementText("https-high-freq-detect-interval");
                                            if (TRUE.equals(httpsHighFreqDetectEnable)) {
                                                httpsDefendPolicyForm.setHttpsHighFreqDetectEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(httpsHighFreqDetectThreshold)) {
                                                    httpsDefendPolicyForm.setHttpsHighFreqDetectThreshold(Integer.parseInt(httpsHighFreqDetectThreshold));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(httpsHighFreqDetectInterval)) {
                                                    httpsDefendPolicyForm.setHttpsHighFreqDetectInterval(Integer.parseInt(httpsHighFreqDetectInterval));
                                                }
                                            } else {
                                                httpsDefendPolicyForm.setHttpsHighFreqDetectEnable(false);
                                            }
                                            String httpsFixResEnable = elementPolicy.elementText("https-fix-res-enable");
                                            String httpsFixResRatioNumber = elementPolicy.elementText("https-fix-res-ratio-number");
                                            String httpsFixResThreshold = elementPolicy.elementText("https-fix-res-threshold");
                                            String httpsFixResInterval = elementPolicy.elementText("https-fix-res-interval");
                                            if (TRUE.equals(httpsFixResEnable)) {
                                                httpsDefendPolicyForm.setHttpsFixResEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(httpsFixResRatioNumber)) {
                                                    httpsDefendPolicyForm.setHttpsFixResRatioNumber(Integer.parseInt(httpsFixResRatioNumber));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(httpsFixResThreshold)) {
                                                    httpsDefendPolicyForm.setHttpsFixResThreshold(Integer.parseInt(httpsFixResThreshold));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(httpsFixResInterval)) {
                                                    httpsDefendPolicyForm.setHttpsFixResInterval(Integer.parseInt(httpsFixResInterval));
                                                }
                                            } else {
                                                httpsDefendPolicyForm.setHttpsFixResEnable(false);
                                            }
                                            String httpsLargeResDetectEnable = elementPolicy.elementText("https-large-res-detect-enable");
                                            String httpsLargeResSize = elementPolicy.elementText("https-large-res-size");
                                            String httpsLargeResDetectRatio = elementPolicy.elementText("https-large-res-detect-ratio");
                                            String httpsLargeResDetectThreshold = elementPolicy.elementText("https-large-res-detect-threshold");
                                            String httpsLargeResDetectInterval = elementPolicy.elementText("https-large-res-detect-interval");
                                            if (TRUE.equals(httpsLargeResDetectEnable)) {
                                                httpsDefendPolicyForm.setHttpsLargeResDetectEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(httpsLargeResSize)) {
                                                    httpsDefendPolicyForm.setHttpsLargeResSize(Integer.parseInt(httpsLargeResSize));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(httpsLargeResDetectRatio)) {
                                                    httpsDefendPolicyForm.setHttpsLargeResDetectRatio(Integer.parseInt(httpsLargeResDetectRatio));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(httpsLargeResDetectThreshold)) {
                                                    httpsDefendPolicyForm.setHttpsLargeResDetectThreshold(Integer.parseInt(httpsLargeResDetectThreshold));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(httpsLargeResDetectInterval)) {
                                                    httpsDefendPolicyForm.setHttpsLargeResDetectInterval(Integer.parseInt(httpsLargeResDetectInterval));
                                                }
                                            } else {
                                                httpsDefendPolicyForm.setHttpsLargeResDetectEnable(false);
                                            }
                                        } else {
                                            httpsDefendPolicyForm.setHttpsSrcEnable(false);
                                        }
                                        if (TRUE.equals(sslDefenseEnable)) {
                                            httpsDefendPolicyForm.setHttpsSslEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(maximumRenegotiationTimes)) {
                                                httpsDefendPolicyForm.setHttpsNegonum(Integer.parseInt(maximumRenegotiationTimes));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(renegotiationInterval)) {
                                                httpsDefendPolicyForm.setHttpsNegointerval(Integer.parseInt(renegotiationInterval));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(abnormalSessions)) {
                                                httpsDefendPolicyForm.setHttpsIllegalnum(Integer.parseInt(abnormalSessions));
                                            }
                                            if (!ZoneImportParserUtil.isEmptyString(checkInterva)) {
                                                httpsDefendPolicyForm.setHttpsIllegalinterval(Integer.parseInt(checkInterva));
                                            }
                                            if (TRUE.equals(httpsNegoCheckEnable)) {
                                                httpsDefendPolicyForm.setHttpsNegoCheckEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(maximumRenegotiationTimes)) {
                                                    httpsDefendPolicyForm.setHttpsNegonum(Integer.parseInt(maximumRenegotiationTimes));
                                                }
                                                if (!ZoneImportParserUtil.isEmptyString(renegotiationInterval)) {
                                                    httpsDefendPolicyForm.setHttpsNegointerval(Integer.parseInt(renegotiationInterval));
                                                }
                                            } else {
                                                httpsDefendPolicyForm.setHttpsNegoCheckEnable(false);
                                            }
                                            if (TRUE.equals(httpsSessionCheckEnable)) {
                                                httpsDefendPolicyForm.setHttpsSessionCheckEnable(true);
                                            } else {
                                                httpsDefendPolicyForm.setHttpsSessionCheckEnable(false);
                                            }
                                            String httpsDestIpConnNumEnable = elementPolicy.elementText("https-dest-ip-conn-num-enable");
                                            String httpsDestIpConnNum = elementPolicy.elementText("https-dest-ip-conn-num");
                                            if (TRUE.equals(httpsDestIpConnNumEnable)) {
                                                httpsDefendPolicyForm.setHttpsDestIpConnNumEnable(true);
                                                if (!ZoneImportParserUtil.isEmptyString(httpsDestIpConnNum)) {
                                                    httpsDefendPolicyForm.setHttpsDestIpConnNum(Integer.parseInt(httpsDestIpConnNum));
                                                }
                                            } else {
                                                httpsDefendPolicyForm.setHttpsDestIpConnNumEnable(false);
                                            }
                                        } else {
                                            httpsDefendPolicyForm.setHttpsSslEnable(false);
                                        }
                                    } else {
                                        httpsDefendPolicyForm.setHttpsDefendEnable(false);
                                    }
                                    zoneServiceForm.setHttpsDefendPolicyForm(httpsDefendPolicyForm);
                                    continue;
                                }
                                if (POLICY_PROTOCOL_TOP_N_STUDY.equals(policyProtocol)) {
                                    String hostEnable = elementPolicy.elementText("http-host-enable");
                                    String hostSamplingRatio = elementPolicy.elementText("http-host-sampling-ratio");
                                    String uriEnable = elementPolicy.elementText("http-uri-enable");
                                    defenseEnable = elementPolicy.elementText("http-uri-sampling-ratio");
                                    String uriSamplingRatio = elementPolicy.elementText("top-n-http-source-ip-addresses-enable");
                                    String samplingRatio = elementPolicy.elementText("top-n-http-source-ip-addresses-sampling-ratio");
                                    String domainNamesEnable = elementPolicy.elementText("top-n-requested-domain-names-enable");
                                    String dynamicCacheEnable = elementPolicy.elementText("top-n-requested-domain-names-dynamic-cache-enable");
                                    String dynamicCacheValue = elementPolicy.elementText("top-n-requested-domain-names-dynamic-cache-value");
                                    String requestedSamplingRatio = elementPolicy.elementText("top-n-requested-domain-names-sampling-ratio");
                                    String ipAddressesEnable = elementPolicy.elementText("top-n-dns-request-source-ip-addresses-enable");
                                    String ipAddressesSamplingRatio = elementPolicy.elementText("top-n-dns-request-source-ip-addresses-sampling-ratio");
                                    String responseIpAddressesEnable = elementPolicy.elementText("top-n-dns-response-source-ip-addresses-enable");
                                    String responseIpAddressesSamplingRatio = elementPolicy.elementText("top-n-dns-response-source-ip-addresses-sampling-ratio");
                                    String httpsIpAddressesEnable = elementPolicy.elementText("top-n-https-source-ip-addresses-enable");
                                    String httpsIpAddressesSamplingRatio = elementPolicy.elementText("top-n-https-source-ip-addresses-sampling-ratio");
                                    String tcpIpAddressesEnable = elementPolicy.elementText("top-n-tcp-source-ip-addresses-enable");
                                    String tcpIpAddressesSamplingRatio = elementPolicy.elementText("top-n-tcp-source-ip-addresses-sampling-ratio");
                                    TopNStudyForm topNStudyForm = new TopNStudyForm();
                                    if (TRUE.equals(hostEnable)) {
                                        topNStudyForm.setHttpHostEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(hostSamplingRatio)) {
                                            topNStudyForm.setHttpHostSimple(Integer.parseInt(hostSamplingRatio));
                                        }
                                    } else {
                                        topNStudyForm.setHttpHostEnable(false);
                                    }
                                    if (TRUE.equals(uriEnable)) {
                                        topNStudyForm.setHttpUriEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(defenseEnable)) {
                                            topNStudyForm.setHttpUriSimple(Integer.parseInt(defenseEnable));
                                        }
                                    } else {
                                        topNStudyForm.setHttpUriEnable(false);
                                    }
                                    if (TRUE.equals(uriSamplingRatio)) {
                                        topNStudyForm.setHttpSrcIpEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(samplingRatio)) {
                                            topNStudyForm.setHttpSrcIpSimple(Integer.parseInt(samplingRatio));
                                        }
                                    } else {
                                        topNStudyForm.setHttpSrcIpEnable(false);
                                    }
                                    if (TRUE.equals(domainNamesEnable)) {
                                        topNStudyForm.setDnsQueryDomainEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(requestedSamplingRatio)) {
                                            topNStudyForm.setDnsQueryDomainSimple(Integer.parseInt(requestedSamplingRatio));
                                        }
                                        if (TRUE.equals(dynamicCacheEnable)) {
                                            topNStudyForm.setTopnCacheEnable(true);
                                            if (!ZoneImportParserUtil.isEmptyString(dynamicCacheValue)) {
                                                topNStudyForm.setTopnCacheNum(Integer.parseInt(dynamicCacheValue));
                                            }
                                        } else {
                                            topNStudyForm.setTopnCacheEnable(false);
                                        }
                                    } else {
                                        topNStudyForm.setDnsQueryDomainEnable(false);
                                    }
                                    if (TRUE.equals(ipAddressesEnable)) {
                                        topNStudyForm.setDnsQuerySrcIpEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(ipAddressesSamplingRatio)) {
                                            topNStudyForm.setDnsQuerySrcIpSimple(Integer.parseInt(ipAddressesSamplingRatio));
                                        }
                                    } else {
                                        topNStudyForm.setDnsQuerySrcIpEnable(false);
                                    }
                                    if (TRUE.equals(responseIpAddressesEnable)) {
                                        topNStudyForm.setDnsReqSrcIpEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(responseIpAddressesSamplingRatio)) {
                                            topNStudyForm.setDnsReqSrcIpSimple(Integer.parseInt(responseIpAddressesSamplingRatio));
                                        }
                                    } else {
                                        topNStudyForm.setDnsReqSrcIpEnable(false);
                                    }
                                    if (TRUE.equals(httpsIpAddressesEnable)) {
                                        topNStudyForm.setHttpsEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(httpsIpAddressesSamplingRatio)) {
                                            topNStudyForm.setHttpsSimple(Integer.parseInt(httpsIpAddressesSamplingRatio));
                                        }
                                    } else {
                                        topNStudyForm.setHttpsEnable(false);
                                    }
                                    if (TRUE.equals(tcpIpAddressesEnable)) {
                                        topNStudyForm.setTcpNewConnEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(tcpIpAddressesSamplingRatio)) {
                                            topNStudyForm.setTcpNewConnSimple(Integer.parseInt(tcpIpAddressesSamplingRatio));
                                        }
                                    } else {
                                        topNStudyForm.setTcpNewConnEnable(false);
                                    }
                                    zoneServiceForm.setTopNStudyForm(topNStudyForm);
                                    continue;
                                }
                                if ("None-Zone".equals(policyProtocol) || "First Packet Check".equals(policyProtocol)) continue;
                                LOG.error((Object)("the protocol error : zoneserviceName is  " + ZoneImportParserUtil.getcleanedMessage(zoneServiceForm.getServiceName()) + ",protocol is " + ZoneImportParserUtil.getcleanedMessage(policyProtocol)));
                                throw new LegoCheckedException(571988L);
                            }
                        }
                        inboundZoneServices.add(zoneServiceForm);
                    }
                }
                Element elementOutbound = element.element("outbound");
                ArrayList<ZoneServiceForm> outboundZoneServices = new ArrayList<ZoneServiceForm>();
                if (null != elementOutbound) {
                    List outboundDefensePolicyList;
                    List outboundfilterList;
                    ZoneImportParserUtil.parserFaultSeverityRule(zonePolicyApplyForm, elementOutbound, false);
                    Element elementOutboundDefenseModeInfo = elementOutbound.element("defense-mode-info");
                    String outboundFilterDropThreshold = elementOutboundDefenseModeInfo.elementText("filter_drop_thershold");
                    String flowspecAction = elementOutboundDefenseModeInfo.elementText("flowspec_action");
                    String flowspecLimitThreshold = elementOutboundDefenseModeInfo.elementText("flowspec_limit_threshold");
                    String flowspecRedirect = elementOutboundDefenseModeInfo.elementText("flowspec_redirect");
                    if (!ZoneImportParserUtil.isEmptyString(outboundFilterDropThreshold)) {
                        zonePolicyApplyForm.setOutBoundFilterDropThreshold(Long.valueOf(outboundFilterDropThreshold));
                    }
                    if (!ZoneImportParserUtil.isEmptyString(flowspecAction)) {
                        zonePolicyApplyForm.setOutBoundFilterAction(Integer.valueOf(flowspecAction));
                        if (2 == zonePolicyApplyForm.getOutBoundFilterAction() && !ZoneImportParserUtil.isEmptyString(flowspecLimitThreshold)) {
                            zonePolicyApplyForm.setOutBoundFilterLimit(Long.valueOf(flowspecLimitThreshold));
                        }
                        if (3 == zonePolicyApplyForm.getOutBoundFilterAction() && !ZoneImportParserUtil.isEmptyString(flowspecRedirect)) {
                            zonePolicyApplyForm.setOutBoundNextHop(flowspecRedirect);
                        }
                    }
                    if (null != (outboundfilterList = elementOutbound.element("filter-list").elements("filter-name")) && !outboundfilterList.isEmpty()) {
                        ArrayList<Long> filterIdList = new ArrayList<Long>();
                        ArrayList<String> filterNameList = new ArrayList<String>();
                        for (Element elementFilter : outboundfilterList) {
                            String filterName = elementFilter.getText();
                            filterNameList.add(filterName);
                        }
                        zonePolicyApplyForm.setOutboundFilterIdList(filterIdList);
                        zonePolicyApplyForm.setOutboundFilterNameList(filterNameList);
                    }
                    if (null != (outboundDefensePolicyList = elementOutbound.element("defense-policy-list").elements("defense-policy")) && !outboundDefensePolicyList.isEmpty()) {
                        for (Element outboundService : outboundDefensePolicyList) {
                            ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
                            zoneServiceForm.setDirection(2);
                            Element elementBasicInfo = outboundService.element("basic-info");
                            String name = elementBasicInfo.elementText("name");
                            String deviceIp = elementBasicInfo.elementText("device-ip");
                            String protocol = elementBasicInfo.elementText("protocol");
                            zoneServiceForm.setServiceName(name);
                            zoneServiceForm.setDeviceIp(deviceIp);
                            zoneServiceForm.setProtocol(protocol);
                            List elementPolicyList = outboundService.element("policy-list").elements("policy");
                            if (null == elementPolicyList || elementPolicyList.isEmpty()) continue;
                            for (Element elementPolicy : elementPolicyList) {
                                String policyProtocol = elementPolicy.elementText("protocol");
                                if (POLICY_PROTOCOL_TCP.equals(policyProtocol)) {
                                    TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
                                    tcpDefendPolicyForm.setDirection(2);
                                    String synFloodAttackDefenseEnable = elementPolicy.elementText("syn-flood-attack-defense-enable");
                                    String synFloodAttackDefenseThreshold = elementPolicy.elementText("syn-flood-attack-defense-threshold");
                                    String synFloodAttackDefenseInterval = elementPolicy.elementText("syn-flood-attack-defense-interval");
                                    String tcpFragmentAttackDefenseEnable = elementPolicy.elementText("tcp-fragment-attack-defense-enable");
                                    String tcpFragmentAattackDefenseTthreshold = elementPolicy.elementText("tcp-fragment-attack-defense-threshold");
                                    if (TRUE.equals(synFloodAttackDefenseEnable)) {
                                        tcpDefendPolicyForm.setSynfloodEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(synFloodAttackDefenseThreshold)) {
                                            tcpDefendPolicyForm.setSynfloodAlertRate(Integer.valueOf(synFloodAttackDefenseThreshold));
                                        }
                                        if (!ZoneImportParserUtil.isEmptyString(synFloodAttackDefenseInterval)) {
                                            String[] synInterVals = synFloodAttackDefenseInterval.split("-");
                                            tcpDefendPolicyForm.setFirstPacketCheckLowerLimit(Integer.valueOf(synInterVals[0]));
                                            tcpDefendPolicyForm.setFirstPacketCheckUpperLimit(Integer.valueOf(synInterVals[1]));
                                        }
                                    } else {
                                        tcpDefendPolicyForm.setSynfloodEnable(false);
                                    }
                                    if (TRUE.equals(tcpFragmentAttackDefenseEnable)) {
                                        tcpDefendPolicyForm.setTcpFragEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(tcpFragmentAattackDefenseTthreshold)) {
                                            tcpDefendPolicyForm.setTcpFragAlertRate(Integer.valueOf(tcpFragmentAattackDefenseTthreshold));
                                        }
                                    } else {
                                        tcpDefendPolicyForm.setTcpFragEnable(false);
                                    }
                                    zoneServiceForm.setTcpDefendPolicyForm(tcpDefendPolicyForm);
                                    continue;
                                }
                                if (POLICY_PROTOCOL_UDP.equals(policyProtocol)) {
                                    UdpDefendPolicyForm udpDefendPolicyForm = new UdpDefendPolicyForm();
                                    udpDefendPolicyForm.setDirection(2);
                                    String udpTtrafficLimitingEnable = elementPolicy.elementText("udp-traffic-limiting-enable");
                                    String udpTrafficLimitingThreshold = elementPolicy.elementText("udp-traffic-limiting-threshold");
                                    String udpFragmentRateLimitingEnable = elementPolicy.elementText("udp-fragment-rate-limiting-enable");
                                    String udpFragmentRateLimitingThreshold = elementPolicy.elementText("udp-fragment-rate-limiting-threshold");
                                    if (TRUE.equals(udpTtrafficLimitingEnable)) {
                                        udpDefendPolicyForm.setUdpMaxSpeedEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(udpTrafficLimitingThreshold)) {
                                            udpDefendPolicyForm.setUdpMaxSpeed(Integer.valueOf(udpTrafficLimitingThreshold));
                                        }
                                    } else {
                                        udpDefendPolicyForm.setUdpMaxSpeedEnable(false);
                                    }
                                    if (TRUE.equals(udpFragmentRateLimitingEnable)) {
                                        udpDefendPolicyForm.setUdpFragMaxSpeedEnable(true);
                                        if (!ZoneImportParserUtil.isEmptyString(udpFragmentRateLimitingThreshold)) {
                                            udpDefendPolicyForm.setUdpFragMaxSpeed(Integer.valueOf(udpFragmentRateLimitingThreshold));
                                        }
                                    } else {
                                        udpDefendPolicyForm.setUdpFragMaxSpeedEnable(false);
                                    }
                                    zoneServiceForm.setUdpDefendPolicyForm(udpDefendPolicyForm);
                                    continue;
                                }
                                if (!POLICY_PROTOCOL_ICMP.equals(policyProtocol)) continue;
                                IcmpDefendPolicyForm icmpDefendPolicyForm = new IcmpDefendPolicyForm();
                                icmpDefendPolicyForm.setDirection(2);
                                String trafficLimitingEnable = elementPolicy.elementText("traffic-limiting-enable");
                                String trafficLimitingThreshold = elementPolicy.elementText("traffic-limiting-threshold");
                                if (TRUE.equals(trafficLimitingEnable)) {
                                    icmpDefendPolicyForm.setIcmpLimitSubEnable(true);
                                    if (!ZoneImportParserUtil.isEmptyString(trafficLimitingThreshold)) {
                                        icmpDefendPolicyForm.setIcmpMaxSpeed(Integer.valueOf(trafficLimitingThreshold));
                                    }
                                } else {
                                    icmpDefendPolicyForm.setIcmpLimitSubEnable(false);
                                }
                                zoneServiceForm.setIcmpDefendPolicyForm(icmpDefendPolicyForm);
                            }
                            outboundZoneServices.add(zoneServiceForm);
                        }
                    }
                }
                ArrayList<ZoneServiceForm> allZoneServices = new ArrayList<ZoneServiceForm>();
                if (!inboundZoneServices.isEmpty()) {
                    allZoneServices.addAll(inboundZoneServices);
                }
                if (!outboundZoneServices.isEmpty()) {
                    allZoneServices.addAll(outboundZoneServices);
                } else if (2 == zoneInfoForm.getZoneType()) {
                    for (ZoneDeviceForm form : zonePolicyApplyForm.getZoneDeviceForms()) {
                        ZoneServiceForm zoneServiceFormOutbound = ZoneImportParserUtil.initZoneServiceForm(true);
                        ZoneImportParserUtil.initZoneServicedData(form.getDeviceIp(), zoneServiceFormOutbound);
                        allZoneServices.add(zoneServiceFormOutbound);
                    }
                }
                zonePolicyApplyForm.setZoneServices(allZoneServices);
                zoneFormList.add(zonePolicyApplyForm);
            }
        }
        return zoneFormList;
    }

    private static TcpDefendPolicyForm portBizParse(Element elementPolicy) {
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        tcpDefendPolicyForm.setDirection(1);
        String sourceLimiteEnable = elementPolicy.elementText("source-ip-limiting-enable");
        String sourceLimitBandwidthEnable = elementPolicy.elementText("source-ip-band-width-limiting-enable");
        String sourceLimitBandwidthThreshold = elementPolicy.elementText("source-ip-band-width-limiting-threshold");
        String sourceLimitPacketEnable = elementPolicy.elementText("source-ip-limiting-packet-enable");
        String sourceLimitPacketThreshold = elementPolicy.elementText("source-ip-limiting-packet-threshold");
        String sourceLimitIllegalTimes = elementPolicy.elementText("source-ip-limiting-anomaly-times");
        String sourceLimitTotalTimes = elementPolicy.elementText("source-ip-limiting-total-check-times");
        String sourceLimitInterval = elementPolicy.elementText("source-ip-limiting-cycle");
        String synRationLimiteEnable = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-enable");
        String synRationLimiteThreshold = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-threshold");
        String synratioLimitPackets = elementPolicy.elementText("syn-ratio-Limit-packets");
        String synRationLimitecycle = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-cycle");
        String synRationLimitePacketsThreshold = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-packets-threshold");
        String synRationLimitePacketscycle = elementPolicy.elementText("source-ip-syn-ratio-anomaly-limiting-packets-cycle");
        String synBlackListEnable = elementPolicy.elementText("syn-blackList-enable");
        String synExceptionTimes = elementPolicy.elementText("syn-exception-times");
        String synTotalCheckTimes = elementPolicy.elementText("syn-total-check-times");
        String tcpConnectionDefenseEnable = elementPolicy.elementText("tcp-connection-flood-attack-defense-enable");
        String newSourceIpAddressEnable = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-enable");
        String newSourceIpAddressThreshold = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-threshold");
        String newSourceIpAddressCheckCycle = elementPolicy.elementText("new-connection-rate-check-by-source-ip-address-check-cycle");
        String sourceIpAddressEnable = elementPolicy.elementText("connection-number-check-for-source-ip-address-enable");
        String sourceIpAddressThreshold = elementPolicy.elementText("connection-number-check-for-source-ip-address-threshold");
        if (TRUE.equals(sourceLimiteEnable)) {
            tcpDefendPolicyForm.setSourceLimitEnable(true);
            if (TRUE.equals(sourceLimitBandwidthEnable)) {
                tcpDefendPolicyForm.setSourceLimitBandwidthEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(sourceLimitBandwidthThreshold)) {
                    tcpDefendPolicyForm.setSourceLimitBandwidthRate(Integer.valueOf(sourceLimitBandwidthThreshold));
                }
            } else {
                tcpDefendPolicyForm.setSourceLimitBandwidthEnable(false);
            }
            if (TRUE.equals(sourceLimitPacketEnable)) {
                tcpDefendPolicyForm.setSourceLimitPacketsEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(sourceLimitPacketThreshold)) {
                    tcpDefendPolicyForm.setSourceLimitPacketsRate(Integer.valueOf(sourceLimitPacketThreshold));
                }
            } else {
                tcpDefendPolicyForm.setSourceLimitPacketsEnable(false);
            }
            if (!ZoneImportParserUtil.isEmptyString(sourceLimitIllegalTimes)) {
                tcpDefendPolicyForm.setSourceLimitIllegalTimes(Integer.valueOf(sourceLimitIllegalTimes));
            }
            if (!ZoneImportParserUtil.isEmptyString(sourceLimitTotalTimes)) {
                tcpDefendPolicyForm.setSourceLimitTotalTimes(Integer.valueOf(sourceLimitTotalTimes));
            }
            if (!ZoneImportParserUtil.isEmptyString(sourceLimitInterval)) {
                tcpDefendPolicyForm.setSourceLimitInterval(Integer.valueOf(sourceLimitInterval));
            }
        } else {
            tcpDefendPolicyForm.setSourceLimitEnable(false);
        }
        if (TRUE.equals(synRationLimiteEnable)) {
            tcpDefendPolicyForm.setSynratioEnable(true);
            if (!ZoneImportParserUtil.isEmptyString(synratioLimitPackets)) {
                tcpDefendPolicyForm.setSynratioLimitPackets(Integer.valueOf(synratioLimitPackets));
            }
            if (!ZoneImportParserUtil.isEmptyString(synRationLimiteThreshold)) {
                tcpDefendPolicyForm.setSynratioLimitRate(Integer.valueOf(synRationLimiteThreshold));
            }
            if (!ZoneImportParserUtil.isEmptyString(synRationLimitecycle)) {
                tcpDefendPolicyForm.setSynratioDuration(Integer.valueOf(synRationLimitecycle));
            }
            if (!ZoneImportParserUtil.isEmptyString(synRationLimitePacketsThreshold)) {
                tcpDefendPolicyForm.setSynMaxPackets(Integer.valueOf(synRationLimitePacketsThreshold));
            }
            if (!ZoneImportParserUtil.isEmptyString(synRationLimitePacketscycle)) {
                tcpDefendPolicyForm.setSynMaxPacketsDuration(Integer.valueOf(synRationLimitePacketscycle));
            }
            if (TRUE.equals(synBlackListEnable)) {
                tcpDefendPolicyForm.setSynBlackListEnable(true);
                if (!ZoneImportParserUtil.isEmptyString(synExceptionTimes)) {
                    tcpDefendPolicyForm.setSynExceptionTimes(Integer.valueOf(synExceptionTimes));
                }
                if (!ZoneImportParserUtil.isEmptyString(synTotalCheckTimes)) {
                    tcpDefendPolicyForm.setSynTotalCheckTimes(Integer.valueOf(synTotalCheckTimes));
                }
            } else {
                tcpDefendPolicyForm.setSynBlackListEnable(false);
            }
        } else {
            tcpDefendPolicyForm.setSynratioEnable(false);
        }
        if (TRUE.equals(tcpConnectionDefenseEnable)) {
            tcpDefendPolicyForm.setTcpConnEnable(true);
        } else {
            tcpDefendPolicyForm.setTcpConnEnable(false);
        }
        if (TRUE.equals(newSourceIpAddressEnable)) {
            tcpDefendPolicyForm.setTcpNewSrctipEnable(true);
            if (!ZoneImportParserUtil.isEmptyString(newSourceIpAddressThreshold)) {
                tcpDefendPolicyForm.setTcpNewSrctipRate(Integer.valueOf(newSourceIpAddressThreshold));
            }
            if (!ZoneImportParserUtil.isEmptyString(newSourceIpAddressCheckCycle)) {
                tcpDefendPolicyForm.setTcpNewSrctipInterval(Integer.valueOf(newSourceIpAddressCheckCycle));
            }
        } else {
            tcpDefendPolicyForm.setTcpNewSrctipEnable(false);
        }
        if (TRUE.equals(sourceIpAddressEnable)) {
            tcpDefendPolicyForm.setTcpSrctipEnable(true);
            if (!ZoneImportParserUtil.isEmptyString(sourceIpAddressThreshold)) {
                tcpDefendPolicyForm.setTcpSrctipNum(Integer.valueOf(sourceIpAddressThreshold));
            }
        } else {
            tcpDefendPolicyForm.setTcpSrctipEnable(false);
        }
        return tcpDefendPolicyForm;
    }

    private static void initZoneServicedData(String deviceIp, ZoneServiceForm zoneServiceForm) {
        zoneServiceForm.setDirection(2);
        zoneServiceForm.setServiceName("Basic_Outbound_" + deviceIp.replace(".", "_"));
        zoneServiceForm.setDeviceIp(deviceIp);
        zoneServiceForm.setProtocol(POLICY_PROTOCOL_DEFAULT);
    }

    private static ZoneServiceForm initZoneServiceForm(boolean isSupportOutbound) {
        ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
        zoneServiceForm.setDirection(2);
        NfaPolicyEditForm nfaPolicyEditForm = new NfaPolicyEditForm();
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        UdpDefendPolicyForm udpDefendPolicyForm = new UdpDefendPolicyForm();
        IcmpDefendPolicyForm icmpDefendPolicyForm = new IcmpDefendPolicyForm();
        if (isSupportOutbound) {
            tcpDefendPolicyForm.setDirection(2);
            udpDefendPolicyForm.setDirection(2);
            icmpDefendPolicyForm.setDirection(2);
            nfaPolicyEditForm.setDirection(2);
        }
        HttpDefendPolicyForm httpDefendPolicyForm = new HttpDefendPolicyForm();
        HttpsDefendPolicyForm httpsDefendPolicyForm = new HttpsDefendPolicyForm();
        DnsDefendPolicyForm dnsDefendPolicyForm = new DnsDefendPolicyForm();
        SipDefendPolicyForm sipDefendPolicyForm = new SipDefendPolicyForm();
        OtherDefendPolicyForm otherDefendPolicyForm = new OtherDefendPolicyForm();
        zoneServiceForm.setTcpDefendPolicyForm(tcpDefendPolicyForm);
        zoneServiceForm.setUdpDefendPolicyForm(udpDefendPolicyForm);
        zoneServiceForm.setHttpDefendPolicyForm(httpDefendPolicyForm);
        zoneServiceForm.setHttpsDefendPolicyForm(httpsDefendPolicyForm);
        zoneServiceForm.setIcmpDefendPolicyForm(icmpDefendPolicyForm);
        zoneServiceForm.setDnsDefendPolicyForm(dnsDefendPolicyForm);
        zoneServiceForm.setSipDefendPolicyForm(sipDefendPolicyForm);
        zoneServiceForm.setOtherDefendPolicyForm(otherDefendPolicyForm);
        zoneServiceForm.setNfaPolicyEditForm(nfaPolicyEditForm);
        return zoneServiceForm;
    }

    private static void parserFaultSeverityRule(ZonePolicyApplyForm zonePolicyApplyForm, Element element, boolean isInbound) {
        Element ruleTemp = element.element("fault-severity-rule-list");
        if (null == ruleTemp) {
            return;
        }
        List elementRuleList = ruleTemp.elements("fault-severity-rule");
        if (null != elementRuleList && !elementRuleList.isEmpty()) {
            FaultSeverityRuleForm faultSeverityRuleForm = new FaultSeverityRuleForm();
            FaultSeverityRule faultSeverityRule = null;
            for (Element elementRule : elementRuleList) {
                String severity = elementRule.elementText("severity");
                String inTrafficMbpsStatus = elementRule.elementText("in-traffic-mbps-status");
                String inTrafficMbps = TRUE;
                if (TRUE.equals(inTrafficMbpsStatus) && CheckImportXml.isGreaterThan0(elementRule.elementText("in-traffic-mbps"))) {
                    inTrafficMbps = elementRule.elementText("in-traffic-mbps");
                }
                String inTrafficppsStatus = elementRule.elementText("in-traffic-pps-status");
                String inTrafficpps = TRUE;
                if (TRUE.equals(inTrafficppsStatus) && CheckImportXml.isGreaterThan0(elementRule.elementText("in-traffic-pps"))) {
                    inTrafficpps = elementRule.elementText("in-traffic-pps");
                }
                String currentConnStatus = "";
                String currentConn = TRUE;
                String newConnStatus = "";
                String newConn = TRUE;
                if (isInbound) {
                    currentConnStatus = elementRule.elementText("current-conn-status");
                    if (TRUE.equals(currentConnStatus) && CheckImportXml.isGreaterThan0(elementRule.elementText("current-conn"))) {
                        currentConn = elementRule.elementText("current-conn");
                    }
                    if (TRUE.equals(newConnStatus = elementRule.elementText("new-conn-status")) && CheckImportXml.isGreaterThan0(elementRule.elementText("new-conn"))) {
                        newConn = elementRule.elementText("new-conn");
                    }
                }
                String durationStatus = elementRule.elementText("duration-status");
                String duration = TRUE;
                if (TRUE.equals(durationStatus) && CheckImportXml.isGreaterThan0(elementRule.elementText("duration"))) {
                    duration = elementRule.elementText("duration");
                }
                String diversionAction = elementRule.elementText("diversion-action");
                if (ZoneImportParserUtil.isEmptyString(severity)) continue;
                faultSeverityRule = new FaultSeverityRule();
                faultSeverityRule.setSeverity(Integer.parseInt(severity));
                if (!ZoneImportParserUtil.isEmptyString(inTrafficMbpsStatus)) {
                    faultSeverityRule.setInTrafficMbpsStatus(Integer.parseInt(inTrafficMbpsStatus));
                }
                if (!ZoneImportParserUtil.isEmptyString(inTrafficMbps)) {
                    faultSeverityRule.setInTrafficMbps(Integer.parseInt(inTrafficMbps));
                }
                if (!ZoneImportParserUtil.isEmptyString(inTrafficppsStatus)) {
                    faultSeverityRule.setInTrafficppsStatus(Integer.parseInt(inTrafficppsStatus));
                }
                if (!ZoneImportParserUtil.isEmptyString(inTrafficpps)) {
                    faultSeverityRule.setInTrafficpps(Integer.parseInt(inTrafficpps));
                }
                if (!ZoneImportParserUtil.isEmptyString(currentConnStatus)) {
                    faultSeverityRule.setCurrentConnStatus(Integer.parseInt(currentConnStatus));
                }
                if (!ZoneImportParserUtil.isEmptyString(currentConn)) {
                    faultSeverityRule.setCurrentConn(Integer.parseInt(currentConn));
                }
                if (!ZoneImportParserUtil.isEmptyString(newConnStatus)) {
                    faultSeverityRule.setNewConnStatus(Integer.parseInt(newConnStatus));
                }
                if (!ZoneImportParserUtil.isEmptyString(newConn)) {
                    faultSeverityRule.setNewConn(Integer.parseInt(newConn));
                }
                if (!ZoneImportParserUtil.isEmptyString(durationStatus)) {
                    faultSeverityRule.setDurationStatus(Integer.parseInt(durationStatus));
                }
                if (!ZoneImportParserUtil.isEmptyString(duration)) {
                    faultSeverityRule.setDuration(Integer.parseInt(duration));
                }
                if (!ZoneImportParserUtil.isEmptyString(diversionAction)) {
                    faultSeverityRule.setDiversionAction(Integer.parseInt(diversionAction));
                }
                if (isInbound) {
                    faultSeverityRule.setDirection(1);
                } else {
                    faultSeverityRule.setDirection(2);
                }
                if ("4".equals(severity)) {
                    faultSeverityRuleForm.setCriticalRule(faultSeverityRule);
                    continue;
                }
                if ("3".equals(severity)) {
                    faultSeverityRuleForm.setMajorRule(faultSeverityRule);
                    continue;
                }
                if ("2".equals(severity)) {
                    faultSeverityRuleForm.setMinorRule(faultSeverityRule);
                    continue;
                }
                if (!TRUE.equals(severity)) continue;
                faultSeverityRuleForm.setWarningRule(faultSeverityRule);
            }
            if (isInbound) {
                zonePolicyApplyForm.setFaultSeverityRuleForm(faultSeverityRuleForm);
            } else {
                zonePolicyApplyForm.setOutboundFaultSeverityRuleForm(faultSeverityRuleForm);
            }
        }
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

