/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import java.util.HashMap;
import java.util.List;

public class FilterDeviceZoneStatusDao
extends BaseDao<FilterDeviceZoneStatusInfo, Long> {
    public FilterDeviceZoneStatusDao() {
        super(FilterDeviceZoneStatusInfo.class);
    }

    public List<FilterDeviceZoneStatusInfo> getDeployedByFilterId(Long filterId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deployState = true";
        return this.getHibernateTemplate().find(hql, new Object[]{filterId});
    }

    public FilterDeviceZoneStatusInfo isDeployedByFilterId(Long filterId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deployState = false";
        List hiList = this.getHibernateTemplate().find(hql, new Object[]{filterId});
        if (hiList != null && !hiList.isEmpty()) {
            return (FilterDeviceZoneStatusInfo)hiList.get(0);
        }
        return null;
    }

    public FilterDeviceZoneStatusInfo getFilterInfoByFilterId(Long filterId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0";
        List hiList = this.getHibernateTemplate().find(hql, new Object[]{filterId});
        if (hiList != null && !hiList.isEmpty()) {
            for (FilterDeviceZoneStatusInfo info : hiList) {
                if ("".equals(info.getErrorCode())) continue;
                return info;
            }
        }
        return null;
    }

    public List<FilterDeviceZoneStatusInfo> getDeployedByZoneId(Long zoneId) {
        String hql = "from FilterDeviceZoneStatusInfo where zoneId = ?0 and deployState = true";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<FilterDeviceZoneStatusInfo> getFailedByZoneId(Long zoneId) {
        String hql = "from FilterDeviceZoneStatusInfo where zoneId = ?0 and deployState = false";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<FilterDeviceZoneStatusInfo> getFailedByDeviceIdAndZoneId(Long deviceId, Long zoneId) {
        String hql = "from FilterDeviceZoneStatusInfo where deviceId = ?0 and zoneId = ?1 and deployState = false";
        return this.getHibernateTemplate().find(hql, new Object[]{deviceId, zoneId});
    }

    public List<FilterDeviceZoneStatusInfo> getByZoneId(Long zoneId) {
        String hql = "from FilterDeviceZoneStatusInfo where zoneId = ?0 ";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public void deleteByDeviceIdAndZoneId(Long deviceId, Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ").append(this.persistentClass.getSimpleName()).append(" where deviceId = ?0  and zoneId = ?1 ");
        condition.put(0, deviceId);
        condition.put(1, zoneId);
        this.executeHql(hql.toString(), condition);
    }

    public void deleteListByZoneId(Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ").append(this.persistentClass.getSimpleName()).append(" where zoneId = ?0 ");
        condition.put(0, zoneId);
        this.executeHql(hql.toString(), condition);
    }

    public void deleteByFilterId(Long filterId) {
        String hql = "delete from FilterDeviceZoneStatusInfo where filterId = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{filterId});
    }

    public void deleteByFilterIdAndDeviceIdAndZoneId(Long filterId, Long deviceId, Long zoneId) {
        String hql = "delete from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 and zoneId = ?2";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{filterId, deviceId, zoneId});
    }

    public void deleteByFilterIdAndDeviceIdAndZoneId(Long filterId, Long deviceId, Long zoneId, int direction) {
        String hql = "delete from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 and zoneId = ?2 and direction = ?3";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{filterId, deviceId, zoneId, direction});
    }

    public FilterDeviceZoneStatusInfo getByFilterIdAndDeviceIdAndZoneId(Long filterId, Long deviceId, Long zoneId, int direction) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 and zoneId =?2 and direction =?3";
        List filterDeviceZoneStatusInfoList = this.getHibernateTemplate().find(hql, new Object[]{filterId, deviceId, zoneId, direction});
        if (filterDeviceZoneStatusInfoList != null && !filterDeviceZoneStatusInfoList.isEmpty()) {
            return (FilterDeviceZoneStatusInfo)filterDeviceZoneStatusInfoList.get(0);
        }
        return null;
    }

    public FilterDeviceZoneStatusInfo getByFilterIdAndDeviceIdAndZoneId(Long filterId, Long deviceId, Long zoneId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 and zoneId =?2";
        List filterDeviceZoneStatusInfoList = this.getHibernateTemplate().find(hql, new Object[]{filterId, deviceId, zoneId});
        if (filterDeviceZoneStatusInfoList != null && !filterDeviceZoneStatusInfoList.isEmpty()) {
            return (FilterDeviceZoneStatusInfo)filterDeviceZoneStatusInfoList.get(0);
        }
        return null;
    }

    public List<FilterDeviceZoneStatusInfo> getInfosByFilterIdAndDeviceIdAndZoneId(Long filterId, Long deviceId, Long zoneId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 and zoneId =?2";
        List filterDeviceZoneStatusInfoList = this.getHibernateTemplate().find(hql, new Object[]{filterId, deviceId, zoneId});
        if (filterDeviceZoneStatusInfoList != null && !filterDeviceZoneStatusInfoList.isEmpty()) {
            return filterDeviceZoneStatusInfoList;
        }
        return null;
    }

    public List<FilterDeviceZoneStatusInfo> getByFilterId(Long filterId) {
        if (null != filterId) {
            StringBuffer hql = new StringBuffer("from FilterDeviceZoneStatusInfo info where 1=1");
            hql.append(" and info.filterId= ?0");
            return this.getHibernateTemplate().find(hql.toString(), new Object[]{filterId});
        }
        return null;
    }

    public List<FilterDeviceZoneStatusInfo> getInitFilterDefineByFilterId(Long filterId) {
        if (null != filterId) {
            StringBuffer hql = new StringBuffer("from FilterDeviceZoneStatusInfo info where 1=1");
            hql.append(" and info.filterId= ?0 and filterDefineState = false");
            return this.getHibernateTemplate().find(hql.toString(), new Object[]{filterId});
        }
        return null;
    }

    public List<FilterDeviceZoneStatusInfo> getDeployZonesByFilterId(Long filterId) {
        if (null != filterId) {
            StringBuffer hql = new StringBuffer("from FilterDeviceZoneStatusInfo info where 1=1");
            hql.append(" and info.filterId= ?0 and  filterDefineState = true");
            return this.getHibernateTemplate().find(hql.toString(), new Object[]{filterId});
        }
        return null;
    }

    public List<FilterDeviceZoneStatusInfo> getDeployedByZoneIdAndDeviceId(Long zoneId, Long deviceId) {
        String hql = "from FilterDeviceZoneStatusInfo where zoneId = ?0 and deviceId = ?1 and deployState = true";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId, deviceId});
    }

    public List<FilterDeviceZoneStatusInfo> getDeployedByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 and deployState = true";
        return this.getHibernateTemplate().find(hql, new Object[]{filterId, deviceId});
    }

    public List<FilterDeviceZoneStatusInfo> getDeployedForZoneByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 and deployState = true and zoneId <> 0";
        return this.getHibernateTemplate().find(hql, new Object[]{filterId, deviceId});
    }

    public List<FilterDeviceZoneStatusInfo> getFilterDefineDeployedByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 and filterDefineState = true and zoneId <> 0";
        return this.getHibernateTemplate().find(hql, new Object[]{filterId, deviceId});
    }

    public List<FilterDeviceZoneStatusInfo> getByZoneIdAndDeviceId(Long zoneId, Long deviceId) {
        String hql = "from FilterDeviceZoneStatusInfo where zoneId = ?0 and deviceId = ?1 ";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId, deviceId});
    }

    public void deleteByDeviceId(Long deviceId) {
        String hql = "delete from FilterDeviceZoneStatusInfo where deviceId = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
    }

    public List<FilterDeviceZoneStatusInfo> findByDeviceId(Long deviceId) {
        String hql = "from FilterDeviceZoneStatusInfo where deviceId = ?0";
        return this.getHibernateTemplate().find(hql, new Object[]{deviceId});
    }

    public void updateFilterDefineState(Long filterId, Long deviceId, Long zoneId) {
        String hql = "update FilterDeviceZoneStatusInfo set filterDefineState = false where filterId = ?0 and deviceId=?1 and zoneId=?2 and direction = 1";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{filterId, deviceId, zoneId});
    }

    public void updateDeploydFilterDefineState(Long filterId, Long deviceId, Long zoneId) {
        String hql = "update FilterDeviceZoneStatusInfo set filterDefineState = true where filterId = ?0 and deviceId=?1 and zoneId=?2";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{filterId, deviceId, zoneId});
    }

    public void updateDeploydFilterErrorCode(Long filterId, Long deviceId, Long zoneId, String errorCode) {
        String hql = "update FilterDeviceZoneStatusInfo set errorCode = ?0 where filterId = ?1 and deviceId=? and zoneId=?2";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{errorCode, filterId, deviceId, zoneId});
    }

    public List<FilterDeviceZoneStatusInfo> getByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        String hql = "from FilterDeviceZoneStatusInfo where filterId = ?0 and deviceId = ?1 ";
        return this.getHibernateTemplate().find(hql, new Object[]{filterId, deviceId});
    }
}

