/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.model.NPFilterInfo;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class NPFilterDao
extends BaseDao<NPFilterInfo, Long> {
    public Paging qeuryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from NPFilterInfo where (1=1) ";
        int index = 0;
        String npFilterName = conditionMap.get("npFilterName");
        if (!AticUtil.isNull((String)npFilterName)) {
            hql = hql + " and lower(filterName) like ?0 ";
            queryMap.put(index, "%" + npFilterName.trim().toLowerCase(Locale.ENGLISH) + "%");
        }
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.queryPageByHql(hql, start, pageSize, queryMap);
        int totalCount = this.getRowCountByHsql(hql, queryMap);
        page.setCount(totalCount);
        page.setData(result);
        return page;
    }

    public NPFilterInfo getById(long pkid) {
        String hql = "from NPFilterInfo where id = ?0 ";
        HashMap<Integer, Long> param = new HashMap<Integer, Long>();
        param.put(0, pkid);
        List result = this.queryByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (NPFilterInfo)result.get(0);
    }

    public NPFilterInfo getByFilterIndex(Integer filterIndex) {
        String hql = "from NPFilterInfo where filterIndex = ?0 ";
        HashMap<Integer, Integer> param = new HashMap<Integer, Integer>();
        param.put(0, filterIndex);
        List result = this.queryByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (NPFilterInfo)result.get(0);
    }

    public List<Integer> queryAllFilterIndex() {
        String hql = "select filterIndex from NPFilterInfo";
        List result = super.getHibernateTemplate().find(hql, new Object[0]);
        if (result == null || result.isEmpty()) {
            return new ArrayList<Integer>();
        }
        return result;
    }

    public void deleteById(long filterId) {
        String hql = "delete from NPFilterInfo where id = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{filterId});
    }

    public List<NPFilterInfo> queryByNpFilterName(String npFilterName, Long filterId) {
        String hql = "from NPFilterInfo where filterName = ?0";
        HashMap<Integer, Object> param = new HashMap<Integer, Object>();
        param.put(0, npFilterName);
        if (null != filterId) {
            hql = hql + " and id <> ?1";
            param.put(1, filterId);
        }
        return this.queryByHql(hql, param);
    }

    public List<NPFilterInfo> queryAllInfoExcludeFilterId(Long filterId) {
        String hql = "from NPFilterInfo where 1=1";
        if (null != filterId) {
            hql = hql + " and id <> " + filterId;
        }
        return this.findByHql(hql);
    }

    public int getCountNpFilter() {
        String hql = "from NPFilterInfo";
        List npFilterList = this.findByHql(hql);
        if (null != npFilterList && !npFilterList.isEmpty()) {
            return npFilterList.size();
        }
        return 0;
    }

    public List<NPFilterInfo> getAllFilter() {
        String hql = "from NPFilterInfo ";
        List result = this.findByHql(hql);
        if (result == null || result.isEmpty()) {
            return new ArrayList<NPFilterInfo>();
        }
        return result;
    }
}

