/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.vsm.secservice.ddos.model.NfaPolicyInfo;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import java.util.HashMap;
import java.util.List;

public class NfaPolicyDao
extends BaseDao<NfaPolicyInfo, Long> {
    public NfaPolicyDao() {
        super(NfaPolicyInfo.class);
    }

    public List<NfaPolicyInfo> queryByServiceId(Long serviceId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("from ").append(this.persistentClass.getSimpleName()).append(" where serviceId = ?0 ");
        condition.put(0, serviceId);
        List list = this.queryByHql(hql.toString(), condition);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<NfaPolicyInfo> queryListByTemplateId(Long templateId, String deviceType) {
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        String hql = "FROM NfaPolicyInfo WHERE pkid IN (SELECT t.childrenId FROM ZoneTemplateItemsInfo t WHERE t.templateId = ?0  and t.type= ?1 )";
        condition.put(0, templateId);
        condition.put(1, deviceType);
        List nfaPolicyInfos = this.queryByHql(hql, condition);
        if (null == nfaPolicyInfos || nfaPolicyInfos.isEmpty()) {
            return null;
        }
        return nfaPolicyInfos;
    }

    public List<NfaPolicyInfo> queryListByServiceId(Long serviceId, int direction) {
        HashMap<Integer, Number> condition = new HashMap<Integer, Number>();
        String hql = "FROM NfaPolicyInfo WHERE serviceId = ?0  and direction = ?1";
        condition.put(0, serviceId);
        condition.put(1, direction);
        List nfaPolicyInfos = this.queryByHql(hql, condition);
        if (null == nfaPolicyInfos || nfaPolicyInfos.isEmpty()) {
            return null;
        }
        return nfaPolicyInfos;
    }

    public List<NfaPolicyInfo> queryListByServiceId(Long serviceId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        String hql = "FROM NfaPolicyInfo WHERE serviceId = ?0";
        condition.put(0, serviceId);
        List nfaPolicyInfos = this.queryByHql(hql, condition);
        if (null == nfaPolicyInfos || nfaPolicyInfos.isEmpty()) {
            return null;
        }
        return nfaPolicyInfos;
    }

    public List<NfaPolicyInfo> queryNfaPolicyByServiceId(Long serviceId, int direction) {
        HashMap<Integer, Number> condition = new HashMap<Integer, Number>();
        String hql = "FROM NfaPolicyInfo WHERE serviceId = ?0 and direction = ?1";
        condition.put(0, serviceId);
        condition.put(1, direction);
        List nfaPolicyInfos = this.queryByHql(hql, condition);
        if (null == nfaPolicyInfos || nfaPolicyInfos.isEmpty()) {
            return null;
        }
        return nfaPolicyInfos;
    }

    public void deleteNfaPolicy(long zoneId) {
        String hql = "delete from NfaPolicyInfo where zoneId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void deleteNfaPolicyTemplate(Long templateId) {
        String hql = "delete from NfaPolicyInfo  where pkid in(SELECT pkid FROM ZoneTemplateItemsInfo where templateId = ?0) and serviceId is null";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{templateId});
    }

    public List<NfaPolicyInfo> queryByZoneId(Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("from ").append(this.persistentClass.getSimpleName()).append(" where zoneId = ?0 ");
        condition.put(0, zoneId);
        List list = this.queryByHql(hql.toString(), condition);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<NfaPolicyInfo> queryByZoneIdAndServiceId(Long zoneId, Long deviceId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        String hql = "FROM NfaPolicyInfo WHERE zoneId = ?0 and serviceId = (SELECT t.pkid FROM ZoneServiceInfo t WHERE t.deviceId = ?1 and t.zoneId = ?2 ) ";
        condition.put(0, zoneId);
        condition.put(1, deviceId);
        condition.put(2, zoneId);
        List nfaPolicyInfos = this.queryByHql(hql, condition);
        if (null == nfaPolicyInfos || nfaPolicyInfos.isEmpty()) {
            return null;
        }
        return nfaPolicyInfos;
    }

    public void deleteNfaDevice(long zoneId, long deviceId) {
        String hql = "delete from NfaPolicyInfo where zoneId = ?0 AND serviceId in (SELECT t.pkid FROM ZoneServiceInfo t WHERE t.deviceId = ?1 and t.zoneId = ?2)";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId, deviceId, zoneId});
    }
}

