/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.model.VpnDeviceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class VpnDeviceDao
extends CommonDaoImpl {
    public void delete(String[] deleteIdList) {
        if (deleteIdList == null) {
            return;
        }
        StringBuffer hql = new StringBuffer();
        ArrayList<Long> idList = new ArrayList<Long>();
        hql.append("delete from VpnDeviceInfo where id in ( ");
        for (int i = 0; i < deleteIdList.length; ++i) {
            idList.add(Long.valueOf(deleteIdList[i]));
            if (0 == i) {
                hql.append("?" + i);
                continue;
            }
            hql.append(",?" + i);
        }
        hql.append(')');
        this.getHibernateTemplate().bulkUpdate(hql.toString(), idList.toArray());
    }

    public void deleteIncludeVpnByZoneId(Long zoneId) {
        if (zoneId == null) {
            return;
        }
        String hql = "delete from VpnDeviceInfo where vpnType = 1 and zoneId = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String vpnIp;
        String vpnName;
        String vpnType;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from VpnDeviceInfo where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String zoneId = conditionMap.get("zoneId");
        if (!AticUtil.isNull((String)zoneId)) {
            hql = hql + " and zoneId = ?" + index;
            queryMap.put(index++, zoneId);
        }
        if (!AticUtil.isNull((String)(vpnType = conditionMap.get("vpnType")))) {
            hql = hql + " and vpnType = ?" + index;
            queryMap.put(index++, vpnType);
        }
        if (!AticUtil.isNull((String)(vpnName = conditionMap.get("vpnName")))) {
            hql = hql + " and lower(vpnName) like ?" + index;
            queryMap.put(index++, vpnName.trim().toLowerCase(Locale.ENGLISH));
        }
        if (!AticUtil.isNull((String)(vpnIp = conditionMap.get("vpnIp")))) {
            String completeIp = IPUtil4Atic.convert2CompleteIp((String)vpnIp);
            hql = hql + " and startIp <= ?" + index;
            queryMap.put(index++, completeIp);
            hql = hql + " and endIp >= ?" + index;
            queryMap.put(index++, completeIp);
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            if (sortName.equalsIgnoreCase("destIp")) {
                sortName = "fullFormatIp";
            }
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<VpnDeviceInfo> findIncludedVpn(Long deviceId, Long zoneId, String startIp, String endIp) {
        return this.findVpn(deviceId, zoneId, startIp, endIp, 1);
    }

    public List<VpnDeviceInfo> findExcludedVpn(Long deviceId, Long zoneId, String startIp, String endIp) {
        return this.findVpn(deviceId, zoneId, startIp, endIp, 2);
    }

    public List<VpnDeviceInfo> findVpn(Long deviceId, Long zoneId, String startIp, String endIp, Integer vpnType) {
        String completeStartIp = IPUtil4Atic.convert2CompleteIp((String)startIp);
        String completeEndIp = IPUtil4Atic.convert2CompleteIp((String)endIp);
        if (deviceId == 0L || zoneId == 0L || startIp == null || endIp == null) {
            return null;
        }
        String hql = "from VpnDeviceInfo where deviceId=?0 and zoneId=?1 and vpnType=?2 and startIp<=?3 and endIp>=?4 and LENGTH(startIp)=?5";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, zoneId.toString());
        param.put(2, vpnType.toString());
        param.put(3, completeEndIp);
        param.put(4, completeStartIp);
        param.put(5, String.valueOf(completeStartIp.length()));
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<VpnDeviceInfo>();
        }
        VpnDeviceInfo infoTemp = null;
        VpnDeviceInfo vpnDeviceStart = null;
        VpnDeviceInfo vpnDeviceEnd = null;
        String ipMaskStart = "";
        String ipMaskEnd = "";
        for (int i = 0; i < result.size() - 1; ++i) {
            for (int j = i + 1; j < result.size(); ++j) {
                int maskEnd;
                vpnDeviceStart = (VpnDeviceInfo)result.get(i);
                vpnDeviceEnd = (VpnDeviceInfo)result.get(j);
                ipMaskStart = ((VpnDeviceInfo)result.get(i)).getIpMask();
                ipMaskEnd = ((VpnDeviceInfo)result.get(j)).getIpMask();
                int maskStart = this.getMask(ipMaskStart);
                if (maskStart >= (maskEnd = this.getMask(ipMaskEnd))) continue;
                infoTemp = vpnDeviceEnd;
                vpnDeviceEnd = vpnDeviceStart;
                vpnDeviceStart = infoTemp;
                result.set(i, vpnDeviceStart);
                result.set(j, vpnDeviceEnd);
            }
        }
        return result;
    }

    public List<VpnDeviceInfo> findIncludedVpn(Long deviceId, Long zoneId) {
        if (deviceId == null || zoneId == null) {
            return null;
        }
        String hql = "from VpnDeviceInfo where deviceId=?0 and zoneId=?1 and vpnType = 1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<VpnDeviceInfo>();
        }
        return result;
    }

    private int getMask(String ipMask) {
        int mask = Integer.parseInt(ipMask.substring(ipMask.indexOf(47) + 1));
        return mask;
    }
}

