/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZoneDeviceDao
extends CommonDaoImpl {
    public List<Long> getByDevId(Long devId) {
        if (devId == null) {
            return new ArrayList<Long>();
        }
        String hql = "select zoneId from ZoneDeviceInfo where deviceId = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, devId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<Long>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<Long>();
    }

    public Long getDefaultZoneIdByDevId(Long deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "select zi.zoneId from ZoneDeviceInfo zdi, ZoneInfo zi where zdi.zoneId=zi.zoneId and zi.zoneType=1 and zdi.deviceId=?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (Long)result.get(0);
    }

    public List<Long> getDeviceIdsByZoneId(Long zoneId) {
        if (zoneId == null) {
            return new ArrayList<Long>();
        }
        String hql = "select deviceId from ZoneDeviceInfo where zoneId = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<Long>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<Long>();
    }

    public void createOrUpdate(ZoneDeviceForm form) {
        this.saveOrUpdate(form);
    }

    public List<ZoneDeviceInfo> getByZoneId(Long zoneId) {
        if (zoneId == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        String hql = "from ZoneDeviceInfo where zoneId = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<ZoneDeviceInfo>();
    }

    public List<ZoneDeviceInfo> getByZoneId(Long zoneId, long userId, boolean isAdmin) {
        if (zoneId == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        StringBuffer hql = new StringBuffer("from ZoneDeviceInfo where zoneId = ?0");
        if (userId > 1L && !isAdmin) {
            hql.append(" and  device_id in (" + CheckChildrenMoUtil.getInstanse().getHql(userId) + ")");
        }
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        List result = this.findByHql(hql.toString(), param);
        if (result == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<ZoneDeviceInfo>();
    }

    public List<ZoneDeviceInfo> getByDeviceId(Long deviceId) {
        if (deviceId == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        String hql = "from ZoneDeviceInfo where deviceId = ?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<ZoneDeviceInfo>();
    }

    public List<ZoneDeviceInfo> getByZoneIdAndDevId(Long zoneId, Long deviceId) {
        if (zoneId == null || deviceId == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        String hql = "from ZoneDeviceInfo where zoneId = ?0 and deviceId = ?1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        param.put(1, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<ZoneDeviceInfo>();
    }

    public List<Long> getZoneIdHaveDevice() {
        String hql = "select distinct zoneId from ZoneDeviceInfo";
        List result = this.findByHql(hql);
        if (result == null) {
            return new ArrayList<Long>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<Long>();
    }

    public void deleteByDeviceId(Long deviceId) {
        if (deviceId == null) {
            return;
        }
        String hql = "delete from ZoneDeviceInfo where deviceId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
    }

    public void deleteByZoneId(Long zoneId) {
        if (zoneId == null) {
            return;
        }
        String hql = "delete from ZoneDeviceInfo where zoneId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void deleteByDeviceIdAndZoneId(Long deviceId, Long zoneId) {
        if (deviceId == null || zoneId == null) {
            return;
        }
        String hql = "delete from ZoneDeviceInfo where deviceId=?0 and zoneId=?1";
        Object[] param = new Object[]{deviceId, zoneId};
        this.getHibernateTemplate().bulkUpdate(hql, param);
    }

    public List<Long> findPkIdByZoneIdAndDeviceId(Long zoneId, List<Long> deviceIds) {
        if (zoneId == null || deviceIds == null || deviceIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(zoneId));
        hql.append("select id from ZoneDeviceInfo where zoneId=?0 and deviceId in (");
        this.getHqlByFor(deviceIds, hql, param);
        hql.append(")");
        List result = this.findByHql(hql.toString(), param);
        if (result == null) {
            return new ArrayList<Long>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<Long>();
    }

    private void getHqlByFor(List<Long> deviceIds, StringBuffer hql, Map<Integer, String> param) {
        for (int i = 0; i < deviceIds.size(); ++i) {
            param.put(i + 1, String.valueOf(deviceIds.get(i)));
            if (0 == i) {
                hql.append("?" + (i + 1));
                continue;
            }
            hql.append(",?" + (i + 1));
        }
    }

    public ZoneDeviceForm findZoneDeviceFormByZoneIdAndDeviceId(Long zoneId, Long deviceId) {
        if (zoneId == null || deviceId == null) {
            return null;
        }
        String hql = "from ZoneDeviceInfo where zoneId = ?0 and deviceId = ?1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        param.put(1, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result != null && !result.isEmpty()) {
            ZoneDeviceInfo zoneDeviceInfo = (ZoneDeviceInfo)result.get(0);
            ZoneDeviceForm zoneDeviceForm = new ZoneDeviceForm();
            VsmUtil.getInstance().copyProperties(zoneDeviceInfo, zoneDeviceForm);
            return zoneDeviceForm;
        }
        return null;
    }

    public void updateDeviceIdByZoneId(Long zoneId, Long lastTimeDeviceId, Long deviceId) {
        String hql = "update ZoneDeviceInfo set deviceId = ?0 where zoneId = ?1 and deviceId = ?2";
        Object[] objArr = new Object[]{deviceId, zoneId, lastTimeDeviceId};
        this.getHibernateTemplate().bulkUpdate(hql, objArr);
    }

    public List<ZoneDeviceInfo> queryAllDeviceAssociatedZone() {
        String hql = "from ZoneDeviceInfo GROUP BY deviceId";
        List result = this.findByHql(hql);
        if (result == null) {
            return new ArrayList<ZoneDeviceInfo>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<ZoneDeviceInfo>();
    }
}

