/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.atic.sdk.bis.model.ZoneBaseLineStudyInfo;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoExceptionTranslator;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.model.ServiceLearningParamInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ZonePolicyApplyDao
extends CommonDaoImpl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String value;
        StringBuffer hql = new StringBuffer();
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        hql.append(" from ZonePolicyApplyInfo policy, com.hs.atic.zone.model.ZoneInfo info ");
        if (conditionMap.containsKey("adminId") && !Boolean.valueOf(conditionMap.get("isAdmin")).booleanValue()) {
            hql.append("," + CheckChildrenMoUtil.getInstanse().getGrantHqlObj());
        }
        hql.append(" where policy.zoneId = info.zoneId ");
        if (conditionMap.containsKey("zoneDeployState")) {
            String zoneDepSta = conditionMap.get("zoneDeployState");
            if (zoneDepSta.equals("UNDEPLOY")) {
                hql.append(" and policy.deployState = 'UNDEPLOY' ");
            } else if (zoneDepSta.equals("INCREAMENT_UNDEPLOY")) {
                hql.append(" and (policy.deployState = 'INCREAMENT_UNDEPLOY' or ( policy.deployState = 'SUCCESS' and policy.filterState = 'INCREAMENT_UNDEPLOY' ) or ( policy.deployState = 'PART_SUCCESS' and policy.filterState = 'INCREAMENT_UNDEPLOY' )) ");
            } else if (zoneDepSta.equals("SUCCESS")) {
                hql.append(" and (policy.deployState = 'SUCCESS' and (policy.filterState = 'SUCCESS' or policy.filterState = 'UNDEPLOY')) ");
            } else if (zoneDepSta.equals("PART_SUCCESS")) {
                hql.append(" and ((policy.deployState = 'SUCCESS' and policy.filterState = 'PART_SUCCESS') or (policy.deployState = 'PART_SUCCESS' and (policy.filterState = 'UNDEPLOY' or policy.filterState = 'SUCCESS' or policy.filterState = 'PART_SUCCESS'))) ");
            } else {
                hql.append(" and policy.deployState = ?" + index);
                queryMap.put(index++, conditionMap.get("zoneDeployState"));
            }
        }
        if (conditionMap.containsKey("filterZoneDeployState")) {
            hql.append(" and (policy.deployState = 'SUCCESS' or policy.deployState = 'INCREAMENT_UNDEPLOY')");
        }
        if (conditionMap.containsKey("zoneAbnormalState")) {
            hql.append(" and policy.abnormalState = ?" + index);
            queryMap.put(index++, conditionMap.get("zoneAbnormalState"));
        }
        if (conditionMap.containsKey("adminId") && !Boolean.valueOf(conditionMap.get("isAdmin")).booleanValue()) {
            hql.append(" and info.moId = " + CheckChildrenMoUtil.getInstanse().getGrantHql(Long.parseLong(conditionMap.get("adminId"))));
        }
        if (conditionMap.containsKey("zoneName")) {
            hql.append(" and ( upper(info.zoneName) like ?" + index);
            queryMap.put(index++, "%" + conditionMap.get("zoneName").trim().toUpperCase(Locale.ENGLISH) + "%");
            hql.append(" or upper(info.zoneDesc) like ?" + index);
            hql.append(')');
            queryMap.put(index++, "%" + conditionMap.get("zoneName").trim().toUpperCase(Locale.ENGLISH) + "%");
        }
        if (conditionMap.containsKey("zoneType")) {
            hql.append(" and info.zoneType = ?" + index);
            queryMap.put(index++, conditionMap.get("zoneType"));
        }
        if (conditionMap.containsKey("zoneIp")) {
            String zoneIp = IPUtil4Atic.convert2CompleteIp((String)conditionMap.get("zoneIp"));
            int ipLength = zoneIp.length();
            hql.append(" and info.zoneId IN ( SELECT zoneId FROM com.hs.atic.zone.model.ZoneIpInfo WHERE startIp <= ?" + index);
            queryMap.put(index++, zoneIp);
            hql.append(" and endIp >= ?" + index);
            queryMap.put(index++, zoneIp);
            hql.append(" and LENGTH(startIp) = ?" + index);
            queryMap.put(index++, String.valueOf(ipLength));
            hql.append(" AND LENGTH(endIp) = ?" + index + ")");
            queryMap.put(index++, String.valueOf(ipLength));
        }
        if (conditionMap.containsKey("exclude")) {
            String zoneIdString = conditionMap.get("exclude");
            String[] zoneIds = zoneIdString.split(",");
            hql.append(" and info.zoneId NOT IN (");
            for (int i = 0; i < zoneIds.length; ++i) {
                if (i == 0) {
                    hql.append("?" + index);
                } else {
                    hql.append(",?" + index);
                }
                queryMap.put(index++, zoneIds[i]);
            }
            hql.append(")");
        }
        if (conditionMap.containsKey("divertState")) {
            value = conditionMap.get("divertState");
            if (value.equals("0")) {
                hql.append(" and info.zoneId NOT IN (SELECT zoneId from DivertTactics WHERE divertStatus = 1 ) ");
            } else if (value.equals("1")) {
                hql.append(" and info.zoneId IN (SELECT zoneId from DivertTactics WHERE divertStatus = 1 ) ");
                hql.append(" and info.zoneId NOT IN (SELECT zoneId from DivertTactics WHERE divertStatus = 0 ) ");
            } else if (value.equals("2")) {
                hql.append(" and info.zoneId IN (SELECT zoneId from DivertTactics WHERE divertStatus = 1 ) ");
                hql.append(" and info.zoneId IN (SELECT zoneId from DivertTactics WHERE divertStatus = 0 ) ");
            } else if (value.equals("3")) {
                hql.append(" and info.zoneId IN (SELECT zoneId from DivertTactics WHERE divertStatus = 0 AND nfaId<>1) ");
            }
        }
        if (conditionMap.containsKey("baselineState")) {
            value = conditionMap.get("baselineState");
            if (value.equals("0")) {
                hql.append(" and info.zoneId NOT IN (SELECT zoneId from ZoneBaseLineStudyInfo WHERE status = 1 ) ");
            } else if (value.equals("1")) {
                hql.append(" and info.zoneId IN (SELECT zoneId from ZoneBaseLineStudyInfo WHERE status = 1 ) ");
            }
        }
        if (conditionMap.containsKey("serviceState")) {
            value = conditionMap.get("serviceState");
            if (value.equals("0")) {
                hql.append(" and info.zoneId NOT IN (SELECT zoneId from ServiceLearningParamInfo WHERE taskStatus = 1 ) ");
            } else if (value.equals("1")) {
                hql.append(" and info.zoneId IN (SELECT zoneId from ServiceLearningParamInfo WHERE taskStatus = 1 ) ");
            }
        }
        String hql4Count = "select count(*) as rowCount ";
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        hql.append(" order by case policy.abnormalState when 'ATTACKED' then 1 when 'ALERTED' then 2 else 3 end asc, lower(info.zoneDesc) asc");
        hql = new StringBuffer("select policy,info.zoneDesc ").append(hql);
        this.logger.info((Object)"query zone policy ");
        List result = this.findPage(hql.toString(), start, pageSize, queryMap);
        ArrayList<ZonePolicyApplyInfo> applyInfoList = new ArrayList<ZonePolicyApplyInfo>();
        ZonePolicyApplyInfo applyInfo = null;
        for (Object[] tempResult : result) {
            applyInfo = (ZonePolicyApplyInfo)tempResult[0];
            applyInfo.setZoneDesc((String)tempResult[1]);
            applyInfoList.add(applyInfo);
        }
        Paging page = new Paging();
        page.setCount(count.intValue());
        page.setData(applyInfoList);
        return page;
    }

    public List<ZonePolicyApplyInfo> queryPageByHql(String hql, int start, int pageSize) {
        InnerClassQuery innerClass = new InnerClassQuery(hql, start, pageSize);
        return (List)new HibernateTemplate(this.getSessionFactory()).execute((HibernateCallback)innerClass);
    }

    public ZonePolicyApplyInfo getByZoneId(Long zoneId) {
        String hql = "from ZonePolicyApplyInfo where zoneId = ?0 ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, zoneId.toString());
        List result = this.findByHql(hql, queryMap);
        if (null == result || result.isEmpty()) {
            return new ZonePolicyApplyInfo();
        }
        return (ZonePolicyApplyInfo)result.get(0);
    }

    public void deleteByZoneId(Long zoneId) {
        String hql1 = "delete from ZoneDeviceInfo where zoneId = ?0 ";
        String hql2 = "delete from ZonePolicyApplyInfo where zoneId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql1, new Object[]{zoneId});
        this.getHibernateTemplate().bulkUpdate(hql2, new Object[]{zoneId});
    }

    public List<ZonePolicyApplyInfo> getListByZoneId(Long zoneId) {
        String hql = "from ZonePolicyApplyInfo where zoneId = ?0 ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, zoneId.toString());
        List result = this.findByHql(hql, queryMap);
        if (result == null) {
            return new ArrayList<ZonePolicyApplyInfo>();
        }
        return result;
    }

    public void updateAbnormalState(Long zoneId, String abnormalState) {
        this.logger.info((Object)"enter updateAbnormalState function");
        this.logger.info((Object)("zoneId : " + zoneId));
        ZonePolicyApplyInfo zonePolicyApplyInfo = this.getByZoneId(zoneId);
        this.logger.info((Object)("collector notified abnormalState:" + this.getcleanedMessage(abnormalState)));
        if (null != zonePolicyApplyInfo) {
            zonePolicyApplyInfo.setAbnormalState(abnormalState);
            this.logger.info((Object)("zoneId is " + zonePolicyApplyInfo.getZoneId()));
            this.updateState(zonePolicyApplyInfo);
        } else {
            this.logger.error((Object)"zonePolicyApplyInfo is null");
        }
        this.logger.info((Object)"leave updateAbnormalState function");
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void updateState(ZonePolicyApplyInfo zonePolicyApplyInfo) {
        String hql = "update ZonePolicyApplyInfo set abnormalState = ?0 where zoneId = ?1 ";
        Object[] object = new Object[]{zonePolicyApplyInfo.getAbnormalState(), zonePolicyApplyInfo.getZoneId()};
        this.getHibernateTemplate().bulkUpdate(hql, object);
    }

    public int getServiceLearnState(long zoneId) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from ServiceLearningParamInfo ");
        hql.append(" where zoneId = ?0");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(zoneId));
        try {
            ServiceLearningParamInfo serviceLearn;
            List result = this.findByHql(hql.toString(), queryMap);
            if (null != result && !result.isEmpty() && (serviceLearn = (ServiceLearningParamInfo)result.get(0)).getTaskStatus().booleanValue()) {
                return 1;
            }
            return 0;
        }
        catch (HibernateException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public int getBaseLineState(long zoneId) {
        int baseLineState;
        block3: {
            StringBuffer hql = new StringBuffer();
            hql.append(" from ZoneBaseLineStudyInfo ");
            hql.append(" where zoneId =?0");
            HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
            queryMap.put(0, String.valueOf(zoneId));
            baseLineState = 0;
            try {
                List result = this.findByHql(hql.toString(), queryMap);
                if (null == result || result.isEmpty()) break block3;
                for (ZoneBaseLineStudyInfo zoneBaseLineInfo : result) {
                    if (zoneBaseLineInfo.getStatus() != 1) continue;
                    baseLineState = 1;
                    break;
                }
            }
            catch (HibernateException e) {
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
        }
        return baseLineState;
    }

    public List<ZonePolicyApplyInfo> queryByZoneIds(List<Long> zoneIds) {
        if (null == zoneIds || zoneIds.isEmpty()) {
            return new ArrayList<ZonePolicyApplyInfo>();
        }
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        hql.append("from ZonePolicyApplyInfo policy where  zoneId in ( ");
        for (int i = 0; i < zoneIds.size(); ++i) {
            param.put(i, String.valueOf(zoneIds.get(i)));
            if (0 == i) {
                hql.append("?" + i);
                continue;
            }
            hql.append(",?" + i);
        }
        hql.append(')');
        List result = this.findByHql(hql.toString(), param);
        if (null != result && !result.isEmpty()) {
            return result;
        }
        return new ArrayList<ZonePolicyApplyInfo>();
    }

    public void updateDeployStateByZoneId(Long zoneId, String deployState) {
        this.getHibernateTemplate().execute((HibernateCallback)new InnerClassUpdateDeployState(zoneId, deployState));
    }

    public void updateAllZoneDeployState() {
        this.getHibernateTemplate().execute((HibernateCallback)new InnerClassUpdateAllZoneDeployState());
    }

    public void updateFilterDeployStateByZoneId(Long zoneId, String filterDeployState) {
        this.getHibernateTemplate().execute((HibernateCallback)new InnerClassUpdateFilterDeployState(zoneId, filterDeployState));
    }

    public List<Long> queryAllDeployZones() {
        StringBuffer hql = new StringBuffer();
        hql.append(" from ZonePolicyApplyInfo policy  ");
        List result = this.findByHql(hql.toString());
        ArrayList<Long> list = new ArrayList<Long>();
        if (null == result) {
            return list;
        }
        for (Object zonePolicyApplyInfo : result) {
            list.add(((ZonePolicyApplyInfo)zonePolicyApplyInfo).getZoneId());
        }
        return list;
    }

    public ZonePolicyApplyInfo getBaseZonePolicyApplyInfoByZoneId(Long zoneId) {
        String hql = " from ZonePolicyApplyInfo where zoneId = ?0";
        List zonePolicyApplyInfoList = this.getHibernateTemplate().find(hql, new Object[]{zoneId});
        if (zonePolicyApplyInfoList != null && !zonePolicyApplyInfoList.isEmpty()) {
            return (ZonePolicyApplyInfo)zonePolicyApplyInfoList.get(0);
        }
        return new ZonePolicyApplyInfo();
    }

    public void resetAllZoneState() {
        this.getHibernateTemplate().execute((HibernateCallback)new InnerClassResetAllZoneState());
    }

    public List<Long> queryAllNeedDeployZoneId() {
        StringBuffer hql = new StringBuffer();
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        hql.append(" from ZonePolicyApplyInfo policy, com.hs.atic.zone.model.ZoneInfo info ");
        hql.append(" where policy.zoneId = info.zoneId ");
        hql.append(" and  not (policy.deployState='SUCCESS' ");
        hql.append(" and  (policy.filterState='SUCCESS' ");
        hql.append(" or policy.filterState='UNDEPLOY')) ");
        List result = this.findByHql(hql.toString());
        if (result != null && !result.isEmpty()) {
            for (Object[] obj : result) {
                zoneIdList.add(((ZonePolicyApplyInfo)obj[0]).getZoneId());
            }
        }
        return zoneIdList;
    }

    private static class InnerClassResetAllZoneState
    implements HibernateCallback {
        private InnerClassResetAllZoneState() {
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery("update ZonePolicyApplyInfo zpai set zpai.abnormalState = :abnormalState");
            q.setString("abnormalState", "NORMAL");
            return q.executeUpdate();
        }
    }

    private static class InnerClassUpdateFilterDeployState
    implements HibernateCallback {
        private Long zoneId;
        private String filterDeployState;

        public InnerClassUpdateFilterDeployState(Long zoneId, String filterDeployState) {
            this.filterDeployState = filterDeployState;
            this.zoneId = zoneId;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery("update ZonePolicyApplyInfo zpai set zpai.filterState = :filterState where zpai.zoneId = :zoneId");
            q.setString("filterState", this.filterDeployState);
            q.setString("zoneId", String.valueOf(this.zoneId));
            return q.executeUpdate();
        }
    }

    private static class InnerClassUpdateAllZoneDeployState
    implements HibernateCallback {
        private InnerClassUpdateAllZoneDeployState() {
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery("update ZonePolicyApplyInfo zpai set zpai.deployState = 'UNDEPLOY' ");
            return q.executeUpdate();
        }
    }

    private static class InnerClassUpdateDeployState
    implements HibernateCallback {
        private Long zoneId;
        private String deployState;

        public InnerClassUpdateDeployState(Long zoneId, String deployState) {
            this.deployState = deployState;
            this.zoneId = zoneId;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery("update ZonePolicyApplyInfo zpai set zpai.deployState = :deployState where zpai.zoneId = :zoneId");
            q.setString("deployState", this.deployState);
            q.setString("zoneId", String.valueOf(this.zoneId));
            return q.executeUpdate();
        }
    }

    private static class InnerClassQuery
    implements HibernateCallback {
        private String hql;
        private int start;
        private int pageSize;

        public InnerClassQuery(String hql, int start, int pageSize) {
            this.hql = hql;
            this.pageSize = pageSize;
            this.start = start;
        }

        public Object doInHibernate(Session session) {
            Query query = session.createQuery(this.hql);
            query.setFirstResult(this.start);
            if (this.pageSize != 0) {
                query.setMaxResults(this.pageSize);
            }
            ArrayList<ZonePolicyApplyInfo> applyInfoList = new ArrayList<ZonePolicyApplyInfo>();
            ZonePolicyApplyInfo applyInfo = null;
            List tempResultList = query.list();
            for (Object[] tempResult : tempResultList) {
                applyInfo = (ZonePolicyApplyInfo)tempResult[0];
                applyInfo.setZoneDesc((String)tempResult[1]);
                applyInfoList.add(applyInfo);
            }
            return applyInfoList;
        }
    }
}

