/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.BlackListForm;
import com.hs.atic.sdk.bis.service.IAticCommonUtilService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.beans.DynamicBlackListInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.DynamicBlacklistForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class BlackListAction
extends BaseAction {
    static Comparator<LangPair> comparator = new Comparator<LangPair>(){

        @Override
        public int compare(LangPair o1, LangPair o2) {
            return o1.getValue().toLowerCase(Locale.ENGLISH).compareTo(o2.getValue().toLowerCase(Locale.ENGLISH));
        }
    };
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String zoneId;
    private List<BlackListForm> blackListInfos;
    private String blackListDatas;
    private String blackTypeCmb;
    private String blackTypeCmbValue;
    private String enableCmb;
    private String enableCmbValue;
    private List<LangPair> blackTypeList;
    private List<LangPair> enableList;
    private List<LangPair> deviceNameList;
    private String deviceNameCmbValue;
    private String deviceNameCmb;
    private boolean viewPage;
    private Boolean collectorOnline = false;
    private String blackIp;
    private String isDeleteAll;

    public Boolean getCollectorOnline() {
        return this.collectorOnline;
    }

    public void setCollectorOnline(Boolean collectorOnline) {
        this.collectorOnline = collectorOnline;
    }

    public boolean isViewPage() {
        return this.viewPage;
    }

    public void setViewPage(boolean viewPage) {
        this.viewPage = viewPage;
    }

    public List<LangPair> getDeviceNameList() {
        return this.deviceNameList;
    }

    public void setDeviceNameList(List<LangPair> deviceNameList) {
        this.deviceNameList = deviceNameList;
    }

    public String getDeviceNameCmbValue() {
        return this.deviceNameCmbValue;
    }

    public void setDeviceNameCmbValue(String deviceNameCmbValue) {
        this.deviceNameCmbValue = deviceNameCmbValue;
    }

    public String getDeviceNameCmb() {
        return this.deviceNameCmb;
    }

    public void setDeviceNameCmb(String deviceNameCmb) {
        this.deviceNameCmb = deviceNameCmb;
    }

    public List<LangPair> getBlackTypeList() {
        return this.blackTypeList;
    }

    public void setBlackTypeList(List<LangPair> blackTypeList) {
        this.blackTypeList = blackTypeList;
    }

    public List<LangPair> getEnableList() {
        return this.enableList;
    }

    public void setEnableList(List<LangPair> enableList) {
        this.enableList = enableList;
    }

    public String getBlackTypeCmb() {
        return this.blackTypeCmb;
    }

    public void setBlackTypeCmb(String blackTypeCmb) {
        this.blackTypeCmb = blackTypeCmb;
    }

    public String getBlackTypeCmbValue() {
        return this.blackTypeCmbValue;
    }

    public void setBlackTypeCmbValue(String blackTypeCmbValue) {
        this.blackTypeCmbValue = blackTypeCmbValue;
    }

    public String getEnableCmb() {
        return this.enableCmb;
    }

    public void setEnableCmb(String enableCmb) {
        this.enableCmb = enableCmb;
    }

    public String getEnableCmbValue() {
        return this.enableCmbValue;
    }

    public void setEnableCmbValue(String enableCmbValue) {
        this.enableCmbValue = enableCmbValue;
    }

    public String getBlackListDatas() {
        return this.blackListDatas;
    }

    public void setBlackListDatas(String blackListDatas) {
        this.blackListDatas = blackListDatas;
    }

    public List<BlackListForm> getBlackListInfos() {
        return this.blackListInfos;
    }

    public void setBlackListInfos(List<BlackListForm> blackListInfos) {
        this.blackListInfos = blackListInfos;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    private void initBlackTypeList() {
        this.blackTypeList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.all"));
        LangPair com1 = new LangPair("3", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.httpFlood"));
        LangPair com2 = new LangPair("4", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.urlMonitor"));
        LangPair com3 = new LangPair("5", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.TcpConnectionFlood"));
        LangPair com4 = new LangPair("6", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.showAttack"));
        LangPair com5 = new LangPair("7", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.httpsFlood"));
        LangPair com6 = new LangPair("12", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.hostfilter"));
        LangPair com7 = new LangPair("14", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.fingershoot"));
        LangPair com8 = new LangPair("15", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.slowhttp"));
        LangPair com9 = new LangPair("16", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.malware"));
        LangPair com10 = new LangPair("17", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.httpfilter"));
        LangPair com13 = new LangPair("20", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.tcpportlimit"));
        LangPair com14 = new LangPair("23", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.tcpratio"));
        LangPair com15 = new LangPair("24", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.tcpsesschk"));
        LangPair com16 = new LangPair("25", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.synackflood"));
        LangPair com17 = new LangPair("26", this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.tlsCon"));
        this.blackTypeList.add(com0);
        this.blackTypeList.add(com1);
        this.blackTypeList.add(com2);
        this.blackTypeList.add(com3);
        this.blackTypeList.add(com4);
        this.blackTypeList.add(com5);
        this.blackTypeList.add(com6);
        this.blackTypeList.add(com7);
        this.blackTypeList.add(com8);
        this.blackTypeList.add(com9);
        this.blackTypeList.add(com10);
        this.blackTypeList.add(com13);
        this.blackTypeList.add(com14);
        this.blackTypeList.add(com15);
        this.blackTypeList.add(com16);
        this.blackTypeList.add(com17);
        if (null == this.blackTypeCmb) {
            this.setBlackTypeCmb("0");
            this.setBlackTypeCmbValue(this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.all"));
        }
    }

    private void initEnableList() {
        this.enableList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.blacklist.status.all"));
        LangPair com1 = new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.blacklist.status.noEffective"));
        LangPair com2 = new LangPair("2", this.getText("com.hs.vsm.secservice.ddos.blacklist.status.effectived"));
        this.enableList.add(com0);
        this.enableList.add(com1);
        this.enableList.add(com2);
        if (null == this.enableCmb) {
            this.setEnableCmb("0");
            this.setEnableCmbValue(this.getText("com.hs.vsm.secservice.ddos.blacklist.status.all"));
        }
    }

    private void initDeviceNameList() {
        this.deviceNameList = new ArrayList<LangPair>();
        IZoneDeviceService service = ZoneReferUtil.getZoneDeviceService();
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        List zoneDeviceForms = service.queryZoneDeviceFormsByZoneID(Long.valueOf(this.zoneId), currentUser.getUserID(), "true".equalsIgnoreCase(currentUser.getIsAdmin()));
        AticDevice securityNE = null;
        String deviceName = null;
        String ipAddress = null;
        StringBuffer devIps = new StringBuffer();
        int j = zoneDeviceForms.size();
        for (int i = 0; i < j; ++i) {
            ZoneDeviceForm zoneDeviceForm = (ZoneDeviceForm)zoneDeviceForms.get(i);
            securityNE = ZoneReferUtil.getDevice(zoneDeviceForm.getDeviceId());
            if (null == securityNE || securityNE.getDeviceType() != 1) continue;
            deviceName = securityNE.getName();
            ipAddress = securityNE.getIpAddress();
            LangPair com = new LangPair(ipAddress, deviceName);
            this.deviceNameList.add(com);
            if (i == j - 1) {
                devIps.append(ipAddress);
                continue;
            }
            devIps.append(ipAddress).append(',');
        }
        Collections.sort(this.deviceNameList, comparator);
        this.deviceNameList.add(0, new LangPair(devIps.toString(), this.getText("com.hs.vsm.secservice.ddos.blacklist.status.all")));
        if (null == this.deviceNameCmb && !this.deviceNameList.isEmpty()) {
            this.setDeviceNameCmb(this.deviceNameList.get(0).getLabel());
            this.setDeviceNameCmbValue(this.deviceNameList.get(0).getValue());
        }
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        Long moId = ZoneBisUtil.getMoidByZoneid(Long.parseLong(this.zoneId));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        queryMap.put("start", this.start + "");
        queryMap.put("pageSize", this.pageSize + "");
        queryMap.put("deviceIp", this.deviceNameCmb);
        queryMap.put("zoneId", this.zoneId);
        if (null == this.blackTypeCmb) {
            queryMap.put("blackType", "0");
        } else {
            queryMap.put("blackType", this.blackTypeCmb);
        }
        if (null == this.enableCmb) {
            queryMap.put("enable", "0");
        } else {
            queryMap.put("enable", this.enableCmb);
        }
        if (StringUtils.isEmpty((CharSequence)this.blackIp)) {
            queryMap.put("blackIp", null);
        } else {
            queryMap.put("blackIp", this.blackIp);
        }
        return queryMap;
    }

    public String showBlackListInfos() {
        logger.info((Object)"showBlackListInfos is execute");
        this.initBlackTypeList();
        this.initEnableList();
        this.initDeviceNameList();
        if (null == this.deviceNameCmbValue || "".equals(this.deviceNameCmbValue)) {
            return "success";
        }
        IAticCommonUtilService aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
        this.collectorOnline = aticCommonUtilService.checkCollectorStatus(this.deviceNameCmb);
        if (!this.collectorOnline.booleanValue()) {
            return "success";
        }
        Map<String, String> queryMap = this.getConditions();
        Paging page = ZoneReferUtil.getBlackList(queryMap);
        this.blackListInfos = page.getData();
        this.total = page.getCount();
        this.setBlackListEnable();
        this.setBlackType();
        this.setProtocol();
        this.setServiceName();
        return "success";
    }

    public void startupService() {
        logger.info((Object)"startupService is execute");
        this.deployDynamicBlacklist();
    }

    private void deployBlacklistService(String ipnutStr, String deviceIp) {
        if (!"".equals(ipnutStr) && !"".equals(deviceIp)) {
            ZoneReferUtil.startBlackListService(ipnutStr, deviceIp);
        }
    }

    public void stopService() {
        logger.info((Object)"stopService is execute");
        this.undeployDynamicBlacklist();
    }

    public void stopAllService() {
        try {
            ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId));
            Long moId = ZoneBisUtil.getMoidByZoneid(Long.valueOf(this.zoneId));
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            String zoneName = zoneInfoForm.getZoneDesc();
            logger.info((Object)("stop all service... zoneId : " + this.zoneId));
            this.initDeviceNameList();
            if (null == this.deviceNameCmbValue || "".equals(this.deviceNameCmbValue)) {
                return;
            }
            IAticCommonUtilService aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
            this.collectorOnline = aticCommonUtilService.checkCollectorStatus(this.deviceNameCmb);
            logger.info((Object)("check collector online : " + this.collectorOnline));
            if (!this.collectorOnline.booleanValue()) {
                return;
            }
            IZoneMgrNorthSerice service = (IZoneMgrNorthSerice)ServiceContext.getInstance().getService("zoneMgrNorthSerice", IZoneMgrNorthSerice.class);
            StringBuffer successDevice = new StringBuffer();
            String[] deviceIps = this.deviceNameCmb.split(",");
            ArrayList<BatchOperation> operations = new ArrayList<BatchOperation>();
            int faild = 0;
            logger.info((Object)("stop service device ip : " + deviceIps.length));
            for (int i = 0; i < deviceIps.length; ++i) {
                String ip = deviceIps[i];
                BatchOperation operation = new BatchOperation();
                try {
                    operation.setTargetId((long)i);
                    operation.setTargetName(zoneName);
                    Long id = this.getDeviceId(ip);
                    logger.info((Object)("undeploy black list deviceId : " + id));
                    if (null == id) {
                        throw new LegoCheckedException("delete all blacklist error. getDeviceId(ip) is null");
                    }
                    service.undeployAllDynamicBlacklist(Long.parseLong(this.zoneId), id);
                    successDevice.append(ip);
                    successDevice.append(",");
                    operation.setOptDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.stopzoneblacklist.all");
                    operation.setDetailParam(new String[]{ip});
                }
                catch (LegoCheckedException e) {
                    ++faild;
                    operation.setErrorCode(e.getErrorCode());
                    this.log.error((Object)("delete all blacklist error. device ip : " + ip + ". " + e.getMessage()));
                }
                catch (Exception e) {
                    ++faild;
                    operation.setErrorCode(200L);
                    this.log.error((Object)("delete all blacklist error. device ip : " + ip + ". " + e.getMessage()));
                }
                operations.add(operation);
            }
            logger.info((Object)("undeploy all service , start to delete db :  " + successDevice.toString()));
            if (!"".equals(successDevice.toString().split(",")[0])) {
                Map<String, Exception> stopErr = ZoneReferUtil.stopAllBlackListService(this.zoneId, successDevice.toString());
                for (Map.Entry<String, Exception> err : stopErr.entrySet()) {
                    BatchOperation operation = new BatchOperation();
                    operation.setTargetId((long)(operations.size() + 1));
                    operation.setTargetName(err.getKey());
                    operation.setErrorCode(570504L);
                    ++faild;
                    logger.error((Object)"connect to collector error.", (Throwable)err.getValue());
                    operations.add(operation);
                }
            }
            BatchOperationResult result = new BatchOperationResult();
            result.setResult(operations);
            result.setFailCount(faild);
            result.setTotalCount(operations.size());
            result.setSucceedCount(operations.size() - faild);
            logger.info((Object)("batch operation result : " + result.getFailCount()));
            this.bathResult(result);
            this.systemOpeLogBatch("com.hs.vsm.secservice.ddos.policy.operation.name.stopzoneblacklist", "lego.dic.module.ddosApp", false, SysoplogLevel.info.getValue(), operations);
        }
        catch (RuntimeException e) {
            logger.error((Object)"stopAllService error.");
            ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId));
            String zoneName = zoneInfoForm.getZoneDesc();
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.stopzoneblacklist", "lego.dic.module.ddosApp", false, null, null, zoneName, SysoplogLevel.info.getValue(), false, e);
            throw e;
        }
        catch (Exception e) {
            ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId));
            String zoneName = zoneInfoForm.getZoneDesc();
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.stopzoneblacklist", "lego.dic.module.ddosApp", false, null, null, zoneName, SysoplogLevel.info.getValue(), false, e);
            throw e;
        }
    }

    private void undeployBlacklistService(List<BlackListForm> ipnutStr, String deviceIp) {
        if (!ipnutStr.isEmpty() && !"".equals(deviceIp)) {
            ZoneReferUtil.stopBlackListService(ipnutStr, deviceIp);
        }
    }

    private void deployDynamicBlacklist() {
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId));
        Long moId = ZoneBisUtil.getMoidByZoneid(Long.valueOf(this.zoneId));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        String zoneName = zoneInfoForm.getZoneDesc();
        List<DynamicBlackListInfo> dynamicBlackListInfos = this.parseTransferString();
        if (!dynamicBlackListInfos.isEmpty()) {
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startupzoneblacklist", "lego.dic.module.ddosApp", BlackListAction.getcleanedMessage(zoneName));
            for (int i = 0; i < dynamicBlackListInfos.size(); ++i) {
                BatchOperation operation = new BatchOperation();
                operation.setTargetId((long)i);
                DynamicBlackListInfo dynamicBlackListInfo = dynamicBlackListInfos.get(i);
                operation.setTargetName(dynamicBlackListInfo.getBlackIp());
                batchOpList.add(operation);
            }
            BatchOperationResult batchOperationResult = this.deployDynamicBlackListInBatch(batchOpList, dynamicBlackListInfos);
            this.bathResult(batchOperationResult);
        }
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private BatchOperationResult deployDynamicBlackListInBatch(List<BatchOperation> boList, List<DynamicBlackListInfo> dynamicBlackListInfos) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        ArrayList<DynamicBlackListInfo> todoList = new ArrayList<DynamicBlackListInfo>();
        for (int i = 0; i < boList.size(); ++i) {
            BatchOperation bo = boList.get(i);
            DynamicBlackListInfo dynamicBlackListInfo = dynamicBlackListInfos.get(i);
            DynamicBlacklistForm form = this.transferObject(dynamicBlackListInfo);
            try {
                this.doDeployDynamicBlackListService(form);
                todoList.add(dynamicBlackListInfo);
                bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.startupzoneblacklist");
                bo.setDetailParam(new String[]{dynamicBlackListInfo.getBlackIp(), this.getProtocolString(dynamicBlackListInfo.getProtocol()), dynamicBlackListInfo.getPort() == 0 ? "--" : dynamicBlackListInfo.getPort() + "", this.getBlackTypeString(dynamicBlackListInfo.getBlackType())});
                continue;
            }
            catch (LegoCheckedException e) {
                ++fail;
                bo.setErrorCode(e.getErrorCode());
                this.log.error((Object)(dynamicBlackListInfo + ". " + e.getMessage()));
                continue;
            }
            catch (Exception e) {
                ++fail;
                bo.setErrorCode(200L);
                this.log.error((Object)(dynamicBlackListInfo + ". " + e.getMessage()));
            }
        }
        String deviceIp = this.getDeviceIp(todoList);
        this.deployBlacklistService(this.assembTransferInputStr(todoList), deviceIp);
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    private void doDeployDynamicBlackListService(DynamicBlacklistForm form) {
        IZoneMgrNorthSerice service = (IZoneMgrNorthSerice)ServiceContext.getInstance().getService("zoneMgrNorthSerice", IZoneMgrNorthSerice.class);
        service.deployDynamicBlacklist(form);
    }

    private void undeployDynamicBlacklist() {
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId));
        Long moId = ZoneBisUtil.getMoidByZoneid(Long.valueOf(this.zoneId));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        if (null == zoneInfoForm) {
            throw new LegoCheckedException(201L);
        }
        List<DynamicBlackListInfo> dynamicBlackListInfos = this.parseTransferString();
        if (!dynamicBlackListInfos.isEmpty()) {
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            StringBuilder deleteBlackIps = new StringBuilder();
            for (int i = 0; i < dynamicBlackListInfos.size(); ++i) {
                BatchOperation operation = new BatchOperation();
                operation.setTargetId((long)i);
                DynamicBlackListInfo dynamicBlackListInfo = dynamicBlackListInfos.get(i);
                operation.setTargetName(dynamicBlackListInfo.getBlackIp());
                batchOpList.add(operation);
                deleteBlackIps.append(dynamicBlackListInfo.getBlackIp()).append(",");
            }
            deleteBlackIps.deleteCharAt(deleteBlackIps.length() - 1);
            try {
                BatchOperationResult batchOperationResult = this.unDeployDynamicBlackListInBatch(batchOpList, dynamicBlackListInfos);
                this.bathResult(batchOperationResult);
                this.systemOpeLogBatch("com.hs.vsm.secservice.ddos.policy.operation.name.stopzoneblacklist", "lego.dic.module.ddosApp", false, SysoplogLevel.warning.getValue(), batchOpList);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("delete dynamic black list failed." + e.getMessage()));
                this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.stopzoneblacklist", "lego.dic.module.ddosApp", false, null, null, deleteBlackIps.toString(), SysoplogLevel.warning.getValue(), false, (Exception)((Object)e));
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)("delete dynamic black list failed." + e.getMessage()));
                this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.stopzoneblacklist", "lego.dic.module.ddosApp", false, null, null, deleteBlackIps.toString(), SysoplogLevel.warning.getValue(), false, e);
                throw new LegoUncheckedException((Throwable)e);
            }
        }
    }

    private BatchOperationResult unDeployDynamicBlackListInBatch(List<BatchOperation> boList, List<DynamicBlackListInfo> dynamicBlackListInfos) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        ArrayList<BlackListForm> todoList = new ArrayList<BlackListForm>();
        for (int i = 0; i < boList.size(); ++i) {
            BatchOperation bo = boList.get(i);
            DynamicBlackListInfo dynamicBlackListInfo = dynamicBlackListInfos.get(i);
            DynamicBlacklistForm form = this.transferObject(dynamicBlackListInfo);
            try {
                this.unDoDeployDynamicBlackListService(form);
                BlackListForm blackListForm = new BlackListForm();
                blackListForm.setPkId(Long.valueOf(dynamicBlackListInfo.getPkId()));
                blackListForm.setZoneId(Long.valueOf(dynamicBlackListInfo.getZoneId()));
                blackListForm.setBizId(dynamicBlackListInfo.getBizId());
                blackListForm.setDeviceIp(dynamicBlackListInfo.getDeviceIp());
                blackListForm.setBlackIp(dynamicBlackListInfo.getBlackIp());
                blackListForm.setZoneIp(dynamicBlackListInfo.getZoneIp());
                blackListForm.setBlackType(dynamicBlackListInfo.getBlackType());
                blackListForm.setBlackTypeStr(dynamicBlackListInfo.getBlackTypeStr());
                blackListForm.setPort(dynamicBlackListInfo.getPort().longValue());
                blackListForm.setProtocol(Long.valueOf(dynamicBlackListInfo.getProtocol()));
                blackListForm.setProtocolStr(dynamicBlackListInfo.getProtocol());
                logger.info((Object)("zone Ip : " + blackListForm.getZoneIp() + " , port : " + blackListForm.getPort()));
                todoList.add(blackListForm);
                bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.stopzoneblacklist");
                bo.setDetailParam(new String[]{dynamicBlackListInfo.getBlackIp(), this.getProtocolString(dynamicBlackListInfo.getProtocol()), dynamicBlackListInfo.getPort() == 0 ? "--" : dynamicBlackListInfo.getPort() + "", this.getBlackTypeString(dynamicBlackListInfo.getBlackType())});
                continue;
            }
            catch (LegoCheckedException e) {
                ++fail;
                bo.setErrorCode(e.getErrorCode());
                this.log.error((Object)(dynamicBlackListInfo + ". " + e.getMessage()));
                continue;
            }
            catch (Exception e) {
                ++fail;
                bo.setErrorCode(200L);
                this.log.error((Object)(dynamicBlackListInfo + ". " + e.getMessage()));
            }
        }
        String deviceIp = null;
        if (!todoList.isEmpty()) {
            BlackListForm blackListForm = (BlackListForm)todoList.get(0);
            deviceIp = blackListForm.getDeviceIp();
        }
        this.undeployBlacklistService(todoList, deviceIp);
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    private String assembTransferInputStr(List<DynamicBlackListInfo> list) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            DynamicBlackListInfo dynamicBlackList = list.get(i);
            tmp.append(dynamicBlackList.getPkId());
            if (i == list.size() - 1) continue;
            tmp.append(',');
        }
        return tmp.toString();
    }

    private String getDeviceIp(List<DynamicBlackListInfo> list) {
        if (!list.isEmpty()) {
            DynamicBlackListInfo dynamicBlackList = list.get(0);
            return dynamicBlackList.getDeviceIp();
        }
        return null;
    }

    private void unDoDeployDynamicBlackListService(DynamicBlacklistForm form) {
        IZoneMgrNorthSerice service = (IZoneMgrNorthSerice)ServiceContext.getInstance().getService("zoneMgrNorthSerice", IZoneMgrNorthSerice.class);
        service.undeployDynamicBlacklist(form);
    }

    private List<DynamicBlackListInfo> parseTransferString() {
        String[] datas;
        ArrayList<DynamicBlackListInfo> dynamicBlacklistInfos = new ArrayList<DynamicBlackListInfo>();
        DynamicBlackListInfo dnamicBlackListInfo = null;
        String firstFlag = ",";
        String secondFlag = ";";
        if (null != this.blackListDatas && (datas = this.blackListDatas.split(firstFlag)).length > 0) {
            int j = datas.length;
            for (int i = 0; i < j; ++i) {
                dnamicBlackListInfo = new DynamicBlackListInfo();
                String data = datas[i];
                String[] blackListDatasStr = data.split(secondFlag);
                String pkId = blackListDatasStr[0].trim();
                String zoneID = blackListDatasStr[1].trim();
                String blackIP = blackListDatasStr[2].trim();
                String protocol = blackListDatasStr[3].trim();
                String port = blackListDatasStr[4].trim();
                String deviceIp = blackListDatasStr[5].trim();
                String bizId = blackListDatasStr[6].trim();
                String blackType = blackListDatasStr[7].trim();
                String zoneIp = blackListDatasStr[8].trim();
                dnamicBlackListInfo.setPkId(pkId);
                dnamicBlackListInfo.setZoneId(zoneID);
                dnamicBlackListInfo.setBlackIp(blackIP);
                dnamicBlackListInfo.setProtocol(protocol);
                dnamicBlackListInfo.setPort(Integer.valueOf(port));
                dnamicBlackListInfo.setDeviceIp(deviceIp);
                dnamicBlackListInfo.setBizId(Long.valueOf(bizId));
                dnamicBlackListInfo.setBlackType(Long.valueOf(blackType));
                dynamicBlacklistInfos.add(dnamicBlackListInfo);
                dnamicBlackListInfo.setZoneIp(zoneIp);
            }
        }
        return dynamicBlacklistInfos;
    }

    private DynamicBlacklistForm transferObject(DynamicBlackListInfo dynamicBlackListInfo) {
        if (dynamicBlackListInfo == null) {
            return null;
        }
        DynamicBlacklistForm dynamicBlacklistForm = new DynamicBlacklistForm();
        String zoneName = this.getZoneName(dynamicBlackListInfo.getZoneId());
        Long deviceId = this.getDeviceId(dynamicBlackListInfo.getDeviceIp());
        Integer timeout = this.getBlackListTimeout(Long.valueOf(dynamicBlackListInfo.getZoneId()));
        dynamicBlacklistForm.setZoneName(zoneName);
        dynamicBlacklistForm.setZoneId(Long.valueOf(dynamicBlackListInfo.getZoneId()));
        dynamicBlacklistForm.setDeviceId(deviceId);
        dynamicBlacklistForm.setIp(dynamicBlackListInfo.getBlackIp());
        dynamicBlacklistForm.setProtocol(Integer.valueOf(dynamicBlackListInfo.getProtocol()));
        dynamicBlacklistForm.setPort(dynamicBlackListInfo.getPort());
        dynamicBlacklistForm.setTimeout(timeout);
        dynamicBlacklistForm.setBizId(dynamicBlackListInfo.getBizId());
        return dynamicBlacklistForm;
    }

    private String getZoneName(String zoneID) {
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(zoneID));
        if (null == zoneInfoForm) {
            return null;
        }
        return zoneInfoForm.getZoneDesc();
    }

    private Long getDeviceId(String deviceIp) {
        List<AticDevice> fireWalls = ZoneReferUtil.getAllDevice((User)this.getSession().getAttribute("currentUser"));
        if (null == fireWalls) {
            return null;
        }
        AticDevice fireWall = null;
        int j = fireWalls.size();
        for (int i = 0; i < j; ++i) {
            fireWall = fireWalls.get(i);
            if (!fireWall.getIpAddress().trim().equals(deviceIp)) continue;
            return fireWall.getMoId();
        }
        return null;
    }

    private Integer getBlackListTimeout(Long zoneID) {
        IZonePolicyApplyService zoneDeviceService = ZoneReferUtil.getZonePolicyService();
        ZonePolicyApplyForm zonePolicyApplyForm = zoneDeviceService.queryByZoneId(zoneID);
        if (null == zonePolicyApplyForm) {
            return null;
        }
        return zonePolicyApplyForm.getDynamicBlackTimeout();
    }

    private void setBlackType() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("3", "com.hs.vsm.secservice.ddos.blacklist.attackType.httpFlood");
        map.put("4", "com.hs.vsm.secservice.ddos.blacklist.attackType.urlMonitor");
        map.put("5", "com.hs.vsm.secservice.ddos.blacklist.attackType.TcpConnectionFlood");
        map.put("6", "com.hs.vsm.secservice.ddos.blacklist.attackType.showAttack");
        map.put("7", "com.hs.vsm.secservice.ddos.blacklist.attackType.httpsFlood");
        map.put("12", "com.hs.vsm.secservice.ddos.blacklist.attackType.hostfilter");
        map.put("14", "com.hs.vsm.secservice.ddos.blacklist.attackType.fingershoot");
        map.put("15", "com.hs.vsm.secservice.ddos.blacklist.attackType.slowhttp");
        map.put("16", "com.hs.vsm.secservice.ddos.blacklist.attackType.malware");
        map.put("17", "com.hs.vsm.secservice.ddos.blacklist.attackType.httpfilter");
        map.put("22", "com.hs.vsm.secservice.ddos.blacklist.attackType.httpsfilterLearn");
        map.put("21", "com.hs.vsm.secservice.ddos.blacklist.attackType.returnCode");
        map.put("20", "com.hs.vsm.secservice.ddos.blacklist.attackType.tcpportlimit");
        map.put("23", "com.hs.vsm.secservice.ddos.blacklist.attackType.tcpratio");
        map.put("24", "com.hs.vsm.secservice.ddos.blacklist.attackType.tcpsesschk");
        map.put("25", "com.hs.vsm.secservice.ddos.blacklist.attackType.synackflood");
        map.put("26", "com.hs.vsm.secservice.ddos.blacklist.attackType.tlsCon");
        block0: for (BlackListForm form : this.blackListInfos) {
            for (Map.Entry entry : map.entrySet()) {
                if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)String.valueOf(form.getBlackType()))) continue;
                form.setBlackTypeStr(this.getText((String)entry.getValue()));
                continue block0;
            }
        }
    }

    private void setBlackListEnable() {
        if (null != this.blackListInfos) {
            for (BlackListForm form : this.blackListInfos) {
                form.setZoneIp(IPUtil4Atic.compressIP((String)form.getZoneIp()));
                form.setBlackIp(IPUtil4Atic.compressIP((String)form.getBlackIp()));
                if ("1".equals(form.getEnable() + "")) {
                    form.setEnableStr(this.getText("com.hs.vsm.secservice.ddos.blacklist.status.noEffective"));
                    continue;
                }
                if (!"2".equals(form.getEnable() + "")) continue;
                form.setEnableStr(this.getText("com.hs.vsm.secservice.ddos.blacklist.status.effectived"));
            }
        }
    }

    private void setProtocol() {
        if (null != this.blackListInfos) {
            for (BlackListForm form : this.blackListInfos) {
                if ("6".equals(form.getProtocol() + "")) {
                    form.setProtocolStr("TCP");
                    continue;
                }
                if ("17".equals(form.getProtocol() + "")) {
                    form.setProtocolStr("UDP");
                    continue;
                }
                if ("1".equals(form.getProtocol() + "")) {
                    form.setProtocolStr("ICMP");
                    continue;
                }
                form.setProtocolStr("OTHER");
            }
        }
    }

    private void setServiceName() {
        if (null != this.blackListInfos) {
            for (BlackListForm form : this.blackListInfos) {
                ZoneServiceForm zoneServiceForm;
                if (null == form.getBizId() || null == (zoneServiceForm = ZoneReferUtil.getZoneServiceService().queryByZoneServiceID(form.getBizId()))) continue;
                form.setServiceName(zoneServiceForm.getServiceName());
            }
        }
    }

    private String getProtocolString(String protocol) {
        if ("6".equals(protocol)) {
            return "TCP";
        }
        if ("17".equals(protocol)) {
            return "UDP";
        }
        if ("1".equals(protocol)) {
            return "ICMP";
        }
        return "OTHER";
    }

    private String getBlackTypeString(Long blackType) {
        String blackTypeStr = blackType.toString();
        if ("0".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.all");
        }
        if ("3".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.httpFlood");
        }
        if ("4".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.urlMonitor");
        }
        if ("5".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.TcpConnectionFlood");
        }
        if ("6".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.showAttack");
        }
        if ("7".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.httpsFlood");
        }
        if ("12".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.hostfilter");
        }
        if ("14".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.fingershoot");
        }
        if ("15".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.slowhttp");
        }
        if ("16".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.malware");
        }
        if ("17".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.httpfilter");
        }
        if ("22".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.httpsfilterLearn");
        }
        if ("21".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.returnCode");
        }
        if ("20".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.tcpportlimit");
        }
        if ("23".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.tcpratio");
        }
        if ("24".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.tcpsesschk");
        }
        if ("25".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.synackflood");
        }
        if ("26".equals(blackTypeStr)) {
            return this.getText("com.hs.vsm.secservice.ddos.blacklist.attackType.tlsCon");
        }
        return "";
    }

    public String getBlackIp() {
        return this.blackIp;
    }

    public void setBlackIp(String blackIp) {
        this.blackIp = blackIp;
    }

    public String getIsDeleteAll() {
        this.isDeleteAll = AticUtil.readUIConfig((String)"dynamicBlacklistDeleteAll");
        logger.info((Object)("get : " + this.isDeleteAll));
        return this.isDeleteAll;
    }

    public void setIsDeleteAll(String isDeleteAll) {
        this.isDeleteAll = isDeleteAll;
    }

    public boolean validateZoneId() {
        long id = 0L;
        try {
            id = Long.parseLong(this.zoneId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return id >= 1L;
    }

    public boolean validateDeviceNameCmb() {
        if (null == this.deviceNameCmb || "".equals(this.deviceNameCmb)) {
            return true;
        }
        String[] names = this.deviceNameCmb.split(",");
        if (names.length > 100) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            boolean flag;
            boolean bl = flag = IPUtil.isIpv4((String)names[i]) || IPUtil.isIpv6((String)names[i]);
            if (flag) continue;
            return false;
        }
        return true;
    }

    public boolean validateBlackTypeCmb() {
        if (null == this.blackTypeCmb) {
            return true;
        }
        if ("".equals(this.blackTypeCmb)) {
            return false;
        }
        String regex = "^(0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26)$";
        return this.blackTypeCmb.matches(regex);
    }

    public boolean validateBlackTypeCmbValue() {
        if (null == this.blackTypeCmbValue) {
            return true;
        }
        if ("".equals(this.blackTypeCmbValue)) {
            return false;
        }
        this.blackTypeCmbValue = this.blackTypeCmbValue.trim();
        String regex = "^(ALL|All|HTTP Flood|URI Monitor|TCP Connection Flood|Slow Attack|HTTPS Flood|Host filter|Fingerprint Matching|Slow Http Attack|Malware Attack|Filter drop|Https Error-Code Check|Https Fingerprint|TCP Port Limit|TCP Ratio|TCP Session Check|SYN-ACK Flood|HTTP Connection Flood|TLS Connection Flood)$";
        return this.blackTypeCmbValue.matches(regex);
    }

    public boolean validateEnableCmb() {
        if (null == this.enableCmb) {
            return true;
        }
        if ("".equals(this.enableCmb)) {
            return false;
        }
        String regex = "^(0|1|2)$";
        return this.enableCmb.matches(regex);
    }

    public boolean validateBlackIp() {
        if (null == this.blackIp || "".equals(this.blackIp)) {
            return true;
        }
        return IPUtil.isIpv4((String)this.blackIp) || IPUtil.isIpv6((String)this.blackIp);
    }
}

