/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.policy.action.RadioGroupVO;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.FilterUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaClusterDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class EditFilterAction
extends BaseAction {
    private static final long serialVersionUID = -5043089756001988639L;
    private static final String SESSION_FILTER_KEY = "filterKeyList";
    private transient IFilterService filterService;
    private transient IFilterDeviceZoneStatusService filterDeviceZoneStatusService;
    private Long id;
    private List<RadioGroupVO> httpFilterActionList;
    private List<RadioGroupVO> filterRadioList;
    private List<RadioGroupVO> filterRadioListOnlyInclude;
    private Integer httpFilterAction;
    private List<LangPair> filterDeviceTypeList;
    private String filterDeviceTypeValue;
    private String filterDeviceTypeLabel;
    private String deviceType;
    private List<LangPair> filterTypeList;
    private String filterTypeValue;
    private String filterTypeLabel;
    private String filterType;
    private String filterKeyValue;
    private List<LangPair> filterActionList;
    private String filterActionValue;
    private String filterActionLabel;
    private Integer filterIdValue;
    private String filterAttackTypeValue;
    private String filterAttackTypeLabel;
    private List<LangPair> filterKeyActionList;
    private List<LangPair> filterFragmentTypeList;
    private String filterFragmentTypeValue;
    private String filterFragmentTypeLabel;
    private List<LangPair> filterHttpOpcodeList;
    private String filterHttpOpcodeValue;
    private String filterHttpOpcodeLabel;
    private List<LangPair> filterDnsOpcodeList;
    private String filterDnsOpcodeValue;
    private String filterDnsOpcodeLabel;
    private FilterForm filterForm;
    private List<HttpFilterForm> httpFilterFormList;
    private List<ZoneInfoForm> zoneInfoList;
    private List<ZonePolicyApplyForm> zonePolicyFormList;
    private String zoneName;
    private String zoneId;
    private int filterId;
    private String filterKeyVlue;
    private String filterContent;
    private HttpFilterForm filterListkeyForm = new HttpFilterForm();
    private String[] filterKeyList;
    private List<HttpFilterForm> filterListKeyFormList;
    private String whichPage = "";
    private List<AticDevice> deviceList;
    private transient IAticDeviceService aticDeviceService;

    public String editFilter() {
        IFilterDeviceZoneInfoService filterDeviceZoneInfoService = ZoneReferUtil.getFilterDeviceZoneInfoService();
        User user = (User)this.getSession().getAttribute("currentUser");
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("userId", String.valueOf(user.getUserID()));
        queryMap.put("isAdmin", user.getIsAdmin());
        queryMap.put("filterId", String.valueOf(this.id));
        List<FilterDeviceZoneForm> filterDeviceZoneFormList = filterDeviceZoneInfoService.getByFilterIdAuthority1(queryMap);
        this.deviceList = new ArrayList<AticDevice>();
        if (null != filterDeviceZoneFormList) {
            for (FilterDeviceZoneForm filterDeviceZoneForm : filterDeviceZoneFormList) {
                AticDevice aticDevice;
                boolean isExist = false;
                for (AticDevice aticDevice2 : this.deviceList) {
                    if (aticDevice2.getMoId() != filterDeviceZoneForm.getDeviceId().longValue()) continue;
                    isExist = true;
                }
                if (isExist || null == (aticDevice = this.aticDeviceService.getDeviceByMoid(filterDeviceZoneForm.getDeviceId().longValue()))) continue;
                boolean filterDefineState = false;
                if (aticDevice.getDeviceType() == 9) {
                    AticDeviceNfaClusterDao nfaClusterDao = (AticDeviceNfaClusterDao)ServiceContext.getInstance().getService("aticDeviceNfaClusterDao", AticDeviceNfaClusterDao.class);
                    List findRelNfaDevice = nfaClusterDao.findRelNfaDevice(Long.valueOf(aticDevice.getMoId()));
                    if (null != findRelNfaDevice) {
                        for (AticDeviceNfaCluster aticDeviceNfaCluster : findRelNfaDevice) {
                            FilterDeviceDao filterDeviceDao = (FilterDeviceDao)((Object)ServiceContext.getInstance().getService("filterDeviceDao", FilterDeviceDao.class));
                            List<FilterDeviceInfo> byFilterIdAndDeviceId = filterDeviceDao.getByFilterIdAndDeviceId(filterDeviceZoneForm.getFilterId(), aticDeviceNfaCluster.getDeviceId());
                            filterDefineState = null != byFilterIdAndDeviceId && !byFilterIdAndDeviceId.isEmpty();
                            if (filterDefineState) continue;
                            break;
                        }
                    }
                } else {
                    Long deviceId1;
                    Long filterId1 = filterDeviceZoneForm.getFilterId();
                    List<FilterDeviceZoneStatusInfo> statusInfos = this.filterDeviceZoneStatusService.getFilterDefineDeployedByFilterIdAndDeviceId(filterId1, deviceId1 = Long.valueOf(aticDevice.getMoId()));
                    if (null != statusInfos && !statusInfos.isEmpty()) {
                        filterDefineState = true;
                    } else {
                        List<FilterDeviceZoneInfo> infos = filterDeviceZoneInfoService.getDeployedDefineForGloByFilterIdAndDeviceId(filterId1, deviceId1);
                        if (null != infos && !infos.isEmpty()) {
                            filterDefineState = true;
                        }
                    }
                }
                aticDevice.setFilterDefineState(filterDefineState);
                this.deviceList.add(aticDevice);
            }
        }
        this.filterForm = (FilterForm)this.filterService.query(this.id);
        if (null == this.filterForm.getPkid()) {
            throw new LegoCheckedException(571507L);
        }
        this.initSessionFilterKey();
        this.initDeviceTypeList(false);
        this.initFilterTypeList(false);
        this.initFilterActionList(false);
        return "success";
    }

    public String createFilter() {
        this.initSessionFilterKey();
        this.initDeviceTypeList(true);
        this.initFilterTypeList(true);
        this.initFilterActionList(true);
        this.filterIdValue = this.filterService.calculationFilterId();
        this.filterForm = new FilterForm();
        this.filterForm.setFilterId(this.filterIdValue);
        return "success";
    }

    public String addFilterKey() {
        this.initFilterFragmentTypeList();
        this.initFilterHttpOpcodeList();
        this.initFilterRadioList();
        this.initFilterRadioListOnlyInclude();
        this.initFilterDnsOpcodeList();
        this.initFilterKeyActionList();
        return "success";
    }

    public void saveFilterKey() {
        int startRange = 0;
        int endRange = 0;
        ArrayList<String> filterKeyVlueList = new ArrayList<String>();
        filterKeyVlueList.add("source-port");
        filterKeyVlueList.add("destination-port");
        filterKeyVlueList.add("packet-length");
        filterKeyVlueList.add("flow-packets");
        filterKeyVlueList.add("flow-average-octets");
        filterKeyVlueList.add("flow-octets");
        if (filterKeyVlueList.contains(this.filterKeyVlue)) {
            String[] currContent = this.filterContent.split("~");
            if (currContent.length == 1) {
                endRange = startRange = Integer.parseInt(currContent[0]);
            } else if (currContent.length == 2) {
                startRange = Integer.parseInt(currContent[0]);
                endRange = Integer.parseInt(currContent[1]);
            }
        }
        HttpFilterForm form = new HttpFilterForm();
        form.setFilterKey(this.filterKeyVlue);
        form.setFilterContent(this.filterContent);
        List<HttpFilterForm> sessionList = null;
        sessionList = this.getSessionFilterKey();
        if (sessionList == null) {
            sessionList = new ArrayList<HttpFilterForm>();
        }
        if ((this.filterKeyVlue.equals("source-ip") || this.filterKeyVlue.equals("destination-ip")) && this.isIpRangeExist(sessionList, this.filterContent)) {
            this.responseResult(this.getText("lego.err.570648"));
            return;
        }
        if ((this.filterKeyVlue.equals("source-port") || this.filterKeyVlue.equals("destination-port")) && this.isRangeExist(form.getFilterKey(), sessionList, startRange, endRange)) {
            this.responseResult(this.getText("lego.err.670721"));
            return;
        }
        if (this.filterKeyVlue.equals("packet-length") && this.isRangeExist(form.getFilterKey(), sessionList, startRange, endRange)) {
            this.responseResult(this.getText("lego.err.670722"));
            return;
        }
        if (this.filterKeyVlue.equals("identification")) {
            String[] currContent = this.filterContent.split("-");
            if (currContent.length == 1) {
                endRange = startRange = Integer.parseInt(currContent[0]);
            } else if (currContent.length == 2) {
                startRange = Integer.parseInt(currContent[0]);
                endRange = Integer.parseInt(currContent[1]);
            } else {
                this.responseResult(this.getText("lego.err.570601"));
                return;
            }
            if (this.isIpIdRangeExist(form.getFilterKey(), sessionList, startRange, endRange)) {
                this.responseResult(this.getText("lego.err.670742"));
                return;
            }
        }
        if (this.filterKeyVlue.equals("flow-packets") && this.isRangeExist(form.getFilterKey(), sessionList, startRange, endRange)) {
            this.responseResult(this.getText("lego.err.670739"));
            return;
        }
        if (this.filterKeyVlue.equals("flow-average-octets") && this.isRangeExist(form.getFilterKey(), sessionList, startRange, endRange)) {
            this.responseResult(this.getText("lego.err.670740"));
            return;
        }
        if (this.filterKeyVlue.equals("flow-octets") && this.isRangeExist(form.getFilterKey(), sessionList, startRange, endRange)) {
            this.responseResult(this.getText("lego.err.670741"));
            return;
        }
        if (this.isFormExist(sessionList, form)) {
            this.responseResult(this.getText("com.hs.vsm.secservice.ddos.filter.contant.same"));
            return;
        }
        if (this.isTooMuch(sessionList, this.filterKeyVlue)) {
            this.responseResult(MessageFormat.format(this.getText("com.hs.vsm.secservice.ddos.filter.number.limit"), FilterUtil.getNumber(this.filterKeyVlue)));
            return;
        }
        sessionList.add(form);
        this.setSessionFilterKey(sessionList);
        this.responseResult("success");
    }

    private boolean checkFingerPrint(String content) {
        String contentNospace;
        String[] fingers = content.split("        ");
        return fingers.length <= 3 || (contentNospace = content.replace(" ", "")).length() <= 403;
    }

    public void checkAllZoneIds() {
        this.getSession().setAttribute("filterZoneIds", (Object)this.zoneId);
    }

    public boolean compareBeforeAdd() {
        boolean bool2;
        String[] httpContent;
        boolean isContentRange;
        boolean isContentRange2;
        boolean isContentRange1;
        String[] packetLength;
        if (this.filterKeyVlue.equals("fingerprint")) {
            if (!this.checkFingerPrint(this.filterContent)) {
                return false;
            }
            FilterUtil.checkFingerprint(this.filterContent);
        }
        String ip = null;
        String mask = "";
        if (this.filterKeyVlue.equals("source-ip") || this.filterKeyVlue.equals("destination-ip")) {
            String[] currContent = this.filterContent.split("/");
            if (currContent.length != 2) {
                return false;
            }
            ip = currContent[0];
            mask = currContent[1];
            if (FilterUtil.isIpv4(ip) && mask != null && !FilterUtil.isIpv4Mask(mask)) {
                return false;
            }
            if (FilterUtil.isIpv6(ip) ? mask != null && !FilterUtil.isIpv6Mask(mask) : !FilterUtil.isIpv4(ip) && !FilterUtil.isIpv6(ip)) {
                return false;
            }
        }
        if ("source-port".equals(this.filterKeyVlue) || "destination-port".equals(this.filterKeyVlue)) {
            String[] portLength = this.filterContent.split("~");
            if (portLength.length == 1) {
                this.filterContent = portLength[0];
                if (!FilterUtil.isPortRange(portLength[0])) {
                    return false;
                }
            } else if (portLength.length == 2) {
                if (!FilterUtil.isPortRange(portLength[0]) || !FilterUtil.isPortRange(portLength[1])) {
                    return false;
                }
                if (Integer.parseInt(portLength[0]) > Integer.parseInt(portLength[1])) {
                    return false;
                }
            }
        }
        if ("packet-length".equals(this.filterKeyVlue)) {
            packetLength = this.filterContent.split("~");
            if (packetLength.length == 1) {
                return false;
            }
            if (packetLength.length == 2) {
                if (!FilterUtil.isPacketLengthRange(packetLength[0]) || !FilterUtil.isPacketLengthRange(packetLength[1])) {
                    return false;
                }
                if (Integer.parseInt(packetLength[0]) > Integer.parseInt(packetLength[1])) {
                    return false;
                }
            }
        }
        if ("flow-packets".equals(this.filterKeyVlue) || "flow-octets".equals(this.filterKeyVlue) || "flow-average-octets".equals(this.filterKeyVlue)) {
            packetLength = this.filterContent.split("~");
            if (packetLength.length == 1) {
                return false;
            }
            if (packetLength.length == 2) {
                if (!FilterUtil.isFlowPacketLengthRange(packetLength[0]) || !FilterUtil.isFlowPacketLengthRange(packetLength[1])) {
                    return false;
                }
                if (Integer.parseInt(packetLength[0]) > Integer.parseInt(packetLength[1])) {
                    return false;
                }
            }
        }
        if ("ttl".equals(this.filterKeyVlue) && !(isContentRange1 = FilterUtil.isCheckData1(this.filterContent))) {
            return false;
        }
        if ("identification".equals(this.filterKeyVlue)) {
            String[] ipId = this.filterContent.split("-");
            if (ipId.length == 1) {
                this.filterContent = ipId[0];
                if (!FilterUtil.isPortRange(ipId[0])) {
                    return false;
                }
            } else if (ipId.length == 2) {
                if (!FilterUtil.isPortRange(ipId[0]) || !FilterUtil.isPortRange(ipId[1])) {
                    return false;
                }
                if (Integer.parseInt(ipId[0]) > Integer.parseInt(ipId[1])) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (("dscp".equals(this.filterKeyVlue) || "protocol".equals(this.filterKeyVlue) || "type".equals(this.filterKeyVlue)) && !(isContentRange2 = FilterUtil.isCheckData2(this.filterContent))) {
            return false;
        }
        if ("tcp-flag".equals(this.filterKeyVlue) && !(isContentRange = FilterUtil.isCheckData3(this.filterContent))) {
            return false;
        }
        if (("cookie".equals(this.filterKeyVlue) || "host".equals(this.filterKeyVlue) || "referer".equals(this.filterKeyVlue) || "uri".equals(this.filterKeyVlue) || "user-agent".equals(this.filterKeyVlue)) && (!"include".equals((httpContent = this.filterContent.split("    ", 2))[0]) || !FilterUtil.isAnyCharacter(httpContent[1]))) {
            return false;
        }
        if (!(!"caller".equals(this.filterKeyVlue) && !"callee".equals(this.filterKeyVlue) && !"domain".equals(this.filterKeyVlue) || "include".equals((httpContent = this.filterContent.split("    ", 2))[0]) || "equal".equals(httpContent[0]) && FilterUtil.isAnyCharacter(httpContent[1]))) {
            return false;
        }
        if (!(!this.filterKeyVlue.equals("fragment") || "non".equals(this.filterContent) || "first".equals(this.filterContent) || "middle".equals(this.filterContent) || "last".equals(this.filterContent) || "donot".equals(this.filterContent))) {
            return false;
        }
        boolean bool1 = "get".equals(this.filterContent) || "post".equals(this.filterContent) || "put".equals(this.filterContent) || "head".equals(this.filterContent);
        boolean bl = bool2 = "delete".equals(this.filterContent) || "options".equals(this.filterContent) || "trace".equals(this.filterContent) || "connect".equals(this.filterContent);
        if (this.filterKeyVlue.equals("opcode") && !bool1 && !bool2) {
            return false;
        }
        return !this.filterKeyVlue.equals("qr") || "query".equals(this.filterContent) || "reply".equals(this.filterContent);
    }

    public String pagingfilterKey() {
        List<HttpFilterForm> temp = this.getSessionFilterKey();
        if (temp != null) {
            this.total = temp.size();
            this.filterListKeyFormList = temp.subList(this.start, this.total < this.start + this.pageSize ? this.total : this.start + this.pageSize);
        } else {
            this.total = 0;
        }
        return "success";
    }

    public void deleteFilterKey() {
        if (this.filterKeyList == null) {
            return;
        }
        String[] record = null;
        List<HttpFilterForm> sessionList = null;
        sessionList = this.getSessionFilterKey();
        if (sessionList == null) {
            this.responseResult("success");
            return;
        }
        for (int i = 0; i < this.filterKeyList.length; ++i) {
            HttpFilterForm form = new HttpFilterForm();
            record = this.filterKeyList[i].split(" ");
            form.setFilterKey(record[0]);
            String filterConten = this.filterKeyList[i].substring(record[0].length() + 1);
            form.setFilterContent(filterConten);
            this.deleteForm(sessionList, form);
        }
        this.responseResult("success");
    }

    private void deleteForm(List<HttpFilterForm> list, HttpFilterForm obj) {
        Iterator<HttpFilterForm> it = list.iterator();
        while (it.hasNext()) {
            HttpFilterForm tmp = it.next();
            if (!this.isSameForm(tmp, obj)) continue;
            it.remove();
        }
    }

    public void cleanFilterKeyList() {
        this.setSessionFilterKey(null);
        this.responseResult("success");
    }

    private boolean isRangeExist(String filterKeyVlu, List<HttpFilterForm> list, int startRange, int endRange) {
        for (HttpFilterForm filterFor : list) {
            if (!filterKeyVlu.equals(filterFor.getFilterKey())) continue;
            String filContent = filterFor.getFilterContent();
            String[] range = filContent.split("~");
            int srart = 0;
            int end = 0;
            if (range.length == 1) {
                end = srart = Integer.parseInt(range[0]);
            } else if (range.length == 2) {
                srart = Integer.parseInt(range[0]);
                end = Integer.parseInt(range[1]);
            } else {
                return true;
            }
            if (endRange < srart || end < startRange) continue;
            return true;
        }
        return false;
    }

    private boolean isIpIdRangeExist(String filterKeyVlu, List<HttpFilterForm> list, int startRange, int endRange) {
        for (HttpFilterForm filterFor : list) {
            if (!filterKeyVlu.equals(filterFor.getFilterKey())) continue;
            String filContent = filterFor.getFilterContent();
            String[] range = filContent.split("-");
            int srart = 0;
            int end = 0;
            if (range.length == 1) {
                end = srart = Integer.parseInt(range[0]);
            } else if (range.length == 2) {
                srart = Integer.parseInt(range[0]);
                end = Integer.parseInt(range[1]);
            }
            if (endRange < srart || end < startRange) continue;
            return true;
        }
        return false;
    }

    private boolean isIpRangeExist(List<HttpFilterForm> list, String ipAddress) {
        String[] content = ipAddress.split("/");
        String[] ipRange = IPUtil.getSubnetRange((String)content[0], (int)Integer.parseInt(content[1]));
        boolean isIpv4 = IPUtil.isIpv4((String)content[0]);
        ipRange[0] = IPUtil4Atic.compressIP((String)ipRange[0]);
        ipRange[1] = IPUtil4Atic.compressIP((String)ipRange[1]);
        for (HttpFilterForm filterFor : list) {
            String[] existContent;
            if (!"source-ip".equals(filterFor.getFilterKey()) && !"destination-ip".equals(filterFor.getFilterKey()) || IPUtil.isIpv4((String)(existContent = filterFor.getFilterContent().split("/"))[0]) != isIpv4) continue;
            String[] existIpRange = new String[]{};
            if (existContent.length == 2) {
                existIpRange = IPUtil.getSubnetRange((String)existContent[0], (int)Integer.parseInt(existContent[1]));
                existIpRange[0] = IPUtil4Atic.compressIP((String)existIpRange[0]);
                existIpRange[1] = IPUtil4Atic.compressIP((String)existIpRange[1]);
            } else if (existContent.length == 1) {
                existIpRange = existContent;
            }
            if (existIpRange.length == 1 && IPUtil.isInIpRange((String[])ipRange, (String)existIpRange[0])) {
                return true;
            }
            if (ipRange[0].compareTo(existIpRange[1]) > 0 || existIpRange[0].compareTo(ipRange[1]) > 0) continue;
            return true;
        }
        return false;
    }

    private boolean isFormExist(List<HttpFilterForm> list, HttpFilterForm obj) {
        for (HttpFilterForm tmp : list) {
            if (!this.isSameForm(tmp, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean isTooMuch(List<HttpFilterForm> list, String filterKey) {
        int count = 0;
        for (HttpFilterForm tmp : list) {
            if (!tmp.getFilterKey().equals(filterKey)) continue;
            ++count;
        }
        return count >= FilterUtil.getNumber(filterKey);
    }

    private boolean isSameForm(HttpFilterForm obj1, HttpFilterForm obj2) {
        return obj1.getFilterKey().equals(obj2.getFilterKey()) && obj1.getFilterContent().equals(obj2.getFilterContent());
    }

    private List<HttpFilterForm> getSessionFilterKey() {
        String sessionId = this.getSession().getId();
        return (List)this.getSession().getAttribute(SESSION_FILTER_KEY + sessionId);
    }

    private void initSessionFilterKey() {
        if (this.filterForm != null) {
            List<HttpFilterForm> httpFilterForms = this.filterForm.getHttpFilterFormList();
            for (HttpFilterForm httpFilterForm : httpFilterForms) {
                String fString = httpFilterForm.getFilterContent();
                if (!fString.contains("cookie") && !fString.contains("referer") && !fString.contains("uri") && !fString.contains("userAgent") && !fString.contains("domain")) continue;
                httpFilterForm.setFilterContent(fString.replaceAll("\\\\x20", " "));
            }
            this.setSessionFilterKey(httpFilterForms);
        } else {
            this.setSessionFilterKey(null);
        }
    }

    private void setSessionFilterKey(List<HttpFilterForm> list) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute(SESSION_FILTER_KEY + sessionId, list);
    }

    public String showImportFilter() {
        return "success";
    }

    private void initDeviceTypeList(boolean isAdd) {
        this.filterDeviceTypeList = new ArrayList<LangPair>();
        this.filterDeviceTypeList.add(new LangPair("AntiDDoS", "AntiDDoS"));
        this.filterDeviceTypeList.add(new LangPair("AntiDDoS1820-N", "AntiDDoS1820-N"));
        this.filterDeviceTypeList.add(new LangPair("ALL", "ALL"));
        this.setDeviceTypeLabelAndValue(isAdd ? "AntiDDoS" : this.filterForm.getDeviceType());
    }

    private void setDeviceTypeLabelAndValue(String value) {
        this.setFilterDeviceTypeLabel(value);
        this.setFilterDeviceTypeValue(value);
    }

    private void initFilterTypeList(boolean isAdd) {
        this.filterTypeList = new ArrayList<LangPair>();
        this.filterTypeList.add(new LangPair("IP", "IP"));
        this.filterTypeList.add(new LangPair("TCP", "TCP"));
        this.filterTypeList.add(new LangPair("UDP", "UDP"));
        this.filterTypeList.add(new LangPair("ICMP", "ICMP"));
        this.filterTypeList.add(new LangPair("HTTP", "HTTP"));
        this.filterTypeList.add(new LangPair("DNS", "DNS"));
        this.filterTypeList.add(new LangPair("SIP", "SIP"));
        this.setTypeLabelAndValue(isAdd ? "IP" : this.filterForm.getFilterType());
    }

    private void setTypeLabelAndValue(String value) {
        this.setFilterTypeLabel(value);
        this.setFilterTypeValue(value);
    }

    private void initFilterActionList(boolean isAdd) {
        this.filterActionList = new ArrayList<LangPair>();
        this.filterActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.filter.action.drop"), String.valueOf(3)));
        this.filterActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.filter.action.drop.black"), String.valueOf(4)));
        this.filterActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.filter.action.pass"), String.valueOf(1)));
        this.filterActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.filter.action.pass.white"), String.valueOf(2)));
        this.filterActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.filter.action.limit"), String.valueOf(5)));
        this.filterActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.filter.action.source.limit"), String.valueOf(7)));
        this.setActionLabelAndValue(isAdd ? Integer.valueOf(3) : this.filterForm.getFilterAction());
    }

    private void setActionLabelAndValue(Integer value) {
        switch (value) {
            case 1: {
                this.setFilterActionLabel(this.getText("com.hs.vsm.secservice.ddos.filter.action.pass"));
                this.setFilterActionValue(String.valueOf(1));
                break;
            }
            case 2: {
                this.setFilterActionLabel(this.getText("com.hs.vsm.secservice.ddos.filter.action.pass.white"));
                this.setFilterActionValue(String.valueOf(2));
                break;
            }
            case 3: {
                this.setFilterActionLabel(this.getText("com.hs.vsm.secservice.ddos.filter.action.drop"));
                this.setFilterActionValue(String.valueOf(3));
                break;
            }
            case 4: {
                this.setFilterActionLabel(this.getText("com.hs.vsm.secservice.ddos.filter.action.drop.black"));
                this.setFilterActionValue(String.valueOf(4));
                break;
            }
            case 5: {
                this.setFilterActionLabel(this.getText("com.hs.vsm.secservice.ddos.filter.action.limit"));
                this.setFilterActionValue(String.valueOf(5));
                break;
            }
            case 6: {
                this.setFilterActionLabel(this.getText("com.hs.vsm.secservice.ddos.filter.action.source.ip"));
                this.setFilterActionValue(String.valueOf(6));
                break;
            }
            case 7: {
                this.setFilterActionLabel(this.getText("com.hs.vsm.secservice.ddos.filter.action.source.limit"));
                this.setFilterActionValue(String.valueOf(7));
                break;
            }
        }
    }

    private void initFilterFragmentTypeList() {
        this.filterFragmentTypeList = new ArrayList<LangPair>();
        this.filterFragmentTypeList.add(new LangPair("non", "non"));
        this.filterFragmentTypeList.add(new LangPair("first", "first"));
        this.filterFragmentTypeList.add(new LangPair("middle", "middle"));
        this.filterFragmentTypeList.add(new LangPair("last", "last"));
        this.filterFragmentTypeList.add(new LangPair("donot", "donot"));
        this.setFilterFragmentTypeValue("non");
        this.setFilterFragmentTypeLabel("non");
    }

    private void initFilterHttpOpcodeList() {
        this.filterHttpOpcodeList = new ArrayList<LangPair>();
        this.filterHttpOpcodeList.add(new LangPair("get", "get"));
        this.filterHttpOpcodeList.add(new LangPair("post", "post"));
        this.filterHttpOpcodeList.add(new LangPair("put", "put"));
        this.filterHttpOpcodeList.add(new LangPair("head", "head"));
        this.filterHttpOpcodeList.add(new LangPair("delete", "delete"));
        this.filterHttpOpcodeList.add(new LangPair("options", "options"));
        this.filterHttpOpcodeList.add(new LangPair("trace", "trace"));
        this.filterHttpOpcodeList.add(new LangPair("connect", "connect"));
        this.setFilterHttpOpcodeValue("get");
        this.setFilterHttpOpcodeLabel("get");
    }

    private void initFilterDnsOpcodeList() {
        this.filterDnsOpcodeList = new ArrayList<LangPair>();
        this.filterDnsOpcodeList.add(new LangPair("query", "query"));
        this.filterDnsOpcodeList.add(new LangPair("reply", "reply"));
        this.setFilterDnsOpcodeValue("query");
        this.setFilterDnsOpcodeLabel("query");
    }

    private void initFilterRadioList() {
        this.filterRadioList = new ArrayList<RadioGroupVO>();
        RadioGroupVO vo = new RadioGroupVO();
        vo.setLabel("include");
        vo.setKey(1);
        this.filterRadioList.add(vo);
        vo = new RadioGroupVO();
        vo.setLabel("equal");
        vo.setKey(2);
        this.filterRadioList.add(vo);
    }

    private void initFilterRadioListOnlyInclude() {
        this.filterRadioListOnlyInclude = new ArrayList<RadioGroupVO>();
        RadioGroupVO vo = new RadioGroupVO();
        vo.setLabel("include");
        vo.setKey(1);
        this.filterRadioListOnlyInclude.add(vo);
    }

    public void getFilterKeyList() {
        if (null == this.filterType || null == this.deviceType) {
            return;
        }
        if (this.deviceType.equals("AntiDDoS")) {
            if (this.filterType.equals("IP")) {
                this.responseResult("[['source-ip','source-ip'],['destination-ip','destination-ip'],['packet-length','packet-length'],['identification','identification'],['ttl','ttl'],['fingerprint','fingerprint'],['protocol','protocol'],['dscp','dscp'],['fragment','fragment']]");
            } else if (this.filterType.equals("TCP")) {
                this.responseResult("[['source-ip','source-ip'],['destination-ip','destination-ip'],['packet-length','packet-length'],['identification','identification'],['ttl','ttl'],['fingerprint','fingerprint'],['dscp','dscp'],['fragment','fragment'],['tcp-flag','tcp-flag'],['destination-port','destination-port'],['source-port','source-port']]");
            } else if (this.filterType.equals("UDP")) {
                this.responseResult("[['source-ip','source-ip'],['destination-ip','destination-ip'],['packet-length','packet-length'],['ttl','ttl'],['identification','identification'],['fingerprint','fingerprint'],['dscp','dscp'],['fragment','fragment'],['destination-port','destination-port'],['source-port','source-port']]");
            } else if (this.filterType.equals("ICMP")) {
                this.responseResult("[['source-ip','source-ip'],['destination-ip','destination-ip'],['packet-length','packet-length'],['ttl','ttl'],['identification','identification'],['fingerprint','fingerprint'],['dscp','dscp'],['fragment','fragment']]");
            } else if (this.filterType.equals("HTTP")) {
                this.responseResult("[['source-ip','source-ip'],['destination-ip','destination-ip'],['packet-length','packet-length'],['ttl','ttl'],['identification','identification'],['fingerprint','fingerprint'],['dscp','dscp'],['fragment','fragment'],['tcp-flag','tcp-flag'],['source-port','source-port'],['opcode','opcode'],['cookie','cookie'],['host','host'],['referer','referer'],['uri','uri'],['user-agent','user-agent']]");
            } else if (this.filterType.equals("DNS")) {
                this.responseResult("[['source-ip','source-ip'],['destination-ip','destination-ip'],['packet-length','packet-length'],['ttl','ttl'],['identification','identification'],['fingerprint','fingerprint'],['dscp','dscp'],['fragment','fragment'],['source-port','source-port'],['domain','domain'],['qr','qr'],['type','type']]");
            } else if (this.filterType.equals("SIP")) {
                this.responseResult("[['source-ip','source-ip'],['destination-ip','destination-ip'],['packet-length','packet-length'],['ttl','ttl'],['identification','identification'],['fingerprint','fingerprint'],['dscp','dscp'],['fragment','fragment'],['source-port','source-port'],['caller','caller'],['callee','callee']]");
            }
        } else if (this.deviceType.equals("AntiDDoS1820-N")) {
            if (this.filterType.equals("IP")) {
                this.responseResult("[['protocol','protocol'],['dscp','dscp'],['flow-average-octets','flow-average-octets'],['flow-packets','flow-packets'],['flow-octets','flow-octets']]");
            } else if (this.filterType.equals("TCP")) {
                this.responseResult("[['dscp','dscp'],['tcp-flag','tcp-flag'],['destination-port','destination-port'],['source-port','source-port'],['flow-average-octets','flow-average-octets'],['flow-packets','flow-packets'],['flow-octets','flow-octets']]");
            } else if (this.filterType.equals("UDP")) {
                this.responseResult("[['dscp','dscp'],['destination-port','destination-port'],['source-port','source-port'],['flow-average-octets','flow-average-octets'],['flow-packets','flow-packets'],['flow-octets','flow-octets']]");
            } else if (this.filterType.equals("ICMP")) {
                this.responseResult("[['dscp','dscp'],['flow-average-octets','flow-average-octets'],['flow-packets','flow-packets'],['flow-octets','flow-octets']]");
            } else if (this.filterType.equals("HTTP")) {
                this.responseResult("[['dscp','dscp'],['tcp-flag','tcp-flag'],['source-port','source-port'],['flow-average-octets','flow-average-octets'],['flow-packets','flow-packets'],['flow-octets','flow-octets']]");
            } else if (this.filterType.equals("DNS")) {
                this.responseResult("[['dscp','dscp'],['source-port','source-port'],['flow-average-octets','flow-average-octets'],['flow-packets','flow-packets'],['flow-octets','flow-octets']]");
            } else if (this.filterType.equals("SIP")) {
                this.responseResult("[['dscp','dscp'],['source-port','source-port'],['flow-average-octets','flow-average-octets'],['flow-packets','flow-packets'],['flow-octets','flow-octets']]");
            }
        } else if (this.deviceType.equals("ALL")) {
            if (this.filterType.equals("IP")) {
                this.responseResult("[['protocol','protocol'],['dscp','dscp'],['packet-length','packet-length']]");
            } else if (this.filterType.equals("TCP")) {
                this.responseResult("[['dscp','dscp'],['tcp-flag','tcp-flag'],['packet-length','packet-length'],['destination-port','destination-port'],['source-port','source-port']]");
            } else if (this.filterType.equals("UDP")) {
                this.responseResult("[['dscp','dscp'],['packet-length','packet-length'],['destination-port','destination-port'],['source-port','source-port']]");
            } else if (this.filterType.equals("ICMP")) {
                this.responseResult("[['dscp','dscp'],['packet-length','packet-length']]");
            } else if (this.filterType.equals("HTTP")) {
                this.responseResult("[['dscp','dscp'],['tcp-flag','tcp-flag'],['source-port','source-port'],['packet-length','packet-length']]");
            } else if (this.filterType.equals("DNS")) {
                this.responseResult("[['dscp','dscp'],['source-port','source-port'],['packet-length','packet-length']]");
            } else if (this.filterType.equals("SIP")) {
                this.responseResult("[['dscp','dscp'],['source-port','source-port'],['packet-length','packet-length']]");
            }
        }
    }

    private void initFilterKeyActionList() {
        this.filterKeyActionList = new ArrayList<LangPair>();
        this.filterKeyActionList.add(new LangPair("include", "include"));
        this.filterKeyActionList.add(new LangPair("exclude", "exclude"));
    }

    public String queryAllZone() {
        IZoneService service = ZoneReferUtil.getZoneService();
        this.zoneInfoList = service.getAll();
        IZonePolicyApplyService zonePolicyService = ZoneReferUtil.getZonePolicyService();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        User user = (User)this.getSession().getAttribute("currentUser");
        if (null != this.zoneName) {
            queryMap.put("zoneName", this.zoneName.trim());
        }
        queryMap.put("adminId", String.valueOf(user.getUserID()));
        queryMap.put("isAdmin", user.getIsAdmin());
        queryMap.put("filterZoneDeployState", "SUCCESS");
        this.zoneId = (String)this.getSession().getAttribute("filterZoneIds");
        if (null != this.zoneId && !this.zoneId.isEmpty()) {
            queryMap.put("exclude", this.zoneId);
        }
        Paging page = zonePolicyService.queryByPage(queryMap, this.start, this.pageSize);
        List tempZonePolicyFormList = page.getData();
        this.total = page.getCount();
        List<ZonePolicyApplyForm> zPolicyList = null;
        if (null != tempZonePolicyFormList) {
            zPolicyList = this.getZonePolicyByDeviceType(tempZonePolicyFormList);
        } else {
            this.log.error((Object)"tempZonePolicyFormList is null");
        }
        this.zonePolicyFormList = new ArrayList<ZonePolicyApplyForm>();
        if (null != zPolicyList && !zPolicyList.isEmpty()) {
            this.zonePolicyFormList = zPolicyList;
        }
        this.dealZonePolicyNe();
        return "success";
    }

    private List<ZonePolicyApplyForm> getZonePolicyByDeviceType(List<ZonePolicyApplyForm> zonePolicyFormLis) {
        ArrayList<ZonePolicyApplyForm> zList;
        block11: {
            IZoneDeviceService zoneDeviceService;
            User currentUser;
            block12: {
                block10: {
                    currentUser = (User)this.getSession().getAttribute("currentUser");
                    if (currentUser == null) {
                        throw new LegoSecurityException(206L);
                    }
                    zList = new ArrayList<ZonePolicyApplyForm>();
                    zoneDeviceService = ZoneReferUtil.getZoneDeviceService();
                    if (null == this.deviceType || !this.deviceType.equals("AntiDDoS")) break block10;
                    List aticDeviceList = null;
                    aticDeviceList = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
                    block0: for (ZonePolicyApplyForm zonePolicyForm : zonePolicyFormLis) {
                        List deviceIdList = zoneDeviceService.getDeviceIdsByZoneId(zonePolicyForm.getZoneId());
                        for (Long deviceId : deviceIdList) {
                            for (AticDevice aticDevice : aticDeviceList) {
                                if (null == aticDevice || aticDevice.getMoId() != deviceId.longValue() || aticDevice.getDeviceType() != 1) continue;
                                zList.add(zonePolicyForm);
                                continue block0;
                            }
                        }
                    }
                    break block11;
                }
                if (null == this.deviceType || !this.deviceType.equals("AntiDDoS1820-N")) break block12;
                List aticDeviceList = this.aticDeviceService.getClusterAndNfa(currentUser.getUserID());
                block3: for (ZonePolicyApplyForm zonePolicyForm : zonePolicyFormLis) {
                    List deviceIdList = zoneDeviceService.getDeviceIdsByZoneId(zonePolicyForm.getZoneId());
                    for (Long deviceId : deviceIdList) {
                        for (AticDevice aticDevice : aticDeviceList) {
                            if (null == aticDevice || aticDevice.getMoId() != deviceId.longValue() || aticDevice.getDeviceType() != 8 && aticDevice.getDeviceType() != 9) continue;
                            zList.add(zonePolicyForm);
                            continue block3;
                        }
                    }
                }
                break block11;
            }
            if (null == this.deviceType || !this.deviceType.equalsIgnoreCase("ALL")) break block11;
            List aticDeviceList = null;
            aticDeviceList = this.aticDeviceService.getAllDevice(currentUser.getUserID(), Boolean.valueOf(currentUser.getIsAdmin()).booleanValue());
            block6: for (ZonePolicyApplyForm zonePolicyForm : zonePolicyFormLis) {
                List deviceIdList = zoneDeviceService.getDeviceIdsByZoneId(zonePolicyForm.getZoneId());
                for (Long deviceId : deviceIdList) {
                    for (AticDevice aticDevice : aticDeviceList) {
                        if (null == aticDevice || aticDevice.getMoId() != deviceId.longValue()) continue;
                        zList.add(zonePolicyForm);
                        continue block6;
                    }
                }
            }
        }
        return zList;
    }

    private void dealZonePolicyNe() {
        if (null != this.zonePolicyFormList) {
            ICommonUtilService commonUtilService = ZoneReferUtil.getCommonUtilService();
            List securityNEList = null;
            User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
            securityNEList = this.aticDeviceService.getAllDevice(currentUser.getUserID(), "true".equalsIgnoreCase(currentUser.getIsAdmin()));
            for (ZonePolicyApplyForm zonePolicyForm : this.zonePolicyFormList) {
                List<ZoneDeviceForm> zoneDevices = zonePolicyForm.getZoneDeviceForms();
                StringBuffer deviceNameBuffer = new StringBuffer();
                block1: for (ZoneDeviceForm zoneDeviceForm : zoneDevices) {
                    for (AticDevice securityNE : securityNEList) {
                        String deviceName;
                        if (null == securityNE || securityNE.getMoId() != zoneDeviceForm.getDeviceId().longValue()) continue;
                        if ("4".equals(commonUtilService.getDDoSVersion(securityNE)) || securityNE.getDeviceType() == 8 || securityNE.getDeviceType() == 9) {
                            deviceName = securityNE.getName();
                            deviceNameBuffer.append(deviceName + "N;");
                            continue block1;
                        }
                        deviceName = securityNE.getName();
                        deviceNameBuffer.append(deviceName + "X;");
                        continue block1;
                    }
                }
                if (deviceNameBuffer.toString().endsWith(";")) {
                    deviceNameBuffer.deleteCharAt(deviceNameBuffer.lastIndexOf(";"));
                }
                zonePolicyForm.setDeviceNames(deviceNameBuffer.toString());
            }
        }
    }

    public List<RadioGroupVO> getHttpFilterActionList() {
        return this.httpFilterActionList;
    }

    public void setHttpFilterActionList(List<RadioGroupVO> httpFilterActionList) {
        this.httpFilterActionList = httpFilterActionList;
    }

    public Integer getHttpFilterAction() {
        return this.httpFilterAction;
    }

    public void setHttpFilterAction(Integer httpFilterAction) {
        this.httpFilterAction = httpFilterAction;
    }

    public List<LangPair> getFilterTypeList() {
        return this.filterTypeList;
    }

    public void setFilterTypeList(List<LangPair> filterTypeList) {
        this.filterTypeList = filterTypeList;
    }

    public String getFilterTypeValue() {
        return this.filterTypeValue;
    }

    public void setFilterTypeValue(String filterTypeValue) {
        this.filterTypeValue = filterTypeValue;
    }

    public String getFilterTypeLabel() {
        return this.filterTypeLabel;
    }

    public void setFilterTypeLabel(String filterTypeLabel) {
        this.filterTypeLabel = filterTypeLabel;
    }

    public FilterForm getFilterForm() {
        return this.filterForm;
    }

    public void setFilterForm(FilterForm filterForm) {
        this.filterForm = filterForm;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<HttpFilterForm> getHttpFilterFormList() {
        return this.httpFilterFormList;
    }

    public void setHttpFilterFormList(List<HttpFilterForm> httpFilterFormList) {
        this.httpFilterFormList = httpFilterFormList;
    }

    public String getFilterKeyValue() {
        return this.filterKeyValue;
    }

    public void setFilterKeyValue(String filterKeyValue) {
        this.filterKeyValue = filterKeyValue;
    }

    public List<LangPair> getFilterKeyActionList() {
        return this.filterKeyActionList;
    }

    public void setFilterKeyActionList(List<LangPair> filterKeyActionList) {
        this.filterKeyActionList = filterKeyActionList;
    }

    public List<ZoneInfoForm> getZoneInfoList() {
        return this.zoneInfoList;
    }

    public void setZoneInfoList(List<ZoneInfoForm> zoneInfoList) {
        this.zoneInfoList = zoneInfoList;
    }

    public List<ZonePolicyApplyForm> getZonePolicyFormList() {
        return this.zonePolicyFormList;
    }

    public void setZonePolicyFormList(List<ZonePolicyApplyForm> zonePolicyFormList) {
        this.zonePolicyFormList = zonePolicyFormList;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public List<LangPair> getFilterActionList() {
        return this.filterActionList;
    }

    public void setFilterActionList(List<LangPair> filterActionList) {
        this.filterActionList = filterActionList;
    }

    public String getFilterActionValue() {
        return this.filterActionValue;
    }

    public void setFilterActionValue(String filterActionValue) {
        this.filterActionValue = filterActionValue;
    }

    public String getFilterActionLabel() {
        return this.filterActionLabel;
    }

    public void setFilterActionLabel(String filterActionLabel) {
        this.filterActionLabel = filterActionLabel;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public List<LangPair> getFilterFragmentTypeList() {
        return this.filterFragmentTypeList;
    }

    public void setFilterFragmentTypeList(List<LangPair> filterFragmentTypeList) {
        this.filterFragmentTypeList = filterFragmentTypeList;
    }

    public String getFilterFragmentTypeValue() {
        return this.filterFragmentTypeValue;
    }

    public void setFilterFragmentTypeValue(String filterFragmentTypeValue) {
        this.filterFragmentTypeValue = filterFragmentTypeValue;
    }

    public String getFilterFragmentTypeLabel() {
        return this.filterFragmentTypeLabel;
    }

    public void setFilterFragmentTypeLabel(String filterFragmentTypeLabel) {
        this.filterFragmentTypeLabel = filterFragmentTypeLabel;
    }

    public List<LangPair> getFilterHttpOpcodeList() {
        return this.filterHttpOpcodeList;
    }

    public void setFilterHttpOpcodeList(List<LangPair> filterHttpOpcodeList) {
        this.filterHttpOpcodeList = filterHttpOpcodeList;
    }

    public String getFilterHttpOpcodeValue() {
        return this.filterHttpOpcodeValue;
    }

    public void setFilterHttpOpcodeValue(String filterHttpOpcodeValue) {
        this.filterHttpOpcodeValue = filterHttpOpcodeValue;
    }

    public String getFilterHttpOpcodeLabel() {
        return this.filterHttpOpcodeLabel;
    }

    public void setFilterHttpOpcodeLabel(String filterHttpOpcodeLabel) {
        this.filterHttpOpcodeLabel = filterHttpOpcodeLabel;
    }

    public List<LangPair> getFilterDnsOpcodeList() {
        return this.filterDnsOpcodeList;
    }

    public void setFilterDnsOpcodeList(List<LangPair> filterDnsOpcodeList) {
        this.filterDnsOpcodeList = filterDnsOpcodeList;
    }

    public String getFilterDnsOpcodeValue() {
        return this.filterDnsOpcodeValue;
    }

    public void setFilterDnsOpcodeValue(String filterDnsOpcodeValue) {
        this.filterDnsOpcodeValue = filterDnsOpcodeValue;
    }

    public String getFilterDnsOpcodeLabel() {
        return this.filterDnsOpcodeLabel;
    }

    public void setFilterDnsOpcodeLabel(String filterDnsOpcodeLabel) {
        this.filterDnsOpcodeLabel = filterDnsOpcodeLabel;
    }

    public List<RadioGroupVO> getFilterRadioList() {
        return this.filterRadioList;
    }

    public void setFilterRadioList(List<RadioGroupVO> filterRadioList) {
        this.filterRadioList = filterRadioList;
    }

    public String getFilterAttackTypeValue() {
        return this.filterAttackTypeValue;
    }

    public void setFilterAttackTypeValue(String filterAttackTypeValue) {
        this.filterAttackTypeValue = filterAttackTypeValue;
    }

    public String getFilterAttackTypeLabel() {
        return this.filterAttackTypeLabel;
    }

    public void setFilterAttackTypeLabel(String filterAttackTypeLabel) {
        this.filterAttackTypeLabel = filterAttackTypeLabel;
    }

    public int getFilterId() {
        return this.filterId;
    }

    public void setFilterId(int filterId) {
        this.filterId = filterId;
    }

    public List<RadioGroupVO> getFilterRadioListOnlyInclude() {
        return this.filterRadioListOnlyInclude;
    }

    public void setFilterRadioListOnlyInclude(List<RadioGroupVO> filterRadioListOnlyInclude) {
        this.filterRadioListOnlyInclude = filterRadioListOnlyInclude;
    }

    public String getFilterKeyVlue() {
        return this.filterKeyVlue;
    }

    public void setFilterKeyVlue(String filterKeyVlue) {
        this.filterKeyVlue = filterKeyVlue;
    }

    public String getFilterContent() {
        return this.filterContent;
    }

    public void setFilterContent(String filterContent) {
        this.filterContent = filterContent;
    }

    public HttpFilterForm getFilterListkeyForm() {
        return this.filterListkeyForm;
    }

    public void setFilterListkeyForm(HttpFilterForm filterListkeyForm) {
        this.filterListkeyForm = filterListkeyForm;
    }

    public void setFilterKeyList(String[] filterKeyList) {
        this.filterKeyList = null != filterKeyList ? (String[])filterKeyList.clone() : null;
    }

    public List<HttpFilterForm> getFilterListKeyFormList() {
        return this.filterListKeyFormList;
    }

    public void setFilterListKeyFormList(List<HttpFilterForm> filterListKeyFormList) {
        this.filterListKeyFormList = filterListKeyFormList;
    }

    public Integer getFilterIdValue() {
        return this.filterIdValue;
    }

    public void setFilterIdValue(Integer filterIdValue) {
        this.filterIdValue = filterIdValue;
    }

    public List<LangPair> getFilterDeviceTypeList() {
        return this.filterDeviceTypeList;
    }

    public void setFilterDeviceTypeList(List<LangPair> filterDeviceTypeList) {
        this.filterDeviceTypeList = filterDeviceTypeList;
    }

    public String getFilterDeviceTypeValue() {
        return this.filterDeviceTypeValue;
    }

    public void setFilterDeviceTypeValue(String filterDeviceTypeValue) {
        this.filterDeviceTypeValue = filterDeviceTypeValue;
    }

    public String getFilterDeviceTypeLabel() {
        return this.filterDeviceTypeLabel;
    }

    public void setFilterDeviceTypeLabel(String filterDeviceTypeLabel) {
        this.filterDeviceTypeLabel = filterDeviceTypeLabel;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    public List<AticDevice> getDeviceList() {
        return this.deviceList;
    }

    public String getWhichPage() {
        return this.whichPage;
    }

    public void setWhichPage(String whichPage) {
        this.whichPage = whichPage;
    }

    public void setDeviceList(List<AticDevice> deviceList) {
        this.deviceList = deviceList;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IFilterDeviceZoneStatusService getFilterDeviceZoneStatusService() {
        return this.filterDeviceZoneStatusService;
    }

    public void setFilterDeviceZoneStatusService(IFilterDeviceZoneStatusService filterDeviceZoneStatusService) {
        this.filterDeviceZoneStatusService = filterDeviceZoneStatusService;
    }

    public boolean validateZoneName() {
        if (null == this.zoneName || "".equals(this.zoneName.trim())) {
            return true;
        }
        if (this.zoneName.trim().equalsIgnoreCase("null")) {
            return false;
        }
        String regexName = "^(?!null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|^|.|+|}|{]*$";
        return this.zoneName.matches(regexName);
    }

    public boolean validateFilterKeyList() {
        if (null == this.filterKeyList || this.filterKeyList.length == 0) {
            return false;
        }
        String filterListRegex = "^[\\w|\\s|\u4e00-\u9fa5|=|\\-|/|_|!|&|;|@|#|$|~|*|^|:|,|.|+|}|{|\\\\]*$";
        String key = "";
        for (String str : this.filterKeyList) {
            int index = str.indexOf(" ");
            if (index > -1) {
                key = str.substring(0, index);
                if ("fingerprint".equals(key) || "cookie".equals(key) || "host".equals(key) || "referer".equals(key) || "uri".equals(key) || "user-agent".equals(key) || "domain".equals(key) || "caller".equals(key) || "callee".equals(key)) {
                    return true;
                }
                if (str.matches(filterListRegex)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean validateZoneId() {
        if (StringUtils.isBlank((CharSequence)this.zoneId)) {
            return true;
        }
        String[] ids = this.zoneId.split(",");
        if (ids.length > 10000) {
            return false;
        }
        for (int i = 0; i < ids.length; ++i) {
            long tmpId = 0L;
            try {
                tmpId = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (tmpId >= 1L) continue;
            return false;
        }
        return true;
    }
}

