/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.struts2.ServletActionContext;

public class FilterTemplateAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String SESSION_ZONE_IP = "zoneIps";
    private String deviceIdList;
    private String neName;
    private List<AticDevice> deviceList;
    private transient IAticDeviceService aticDeviceService;
    private List<ZoneInfoForm> zoneInfoList;
    private String zoneName;
    private String zoneId;
    private List<ZonePolicyApplyForm> zonePolicyFormList;
    private String deviceType;
    private Long filterId;
    private String[] cacheZonePolicyForms;
    private String delCacheZoneIds;
    private String isClearSession;
    private String filterZoneIds;
    private int unDeployNumber;

    public String addDevice() {
        Paging page;
        List zoneDevices;
        this.deviceList = new ArrayList<AticDevice>();
        Map<String, String> queryMap = this.getConditions();
        HashSet<Long> deviceSet = new HashSet<Long>();
        IClusterService clusterService = ZoneReferUtil.getClusterService();
        this.dealRelNe(deviceSet);
        if (null != this.aticDeviceService && null != (zoneDevices = (page = this.aticDeviceService.getDeviceByPage(queryMap, 0, Integer.MAX_VALUE)).getData()) && !zoneDevices.isEmpty()) {
            for (AticDevice aticDevice : zoneDevices) {
                long deviceId01 = aticDevice.getMoId();
                Boolean clusterDevice = clusterService.isBelongCluster(Long.valueOf(deviceId01));
                if (clusterDevice.booleanValue() || deviceSet.contains(deviceId01) || aticDevice.getDeviceType() == 3 || aticDevice.getDeviceType() == 6) continue;
                if (null != this.aticDeviceService) {
                    aticDevice.setDeviceStateVal(this.getDeviceStateVal(this.aticDeviceService.getStatusByMoid(aticDevice.getMoId())));
                } else {
                    LOGGER.error((Object)"fail to get device status.");
                }
                if (null != this.deviceType && "ALL".equals(this.deviceType)) {
                    this.deviceList.add(aticDevice);
                    continue;
                }
                if (null != this.deviceType && "AntiDDoS".equals(this.deviceType)) {
                    if (aticDevice.getDeviceType() != 1) continue;
                    this.deviceList.add(aticDevice);
                    continue;
                }
                if (null == this.deviceType || !"AntiDDoS1820-N".equals(this.deviceType) || aticDevice.getDeviceType() != 8 && aticDevice.getDeviceType() != 9) continue;
                this.deviceList.add(aticDevice);
            }
        }
        return "success";
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.neName && this.neName.length() > 0) {
            queryMap.put("nameOrIp", this.neName.trim());
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        queryMap.put("isDdosType", "true");
        queryMap.put("userId", String.valueOf(currentUser.getUserID()));
        queryMap.put("isAdmin", currentUser.getIsAdmin());
        return queryMap;
    }

    private void dealRelNe(Set<Long> deviceSet) {
        if (null != this.deviceIdList && this.deviceIdList.length() > 0) {
            String[] deviceArray;
            for (String deviceId01 : deviceArray = this.deviceIdList.split(",")) {
                if (AticUtil.isNull((String)deviceId01)) continue;
                try {
                    deviceSet.add(Long.parseLong(deviceId01));
                }
                catch (Exception e) {
                    LOGGER.error((Object)"deviceId is not in deviceSet");
                }
            }
        }
        ArrayList<Long> moIdList = new ArrayList<Long>(deviceSet);
        BisUtil.checkUserSecurity(moIdList);
    }

    private String getDeviceStateVal(int deviceState) {
        if (deviceState == 0) {
            return this.getText("com.hs.vsm.secservice.ddos.policy.deviceState.online");
        }
        if (deviceState == -1) {
            return this.getText("com.hs.vsm.secservice.ddos.policy.deviceState.offline");
        }
        if (deviceState == -2) {
            return this.getText("com.hs.vsm.secservice.ddos.policy.device.unsupported");
        }
        return this.getText("com.hs.vsm.secservice.ddos.policy.device.unknown");
    }

    public String relationZoneDeploy() {
        this.filterZoneIds = "";
        this.unDeployNumber = 0;
        this.zonePolicyFormList = new ArrayList<ZonePolicyApplyForm>();
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        if (null != this.isClearSession && "true".equals(this.isClearSession)) {
            this.setSessionZoneIp(null);
            IFilterDeviceZoneInfoService filterDeviceZoneInfoService = ZoneReferUtil.getFilterDeviceZoneInfoService();
            IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
            User user = (User)this.getSession().getAttribute("currentUser");
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("userId", String.valueOf(user.getUserID()));
            queryMap.put("isAdmin", user.getIsAdmin());
            queryMap.put("filterId", String.valueOf(this.filterId));
            List<FilterDeviceZoneForm> filterDeviceZoneForms = filterDeviceZoneInfoService.getByFilterIdAuthority(queryMap);
            IZoneMgrNorthSerice zoneMgrNorthSerice = ZoneReferUtil.getZoneMgrNorthSerice();
            List<FilterDeviceZoneStatusForm> filterDeviceZoneStatusFormList = zoneMgrNorthSerice.getByFilterId(this.filterId);
            HashSet<Long> zoneIdExistSet = new HashSet<Long>();
            IFilterDeviceZoneStatusService filterDeviceZoneStatusService = ZoneReferUtil.getFilterDeviceZoneStatusService();
            for (FilterDeviceZoneForm filterDeviceZoneForm : filterDeviceZoneForms) {
                Long zoneId = filterDeviceZoneForm.getZoneId();
                zoneIdExistSet.add(zoneId);
            }
            HashMap<String, Boolean> filterDeviceZoneStatusFormMap = new HashMap<String, Boolean>();
            for (FilterDeviceZoneStatusForm filterDeviceZoneStatusForm : filterDeviceZoneStatusFormList) {
                StringBuilder filterDeviceZoneStatus = new StringBuilder("");
                filterDeviceZoneStatus.append(filterDeviceZoneStatusForm.getFilterId()).append(filterDeviceZoneStatusForm.getZoneId()).append(filterDeviceZoneStatusForm.getDeviceId());
                filterDeviceZoneStatusFormMap.put(filterDeviceZoneStatus.toString(), filterDeviceZoneStatusForm.getDeployState());
            }
            if (this.aticDeviceService != null && currentUser != null) {
                List list = this.aticDeviceService.getAllDevice(currentUser.getUserID(), "true".equalsIgnoreCase(currentUser.getIsAdmin()));
                List<ZonePolicyApplyForm> zonePolicyApplyFormList = zonePolicyApplyService.queryRelationZoneByZoneId(zoneIdExistSet);
                for (ZonePolicyApplyForm zonePolicyApplyForm : zonePolicyApplyFormList) {
                    String deviceNames = this.queryDeviceNames(filterDeviceZoneStatusFormMap, zonePolicyApplyForm, list, filterDeviceZoneStatusService);
                    zonePolicyApplyForm.setDeviceNames(deviceNames);
                    this.zonePolicyFormList.add(zonePolicyApplyForm);
                    this.getZoneIdAndUnDeployNumber(zonePolicyApplyForm);
                }
                this.setSessionZoneIp(this.zonePolicyFormList);
            }
        } else {
            List<ZonePolicyApplyForm> sessionList = this.getSessionZoneIp();
            if (sessionList == null) {
                sessionList = new ArrayList<ZonePolicyApplyForm>();
            }
            this.addSessionZondId(sessionList);
            this.deleteSessionZondId(sessionList);
            for (ZonePolicyApplyForm zonePolicyApplyForm : sessionList) {
                this.getZoneIdAndUnDeployNumber(zonePolicyApplyForm);
                if (null != this.zoneName && !AticUtil.isNull((String)this.zoneName)) {
                    if (!zonePolicyApplyForm.getZoneDesc().toLowerCase(Locale.US).contains(this.zoneName.toLowerCase(Locale.US))) continue;
                    this.zonePolicyFormList.add(zonePolicyApplyForm);
                    continue;
                }
                this.zonePolicyFormList.add(zonePolicyApplyForm);
            }
        }
        this.setTotal(this.zonePolicyFormList.size());
        this.zonePolicyFormList = this.getAttackTypePageData(this.zonePolicyFormList, this.getStart(), this.getPageSize());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneName", (Object)this.zoneName);
        this.getSession().setAttribute("filterZoneIds", (Object)this.filterZoneIds);
        this.getSession().setAttribute("unDeployNumber", (Object)this.unDeployNumber);
        return "success";
    }

    private void getZoneIdAndUnDeployNumber(ZonePolicyApplyForm zonePolicyApplyForm) {
        this.filterZoneIds = this.filterZoneIds + zonePolicyApplyForm.getZoneId() + ",";
        String[] deviceName = zonePolicyApplyForm.getDeviceNames().split(";");
        for (int i = 0; i < deviceName.length; ++i) {
            if (!deviceName[i].contains("N")) continue;
            ++this.unDeployNumber;
        }
    }

    private void deleteSessionZondId(List<ZonePolicyApplyForm> sessionList) {
        if (null != this.delCacheZoneIds && !this.delCacheZoneIds.isEmpty()) {
            String[] delCacheZoneIdStr = this.delCacheZoneIds.split(",");
            for (int i = 0; i < delCacheZoneIdStr.length; ++i) {
                if (null == delCacheZoneIdStr[i] || delCacheZoneIdStr[i].isEmpty()) continue;
                Long deleteZondId = Long.parseLong(delCacheZoneIdStr[i]);
                Iterator<ZonePolicyApplyForm> it = sessionList.iterator();
                while (it.hasNext()) {
                    Long tmp = it.next().getZoneId();
                    if (!tmp.equals(deleteZondId)) continue;
                    it.remove();
                }
            }
        }
    }

    private void addSessionZondId(List<ZonePolicyApplyForm> sessionList) {
        if (null != this.cacheZonePolicyForms) {
            for (int i = 0; i < this.cacheZonePolicyForms.length; ++i) {
                if (null == this.cacheZonePolicyForms[i] || this.cacheZonePolicyForms[i].isEmpty()) continue;
                String[] cacheZonePolicyFormList = this.cacheZonePolicyForms[i].split(",");
                for (int j = 0; j < cacheZonePolicyFormList.length; ++j) {
                    String[] cacheZonePolicyForm = cacheZonePolicyFormList[j].split(";");
                    long cacheZoneId = Long.parseLong(cacheZonePolicyForm[0]);
                    boolean isExit = false;
                    for (ZonePolicyApplyForm from : sessionList) {
                        if (from.getZoneId() != cacheZoneId) continue;
                        isExit = true;
                        break;
                    }
                    if (isExit) continue;
                    ZonePolicyApplyForm form = new ZonePolicyApplyForm();
                    form.setZoneId(cacheZoneId);
                    form.setZoneDesc(cacheZonePolicyForm[1]);
                    StringBuilder deviceNames = new StringBuilder();
                    for (int k = 2; k < cacheZonePolicyForm.length; ++k) {
                        deviceNames.append(cacheZonePolicyForm[k]).append(";");
                    }
                    form.setDeviceNames(deviceNames.toString());
                    sessionList.add(form);
                }
            }
            this.setSessionZoneIp(sessionList);
        }
    }

    private List<ZonePolicyApplyForm> getAttackTypePageData(List<ZonePolicyApplyForm> allData, int start, int pageSize) {
        int endIndex;
        if (start == 0 && pageSize == 0) {
            return allData;
        }
        ArrayList<ZonePolicyApplyForm> list = new ArrayList<ZonePolicyApplyForm>();
        int startIndex = start;
        if (startIndex < 0 || startIndex >= allData.size()) {
            startIndex = allData.size() - 1;
        }
        if ((endIndex = start + pageSize) < 0 || endIndex >= allData.size()) {
            endIndex = allData.size();
        }
        if (allData.isEmpty()) {
            return list;
        }
        list.addAll(allData.subList(startIndex, endIndex));
        return list;
    }

    private List<ZonePolicyApplyForm> getSessionZoneIp() {
        String sessionId = this.getSession().getId();
        return (List)this.getSession().getAttribute(SESSION_ZONE_IP + sessionId);
    }

    private void setSessionZoneIp(List<ZonePolicyApplyForm> list) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute(SESSION_ZONE_IP + sessionId, list);
    }

    private String queryDeviceNames(Map<String, Boolean> filterDeviceZoneStatusFormMap, ZonePolicyApplyForm zonePolicyForm, List<AticDevice> securityNEList, IFilterDeviceZoneStatusService filterDeviceZoneStatusService) {
        List<ZoneDeviceForm> zoneDevices = zonePolicyForm.getZoneDeviceForms();
        StringBuffer deviceNameBuffer = new StringBuffer();
        ICommonUtilService commonUtilService = ZoneReferUtil.getCommonUtilService();
        IClusterService clusterService = ZoneReferUtil.getClusterService();
        for (ZoneDeviceForm zoneDeviceForm : zoneDevices) {
            AticDevice securityNE = ZoneReferUtil.getDevice(zoneDeviceForm.getDeviceId());
            if (null == securityNE || securityNEList.isEmpty() || !this.belongs(securityNE, securityNEList)) continue;
            int deviceType = securityNE.getDeviceType();
            String ipAddress = securityNE.getIpAddress();
            String deviceName = securityNE.getName();
            if ("4".equals(commonUtilService.getDDoSVersion(ipAddress)) || deviceType == 8 || deviceType == 9) {
                boolean isDeploy = this.isDeploy(filterDeviceZoneStatusFormMap, filterDeviceZoneStatusService, clusterService, securityNE, zoneDeviceForm);
                if (isDeploy) {
                    deviceNameBuffer.append(deviceName + "Y;");
                    continue;
                }
                deviceNameBuffer.append(deviceName + "N;");
                ++this.unDeployNumber;
                continue;
            }
            deviceNameBuffer.append(deviceName + "X;");
        }
        if (deviceNameBuffer.toString().endsWith(";")) {
            deviceNameBuffer.deleteCharAt(deviceNameBuffer.lastIndexOf(";"));
        }
        return deviceNameBuffer.toString();
    }

    private boolean isDeploy(Map<String, Boolean> filterDeviceZoneStatusFormMap, IFilterDeviceZoneStatusService filterDeviceZoneStatusService, IClusterService clusterService, AticDevice securityNE, ZoneDeviceForm zoneDeviceForm) {
        int deviceType = securityNE.getDeviceType();
        long moId = securityNE.getMoId();
        boolean isDeploy = false;
        if (deviceType == 9) {
            List aticDeviceNfaClusters = clusterService.getBindNfaDevice(Long.valueOf(moId));
            boolean isAllDeploy = this.isAllDeploy(filterDeviceZoneStatusService, zoneDeviceForm.getZoneId(), aticDeviceNfaClusters);
            if (isAllDeploy) {
                isDeploy = true;
            }
        } else {
            StringBuilder filterDeviceZoneStatus = new StringBuilder("");
            if (null != this.filterId) {
                filterDeviceZoneStatus.append(this.filterId).append(zoneDeviceForm.getZoneId()).append(zoneDeviceForm.getDeviceId());
                if (filterDeviceZoneStatusFormMap.containsKey(filterDeviceZoneStatus.toString()) && filterDeviceZoneStatusFormMap.get(filterDeviceZoneStatus.toString()).booleanValue()) {
                    isDeploy = true;
                }
            }
        }
        return isDeploy;
    }

    private boolean isAllDeploy(IFilterDeviceZoneStatusService filterDeviceZoneStatusService, Long zoneID, List<AticDeviceNfaCluster> aticDeviceNfaClusters) {
        boolean isAllDeploy = true;
        for (AticDeviceNfaCluster aticDeviceNfaCluster : aticDeviceNfaClusters) {
            List<FilterDeviceZoneStatusForm> filterDeviceZoneStatusForms = filterDeviceZoneStatusService.getInfosByFilterIdAndDeviceIdAndZoneId(this.filterId, aticDeviceNfaCluster.getDeviceId(), zoneID);
            if (filterDeviceZoneStatusForms.isEmpty()) {
                isAllDeploy = false;
                break;
            }
            for (FilterDeviceZoneStatusForm filterDeviceZoneStatusForm : filterDeviceZoneStatusForms) {
                if (filterDeviceZoneStatusForm.getDeployState().booleanValue()) continue;
                isAllDeploy = false;
                break;
            }
            if (isAllDeploy) continue;
            break;
        }
        return isAllDeploy;
    }

    private boolean belongs(AticDevice securityNE, List<AticDevice> securityNEList) {
        boolean result = false;
        for (AticDevice item : securityNEList) {
            if (securityNE.getMoId() != item.getMoId()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean validateDeviceIdList() {
        if (null == this.deviceIdList) {
            return false;
        }
        if ("".equals(this.deviceIdList)) {
            return true;
        }
        String[] id = this.deviceIdList.split(",");
        if (id.length > 100) {
            return false;
        }
        for (int i = 0; i < id.length; ++i) {
            long deviceIdTemp = 0L;
            try {
                deviceIdTemp = Long.parseLong(id[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (deviceIdTemp >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateCacheZonePolicyForms() {
        if (null == this.cacheZonePolicyForms) {
            return true;
        }
        if (this.cacheZonePolicyForms.length > 100) {
            return false;
        }
        for (String item : this.cacheZonePolicyForms) {
            boolean res = item.matches("^(?!null$)[\\w|\\u4e00-\\u9fa5|\\-|!|@|#|$|^|.|+|}|{|;|,]*$");
            if (res) continue;
            return false;
        }
        return true;
    }

    public boolean validateDelCacheZoneIds() {
        String[] vDelCacheZoneIds;
        return null == this.delCacheZoneIds || this.delCacheZoneIds.isEmpty() || (vDelCacheZoneIds = this.delCacheZoneIds.split(",")).length <= 100;
    }

    public String getDeviceIdList() {
        return this.deviceIdList;
    }

    public void setDeviceIdList(String deviceIdList) {
        this.deviceIdList = deviceIdList;
    }

    public String getNeName() {
        return this.neName;
    }

    public void setNeName(String neName) {
        this.neName = neName;
    }

    public List<AticDevice> getDeviceList() {
        return this.deviceList;
    }

    public void setDeviceList(List<AticDevice> deviceList) {
        this.deviceList = deviceList;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public List<ZoneInfoForm> getZoneInfoList() {
        return this.zoneInfoList;
    }

    public void setZoneInfoList(List<ZoneInfoForm> zoneInfoList) {
        this.zoneInfoList = zoneInfoList;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public List<ZonePolicyApplyForm> getZonePolicyFormList() {
        return this.zonePolicyFormList;
    }

    public void setZonePolicyFormList(List<ZonePolicyApplyForm> zonePolicyFormList) {
        this.zonePolicyFormList = zonePolicyFormList;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public void setFilterId(Long filterId) {
        this.filterId = filterId;
    }

    public String[] getCacheZonePolicyForms() {
        if (null != this.cacheZonePolicyForms) {
            return (String[])this.cacheZonePolicyForms.clone();
        }
        return new String[0];
    }

    public void setCacheZonePolicyForms(String[] cacheZonePolicyForms) {
        this.cacheZonePolicyForms = null != cacheZonePolicyForms ? (String[])cacheZonePolicyForms.clone() : null;
    }

    public String getDelCacheZoneIds() {
        return this.delCacheZoneIds;
    }

    public void setDelCacheZoneIds(String delCacheZoneIds) {
        this.delCacheZoneIds = delCacheZoneIds;
    }

    public String getIsClearSession() {
        return this.isClearSession;
    }

    public void setIsClearSession(String isClearSession) {
        this.isClearSession = isClearSession;
    }

    public String getFilterZoneIds() {
        return this.filterZoneIds;
    }

    public void setFilterZoneIds(String filterZoneIds) {
        this.filterZoneIds = filterZoneIds;
    }

    public int getUnDeployNumber() {
        return this.unDeployNumber;
    }

    public void setUnDeployNumber(int unDeployNumber) {
        this.unDeployNumber = unDeployNumber;
    }
}

