/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaClusterDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SaveFilterFormAction
extends BaseAction {
    private static final String SESSION_FILTER_KEY = "filterKeyList";
    private static final long serialVersionUID = -941046514255545767L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private FilterForm filterForm;
    private String httpFilterContentsStr;
    private String deviceType;
    private Integer filterAction;
    private Integer filterIdValue;
    private Integer httpFilterAlert;
    private String zoneIds;
    private Long filterId;
    private String progressUrl;
    private boolean isDeploy;
    private String deleteFilterNames;
    private String deleteFilterIds;
    private String deleteZoneIds;
    private String deviceIds;
    private String deleteDeviceIds;
    private boolean isGlobalApplyFilter;

    public void checkFilterNameExist() {
        IFilterService service = ZoneReferUtil.getFilterService();
        if (null != this.filterForm && null != this.filterForm.getPkid() && null != this.filterForm.getFilterName()) {
            ArrayList<Long> filterIds2Check = new ArrayList<Long>();
            filterIds2Check.add(this.filterForm.getPkid());
            ZoneBisUtil.checkUserSecurity("Filter", filterIds2Check);
            if (service.filterNameExsit(this.filterForm.getPkid(), this.filterForm.getFilterName()).booleanValue()) {
                this.responseResult("yes");
            } else {
                logger.info((Object)"Filter name is not duplicate.");
                this.responseResult("no");
            }
        } else {
            logger.error((Object)"FilterForm(id or filter_name) is null.");
            this.responseResult("error");
        }
    }

    public boolean checkFilterCount() {
        IFilterService service = ZoneReferUtil.getFilterService();
        HashMap map = new HashMap();
        Paging page = service.queryByPage(map, this.start, this.pageSize);
        this.total = page.getCount();
        if (this.total >= 10000 && null == this.filterForm.getPkid()) {
            this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.policy.filter.max.num", null);
            return false;
        }
        return true;
    }

    public void checkFilterNumberLimit() {
        IFilterService service = ZoneReferUtil.getFilterService();
        this.dealHttpFilterContent();
        if (StringUtils.isNotEmpty((CharSequence)this.deviceIds)) {
            String[] deviceIdStr = this.deviceIds.split(",");
            ArrayList<Long> deviceIdList = new ArrayList<Long>();
            for (int i = 0; i < deviceIdStr.length; ++i) {
                if (null == deviceIdStr[i] || deviceIdStr[i].isEmpty()) continue;
                deviceIdList.add(Long.valueOf(deviceIdStr[i]));
            }
            BisUtil.checkUserSecurity(deviceIdList);
            this.filterForm.setDeviceIdList(deviceIdList);
            Long deviceId = service.checkFilterNumberLimitByDevice(this.filterForm);
            if (deviceId != null) {
                AticDevice ne = ZoneReferUtil.getDevice(deviceId);
                this.responseResult(MessageFormat.format(this.getText("com.hs.vsm.secservice.ddos.filter.device.limite.over"), ne.getName()));
            }
        }
    }

    private boolean checkFingerPrint(String content) {
        String contentNospace;
        String[] fingers = content.split("        ");
        return fingers.length <= 3 || (contentNospace = content.replace(" ", "")).length() <= 403;
    }

    private String checkFingerPrintList(List<HttpFilterForm> fromList) {
        if (null != fromList && !fromList.isEmpty()) {
            HttpFilterForm currForm = null;
            for (int i = 0; i < fromList.size(); ++i) {
                currForm = fromList.get(i);
                if (!"fingerprint".equals(currForm.getFilterKey()) || this.checkFingerPrint(currForm.getFilterContent())) continue;
                return "fingerFourOver";
            }
        }
        return "";
    }

    public void saveFilterForm() {
        try {
            IFilterService service = ZoneReferUtil.getFilterService();
            this.dealHttpFilterContent();
            String checkResult = this.checkFingerPrintList(this.filterForm.getHttpFilterFormList());
            if (!"".equals(checkResult)) {
                logger.error((Object)"The device supports a maximum of 510 characters. When four fingerprints are combined, the total number of characters entered by the user does not exceed 403.");
                this.responseResult(checkResult);
                return;
            }
            this.filterForm.setDeviceType(this.deviceType);
            this.filterForm.setFilterAction(this.filterAction);
            if (this.filterAction.equals(5) || this.filterAction.equals(7)) {
                this.filterForm.setFilterAlert(this.httpFilterAlert);
            }
            this.filterForm.setFilterId(this.filterIdValue);
            this.filterForm.setDirection(1);
            ArrayList<Long> deviceIdList = new ArrayList<Long>();
            if (StringUtils.isNotEmpty((CharSequence)this.deviceIds)) {
                String[] deviceIdStr = this.deviceIds.split(",");
                for (int i = 0; i < deviceIdStr.length; ++i) {
                    if (null == deviceIdStr[i] || deviceIdStr[i].isEmpty()) continue;
                    deviceIdList.add(Long.valueOf(deviceIdStr[i]));
                }
                BisUtil.checkUserSecurity(deviceIdList);
            }
            this.filterForm.setDeviceIdList(deviceIdList);
            if (!this.checkFilterCount()) {
                this.responseResult("574001");
                return;
            }
            if (null != this.filterForm.getPkid()) {
                this.fillFilterId(this.filterForm.getPkid());
                StringBuffer deleteDeviceIdBuffer = new StringBuffer();
                FilterForm oldFilterForm = (FilterForm)service.query(this.filterForm.getPkid());
                oldFilterForm.setDirection(1);
                this.optModifyFilter(this.filterForm, oldFilterForm);
                for (Long oldDeviceId : oldFilterForm.getDeviceIdList()) {
                    if (this.filterForm.getDeviceIdList().contains(oldDeviceId)) continue;
                    deleteDeviceIdBuffer.append(oldDeviceId);
                    deleteDeviceIdBuffer.append(',');
                }
                this.filterForm.setDeviceType(oldFilterForm.getDeviceType());
                this.filterForm.setFilterType(oldFilterForm.getFilterType());
                this.filterForm.setFilterName(oldFilterForm.getFilterName());
                this.filterForm.setGlobalFilterConfig(true);
                this.filterForm.setEditGloFilter(false);
                this.filterForm.setDeployApply(false);
                if (null == this.filterForm.getFilterMode()) {
                    this.filterForm.setFilterMode(1);
                }
                service.update(this.filterForm);
                String deleteDeviceIdsStr = deleteDeviceIdBuffer.toString().trim();
                if (deleteDeviceIdsStr.length() > 0) {
                    deleteDeviceIdsStr = deleteDeviceIdsStr.substring(0, deleteDeviceIdsStr.length() - 1);
                }
                this.responseResult(this.filterForm.getPkid() + ";" + this.htmlEncodeCore(deleteDeviceIdsStr));
            } else {
                if (service.filterNameExsit(this.filterForm.getPkid(), this.filterForm.getFilterName()).booleanValue()) {
                    throw new LegoCheckedException(631048L);
                }
                this.filterForm.setGlobalFilterConfig(true);
                this.filterForm.setEditGloFilter(true);
                this.filterForm.setDeployApply(false);
                this.filterForm.setFilterMode(1);
                Long pkid = (Long)service.create(this.filterForm);
                this.filterForm.setPkid(pkid);
                this.optCreateFilter(this.filterForm);
                this.responseResult(String.valueOf(this.filterForm.getPkid()));
            }
        }
        catch (LegoCheckedException e) {
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.create.filter", "lego.dic.module.ddosApp", false, null, "com.hs.vsm.secservice.ddos.policy.operation.detail.name.create.filter", this.filterForm.getFilterName(), SysoplogLevel.info.getValue(), false, (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.create.filter", "lego.dic.module.ddosApp", false, null, "com.hs.vsm.secservice.ddos.policy.operation.detail.name.create.filter", this.filterForm.getFilterName(), SysoplogLevel.info.getValue(), false, e);
            throw new LegoUncheckedException((Throwable)e);
        }
    }

    public void saveFilterForZone() {
        ArrayList<Long> filterIds2Check = new ArrayList<Long>();
        filterIds2Check.add(this.filterId);
        ZoneBisUtil.checkUserSecurity("Filter", filterIds2Check);
        IFilterService service = ZoneReferUtil.getFilterService();
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        String[] zoneIdStr = this.zoneIds.split(",");
        for (int i = 0; i < zoneIdStr.length; ++i) {
            if (null == zoneIdStr[i] || zoneIdStr[i].isEmpty()) continue;
            zoneIdList.add(Long.valueOf(zoneIdStr[i]));
        }
        ZoneBisUtil.checkUserSecurity("ZoneInfo", zoneIdList);
        this.filterForm = new FilterForm();
        this.filterForm.setZoneIdList(zoneIdList);
        FilterForm exitFilterForm = (FilterForm)service.query(this.filterId);
        String checkResult = this.checkFingerPrintList(exitFilterForm.getHttpFilterFormList());
        if (!"".equals(checkResult)) {
            logger.error((Object)"The device supports a maximum of 510 characters. When four fingerprints are combined, the total number of characters entered by the user does not exceed 403.");
            this.responseResult(checkResult);
            return;
        }
        exitFilterForm.setDirection(1);
        StringBuffer deleteZoneIdBuffer = new StringBuffer();
        for (Long oldZoneId : exitFilterForm.getZoneIdList()) {
            if (this.filterForm.getZoneIdList().contains(oldZoneId)) continue;
            deleteZoneIdBuffer.append(oldZoneId);
            deleteZoneIdBuffer.append(',');
        }
        exitFilterForm.setDeviceType(this.deviceType);
        exitFilterForm.setGlobalFilterConfig(false);
        exitFilterForm.setEditGloFilter(false);
        exitFilterForm.setDeployApply(false);
        exitFilterForm.setDirection(1);
        exitFilterForm.setPkid(this.filterId);
        exitFilterForm.setZoneIdList(zoneIdList);
        service.saveFilterZone(exitFilterForm);
        String deleteZoneIdsStr = deleteZoneIdBuffer.toString().trim();
        this.responseResult(deleteZoneIdsStr);
    }

    private void optCreateFilter(FilterForm filterForms) {
        String[] pars = new String[]{filterForms.getFilterName(), filterForms.getFilterType()};
        this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.create.filter", "lego.dic.module.ddosApp", false, pars, "com.hs.vsm.secservice.ddos.policy.operation.detail.name.create.filter", filterForms.getFilterName(), SysoplogLevel.info.getValue(), true, null);
    }

    private void optModifyFilter(FilterForm filterForms, FilterForm oldFilterForm) {
        if (!filterForms.getCalcCrcString().equals(oldFilterForm.getCalcCrcString())) {
            String[] pars = new String[]{filterForms.getFilterName(), filterForms.getFilterType()};
            this.updateFilterDefineState(oldFilterForm);
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.modify.filter", "lego.dic.module.ddosApp", false, pars, "com.hs.vsm.secservice.ddos.policy.operation.detail.name.modify.filter", filterForms.getFilterName(), SysoplogLevel.info.getValue(), true, null);
        }
    }

    private void updateFilterDefineState(FilterForm oldFilterForm) {
        Long filId = oldFilterForm.getPkid();
        IFilterDeviceZoneInfoService filterDeviceZoneInfoService = ZoneReferUtil.getFilterDeviceZoneInfoService();
        IFilterDeviceZoneStatusService filterDeviceZoneStatusService = ZoneReferUtil.getFilterDeviceZoneStatusService();
        List<FilterDeviceZoneForm> filterDeviceZoneForms = filterDeviceZoneInfoService.getByFilterId(filId);
        for (FilterDeviceZoneForm filterDeviceZoneForm : filterDeviceZoneForms) {
            Long zoneId = filterDeviceZoneForm.getZoneId();
            Long deviceId = filterDeviceZoneForm.getDeviceId();
            filterDeviceZoneStatusService.updateFilterDefineState(filId, deviceId, zoneId);
            if (zoneId != 0L) continue;
            filterDeviceZoneInfoService.updateGloFilterDefineDeployState(filId, deviceId, zoneId);
        }
    }

    private void optDeployFilter(FilterForm filterForms, boolean isDeploySuccess, String detail, String[] detailPara) {
        SysOptLog sysOptLog = new SysOptLog();
        sysOptLog.setOperation("com.hs.vsm.secservice.ddos.policy.operation.name.deploy.filter");
        sysOptLog.setModule("lego.dic.module.ddosApp");
        sysOptLog.setLevel(SysoplogLevel.normal.getValue());
        sysOptLog.setResult(isDeploySuccess ? 1 : 0);
        sysOptLog.setTarget(filterForms.getFilterName());
        sysOptLog.setDetail(detail);
        sysOptLog.setDetailPara(detailPara);
        User user = (User)this.getSession().getAttribute("currentUser");
        sysOptLog.setOperator(user.getUserName());
        sysOptLog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        sysOptLog.setDate(new Date());
        ISysOptLog service = ZoneReferUtil.getSysOptLog();
        service.writeOptLog(sysOptLog);
    }

    private boolean checkZoneList(Set<Long> zoneSet) {
        return null != zoneSet && zoneSet.isEmpty();
    }

    private void dealHttpFilterContent() {
        List<HttpFilterForm> httpFilterFormList = this.getSessionFilterKey();
        this.filterForm.setHttpFilterFormList(httpFilterFormList);
    }

    private void fillFilterId(Long filterID) {
        List<HttpFilterForm> httpFilterFormList = this.getSessionFilterKey();
        for (HttpFilterForm tmp : httpFilterFormList) {
            tmp.setFilterId(filterID);
        }
        this.setSessionFilterKey(httpFilterFormList);
    }

    private List<HttpFilterForm> getSessionFilterKey() {
        String sessionId = this.getSession().getId();
        return (List)this.getSession().getAttribute(SESSION_FILTER_KEY + sessionId);
    }

    private void setSessionFilterKey(List<HttpFilterForm> list) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute(SESSION_FILTER_KEY + sessionId, list);
    }

    public void deployFilterProgress() {
        StringBuffer errorMsgKey;
        IFilterService service = ZoneReferUtil.getFilterService();
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        IAticDeviceService deviceService = ZoneReferUtil.getFirewallService();
        IHttpFilterService httpFilterService = ZoneReferUtil.getHttpFilterService();
        IFilterDeviceZoneInfoService filterDeviceZoneInfoService = ZoneReferUtil.getFilterDeviceZoneInfoService();
        IZoneMgrNorthSerice zoneMgrNorthSerice = ZoneReferUtil.getZoneMgrNorthSerice();
        this.filterForm = (FilterForm)service.query(this.filterId);
        String filterType = this.filterForm.getFilterType();
        List<HttpFilterForm> httpFilterForms = httpFilterService.queryByFilterId(this.filterForm.getPkid());
        List<FilterDeviceZoneForm> filterDeviceZoneForms = filterDeviceZoneInfoService.getByFilterId(this.filterForm.getPkid(), 1);
        int number = 0;
        String filterKey = "";
        if (null != httpFilterForms && !httpFilterForms.isEmpty()) {
            number = httpFilterForms.size();
            Iterator<HttpFilterForm> iterator = httpFilterForms.iterator();
            if (iterator.hasNext()) {
                HttpFilterForm filter = iterator.next();
                filterKey = filter.getFilterKey();
            }
        }
        StringBuffer sBuffer = new StringBuffer();
        ArrayList<Long> devicIds = new ArrayList<Long>();
        for (FilterDeviceZoneForm filterDeviceZoneForm : filterDeviceZoneForms) {
            Long deviceId = filterDeviceZoneForm.getDeviceId();
            AticDevice aticDevice = deviceService.getDeviceByMoid(deviceId.longValue());
            if (null == aticDevice) continue;
            if (aticDevice.getVersion().contains("SPC500")) {
                if ("SIP".equalsIgnoreCase(filterType)) {
                    if ("callee".equalsIgnoreCase(filterKey) && number > 128) {
                        this.responseResult(this.getText("lego.err.631051"));
                        this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.filter.deploy.failed", null);
                        return;
                    }
                    if ("caller".equalsIgnoreCase(filterKey) && number > 128) {
                        this.responseResult(this.getText("lego.err.631052"));
                        this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.filter.deploy.failed", null);
                        return;
                    }
                }
                if ("DNS".equalsIgnoreCase(filterType) && "domain".equalsIgnoreCase(filterKey) && number > 128) {
                    this.responseResult(this.getText("lego.err.631053"));
                    this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.filter.deploy.failed", null);
                    return;
                }
                if ("HTTP".equalsIgnoreCase(filterType)) {
                    this.validateHttp(filterKey, number);
                }
            }
            if (devicIds.contains(deviceId)) continue;
            sBuffer.append(aticDevice.getName());
            sBuffer.append(",");
            devicIds.add(deviceId);
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Long adminId = currentUser.getUserID();
        Map<Long, Set<Long>> resultMap = null;
        ArrayList<Long> deleteDeviceIdList = new ArrayList<Long>();
        if (null != this.deleteDeviceIds && !"".equals(this.deleteDeviceIds)) {
            String[] deviceIdArray;
            for (String deviceId : deviceIdArray = this.deleteDeviceIds.split(",")) {
                deleteDeviceIdList.add(Long.parseLong(deviceId));
            }
        }
        ArrayList<Long> moIdList = new ArrayList<Long>(devicIds);
        moIdList.addAll(deleteDeviceIdList);
        BisUtil.checkUserSecurity(moIdList);
        resultMap = zoneMgrNorthSerice.doDeployWithFilter(this.filterForm.getPkid(), null, null, adminId, deleteDeviceIdList, this.isGlobalApplyFilter);
        IFilterDeviceZoneStatusService filterDeviceService = ZoneReferUtil.getFilterDeviceZoneStatusService();
        FilterDeviceZoneStatusInfo filterInfo = filterDeviceService.getFilterDeviceZoneStatusInfo(this.filterForm.getPkid());
        String errorCode = null;
        if (null != filterInfo) {
            errorCode = filterInfo.getErrorCode();
        }
        if ("lego.err.630005".equals(errorCode)) {
            errorMsgKey = new StringBuffer();
            errorMsgKey.append(this.getText("lego.err.630005"));
            errorMsgKey.append(this.getText("lego.lab.res.devname"));
            errorMsgKey.append(this.getText("com.hs.vsm.secservice.ddos.global.filter.colon"));
            errorMsgKey.append(deviceService.getDeviceByMoid(filterInfo.getDeviceId().longValue()).getName());
            this.responseResult(errorMsgKey.toString());
            String[] filterParam = new String[]{sBuffer.substring(0, sBuffer.length() - 1), "lego.err.631066"};
            this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.deployfail", filterParam);
            return;
        }
        if ("lego.err.631065".equals(errorCode)) {
            errorMsgKey = new StringBuffer();
            errorMsgKey.append(this.getText("lego.err.631066"));
            errorMsgKey.append(this.getText("lego.lab.res.devname"));
            errorMsgKey.append(this.getText("com.hs.vsm.secservice.ddos.global.filter.colon"));
            errorMsgKey.append(deviceService.getDeviceByMoid(filterInfo.getDeviceId().longValue()).getName());
            errorMsgKey.append(this.getText("com.hs.vsm.secservice.ddos.global.filter.comma"));
            errorMsgKey.append(this.getText("com.hs.vsm.secservice.ddos.global.filter.id"));
            errorMsgKey.append(this.filterForm.getFilterId());
            this.responseResult(errorMsgKey.toString());
            String[] filterParam = new String[]{sBuffer.substring(0, sBuffer.length() - 1), "lego.err.631066"};
            this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.deployfail", filterParam);
            return;
        }
        if ("lego.err.631044".equals(errorCode)) {
            errorMsgKey = new StringBuffer();
            errorMsgKey.append(this.getText("lego.err.631044"));
            errorMsgKey.append(this.getText("com.hs.vsm.secservice.ddos.global.filter.preference"));
            errorMsgKey.append(filterInfo.getFilterPreference());
            this.responseResult(errorMsgKey.toString());
            String[] filterParam = new String[]{sBuffer.substring(0, sBuffer.length() - 1), "lego.err.631066"};
            this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.deployfail", filterParam);
            return;
        }
        if (errorCode != null && errorCode.contains("lego.err")) {
            List<ZoneDeviceDeployStatusForm> deployFailedForms = ZoneReferUtil.getDeviceDeployStatus(filterInfo.getZoneId());
            for (ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm : deployFailedForms) {
                String errorParam = zoneDeviceDeployStatusForm.getErrorParam();
                String errorKey = zoneDeviceDeployStatusForm.getErrorMsgKey();
                if (zoneDeviceDeployStatusForm.getDeviceId().longValue() != filterInfo.getDeviceId().longValue() || null != errorParam && ("".equals(errorKey) || "--".equals(errorKey)) || null == errorParam || null == errorKey) continue;
                this.responseResult(this.getText(errorKey).replaceFirst("\\$0", errorParam));
                this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.filter.deploy.failed", null);
                return;
            }
            this.responseResult(this.getText(errorCode));
            this.optDeployFilter(this.filterForm, false, "com.hs.vsm.secservice.ddos.filter.deploy.failed", null);
            return;
        }
        StringBuffer result = new StringBuffer();
        IAticDeviceService neService = ZoneReferUtil.getFirewallService();
        String detail = null;
        String[] detailPara = null;
        if (null != resultMap && !resultMap.isEmpty()) {
            for (Map.Entry<Long, Set<Long>> entry : resultMap.entrySet()) {
                Set<Long> zoneSet = entry.getValue();
                if (null == zoneSet) continue;
                if (this.checkZoneList(zoneSet)) {
                    result.append(this.getText("com.hs.vsm.secservice.ddos.filter.deploy.failed1").replace("{0}", this.htmlEncodeCore(neService.getDeviceByMoid(entry.getKey().longValue()).getName())) + "<br>");
                    detail = "com.hs.vsm.secservice.ddos.filter.deploy.failed1";
                    detailPara = new String[]{neService.getDeviceByMoid(entry.getKey().longValue()).getName()};
                    this.optDeployFilter(this.filterForm, false, detail, detailPara);
                    this.responseResult(result.toString());
                    continue;
                }
                StringBuffer zoneNames = new StringBuffer();
                for (Long zoneId : entry.getValue()) {
                    String zoneDesc = "";
                    if (zoneId == 0L) {
                        this.responseResult("success");
                        return;
                    }
                    zoneDesc = zoneService.getById(zoneId).getZoneDesc();
                    zoneNames.append(zoneDesc);
                    zoneNames.append(',');
                }
                String zoneNameResult = "";
                if (zoneNames.length() > 0) {
                    zoneNameResult = zoneNames.substring(0, zoneNames.length() - 1);
                }
                result.append(this.getText("com.hs.vsm.secservice.ddos.filter.deploy.failed2").replace("{0}", this.htmlEncodeCore(neService.getDeviceByMoid(entry.getKey().longValue()).getName())).replace("{1}", this.htmlEncodeCore(zoneNameResult)) + "<br>");
                detail = "com.hs.vsm.secservice.ddos.filter.deploy.failed2";
                detailPara = new String[]{neService.getDeviceByMoid(entry.getKey().longValue()).getName(), zoneNameResult};
                this.optDeployFilter(this.filterForm, false, detail, detailPara);
                this.responseResult(result.toString());
            }
            this.responseResult("success");
        } else {
            detail = "com.hs.vsm.secservice.ddos.policy.operation.detail.name.deploy.filter";
            detailPara = new String[]{this.filterForm.getFilterName(), this.filterForm.getFilterType()};
            this.optDeployFilter(this.filterForm, true, detail, detailPara);
            this.responseResult("success");
        }
    }

    private void validateHttp(String filterKey, int number) {
        if ("cookie".equalsIgnoreCase(filterKey) && number > 128) {
            this.responseResult(this.getText("lego.err.631054"));
            return;
        }
        if ("host".equalsIgnoreCase(filterKey) && number > 128) {
            this.responseResult(this.getText("lego.err.631055"));
            return;
        }
        if ("referer".equalsIgnoreCase(filterKey) && number > 128) {
            this.responseResult(this.getText("lego.err.631056"));
            return;
        }
        if ("uri".equalsIgnoreCase(filterKey) && number > 128) {
            this.responseResult(this.getText("lego.err.631057"));
            return;
        }
        if ("user-agent".equalsIgnoreCase(filterKey) && number > 128) {
            this.responseResult(this.getText("lego.err.631058"));
            return;
        }
    }

    public String startProgressbar() {
        if (!StringUtils.isEmpty((CharSequence)this.deleteFilterIds)) {
            ArrayList<Long> filterIds2Check = new ArrayList<Long>();
            String[] ids = this.deleteFilterIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                filterIds2Check.add(Long.parseLong(ids[i]));
            }
            ZoneBisUtil.checkUserSecurity("Filter", filterIds2Check);
        }
        return "success";
    }

    public String startProgressbarForDevice() {
        return "success";
    }

    public FilterForm getFilterForm() {
        return this.filterForm;
    }

    public void setFilterForm(FilterForm filterForm) {
        this.filterForm = filterForm;
    }

    public String getHttpFilterContentsStr() {
        return this.httpFilterContentsStr;
    }

    public void setHttpFilterContentsStr(String httpFilterContentsStr) {
        this.httpFilterContentsStr = httpFilterContentsStr;
    }

    public String getZoneIds() {
        return this.zoneIds;
    }

    public void setZoneIds(String zoneIds) {
        this.zoneIds = this.htmlEncodeCore(zoneIds);
    }

    public Integer getFilterAction() {
        return this.filterAction;
    }

    public void setFilterAction(Integer filterAction) {
        this.filterAction = filterAction;
    }

    public Integer getHttpFilterAlert() {
        return this.httpFilterAlert;
    }

    public void setHttpFilterAlert(Integer httpFilterAlert) {
        this.httpFilterAlert = httpFilterAlert;
    }

    public String getProgressUrl() {
        return this.progressUrl;
    }

    public void setProgressUrl(String progressUrl) {
        this.progressUrl = progressUrl;
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public void setFilterId(Long filterId) {
        this.filterId = filterId;
    }

    public String getDeleteFilterNames() {
        return this.deleteFilterNames;
    }

    public void setDeleteFilterNames(String deleteFilterNames) {
        this.deleteFilterNames = deleteFilterNames;
    }

    public String getDeleteFilterIds() {
        return this.deleteFilterIds;
    }

    public void setDeleteFilterIds(String deleteFilterIds) {
        this.deleteFilterIds = deleteFilterIds;
    }

    public Boolean getIsDeploy() {
        return this.isDeploy;
    }

    public void setIsDeploy(Boolean isDeploy) {
        this.isDeploy = isDeploy;
    }

    public String getDeleteZoneIds() {
        return this.deleteZoneIds;
    }

    public void setDeleteZoneIds(String deleteZoneIds) {
        this.deleteZoneIds = this.htmlEncodeCore(deleteZoneIds);
    }

    public Integer getFilterIdValue() {
        return this.filterIdValue;
    }

    public void setFilterIdValue(Integer filterIdValue) {
        this.filterIdValue = filterIdValue;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(String deviceIds) {
        this.deviceIds = deviceIds;
    }

    public String getDeleteDeviceIds() {
        return this.deleteDeviceIds;
    }

    public void setDeleteDeviceIds(String deleteDeviceIds) {
        this.deleteDeviceIds = deleteDeviceIds;
    }

    public Boolean getIsGlobalApplyFilter() {
        return this.isGlobalApplyFilter;
    }

    public void setIsGlobalApplyFilter(Boolean isGlobalApplyFilter) {
        this.isGlobalApplyFilter = isGlobalApplyFilter;
    }

    public boolean validateFilterFormPkid() {
        if (null == this.filterForm.getPkid()) {
            return true;
        }
        return this.filterForm.getPkid() > 0L;
    }

    public boolean validateFilterPkid() {
        if (null == this.filterId) {
            return true;
        }
        return this.filterId > 0L;
    }

    public boolean validateDeleteDeviceIds() {
        if (null == this.deleteDeviceIds || "".equals(this.deleteDeviceIds)) {
            return true;
        }
        String[] ids = this.deleteDeviceIds.split(",");
        if (ids.length > 100) {
            return false;
        }
        for (int i = 0; i < ids.length; ++i) {
            long id = 0L;
            try {
                id = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateZoneIds() {
        if (null == this.zoneIds || "".equals(this.zoneIds)) {
            return true;
        }
        String[] ids = this.zoneIds.split(",");
        if (ids.length > 10000) {
            return false;
        }
        for (int i = 0; i < ids.length; ++i) {
            long id = 0L;
            try {
                id = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeleteZoneIds() {
        if (null == this.deleteZoneIds || "".equals(this.deleteZoneIds)) {
            return true;
        }
        String[] ids = this.deleteZoneIds.split(",");
        if (ids.length > 10000) {
            return false;
        }
        for (int i = 0; i < ids.length; ++i) {
            long id = 0L;
            try {
                if (ids[i].equals("0")) {
                    return true;
                }
                id = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeleteFilterIds() {
        if (null == this.deleteFilterIds || "".equals(this.deleteFilterIds)) {
            return true;
        }
        String[] ids = this.deleteFilterIds.split(",");
        if (ids.length > 100) {
            return false;
        }
        for (int i = 0; i < ids.length; ++i) {
            long id = 0L;
            try {
                id = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeleteFilterNames() {
        if (null == this.deleteFilterNames || "".equals(this.deleteFilterNames)) {
            return true;
        }
        String[] names = this.deleteFilterNames.split(",");
        if (names.length > 100) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (AticUtil.isNull((String)names[i])) {
                return false;
            }
            if (names[i].trim().equalsIgnoreCase("null")) {
                return false;
            }
            String nameRegex = "^(?!\\s*null$)[\\w*]{1,63}$";
            if (names[i].matches(nameRegex)) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeviceIds() {
        String para = this.deviceIds;
        if (null == para || "".equals(para)) {
            return true;
        }
        long id = 0L;
        String[] idArray = para.split(",");
        if (idArray.length > 100) {
            return false;
        }
        for (int i = 0; i < idArray.length; ++i) {
            try {
                id = Long.parseLong(idArray[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id >= 1L) continue;
            return false;
        }
        return true;
    }

    public void checkFilterApplayToGlobOrZone() {
        StringBuffer deviceNames = new StringBuffer("");
        IFilterDeviceZoneInfoService filterDeviceZoneInfoService = ZoneReferUtil.getFilterDeviceZoneInfoService();
        IFilterDeviceZoneStatusService filterDeviceZoneStatusService = ZoneReferUtil.getFilterDeviceZoneStatusService();
        if (StringUtils.isEmpty((CharSequence)this.deleteDeviceIds)) {
            this.responseResult(deviceNames.toString());
            return;
        }
        String[] needDeleteDeviceIds = this.deleteDeviceIds.split(",");
        if (0 == needDeleteDeviceIds.length) {
            this.responseResult(deviceNames.toString());
            return;
        }
        ArrayList<Long> moIdList = new ArrayList<Long>();
        for (String deviceIdStr : needDeleteDeviceIds) {
            List<FilterDeviceZoneStatusForm> filterDeviceZoneStatusFormList;
            AticDeviceNfaClusterDao nfaClusterDao;
            List findRelNfaDevice;
            if ("".equals(deviceIdStr.trim())) continue;
            Long moId = Long.valueOf(deviceIdStr);
            moIdList.add(moId);
            List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = filterDeviceZoneInfoService.querydeployedFilterByfilterIdAndDeviceId(this.filterId, moId, 1);
            AticDevice aticDevice = ZoneReferUtil.getDevice(moId);
            if (!filterDeviceZoneInfoList.isEmpty()) {
                if (null == aticDevice) continue;
                deviceNames.append(aticDevice.getName() + ";");
                continue;
            }
            if (null != aticDevice && aticDevice.getDeviceType() == 9 && (findRelNfaDevice = (nfaClusterDao = (AticDeviceNfaClusterDao)ServiceContext.getInstance().getService("aticDeviceNfaClusterDao", AticDeviceNfaClusterDao.class)).findRelNfaDevice(Long.valueOf(aticDevice.getMoId()))) != null) {
                for (AticDeviceNfaCluster aticDeviceNfaCluster : findRelNfaDevice) {
                    List<FilterDeviceZoneStatusForm> filterDeviceZoneStatusFormList2 = filterDeviceZoneStatusService.getInfosByFilterIdAndDeviceId(this.filterId, aticDeviceNfaCluster.getDeviceId());
                    if (filterDeviceZoneStatusFormList2.isEmpty()) continue;
                    deviceNames.append(aticDevice.getName() + ";");
                    break;
                }
            }
            if ((filterDeviceZoneStatusFormList = filterDeviceZoneStatusService.getInfosByFilterIdAndDeviceId(this.filterId, moId)).isEmpty() || null == aticDevice) continue;
            deviceNames.append(aticDevice.getName() + ";");
        }
        BisUtil.checkUserSecurity(moIdList);
        if (deviceNames.length() != 0) {
            this.responseResult(deviceNames.substring(0, deviceNames.length() - 1));
        } else {
            this.responseResult(deviceNames.toString());
        }
    }
}

