/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.ServiceLearningForm;
import com.hs.atic.sdk.bis.service.IAticCommonUtilService;
import com.hs.atic.sdk.bis.service.IServiceLearningService;
import com.hs.atic.sdk.util.TimeTransferUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.action.RadioGroupVO;
import com.hs.vsm.secservice.ddos.policy.beans.ServiceLearningInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.DevCapUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ServiceLearningParamForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IServiceLearningParamService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.capability.model.ParaBean;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ServiceLearningAction
extends BaseAction {
    static Comparator<LangPair> comparator = new Comparator<LangPair>(){

        @Override
        public int compare(LangPair o1, LangPair o2) {
            return o1.getValue().toLowerCase(Locale.ENGLISH).compareTo(o2.getValue().toLowerCase(Locale.ENGLISH));
        }
    };
    private static final long serialVersionUID = 394439543267141759L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String SERVICE_LEARNNING_ALL = "-1";
    private static final String SERVICE_LEARNNING_NOCONFIRMED = "0";
    private static final String SERVICE_LEARNNING_CONFIRMED = "1";
    private static final String AUTO_CONGFIRM_NUM_ALL_KEY = "-1";
    private static final String AUTO_CONGFIRM_NUM_FIVE_KEY = "0";
    private static final String AUTO_CONGFIRM_NUM_TEN_KEY = "1";
    private static final int CONGFIRM_MODE_MANUAL = 0;
    private static final int CONGFIRM_MODE_AUTO = 1;
    List<RadioGroupVO> confirmTypeList;
    List<LangPair> topObjList;
    String topCmbKey;
    String topCmbValue;
    private String zoneId;
    private String alertRate2Query;
    private String serviceName;
    private String stateCmbKey;
    private String stateCmbValue;
    private List<LangPair> stateList;
    private List<ServiceLearningForm> serviceLearningDatas = null;
    private ServiceLearningParamForm serviceLearningParamForm;
    private String confirmType;
    private List<LangPair> deviceNameList;
    private String deviceNameCmbValue;
    private String deviceNameCmbKey;
    private String serviceLearningGrids;
    private String deviceId;
    private boolean pageDisabled;
    private int checkDev;
    private String notSupportDeviceName;
    private Boolean isHasNotSupportDevice;
    private Boolean viewPage;

    private void initConfirmTypes() {
        this.confirmTypeList = new ArrayList<RadioGroupVO>();
        RadioGroupVO radio1 = new RadioGroupVO();
        radio1.setKey(0);
        radio1.setLabel(this.getText("com.hs.vsm.secservice.ddos.policy.serviceLearing.manualCOnfirm"));
        RadioGroupVO radio2 = new RadioGroupVO();
        radio2.setKey(1);
        radio2.setLabel(this.getText("com.hs.vsm.secservice.ddos.policy.serviceLearing.autoConfirm"));
        this.confirmTypeList.add(radio1);
        this.confirmTypeList.add(radio2);
        if (null == this.serviceLearningParamForm) {
            this.confirmType = String.valueOf(0);
        } else if (String.valueOf(0).equals(this.serviceLearningParamForm.getConfirmType())) {
            this.confirmType = String.valueOf(0);
        } else if (String.valueOf(1).equals(this.serviceLearningParamForm.getConfirmType())) {
            this.confirmType = String.valueOf(1);
        }
    }

    private void initTopObjs() {
        this.topObjList = new ArrayList<LangPair>();
        this.topObjList.add(new LangPair("-1", this.getText("com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.all")));
        this.topObjList.add(new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.five")));
        this.topObjList.add(new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.ten")));
        if (null == this.serviceLearningParamForm) {
            this.setTopCmbKey("-1");
            this.setTopCmbValue(this.getText("com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.all"));
        } else if (this.serviceLearningParamForm.getTopObj() != null) {
            if ("-1".equals(this.serviceLearningParamForm.getTopObj().toString())) {
                this.setTopCmbKey("-1");
                this.setTopCmbValue(this.getText("com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.all"));
            } else if ("0".equals(this.serviceLearningParamForm.getTopObj().toString())) {
                this.setTopCmbKey("0");
                this.setTopCmbValue(this.getText("com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.five"));
            } else if ("1".equals(this.serviceLearningParamForm.getTopObj().toString())) {
                this.setTopCmbKey("1");
                this.setTopCmbValue(this.getText("com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.ten"));
            }
        } else {
            this.setTopCmbKey("-1");
            this.setTopCmbValue(this.getText("com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.all"));
        }
    }

    private void initStateList() {
        this.stateList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("-1", this.getText("com.hs.vsm.secservice.ddos.blacklist.status.all"));
        LangPair com1 = new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.policy.serviceLearing.noconfirm"));
        LangPair com2 = new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.policy.serviceLearing.confirmed"));
        this.stateList.add(com0);
        this.stateList.add(com1);
        this.stateList.add(com2);
        if (this.stateCmbKey == null) {
            this.setStateCmbKey("-1");
            this.setStateCmbValue(this.getText("com.hs.vsm.secservice.ddos.blacklist.status.all"));
        }
    }

    private Map<String, Object> getConditions() {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("start", this.start + "");
        queryMap.put("pageSize", this.pageSize + "");
        queryMap.put("state", this.stateCmbKey);
        if (!StringUtils.isEmpty((CharSequence)this.serviceName)) {
            queryMap.put("serviceName", this.serviceName.trim());
        }
        queryMap.put("zoneId", this.zoneId);
        queryMap.put("deviceId", this.getDeviceId());
        queryMap.put("deviceIP", this.getDeviceNameCmbValue());
        queryMap.put("deviceIP", this.getDeviceNameCmbValue());
        queryMap.put("alertRate2Query", this.alertRate2Query);
        logger.info((Object)("query service learning result by queryMap: " + queryMap));
        return queryMap;
    }

    private void parseZoneId() {
        if (this.zoneId.contains(",")) {
            String[] zoneids = this.zoneId.split(",");
            this.zoneId = zoneids[0];
        }
    }

    private String setNoSupportDeviceName(List<String> notSupportDevices) {
        if (null == notSupportDevices || notSupportDevices.isEmpty()) {
            return "";
        }
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(notSupportDevices.get(0));
        notSupportDevices.remove(0);
        for (String name : notSupportDevices) {
            nameBuffer.append(',');
            nameBuffer.append(name);
        }
        return nameBuffer.toString();
    }

    private void initDeviceNameList() {
        this.isHasNotSupportDevice = false;
        this.deviceNameList = new ArrayList<LangPair>();
        IZoneDeviceService service = ZoneReferUtil.getZoneDeviceService();
        ICommonUtilService commonUtilService = ZoneReferUtil.getCommonUtilService();
        IAticCommonUtilService aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
        this.parseZoneId();
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        List zoneDeviceForms = service.queryZoneDeviceFormsByZoneID(Long.valueOf(this.zoneId), currentUser.getUserID(), "true".equalsIgnoreCase(currentUser.getIsAdmin()));
        AticDevice securityNE = null;
        String deviceName = null;
        ArrayList<String> notSupportDevices = new ArrayList<String>();
        HashMap<String, String> devIps = new HashMap<String, String>();
        int j = zoneDeviceForms.size();
        for (int i = 0; i < j; ++i) {
            ZoneDeviceForm zoneDeviceForm = (ZoneDeviceForm)zoneDeviceForms.get(i);
            securityNE = ZoneReferUtil.getDevice(zoneDeviceForm.getDeviceId());
            if (commonUtilService.isSupportSrvLearning(securityNE)) {
                deviceName = securityNE.getName();
                String ipAddress = securityNE.getIpAddress();
                LangPair com = new LangPair(ipAddress, deviceName);
                this.deviceNameList.add(com);
                devIps.put(ipAddress, String.valueOf(securityNE.getMoId()));
                if (this.pageDisabled || aticCommonUtilService.checkCollectorStatus(ipAddress)) continue;
                this.pageDisabled = true;
                continue;
            }
            this.isHasNotSupportDevice = true;
            notSupportDevices.add(securityNE.getName());
        }
        this.notSupportDeviceName = this.setNoSupportDeviceName(notSupportDevices);
        Collections.sort(this.deviceNameList, comparator);
        if ((this.getDeviceNameCmbValue() == null || "".equals(this.getDeviceNameCmbValue())) && !this.deviceNameList.isEmpty()) {
            this.setDeviceNameCmbValue(this.deviceNameList.get(0).getLabel());
            this.setDeviceNameCmbKey(this.deviceNameList.get(0).getValue());
        }
        this.deviceId = (String)devIps.get(this.getDeviceNameCmbValue());
    }

    private String getDeviceName(String deviceIP) {
        IZoneDeviceService service = ZoneReferUtil.getZoneDeviceService();
        this.parseZoneId();
        List zoneDeviceForms = service.queryZoneDeviceFormsByZoneID(Long.valueOf(this.zoneId));
        AticDevice firewall = null;
        int j = zoneDeviceForms.size();
        for (int i = 0; i < j; ++i) {
            ZoneDeviceForm zoneDeviceForm = (ZoneDeviceForm)zoneDeviceForms.get(i);
            firewall = ZoneReferUtil.getDevice(zoneDeviceForm.getDeviceId());
            if (!deviceIP.equals(firewall.getIpAddress())) continue;
            return firewall.getName();
        }
        return null;
    }

    private void setServiceLearingDeviceName(List<ServiceLearningForm> serviceLearningDataList) {
        String deviceName = null;
        if (!serviceLearningDataList.isEmpty()) {
            for (ServiceLearningForm serviceLearningForm : serviceLearningDataList) {
                if (null == serviceLearningForm.getDeviceIp()) continue;
                deviceName = this.getDeviceName(serviceLearningForm.getDeviceIp());
                serviceLearningForm.setDeviceName(deviceName);
            }
        }
    }

    private Long getDeviceId(String deviceIp) {
        IAticDeviceService firewallService = ZoneReferUtil.getFirewallService();
        List firewalls = firewallService.getAllDevice();
        if (!firewalls.isEmpty()) {
            for (AticDevice firewall : firewalls) {
                if (!firewall.getIpAddress().equals(deviceIp)) continue;
                return firewall.getMoId();
            }
        }
        return null;
    }

    private void setServiceLearningDeviceId(List<ServiceLearningForm> serviceLearningDataList) {
        if (!serviceLearningDataList.isEmpty()) {
            for (ServiceLearningForm serviceLearningForm : serviceLearningDataList) {
                String deviceIp = serviceLearningForm.getDeviceIp();
                Long deviceID = this.getDeviceId(deviceIp);
                serviceLearningForm.setDeviceId(deviceID + "");
            }
        }
    }

    private Long getDeviceIdByZoneId(Long zoneID) {
        IZoneDeviceService zoneDeviceService = ZoneReferUtil.getZoneDeviceService();
        List zoneDeviceFormList = zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneID);
        if (!zoneDeviceFormList.isEmpty()) {
            ZoneDeviceForm zoneDeviceForm = (ZoneDeviceForm)zoneDeviceFormList.get(0);
            return zoneDeviceForm.getDeviceId();
        }
        return null;
    }

    private long getTimeInMillis(String time) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime();
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    private long getCurrentTimeMills() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return calendar.getTimeInMillis();
    }

    public String showServiceLearning() {
        ZoneInfoForm zoneInfoForm;
        this.parseZoneId();
        this.pageDisabled = false;
        logger.info((Object)("service learning zoneId: " + this.zoneId));
        IServiceLearningParamService serviceLearningParamService = ZoneReferUtil.getServiceLearningParamService();
        this.serviceLearningParamForm = serviceLearningParamService.queryByZoneId(this.zoneId);
        if (this.serviceLearningParamForm == null) {
            this.serviceLearningParamForm = new ServiceLearningParamForm();
            this.serviceLearningParamForm.setStartupTime(TimeTransferUtil.transferlong2String(System.currentTimeMillis() + 60000L));
            this.serviceLearningParamForm.setTaskStatus(false);
            this.serviceLearningParamForm.setConfirmType(String.valueOf(0));
        }
        if (this.serviceLearningParamForm.getTaskStatus().booleanValue()) {
            this.alertRate2Query = this.serviceLearningParamForm.getAlertRate().toString();
        }
        if ((zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId))) != null) {
            this.serviceLearningParamForm.setZoneName(zoneInfoForm.getZoneDesc());
        }
        logger.info((Object)("serviceLearningParamForm : " + AticUtil.getcleanedMessage((String)this.serviceLearningParamForm.toString())));
        this.initConfirmTypes();
        this.initTopObjs();
        this.initStateList();
        this.initDeviceNameList();
        if (this.deviceNameList == null || this.deviceNameList.isEmpty()) {
            this.pageDisabled = true;
            return "success";
        }
        IServiceLearningService sericeLearningService = ZoneReferUtil.getServiceLearingService();
        IAticCommonUtilService aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
        boolean collectorStatus = aticCommonUtilService.checkCollectorStatus(this.getDeviceNameCmbValue());
        if (!collectorStatus) {
            this.pageDisabled = true;
            return "success";
        }
        logger.info((Object)"get serviceLearning result map : ");
        Map<String, Object> queryMap = this.getConditions();
        logger.info((Object)("get serviceLearning result map : " + this.getcleanedMessage(queryMap.toString())));
        Paging page = sericeLearningService.getServiceLearningData(queryMap);
        if (null == page) {
            this.pageDisabled = true;
            return "success";
        }
        this.serviceLearningDatas = page.getData();
        this.setServiceLearingDeviceName(this.serviceLearningDatas);
        this.setServiceLearningDeviceId(this.serviceLearningDatas);
        logger.info((Object)("get service result:" + this.serviceLearningDatas));
        this.total = page.getCount();
        if (this.start >= this.total) {
            this.start = this.total - (this.total % this.pageSize == 0 ? this.pageSize : this.total % this.pageSize);
        }
        this.start = this.start > 0 ? this.start : 0;
        IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        ZonePolicyApplyForm zonePolicyApplyForm = (ZonePolicyApplyForm)zonePolicyApplyService.query(Long.valueOf(this.zoneId));
        if (!"SUCCESS".equals(zonePolicyApplyForm.getDeployState())) {
            this.pageDisabled = true;
        }
        return "success";
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void checkCollectorStatus() {
        String deployState;
        this.parseZoneId();
        IZoneDeviceService service = ZoneReferUtil.getZoneDeviceService();
        Long moId = ZoneBisUtil.getMoidByZoneid(Long.valueOf(this.zoneId));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        List zoneDeviceForms = service.queryZoneDeviceFormsByZoneID(Long.valueOf(this.zoneId));
        if (zoneDeviceForms == null || zoneDeviceForms.isEmpty()) {
            this.responseResult("nodevice");
            return;
        }
        boolean hasSupportDev = false;
        boolean hasOffLineDev = false;
        IAticCommonUtilService aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
        ICommonUtilService policyCommonUtilService = ZoneReferUtil.getCommonUtilService();
        AticDevice securityNE = null;
        StringBuffer offLineCollector = new StringBuffer();
        for (ZoneDeviceForm zoneDeviceForm : zoneDeviceForms) {
            securityNE = ZoneReferUtil.getDevice(zoneDeviceForm.getDeviceId());
            Boolean isSupport = policyCommonUtilService.isSupportSrvLearning(securityNE);
            if (!isSupport.booleanValue()) continue;
            hasSupportDev = true;
            boolean collectorStatus = aticCommonUtilService.checkCollectorStatus(String.valueOf(securityNE.getIpAddress()));
            if (collectorStatus) continue;
            hasOffLineDev = true;
            offLineCollector.append(securityNE.getName()).append(',');
        }
        if (!hasSupportDev) {
            this.responseResult("nosupport");
            return;
        }
        IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        ZonePolicyApplyForm zonePolicyApplyForm = (ZonePolicyApplyForm)zonePolicyApplyService.query(Long.valueOf(this.zoneId));
        if (hasOffLineDev && !"SUCCESS".equals(zonePolicyApplyForm.getDeployState())) {
            deployState = "failed";
            if ("UNDEPLOY".equals(zonePolicyApplyForm.getDeployState())) {
                deployState = "undeployed";
            }
            if ("INCREAMENT_UNDEPLOY".equals(zonePolicyApplyForm.getDeployState())) {
                deployState = "increament";
            }
            String offLineCollectorStr = offLineCollector.toString();
            this.responseResult("nocollector&nodeploy#" + offLineCollectorStr.substring(0, offLineCollectorStr.length() - 1) + "#" + deployState);
        } else if (!"SUCCESS".equals(zonePolicyApplyForm.getDeployState())) {
            deployState = "failed";
            if ("UNDEPLOY".equals(zonePolicyApplyForm.getDeployState())) {
                deployState = "undeployed";
            }
            if ("INCREAMENT_UNDEPLOY".equals(zonePolicyApplyForm.getDeployState())) {
                deployState = "increament";
            }
            this.responseResult("nodeploy#" + deployState);
        } else if (hasOffLineDev) {
            String offLineCollectorStr = offLineCollector.toString();
            this.responseResult("nocollector#" + offLineCollectorStr.substring(0, offLineCollectorStr.length() - 1));
        } else {
            this.responseResult("success");
        }
    }

    private void setTaskOpt(String zoneName, boolean opertation) {
        String logName;
        String string = logName = opertation ? "com.hs.vsm.secservice.ddos.policy.operation.name.startServicelearningTask" : "com.hs.vsm.secservice.ddos.policy.operation.name.stopServicelearningTask";
        if (this.serviceLearningParamForm.getConfirmType().equals(String.valueOf(1))) {
            String topN;
            String detailName = opertation ? "com.hs.vsm.secservice.ddos.policy.operation.detail.auto.startServicelearningTask" : "com.hs.vsm.secservice.ddos.policy.operation.detail.auto.stopServicelearningTask";
            int topObj = this.serviceLearningParamForm.getTopObj() == null ? 0 : this.serviceLearningParamForm.getTopObj();
            switch (topObj) {
                case 0: {
                    topN = "com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.five";
                    break;
                }
                case 1: {
                    topN = "com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.ten";
                    break;
                }
                case 2: {
                    topN = "com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.thirty";
                    break;
                }
                default: {
                    topN = "com.hs.vsm.secservice.ddos.policy.servicelearn.topnnum.all";
                }
            }
            this.getOperateLog().info(logName, "lego.dic.module.ddosApp", zoneName, false, detailName, new String[]{this.serviceLearningParamForm.getStartupTime(), this.serviceLearningParamForm.getStopTime(), this.serviceLearningParamForm.getAlertRate() + "", "com.hs.vsm.secservice.ddos.policy.serviceLearing.autoConfirm", topN});
        } else {
            String detailName = opertation ? "com.hs.vsm.secservice.ddos.policy.operation.detail.manual.startServicelearningTask" : "com.hs.vsm.secservice.ddos.policy.operation.detail.manual.stopServicelearningTask";
            this.getOperateLog().info(logName, "lego.dic.module.ddosApp", zoneName, false, detailName, new String[]{this.serviceLearningParamForm.getStartupTime(), this.serviceLearningParamForm.getStopTime(), this.serviceLearningParamForm.getAlertRate() + "", "com.hs.vsm.secservice.ddos.policy.serviceLearing.manualCOnfirm"});
        }
    }

    public void startupServiceLearning() {
        logger.info((Object)("startup service learning on zoneID:" + this.zoneId));
        Long moId = ZoneBisUtil.getMoidByZoneid(Long.valueOf(this.zoneId));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId));
        if (zoneInfoForm == null) {
            throw new LegoCheckedException(630144L);
        }
        this.setTaskOpt(zoneInfoForm.getZoneDesc(), true);
        IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        ZonePolicyApplyForm zonePolicyApplyForm = (ZonePolicyApplyForm)zonePolicyApplyService.query(Long.valueOf(this.zoneId));
        if (!"SUCCESS".equals(zonePolicyApplyForm.getDeployState())) {
            throw new LegoCheckedException(630125L);
        }
        long currentTimeMills = this.getCurrentTimeMills();
        long startServiceTimeMills = this.getTimeInMillis(this.serviceLearningParamForm.getStartupTime());
        long stopServiceTimeMills = this.getTimeInMillis(this.serviceLearningParamForm.getStopTime());
        if (startServiceTimeMills < currentTimeMills) {
            logger.error((Object)("startTime:" + startServiceTimeMills + " currentTime:" + currentTimeMills));
            this.responseResult("starttimelessthancurrent");
            return;
        }
        if ((stopServiceTimeMills - startServiceTimeMills) / 1000L < 64L || (stopServiceTimeMills - startServiceTimeMills) / 1000L > 31536000L) {
            logger.error((Object)("startTime:" + startServiceTimeMills + " stopTime:" + stopServiceTimeMills));
            this.responseResult("timeoutrange");
            return;
        }
        this.initDeviceNameList();
        if (this.deviceNameList == null || this.deviceNameList.isEmpty()) {
            throw new LegoCheckedException(630131L);
        }
        this.serviceLearningDatas = new ArrayList<ServiceLearningForm>();
        this.total = 0;
        String zoneName = this.getZonenameByZoneId(Long.valueOf(this.zoneId));
        logger.info((Object)("startup service learning on zoneName:" + zoneName));
        this.deployStartupCommand(this.serviceLearningParamForm);
        this.responseResult("success");
    }

    private void deleteServiceLearning(List<LangPair> deviceNameLists, ServiceLearningParamForm form) {
        if (deviceNameLists != null) {
            IServiceLearningService sericeLearningService = ZoneReferUtil.getServiceLearingService();
            if (!deviceNameLists.isEmpty()) {
                for (LangPair lp : deviceNameLists) {
                    sericeLearningService.addServiceLearningTask(this.zoneId, lp.getLabel(), form.getStartupTime(), form.getStopTime());
                }
            }
        }
    }

    private void deployStartupCommand(ServiceLearningParamForm serviceLearningParamForms) {
        IServiceLearningParamService serviceLearningParamService;
        ISysOptLog sysOptLog = ZoneReferUtil.getSysOptLog();
        HttpServletRequest request = this.fetchRequest();
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("com.hs.vsm.secservice.ddos.quickstart.policy");
        sysLog.setModule("lego.dic.module.ddosApp");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(currentUser.getIpAdr());
        sysLog.setOperator(currentUser.getUserName());
        sysLog.setResult(0);
        sysLog.setTarget(serviceLearningParamForms.getZoneName());
        IAticCommonUtilService aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
        StringBuffer offLineCollectors = new StringBuffer();
        boolean isHasOffLineCollector = false;
        if (this.deviceNameList != null) {
            if (!this.deviceNameList.isEmpty()) {
                for (LangPair lp : this.deviceNameList) {
                    if (aticCommonUtilService.checkCollectorStatus(lp.getLabel())) continue;
                    isHasOffLineCollector = true;
                    offLineCollectors.append(lp.getValue()).append(',');
                }
            }
            if (isHasOffLineCollector) {
                String offLineCollectorStr = offLineCollectors.toString();
                this.responseResult("nocollector#" + offLineCollectorStr.substring(0, offLineCollectorStr.length() - 1));
                sysLog.setDetail("com.hs.vsm.secservice.ddos.policy.servicelearn.zonestate.failed1");
                sysOptLog.writeOptLog(sysLog);
                return;
            }
        }
        if ((serviceLearningParamService = ZoneReferUtil.getServiceLearningParamService()) == null) {
            sysLog.setDetail("lego.err.630130");
            sysOptLog.writeOptLog(sysLog);
            throw new LegoCheckedException(630130L);
        }
        ServiceLearningParamForm temp = serviceLearningParamService.queryByZoneId(this.zoneId);
        if (null != temp && temp.getTaskStatus().booleanValue()) {
            sysLog.setDetail("lego.err.630142");
            sysOptLog.writeOptLog(sysLog);
            throw new LegoCheckedException(630142L);
        }
        try {
            logger.info((Object)"start delete service learning result before!!");
            this.deleteServiceLearning(this.deviceNameList, serviceLearningParamForms);
            logger.info((Object)"end delete service learning result before!!");
        }
        catch (Exception e) {
            sysLog.setDetail("lego.err.570504");
            sysOptLog.writeOptLog(sysLog);
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
        serviceLearningParamForms.setTaskStatus(false);
        try {
            logger.info((Object)"startup deploy command!!");
            serviceLearningParamService.deployStartupCommand(serviceLearningParamForms);
            logger.info((Object)"end deploy command!!");
        }
        catch (Exception e) {
            sysLog.setDetail("lego.err.630130");
            sysOptLog.writeOptLog(sysLog);
            throw new LegoCheckedException(630130L, (Throwable)e);
        }
        try {
            serviceLearningParamService.createOrUpdate(serviceLearningParamForms);
        }
        catch (Exception e) {
            sysLog.setDetail("lego.err.630127");
            sysOptLog.writeOptLog(sysLog);
            throw new LegoCheckedException(630127L, (Throwable)e);
        }
    }

    private String getZonenameByZoneId(Long zoneID) {
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(zoneID);
        return zoneInfoForm.getZoneDesc();
    }

    public void stopServiceLearning() {
        Long moId = ZoneBisUtil.getMoidByZoneid(Long.valueOf(this.zoneId));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId));
        if (null == zoneInfoForm) {
            throw new LegoCheckedException(630145L);
        }
        String zoneName = zoneInfoForm.getZoneDesc();
        IServiceLearningParamService serviceLearningParamService = ZoneReferUtil.getServiceLearningParamService();
        if (serviceLearningParamService == null) {
            throw new LegoCheckedException(630130L);
        }
        this.serviceLearningParamForm = serviceLearningParamService.queryByZoneId(this.zoneId);
        if (this.serviceLearningParamForm == null || !this.serviceLearningParamForm.getTaskStatus().booleanValue()) {
            throw new LegoCheckedException(630143L);
        }
        this.serviceLearningParamForm.setTaskStatus(false);
        this.setTaskOpt(zoneName, false);
        try {
            serviceLearningParamService.deplyStopCommand(Long.valueOf(this.zoneId));
            serviceLearningParamService.updateServiceParamStatus(Long.valueOf(this.zoneId));
            this.responseResult("success");
        }
        catch (Exception e) {
            throw new LegoCheckedException(630127L, (Throwable)e);
        }
    }

    private boolean isNull(String str) {
        return str == null || "".equals(str);
    }

    private ZoneServiceForm generateZoneServce(ServiceLearningInfo info) {
        Long zoneID = info.getZoneId();
        Long deviceID = info.getDeviceId();
        String protocol = info.getProtocol();
        String port = String.valueOf(info.getPort());
        String ip = info.getZoneIp();
        IZoneServiceService zoneServiceService = ZoneReferUtil.getZoneServiceService();
        List<ZoneServiceForm> zoneServiceForms = zoneServiceService.queryByProtocolAndPort(zoneID, deviceID, protocol, port);
        if (null != zoneServiceForms) {
            if (zoneServiceForms.isEmpty()) {
                ZoneServiceForm form = new ZoneServiceForm();
                form.setDeviceId(info.getDeviceId());
                form.setServiceName(zoneServiceService.getZoneServiceName(info.getServiceName(), zoneID));
                boolean bool1 = "UDP".equals(protocol) || "TCP".equals(protocol) || "HTTP".equals(protocol) || "HTTPS".equals(protocol);
                boolean bool2 = "SIP".equals(protocol);
                if (bool1 || bool2) {
                    form.setProtocol(protocol);
                    form.setPortList(this.isNull(port) ? "" : port);
                } else {
                    form.setProtocol("Other");
                    form.setProtocolNum(Integer.parseInt(protocol));
                }
                form.setIpList(this.isNull(ip) ? "" : ip);
                form.setInfoFrom(1);
                form.setZoneId(zoneID);
                return form;
            }
            for (ZoneServiceForm zoneServiceForm : zoneServiceForms) {
                String serviceIps = zoneServiceForm.getIpList();
                ParaBean bean = this.hasParasDiff(zoneServiceForm);
                int maxIpSize = Integer.parseInt(bean.getParaDefault());
                int currentIpSize = serviceIps.split(";").length;
                if (currentIpSize >= maxIpSize) continue;
                zoneServiceForm.setIpList(new StringBuffer(serviceIps).append(";").append(ip).toString());
                return zoneServiceForm;
            }
        } else {
            logger.error((Object)"zoneServiceForms is null");
        }
        throw new LegoCheckedException(631015L);
    }

    private ParaBean hasParasDiff(ZoneServiceForm form) {
        Long moId = form.getDeviceId();
        DevCapUtil devCapUtil = DevCapUtil.getInstance();
        devCapUtil.initContext(moId, form.getProtocol());
        ParaBean paraBean = devCapUtil.hasParasDiff("ipListLimit", moId, form.getProtocol());
        if (null == paraBean) {
            paraBean = new ParaBean();
        }
        return paraBean;
    }

    public void confirmServiceLearning() {
        List<ServiceLearningInfo> serviceLearningInfos = this.parseTransferString();
        BatchOperationResult result = new BatchOperationResult();
        if (!serviceLearningInfos.isEmpty()) {
            int fail = 0;
            ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(serviceLearningInfos.get(0).getZoneId());
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            IZoneServiceService zoneServiceService = ZoneReferUtil.getZoneServiceService();
            int i = 0;
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.confirmServicelearningTask", "lego.dic.module.ddosApp");
            for (ServiceLearningInfo info : serviceLearningInfos) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId((long)i++);
                bo.setTargetName(zoneInfoForm.getZoneDesc());
                bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.confirmServicelearningTask");
                bo.setDetailParam(new String[]{info.getServiceName(), info.getProtocolDisplay(), String.valueOf(info.getPort()), info.getZoneIp(), String.valueOf(info.getFlowRate()), info.getDeviceName()});
                try {
                    ZoneServiceForm form = this.generateZoneServce(info);
                    zoneServiceService.create(form);
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    bo.setTargetName(new StringBuffer(info.getServiceName()).append("_").append(info.getZoneIp()).toString());
                    bo.setErrorCode(e.getErrorCode() == 630156L ? 630159L : e.getErrorCode());
                    logger.error((Object)("errorMessage=" + e.getMessage()));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setTargetName(new StringBuffer(info.getServiceName()).append("_").append(info.getZoneIp()).toString());
                    bo.setErrorCode(200L);
                    logger.error((Object)("errorMessage=" + this.getcleanedMessage(e.getMessage())));
                }
                batchOpList.add(bo);
            }
            result.setResult(batchOpList);
            result.setFailCount(fail);
            result.setTotalCount(serviceLearningInfos.size());
            result.setSucceedCount(serviceLearningInfos.size() - fail);
            this.batchOperationResult = result;
            this.bathResult(this.batchOperationResult);
        }
    }

    private List<ServiceLearningInfo> parseTransferString() {
        String[] serviceLearningDataStrs;
        ArrayList<ServiceLearningInfo> datas = new ArrayList<ServiceLearningInfo>();
        String firstFlag = ",";
        String secondFlag = ";";
        ServiceLearningInfo data = null;
        if (null != this.serviceLearningGrids && !this.serviceLearningGrids.isEmpty() && (serviceLearningDataStrs = this.serviceLearningGrids.split(firstFlag)).length > 0) {
            int j = serviceLearningDataStrs.length;
            for (int i = 0; i < j; ++i) {
                data = new ServiceLearningInfo();
                String serviceLdarningData = serviceLearningDataStrs[i].trim();
                String[] serviceLdarningAttDatas = serviceLdarningData.split(secondFlag);
                String logTime = serviceLdarningAttDatas[0].trim();
                String protocol = serviceLdarningAttDatas[1].trim();
                String port = serviceLdarningAttDatas[2].trim();
                String zoneIp = serviceLdarningAttDatas[3].trim();
                String zoneID = serviceLdarningAttDatas[4].trim();
                String deviceID = serviceLdarningAttDatas[5].trim();
                String deviceName = serviceLdarningAttDatas[6].trim();
                String serviceNameStr = serviceLdarningAttDatas[7].trim();
                String protocolDisplay = serviceLdarningAttDatas[9].trim();
                Integer flowRate = 0;
                if (!"".equals(serviceLdarningAttDatas[8].trim()) && !"".equals(serviceLdarningAttDatas[7].trim())) {
                    flowRate = Integer.parseInt(serviceLdarningAttDatas[8].trim());
                }
                if (!"".equals(logTime) && !"null".equals(logTime)) {
                    data.setLogTime(Long.valueOf(logTime));
                }
                data.setProtocol(protocol);
                data.setPort(Integer.valueOf(port));
                data.setZoneIp(zoneIp);
                data.setZoneId(Long.valueOf(zoneID));
                data.setDeviceId(Long.valueOf(deviceID));
                data.setDeviceName(deviceName);
                data.setServiceName(serviceNameStr);
                data.setFlowRate(flowRate);
                data.setProtocolDisplay(protocolDisplay);
                datas.add(data);
            }
        }
        return datas;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getStateCmbKey() {
        return this.stateCmbKey;
    }

    public void setStateCmbKey(String stateCmbKey) {
        this.stateCmbKey = stateCmbKey;
    }

    public List<LangPair> getStateList() {
        return this.stateList;
    }

    public void setStateList(List<LangPair> stateList) {
        this.stateList = stateList;
    }

    public String getStateCmbValue() {
        return this.stateCmbValue;
    }

    public void setStateCmbValue(String stateCmbValue) {
        this.stateCmbValue = stateCmbValue;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public List<RadioGroupVO> getConfirmTypeList() {
        return this.confirmTypeList;
    }

    public void setConfirmTypeList(List<RadioGroupVO> confirmTypeList) {
        this.confirmTypeList = confirmTypeList;
    }

    public List<ServiceLearningForm> getServiceLearningDatas() {
        return this.serviceLearningDatas;
    }

    public void setServiceLearningDatas(List<ServiceLearningForm> serviceLearningDatas) {
        this.serviceLearningDatas = serviceLearningDatas;
    }

    public List<LangPair> getTopObjList() {
        return this.topObjList;
    }

    public void setTopObjList(List<LangPair> topObjList) {
        this.topObjList = topObjList;
    }

    public String getTopCmbKey() {
        return this.topCmbKey;
    }

    public void setTopCmbKey(String topCmbKey) {
        this.topCmbKey = topCmbKey;
    }

    public String getTopCmbValue() {
        return this.topCmbValue;
    }

    public void setTopCmbValue(String topCmbValue) {
        this.topCmbValue = topCmbValue;
    }

    public ServiceLearningParamForm getServiceLearningParamForm() {
        return this.serviceLearningParamForm;
    }

    public void setServiceLearningParamForm(ServiceLearningParamForm serviceLearningParamForm) {
        this.serviceLearningParamForm = serviceLearningParamForm;
    }

    public String getConfirmType() {
        return this.confirmType;
    }

    public void setConfirmType(String confirmType) {
        this.confirmType = confirmType;
    }

    public List<LangPair> getDeviceNameList() {
        return this.deviceNameList;
    }

    public void setDeviceNameList(List<LangPair> deviceNameList) {
        this.deviceNameList = deviceNameList;
    }

    public String getDeviceNameCmbValue() {
        return this.deviceNameCmbValue;
    }

    public void setDeviceNameCmbValue(String deviceNameCmbValue) {
        this.deviceNameCmbValue = deviceNameCmbValue;
    }

    public String getDeviceNameCmbKey() {
        return this.deviceNameCmbKey;
    }

    public void setDeviceNameCmbKey(String deviceNameCmbKey) {
        this.deviceNameCmbKey = deviceNameCmbKey;
    }

    public String getServiceLearningGrids() {
        return this.serviceLearningGrids;
    }

    public void setServiceLearningGrids(String serviceLearningGrids) {
        this.serviceLearningGrids = serviceLearningGrids;
    }

    public ParaBean hasParasDiff(String id) {
        Long deviceID = Long.valueOf(this.getDeviceIdByZoneId(Long.valueOf(this.zoneId)) + "");
        return DevCapUtil.getInstance().hasParasDiff(id, deviceID, "Default");
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Boolean getIsHasNotSupportDevice() {
        return this.isHasNotSupportDevice;
    }

    public void setIsHasNotSupportDevice(Boolean isHasNotSupportDevice) {
        this.isHasNotSupportDevice = isHasNotSupportDevice;
    }

    public boolean isPageDisabled() {
        return this.pageDisabled;
    }

    public void setPageDisabled(boolean pageDisabled) {
        this.pageDisabled = pageDisabled;
    }

    public String getAlertRate2Query() {
        return this.alertRate2Query;
    }

    public void setAlertRate2Query(String alertRate2Query) {
        this.alertRate2Query = alertRate2Query;
    }

    public String getNotSupportDeviceName() {
        return this.notSupportDeviceName;
    }

    public void setNotSupportDeviceName(String notSupportDeviceName) {
        this.notSupportDeviceName = notSupportDeviceName;
    }

    public int getCheckDev() {
        return this.checkDev;
    }

    public void setCheckDev(int checkDev) {
        this.checkDev = checkDev;
    }

    public boolean validateStringId(String id) {
        long idTemp = 0L;
        try {
            idTemp = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return idTemp >= 1L;
    }

    public boolean validateZoneId() {
        this.parseZoneId();
        long id = 0L;
        try {
            id = Long.parseLong(this.zoneId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return id >= 1L;
    }

    public boolean validateValue() {
        if (null == this.deviceNameCmbValue) {
            return true;
        }
        return IPUtil.isIpv4((String)this.deviceNameCmbValue) || IPUtil.isIpv6((String)this.deviceNameCmbValue);
    }

    public boolean validateViewPage() {
        return true;
    }

    public boolean validateFormZoneId() {
        if (null == this.serviceLearningParamForm) {
            return true;
        }
        String id = this.serviceLearningParamForm.getZoneId();
        return this.validateStringId(id);
    }

    public boolean validateFormDeviceId() {
        if (null == this.deviceId) {
            return true;
        }
        return this.validateStringId(this.deviceId);
    }

    public boolean validateStartupTime() {
        String date = this.serviceLearningParamForm.getStartupTime();
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateStopTime() {
        String date = this.serviceLearningParamForm.getStopTime();
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public Boolean getViewPage() {
        return this.viewPage;
    }

    public void setViewPage(Boolean viewPage) {
        this.viewPage = viewPage;
    }
}

