/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.VpnDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IVpnDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VpnDeviceAction
extends BaseAction {
    private static final long serialVersionUID = -5431279803320932165L;
    private Long zoneId;
    private List<VpnDeviceForm> includeVpnList;
    private List<VpnDeviceForm> excludeVpnList;
    private List<LangPair> vpnZoneDeviceList;
    private String vpnZoneDeviceLabel;
    private String vpnZoneDeviceValue;
    private String vpnName;
    private String vpnIp;
    private String vpnType;
    private Long deviceId;
    private String zoneIp;
    private Integer zoneMask;
    private String deviceVpnName;
    private String[] deleteIdList;

    public String editVpn() {
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        return "success";
    }

    public String addExcludeVpn() {
        this.initDeviceList();
        return "success";
    }

    public void saveExcludeVpn() {
        VpnDeviceForm form = new VpnDeviceForm();
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(this.deviceId);
        BisUtil.checkUserSecurity(deviceList);
        form.setDeviceId(this.deviceId);
        form.setVpnName(this.deviceVpnName);
        form.setIpMask(this.zoneIp + "/" + this.zoneMask);
        form.setVpnType(2);
        form.setZoneId(this.zoneId);
        form.setStartIp(IPUtil4Atic.convert2CompleteIp((String)ZoneReferUtil.getMaskStartIp(this.zoneIp, this.zoneMask)));
        form.setEndIp(IPUtil4Atic.convert2CompleteIp((String)ZoneReferUtil.getMaskEndIp(this.zoneIp, this.zoneMask)));
        SysOptLog saveExcludeLog = new SysOptLog();
        saveExcludeLog.setOperation("com.hs.vsm.secservice.ddos.policy.operation.vpn.createExcludeVpn");
        saveExcludeLog.setModule("lego.dic.module.AticZone");
        saveExcludeLog.setLevel(SysoplogLevel.info.getValue());
        saveExcludeLog.setTarget(this.getZoneName(this.zoneId));
        User user = (User)this.getSession().getAttribute("currentUser");
        saveExcludeLog.setOperator(user.getUserName().trim());
        saveExcludeLog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        ISysOptLog sysOptLog = ZoneReferUtil.getSysOptLog();
        if (this.isExcludeVpnExist()) {
            this.responseResult(this.getText("com.hs.vsm.secservice.ddos.policy.operation.vpn.exist.alert"));
            saveExcludeLog.setResult(1);
            saveExcludeLog.setDetail("com.hs.vsm.secservice.ddos.policy.operation.vpn.exist");
            sysOptLog.writeOptLog(saveExcludeLog);
            return;
        }
        IVpnDeviceService service = ZoneReferUtil.getVpnDeviceService();
        try {
            service.save(form);
            saveExcludeLog.setResult(1);
        }
        catch (LegoCheckedException e) {
            saveExcludeLog.setResult(0);
            saveExcludeLog.setDetail("lego.err." + e.getErrorCode());
        }
        catch (Exception e) {
            saveExcludeLog.setResult(0);
            saveExcludeLog.setDetail(this.getText("com.hs.vsm.secservice.ddos.policy.operation.vpn.createExcludeVpn.exception"));
        }
        sysOptLog.writeOptLog(saveExcludeLog);
        this.responseResult("success");
    }

    private boolean isExcludeVpnExist() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(this.deviceId);
        BisUtil.checkUserSecurity(deviceList);
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        IVpnDeviceService service = ZoneReferUtil.getVpnDeviceService();
        return service.isVpnExcluded(this.deviceId, this.zoneId, this.zoneIp, this.zoneMask);
    }

    public void deleteExcludeVpn() {
        SysOptLog deleteExcludeLog = new SysOptLog();
        deleteExcludeLog.setOperation("com.hs.vsm.secservice.ddos.policy.operation.vpn.deleteExcludeVpn");
        deleteExcludeLog.setModule("lego.dic.module.AticZone");
        deleteExcludeLog.setLevel(SysoplogLevel.info.getValue());
        User user = (User)this.getSession().getAttribute("currentUser");
        deleteExcludeLog.setOperator(user.getUserName().trim());
        deleteExcludeLog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        deleteExcludeLog.setTarget(this.getZoneName(this.zoneId));
        IVpnDeviceService service = ZoneReferUtil.getVpnDeviceService();
        try {
            service.delete(this.deleteIdList);
            deleteExcludeLog.setResult(1);
        }
        catch (LegoCheckedException e) {
            deleteExcludeLog.setResult(0);
            deleteExcludeLog.setDetail("lego.err." + e.getErrorCode());
        }
        catch (Exception e) {
            deleteExcludeLog.setResult(0);
            deleteExcludeLog.setDetail(this.getText("com.hs.vsm.secservice.ddos.policy.operation.vpn.deleteExcludeVpn.exception"));
        }
        ISysOptLog sysOptLog = ZoneReferUtil.getSysOptLog();
        sysOptLog.writeOptLog(deleteExcludeLog);
        this.responseResult("success");
    }

    public void syncIncludeVpn() {
        SysOptLog syncIncludeLog = new SysOptLog();
        syncIncludeLog.setOperation("com.hs.vsm.secservice.ddos.policy.operation.vpn.syncIncludeVpn");
        syncIncludeLog.setModule("lego.dic.module.AticZone");
        syncIncludeLog.setLevel(SysoplogLevel.info.getValue());
        User user = (User)this.getSession().getAttribute("currentUser");
        syncIncludeLog.setOperator(user.getUserName().trim());
        syncIncludeLog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        syncIncludeLog.setTarget(this.getZoneName(this.zoneId));
        IVpnDeviceService service = ZoneReferUtil.getVpnDeviceService();
        try {
            service.syncIncludeVpn(this.zoneId);
            syncIncludeLog.setResult(1);
        }
        catch (LegoCheckedException e) {
            syncIncludeLog.setResult(0);
            syncIncludeLog.setDetail("lego.err." + e.getErrorCode());
            this.responseResult(this.getText("lego.err." + e.getErrorCode()));
        }
        catch (Exception e) {
            syncIncludeLog.setResult(0);
            syncIncludeLog.setDetail(this.getText("com.hs.vsm.secservice.ddos.policy.operation.vpn.syncIncludeVpn.exception"));
            this.responseResult(this.getText("com.hs.vsm.secservice.ddos.policy.operation.vpn.syncIncludeVpn.exception"));
        }
        ISysOptLog sysOptLog = ZoneReferUtil.getSysOptLog();
        sysOptLog.writeOptLog(syncIncludeLog);
        this.responseResult("success");
    }

    private String getZoneName(Long zoneID) {
        IZoneService zoneService = ZoneUtil.getZoneService();
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        ZoneInfoForm zoneInfoForm = zoneService.getById(zoneID);
        String zoneName = zoneInfoForm.getZoneName();
        return zoneName;
    }

    private void initDeviceList() {
        this.vpnZoneDeviceList = new ArrayList<LangPair>();
        IZoneDeviceService zoneDeviceService = ZoneReferUtil.getZoneDeviceService();
        IAticDeviceService fwService = ZoneReferUtil.getFirewallService();
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        List zoneDeviceFormsList = zoneDeviceService.queryZoneDeviceFormsByZoneID(this.zoneId);
        if (!zoneDeviceFormsList.isEmpty()) {
            for (ZoneDeviceForm form : zoneDeviceFormsList) {
                AticDevice ne = fwService.getDeviceByMoid(form.getDeviceId().longValue());
                this.vpnZoneDeviceList.add(new LangPair(ne.getName(), form.getDeviceId().toString()));
            }
            this.vpnZoneDeviceLabel = this.vpnZoneDeviceList.get(0).getLabel();
            this.vpnZoneDeviceValue = this.vpnZoneDeviceList.get(0).getValue();
        }
    }

    public String pagingIncludeVpn() {
        Map<String, String> queryMap = this.getVpnConditions();
        IVpnDeviceService vpnDeviceService = ZoneReferUtil.getVpnDeviceService();
        Paging result = vpnDeviceService.queryByPage(queryMap, this.start, this.pageSize);
        this.includeVpnList = result.getData();
        this.total = result.getCount();
        this.getSession().setAttribute("pageSize", (Object)this.pageSize);
        this.getSession().setAttribute("start", (Object)this.start);
        return "success";
    }

    public String pagingExcludeVpn() {
        Map<String, String> queryMap = this.getVpnConditions();
        IVpnDeviceService vpnDeviceService = ZoneReferUtil.getVpnDeviceService();
        Paging result = vpnDeviceService.queryByPage(queryMap, this.start, this.pageSize);
        this.excludeVpnList = result.getData();
        this.total = result.getCount();
        this.getSession().setAttribute("pageSize", (Object)this.pageSize);
        this.getSession().setAttribute("start", (Object)this.start);
        return "success";
    }

    private Map<String, String> getVpnConditions() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.zoneId != null && this.zoneId > 0L) {
            Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            queryMap.put("zoneId", this.zoneId.toString());
        }
        if (this.vpnType != null && !"".equals(this.vpnType)) {
            queryMap.put("vpnType", this.vpnType.trim());
        }
        if (this.vpnIp != null && !"".equals(this.vpnIp)) {
            queryMap.put("vpnIp", this.vpnIp.trim());
        }
        if (this.vpnName != null && !"".equals(this.vpnName)) {
            queryMap.put("vpnName", this.vpnName.trim());
        }
        return queryMap;
    }

    public List<VpnDeviceForm> getIncludeVpnList() {
        return this.includeVpnList;
    }

    public void setIncludeVpnList(List<VpnDeviceForm> includeVpnList) {
        this.includeVpnList = includeVpnList;
    }

    public List<VpnDeviceForm> getExcludeVpnList() {
        return this.excludeVpnList;
    }

    public void setExcludeVpnList(List<VpnDeviceForm> excludeVpnList) {
        this.excludeVpnList = excludeVpnList;
    }

    public String getVpnName() {
        return this.vpnName;
    }

    public void setVpnName(String vpnName) {
        this.vpnName = vpnName;
    }

    public String getVpnIp() {
        return this.vpnIp;
    }

    public void setVpnIp(String vpnIp) {
        this.vpnIp = vpnIp;
    }

    public String getVpnType() {
        return this.vpnType;
    }

    public void setVpnType(String vpnType) {
        this.vpnType = vpnType;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public List<LangPair> getVpnZoneDeviceList() {
        return this.vpnZoneDeviceList;
    }

    public void setVpnZoneDeviceList(List<LangPair> vpnZoneDeviceList) {
        this.vpnZoneDeviceList = vpnZoneDeviceList;
    }

    public String getVpnZoneDeviceLabel() {
        return this.vpnZoneDeviceLabel;
    }

    public void setVpnZoneDeviceLabel(String vpnZoneDeviceLabel) {
        this.vpnZoneDeviceLabel = vpnZoneDeviceLabel;
    }

    public String getVpnZoneDeviceValue() {
        return this.vpnZoneDeviceValue;
    }

    public void setVpnZoneDeviceValue(String vpnZoneDeviceValue) {
        this.vpnZoneDeviceValue = vpnZoneDeviceValue;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public Integer getZoneMask() {
        return this.zoneMask;
    }

    public void setZoneMask(Integer zoneMask) {
        this.zoneMask = zoneMask;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public String getDeviceVpnName() {
        return this.deviceVpnName;
    }

    public void setDeviceVpnName(String deviceVpnName) {
        this.deviceVpnName = deviceVpnName;
    }

    public String[] getDeleteIdList() {
        if (null != this.deleteIdList) {
            return (String[])this.deleteIdList.clone();
        }
        return new String[0];
    }

    public void setDeleteIdList(String[] deleteIdList) {
        this.deleteIdList = null != deleteIdList ? (String[])deleteIdList.clone() : null;
    }

    public boolean validatePageSize() {
        String page = String.valueOf(this.pageSize);
        String regex = "^(10|20|30|50|100)$";
        return page.matches(regex);
    }

    public boolean validateVpnIp() {
        if ("".equals(this.vpnIp) || null == this.vpnIp) {
            return true;
        }
        return IPUtil.isIpv4((String)this.vpnIp.trim()) || IPUtil.isIpv6((String)this.vpnIp.trim());
    }

    public boolean validateVpnName() {
        if ("".equals(this.vpnName) || null == this.vpnName) {
            return true;
        }
        String regex = "^(?!(?i)null$)[\\w|\u4e00-\u9fa5|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\{]{1,31}$";
        return this.vpnName.matches(regex);
    }

    public boolean validateZoneIp() {
        if (null == this.zoneIp) {
            return true;
        }
        if ("".equals(this.zoneIp)) {
            return false;
        }
        return IPUtil.isIpv4((String)this.zoneIp.trim()) || IPUtil.isIpv6((String)this.zoneIp.trim());
    }

    public boolean validateDeleteIdList() {
        if (null != this.deleteIdList && this.deleteIdList.length == 0) {
            return false;
        }
        long id = 0L;
        if (null != this.deleteIdList) {
            if (this.deleteIdList.length > 100) {
                return false;
            }
            for (int i = 0; i < this.deleteIdList.length; ++i) {
                try {
                    id = Long.parseLong(this.deleteIdList[i]);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (id >= 1L) continue;
                return false;
            }
        }
        return true;
    }
}

