/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.service.IAticCommonUtilService;
import com.hs.atic.sdk.bis.service.IBaselineDataService;
import com.hs.atic.sdk.util.TimeTransferUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.action.ZoneBaselineAction;
import com.hs.vsm.secservice.ddos.policy.beans.PrintBean;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.DevCapUtil;
import com.hs.vsm.secservice.ddos.policy.util.JfreeChartTool;
import com.hs.vsm.secservice.ddos.policy.util.TimeSeriesReport;
import com.hs.vsm.secservice.nfa.util.NfaClusterUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.capability.model.ParaBean;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ZoneBaselineDetailAction
extends BaseAction {
    private static final long serialVersionUID = -4987251112150472898L;
    private static final long NUM_24L = 24L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String isQuery = "false";
    private String image;
    private ParaBean paraBean;
    private int maxLength;
    private Boolean isServiceBaseline;
    private long realBizId;
    private long realZoneId;
    private String realDevIp;
    private int realDevType;
    private long thisPeridEndTime;
    private Long studyId;
    private String endTime;
    private Long serviceId;
    private String fieldName;
    private Long zoneId;
    private String deviceIp;
    private String currentValue;
    private String currentValueUnit;
    private String startTime;
    private Long period;
    private String baseValue;
    private String voteValue;
    private String stopTime;
    private Boolean hasStart;
    private Boolean isNFA;
    private int direction;

    public String baselineDetail() {
        logger.info((Object)"baselineDetail is execute");
        List<TimeSeriesReport> detail = this.getDetail();
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        AticDevice aticDevice = aticDeviceService.getDeviceByIp(this.deviceIp);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(aticDevice.getMoId());
        BisUtil.checkUserSecurity(moIdList);
        String oldCurrnetVauleUnit = this.currentValue;
        if (aticDevice.getDeviceType() == 8 || aticDevice.getDeviceType() == 9) {
            this.isNFA = true;
            if (this.fieldName.contains("PpsThreshold")) {
                this.paraBean.setParaUnit("pps");
                this.paraBean.setParaRange("1-2,147,483,647");
            }
            if (null != this.currentValueUnit) {
                if (this.currentValueUnit.equalsIgnoreCase("Kpps")) {
                    this.currentValue = String.valueOf(Long.parseLong(this.currentValue) * 1000L);
                } else if (this.currentValueUnit.equalsIgnoreCase("Mpps")) {
                    this.currentValue = String.valueOf(Long.parseLong(this.currentValue) * 1000L * 1000L);
                } else if (this.currentValueUnit.equalsIgnoreCase("Gpps")) {
                    this.currentValue = String.valueOf(Long.parseLong(this.currentValue) * 1000L * 1000L * 1000L);
                }
            }
        }
        List<TimeSeriesReport> currentLine = this.getline(detail, Long.parseLong(this.currentValue));
        List<TimeSeriesReport> voteLine = this.getline(detail, Long.parseLong(this.voteValue));
        ArrayList<PrintBean> beans = new ArrayList<PrintBean>();
        PrintBean p1 = new PrintBean();
        p1.setName(this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.study.nowValue"));
        p1.setValues(currentLine);
        PrintBean p2 = new PrintBean();
        p2.setName(this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.study.flux"));
        p2.setValues(detail);
        PrintBean p3 = new PrintBean();
        p3.setName(this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.study.voteValue"));
        p3.setValues(voteLine);
        beans.add(p1);
        beans.add(p2);
        beans.add(p3);
        this.endTime = TimeTransferUtil.transferlong2String(this.thisPeridEndTime * 1000L);
        this.currentValue = oldCurrnetVauleUnit;
        try {
            String valueAxisLabel = "";
            if (null != this.paraBean) {
                valueAxisLabel = this.paraBean.getParaUnit();
                if (!AticUtil.isNull((String)valueAxisLabel) && valueAxisLabel.contains("com.hs.vsm.secservice.ddos.percent")) {
                    valueAxisLabel = this.getText("com.hs.vsm.secservice.ddos.percent");
                } else if (!AticUtil.isNull((String)valueAxisLabel) && valueAxisLabel.contains("com.hs.vsm.secservice.ddos.item")) {
                    valueAxisLabel = this.getText("com.hs.vsm.secservice.ddos.item");
                } else if (!AticUtil.isNull((String)valueAxisLabel) && valueAxisLabel.contains(".")) {
                    valueAxisLabel = this.getText("com.hs.vsm.secservice.ddos.connections.second");
                }
            }
            this.image = this.fetchRequest().getContextPath() + "/servlet/DisplayChart?filename=" + JfreeChartTool.getInstance().displayTimeSeriesChart(beans, this.getText("com.hs.vsm.secservice.ddos.baseline.image.title"), "", valueAxisLabel, this.getSession());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"baseline detail error");
            this.image = "";
        }
        return "success";
    }

    public void queryDetail() {
        if (StringUtils.equals((CharSequence)"success", (CharSequence)this.baselineDetail())) {
            this.responseResult(this.image);
        }
    }

    private List<TimeSeriesReport> getline(List<TimeSeriesReport> detail, Long value) {
        ArrayList<TimeSeriesReport> result = new ArrayList<TimeSeriesReport>();
        if (!detail.isEmpty()) {
            TimeSeriesReport start = new TimeSeriesReport();
            TimeSeriesReport end = new TimeSeriesReport();
            start.setValue(value);
            end.setValue(value);
            start.setMonitorTime(detail.get(0).getMonitorTime());
            end.setMonitorTime(detail.get(detail.size() - 1).getMonitorTime());
            result.add(start);
            result.add(end);
        }
        return result;
    }

    private List<TimeSeriesReport> getDetail() {
        ArrayList<TimeSeriesReport> result = new ArrayList<TimeSeriesReport>();
        Map<Object, Object> metaData = new HashMap();
        if (this.isServiceBaseline.booleanValue()) {
            metaData = this.getBaselineMetaData();
            this.hasParasDiff(this.fieldName);
        }
        if (null != metaData && !metaData.isEmpty()) {
            ZoneServiceForm zoneServiceForm = null;
            if ("synratioLimitPackets".equals(this.fieldName)) {
                zoneServiceForm = (ZoneServiceForm)ZoneReferUtil.getZoneServiceService().query(this.serviceId);
                int interval = zoneServiceForm.getCurrentValue("synratioDuration");
                for (Map.Entry<Object, Object> entry : metaData.entrySet()) {
                    TimeSeriesReport point = new TimeSeriesReport();
                    point.setMonitorTime(new Date((Long)entry.getKey()));
                    long detailValue = (Long)entry.getValue();
                    if (0 != interval) {
                        detailValue = (int)Math.ceil(Double.valueOf(detailValue) / 10.0 * (double)interval);
                    }
                    point.setValue(detailValue);
                    result.add(point);
                }
            } else {
                for (Map.Entry<Object, Object> entry : metaData.entrySet()) {
                    TimeSeriesReport point = new TimeSeriesReport();
                    point.setMonitorTime(new Date((Long)entry.getKey()));
                    point.setValue((Long)entry.getValue());
                    result.add(point);
                }
            }
        } else {
            TimeSeriesReport point = new TimeSeriesReport();
            long startTimeLong = TimeTransferUtil.convertString2Long(this.startTime);
            point.setMonitorTime(new Date(startTimeLong * 1000L));
            point.setValue(0L);
            result.add(point);
            point = new TimeSeriesReport();
            point.setMonitorTime(new Date(this.thisPeridEndTime * 1000L));
            point.setValue(0L);
            result.add(point);
        }
        Collections.sort(result, new InnerClass());
        return result;
    }

    private Map<Long, Long> getBaselineMetaData() {
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        ICommonUtilService mgr = ZoneReferUtil.getCommonUtilService();
        String version = mgr.getDDoSVersion(this.deviceIp);
        queryMap.put("version", version);
        queryMap.put("deviceIp", this.deviceIp);
        queryMap.put("zoneId", this.zoneId.toString());
        queryMap.put("bizId", this.serviceId.toString());
        queryMap.put("fieldName", this.fieldName);
        queryMap.put("realBizId", this.realBizId + "");
        queryMap.put("realZoneId", this.realZoneId + "");
        queryMap.put("realdevIp", this.realDevIp);
        queryMap.put("realDevType", this.realDevType + "");
        queryMap.put("studyId", this.studyId.toString());
        queryMap.put("direction", this.direction + "");
        SimpleDateFormat starTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!this.isQuery.equals("true")) {
            this.thisPeridEndTime = System.currentTimeMillis() / 1000L;
            long daySeconds = 86400L;
            this.startTime = starTime.format((Object)new Date((this.thisPeridEndTime - daySeconds) * 1000L));
        } else {
            this.thisPeridEndTime = TimeTransferUtil.convertString2Long(this.stopTime);
        }
        long startTimeLong = TimeTransferUtil.convertString2Long(this.startTime);
        queryMap.put("startTime", startTimeLong + "");
        queryMap.put("endTime", this.thisPeridEndTime + "");
        queryMap.put("tableSuffix", this.getTableSuffix(startTimeLong, this.thisPeridEndTime));
        IBaselineDataService baseLineStudyService = ZoneReferUtil.getBaselineDataService();
        Map<Long, Long> resultMap = baseLineStudyService.getBaselineMetaData(queryMap);
        if (null != resultMap && !resultMap.isEmpty()) {
            int timeSpan = this.getTimeSpan((String)queryMap.get("tableSuffix"));
            ArrayList<Long> timeList = new ArrayList<Long>();
            for (Map.Entry<Long, Long> entry : resultMap.entrySet()) {
                timeList.add(entry.getKey());
            }
            Collections.sort(timeList);
            try {
                this.fillContinuousTime(timeList, timeSpan, resultMap);
            }
            catch (Exception e) {
                logger.error((Object)("query BaselineDetail error." + e.getMessage()));
            }
        }
        return resultMap;
    }

    private void fillContinuousTime(List<Long> timeList, int timeSpan, Map<Long, Long> resultMap) {
        if (null != timeList && !timeList.isEmpty()) {
            for (int i = 0; i <= timeList.size() && i != timeList.size() - 1; ++i) {
                Long startTimeLong = timeList.get(i);
                Long nextTime = timeList.get(i + 1);
                long timeGap = nextTime - startTimeLong;
                if (timeGap <= Long.parseLong(timeSpan * 2 + "")) continue;
                HashMap<Long, Long> resultMapSec = new HashMap<Long, Long>();
                int j = 1;
                do {
                    startTimeLong = startTimeLong + (long)timeSpan;
                    resultMapSec.put(startTimeLong, 0L);
                } while ((long)(++j) < timeGap / (long)timeSpan);
                resultMap.putAll(resultMapSec);
            }
        }
    }

    private int getTimeSpan(String tableSuffix) {
        if ("D".equals(tableSuffix)) {
            return 86400000;
        }
        return 300000;
    }

    private String getTableSuffix(long startTimeLong, long endTimeLong) {
        IAticCommonUtilService aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
        int dayConf = aticCommonUtilService.getDayTableInterval();
        if (endTimeLong - startTimeLong > (long)dayConf * 24L * 3600L) {
            return "D";
        }
        return "M";
    }

    public void hasParasDiff(String id) {
        String policyItem;
        Map<String, String> serviceItemMap = Constant.getPolicyItemMap();
        AticDevice device = ZoneReferUtil.getDeviceByIp(this.deviceIp);
        if (device.getDeviceType() == 9) {
            device = NfaClusterUtil.getNfaDeviceInfo(device.getMoId());
        }
        if (null == (policyItem = serviceItemMap.get(id))) {
            policyItem = id;
        }
        this.paraBean = DevCapUtil.getInstance().hasParasDiff(policyItem, device.getMoId(), "DEFAULT");
        if (null == this.paraBean) {
            return;
        }
        if (this.paraBean.getMaxVal() / 10 > 0) {
            this.maxLength = 2;
        }
        if (this.paraBean.getMaxVal() / 100 > 0) {
            this.maxLength = 3;
        }
        if (this.paraBean.getMaxVal() / 1000 > 0) {
            this.maxLength = 4;
        }
        if (this.paraBean.getMaxVal() / 10000 > 0) {
            this.maxLength = 5;
        }
        if (this.paraBean.getMaxVal() / 100000 > 0) {
            this.maxLength = 6;
        }
        if (this.paraBean.getMaxVal() / 1000000 > 0) {
            this.maxLength = 7;
        }
        if (this.paraBean.getMaxVal() / 10000000 > 0) {
            this.maxLength = 8;
        }
    }

    private Map<String, String> getOpeMap() {
        HashMap<String, String> opeMap = new HashMap<String, String>();
        opeMap.put("alertSpeed", "udpFloodAlertSpeed");
        opeMap.put("fragAlertSpeed", "udpFragAlertSpeed");
        opeMap.put("alertRate", "dnsRequsetAlertRate");
        opeMap.put("replyFloodAlertRate", "dnsReplyFloodAlertRate");
        opeMap.put("fingerAlert", "otherFingerAlert");
        return opeMap;
    }

    public void saveZonePolicyItem() {
        ZoneInfoForm zoneInfoForm;
        ArrayList<Long> moIdList;
        Long moId;
        long zoneID;
        ZoneServiceForm form;
        logger.info((Object)"saveZonePolicyItem is execute");
        if (this.isServiceBaseline.booleanValue()) {
            form = (ZoneServiceForm)ZoneReferUtil.getZoneServiceService().query(this.serviceId);
            form.setCurrentValue(this.fieldName, Integer.parseInt(this.currentValue), this.currentValueUnit);
            ZoneReferUtil.getZoneServiceService().save(form);
            zoneID = form.getZoneId();
            moId = ZoneBisUtil.getMoidByZoneid(zoneID);
            moIdList = new ArrayList();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(zoneID);
            StringBuffer zoneName = new StringBuffer(zoneInfoForm.getZoneDesc()).append("(").append(form.getServiceName()).append(")");
            Map<String, String> opeMap = this.getOpeMap();
            String opeString = opeMap.get(this.fieldName);
            if (!AticUtil.isNull((String)opeString)) {
                this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.confirmBaselineTask", "lego.dic.module.ddosApp", false, new String[]{opeString, this.currentValue}, "com.hs.vsm.secservice.ddos.policy.operation.detail.confirmBaselineTask", zoneName.toString(), SysoplogLevel.info.getValue(), true, null);
            } else {
                this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.confirmBaselineTask", "lego.dic.module.ddosApp", false, new String[]{this.fieldName, this.currentValue}, "com.hs.vsm.secservice.ddos.policy.operation.detail.confirmBaselineTask", zoneName.toString(), SysoplogLevel.info.getValue(), true, null);
            }
        } else {
            form = (ZoneServiceForm)ZoneReferUtil.getZoneServiceService().query(this.serviceId);
            ZoneReferUtil.getZoneServiceService().save(form);
            zoneID = form.getZoneId();
            moId = ZoneBisUtil.getMoidByZoneid(zoneID);
            moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(zoneID);
            String zoneName = zoneInfoForm.getZoneDesc();
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.name.confirmBaselineTask", "lego.dic.module.ddosApp", false, new String[]{this.fieldName, this.currentValue}, "com.hs.vsm.secservice.ddos.policy.operation.detail.confirmBaselineTask", zoneName, SysoplogLevel.info.getValue(), true, null);
        }
        ArrayList<Long> zoneIds = new ArrayList<Long>();
        zoneIds.add(zoneID);
        IZonePolicyMgrService zonePolicyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        HashMap<String, String> requestUserMap = new HashMap<String, String>();
        requestUserMap.put("requestUserName", currentUser.getUserName());
        requestUserMap.put("requestTerminalIp", this.fetchRequest().getRemoteAddr());
        zonePolicyMgrService.setRequestUserMap(requestUserMap);
        zonePolicyMgrService.deploy(zoneIds, System.currentTimeMillis() / 1000L);
        logger.info((Object)"saveZonePolicyItem is success");
        this.responseResult("success");
    }

    public ParaBean getParaBean() {
        return this.paraBean;
    }

    public void setParaBean(ParaBean paraBean) {
        this.paraBean = paraBean;
    }

    public String getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(String stopTime) {
        this.stopTime = stopTime;
    }

    public Boolean getHasStart() {
        return this.hasStart;
    }

    public void setHasStart(Boolean hasStart) {
        this.hasStart = hasStart;
    }

    public Boolean getIsServiceBaseline() {
        return this.isServiceBaseline;
    }

    public void setIsServiceBaseline(Boolean isServiceBaseline) {
        this.isServiceBaseline = isServiceBaseline;
    }

    public String getIsQuery() {
        return this.isQuery;
    }

    public void setIsQuery(String isQuery) {
        this.isQuery = isQuery;
    }

    public long getStudyId() {
        return this.studyId;
    }

    public void setStudyId(long studyId) {
        this.studyId = studyId;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public long getThisPeridEndTime() {
        return this.thisPeridEndTime;
    }

    public void setThisPeridEndTime(long thisPeridEndTime) {
        this.thisPeridEndTime = thisPeridEndTime;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public Long getPeriod() {
        return this.period;
    }

    public void setPeriod(Long period) {
        this.period = period;
    }

    public long getRealBizId() {
        return this.realBizId;
    }

    public void setRealBizId(long realBizId) {
        this.realBizId = realBizId;
    }

    public long getRealZoneId() {
        return this.realZoneId;
    }

    public void setRealZoneId(long realZoneId) {
        this.realZoneId = realZoneId;
    }

    public String getRealDevIp() {
        return this.realDevIp;
    }

    public void setRealDevIp(String realDevIp) {
        this.realDevIp = realDevIp;
    }

    public int getRealDevType() {
        return this.realDevType;
    }

    public void setRealDevType(int realDevType) {
        this.realDevType = realDevType;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public String getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(String baseValue) {
        this.baseValue = baseValue;
    }

    public String getVoteValue() {
        return this.voteValue;
    }

    public void setVoteValue(String voteValue) {
        this.voteValue = voteValue;
    }

    public String getCurrentValueUnit() {
        return this.currentValueUnit;
    }

    public void setCurrentValueUnit(String currentValueUnit) {
        this.currentValueUnit = currentValueUnit;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Boolean getIsNFA() {
        return this.isNFA;
    }

    public void setIsNFA(Boolean isNFA) {
        this.isNFA = isNFA;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public boolean validateDeviceIp() {
        return new ZoneBaselineAction().validateDeviceIp();
    }

    public boolean validateVoteValue() {
        String valueTemp = this.voteValue;
        long value = 0L;
        if (null == valueTemp) {
            return true;
        }
        try {
            value = Long.parseLong(valueTemp);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return value >= 0L;
    }

    public boolean validateBaseValue() {
        String valueTemp = this.baseValue;
        long value = 0L;
        if (null == valueTemp) {
            return true;
        }
        try {
            value = Long.parseLong(valueTemp);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return value >= 0L;
    }

    public boolean validateCurrentValueUnit() {
        if (null == this.currentValueUnit || "".equals(this.currentValueUnit)) {
            return true;
        }
        String regex = "^(Kpps|Mpps|Gpps|pps|Kbps|Mbps|Gbps|qps|Mbit\\/s|com.hs.vsm.secservice.ddos.connections|com.hs.vsm.secservice.ddos.connections.second|com.hs.vsm.secservice.ddos.second|com.hs.vsm.secservice.ddos.item|com.hs.vsm.secservice.ddos.percent)$";
        return this.currentValueUnit.matches(regex);
    }

    public boolean validateRealDevIp() {
        if (null == this.realDevIp) {
            return true;
        }
        return IPUtil.isIpv4((String)this.realDevIp.trim()) || IPUtil.isIpv6((String)this.realDevIp.trim());
    }

    public boolean validateStudyId() {
        if (null == this.studyId) {
            return true;
        }
        return this.studyId >= 1L;
    }

    public boolean validateCurrentValue() {
        long value = 0L;
        try {
            value = Long.parseLong(this.currentValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        AticDevice aticDevice = aticDeviceService.getDeviceByIp(this.deviceIp);
        if (aticDevice.getDeviceType() == 8 || aticDevice.getDeviceType() == 9) {
            this.isNFA = true;
        }
        return !(null != this.isNFA && this.isNFA != false ? value < 0L || value > Integer.MAX_VALUE : value < 0L || value > 80000000L);
    }

    public boolean validateStartTime() {
        String date = this.startTime;
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateStopTime() {
        String date = this.stopTime;
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateStopTimeMayNull() {
        String date = this.stopTime;
        if (null == date || "".equals(date)) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateHasStart() {
        if (null == this.hasStart) {
            return true;
        }
        String regEx = "^(true|false)*$";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(String.valueOf(this.hasStart));
        return m.matches();
    }

    private static class InnerClass<T>
    implements Comparator<TimeSeriesReport>,
    Serializable {
        private static final long serialVersionUID = 1512314887057744547L;

        private InnerClass() {
        }

        @Override
        public int compare(TimeSeriesReport o1, TimeSeriesReport o2) {
            return o2.getMonitorTime().compareTo(o1.getMonitorTime());
        }
    }
}

