/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.atic.zone.util.ImportZoneConstant;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.action.ViewAllFilterAction;
import com.hs.vsm.secservice.ddos.policy.beans.TreeNode;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneIpLocationService;
import com.restful.util.JacksonNullProviderUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.BeanUtils;

public class ZoneIpLocationAction
extends BaseAction {
    private static final long serialVersionUID = 1498087888052655876L;
    private static final String LOCATION_CUSTOM = "Location_Custom";
    private static final String CHINA_CN = "cn";
    private static final String CHINA_CN_TEMP = "acn";
    private static final String UNKNOWN_OTHER = "other";
    private static final String LOCATION = "location";
    private static final String UNKNOWN_OTHER_TEMP = "aaother";
    private static final String LOCATION_IMAGE_PATH = "/vsm/atic/resource/skins/images/nationalFlag/";
    private static final String IMAGE_SUFFIX = ".gif";
    private static final String SPRIT = "/";
    private static final long LOCATION_MASK_CHINA = 0x1000000L;
    private static final long LOCATION_MASK_CHINA_TAIPEI = 0x1220100L;
    private static final long LOCATION_MASK_UNKNOWN = 0L;
    private static final int STRING_LENGTH = 255;
    private static final String REGEX = "^acn5\\d{2}$";
    private static final String REG = "^/{2,}$";
    private static final int IPLOCATION_MAX = 33;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String locationName;
    private List<IpLocation> ipLocationList;
    private Map<String, String> ipLocationNameMap = new HashMap<String, String>();
    private List<ZoneIpLocationForm> zoneIpLocationFormList;
    private String[] saveList;
    private String locationNameEn;
    private Long locationId;
    private String language;
    private String[] locationNameList;
    private String helpLanguage = "";
    private List<LangPair> locationActionList;
    private ZoneIpLocationForm zoneIpLocationForm;
    private String locationActionValue;
    private String locationActionLabel;
    private Integer locationAction;
    private Integer locationLimit;
    private Long id;
    private Long zoneId;
    private transient IZoneIpLocationService zoneIpLocationService;
    private String json;
    private String[] selectedNodeNames;
    private List<String> zoneIpLocationNameFormList;
    private Map<String, IpLocation> ipLocationMap;
    private transient ILibraryFileService libraryFileService;

    public String pagingZoneIpLocation() {
        String languageStr = LocaleUtil.getInstance().getCurrentUserLocale().getLanguage();
        if ("zh".equalsIgnoreCase(languageStr)) {
            this.setHelpLanguage("zh_cn");
        } else {
            this.setHelpLanguage("en");
        }
        languageStr = LocaleUtil.getInstance().getCurrentUserLocale().getLanguage();
        List<ZoneIpLocationForm> temp = this.getSessionZoneIpLocation();
        if (temp != null) {
            for (ZoneIpLocationForm zoneIpLocationFo : temp) {
                zoneIpLocationFo.setLocationNameEn(zoneIpLocationFo.getLocationNameEn().indexOf(SPRIT) == 0 ? zoneIpLocationFo.getLocationNameEn().replaceFirst(SPRIT, "") : zoneIpLocationFo.getLocationNameEn());
                zoneIpLocationFo.setLocationNameZh(zoneIpLocationFo.getLocationNameZh().indexOf(SPRIT) == 0 ? zoneIpLocationFo.getLocationNameZh().replaceFirst(SPRIT, "") : zoneIpLocationFo.getLocationNameZh());
            }
            this.total = temp.size();
            this.zoneIpLocationFormList = temp.subList(this.start, this.total < this.start + this.pageSize ? this.total : this.start + this.pageSize);
            String shortName = "";
            Pattern p = Pattern.compile(REGEX);
            for (ZoneIpLocationForm form : this.zoneIpLocationFormList) {
                String string = shortName = PolicyUtil.isNull(form.getShortName()) ? LOCATION : form.getShortName().toLowerCase(Locale.getDefault());
                if (p.matcher(shortName).find()) {
                    shortName = CHINA_CN;
                }
                form.setShortName(shortName);
                form.setLanguage(languageStr);
            }
        } else {
            this.total = 0;
        }
        return "success";
    }

    public ILibraryFileService getLibraryFileService() {
        return this.libraryFileService;
    }

    public void setLibraryFileService(ILibraryFileService libraryFileService) {
        this.libraryFileService = libraryFileService;
    }

    private List<ZoneIpLocationForm> getSessionZoneIpLocation() {
        String sessionId = this.getSession().getId();
        return (List)this.getSession().getAttribute("zoneIpLocationList" + sessionId);
    }

    private void setSessionZoneIpLocation(List<ZoneIpLocationForm> list) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute("zoneIpLocationList" + sessionId, list);
    }

    private void setSessionIpNameMap(Map<String, IpLocation> map) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute("zoneIpLocationNameMap" + sessionId, map);
    }

    private Map<String, IpLocation> getSessionIpNameMap() {
        String sessionId = this.getSession().getId();
        return (Map)this.getSession().getAttribute("zoneIpLocationNameMap" + sessionId);
    }

    private List<String> getSessionZoneIpLocationName() {
        String sessionId = this.getSession().getId();
        return (List)this.getSession().getAttribute("zoneIpLocationNameList" + sessionId);
    }

    private void setSessionZoneIpLocationName(List<String> list) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute("zoneIpLocationNameList" + sessionId, list);
    }

    public String addIpLocation() {
        this.initLocationActionList(true, this.zoneIpLocationForm);
        this.language = LocaleUtil.getInstance().getCurrentUserLocale().getLanguage();
        this.initIpLocationMapAndIpLocationNameMap();
        this.removeSelectedIpLocation();
        HashMap<String[], String> locaMap = new HashMap<String[], String>();
        for (Map.Entry<String, String> entry : this.ipLocationNameMap.entrySet()) {
            String[] ipLocationStr = entry.getKey().split(SPRIT);
            locaMap.put(ipLocationStr, entry.getValue());
        }
        ArrayList<Map.Entry<String[], String>> list = new ArrayList<Map.Entry<String[], String>>(locaMap.entrySet());
        MyComparator myComparator = new MyComparator();
        Collections.sort(list, myComparator);
        List<TreeNode> ipLocationTree = this.searchIpLocation(list);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializerProvider((DefaultSerializerProvider)new JacksonNullProviderUtil());
        try {
            this.json = mapper.writeValueAsString(ipLocationTree);
        }
        catch (JsonProcessingException e) {
            logger.error((Object)("JsonProcessingException:" + e.getMessage()));
        }
        this.fetchRequest().setAttribute("json", (Object)this.json);
        return "success";
    }

    private void initIpLocationMapAndIpLocationNameMap() {
        Map<Long, IpLocation> map = this.libraryFileService.getIpLocationMap();
        this.ipLocationList = new ArrayList<IpLocation>(map.values());
        if (null == this.ipLocationMap) {
            this.ipLocationMap = new HashMap<String, IpLocation>();
        }
        for (IpLocation ipLoca : this.ipLocationList) {
            IpLocation temp = new IpLocation();
            BeanUtils.copyProperties((Object)ipLoca, (Object)temp);
            if (LOCATION_CUSTOM.equals(temp.getLocationType())) {
                temp.setShortName(LOCATION);
                if (-1 == temp.getLocationNameEn().indexOf(SPRIT)) {
                    temp.setLocationNameEn(SPRIT + temp.getLocationNameEn());
                }
                if (-1 == temp.getLocationNameZh().indexOf(SPRIT)) {
                    temp.setLocationNameZh(SPRIT + temp.getLocationNameZh());
                }
            } else {
                if (temp.getLocationMask() == 0L) {
                    temp.setShortName(UNKNOWN_OTHER_TEMP);
                }
                if (temp.getLocationMask() > 0x1000000L && temp.getLocationMask() <= 0x1220100L) {
                    temp.setShortName(CHINA_CN_TEMP + temp.getLocationId());
                }
            }
            if ("zh".equalsIgnoreCase(this.language)) {
                this.ipLocationNameMap.put(temp.getLocationNameZh(), temp.getShortName().toLowerCase(Locale.ENGLISH));
            } else {
                this.ipLocationNameMap.put(temp.getLocationNameEn(), temp.getShortName().toLowerCase(Locale.ENGLISH));
            }
            this.ipLocationMap.put(temp.getLocationNameZh(), temp);
            this.ipLocationMap.put(temp.getLocationNameEn(), temp);
        }
        this.setSessionIpNameMap(this.ipLocationMap);
    }

    private void initLocationActionList(boolean isAdd, ZoneIpLocationForm zoneIpLocationForms) {
        this.locationActionList = new ArrayList<LangPair>();
        this.locationActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.location.action.pass"), String.valueOf(1)));
        this.locationActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.location.action.block"), String.valueOf(2)));
        this.locationActionList.add(new LangPair(this.getText("com.hs.vsm.secservice.ddos.location.action.limit"), String.valueOf(3)));
        this.setActionLabelAndValue(isAdd ? Integer.valueOf(2) : zoneIpLocationForms.getLocationAction());
    }

    private void setActionLabelAndValue(Integer value) {
        switch (value) {
            case 1: {
                this.setLocationActionLabel(this.getText("com.hs.vsm.secservice.ddos.location.action.pass"));
                this.setLocationActionValue(String.valueOf(1));
                break;
            }
            case 2: {
                this.setLocationActionLabel(this.getText("com.hs.vsm.secservice.ddos.location.action.block"));
                this.setLocationActionValue(String.valueOf(2));
                break;
            }
            case 3: {
                this.setLocationActionLabel(this.getText("com.hs.vsm.secservice.ddos.location.action.limit"));
                this.setLocationActionValue(String.valueOf(3));
                break;
            }
        }
    }

    public void saveIpLocation() {
        ArrayList<String> nameTem = new ArrayList<String>();
        ArrayList<IpLocation> iList = new ArrayList<IpLocation>();
        this.ipLocationMap = this.getSessionIpNameMap();
        if (this.selectedNodeNames == null || this.selectedNodeNames.length == 0) {
            this.responseResult("isnull");
            return;
        }
        for (String name : this.selectedNodeNames) {
            if (AticUtil.isNull((String)name)) {
                this.responseResult("tomuch");
                return;
            }
            iList.add(this.ipLocationMap.get(name));
            name = name.indexOf(SPRIT) == 0 ? name.replaceFirst(SPRIT, "") : name;
            nameTem.add(name);
        }
        if (this.getLocationAction() == 3) {
            this.validateThreshold();
        }
        this.language = LocaleUtil.getInstance().getCurrentUserLocale().getLanguage();
        List<ZoneIpLocationForm> sessionZoneIpLocation = this.getSessionZoneIpLocation();
        if (sessionZoneIpLocation == null) {
            sessionZoneIpLocation = new ArrayList<ZoneIpLocationForm>();
        }
        if (sessionZoneIpLocation.isEmpty()) {
            ZoneIpLocationForm form = new ZoneIpLocationForm();
            form.setLocationId(ImportZoneConstant.OTHER_LOCATION_ID);
            form.setLocationNameEn("OtherLocation");
            form.setLocationNameZh("OtherLocation");
            form.setShortName("Other");
            form.setLocationAction(1);
            sessionZoneIpLocation.add(form);
        }
        ArrayList<ZoneIpLocationForm> sessionZoneIpLocationTemp = new ArrayList<ZoneIpLocationForm>();
        for (IpLocation ipLocation : iList) {
            ZoneIpLocationForm form = new ZoneIpLocationForm();
            form.setLocationId(ipLocation.getLocationId());
            form.setLocationNameEn(ipLocation.getLocationNameEn());
            form.setLocationNameZh(ipLocation.getLocationNameZh());
            String shortName = ipLocation.getShortName();
            if (shortName.contains(UNKNOWN_OTHER)) {
                shortName = UNKNOWN_OTHER;
            }
            if (shortName.contains(CHINA_CN)) {
                shortName = CHINA_CN;
            }
            form.setShortName(shortName);
            form.setLocationAction(this.getLocationAction());
            form.setLocationLimit(this.getLocationLimit());
            form.setLanguage(this.language);
            if (this.getLocationAction() == 3 && (null == this.getLocationLimit() || this.getLocationLimit() < 1 || this.getLocationLimit() > 10240)) {
                this.responseResult("error");
                return;
            }
            if (this.getLocationAction() != 3 && null != this.getLocationLimit()) {
                this.responseResult("error");
                return;
            }
            if (!this.validateLocation(form, false)) {
                this.responseResult("error");
                return;
            }
            if (this.isContain(sessionZoneIpLocation, ipLocation)) continue;
            sessionZoneIpLocation.add(form);
            sessionZoneIpLocationTemp.add(form);
        }
        if (sessionZoneIpLocation.size() > 33) {
            sessionZoneIpLocation.removeAll(sessionZoneIpLocationTemp);
            this.responseResult("tomuch");
            return;
        }
        List<String> zoneIpLocationNameFormListx = this.getSessionZoneIpLocationName();
        if (null == zoneIpLocationNameFormListx) {
            zoneIpLocationNameFormListx = new ArrayList<String>();
        }
        zoneIpLocationNameFormListx.addAll(nameTem);
        this.setSessionZoneIpLocationName(zoneIpLocationNameFormListx);
        this.responseResult("success");
    }

    private boolean isContain(List<ZoneIpLocationForm> sessionZoneIpLocation, IpLocation ipLocation) {
        for (ZoneIpLocationForm zoneIpLocationF : sessionZoneIpLocation) {
            if (zoneIpLocationF.getLocationId() != ipLocation.getLocationId()) continue;
            return true;
        }
        return false;
    }

    private void validateThreshold() {
        if (!ZoneUtil.isValidLimitThreshold(String.valueOf(this.getLocationLimit()))) {
            throw new LegoCheckedException(670736L);
        }
    }

    private boolean validateLocation(ZoneIpLocationForm form, boolean isEdit) {
        Map<Long, IpLocation> map = this.libraryFileService.getIpLocationMap();
        ArrayList<IpLocation> ipLocationAlList = new ArrayList<IpLocation>(map.values());
        HashMap<String, IpLocation> locationMap = new HashMap<String, IpLocation>();
        HashMap<String, IpLocation> locationMapZh = new HashMap<String, IpLocation>();
        if (!isEdit) {
            for (IpLocation ipLocation : ipLocationAlList) {
                if (LOCATION_CUSTOM.equals(ipLocation.getLocationType())) {
                    ipLocation.setShortName(LOCATION);
                    if (-1 == ipLocation.getLocationNameEn().indexOf(SPRIT)) {
                        ipLocation.setLocationNameEn(SPRIT + ipLocation.getLocationNameEn());
                    }
                    if (-1 == ipLocation.getLocationNameZh().indexOf(SPRIT)) {
                        ipLocation.setLocationNameZh(SPRIT + ipLocation.getLocationNameZh());
                    }
                }
                locationMap.put(ipLocation.getLocationNameEn(), ipLocation);
                locationMapZh.put(ipLocation.getLocationNameZh(), ipLocation);
            }
            if (null == map.get(form.getLocationId()) || null == locationMap.get(form.getLocationNameEn()) || null == locationMapZh.get(form.getLocationNameZh())) {
                return false;
            }
            if (!map.get(form.getLocationId()).equals(locationMap.get(form.getLocationNameEn()))) {
                return false;
            }
            if (form.getLocationAction() != 1 && form.getLocationAction() != 2 && form.getLocationAction() != 3) {
                return false;
            }
        } else if (form.getLocationAction() != 1 && form.getLocationAction() != 2 && form.getLocationAction() != 3) {
            return false;
        }
        return true;
    }

    public String modifyIpLocation() {
        this.zoneIpLocationFormList = this.getSessionZoneIpLocation();
        Long locationID = this.locationId;
        for (ZoneIpLocationForm zoneIpLocationForms : this.zoneIpLocationFormList) {
            if (zoneIpLocationForms.getLocationId() != locationID.longValue()) continue;
            zoneIpLocationForms.setLocationId(locationID);
            zoneIpLocationForms.setLocationNameEn(zoneIpLocationForms.getLocationNameEn());
            zoneIpLocationForms.setLocationAction(zoneIpLocationForms.getLocationAction());
            zoneIpLocationForms.setLocationLimit(zoneIpLocationForms.getLocationLimit());
            this.initLocationActionList(false, zoneIpLocationForms);
            this.zoneIpLocationForm = zoneIpLocationForms;
            break;
        }
        return "success";
    }

    public void editIpLocation() {
        this.zoneIpLocationFormList = this.getSessionZoneIpLocation();
        Long locationID = this.locationId;
        for (ZoneIpLocationForm form : this.zoneIpLocationFormList) {
            if (!this.validateLocation(this.zoneIpLocationForm, true)) {
                this.responseResult("error");
                return;
            }
            if (this.zoneIpLocationForm.getLocationAction() == 3 && (null == this.getLocationLimit() || this.getLocationLimit() < 1 || this.getLocationLimit() > 10240)) {
                this.responseResult("error");
                return;
            }
            if (form.getLocationId() != locationID.longValue()) continue;
            form.setLocationId(locationID);
            form.setLocationAction(this.zoneIpLocationForm.getLocationAction());
            if (this.zoneIpLocationForm.getLocationAction() != 3) {
                form.setLocationLimit(null);
                break;
            }
            form.setLocationLimit(this.getLocationLimit());
            break;
        }
    }

    private List<String> findZhName(String[] locationNamList) {
        ArrayList<String> result = new ArrayList<String>();
        this.ipLocationMap = this.getSessionIpNameMap();
        if (null == this.ipLocationMap || this.ipLocationMap.size() == 0) {
            this.initIpLocationMapAndIpLocationNameMap();
        }
        for (String name : locationNamList) {
            IpLocation ipLocation = this.ipLocationMap.get(SPRIT + name);
            if (null != ipLocation) {
                result.add(null != this.ipLocationMap.get(SPRIT + name) ? (ipLocation.getLocationNameZh().indexOf(SPRIT) == 0 ? ipLocation.getLocationNameZh().replaceFirst(SPRIT, "") : ipLocation.getLocationNameZh()) : name);
                result.add(null != this.ipLocationMap.get(SPRIT + name) ? (ipLocation.getLocationNameEn().indexOf(SPRIT) == 0 ? ipLocation.getLocationNameEn().replaceFirst(SPRIT, "") : ipLocation.getLocationNameEn()) : name);
                continue;
            }
            result.add(name);
        }
        return result;
    }

    public void deleteIpLocation() {
        List<String> zoneIpLocationNameFormListx;
        if (this.locationName == null) {
            this.responseResult("stay");
        }
        if (null != (zoneIpLocationNameFormListx = this.getSessionZoneIpLocationName())) {
            List<String> list = this.findZhName(new String[]{this.locationName});
            zoneIpLocationNameFormListx.removeAll(list);
            this.setSessionZoneIpLocationName(zoneIpLocationNameFormListx);
        }
        this.zoneIpLocationFormList = this.getSessionZoneIpLocation();
        this.zoneIpLocationNameFormList = this.getSessionZoneIpLocationName();
        this.ipLocationMap = this.getSessionIpNameMap();
        if (this.zoneIpLocationFormList == null) {
            this.zoneIpLocationFormList = new ArrayList<ZoneIpLocationForm>();
        }
        if (this.zoneIpLocationNameFormList == null) {
            this.zoneIpLocationNameFormList = new ArrayList<String>();
        }
        if (null == this.ipLocationMap || this.ipLocationMap.size() == 0) {
            this.initIpLocationMapAndIpLocationNameMap();
        }
        int count = this.zoneIpLocationFormList.size();
        if (null != this.locationName) {
            Iterator<Object> it = this.zoneIpLocationFormList.iterator();
            while (it.hasNext()) {
                ZoneIpLocationForm form = it.next();
                if (form.getLocationNameEn().equalsIgnoreCase(this.locationName)) {
                    it.remove();
                    --count;
                }
                if (count != 1) continue;
                this.zoneIpLocationFormList = new ArrayList<ZoneIpLocationForm>();
                this.setSessionZoneIpLocation(this.zoneIpLocationFormList);
            }
            it = this.zoneIpLocationNameFormList.iterator();
            while (it.hasNext()) {
                String locName = (String)it.next();
                if (null == this.ipLocationMap.get(this.locationName) || null == this.ipLocationMap.get(this.locationName).getLocationNameZh() || !locName.equals(this.ipLocationMap.get(this.locationName).getLocationNameZh())) continue;
                it.remove();
            }
        }
        this.responseResult("success");
    }

    public void deleteAllIpLocation() {
        this.zoneIpLocationFormList = this.getSessionZoneIpLocation();
        this.zoneIpLocationFormList = new ArrayList<ZoneIpLocationForm>();
        this.setSessionZoneIpLocation(this.zoneIpLocationFormList);
        this.zoneIpLocationNameFormList = this.getSessionZoneIpLocationName();
        this.zoneIpLocationNameFormList = new ArrayList<String>();
        this.setSessionZoneIpLocationName(this.zoneIpLocationNameFormList);
        this.responseResult("success");
    }

    public void deleteIpLocationBatch() {
        List<String> zoneIpLocationNameFormListx;
        if (this.locationNameList == null) {
            return;
        }
        this.zoneIpLocationFormList = this.getSessionZoneIpLocation();
        this.zoneIpLocationNameFormList = this.getSessionZoneIpLocationName();
        this.ipLocationMap = this.getSessionIpNameMap();
        if (this.zoneIpLocationFormList == null) {
            this.zoneIpLocationFormList = new ArrayList<ZoneIpLocationForm>();
        }
        if (this.zoneIpLocationNameFormList == null) {
            this.zoneIpLocationNameFormList = new ArrayList<String>();
        }
        if (null == this.ipLocationMap || this.ipLocationMap.size() == 0) {
            this.initIpLocationMapAndIpLocationNameMap();
        }
        if (null != (zoneIpLocationNameFormListx = this.getSessionZoneIpLocationName())) {
            List<String> list = this.findZhName(this.locationNameList);
            for (String locationNameTemp : list) {
                zoneIpLocationNameFormListx.remove(locationNameTemp);
            }
            this.setSessionZoneIpLocationName(zoneIpLocationNameFormListx);
        }
        int count = this.zoneIpLocationFormList.size();
        for (int i = 0; i < this.locationNameList.length; ++i) {
            Iterator<Object> it = this.zoneIpLocationFormList.iterator();
            while (it.hasNext()) {
                ZoneIpLocationForm form = it.next();
                if (form.getLocationNameEn().equalsIgnoreCase(this.locationNameList[i])) {
                    it.remove();
                    --count;
                }
                if (count != 1) continue;
                this.zoneIpLocationFormList = new ArrayList<ZoneIpLocationForm>();
                this.setSessionZoneIpLocation(this.zoneIpLocationFormList);
            }
            it = this.zoneIpLocationNameFormList.iterator();
            while (it.hasNext()) {
                String locName = (String)it.next();
                if (null == this.ipLocationMap.get(this.locationName) || null == this.ipLocationMap.get(this.locationName).getLocationNameZh() || !locName.equals(this.ipLocationMap.get(this.locationNameList[i]).getLocationNameZh())) continue;
                it.remove();
            }
        }
        this.responseResult("success");
    }

    private void removeSelectedIpLocation() {
        List<String> list = this.getSessionZoneIpLocationName();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<String> removeList = new ArrayList<String>();
        for (String selectedName : list) {
            for (Map.Entry<String, String> entry : this.ipLocationNameMap.entrySet()) {
                if (!entry.getKey().contains(selectedName)) continue;
                removeList.add(entry.getKey());
            }
        }
        for (String string : removeList) {
            this.ipLocationNameMap.remove(string);
        }
    }

    public List<IpLocation> getIpLocationList() {
        return this.ipLocationList;
    }

    public void setIpLocationList(List<IpLocation> ipLocationList) {
        this.ipLocationList = ipLocationList;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public List<ZoneIpLocationForm> getZoneIpLocationFormList() {
        return this.zoneIpLocationFormList;
    }

    public void setZoneIpLocationFormList(List<ZoneIpLocationForm> zoneIpLocationFormList) {
        this.zoneIpLocationFormList = zoneIpLocationFormList;
    }

    public String[] getSaveList() {
        if (null != this.saveList) {
            return (String[])this.saveList.clone();
        }
        return new String[0];
    }

    public void setSaveList(String[] saveList) {
        this.saveList = null != saveList ? (String[])saveList.clone() : null;
    }

    public String getLocationNameEn() {
        return this.locationNameEn;
    }

    public void setLocationNameEn(String locationNameEn) {
        this.locationNameEn = locationNameEn;
    }

    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String[] getLocationNameList() {
        if (null != this.locationNameList) {
            return (String[])this.locationNameList.clone();
        }
        return new String[0];
    }

    public void setLocationNameList(String[] locationNameList) {
        this.locationNameList = null != locationNameList ? (String[])locationNameList.clone() : null;
    }

    public String getHelpLanguage() {
        return this.helpLanguage;
    }

    public void setHelpLanguage(String helpLanguage) {
        this.helpLanguage = helpLanguage;
    }

    public List<LangPair> getLocationActionList() {
        return this.locationActionList;
    }

    public void setLocationActionList(List<LangPair> locationActionList) {
        this.locationActionList = locationActionList;
    }

    public ZoneIpLocationForm getZoneIpLocationForm() {
        return this.zoneIpLocationForm;
    }

    public void setZoneIpLocationForm(ZoneIpLocationForm zoneIpLocationForm) {
        this.zoneIpLocationForm = zoneIpLocationForm;
    }

    public String getLocationActionValue() {
        return this.locationActionValue;
    }

    public void setLocationActionValue(String locationActionValue) {
        this.locationActionValue = locationActionValue;
    }

    public String getLocationActionLabel() {
        return this.locationActionLabel;
    }

    public void setLocationActionLabel(String locationActionLabel) {
        this.locationActionLabel = locationActionLabel;
    }

    public Integer getLocationAction() {
        return this.locationAction;
    }

    public void setLocationAction(Integer locationAction) {
        this.locationAction = locationAction;
    }

    public Integer getLocationLimit() {
        return this.locationLimit;
    }

    public void setLocationLimit(Integer locationLimit) {
        this.locationLimit = locationLimit;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public IZoneIpLocationService getZoneIpLocationService() {
        return this.zoneIpLocationService;
    }

    public void setZoneIpLocationService(IZoneIpLocationService zoneIpLocationService) {
        this.zoneIpLocationService = zoneIpLocationService;
    }

    public boolean validatePageSize() {
        return new ViewAllFilterAction().validatePageSize();
    }

    public boolean validateLocationNameList() {
        if (null == this.locationNameList || this.locationNameList.length == 0) {
            return true;
        }
        if (this.locationNameList.length > 33) {
            return false;
        }
        String regex = "^[\\w|\u4e00-\u9fa5|\\-|/|\\.|\\(|\\ |\\)|\\']*$";
        for (int i = 0; i < this.locationNameList.length; ++i) {
            boolean flag = this.locationNameList[i].matches(regex);
            if (flag && this.locationNameList[i].length() <= 255) continue;
            return false;
        }
        return true;
    }

    public boolean validateLocationAction() {
        if (null == this.zoneIpLocationForm || null == this.zoneIpLocationForm.getLocationAction()) {
            return true;
        }
        if ("".equals(this.zoneIpLocationForm.getLocationAction().toString())) {
            return false;
        }
        String regex = "^(1|2|3)$";
        return this.zoneIpLocationForm.getLocationAction().toString().matches(regex);
    }

    public boolean validateLocationName() {
        return this.validateName(this.locationName);
    }

    private boolean validateName(String str) {
        if (null == str || "".equals(str.trim()) || "null".equals(str.trim())) {
            return false;
        }
        String regex = "^[\\w|\u4e00-\u9fa5|\\-|/|\\.|\\(|\\ |\\)|\\']{1,255}$";
        return str.matches(regex);
    }

    public boolean validateSelectedNodeNames() {
        if (null == this.selectedNodeNames || this.selectedNodeNames.length == 0 || this.selectedNodeNames.length > 33) {
            return false;
        }
        for (int i = 0; i < this.selectedNodeNames.length; ++i) {
            if (this.validateName(this.selectedNodeNames[i])) continue;
            return false;
        }
        return true;
    }

    public boolean validateLocationLimit() {
        if (null != this.locationAction && this.locationAction == 3 && (null == this.locationLimit || 0 == this.locationLimit)) {
            return false;
        }
        if ((null == this.locationLimit || 0 == this.locationLimit) && null != this.locationAction && this.locationAction != 3) {
            return true;
        }
        if (null == this.locationLimit) {
            return true;
        }
        return this.locationLimit >= 1 && this.locationLimit <= 10240;
    }

    public boolean validateId() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String idStr = request.getParameter("zoneIpLocationForm.locationId");
        if (null == this.zoneIpLocationForm) {
            return true;
        }
        if ("".equals(idStr)) {
            return false;
        }
        long idTemp = 0L;
        try {
            idTemp = Long.parseLong(idStr);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return idTemp >= 0L;
    }

    public List<TreeNode> searchIpLocation(List<Map.Entry<String[], String>> locaMap) {
        try {
            boolean flag = false;
            TreeNode root = new TreeNode();
            root.setKey("0");
            root.setValue("0");
            root.setLevel(0);
            List<TreeNode> updataNode = null;
            TreeNode loadNode = root;
            for (Map.Entry<String[], String> entry : locaMap) {
                String[] keys = entry.getKey();
                String value = entry.getValue();
                if (value.contains(UNKNOWN_OTHER)) {
                    value = UNKNOWN_OTHER;
                }
                if (value.contains(CHINA_CN)) {
                    value = CHINA_CN;
                }
                String path = LOCATION_IMAGE_PATH + value + IMAGE_SUFFIX;
                flag = false;
                if (updataNode == null) {
                    for (int n = 1; n < keys.length; ++n) {
                        TreeNode node = n == keys.length - 1 ? new TreeNode(keys[n], keys[n], this.createIplocation(keys, n), null, n, true) : new TreeNode(keys[n], keys[n], this.createIplocation(keys, n), null, n, false);
                        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                        node.setUrl(path);
                        list.add(node);
                        loadNode.setChildren(list);
                        loadNode = node;
                    }
                    updataNode = root.getChildren();
                    continue;
                }
                loadNode = root;
                updataNode = root.getChildren();
                int depIndex = keys.length < 8 ? keys.length : 8;
                for (int m = 1; m < depIndex; ++m) {
                    if (null != updataNode && !flag) {
                        for (TreeNode item : updataNode) {
                            if (!item.getKey().equals(keys[m])) continue;
                            updataNode = item.getChildren();
                            loadNode = item;
                            break;
                        }
                        if (m == loadNode.getLevel()) continue;
                    }
                    flag = true;
                    for (int n = m; n < depIndex; ++n) {
                        TreeNode node = n == depIndex - 1 ? new TreeNode(keys[n], keys[n], this.createIplocation(keys, n), null, n, true) : new TreeNode(keys[n], keys[n], this.createIplocation(keys, n), null, n, false);
                        List<Object> list = loadNode.getChildren() == null ? new ArrayList() : loadNode.getChildren();
                        node.setUrl(path);
                        list.add(node);
                        loadNode.setChildren(list);
                        loadNode = node;
                    }
                    break;
                }
                updataNode = root.getChildren();
            }
            ArrayList<TreeNode> allIpLocation = new ArrayList<TreeNode>();
            allIpLocation.add(root);
            return allIpLocation;
        }
        catch (RuntimeException ex) {
            logger.error((Object)("---> searchIpLocation is error :" + ex.getMessage()));
            return new ArrayList<TreeNode>();
        }
    }

    private String createIplocation(String[] ipLocation, int index) {
        if (ipLocation.length > 0) {
            StringBuilder name = new StringBuilder();
            for (int i = 1; i < index + 1; ++i) {
                name.append(SPRIT).append(ipLocation[i]);
            }
            return name.toString().replaceAll(REG, SPRIT);
        }
        return "";
    }

    public void setSelectedNodeNames(String[] selectedNodeNames) {
        this.selectedNodeNames = selectedNodeNames != null ? (String[])selectedNodeNames.clone() : null;
    }

    public List<String> getZoneIpLocationNameFormList() {
        return this.zoneIpLocationNameFormList;
    }

    public void setZoneIpLocationNameFormList(List<String> zoneIpLocationNameFormList) {
        this.zoneIpLocationNameFormList = zoneIpLocationNameFormList;
    }

    private static class MyComparator
    implements Comparator<Map.Entry<String[], String>>,
    Serializable {
        private static final long serialVersionUID = 445482268888638525L;

        private MyComparator() {
        }

        @Override
        public int compare(Map.Entry<String[], String> o1, Map.Entry<String[], String> o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

