/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action.npfilter;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterRuleForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class NpFilterAction
extends BaseAction {
    private static final long serialVersionUID = 15453939456931574L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String npFilterName;
    private INpFilterService npFilterService;
    private List<NPFilterForm> npFilterList = new ArrayList<NPFilterForm>();
    private String npFilterIds;
    private List<NPFilterDeviceForm> ddosDeviceList = new ArrayList<NPFilterDeviceForm>();
    private List<AticDevice> aticDdosDeviceList = new ArrayList<AticDevice>();
    private IAticDeviceService aticDeviceService;
    private String aticDeviceIds;
    private NPFilterForm npFilterForm = new NPFilterForm();
    private List<LangPair> protocolPairList = new ArrayList<LangPair>();
    private List<LangPair> actionPairList = new ArrayList<LangPair>();
    private List<LangPair> tcpFlagList = new ArrayList<LangPair>();
    private List<LangPair> fragmentTypeList = new ArrayList<LangPair>();
    private Boolean newPage = false;
    private Boolean isDeploy = false;
    private String protocolLable;
    private String protocolValue;
    private String actionLabel;
    private String actionValue;
    private String deviceIdList;
    private String tcpFlagLavel;
    private String tcpFlagValue;
    private String fragmentTypeLabel;
    private String fragmentTypeValue;
    private NPFilterRuleForm npFilterRuleForm;
    private Long npFilterId;
    private String neName;

    public String getNeName() {
        return this.neName;
    }

    public void setNeName(String neName) {
        this.neName = neName;
    }

    public String getTcpFlagLavel() {
        return this.tcpFlagLavel;
    }

    public void setTcpFlagLavel(String tcpFlagLavel) {
        this.tcpFlagLavel = tcpFlagLavel;
    }

    public String getTcpFlagValue() {
        return this.tcpFlagValue;
    }

    public void setTcpFlagValue(String tcpFlagValue) {
        this.tcpFlagValue = tcpFlagValue;
    }

    public Long getNpFilterId() {
        return this.npFilterId;
    }

    public void setNpFilterId(Long npFilterId) {
        this.npFilterId = npFilterId;
    }

    public List<LangPair> getTcpFlagList() {
        return this.tcpFlagList;
    }

    public void setTcpFlagList(List<LangPair> tcpFlagList) {
        this.tcpFlagList = tcpFlagList;
    }

    public NPFilterRuleForm getNpFilterRuleForm() {
        return this.npFilterRuleForm;
    }

    public void setNpFilterRuleForm(NPFilterRuleForm npFilterRuleForm) {
        this.npFilterRuleForm = npFilterRuleForm;
    }

    public String getDeviceIdList() {
        return this.deviceIdList;
    }

    public void setDeviceIdList(String deviceIdList) {
        this.deviceIdList = deviceIdList;
    }

    public String getProtocolLable() {
        return this.protocolLable;
    }

    public void setProtocolLable(String protocolLable) {
        this.protocolLable = protocolLable;
    }

    public String getProtocolValue() {
        return this.protocolValue;
    }

    public void setProtocolValue(String protocolValue) {
        this.protocolValue = protocolValue;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public String getActionValue() {
        return this.actionValue;
    }

    public void setActionValue(String actionValue) {
        this.actionValue = actionValue;
    }

    public Boolean getNewPage() {
        return this.newPage;
    }

    public void setNewPage(Boolean newPage) {
        this.newPage = newPage;
    }

    public Boolean getIsDeploy() {
        return this.isDeploy;
    }

    public void setIsDeploy(Boolean isDeploy) {
        this.isDeploy = isDeploy;
    }

    public List<LangPair> getProtocolPairList() {
        return this.protocolPairList;
    }

    public void setProtocolPairList(List<LangPair> protocolPairList) {
        this.protocolPairList = protocolPairList;
    }

    public List<LangPair> getActionPairList() {
        return this.actionPairList;
    }

    public void setActionPairList(List<LangPair> actionPairList) {
        this.actionPairList = actionPairList;
    }

    public String getNpFilterName() {
        return this.npFilterName;
    }

    public void setNpFilterName(String npFilterName) {
        this.npFilterName = npFilterName;
    }

    public INpFilterService getNpFilterService() {
        return this.npFilterService;
    }

    public void setNpFilterService(INpFilterService npFilterService) {
        this.npFilterService = npFilterService;
    }

    public String getNpFilterIds() {
        return this.npFilterIds;
    }

    public void setNpFilterIds(String npFilterIds) {
        this.npFilterIds = npFilterIds;
    }

    public List<NPFilterForm> getNpFilterList() {
        return this.npFilterList;
    }

    public void setNpFilterList(List<NPFilterForm> npFilterList) {
        this.npFilterList = npFilterList;
    }

    public List<NPFilterDeviceForm> getDdosDeviceList() {
        return this.ddosDeviceList;
    }

    public void setDdosDeviceList(List<NPFilterDeviceForm> ddosDeviceList) {
        this.ddosDeviceList = ddosDeviceList;
    }

    public List<AticDevice> getAticDdosDeviceList() {
        return this.aticDdosDeviceList;
    }

    public void setAticDdosDeviceList(List<AticDevice> aticDdosDeviceList) {
        this.aticDdosDeviceList = aticDdosDeviceList;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public String getAticDeviceIds() {
        return this.aticDeviceIds;
    }

    public void setAticDeviceIds(String aticDeviceIds) {
        this.aticDeviceIds = aticDeviceIds;
    }

    public NPFilterForm getNpFilterForm() {
        return this.npFilterForm;
    }

    public void setNpFilterForm(NPFilterForm npFilterForm) {
        this.npFilterForm = npFilterForm;
    }

    public List<LangPair> getFragmentTypeList() {
        return this.fragmentTypeList;
    }

    public void setFragmentTypeList(List<LangPair> fragmentTypeList) {
        this.fragmentTypeList = fragmentTypeList;
    }

    public String getFragmentTypeLabel() {
        return this.fragmentTypeLabel;
    }

    public void setFragmentTypeLabel(String fragmentTypeLabel) {
        this.fragmentTypeLabel = fragmentTypeLabel;
    }

    public String getFragmentTypeValue() {
        return this.fragmentTypeValue;
    }

    public void setFragmentTypeValue(String fragmentTypeValue) {
        this.fragmentTypeValue = fragmentTypeValue;
    }

    public String viewFilterTab() {
        return "success";
    }

    public String viewNpFilterTemplate() {
        try {
            this.npFilterList = new ArrayList<NPFilterForm>();
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("npFilterName", this.npFilterName);
            Paging page = this.npFilterService.queryByPage(queryMap, this.start, this.pageSize);
            this.npFilterList = page.getData();
            this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
            this.getSession().setAttribute("start", (Object)this.getStart());
            this.setTotal(page.getCount());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Query NP Filter Error." + e.getMessage()));
        }
        return "success";
    }

    public String openCreateNpFilter() {
        try {
            this.npFilterForm = new NPFilterForm();
            this.setProtocolLabelAndValue(null);
            this.setActionLabelAndValue(null);
            this.setTcpFlag(null);
            this.setFragmentType(null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Init NP Filter Error." + e.getMessage()));
        }
        return "success";
    }

    private void setProtocolLabelAndValue(String protocolType) {
        this.protocolPairList.add(new LangPair("NUMBER", this.getText("com.hs.vsm.secservice.ddos.np.filter.protocol.number")));
        this.protocolPairList.add(new LangPair("ICMP", "ICMP"));
        this.protocolPairList.add(new LangPair("TCP", "TCP"));
        this.protocolPairList.add(new LangPair("UDP", "UDP"));
        this.protocolPairList.add(new LangPair("IP", "IP"));
        if (this.newPage.booleanValue()) {
            this.setProtocolLable("TCP");
            this.setProtocolValue("TCP");
            this.npFilterForm.setIpType("IPV4");
        } else if ("NUMBER".equals(protocolType)) {
            this.setProtocolLable("NUMBER");
            this.setProtocolValue(this.getText("com.hs.vsm.secservice.ddos.np.filter.protocol.number"));
        } else {
            this.setProtocolLable(protocolType);
            this.setProtocolValue(protocolType);
        }
    }

    private void setTcpFlag(String tcpFlag) {
        this.tcpFlagList.add(new LangPair("--", "--"));
        this.tcpFlagList.add(new LangPair("ack", "ack"));
        this.tcpFlagList.add(new LangPair("fin", "fin"));
        this.tcpFlagList.add(new LangPair("rst", "rst"));
        this.tcpFlagList.add(new LangPair("syn", "syn"));
        this.tcpFlagList.add(new LangPair("syn-ack", "syn-ack"));
        this.tcpFlagList.add(new LangPair("urg", "urg"));
        if (!this.newPage.booleanValue() && null != tcpFlag && !"".equals(tcpFlag)) {
            this.setTcpFlagLavel(tcpFlag);
            this.setTcpFlagValue(tcpFlag);
        } else {
            this.setTcpFlagLavel("--");
            this.setTcpFlagValue("--");
        }
    }

    private void setFragmentType(String fragmentType) {
        this.fragmentTypeList.add(new LangPair("--", "--"));
        this.fragmentTypeList.add(new LangPair("fragment", "fragment"));
        this.fragmentTypeList.add(new LangPair("non-fragment", "non-fragment"));
        if (!this.newPage.booleanValue() && null != fragmentType && !"".equals(fragmentType)) {
            this.setFragmentTypeLabel(fragmentType);
            this.setFragmentTypeValue(fragmentType);
        } else {
            this.setFragmentTypeLabel("--");
            this.setFragmentTypeValue("--");
        }
    }

    private void setActionLabelAndValue(Integer value) {
        this.actionPairList.add(new LangPair(String.valueOf(0), this.getText("com.hs.vsm.secservice.ddos.np.filter.drop")));
        this.actionPairList.add(new LangPair(String.valueOf(1), this.getText("com.hs.vsm.secservice.ddos.np.filter.limit")));
        if (this.newPage.booleanValue()) {
            this.setActionLabel(String.valueOf(1));
            this.setActionValue(this.getText("com.hs.vsm.secservice.ddos.np.filter.limit"));
        } else if (value == 0) {
            this.setActionLabel(String.valueOf(0));
            this.setActionValue(this.getText("com.hs.vsm.secservice.ddos.np.filter.drop"));
        } else {
            this.setActionLabel(String.valueOf(1));
            this.setActionValue(this.getText("com.hs.vsm.secservice.ddos.np.filter.limit"));
        }
    }

    public String addDdosDevice() {
        try {
            Map<String, String> queryMap = this.getConditions();
            Paging page = this.aticDeviceService.getDeviceByPage(queryMap, 0, Integer.MAX_VALUE);
            if (null == page) {
                return "success";
            }
            List allDddosDeviceList = page.getData();
            if (null != allDddosDeviceList && !allDddosDeviceList.isEmpty()) {
                for (AticDevice aticDevice : allDddosDeviceList) {
                    String[] deviceIdsArray;
                    if (1 != aticDevice.getDeviceType() || 0 != aticDevice.getStatus()) continue;
                    this.aticDdosDeviceList.add(aticDevice);
                    if (null == this.deviceIdList || "".equals(this.deviceIdList)) continue;
                    for (String deviceId : deviceIdsArray = this.deviceIdList.substring(0, this.deviceIdList.length() - 1).split(",")) {
                        if (aticDevice.getMoId() != Long.parseLong(deviceId)) continue;
                        this.aticDdosDeviceList.remove(aticDevice);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Add DDOS Device Error." + e.getMessage()));
        }
        return "success";
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)this.neName)) {
            queryMap.put("nameOrIp", this.neName.trim());
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        queryMap.put("isDdosType", "true");
        queryMap.put("userId", String.valueOf(currentUser.getUserID()));
        queryMap.put("isAdmin", currentUser.getIsAdmin());
        return queryMap;
    }

    public String openEnditNpFilter() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (currentUser == null) {
            throw new LegoSecurityException(206L);
        }
        Map<String, String> queryMap = this.getConditionMap();
        this.npFilterForm = this.npFilterService.queryById(queryMap);
        if (null != this.npFilterForm) {
            this.setActionLabelAndValue(this.npFilterForm.getFilterAction());
            this.setTcpFlag(this.npFilterForm.getNpFilterRuleForm().getTcpFlag());
            this.setProtocolLabelAndValue(this.npFilterForm.getProtocolType());
            this.setFragmentType(this.npFilterForm.getNpFilterRuleForm().getFragmentType());
            List antiAllList = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
            HashMap<Long, AticDevice> aticDdosMap = new HashMap<Long, AticDevice>();
            for (AticDevice aticDevice : antiAllList) {
                aticDdosMap.put(aticDevice.getMoId(), aticDevice);
            }
            List<NPFilterDeviceForm> npFilterDeviceFormList = this.npFilterForm.getNpFilterDeviceFormList();
            for (NPFilterDeviceForm npFilterDeviceForm : npFilterDeviceFormList) {
                AticDevice aticDevice = (AticDevice)aticDdosMap.get(npFilterDeviceForm.getDeviceId());
                npFilterDeviceForm.setDeviceName(aticDevice.getName());
                String errorCode = npFilterDeviceForm.getErrorCode();
                if (null != errorCode) {
                    Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
                    String msgInfo = AticUtil.getText((String)errorCode, (Locale)locale);
                    if (null != msgInfo) {
                        String errorParam = npFilterDeviceForm.getErrorParam();
                        msgInfo = msgInfo.replace("[$0]", null == errorParam ? "" : errorParam);
                        npFilterDeviceForm.setErrorCode(msgInfo);
                    }
                } else {
                    npFilterDeviceForm.setErrorCode("--");
                }
                this.ddosDeviceList.add(npFilterDeviceForm);
            }
        }
        return "success";
    }

    private boolean checkNpFilterNameAndRule() {
        boolean isMaxNpFilter;
        String packetLength;
        Long filterId = this.npFilterForm.getId();
        String filterName = this.npFilterForm.getFilterName();
        boolean isExsit = this.npFilterService.queryByName(filterName, filterId);
        if (isExsit) {
            this.responseResult("nameExist");
            return true;
        }
        if (this.npFilterForm.getFilterAction() != 1) {
            this.npFilterForm.setFilterAlert(0L);
        }
        if (null != this.npFilterForm.getNpFilterRuleForm() && null != (packetLength = this.npFilterForm.getNpFilterRuleForm().getPacketLength()) && !"".equals(packetLength)) {
            String[] packageLengthArray = packetLength.split("-");
            this.npFilterForm.getNpFilterRuleForm().setPacketStartLength(Integer.parseInt(packageLengthArray[0]));
            this.npFilterForm.getNpFilterRuleForm().setPacketEndLength(Integer.parseInt(packageLengthArray[1]));
        }
        Long newCrc = this.npFilterForm.getCalcCrc();
        List<NPFilterForm> allNpFilterList = this.npFilterService.queryAllNpFilterExcludeFilterId(filterId);
        for (NPFilterForm npRuleForm : allNpFilterList) {
            if (!newCrc.equals(npRuleForm.getCalcCrc())) continue;
            this.responseResult("ruleExist;" + npRuleForm.getFilterName());
            return true;
        }
        if (null == filterId && (isMaxNpFilter = this.npFilterService.checkNpFilterNumberLimit())) {
            this.responseResult("maxNumber");
            return true;
        }
        if (null != this.deviceIdList && !"".equals(this.deviceIdList)) {
            String[] deviceIdsArray;
            for (String deviceId : deviceIdsArray = this.deviceIdList.substring(0, this.deviceIdList.length() - 1).split(",")) {
                boolean isMaxDevice = this.npFilterService.checkNpFilterDeviceNumberLimit(Long.parseLong(deviceId), filterId);
                if (!isMaxDevice) continue;
                AticDevice deviceInfo = this.aticDeviceService.getDeviceByMoid(Long.parseLong(deviceId));
                this.responseResult("maxDevice:" + deviceInfo.getName());
                return true;
            }
        }
        return false;
    }

    public String startNPFilterProgressbar() {
        ArrayList<Long> filterIds2Check = new ArrayList<Long>();
        if (!StringUtils.isEmpty((CharSequence)this.npFilterIds)) {
            String[] ids = this.npFilterIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                filterIds2Check.add(Long.parseLong(ids[i]));
            }
        }
        ZoneBisUtil.checkUserSecurity("NPFilter", filterIds2Check);
        return "success";
    }

    public void saveNpFilter() {
        boolean isExist;
        boolean isCreate;
        boolean bl = isCreate = null == this.npFilterForm.getId();
        if (!isCreate) {
            ArrayList<Long> filterIds2Check = new ArrayList<Long>();
            filterIds2Check.add(this.npFilterForm.getId());
            ZoneBisUtil.checkUserSecurity("NPFilter", filterIds2Check);
        }
        if (isExist = this.checkNpFilterNameAndRule()) {
            return;
        }
        if (null != this.deviceIdList && !this.deviceIdList.isEmpty()) {
            ArrayList<NPFilterDeviceForm> deviceFormsList = new ArrayList<NPFilterDeviceForm>();
            String[] deviceIds = this.deviceIdList.substring(0, this.deviceIdList.length() - 1).split(",");
            ArrayList<Long> moIdList = new ArrayList<Long>();
            for (String deviceId : deviceIds) {
                moIdList.add(Long.parseLong(deviceId));
            }
            BisUtil.checkUserSecurity(moIdList);
            for (String deviceId : deviceIds) {
                NPFilterDeviceForm deviceForm = new NPFilterDeviceForm();
                deviceForm.setDeviceId(Long.parseLong(deviceId));
                deviceFormsList.add(deviceForm);
            }
            this.npFilterForm.setNpFilterDeviceFormList(deviceFormsList);
        }
        try {
            this.npFilterService.saveNpFilter(this.npFilterForm);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("save np filter failed, " + e.getMessage()));
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.create.npfilter", "lego.dic.module.NPFilter", false, null, null, this.npFilterForm.getFilterName(), SysoplogLevel.info.getValue(), false, (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("save np filter failed, " + e.getMessage()));
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.create.npfilter", "lego.dic.module.NPFilter", false, null, null, this.npFilterForm.getFilterName(), SysoplogLevel.info.getValue(), false, e);
            throw new LegoUncheckedException((Throwable)e);
        }
        if (isCreate) {
            this.optCreateNPFilter(this.npFilterForm);
        } else {
            this.optModifyNPFilter(this.npFilterForm);
        }
        this.responseResult(this.npFilterForm.getId() + ";saveSuccesed");
    }

    public void deployNpFilter() {
        Map<Long, Set<Long>> resultMap = null;
        Map<String, String> queryMap = this.getConditionMap();
        NPFilterForm filterForm = this.npFilterService.queryById(queryMap);
        try {
            resultMap = this.npFilterService.deployNpFilter(this.npFilterId, null, null, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Deploy NPFilter Error." + e.getMessage()));
            String detail = "com.hs.vsm.secservice.ddos.policy.operation.deploy.npfilter.fail";
            String[] detailPara = new String[]{this.npFilterForm.getFilterName()};
            this.optDeployNPFilter(this.npFilterForm, false, detail, detailPara);
            this.responseResult("DeployFail");
            return;
        }
        if (null != resultMap && !resultMap.isEmpty()) {
            String detail = "com.hs.vsm.secservice.ddos.policy.operation.deploy.npfilter.fail";
            String[] detailPara = new String[]{filterForm.getFilterName()};
            this.optDeployNPFilter(filterForm, false, detail, detailPara);
            this.responseResult("DeployFail");
        } else if (null != resultMap && resultMap.isEmpty()) {
            String detail = "com.hs.vsm.secservice.ddos.policy.operation.deploy.npfilter.success";
            String[] detailPara = new String[]{filterForm.getFilterName()};
            this.optDeployNPFilter(filterForm, true, detail, detailPara);
            this.responseResult("success");
        }
        this.responseResult("success");
    }

    public void deleteNpFilter() {
        ArrayList<BatchOperation> batchOperation = new ArrayList<BatchOperation>();
        ArrayList<Long> filterIdList = new ArrayList<Long>();
        if (null != this.npFilterIds) {
            String[] substring;
            for (String string : substring = this.npFilterIds.substring(0, this.npFilterIds.length() - 1).split(",")) {
                filterIdList.add(Long.parseLong(string));
            }
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Long adminId = currentUser.getUserID();
        StringBuilder filterNames = new StringBuilder();
        for (Long l : filterIdList) {
            Map<String, String> queryMap = this.getConditionMap();
            queryMap.put("filterId", String.valueOf(l));
            NPFilterForm filterForm = this.npFilterService.queryById(queryMap);
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(l.longValue());
            bo.setTargetName(filterForm.getFilterName());
            bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.operation.delete.npfilter.success");
            bo.setDetailParam(new String[]{filterForm.getFilterName()});
            batchOperation.add(bo);
            filterNames.append(filterForm.getFilterName()).append(",");
        }
        filterNames.deleteCharAt(filterNames.length() - 1);
        try {
            this.npFilterService.unDeployNpFilter(filterIdList, null, null, adminId);
            this.batchOperationResult = this.npFilterService.deleteInBatch(batchOperation);
            this.bathResult(this.batchOperationResult);
            this.systemOpeLogBatch("com.hs.vsm.secservice.ddos.policy.operation.delete.npfilter", "lego.dic.module.NPFilter", false, SysoplogLevel.info.getValue(), batchOperation);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("UnDeploy NPFilter Error." + e.getMessage()));
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.delete.npfilter", "lego.dic.module.NPFilter", false, null, null, filterNames.toString(), SysoplogLevel.info.getValue(), false, (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("UnDeploy NPFilter Error." + e.getMessage()));
            this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.delete.npfilter", "lego.dic.module.NPFilter", false, null, null, filterNames.toString(), SysoplogLevel.info.getValue(), false, e);
            throw new LegoUncheckedException((Throwable)e);
        }
    }

    private void optCreateNPFilter(NPFilterForm filterForm) {
        String[] pars = new String[]{filterForm.getFilterName()};
        this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.create.npfilter", "lego.dic.module.NPFilter", false, pars, "com.hs.vsm.secservice.ddos.policy.operation.create.npfilter.success", filterForm.getFilterName(), SysoplogLevel.info.getValue(), true, null);
    }

    private void optModifyNPFilter(NPFilterForm filterForm) {
        String[] pars = new String[]{filterForm.getFilterName()};
        this.systemOpeLog("com.hs.vsm.secservice.ddos.policy.operation.modify.npfilter", "lego.dic.module.NPFilter", false, pars, "com.hs.vsm.secservice.ddos.policy.operation.modify.npfilter.success", filterForm.getFilterName(), SysoplogLevel.info.getValue(), true, null);
    }

    private void optDeployNPFilter(NPFilterForm filterForm, boolean isSuccess, String detail, String[] detailPara) {
        SysOptLog sysOptLog = new SysOptLog();
        sysOptLog.setOperation("com.hs.vsm.secservice.ddos.policy.operation.deploy.npfilter");
        sysOptLog.setModule("lego.dic.module.NPFilter");
        sysOptLog.setLevel(SysoplogLevel.normal.getValue());
        sysOptLog.setResult(isSuccess ? 1 : 0);
        sysOptLog.setTarget(filterForm.getFilterName());
        sysOptLog.setDetail(detail);
        sysOptLog.setDetailPara(detailPara);
        User user = (User)this.getSession().getAttribute("currentUser");
        sysOptLog.setOperator(user.getUserName());
        sysOptLog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        sysOptLog.setDate(new Date());
        ISysOptLog service = ZoneReferUtil.getSysOptLog();
        service.writeOptLog(sysOptLog);
    }

    public boolean validateRuleParameters() {
        NPFilterRuleForm ruleForm = this.npFilterForm.getNpFilterRuleForm();
        try {
            if (null != ruleForm) {
                String packageLength;
                String descPortSection;
                String srcPortSection;
                String srcMaskIp;
                String destMaskIp = ruleForm.getDestinationIp();
                if (null != destMaskIp && !"".equals(destMaskIp)) {
                    int mask;
                    String[] ipMask = destMaskIp.split("/");
                    if (IPUtil.isIpv4((String)ipMask[0])) {
                        mask = Integer.parseInt(ipMask[1]);
                        if (mask < 8 || mask > 32) {
                            return false;
                        }
                    } else if (IPUtil.isIpv6((String)ipMask[0])) {
                        mask = Integer.parseInt(ipMask[1]);
                        if (mask < 8 || mask > 128) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (null != (srcMaskIp = ruleForm.getSourceIp()) && !"".equals(srcMaskIp)) {
                    int mask;
                    String[] srcIpMask = srcMaskIp.split("/");
                    if (IPUtil.isIpv4((String)srcIpMask[0])) {
                        mask = Integer.parseInt(srcIpMask[1]);
                        if (mask < 8 || mask > 32) {
                            return false;
                        }
                    } else if (IPUtil.isIpv6((String)srcIpMask[0])) {
                        mask = Integer.parseInt(srcIpMask[1]);
                        if (mask < 8 || mask > 128) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (null != (srcPortSection = ruleForm.getSourcePort()) && !"".equals(srcPortSection)) {
                    int srcEndPort;
                    String[] srcPorts = srcPortSection.split("-");
                    int srcStartPort = Integer.parseInt(srcPorts[0]);
                    if (srcStartPort < 0 || srcStartPort > 65535) {
                        return false;
                    }
                    if (srcPorts.length == 2 && ((srcEndPort = Integer.parseInt(srcPorts[1])) < 0 || srcEndPort > 65535)) {
                        return false;
                    }
                }
                if (null != (descPortSection = ruleForm.getDestinationPort()) && !"".equals(descPortSection)) {
                    int descEndPort;
                    String[] descPorts = descPortSection.split("-");
                    int descStartPort = Integer.parseInt(descPorts[0]);
                    if (descStartPort < 0 || descStartPort > 65535) {
                        return false;
                    }
                    if (descPorts.length == 2 && ((descEndPort = Integer.parseInt(descPorts[1])) < 0 || descEndPort > 65535 || descStartPort == descEndPort)) {
                        return false;
                    }
                }
                if (null != (packageLength = ruleForm.getPacketLength()) && !"".equals(packageLength)) {
                    String[] packageLengthArray = packageLength.split("-");
                    if (packageLengthArray.length != 2) {
                        return false;
                    }
                    int startPackage = Integer.parseInt(packageLengthArray[0]);
                    int endPackage = Integer.parseInt(packageLengthArray[1]);
                    if (startPackage < 0 || startPackage > 65535 || endPackage < 0 || endPackage > 65535 || startPackage > endPackage) {
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Parse Integer Error." + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean validateIp(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return true;
        }
        String[] ipAndMask = ip.split("/");
        if (ipAndMask.length != 2) {
            return false;
        }
        if ("ipv4".equalsIgnoreCase(this.npFilterForm.getIpType()) && IPUtil.isIpv4((String)ipAndMask[0]) && !"0.0.0.0".equals(ipAndMask[0])) {
            int mask = Integer.parseInt(ipAndMask[1]);
            if (mask < 8 || mask > 32) {
                return false;
            }
        } else if ("ipv6".equalsIgnoreCase(this.npFilterForm.getIpType()) && IPUtil.isIpv6((String)ipAndMask[0])) {
            int mask = Integer.parseInt(ipAndMask[1]);
            if (mask < 8 || mask > 128) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean validatePort(String port) {
        if (StringUtils.isBlank((CharSequence)port)) {
            return true;
        }
        try {
            if (port.contains("-")) {
                String[] portArray = port.split("-");
                if (portArray.length != 2) {
                    return false;
                }
                int startPort = Integer.parseInt(portArray[0]);
                int endPort = Integer.parseInt(portArray[1]);
                if (startPort < 0 || startPort > 65535 || endPort < 0 || endPort > 65535) {
                    return false;
                }
                if (endPort <= startPort) {
                    return false;
                }
            } else {
                int startPort = Integer.parseInt(port);
                if (startPort < 0 || startPort > 65535) {
                    return false;
                }
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean validatePacketLength(String packetLength) {
        if (StringUtils.isBlank((CharSequence)packetLength)) {
            return true;
        }
        String[] packetArray = packetLength.split("-");
        if (packetArray.length != 2) {
            return false;
        }
        try {
            int startPackageLength = Integer.parseInt(packetArray[0]);
            int endPackageLength = Integer.parseInt(packetArray[1]);
            if (startPackageLength < 0 || startPackageLength > 65535 || endPackageLength < 0 || endPackageLength > 65535) {
                return false;
            }
            if (endPackageLength < startPackageLength) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean validateDeviceIdList() {
        if (null != this.deviceIdList && !"".equals(this.deviceIdList)) {
            boolean res = this.deviceIdList.matches("^[0-9,]+$");
            if (!res) {
                return false;
            }
            String[] deviceIdsArray = this.deviceIdList.substring(0, this.deviceIdList.length() - 1).split(",");
            if (deviceIdsArray.length > 100) {
                return false;
            }
        }
        return true;
    }

    public boolean validateNpFilterIds() {
        if (null != this.npFilterIds && !"".equals(this.npFilterIds)) {
            boolean res = this.npFilterIds.matches("^[0-9,]+$");
            if (!res) {
                return false;
            }
            String[] substring = this.npFilterIds.substring(0, this.npFilterIds.length() - 1).split(",");
            if (substring.length > 100) {
                return false;
            }
            for (String item : substring) {
                long pId = Long.parseLong(item);
                if (pId >= 1L) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, String> getConditionMap() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (currentUser == null) {
            throw new LegoSecurityException(206L);
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("userId", String.valueOf(currentUser.getUserID()));
        queryMap.put("isAdmin", currentUser.getIsAdmin());
        if (null != this.npFilterId) {
            queryMap.put("filterId", String.valueOf(this.npFilterId));
        }
        return queryMap;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

