/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class CSVReader {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private BufferedReader bufferedreader = null;
    private List<String> list = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVReader(String filename) throws IOException {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            String stemp;
            fileInputStream = new FileInputStream(filename);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, System.getProperty("file.encoding"));
            this.bufferedreader = new BufferedReader(inputStreamReader);
            while ((stemp = this.bufferedreader.readLine()) != null) {
                this.list.add(stemp);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"write unsupportedEncoding error");
        }
        catch (FileNotFoundException e) {
            log.error((Object)"write unsupportedEncoding error");
        }
        catch (IOException e) {
            log.error((Object)"write IOException error");
        }
        catch (RuntimeException e) {
            log.error((Object)"write unknowException error");
        }
        finally {
            if (null != this.bufferedreader) {
                this.closeOutputStream(this.bufferedreader);
            }
            if (null != inputStreamReader) {
                this.closeInputStream(inputStreamReader);
            }
            if (null != fileInputStream) {
                this.closeInStream(fileInputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVReader(String filename, String encode) throws IOException {
        if (null == encode || !encode.equalsIgnoreCase("UTF-8")) {
            throw new IllegalArgumentException("encode is not correct");
        }
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            String stemp;
            fileInputStream = new FileInputStream(filename);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, encode);
            this.bufferedreader = new BufferedReader(inputStreamReader);
            while ((stemp = this.bufferedreader.readLine()) != null) {
                this.list.add(stemp);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"write unsupportedEncoding error");
        }
        catch (FileNotFoundException e) {
            log.error((Object)"write unsupportedEncoding error");
        }
        catch (IOException e) {
            log.error((Object)"write IOException error");
        }
        catch (RuntimeException e) {
            log.error((Object)"write unknowException error");
        }
        finally {
            if (null != this.bufferedreader) {
                this.closeOutputStream(this.bufferedreader);
            }
            if (null != inputStreamReader) {
                this.closeInputStream(inputStreamReader);
            }
            if (null != fileInputStream) {
                this.closeInStream(fileInputStream);
            }
        }
    }

    private void closeInStream(FileInputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                log.error((Object)"close inputStream error");
            }
            finally {
                inputStream = null;
            }
        }
    }

    private void closeInputStream(InputStreamReader inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                log.error((Object)"close inputStream error");
            }
            finally {
                inputStream = null;
            }
        }
    }

    private void closeOutputStream(BufferedReader outputStream) {
        if (null != outputStream) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                log.error((Object)"close outputStream error");
            }
            finally {
                outputStream = null;
            }
        }
    }

    public List<String> getList() throws IOException {
        return this.list;
    }

    public int getRowNum() {
        return this.list.size();
    }

    public int getColNum() {
        if (!this.list.toString().equals("[]")) {
            if (this.list.get(0).contains(",")) {
                return this.list.get(0).split(",").length;
            }
            if (this.list.get(0).trim().length() != 0) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public String getRow(int index) {
        if (this.list.size() != 0) {
            return this.list.get(index);
        }
        return null;
    }

    public String getCol(int index) {
        if (this.getColNum() == 0) {
            return null;
        }
        StringBuffer scol = new StringBuffer();
        String temp2 = null;
        int colnum = this.getColNum();
        if (colnum > 1) {
            for (String temp2 : this.list) {
                scol = scol.append(temp2.split(",")[index] + ",");
            }
        } else {
            for (String temp2 : this.list) {
                scol = scol.append(temp2 + ",");
            }
        }
        String str = scol.toString();
        str = str.substring(0, str.length() - 1);
        return str;
    }

    public String getString(int row, int col) {
        String temp = null;
        int colnum = this.getColNum();
        temp = colnum > 1 ? this.list.get(row).split(",")[col] : (colnum == 1 ? this.list.get(row) : null);
        return temp;
    }

    public void csvClose() throws IOException {
        this.bufferedreader.close();
    }
}

