/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.biff.EmptyCell;

public final class FilterUtil {
    static final String REGEX = "((25[0-5]|2[0-4]\\d|1\\d{2}|0?[1-9]\\d|0?0?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|0?[1-9]\\d|0?0?\\d)";
    private static FilterUtil instance;
    private static Log logger;
    private static ReentrantLock lock;

    private FilterUtil() {
    }

    public static FilterUtil getInstance() {
        lock.lock();
        try {
            FilterUtil filterUtil = instance == null ? (FilterUtil)FilterUtil.class.newInstance() : instance;
            return filterUtil;
        }
        catch (InstantiationException e) {
            FilterUtil filterUtil = null;
            return filterUtil;
        }
        catch (IllegalAccessException e) {
            FilterUtil filterUtil = null;
            return filterUtil;
        }
        finally {
            lock.unlock();
        }
    }

    public static void closeInputStream(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)"close inputStream error");
            }
        }
    }

    public static Cell[] fillCellFilter(Cell[] cell) {
        if (cell.length == 2) {
            return cell;
        }
        Cell[] cellToFill = new Cell[2];
        System.arraycopy(cell, 0, cellToFill, 0, cell.length);
        for (int i = cell.length; i < 2; ++i) {
            cellToFill[i] = new EmptyCell(0, 0);
        }
        return cellToFill;
    }

    public static boolean isIpv4(String ip) {
        FilterUtil.checkNull(ip);
        Matcher m = Pattern.compile(REGEX).matcher(ip);
        return m.matches();
    }

    public static boolean isIpv6(String ip) {
        int i;
        FilterUtil.checkNull(ip);
        int idx = ip.indexOf("::");
        if (idx == -1) {
            String[] items = ip.split(":");
            if (items.length != 8) {
                return false;
            }
            for (int i2 = 0; i2 < items.length; ++i2) {
                if (FilterUtil.isHex(items[i2])) continue;
                return false;
            }
            return true;
        }
        if (idx != ip.lastIndexOf("::")) {
            return false;
        }
        String item = null;
        String[] items = ip.split("::");
        String[] items0 = new String[]{};
        String[] items1 = new String[]{};
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            if (null == item || item.isEmpty()) continue;
            if (i == 0) {
                if (item.startsWith(":")) {
                    return false;
                }
                items0 = item.split(":");
                continue;
            }
            if (i != 1) continue;
            if (item.endsWith(":")) {
                return false;
            }
            items1 = item.split(":");
        }
        if (items0.length + items1.length > 7) {
            return false;
        }
        for (i = 0; i < items0.length; ++i) {
            if (items0[i].isEmpty() || FilterUtil.isHex(items0[i])) continue;
            return false;
        }
        for (i = 0; i < items1.length; ++i) {
            if (items1[i].isEmpty() || FilterUtil.isHex(items1[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isHex(String str) {
        FilterUtil.checkNull(str);
        str = str.trim();
        if (str.length() == 0 || str.length() > 4) {
            return false;
        }
        str = str.toLowerCase(Locale.getDefault());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f') continue;
            return false;
        }
        return true;
    }

    private static void checkNull(String str) {
        if (null == str) {
            throw new IllegalArgumentException("input parameter of str is null.");
        }
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
    }

    public static boolean isCheckData1(String content1) {
        String regexStr = "^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$";
        return !FilterUtil.isNull(content1) && content1.matches(regexStr);
    }

    public static boolean isCheckData2(String content2) {
        String regexStr = "^(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$";
        return !FilterUtil.isNull(content2) && content2.matches(regexStr);
    }

    public static boolean isCheckData3(String content) {
        String regexStr = "^([0-9]|[1-5][0-9]|6[0-3]$)";
        return !FilterUtil.isNull(content) && content.matches(regexStr);
    }

    public static boolean isIpv4Mask(String content3) {
        String regexStr = "^1[0-9]|2[0-9]|3[0-2]|[8-9]$";
        return !FilterUtil.isNull(content3) && content3.matches(regexStr);
    }

    public static boolean isIpv6Mask(String content4) {
        String regexStr = "^[89]$|^[1-9][0-9]$|^1[0-2][0-8]$";
        return !FilterUtil.isNull(content4) && content4.matches(regexStr);
    }

    public static boolean isPacketLengthRange(String packetLength) {
        String regexStr = "^[1-9]\\d{0,2}$|^1[0-4]\\d{2}$|^1500$";
        return !FilterUtil.isNull(packetLength) && packetLength.matches(regexStr);
    }

    public static boolean isFingerprintPacketLengthRange(String packetLength) {
        String regexStr = "^[0]$";
        return !FilterUtil.isNull(packetLength) && packetLength.matches(regexStr);
    }

    public static boolean isPortRange(String portRange) {
        String regexStr = "(^[0-9]\\d{0,3}$)|(^[1-5]\\d{4}$)|(^6[0-4]\\d{3}$)|(^65[0-4]\\d{2}$)|(^655[0-2]\\d$)|(^6553[0-5]$)";
        return !FilterUtil.isNull(portRange) && portRange.matches(regexStr);
    }

    public static boolean isAnyCharacter(String content7) {
        String regexStr = "^[^\u4e00-\u9fa5]{2,63}$";
        return !FilterUtil.isNull(content7) && content7.matches(regexStr);
    }

    public static boolean isHexadecimal(String length) {
        String regexStr = "(^[0-9A-F]{4,16}$)|(^[0-9a-f]{4,16}$)";
        return !FilterUtil.isNull(length) && length.matches(regexStr);
    }

    public static boolean isOffsetRange(String offset) {
        String regexStr = "^[0-9]\\d{0,2}$|^1[0-4]\\d{2}$|^1500$";
        return !FilterUtil.isNull(offset) && offset.matches(regexStr);
    }

    public static boolean isStringContent(String content) {
        String regexStr = "^[\\S]{2,}$";
        return !FilterUtil.isNull(content);
    }

    public static boolean isFlowPacketLengthRange(String packetLength) {
        String regexStr = "(^[0-9]\\d{0,3}$)|(^[1-5]\\d{4}$)|(^6[0-4]\\d{3}$)|(^65[0-4]\\d{2}$)|(^655[0-2]\\d$)|(^6553[0-5]$)";
        return !FilterUtil.isNull(packetLength) && packetLength.matches(regexStr);
    }

    public static boolean isLegalContent(String content) {
        return !FilterUtil.isChineseChar(content) && FilterUtil.isStringContent(content);
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock uBlock = Character.UnicodeBlock.of(c);
        return uBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || uBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || uBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || uBlock == Character.UnicodeBlock.GENERAL_PUNCTUATION || uBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || uBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isChineseChar(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!FilterUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHexContent(String str) {
        boolean isHexFlg = true;
        int i = 0;
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            isHexFlg = false;
        }
        return isHexFlg;
    }

    public static boolean isRangeExist(String content, int startRange, int endRange) {
        String[] range = content.split("~");
        int start = 0;
        int end = 0;
        if (range.length == 1) {
            end = start = Integer.parseInt(range[0]);
        } else if (range.length == 2) {
            start = Integer.parseInt(range[0]);
            end = Integer.parseInt(range[1]);
        }
        return endRange >= start && end >= startRange;
    }

    public static String validateContent1(String content) {
        if (content == null || "".equals(content)) {
            return "670717";
        }
        String reg1 = "/^[\\S]{2,}$/";
        Pattern p = Pattern.compile(reg1);
        boolean tag = false;
        boolean tag1 = false;
        if (content.length() > 1) {
            if (!content.startsWith("\\x")) {
                tag = true;
            } else {
                String[] arr = content.split("\\\\x");
                if (arr.length > 1) {
                    for (int i = 1; i < arr.length; ++i) {
                        if (arr[i].length() < 3) {
                            try {
                                Integer arr16 = Integer.parseInt(arr[i], 16);
                                if (Integer.parseInt("30", 16) <= arr16 && arr16 <= Integer.parseInt("39", 16) || Integer.parseInt("41", 16) <= arr16 && arr16 <= Integer.parseInt("5A", 16) || Integer.parseInt("61", 16) <= arr16 && arr16 <= Integer.parseInt("7A", 16)) {
                                    tag = false;
                                    continue;
                                }
                                tag1 = true;
                                continue;
                            }
                            catch (NumberFormatException e) {
                                tag = true;
                            }
                        } else {
                            tag = true;
                        }
                        break;
                    }
                }
            }
        } else {
            tag = true;
        }
        Matcher m = p.matcher(content);
        if (tag && m.find()) {
            return "670717";
        }
        if (tag && (content.length() < 2 || content.length() > 128)) {
            return "670725";
        }
        if (!tag) {
            if (tag1) {
                return "670724";
            }
            String[] arr1 = content.split("\\\\x");
            if (arr1.length <= 0 || arr1.length >= 33) {
                return "670725";
            }
        }
        return "ok";
    }

    public static void checkFingerprint(String fingerPrint) {
        String[] fingers = fingerPrint.split("        ");
        for (int i = 0; i < fingers.length; ++i) {
            String offset;
            String onePart = fingers[i];
            String[] fingerContentOne = onePart.split(" ");
            if (fingerContentOne.length <= 2) {
                offset = fingerContentOne[0];
                String content = fingerContentOne[1];
                String tag = FilterUtil.validateContent(content);
                if ("670717".equals(tag)) {
                    throw new LegoCheckedException(570505L);
                }
                if ("670725".equals(tag)) {
                    throw new LegoCheckedException(670737L);
                }
                if ("670724".equals(tag)) {
                    throw new LegoCheckedException(570505L);
                }
                if (FilterUtil.isOffsetRange(offset)) continue;
                throw new LegoCheckedException(570505L);
            }
            if (fingerContentOne.length == 3) {
                offset = fingerContentOne[0];
                String contentLength = fingerContentOne[1];
                String depth = fingerContentOne[2];
                String tag = FilterUtil.validateContent(contentLength);
                if ("670717".equals(tag)) {
                    throw new LegoCheckedException(570505L);
                }
                if ("670725".equals(tag)) {
                    throw new LegoCheckedException(670737L);
                }
                if ("670724".equals(tag)) {
                    throw new LegoCheckedException(570505L);
                }
                if (FilterUtil.isOffsetRange(offset) && FilterUtil.isPacketLengthRange(depth)) continue;
                throw new LegoCheckedException(570505L);
            }
            throw new LegoCheckedException(570505L);
        }
    }

    public static String validateContent(String content) {
        if (content == null || "".equals(content)) {
            return "670717";
        }
        String reg1 = "/^[\\S]{2,}$/";
        Pattern p = Pattern.compile(reg1);
        String[] arr = content.split("\\\\x");
        for (int i = 1; i < arr.length; ++i) {
            if (arr.length == 2 && arr[0].length() == 0 && arr[1].length() == 2) {
                return "670725";
            }
            if (i > 1 || !content.startsWith("\\x")) {
                String last = arr[i - 1].substring(arr[i - 1].length() - 1, arr[i - 1].length());
                if ("\\".equals(last)) continue;
                if (arr[i].length() < 2) {
                    return "670717";
                }
                String val1 = arr[i].substring(0, 1);
                String val2 = arr[i].substring(1, 2);
                try {
                    Integer.parseInt(val1, 16);
                    Integer.parseInt(val2, 16);
                    continue;
                }
                catch (NumberFormatException e) {
                    return "670717";
                }
            }
            String val1 = arr[i].substring(0, 1);
            String val2 = arr[i].substring(1, 2);
            try {
                Integer.parseInt(val1, 16);
                Integer.parseInt(val2, 16);
                continue;
            }
            catch (NumberFormatException e) {
                return "670717";
            }
        }
        Matcher m = p.matcher(content);
        if (m.find()) {
            return "670717";
        }
        if (content.length() < 2 || content.length() > 128) {
            return "670725";
        }
        return "ok";
    }

    public static int getNumber(String filterKey) {
        if (filterKey.equals("source-ip")) {
            return 1000;
        }
        if (filterKey.equals("destination-ip")) {
            return 100;
        }
        if (filterKey.equals("packet-length")) {
            return 32;
        }
        if (filterKey.equals("ttl")) {
            return 32;
        }
        if (filterKey.equals("identification")) {
            return 32;
        }
        if (filterKey.equals("fingerprint")) {
            return 10;
        }
        if (filterKey.equals("protocol")) {
            return 32;
        }
        if (filterKey.equals("dscp")) {
            return 32;
        }
        if (filterKey.equals("tcp-flag")) {
            return 16;
        }
        if (filterKey.equals("destination-port")) {
            return 32;
        }
        if (filterKey.equals("source-port")) {
            return 32;
        }
        if (filterKey.equals("host")) {
            return 512;
        }
        if (filterKey.equals("cookie")) {
            return 512;
        }
        if (filterKey.equals("referer")) {
            return 512;
        }
        if (filterKey.equals("uri")) {
            return 512;
        }
        if (filterKey.equals("user-agent")) {
            return 512;
        }
        if (filterKey.equals("domain")) {
            return 512;
        }
        if (filterKey.equals("type")) {
            return 10;
        }
        if (filterKey.equals("caller")) {
            return 512;
        }
        if (filterKey.equals("callee")) {
            return 512;
        }
        if (filterKey.equals("fragment")) {
            return 5;
        }
        if (filterKey.equals("qr")) {
            return 2;
        }
        if (filterKey.equals("opcode")) {
            return 8;
        }
        if (filterKey.equals("flow-packets")) {
            return 32;
        }
        if (filterKey.equals("flow-octets")) {
            return 32;
        }
        if (filterKey.equals("flow-average-octets")) {
            return 32;
        }
        return 0;
    }

    static {
        logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
        lock = new ReentrantLock();
    }
}

