/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.beans.PrintBean;
import com.hs.vsm.secservice.ddos.policy.util.TimeSeriesReport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public final class JfreeChartTool {
    public static final String FILE_NAME_ERROR = "";
    public static final String ERROR_MESSAGE = "";
    private static JfreeChartTool instance = new JfreeChartTool();
    private static final int WIDTH = 700;
    private static final int HEIGHT = 300;
    private static final double NUM_ONE_HUNDRED = 100.0;
    private static final double NUM_TEN = 10.0;
    private static final double NUM_FIFTY = 50.0;
    private static final double NUM_TWO = 2.0;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private JfreeChartTool() {
    }

    public static JfreeChartTool getInstance() {
        return instance;
    }

    public String displayTimeSeriesChart(List<PrintBean> beans, String tableName, String timeAxisLabel, String valueAxisLabel, HttpSession currentSession) {
        int width = 700;
        int height = 300;
        String imgFile = "";
        try {
            TimeSeriesCollection dataset = new TimeSeriesCollection();
            for (PrintBean p : beans) {
                String serielName = p.getName();
                List<TimeSeriesReport> valueLs = p.getValues();
                TimeSeries s1 = new TimeSeries((Comparable)((Object)serielName), Second.class);
                for (TimeSeriesReport timeSeriesReport : valueLs) {
                    s1.addOrUpdate((RegularTimePeriod)new Second(timeSeriesReport.getMonitorTime()), (Number)timeSeriesReport.getValue());
                }
                dataset.addSeries(s1);
            }
            StandardChartTheme standardChartTheme = new StandardChartTheme("aticTheme");
            standardChartTheme.setLargeFont(new Font("SansSerif", 0, 12));
            standardChartTheme.setRegularFont(new Font("SansSerif", 0, 12));
            standardChartTheme.setExtraLargeFont(new Font("SansSerif", 0, 12));
            ChartFactory.setChartTheme((ChartTheme)standardChartTheme);
            TimeSeriesCollection xydataset = dataset;
            String valueAxisLabelStr = AticUtil.getText((String)valueAxisLabel);
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)tableName, (String)timeAxisLabel, (String)valueAxisLabelStr, (XYDataset)xydataset, (boolean)true, (boolean)false, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            XYPlot plot = (XYPlot)chart.getPlot();
            XYPlot xyplot = (XYPlot)chart.getPlot();
            XYLineAndShapeRenderer xylinerenderer = (XYLineAndShapeRenderer)xyplot.getRenderer();
            xylinerenderer.setSeriesPaint(0, (Paint)new Color(0, 0, 255));
            xylinerenderer.setSeriesPaint(1, (Paint)new Color(255, 0, 0));
            xylinerenderer.setSeriesPaint(2, (Paint)new Color(0, 238, 118));
            XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)plot.getRenderer();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setForegroundAlpha(1.0f);
            plot.setRangeGridlinePaint((Paint)new Color(127, 127, 127));
            plot.setRangeGridlinesVisible(true);
            plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 50.0));
            plot.getRangeAxis().setLabel(valueAxisLabelStr);
            plot.setOutlinePaint(null);
            NumberAxis number = (NumberAxis)plot.getRangeAxis();
            double upperBound = number.getUpperBound();
            if (upperBound < 100.0) {
                long temp;
                if (upperBound < 1.0) {
                    upperBound = 10.0;
                }
                long newBound = temp + ((temp = Math.round(upperBound)) % 10L == 0L ? 0L : 10L - temp % 10L);
                number.setRange(0.0, (double)newBound);
                number.setTickUnit(new NumberTickUnit((double)newBound / 10.0));
                number.centerRange((double)newBound / 2.0);
            }
            number.setNumberFormatOverride(NumberFormat.getIntegerInstance());
            xylineandshaperenderer.setBaseShapesVisible(true);
            xylineandshaperenderer.setShape((Shape)new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
            NumberAxis vn = (NumberAxis)plot.getRangeAxis();
            DecimalFormat df = new DecimalFormat("###,###");
            vn.setNumberFormatOverride((NumberFormat)df);
            DateAxis dateaxis = (DateAxis)plot.getDomainAxis();
            dateaxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"));
            imgFile = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)width, (int)height, null, (HttpSession)currentSession);
        }
        catch (IOException e) {
            this.logger.error((Object)"getting dynamicBaseLine failed");
        }
        return imgFile;
    }

    public String displayEmptyChart(String tableName, HttpSession currentSession, String contextPath) {
        int width = 700;
        int height = 300;
        String imgFile = "";
        try {
            DefaultCategoryDataset defaultDataset = new DefaultCategoryDataset();
            StandardChartTheme standardChartTheme = new StandardChartTheme("aticTheme");
            standardChartTheme.setLargeFont(new Font("SansSerif", 0, 12));
            standardChartTheme.setRegularFont(new Font("SansSerif", 0, 12));
            standardChartTheme.setExtraLargeFont(new Font("SansSerif", 0, 12));
            ChartFactory.setChartTheme((ChartTheme)standardChartTheme);
            JFreeChart chart = ChartFactory.createBarChart((String)tableName, null, null, (CategoryDataset)defaultDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            CategoryPlot plot = chart.getCategoryPlot();
            CategoryAxis domainAxis = plot.getDomainAxis();
            domainAxis.setAxisLineVisible(false);
            plot.setOutlinePaint(null);
            ValueAxis rangeAxis = plot.getRangeAxis();
            rangeAxis.setAxisLineVisible(false);
            plot.setBackgroundPaint((Paint)Color.WHITE);
            NumberAxis number = (NumberAxis)plot.getRangeAxis();
            number.setVisible(false);
            imgFile = contextPath + "/servlet/DisplayChart?filename=" + ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)width, (int)height, null, (HttpSession)currentSession);
        }
        catch (IOException ex) {
            this.logger.error((Object)"getting block picture failed");
        }
        return imgFile;
    }
}

