/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.vsm.secservice.nfa.util.NfaPolicyUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class NfaCheckUtil {
    public static final int PPS_KMAXVALUE = 4294967;
    public static final int PPS_MMAXVALUE = 4294;
    public static final int PPS_GMAXVALUE = 4;
    public static final int BPS_MMAXVALUE = 4294967;
    public static final int BPS_GMAXVALUE = 4294;
    private static final int MINVALUE = 1;
    private static final long PPS_MAXVALUE = 0x100000000L;
    private static final long PPS_MAXVALUE_2 = Integer.MAX_VALUE;
    private static final long BPS_MAXVALUE = 0x100000000L;
    private static final long BPS_MAXVALUE_2 = Integer.MAX_VALUE;
    private static NfaCheckUtil instance;
    private static ReentrantLock lock;

    private NfaCheckUtil() {
    }

    public static NfaCheckUtil getInstance() {
        lock.lock();
        try {
            NfaCheckUtil nfaCheckUtil = instance == null ? (NfaCheckUtil)NfaCheckUtil.class.newInstance() : instance;
            return nfaCheckUtil;
        }
        catch (InstantiationException e) {
            NfaCheckUtil nfaCheckUtil = null;
            return nfaCheckUtil;
        }
        catch (IllegalAccessException e) {
            NfaCheckUtil nfaCheckUtil = null;
            return nfaCheckUtil;
        }
        finally {
            lock.unlock();
        }
    }

    public static void checkNfaPolicyThreashold(NfaPolicyEditForm nfaPolicyEditForm) {
        List<NfaPolicyForm> nfaList = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(nfaPolicyEditForm);
        Iterator<NfaPolicyForm> iterator = nfaList.iterator();
        while (iterator.hasNext()) {
            NfaPolicyForm nfaPolicyFormTemp;
            NfaPolicyForm nfaPolicyForm = nfaPolicyFormTemp = iterator.next();
            String name = nfaPolicyForm.getName();
            NfaCheckUtil.checkNfaName(name);
            Long pkid = nfaPolicyForm.getPkid();
            Long zoneId = nfaPolicyForm.getZoneId();
            NfaCheckUtil.checkLongId(pkid);
            NfaCheckUtil.checkLongId(zoneId);
            nfaPolicyForm = NfaCheckUtil.method(nfaPolicyEditForm, nfaPolicyForm, name);
            NfaCheckUtil.checkThreshold(nfaPolicyForm);
            NfaCheckUtil.checkPpsThreshold(nfaPolicyForm);
            NfaCheckUtil.checkBpsThreshold(nfaPolicyForm);
        }
    }

    private static void checkThreshold(NfaPolicyForm nfaPolicyForm) {
        ArrayList<String> ppsTList = new ArrayList<String>();
        ppsTList.add("pps");
        ppsTList.add("Kpps");
        ppsTList.add("Mpps");
        ppsTList.add("Gpps");
        if (null != nfaPolicyForm.getPpsUnit() && !ppsTList.contains(nfaPolicyForm.getPpsUnit())) {
            throw new LegoCheckedException(570505L);
        }
        ArrayList<String> bpsList = new ArrayList<String>();
        bpsList.add("Kbps");
        bpsList.add("Mbps");
        bpsList.add("Gbps");
        if (null != nfaPolicyForm.getBpsUnit() && !bpsList.contains(nfaPolicyForm.getBpsUnit())) {
            throw new LegoCheckedException(570505L);
        }
    }

    private static void checkLongId(Long id) {
        if (null != id && id < 0L) {
            throw new LegoCheckedException(570505L);
        }
    }

    private static void checkNfaName(String name) {
        ArrayList<String> nfaNames = new ArrayList<String>();
        nfaNames.add("Host_Traffic_Overflow");
        nfaNames.add("Tcp_Syn_Flood");
        nfaNames.add("Tcp_Fragment_Flood");
        nfaNames.add("Tcp_Ack_Flood");
        nfaNames.add("Tcp_Malformed_Flood");
        nfaNames.add("Tcp_RstFin_Flood");
        nfaNames.add("Udp_Flood");
        nfaNames.add("Udp_Fragment_Flood");
        nfaNames.add("Dns_Query_Flood");
        nfaNames.add("Dns_Reply_Flood");
        nfaNames.add("Http_Flood");
        nfaNames.add("Https_Flood");
        nfaNames.add("Sip_Flood");
        nfaNames.add("Icmp_Flood");
        nfaNames.add("Other_Flood");
        nfaNames.add("Dark_Ip");
        if (null != name && !nfaNames.contains(name)) {
            throw new LegoCheckedException(570505L);
        }
    }

    private static void checkPpsThreshold(NfaPolicyForm nfaPolicyForm) {
        if (null == nfaPolicyForm || !NfaCheckUtil.isNumber(String.valueOf(nfaPolicyForm.getPpsThreshold()))) {
            throw new LegoCheckedException(670804L);
        }
        if (nfaPolicyForm.getPpsUnit().contains("K")) {
            if (nfaPolicyForm.getPpsThreshold() > 4294967L || nfaPolicyForm.getPpsThreshold() < 1L) {
                throw new LegoCheckedException(670801L);
            }
        } else if (nfaPolicyForm.getPpsUnit().contains("M")) {
            if (nfaPolicyForm.getPpsThreshold() > 4294L || nfaPolicyForm.getPpsThreshold() < 1L) {
                throw new LegoCheckedException(670802L);
            }
        } else if (nfaPolicyForm.getPpsUnit().contains("G")) {
            if (nfaPolicyForm.getPpsThreshold() > 4L || nfaPolicyForm.getPpsThreshold() < 1L) {
                throw new LegoCheckedException(670803L);
            }
        } else if (nfaPolicyForm.getPpsUnit().contains("pps") && (nfaPolicyForm.getPpsThreshold() > Integer.MAX_VALUE || nfaPolicyForm.getPpsThreshold() < 1L)) {
            throw new LegoCheckedException(670800L);
        }
    }

    private static void checkBpsThreshold(NfaPolicyForm nfaPolicyForm) {
        if (null == nfaPolicyForm || !NfaCheckUtil.isNumber(String.valueOf(nfaPolicyForm.getPpsThreshold()))) {
            throw new LegoCheckedException(670808L);
        }
        if (nfaPolicyForm.getBpsUnit().contains("M")) {
            if (nfaPolicyForm.getBpsThreshold() > 4294967L || nfaPolicyForm.getBpsThreshold() < 1L) {
                throw new LegoCheckedException(670806L);
            }
        } else if (nfaPolicyForm.getBpsUnit().contains("G")) {
            if (nfaPolicyForm.getBpsThreshold() > 4294L || nfaPolicyForm.getBpsThreshold() < 1L) {
                throw new LegoCheckedException(670807L);
            }
        } else if (nfaPolicyForm.getBpsUnit().contains("Kbps") && (nfaPolicyForm.getBpsThreshold() > Integer.MAX_VALUE || nfaPolicyForm.getBpsThreshold() < 1L)) {
            throw new LegoCheckedException(670805L);
        }
    }

    public static boolean isNumber(String str) {
        String regex = "^[0-9]*$";
        return !AticUtil.isNull((String)str) && str.matches(regex);
    }

    public static boolean checkNfaParam(NfaPolicyEditForm nfaPolicyEditForm) {
        List<NfaPolicyForm> nfaList = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(nfaPolicyEditForm);
        Iterator<NfaPolicyForm> iterator = nfaList.iterator();
        if (iterator.hasNext()) {
            NfaPolicyForm nfaPolicyFormTemp;
            NfaPolicyForm nfaPolicyForm = nfaPolicyFormTemp = iterator.next();
            String name = nfaPolicyForm.getName();
            return NfaCheckUtil.checkPpsThresholdone(nfaPolicyForm = NfaCheckUtil.method(nfaPolicyEditForm, nfaPolicyForm, name)) && NfaCheckUtil.checkBpsThresholdone(nfaPolicyForm);
        }
        return true;
    }

    private static NfaPolicyForm method(NfaPolicyEditForm nfaPolicyEditForm, NfaPolicyForm nfaPolicyForm, String name) {
        if ("Host_Traffic_Overflow".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getHostTotal();
        } else if ("Tcp_Syn_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpSynFlood();
        } else if ("Tcp_Fragment_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpFragmentFlood();
        } else if ("Tcp_Ack_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpAckFlood();
        }
        nfaPolicyForm = NfaCheckUtil.methodone(nfaPolicyEditForm, name, nfaPolicyForm);
        nfaPolicyForm = NfaCheckUtil.methodtwo(nfaPolicyEditForm, name, nfaPolicyForm);
        return nfaPolicyForm;
    }

    private static NfaPolicyForm methodtwo(NfaPolicyEditForm nfaPolicyEditForm, String name, NfaPolicyForm nfaPolicyForm) {
        if ("Http_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getHttpFlood();
        } else if ("Https_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getHttpsFlood();
        } else if ("Sip_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getSipFlood();
        } else if ("Icmp_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getIcmpFlood();
        } else if ("Other_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getOtherFlood();
        } else if ("Dark_Ip".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getDarkIp();
        }
        return nfaPolicyForm;
    }

    private static NfaPolicyForm methodone(NfaPolicyEditForm nfaPolicyEditForm, String name, NfaPolicyForm nfaPolicyForm) {
        if ("Tcp_Malformed_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpAbnormalFlood();
        } else if ("Tcp_RstFin_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpRstFinFlood();
        } else if ("Udp_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getUdpFlood();
        } else if ("Udp_Fragment_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getUdpFragmentFlood();
        } else if ("Dns_Query_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getUdpFragmentFlood();
        } else if ("Dns_Reply_Flood".equals(name)) {
            nfaPolicyForm = nfaPolicyEditForm.getDnsReplyFlood();
        }
        return nfaPolicyForm;
    }

    private static boolean checkPpsThresholdone(NfaPolicyForm nfaPolicyForm) {
        if (null == nfaPolicyForm || !NfaCheckUtil.isNumber(String.valueOf(nfaPolicyForm.getPpsThreshold()))) {
            return false;
        }
        return !(nfaPolicyForm.getPpsUnit().contains("K") ? nfaPolicyForm.getPpsThreshold() > 4294967L || nfaPolicyForm.getPpsThreshold() < 1L : (nfaPolicyForm.getPpsUnit().contains("M") ? nfaPolicyForm.getPpsThreshold() > 4294L || nfaPolicyForm.getPpsThreshold() < 1L : (nfaPolicyForm.getPpsUnit().contains("G") ? nfaPolicyForm.getPpsThreshold() > 4L || nfaPolicyForm.getPpsThreshold() < 1L : nfaPolicyForm.getPpsUnit().contains("pps") && (nfaPolicyForm.getPpsThreshold() > Integer.MAX_VALUE || nfaPolicyForm.getPpsThreshold() < 1L))));
    }

    private static boolean checkBpsThresholdone(NfaPolicyForm nfaPolicyForm) {
        if (null == nfaPolicyForm || !NfaCheckUtil.isNumber(String.valueOf(nfaPolicyForm.getPpsThreshold()))) {
            return false;
        }
        return !(nfaPolicyForm.getBpsUnit().contains("M") ? nfaPolicyForm.getBpsThreshold() > 4294967L || nfaPolicyForm.getBpsThreshold() < 1L : (nfaPolicyForm.getBpsUnit().contains("G") ? nfaPolicyForm.getBpsThreshold() > 4294L || nfaPolicyForm.getBpsThreshold() < 1L : nfaPolicyForm.getBpsUnit().contains("Kbps") && (nfaPolicyForm.getBpsThreshold() > 0x100000000L || nfaPolicyForm.getBpsThreshold() < 1L)));
    }

    static {
        lock = new ReentrantLock();
    }
}

