/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class BlackWhiteListCache {
    private Map<String, List<ZoneBlackWhiteForm>> black2Add = new HashMap<String, List<ZoneBlackWhiteForm>>();
    private Map<String, List<ZoneBlackWhiteForm>> black2Delete = new HashMap<String, List<ZoneBlackWhiteForm>>();
    private Map<String, List<ZoneBlackWhiteForm>> white2Add = new HashMap<String, List<ZoneBlackWhiteForm>>();
    private Map<String, List<ZoneBlackWhiteForm>> white2Delete = new HashMap<String, List<ZoneBlackWhiteForm>>();

    private BlackWhiteListCache() {
    }

    public static BlackWhiteListCache getInstance() {
        return BlackWhiteListCacheHolder.instance;
    }

    public synchronized void insertPreAddBlackInfo(String pageId, ZoneBlackWhiteForm blackWhiteListInfo) {
        List<ZoneBlackWhiteForm> list = this.black2Add.get(pageId);
        if (null == list) {
            list = new ArrayList<ZoneBlackWhiteForm>();
            this.black2Add.put(pageId, list);
        }
        if (null == blackWhiteListInfo || null == blackWhiteListInfo.getBlackWhiteType() || null == blackWhiteListInfo.getZoneId() || null == blackWhiteListInfo.getIpAddress() || null == blackWhiteListInfo.getMask()) {
            return;
        }
        for (ZoneBlackWhiteForm form : list) {
            if (null == form || null == form.getBlackWhiteType() || null == form.getZoneId() || null == form.getIpAddress() || null == form.getMask() || !blackWhiteListInfo.getBlackWhiteType().equals(form.getBlackWhiteType()) || !blackWhiteListInfo.getZoneId().equals(form.getZoneId()) || !blackWhiteListInfo.getIpAddress().equals(form.getIpAddress()) || !blackWhiteListInfo.getMask().equals(form.getMask())) continue;
            return;
        }
        blackWhiteListInfo.setPkid(0L);
        list.add(blackWhiteListInfo);
    }

    public synchronized void insertPreDeleteBlackInfo(String pageId, ZoneBlackWhiteForm blackWhiteListInfo) {
        List<ZoneBlackWhiteForm> list = this.black2Delete.get(pageId);
        List<ZoneBlackWhiteForm> toadd = this.black2Add.get(pageId);
        if (null == list) {
            list = new ArrayList<ZoneBlackWhiteForm>();
            this.black2Delete.put(pageId, list);
        }
        if (null == toadd) {
            toadd = new ArrayList<ZoneBlackWhiteForm>();
            this.black2Add.put(pageId, toadd);
        }
        if (null == blackWhiteListInfo || null == blackWhiteListInfo.getBlackWhiteType() || null == blackWhiteListInfo.getZoneId() || null == blackWhiteListInfo.getIpAddress() || null == blackWhiteListInfo.getMask()) {
            return;
        }
        ZoneBlackWhiteForm repeat = null;
        for (ZoneBlackWhiteForm blackWhite : toadd) {
            if (null == blackWhite || null == blackWhite.getBlackWhiteType() || null == blackWhite.getZoneId() || null == blackWhite.getIpAddress() || null == blackWhite.getMask() || !blackWhiteListInfo.getBlackWhiteType().equals(blackWhite.getBlackWhiteType()) || !blackWhiteListInfo.getZoneId().equals(blackWhite.getZoneId()) || !blackWhiteListInfo.getIpAddress().equals(blackWhite.getIpAddress()) || !blackWhiteListInfo.getMask().equals(blackWhite.getMask())) continue;
            repeat = blackWhite;
        }
        if (null != repeat) {
            toadd.remove(repeat);
            return;
        }
        list.add(blackWhiteListInfo);
    }

    public synchronized List<ZoneBlackWhiteForm> getZoneBlackAddList(String pageId) {
        List<ZoneBlackWhiteForm> temp = this.black2Add.get(pageId);
        if (null == temp) {
            return new ArrayList<ZoneBlackWhiteForm>();
        }
        ArrayList<ZoneBlackWhiteForm> result = new ArrayList<ZoneBlackWhiteForm>();
        for (ZoneBlackWhiteForm form : temp) {
            ZoneBlackWhiteForm clone = new ZoneBlackWhiteForm();
            BeanUtils.copyProperties((Object)form, (Object)clone);
            result.add(clone);
        }
        return result;
    }

    public synchronized List<ZoneBlackWhiteForm> getZoneBlackDeleteList(String pageId) {
        List<ZoneBlackWhiteForm> temp = this.black2Delete.get(pageId);
        if (null == temp) {
            return new ArrayList<ZoneBlackWhiteForm>();
        }
        ArrayList<ZoneBlackWhiteForm> result = new ArrayList<ZoneBlackWhiteForm>();
        for (ZoneBlackWhiteForm form : temp) {
            ZoneBlackWhiteForm clone = new ZoneBlackWhiteForm();
            BeanUtils.copyProperties((Object)form, (Object)clone);
            result.add(clone);
        }
        return result;
    }

    public synchronized void insertPreAddWhiteInfo(String pageId, ZoneBlackWhiteForm blackWhiteListInfo) {
        List<ZoneBlackWhiteForm> list = this.white2Add.get(pageId);
        if (null == list) {
            list = new ArrayList<ZoneBlackWhiteForm>();
            this.white2Add.put(pageId, list);
        }
        for (ZoneBlackWhiteForm form : list) {
            if (null == form || null == form.getBlackWhiteType() || null == form.getZoneId() || null == form.getIpAddress() || null == form.getMask() || !blackWhiteListInfo.getBlackWhiteType().equals(form.getBlackWhiteType()) || !blackWhiteListInfo.getZoneId().equals(form.getZoneId()) || !blackWhiteListInfo.getIpAddress().equals(form.getIpAddress()) || !blackWhiteListInfo.getMask().equals(form.getMask())) continue;
            return;
        }
        blackWhiteListInfo.setPkid(0L);
        list.add(blackWhiteListInfo);
    }

    public synchronized void insertPreDeleteWhiteInfo(String pageId, ZoneBlackWhiteForm blackWhiteListInfo) {
        List<ZoneBlackWhiteForm> list = this.white2Delete.get(pageId);
        List<ZoneBlackWhiteForm> toadd = this.white2Add.get(pageId);
        if (null == list) {
            list = new ArrayList<ZoneBlackWhiteForm>();
            this.white2Delete.put(pageId, list);
        }
        if (null == toadd) {
            toadd = new ArrayList<ZoneBlackWhiteForm>();
            this.white2Add.put(pageId, toadd);
        }
        if (null == blackWhiteListInfo || null == blackWhiteListInfo.getBlackWhiteType() || null == blackWhiteListInfo.getZoneId() || null == blackWhiteListInfo.getIpAddress() || null == blackWhiteListInfo.getMask()) {
            return;
        }
        ZoneBlackWhiteForm repeat = null;
        for (ZoneBlackWhiteForm blackWhite : toadd) {
            if (null == blackWhite || null == blackWhite.getBlackWhiteType() || null == blackWhite.getZoneId() || null == blackWhite.getIpAddress() || null == blackWhite.getMask() || !blackWhiteListInfo.getBlackWhiteType().equals(blackWhite.getBlackWhiteType()) || !blackWhiteListInfo.getZoneId().equals(blackWhite.getZoneId()) || !blackWhiteListInfo.getIpAddress().equals(blackWhite.getIpAddress()) || !blackWhiteListInfo.getMask().equals(blackWhite.getMask())) continue;
            repeat = blackWhite;
        }
        if (null != repeat) {
            toadd.remove(repeat);
            return;
        }
        list.add(blackWhiteListInfo);
    }

    public synchronized List<ZoneBlackWhiteForm> getZoneWhiteAddList(String pageId) {
        List<ZoneBlackWhiteForm> temp = this.white2Add.get(pageId);
        if (null == temp) {
            return new ArrayList<ZoneBlackWhiteForm>();
        }
        ArrayList<ZoneBlackWhiteForm> result = new ArrayList<ZoneBlackWhiteForm>();
        for (ZoneBlackWhiteForm form : temp) {
            ZoneBlackWhiteForm clone = new ZoneBlackWhiteForm();
            BeanUtils.copyProperties((Object)form, (Object)clone);
            result.add(clone);
        }
        return result;
    }

    public synchronized List<ZoneBlackWhiteForm> getZoneWhiteDeleteList(String pageId) {
        List<ZoneBlackWhiteForm> temp = this.white2Delete.get(pageId);
        if (null == temp) {
            return new ArrayList<ZoneBlackWhiteForm>();
        }
        ArrayList<ZoneBlackWhiteForm> result = new ArrayList<ZoneBlackWhiteForm>();
        for (ZoneBlackWhiteForm form : temp) {
            ZoneBlackWhiteForm clone = new ZoneBlackWhiteForm();
            BeanUtils.copyProperties((Object)form, (Object)clone);
            result.add(clone);
        }
        return result;
    }

    public synchronized void clearBlackAll(String pageId) {
        if (!this.black2Add.containsKey(pageId)) {
            return;
        }
        this.black2Add.remove(pageId);
    }

    public synchronized void clearWhiteAll(String pageId) {
        if (!this.white2Add.containsKey(pageId)) {
            return;
        }
        this.white2Add.remove(pageId);
    }

    public synchronized void clearPreDelBlackAll(String pageId) {
        if (!this.black2Delete.containsKey(pageId)) {
            return;
        }
        this.black2Delete.remove(pageId);
    }

    public synchronized void clearPreDelWhiteAll(String pageId) {
        if (!this.white2Delete.containsKey(pageId)) {
            return;
        }
        this.white2Delete.remove(pageId);
    }

    private static class BlackWhiteListCacheHolder {
        private static BlackWhiteListCache instance = new BlackWhiteListCache();

        private BlackWhiteListCacheHolder() {
        }
    }
}

