/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.dao.ZoneDao;
import com.hs.atic.zone.model.ZoneInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.dao.BlackWhiteListDao;
import com.hs.vsm.secservice.ddos.dao.BlackWhiteStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.model.BlackWhiteListInfo;
import com.hs.vsm.secservice.ddos.model.BlackWhiteStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.service.BlackWhiteListCache;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IBlackWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class BlackWhiteListServiceImpl
implements IBlackWhiteListService {
    private static final int DEVICE_CLEAN_TYPE = 0;
    private static final int DEVICE_DETECT_TYPE = 1;
    private static final int DEVICE_MIX_TYPE = 2;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private BlackWhiteListDao blackWhiteListDao;
    private BlackWhiteStatusDao blackWhiteStatusDao;
    private ZoneDao zoneDao;
    private IAticDeviceService aticDeviceService;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private String zoneStringAndZoneDesc;

    @Override
    public List<ZoneBlackWhiteForm> queryBlackWhiteListByZoneIdAndType(Long zoneId, int blackWhiteType) {
        this.logger.info((Object)"query blackWhiteList by zoneid and deviceId and type start");
        try {
            ArrayList<ZoneBlackWhiteForm> blackWhiteForms = new ArrayList<ZoneBlackWhiteForm>();
            List<BlackWhiteStatusInfo> listInfos = this.blackWhiteStatusDao.queryBlackWhiteByZoneIdAndDeviceIdAndType(zoneId, blackWhiteType);
            for (BlackWhiteStatusInfo bInfo : listInfos) {
                ZoneBlackWhiteForm form = new ZoneBlackWhiteForm();
                VsmUtil.getInstance().copyProperties(bInfo, form);
                ZoneInfo zoneInfo = this.zoneDao.getByZoneId(bInfo.getZoneId());
                if (null == zoneInfo || null == zoneInfo.getZoneName()) continue;
                form.setZoneName(zoneInfo.getZoneName());
                form.setDeleteFlag(1);
                blackWhiteForms.add(form);
            }
            return blackWhiteForms;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            throw new LegoCheckedException(571805L, (Throwable)e);
        }
    }

    @Override
    public List<ZoneBlackWhiteForm> queryConfigBlackWhiteListByZoneIdAndType(Long zoneId, int blackWhiteType) {
        ArrayList<ZoneBlackWhiteForm> blackWhiteForms = new ArrayList<ZoneBlackWhiteForm>();
        List<BlackWhiteListInfo> listInfos = this.blackWhiteListDao.getBlackWhiteListByZoneIdAndType(zoneId, blackWhiteType);
        for (BlackWhiteListInfo bInfo : listInfos) {
            ZoneBlackWhiteForm form = new ZoneBlackWhiteForm();
            VsmUtil.getInstance().copyProperties(bInfo, form);
            blackWhiteForms.add(form);
        }
        return blackWhiteForms;
    }

    @Override
    public List<ZoneBlackWhiteForm> queryAllByType(int blackWhiteType, Long userId, boolean isAdmin) {
        this.logger.info((Object)"query blackWhiteList by type start");
        try {
            ArrayList<ZoneBlackWhiteForm> blackWhiteForms = new ArrayList<ZoneBlackWhiteForm>();
            List<BlackWhiteStatusInfo> listInfos = this.blackWhiteStatusDao.queryAllByType(blackWhiteType, userId, isAdmin);
            for (BlackWhiteStatusInfo bInfo : listInfos) {
                ZoneBlackWhiteForm form = new ZoneBlackWhiteForm();
                VsmUtil.getInstance().copyProperties(bInfo, form);
                ZoneInfo zInfo = this.zoneDao.getByZoneId(bInfo.getZoneId());
                if (zInfo != null && !AticUtil.isNull((String)zInfo.getZoneName())) {
                    String zoneName = zInfo.getZoneName();
                    form.setZoneName(zoneName);
                    blackWhiteForms.add(form);
                    continue;
                }
                this.logger.error((Object)("zone [" + bInfo.getZoneId() + "] Info or zone name is null !"));
            }
            return blackWhiteForms;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            throw new LegoCheckedException(571805L, (Throwable)e);
        }
    }

    private boolean checkDeviceType(Long deviceId) {
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (null == aticDevice) {
            return false;
        }
        return aticDevice.getDdosType() == 0 || aticDevice.getDdosType() == 1 || aticDevice.getDdosType() == 2;
    }

    @Override
    public void deleteBlackWhiteByForm(List<ZoneBlackWhiteForm> blackWhiteForms) {
        for (ZoneBlackWhiteForm form : blackWhiteForms) {
            this.blackWhiteListDao.deleteBlackWhiteByForm(form);
        }
    }

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        String regular;
        String[] pkids;
        ArrayList<ZoneBlackWhiteForm> blackWhiteForms = new ArrayList<ZoneBlackWhiteForm>();
        HashMap<Integer, String> condition = new HashMap<Integer, String>();
        StringBuffer hql = new StringBuffer();
        hql.append("FROM BlackWhiteListInfo WHERE 1=1 ");
        int index = 0;
        for (Map.Entry<String, String> entry : queryMap.entrySet()) {
            if (entry.getKey().equals("pkids") || entry.getKey().equals("sortType") || entry.getKey().equals("sortName")) continue;
            hql.append(" AND " + entry.getKey() + "=?" + index);
            condition.put(index++, entry.getValue());
        }
        for (String id : pkids = null != queryMap.get("pkids") && queryMap.get("pkids").split(",").length > 0 ? queryMap.get("pkids").split(",") : new String[]{}) {
            hql.append(" AND pkid != ?" + index);
            condition.put(index++, id);
        }
        String string = queryMap.get("sortType");
        String sortName = queryMap.get("sortName");
        if (null != string && null != sortName && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (string.trim().equalsIgnoreCase("desc") || string.trim().equalsIgnoreCase("asc"))) {
            hql.append(" order by " + sortName + "  " + string);
        }
        List list = new ArrayList();
        if (pageSize > 0) {
            list = this.blackWhiteListDao.queryPageByHql(hql.toString(), start, pageSize, condition);
        }
        Paging paging = new Paging();
        ZoneBlackWhiteForm zoneBlackWhiteForm = null;
        for (BlackWhiteListInfo bInfo : list) {
            zoneBlackWhiteForm = new ZoneBlackWhiteForm();
            VsmUtil.getInstance().copyProperties(bInfo, zoneBlackWhiteForm);
            blackWhiteForms.add(zoneBlackWhiteForm);
        }
        paging.setData(blackWhiteForms);
        paging.setCount(this.blackWhiteListDao.getRowCountByHsql(hql.toString(), condition));
        return paging;
    }

    @Override
    public int saveZoneBlackWhiteList(ZoneBlackWhiteForm zoneBlackWhiteForm) {
        int resultStr;
        Long zoneId = zoneBlackWhiteForm.getZoneId();
        if (null == zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BlackWhiteListInfo blackWhiteListInfoIsExist = this.blackWhiteListDao.queryBlackWhiteByForm(zoneBlackWhiteForm);
        if (blackWhiteListInfoIsExist != null) {
            blackWhiteListInfoIsExist.setDeleteFlag(0);
            this.blackWhiteListDao.update(blackWhiteListInfoIsExist);
            return 0;
        }
        int blackWhiteInfoListNumber = this.blackWhiteListDao.getBlackWhiteListNumberByZoneId(zoneId);
        if (blackWhiteInfoListNumber >= 1000) {
            return 1000;
        }
        List<BlackWhiteListInfo> blackWhiteInfoList = this.blackWhiteListDao.getBlackWhiteListByZoneId(zoneId);
        if (blackWhiteInfoList.size() > 0 && 0 != (resultStr = this.checkIpAndMaskInBlackWhiteList(blackWhiteInfoList, zoneBlackWhiteForm))) {
            return resultStr;
        }
        BlackWhiteListInfo blackWhiteListInfo = new BlackWhiteListInfo();
        VsmUtil.getInstance().copyProperties(zoneBlackWhiteForm, blackWhiteListInfo);
        this.logger.info((Object)("save zone blacklist or whitelist :" + blackWhiteListInfo.toString()));
        this.blackWhiteListDao.save(blackWhiteListInfo);
        return 0;
    }

    @Override
    public int saveZoneBlackWhiteListCache(ZoneBlackWhiteForm zoneBlackWhiteForm) {
        Long zoneId = zoneBlackWhiteForm.getZoneId();
        if (null == zoneId) {
            throw new LegoCheckedException(630111L);
        }
        BlackWhiteListInfo blackWhiteListInfoIsExist = this.blackWhiteListDao.queryBlackWhiteByForm(zoneBlackWhiteForm);
        if (blackWhiteListInfoIsExist != null) {
            blackWhiteListInfoIsExist.setDeleteFlag(0);
            this.blackWhiteListDao.update(blackWhiteListInfoIsExist);
            return 0;
        }
        List<ZoneBlackWhiteForm> cacheDelBlackList = BlackWhiteListCache.getInstance().getZoneBlackDeleteList(zoneBlackWhiteForm.getZoneBlackWhitePageId());
        List<ZoneBlackWhiteForm> cacheDelWhiteList = BlackWhiteListCache.getInstance().getZoneWhiteDeleteList(zoneBlackWhiteForm.getZoneBlackWhitePageId());
        List pkidsExpect = null;
        if (cacheDelBlackList.size() > 0 || cacheDelWhiteList.size() > 0) {
            ArrayList<ZoneBlackWhiteForm> list = new ArrayList<ZoneBlackWhiteForm>();
            list.addAll(cacheDelBlackList);
            list.addAll(cacheDelWhiteList);
            pkidsExpect = list.stream().map(each -> each.getPkid()).collect(Collectors.toList());
        }
        List<BlackWhiteListInfo> blackWhiteInfoList = this.blackWhiteListDao.getBlackWhiteListByZoneId(zoneId, pkidsExpect);
        List<ZoneBlackWhiteForm> cacheAddBlackList = BlackWhiteListCache.getInstance().getZoneBlackAddList(zoneBlackWhiteForm.getZoneBlackWhitePageId());
        List<ZoneBlackWhiteForm> cacheAddWhiteList = BlackWhiteListCache.getInstance().getZoneWhiteAddList(zoneBlackWhiteForm.getZoneBlackWhitePageId());
        if (blackWhiteInfoList.size() + cacheAddBlackList.size() + cacheAddWhiteList.size() >= 1000) {
            return 1000;
        }
        ArrayList<ZoneBlackWhiteForm> zoneBlackWhiteFormDB = new ArrayList<ZoneBlackWhiteForm>();
        for (BlackWhiteListInfo dbInfo : blackWhiteInfoList) {
            ZoneBlackWhiteForm z = new ZoneBlackWhiteForm();
            BeanUtils.copyProperties((Object)dbInfo, (Object)z);
            zoneBlackWhiteFormDB.add(z);
        }
        if (cacheAddBlackList.size() > 0 || cacheAddWhiteList.size() > 0 || zoneBlackWhiteFormDB.size() > 0) {
            ArrayList<ZoneBlackWhiteForm> list = new ArrayList<ZoneBlackWhiteForm>();
            list.addAll(cacheAddBlackList);
            list.addAll(cacheAddWhiteList);
            list.addAll(zoneBlackWhiteFormDB);
            int resultStr = this.checkCacheIpAndMaskInBlackWhiteList(list, zoneBlackWhiteForm);
            if (0 != resultStr) {
                return resultStr;
            }
        }
        BlackWhiteListInfo blackWhiteListInfo = new BlackWhiteListInfo();
        VsmUtil.getInstance().copyProperties(zoneBlackWhiteForm, blackWhiteListInfo);
        this.logger.info((Object)("save zone blacklist or whitelist :" + blackWhiteListInfo.toString()));
        if (null != zoneBlackWhiteForm.getBlackWhiteType() && zoneBlackWhiteForm.getBlackWhiteType() == 1) {
            this.logger.info((Object)("saveZoneBlackWhiteListCache 1 zoneBlackWhitePageId =" + zoneBlackWhiteForm.getZoneBlackWhitePageId() + " insertPreAddBlackInfo = " + zoneBlackWhiteForm.toString()));
            BlackWhiteListCache.getInstance().insertPreAddBlackInfo(zoneBlackWhiteForm.getZoneBlackWhitePageId(), zoneBlackWhiteForm);
        } else if (null != zoneBlackWhiteForm.getBlackWhiteType() && zoneBlackWhiteForm.getBlackWhiteType() == 2) {
            this.logger.info((Object)("saveZoneBlackWhiteListCache 2 zoneBlackWhitePageId =" + zoneBlackWhiteForm.getZoneBlackWhitePageId() + " insertPreAddWhiteInfo = " + zoneBlackWhiteForm.toString()));
            BlackWhiteListCache.getInstance().insertPreAddWhiteInfo(zoneBlackWhiteForm.getZoneBlackWhitePageId(), zoneBlackWhiteForm);
        }
        return 0;
    }

    @Override
    public boolean preSaveZoneBlackWhiteListCheck(long zoneId, List<ZoneBlackWhiteForm> toadd, List<ZoneBlackWhiteForm> todelete) {
        List pkidsExpect = null;
        if (null != todelete && todelete.size() > 0) {
            pkidsExpect = todelete.stream().map(each -> each.getPkid()).collect(Collectors.toList());
        }
        List<BlackWhiteListInfo> blackWhiteInfoList = this.blackWhiteListDao.getBlackWhiteListByZoneId(zoneId, pkidsExpect);
        HashMap<Long, ZoneBlackWhiteForm> dbBlackWhiteMap = new HashMap<Long, ZoneBlackWhiteForm>();
        if (blackWhiteInfoList.size() > 0) {
            for (BlackWhiteListInfo info : blackWhiteInfoList) {
                if (null == info || null == info.getPkid()) continue;
                ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
                BeanUtils.copyProperties((Object)info, (Object)zoneBlackWhiteForm);
                dbBlackWhiteMap.put(info.getPkid(), zoneBlackWhiteForm);
            }
        }
        if (blackWhiteInfoList.size() + toadd.size() > 1000) {
            LegoCheckedException e = new LegoCheckedException(1000L);
            throw e;
        }
        if (dbBlackWhiteMap.size() > 0) {
            for (ZoneBlackWhiteForm zoneBlackWhiteForm : toadd) {
                int resultStr = this.checkIpAndMaskInBlackWhiteList(dbBlackWhiteMap, zoneBlackWhiteForm);
                if (0 == resultStr) continue;
                LegoCheckedException e = new LegoCheckedException((long)resultStr);
                e.setAccessoryResult((Object)zoneBlackWhiteForm);
                throw e;
            }
        }
        return true;
    }

    private int checkIpAndMaskInBlackWhiteList(List<BlackWhiteListInfo> blackWhiteListInfoList, ZoneBlackWhiteForm zoneBlackWhiteForm) {
        String[] srcIpRange = IPUtil.getSubnetRange((String)zoneBlackWhiteForm.getIpAddress(), (int)zoneBlackWhiteForm.getMask());
        for (BlackWhiteListInfo blackWhiteListInfo : blackWhiteListInfoList) {
            String[] destNetRange = IPUtil.getSubnetRange((String)blackWhiteListInfo.getIpAddress(), (int)blackWhiteListInfo.getMask());
            if (!IPUtil4Atic.isCrossIpRange((String[])destNetRange, (String[])srcIpRange)) continue;
            if (blackWhiteListInfo.getBlackWhiteType() == 1) {
                this.logger.error((Object)("blackWhiteListInfo " + blackWhiteListInfo.toString() + ";zoneBlackWhiteForm " + zoneBlackWhiteForm.toString()));
                return 1;
            }
            if (blackWhiteListInfo.getBlackWhiteType() != 2) continue;
            this.logger.error((Object)("blackWhiteListInfo " + blackWhiteListInfo.toString() + ";zoneBlackWhiteForm " + zoneBlackWhiteForm.toString()));
            return 2;
        }
        return 0;
    }

    private int checkCacheIpAndMaskInBlackWhiteList(List<ZoneBlackWhiteForm> blackWhiteListInfoList, ZoneBlackWhiteForm zoneBlackWhiteForm) {
        String[] srcIpRange = IPUtil.getSubnetRange((String)zoneBlackWhiteForm.getIpAddress(), (int)zoneBlackWhiteForm.getMask());
        for (ZoneBlackWhiteForm blackWhiteListInfo : blackWhiteListInfoList) {
            String[] destNetRange = IPUtil.getSubnetRange((String)blackWhiteListInfo.getIpAddress(), (int)blackWhiteListInfo.getMask());
            if (!IPUtil4Atic.isCrossIpRange((String[])destNetRange, (String[])srcIpRange)) continue;
            if (blackWhiteListInfo.getBlackWhiteType() == 1) {
                this.logger.error((Object)("blackWhiteListInfo " + blackWhiteListInfo.toString() + ";zoneBlackWhiteForm " + zoneBlackWhiteForm.toString()));
                return 1;
            }
            if (blackWhiteListInfo.getBlackWhiteType() != 2) continue;
            this.logger.error((Object)("blackWhiteListInfo " + blackWhiteListInfo.toString() + ";zoneBlackWhiteForm " + zoneBlackWhiteForm.toString()));
            return 2;
        }
        return 0;
    }

    private int checkIpAndMaskInBlackWhiteList(Map<Long, ZoneBlackWhiteForm> blackWhiteMapDB, ZoneBlackWhiteForm zoneBlackWhiteForm) {
        String[] srcIpRange = IPUtil.getSubnetRange((String)zoneBlackWhiteForm.getIpAddress(), (int)zoneBlackWhiteForm.getMask());
        for (Map.Entry<Long, ZoneBlackWhiteForm> blackWhiteListInfoEach : blackWhiteMapDB.entrySet()) {
            String[] destNetRange = IPUtil.getSubnetRange((String)blackWhiteListInfoEach.getValue().getIpAddress(), (int)blackWhiteListInfoEach.getValue().getMask());
            if (!IPUtil4Atic.isCrossIpRange((String[])destNetRange, (String[])srcIpRange)) continue;
            if (blackWhiteListInfoEach.getValue().getBlackWhiteType() == 1) {
                this.logger.error((Object)("blackWhiteListInfo " + blackWhiteListInfoEach.getValue().toString() + ";zoneBlackWhiteForm " + zoneBlackWhiteForm.toString()));
                return 1;
            }
            if (blackWhiteListInfoEach.getValue().getBlackWhiteType() != 2) continue;
            this.logger.error((Object)("blackWhiteListInfo " + blackWhiteListInfoEach.getValue().toString() + ";zoneBlackWhiteForm " + zoneBlackWhiteForm.toString()));
            return 2;
        }
        return 0;
    }

    @Override
    public BatchOperationResult batchDelZoneBlackWhiteList(List<BatchOperation> boList, List<ZoneBlackWhiteForm> delZoneBlackListFormCacheList, String zoneBlackWhitePageId) {
        if (null != delZoneBlackListFormCacheList) {
            for (ZoneBlackWhiteForm zoneBlackWhite : delZoneBlackListFormCacheList) {
                if (null != zoneBlackWhite.getBlackWhiteType() && zoneBlackWhite.getBlackWhiteType() == 1) {
                    this.logger.info((Object)("batchDelZoneBlackWhiteList 1 zoneBlackWhitePageId=" + zoneBlackWhitePageId + "zoneBlackWhite" + zoneBlackWhite.toString()));
                    BlackWhiteListCache.getInstance().insertPreDeleteBlackInfo(zoneBlackWhitePageId, zoneBlackWhite);
                    continue;
                }
                if (null == zoneBlackWhite.getBlackWhiteType() || zoneBlackWhite.getBlackWhiteType() != 2) continue;
                this.logger.info((Object)("batchDelZoneBlackWhiteList 2 zoneBlackWhitePageId=" + zoneBlackWhitePageId + "zoneBlackWhite" + zoneBlackWhite.toString()));
                BlackWhiteListCache.getInstance().insertPreDeleteWhiteInfo(zoneBlackWhitePageId, zoneBlackWhite);
            }
        }
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == boList || boList.isEmpty()) {
            return result;
        }
        for (BatchOperation bo : boList) {
            try {
                BlackWhiteListInfo blackWhiteListInfo = (BlackWhiteListInfo)this.blackWhiteListDao.query(Long.valueOf(bo.getTargetId()));
                if (null == blackWhiteListInfo) {
                    this.logger.error((Object)("delete black white list : " + this.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                    continue;
                }
                ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
                VsmUtil.getInstance().copyProperties(blackWhiteListInfo, zoneBlackWhiteForm);
                zoneBlackWhiteForm.setZoneName(bo.getTargetName());
                if (null != zoneBlackWhiteForm.getBlackWhiteType() && zoneBlackWhiteForm.getBlackWhiteType() == 1) {
                    this.logger.info((Object)("zoneBlackWhitePageId =" + zoneBlackWhitePageId + " insertPreDeleteBlackInfo = " + zoneBlackWhiteForm.toString()));
                    BlackWhiteListCache.getInstance().insertPreDeleteBlackInfo(zoneBlackWhitePageId, zoneBlackWhiteForm);
                } else if (null != zoneBlackWhiteForm.getBlackWhiteType() && zoneBlackWhiteForm.getBlackWhiteType() == 2) {
                    this.logger.info((Object)("zoneBlackWhitePageId =" + zoneBlackWhitePageId + " insertPreDeleteWhiteInfo = " + zoneBlackWhiteForm.toString()));
                    BlackWhiteListCache.getInstance().insertPreDeleteWhiteInfo(zoneBlackWhitePageId, zoneBlackWhiteForm);
                }
                String[] detailPara = new String[]{zoneBlackWhiteForm.getIpAddressAndMask()};
                if (blackWhiteListInfo.getBlackWhiteType() == 1) {
                    bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.blacklist.ip.oplog.del");
                } else if (blackWhiteListInfo.getBlackWhiteType() == 2) {
                    bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.whitelist.ip.oplog.del");
                }
                bo.setDetailParam(detailPara);
                this.logger.info((Object)("delete black white list : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
            }
            catch (Exception e) {
                ++fail;
                bo.setErrorCode(572218L);
                this.logger.error((Object)("delete black white list : " + this.getcleanedMessage(bo.getTargetName()) + " failed. " + e.getMessage()));
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("delete black white list result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public ZoneBlackWhiteForm findById(long pkid) {
        ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
        BlackWhiteListInfo blackWhiteListInfo = (BlackWhiteListInfo)this.blackWhiteListDao.query(Long.valueOf(pkid));
        if (null != blackWhiteListInfo) {
            VsmUtil.getInstance().copyProperties(blackWhiteListInfo, zoneBlackWhiteForm);
        }
        return zoneBlackWhiteForm;
    }

    @Override
    public void updateDeleteFlagById(long pkid) {
        BlackWhiteListInfo blackWhiteListInfo = (BlackWhiteListInfo)this.blackWhiteListDao.query(Long.valueOf(pkid));
        if (blackWhiteListInfo != null) {
            blackWhiteListInfo.setDeleteFlag(1);
            this.blackWhiteListDao.update(blackWhiteListInfo);
        }
    }

    @Override
    public void batchDelAllZoneBlackWhiteList(ZoneBlackWhiteForm zoneBlackWhiteForm) {
        Long zoneId = zoneBlackWhiteForm.getZoneId();
        Integer blackWhiteType = zoneBlackWhiteForm.getBlackWhiteType();
        this.blackWhiteListDao.deleteAllZoneBlackWhiteList(zoneId, blackWhiteType);
    }

    @Override
    public void batchDelAllZoneBlackWhiteList(ZoneBlackWhiteForm zoneBlackWhiteForm, String zoneBlackWhitePageId) {
        Long zoneId = zoneBlackWhiteForm.getZoneId();
        Integer blackWhiteType = zoneBlackWhiteForm.getBlackWhiteType();
        String zoneName = zoneBlackWhiteForm.getZoneName();
        if (null != blackWhiteType && blackWhiteType == 1) {
            List<BlackWhiteListInfo> list = this.blackWhiteListDao.getBlackWhiteListByZoneIdAndType(zoneId, blackWhiteType);
            this.logger.info((Object)("batchDelAllZoneBlackWhiteList 1 zoneBlackWhitePageId =" + zoneBlackWhitePageId + " batchDelAllZoneBlackList size = " + list.size()));
            for (BlackWhiteListInfo info : list) {
                if (null == info) continue;
                ZoneBlackWhiteForm form = new ZoneBlackWhiteForm();
                BeanUtils.copyProperties((Object)info, (Object)form);
                form.setZoneName(zoneName);
                BlackWhiteListCache.getInstance().insertPreDeleteBlackInfo(zoneBlackWhitePageId, form);
            }
            this.logger.info((Object)("batchDelAllZoneBlackWhiteList 1 zoneBlackWhitePageId =" + zoneBlackWhitePageId + " clearBlackAll"));
            BlackWhiteListCache.getInstance().clearBlackAll(zoneBlackWhitePageId);
        } else if (null != blackWhiteType && blackWhiteType == 2) {
            List<BlackWhiteListInfo> list = this.blackWhiteListDao.getBlackWhiteListByZoneIdAndType(zoneId, blackWhiteType);
            this.logger.info((Object)("batchDelAllZoneBlackWhiteList 2 zoneBlackWhitePageId =" + zoneBlackWhitePageId + " batchDelAllZoneWhiteList size = " + list.size()));
            for (BlackWhiteListInfo info : list) {
                if (null == info) continue;
                ZoneBlackWhiteForm form = new ZoneBlackWhiteForm();
                BeanUtils.copyProperties((Object)info, (Object)form);
                form.setZoneName(zoneName);
                BlackWhiteListCache.getInstance().insertPreDeleteWhiteInfo(zoneBlackWhitePageId, form);
            }
            this.logger.info((Object)("batchDelAllZoneBlackWhiteList 2 zoneBlackWhitePageId =" + zoneBlackWhitePageId + " clearWhiteAll"));
            BlackWhiteListCache.getInstance().clearWhiteAll(zoneBlackWhitePageId);
        }
    }

    @Override
    public List<ZoneBlackWhiteForm> queryDoBlackWhiteListByZoneIdAndDeviceId(Long zoneId, Long deviceId) {
        this.logger.info((Object)"query blackWhiteList by zoneid and deviceId and type start");
        ArrayList<ZoneBlackWhiteForm> blackWhiteForms = new ArrayList<ZoneBlackWhiteForm>();
        List<BlackWhiteStatusInfo> listInfos = this.blackWhiteStatusDao.getDoBlackWhiteByZoneIdAndDeviceIdAndType(zoneId, deviceId, 1);
        for (BlackWhiteStatusInfo bInfo : listInfos) {
            ZoneBlackWhiteForm form = new ZoneBlackWhiteForm();
            VsmUtil.getInstance().copyProperties(bInfo, form);
            blackWhiteForms.add(form);
        }
        return blackWhiteForms;
    }

    @Override
    public void batchSaveDoDeployStatus(List<ZoneBlackWhiteForm> blackWhiteFormList, String deployState) {
        for (ZoneBlackWhiteForm blackWhiteForm : blackWhiteFormList) {
            blackWhiteForm.setPkid(null);
            BlackWhiteStatusInfo statusInfo = this.blackWhiteStatusDao.queryBlackWhiteByForm(blackWhiteForm);
            if (null == statusInfo) {
                statusInfo = new BlackWhiteStatusInfo();
                VsmUtil.getInstance().copyProperties(blackWhiteForm, statusInfo);
            }
            statusInfo.setDeployState(deployState);
            this.blackWhiteStatusDao.createOrUpdate(statusInfo);
        }
    }

    @Override
    public void batchDeleteUnDeployStatus(List<ZoneBlackWhiteForm> blackWhiteFormList) {
        for (ZoneBlackWhiteForm blackWhiteForm : blackWhiteFormList) {
            this.blackWhiteStatusDao.deleteByblackWhiteForm(blackWhiteForm);
        }
    }

    @Override
    public void singleSaveDoDeployStatus(ZoneBlackWhiteForm blackWhiteForm, String deployState) {
        blackWhiteForm.setPkid(null);
        BlackWhiteStatusInfo statusInfo = this.blackWhiteStatusDao.queryBlackWhiteByForm(blackWhiteForm);
        if (null == statusInfo) {
            statusInfo = new BlackWhiteStatusInfo();
            VsmUtil.getInstance().copyProperties(blackWhiteForm, statusInfo);
        }
        statusInfo.setDeployState(deployState);
        this.blackWhiteStatusDao.createOrUpdate(statusInfo);
    }

    @Override
    public void singleDeleteUnDeployStatus(ZoneBlackWhiteForm blackWhiteForm) {
        this.blackWhiteStatusDao.deleteByblackWhiteForm(blackWhiteForm);
    }

    @Override
    public List<ZoneWhiteForm> queryDoWhiteListByZoneIdAndDeviceId(Long zoneId, Long deviceId) {
        this.logger.info((Object)"query blackWhiteList by zoneid and deviceId and type start");
        ArrayList<ZoneWhiteForm> blackWhiteForms = new ArrayList<ZoneWhiteForm>();
        List<BlackWhiteStatusInfo> listInfos = this.blackWhiteStatusDao.getDoBlackWhiteByZoneIdAndDeviceIdAndType(zoneId, deviceId, 2);
        for (BlackWhiteStatusInfo bInfo : listInfos) {
            ZoneWhiteForm form = new ZoneWhiteForm();
            VsmUtil.getInstance().copyProperties(bInfo, form);
            blackWhiteForms.add(form);
        }
        return blackWhiteForms;
    }

    @Override
    public List<ZoneDeviceForm> queryZoneDeviceByZoneName(String zoneName) {
        List<ZoneDeviceDeployStatusInfo> deployStatusInfos;
        ArrayList<ZoneDeviceForm> zoneDeviceForms = new ArrayList<ZoneDeviceForm>();
        ZoneInfo zoneInfo = this.zoneDao.getZoneByName(zoneName);
        if (null != zoneInfo && zoneInfo.getZoneType() != 1 && (deployStatusInfos = this.zoneDeviceDeployStatusDao.queryByZoneId2(zoneInfo.getZoneId())).size() > 0) {
            for (ZoneDeviceDeployStatusInfo info : deployStatusInfos) {
                this.checkDeviceType(info.getDeviceId());
                ZoneDeviceForm zoneDeviceForm = new ZoneDeviceForm();
                zoneDeviceForm.setZoneId(zoneInfo.getZoneId());
                zoneDeviceForm.setDeviceId(info.getDeviceId());
                zoneDeviceForms.add(zoneDeviceForm);
            }
        }
        return zoneDeviceForms;
    }

    @Override
    public BatchOperationResult importSaveBlackWhiteList(List<ZoneBlackWhiteForm> batchZoneBlackWhiteFormList, List<BatchOperation> frontOperationList, String zoneAndZoneDesc, Long zoneId) {
        long time = System.currentTimeMillis();
        this.setZoneStringAndZoneDesc(zoneAndZoneDesc);
        this.logger.info((Object)"entry importSaveNewBlackList()");
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<ZoneBlackWhiteForm> baseCheckDataListIpv4 = new ArrayList<ZoneBlackWhiteForm>();
        ArrayList<ZoneBlackWhiteForm> baseCheckDataListIpv6 = new ArrayList<ZoneBlackWhiteForm>();
        this.importBaseCheck(batchZoneBlackWhiteFormList, frontOperationList, zoneId, baseCheckDataListIpv4, baseCheckDataListIpv6);
        ArrayList<ZoneBlackWhiteForm> selfCheckDataListIpv4 = new ArrayList<ZoneBlackWhiteForm>();
        ArrayList<ZoneBlackWhiteForm> selfCheckDataListIpv6 = new ArrayList<ZoneBlackWhiteForm>();
        this.selfCheckIpV4(selfCheckDataListIpv4, baseCheckDataListIpv4, frontOperationList);
        this.selfCheckIpV6(selfCheckDataListIpv6, baseCheckDataListIpv6, frontOperationList);
        List<BlackWhiteListInfo> dbListIp = this.blackWhiteListDao.getBlackWhiteListByZoneId(zoneId);
        ArrayList<ZoneBlackWhiteForm> dbListIpV4 = new ArrayList<ZoneBlackWhiteForm>();
        ArrayList<ZoneBlackWhiteForm> dbListIpV6 = new ArrayList<ZoneBlackWhiteForm>();
        this.ipBlackTypeGroup(dbListIp, dbListIpV4, dbListIpV6);
        ArrayList<ZoneBlackWhiteForm> errorIpV4List = new ArrayList<ZoneBlackWhiteForm>();
        ArrayList<ZoneBlackWhiteForm> errorIpV6List = new ArrayList<ZoneBlackWhiteForm>();
        this.bListIpV4Compar(dbListIpV4, selfCheckDataListIpv4, errorIpV4List, frontOperationList);
        ArrayList<ZoneBlackWhiteForm> needRemoveIpV4List = new ArrayList<ZoneBlackWhiteForm>();
        if (!selfCheckDataListIpv4.isEmpty()) {
            for (ZoneBlackWhiteForm zoneBlackWhiteForm : selfCheckDataListIpv4) {
                for (ZoneBlackWhiteForm errorZoneForm : errorIpV4List) {
                    if (null == zoneBlackWhiteForm || null == errorZoneForm || !zoneBlackWhiteForm.getStartIp().equals(errorZoneForm.getStartIp())) continue;
                    needRemoveIpV4List.add(zoneBlackWhiteForm);
                }
            }
            if (!needRemoveIpV4List.isEmpty()) {
                selfCheckDataListIpv4.removeAll(needRemoveIpV4List);
            }
        }
        this.bListIpV6Compar(dbListIpV6, selfCheckDataListIpv6, errorIpV6List, frontOperationList);
        ArrayList<ZoneBlackWhiteForm> needRemoveIpV6List = new ArrayList<ZoneBlackWhiteForm>();
        if (!selfCheckDataListIpv6.isEmpty()) {
            for (ZoneBlackWhiteForm zoneForm : selfCheckDataListIpv6) {
                for (ZoneBlackWhiteForm errorZoneForm : errorIpV6List) {
                    if (null == zoneForm || null == errorZoneForm || !zoneForm.getStartIp().equals(errorZoneForm.getStartIp())) continue;
                    needRemoveIpV6List.add(zoneForm);
                }
            }
            if (!needRemoveIpV6List.isEmpty()) {
                selfCheckDataListIpv6.removeAll(needRemoveIpV6List);
            }
        }
        int n = dbListIp.size();
        if (!selfCheckDataListIpv4.isEmpty()) {
            this.saveImportData(selfCheckDataListIpv4, frontOperationList, n);
        }
        if (!selfCheckDataListIpv6.isEmpty()) {
            this.saveImportData(selfCheckDataListIpv6, frontOperationList, n);
        }
        ArrayList<BatchOperation> batList = new ArrayList<BatchOperation>();
        for (BatchOperation batchOperation : frontOperationList) {
            batList.add(batchOperation);
        }
        result.setResult(batList);
        result.setFailCount(batList.size());
        result.setTotalCount(batchZoneBlackWhiteFormList.size());
        result.setSucceedCount(batchZoneBlackWhiteFormList.size() - batList.size());
        this.logger.info((Object)("import save black white list  time: " + (System.currentTimeMillis() - time) / 1000L));
        return result;
    }

    private void importBaseCheck(List<ZoneBlackWhiteForm> batchZoneBlackWhiteFormList, List<BatchOperation> frontOperationList, Long zoneId, List<ZoneBlackWhiteForm> baseCheckDataListIpv4, List<ZoneBlackWhiteForm> baseCheckDataListIpv6) {
        for (ZoneBlackWhiteForm zoneBlackWhiteForm : batchZoneBlackWhiteFormList) {
            String[] subNetRange;
            BatchOperation operation;
            int blackWhiteType = zoneBlackWhiteForm.getBlackWhiteType();
            String ipAddress = zoneBlackWhiteForm.getIpAddress();
            Integer intMask = zoneBlackWhiteForm.getMask();
            if (!IPUtil.isIpv4((String)ipAddress) && !IPUtil.isIpv6((String)ipAddress)) {
                operation = new BatchOperation();
                if (1 == blackWhiteType) {
                    operation.setErrorCode(632008L);
                } else if (2 == blackWhiteType) {
                    operation.setErrorCode(632009L);
                }
                operation.setTargetName(this.zoneStringAndZoneDesc + "/" + zoneBlackWhiteForm.getIpAddressAndMask());
                frontOperationList.add(operation);
                this.logger.error((Object)("batch add import blacklist and whitelist data ipformat error:" + zoneBlackWhiteForm.getIpAddressAndMask()));
                continue;
            }
            if (IPUtil.isIpv4((String)ipAddress)) {
                if (intMask < 8 || intMask > 128) {
                    operation = new BatchOperation();
                    if (1 == blackWhiteType) {
                        operation.setErrorCode(632006L);
                    } else if (2 == blackWhiteType) {
                        operation.setErrorCode(632007L);
                    }
                    operation.setTargetName(this.zoneStringAndZoneDesc + "--" + zoneBlackWhiteForm.getIpAddressAndMask());
                    frontOperationList.add(operation);
                    continue;
                }
                zoneBlackWhiteForm.setZoneId(zoneId);
                subNetRange = IPUtil.getSubnetRange((String)zoneBlackWhiteForm.getIpAddress(), (int)zoneBlackWhiteForm.getMask());
                zoneBlackWhiteForm.setStartIp(subNetRange[0]);
                zoneBlackWhiteForm.setEndIp(subNetRange[1]);
                zoneBlackWhiteForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)subNetRange[0]));
                zoneBlackWhiteForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)subNetRange[1]));
                baseCheckDataListIpv4.add(zoneBlackWhiteForm);
                continue;
            }
            if (!IPUtil.isIpv6((String)ipAddress)) continue;
            if (intMask < 8 || intMask > 128) {
                operation = new BatchOperation();
                if (1 == blackWhiteType) {
                    operation.setErrorCode(632006L);
                } else if (2 == blackWhiteType) {
                    operation.setErrorCode(632007L);
                }
                operation.setTargetName(this.zoneStringAndZoneDesc + "--" + zoneBlackWhiteForm.getIpAddressAndMask());
                frontOperationList.add(operation);
                continue;
            }
            zoneBlackWhiteForm.setZoneId(zoneId);
            subNetRange = IPUtil.getSubnetRange((String)zoneBlackWhiteForm.getIpAddress(), (int)zoneBlackWhiteForm.getMask());
            zoneBlackWhiteForm.setStartIp(subNetRange[0]);
            zoneBlackWhiteForm.setEndIp(subNetRange[1]);
            zoneBlackWhiteForm.setStartIpLong(1L);
            zoneBlackWhiteForm.setEndIpLong(1L);
            zoneBlackWhiteForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)subNetRange[0]));
            zoneBlackWhiteForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)subNetRange[1]));
            baseCheckDataListIpv6.add(zoneBlackWhiteForm);
        }
    }

    private void selfCheckIpV4(List<ZoneBlackWhiteForm> selfCheckDataListIpv4, List<ZoneBlackWhiteForm> baseCheckDataListIpv4, List<BatchOperation> frontOperationList) {
        if (null != baseCheckDataListIpv4 && !baseCheckDataListIpv4.isEmpty() && baseCheckDataListIpv4.size() == 1) {
            selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(0));
        }
        if (null != baseCheckDataListIpv4 && !baseCheckDataListIpv4.isEmpty() && baseCheckDataListIpv4.size() != 1) {
            Collections.sort(baseCheckDataListIpv4);
            for (int i = 0; i < baseCheckDataListIpv4.size(); ++i) {
                if (i == 0) {
                    selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(0));
                    continue;
                }
                if (baseCheckDataListIpv4.get(i).getStartIpLong() <= selfCheckDataListIpv4.get(selfCheckDataListIpv4.size() - 1).getEndIpLong()) {
                    int blackWhiteType = baseCheckDataListIpv4.get(i).getBlackWhiteType();
                    String targetName = this.zoneStringAndZoneDesc + "/" + baseCheckDataListIpv4.get(i).getIpAddressAndMask();
                    BatchOperation operation = new BatchOperation();
                    if (1 == blackWhiteType) {
                        operation.setErrorCode(632004L);
                    } else if (2 == blackWhiteType) {
                        operation.setErrorCode(632005L);
                    }
                    operation.setTargetName(targetName);
                    frontOperationList.add(operation);
                    continue;
                }
                selfCheckDataListIpv4.add(baseCheckDataListIpv4.get(i));
            }
        }
    }

    private void selfCheckIpV6(List<ZoneBlackWhiteForm> selfCheckDataListIpv6, List<ZoneBlackWhiteForm> baseCheckDataListIpv6, List<BatchOperation> frontOperationList) {
        if (null != baseCheckDataListIpv6 && !baseCheckDataListIpv6.isEmpty() && baseCheckDataListIpv6.size() == 1) {
            selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(0));
        }
        if (null != baseCheckDataListIpv6 && !baseCheckDataListIpv6.isEmpty() && baseCheckDataListIpv6.size() != 1) {
            Collections.sort(baseCheckDataListIpv6);
            for (int i = 0; i < baseCheckDataListIpv6.size(); ++i) {
                if (i == 0) {
                    selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(0));
                    continue;
                }
                if (IPUtil.compareTo((String)baseCheckDataListIpv6.get(i).getStartIp(), (String)selfCheckDataListIpv6.get(selfCheckDataListIpv6.size() - 1).getEndIp()) != 1) {
                    int blackWhiteType = baseCheckDataListIpv6.get(i).getBlackWhiteType();
                    String targetName = this.zoneStringAndZoneDesc + "/" + baseCheckDataListIpv6.get(i).getIpAddressAndMask();
                    BatchOperation operation = new BatchOperation();
                    if (1 == blackWhiteType) {
                        operation.setErrorCode(632004L);
                    } else if (2 == blackWhiteType) {
                        operation.setErrorCode(632005L);
                    }
                    operation.setTargetName(targetName);
                    frontOperationList.add(operation);
                    continue;
                }
                selfCheckDataListIpv6.add(baseCheckDataListIpv6.get(i));
            }
        }
    }

    private void ipBlackTypeGroup(List<BlackWhiteListInfo> list, List<ZoneBlackWhiteForm> listIpV4, List<ZoneBlackWhiteForm> listIpV6) {
        if (null != list && !list.isEmpty()) {
            for (BlackWhiteListInfo blackWhiteListInfo : list) {
                String[] subNetRange;
                ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
                VsmUtil.getInstance().copyProperties(blackWhiteListInfo, zoneBlackWhiteForm);
                String ipAddress = zoneBlackWhiteForm.getIpAddress();
                if (IPUtil.isIpv4((String)ipAddress)) {
                    subNetRange = IPUtil.getSubnetRange((String)zoneBlackWhiteForm.getIpAddress(), (int)zoneBlackWhiteForm.getMask());
                    zoneBlackWhiteForm.setStartIp(subNetRange[0]);
                    zoneBlackWhiteForm.setEndIp(subNetRange[1]);
                    zoneBlackWhiteForm.setStartIpLong(AticUtil.convertIpFromStr2Long((String)subNetRange[0]));
                    zoneBlackWhiteForm.setEndIpLong(AticUtil.convertIpFromStr2Long((String)subNetRange[1]));
                    listIpV4.add(zoneBlackWhiteForm);
                    continue;
                }
                if (!IPUtil.isIpv6((String)ipAddress)) continue;
                subNetRange = IPUtil.getSubnetRange((String)zoneBlackWhiteForm.getIpAddress(), (int)zoneBlackWhiteForm.getMask());
                zoneBlackWhiteForm.setStartIp(subNetRange[0]);
                zoneBlackWhiteForm.setEndIp(subNetRange[1]);
                zoneBlackWhiteForm.setStartIpLong(1L);
                zoneBlackWhiteForm.setEndIpLong(1L);
                zoneBlackWhiteForm.setStartIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)subNetRange[0]));
                zoneBlackWhiteForm.setEndIpV6AllZero(IPUtil4Atic.convert2CompleteIpV6((String)subNetRange[1]));
                listIpV6.add(zoneBlackWhiteForm);
            }
        }
    }

    private void bListIpV4Compar(List<ZoneBlackWhiteForm> bListIpV4, List<ZoneBlackWhiteForm> selfCheckDataListIpv4, List<ZoneBlackWhiteForm> errorIpV4List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != bListIpV4 && !bListIpV4.isEmpty()) {
            Collections.sort(bListIpV4);
            block0: for (int i = 0; i < selfCheckDataListIpv4.size(); ++i) {
                for (int j = confilctNumber; j < bListIpV4.size(); ++j) {
                    if (selfCheckDataListIpv4.get(i).getStartIpLong() > bListIpV4.get(j).getEndIpLong() || bListIpV4.get(j).getStartIpLong() > selfCheckDataListIpv4.get(i).getEndIpLong() || bListIpV4.get(j).getEndIpLong() < selfCheckDataListIpv4.get(i).getStartIpLong()) continue;
                    errorIpV4List.add(selfCheckDataListIpv4.get(i));
                    confilctNumber = j;
                    continue block0;
                }
            }
            for (ZoneBlackWhiteForm zoneForm : errorIpV4List) {
                int blackWhiteType = zoneForm.getBlackWhiteType();
                String targetName = this.zoneStringAndZoneDesc + "--" + zoneForm.getIpAddressAndMask();
                BatchOperation operation = new BatchOperation();
                if (1 == blackWhiteType) {
                    operation.setErrorCode(632004L);
                } else if (2 == blackWhiteType) {
                    operation.setErrorCode(632005L);
                }
                operation.setTargetName(targetName);
                frontOperationList.add(operation);
            }
        }
    }

    private void bListIpV6Compar(List<ZoneBlackWhiteForm> bListIpV6, List<ZoneBlackWhiteForm> selfCheckDataListIpv6, List<ZoneBlackWhiteForm> errorIpV6List, List<BatchOperation> frontOperationList) {
        int confilctNumber = 0;
        if (null != bListIpV6 && !bListIpV6.isEmpty()) {
            Collections.sort(bListIpV6);
            block0: for (int i = 0; i < selfCheckDataListIpv6.size(); ++i) {
                for (int j = confilctNumber; j < bListIpV6.size(); ++j) {
                    if (IPUtil.compareTo((String)selfCheckDataListIpv6.get(i).getStartIp(), (String)bListIpV6.get(j).getEndIp()) == 1 || IPUtil.compareTo((String)bListIpV6.get(j).getStartIp(), (String)selfCheckDataListIpv6.get(i).getEndIp()) == 1 || IPUtil.compareTo((String)bListIpV6.get(j).getEndIp(), (String)selfCheckDataListIpv6.get(i).getStartIp()) == -1) continue;
                    errorIpV6List.add(selfCheckDataListIpv6.get(i));
                    confilctNumber = j;
                    continue block0;
                }
            }
            for (ZoneBlackWhiteForm zoneForm : errorIpV6List) {
                int blackWhiteType = zoneForm.getBlackWhiteType();
                String targetName = this.zoneStringAndZoneDesc + "--" + zoneForm.getIpAddressAndMask();
                BatchOperation operation = new BatchOperation();
                if (1 == blackWhiteType) {
                    operation.setErrorCode(632004L);
                } else if (2 == blackWhiteType) {
                    operation.setErrorCode(632005L);
                }
                operation.setTargetName(targetName);
                frontOperationList.add(operation);
            }
        }
    }

    private void saveImportData(List<ZoneBlackWhiteForm> importZoneBlackWhiteFormList, List<BatchOperation> frontOperationList, int dbSize) {
        int importSize = importZoneBlackWhiteFormList.size();
        int maxSize = dbSize + importSize;
        if (maxSize < 1000) {
            for (ZoneBlackWhiteForm zoneForm : importZoneBlackWhiteFormList) {
                BlackWhiteListInfo blackWhiteListInfo = new BlackWhiteListInfo();
                VsmUtil.getInstance().copyProperties(zoneForm, blackWhiteListInfo);
                this.logger.info((Object)("save zone blacklist or whitelist :" + blackWhiteListInfo.toString()));
                this.blackWhiteListDao.save(blackWhiteListInfo);
            }
        } else if (dbSize >= 1000) {
            for (ZoneBlackWhiteForm zoneForm : importZoneBlackWhiteFormList) {
                String targetName = this.zoneStringAndZoneDesc + "--" + zoneForm.getIpAddressAndMask();
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(631080L);
                operation.setTargetName(targetName);
                frontOperationList.add(operation);
            }
        } else {
            int insertSize = 1000 - dbSize;
            for (int i = 0; i < importSize; ++i) {
                ZoneBlackWhiteForm zoneForm = importZoneBlackWhiteFormList.get(i);
                if (i < insertSize) {
                    BlackWhiteListInfo blackWhiteListInfo = new BlackWhiteListInfo();
                    VsmUtil.getInstance().copyProperties(zoneForm, blackWhiteListInfo);
                    this.logger.info((Object)("save zone blacklist or whitelist :" + blackWhiteListInfo.toString()));
                    this.blackWhiteListDao.save(blackWhiteListInfo);
                    continue;
                }
                String targetName = this.zoneStringAndZoneDesc + "--" + zoneForm.getIpAddressAndMask();
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(631080L);
                operation.setTargetName(targetName);
                frontOperationList.add(operation);
            }
        }
    }

    @Override
    public void saveBlackWhiteInfo(ZonePolicyApplyForm form) {
        List<ZoneBlackWhiteForm> toAddForm;
        List<ZoneBlackWhiteForm> toDeleteForm = form.getToDeleteBlackWhiteList();
        if (null != toDeleteForm && toDeleteForm.size() > 0) {
            this.blackWhiteListDao.deleteByPkids(toDeleteForm);
        }
        if (null != (toAddForm = form.getToAddBlackWhiteList())) {
            for (ZoneBlackWhiteForm add : toAddForm) {
                if (null == add) continue;
                BlackWhiteListInfo blackWhiteListInfo = new BlackWhiteListInfo();
                BeanUtils.copyProperties((Object)add, (Object)blackWhiteListInfo);
                BlackWhiteListInfo blackWhiteListInfoIsExist = this.blackWhiteListDao.queryBlackWhiteByForm(add);
                if (blackWhiteListInfoIsExist != null) {
                    blackWhiteListInfoIsExist.setDeleteFlag(0);
                    this.blackWhiteListDao.update(blackWhiteListInfoIsExist);
                    continue;
                }
                this.blackWhiteListDao.save(blackWhiteListInfo);
            }
        }
    }

    @Override
    public int getTotalBlackWhiteListsByZoneId(long zoneId) {
        return this.blackWhiteListDao.getBlackWhiteListNumberByZoneId(zoneId);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public BlackWhiteListDao getBlackWhiteListDao() {
        return this.blackWhiteListDao;
    }

    public void setBlackWhiteListDao(BlackWhiteListDao blackWhiteListDao) {
        this.blackWhiteListDao = blackWhiteListDao;
    }

    public BlackWhiteStatusDao getBlackWhiteStatusDao() {
        return this.blackWhiteStatusDao;
    }

    public void setBlackWhiteStatusDao(BlackWhiteStatusDao blackWhiteStatusDao) {
        this.blackWhiteStatusDao = blackWhiteStatusDao;
    }

    public ZoneDao getZoneDao() {
        return this.zoneDao;
    }

    public void setZoneDao(ZoneDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public String getZoneStringAndZoneDesc() {
        return this.zoneStringAndZoneDesc;
    }

    public void setZoneStringAndZoneDesc(String zoneStringAndZoneDesc) {
        this.zoneStringAndZoneDesc = zoneStringAndZoneDesc;
    }
}

